/*
	This file keeps all the functions relevant to the stats structure
*/

#include "rpggame.h"

void stats::calcattrs()
{
	loopi(RESIST_MAX)
	{
		switch(i)
		{
			case RESIST_FIRE:
				resistance[i] = agility/4.0f + charisma / 6.0f + intelligence / 6.0f;
				break;
			case RESIST_WATER:
				resistance[i] = endurance/4.0f + charisma / 6.0f + intelligence / 6.0f;
				break;
			case RESIST_AIR:
				resistance[i] = strength/8.0f  + endurance/8.0f + charisma / 6.0f + intelligence / 6.0f;
				break;
			case RESIST_EARTH:
				resistance[i] = strength/4.0f + charisma / 6.0f + intelligence / 6.0f;
				break;
			case RESIST_MAGIC:
				resistance[i] = charisma / 3.0f + intelligence / 3.0f;
				break;
			case RESIST_SLASH:
				resistance[i] = strength/2;
				break;
			case RESIST_BLUNT:
				resistance[i] = endurance/2;
				break;
			case RESIST_PIERCE:
				resistance[i] = agility/2;
				break;
			default: //ie, unknown resistance
				resistance[i] = 10;
				break;
		}
		resistance[i] += luck/5;
	}
	maxhealth = endurance * 4 + strength * 2 + (10 + endurance + strength / 2.0f) * levels[LEVEL_OVERALL].level;
	healthregen = endurance / 100.0f + strength / 200.0f;

	maxmana = intelligence * 4 + charisma * 2 + (10 + intelligence + charisma / 2.0f) * levels[LEVEL_OVERALL].level;
	manaregen = intelligence / 12.5f + charisma / 25.0f;

	maxweight = (strength * strength) / 9 + endurance;

	movespeed = 30 + agility * .9f; //ends at 120
	jumpvel =  100 + agility; //ends at 200
}

void stats::limits()
{
	#define limit(n, mn, mx) n = min(mx, max(n, mn))
	#define limitdn(n, mn) n = max(n, mn)
	limit(strength, 5, 100);
	limit(intelligence, 5, 100);
	limit(charisma, 5, 100);
	limit(endurance, 5, 100);
	limit(agility, 5, 100);
	limit(luck, 5, 100);
	limit(movespeed, 20, 150);
	limit(jumpvel, 66, 250);
	loopi(RESIST_MAX) limit(resistance[i], 0, 80);

	limitdn(healthregen, (float) 0.01);
	limitdn(manaregen, (float) 0.01);
	limitdn(maxhealth, 1);
	limitdn(maxmana, 1);
	limitdn(maxweight, 20);
	#undef limit
	#undef limitdn
}

#define test(test)\
	if(strength test s.strength || intelligence test s.intelligence || endurance test s.endurance || \
		agility test s.agility || luck test s.luck || maxhealth test s.maxhealth || healthregen test s.healthregen || \
		maxmana test s.maxmana || manaregen test s.manaregen || maxweight test s.maxweight || movespeed test s.movespeed \
	) return false; \
	\
	loopi(LEVEL_MAX) if(levels[i].level test s.levels[i].level) return false; \
	loopi(RESIST_MAX) if (resistance[i] test s.resistance[i]) return false;

bool stats::operator>= (const stats &s)
{
	test(<)

	return true;
}
bool stats::operator< (const stats &s)
{
	test(>=)

	return true;
}
bool stats::operator== (const stats &s)
{
	test(!=)

	return true;
}
bool stats::operator!= (const stats &s)
{
	return (!(*this == s));
}

#undef test

stats &stats::add(int n)
{
	strength += n, intelligence += n, charisma += n, endurance += n, agility += n, luck += n;
	loopi(LEVEL_MAX) levels[i].level += n;
	loopi(RESIST_MAX) resistance[i] += n;
	return *this;
}
stats &stats::add(const stats &s)
{
	strength += s.strength, intelligence += s.intelligence, charisma += s.charisma, endurance += s.endurance, agility += s.agility, luck += s.luck;
	loopi(LEVEL_MAX) levels[i].level += s.levels[i].level;
	loopi(RESIST_MAX) resistance[i] += s.resistance[i];
	return *this;
}
stats &stats::addall(int n)
{
	add(n);
	maxhealth += n, healthregen += n, maxmana += n, manaregen += n, maxweight += n, movespeed += n, jumpvel += n;
	return *this;
}
stats &stats::addall(const stats &s)
{
	add(s);
	maxhealth += s.maxhealth, healthregen += s.healthregen, maxmana += s.maxmana, manaregen += s.manaregen, maxweight += s.maxweight, movespeed += s.movespeed, jumpvel += s.jumpvel;
	return *this;
}
stats &stats::sub(int n)
{
	strength -= n, intelligence -= n, charisma -= n, endurance -= n, agility -= n, luck -= n;
	loopi(LEVEL_MAX) levels[i].level -= n;
	loopi(RESIST_MAX) resistance[i] -= n;
	return *this;
}
stats &stats::sub(const stats &s)
{
	strength -= s.strength, intelligence -= s.intelligence, charisma -= s.charisma, endurance -= s.endurance, agility -= s.agility, luck -= s.luck;
	loopi(LEVEL_MAX) levels[i].level -= s.levels[i].level;
	loopi(RESIST_MAX) resistance[i] -= s.resistance[i];
	return *this;
}
stats &stats::suball(int n)
{
	sub(n);
	maxhealth -= n, healthregen -= n, maxmana -= n, manaregen -= n, maxweight -= n, movespeed -= n, jumpvel -= n;
	return *this;
}
stats &stats::suball(const stats &s)
{
	sub(s);
	maxhealth -= s.maxhealth, healthregen -= s.healthregen, maxmana -= s.maxmana, manaregen -= s.manaregen, maxweight -= s.maxweight, movespeed -= s.movespeed, jumpvel -= s.jumpvel;
	return *this;
}
stats &stats::div(float n)
{
	strength /= n, intelligence /= n, charisma /= n, endurance /= n, agility /= n, luck /= n;
	loopi(LEVEL_MAX) levels[i].level /= n;
	loopi(RESIST_MAX) resistance[i] /= n;
	return *this;
}
stats &stats::divall(float n)
{
	div(n);
	maxhealth /= n, healthregen /= n, maxmana /= n, manaregen /= n, maxweight /= n, movespeed /= n, jumpvel /= n;
	return *this;
}
stats &stats::mul(float n)
{
	strength *= n, intelligence *= n, charisma *= n, endurance *= n, agility *= n, luck *= n;
	loopi(LEVEL_MAX) levels[i].level *= n;
	loopi(RESIST_MAX) resistance[i] *= n;
	return *this;
}
stats &stats::mulall(float n)
{
	mul(n);
	maxhealth *= n, healthregen *= n, maxmana *= n, manaregen *= n, maxweight *= n, movespeed *= n, jumpvel *= n;
	return *this;
}
