
#include "err.h"
#include "csm.h"
#include "idn.h"

#define _EMPTYIDENT
#ifndef _EMPTYIDENT
#undef _EMPTYIDENT

/* identifier code is set on instantiation: */
#include "termcode.h"
#define _IDENTCODE 

#else
#undef _EMPTYIDENT

/* identifier code is not set on instantiation, use default: */
#define _IDENTCODE 0

#endif

#include "MakeName.h"

#include <string.h>

static int      num = 0;

#if defined(__STDC__) || defined(__cplusplus)
int GenerateName (char *prefix)
#else
int GenerateName (prefix) char *prefix;
#endif
{
    int newid, stored;
    int idtoken;
    char numstring[32];

    stored = numstr; /* save number of strings stored so far */
    do {
        num++;
        sprintf (numstring, "%d", num);
        obstack_strgrow(Csm_obstk, prefix);
        CsmStrPtr = (char *)obstack_strcpy(Csm_obstk, numstring);
        idtoken = _IDENTCODE;
        mkidn (CsmStrPtr, strlen (CsmStrPtr), &idtoken, &newid);
    } while (stored == numstr);

    return (newid);

}/*GenerateName*/

#if defined(__STDC) || defined(__cplusplus)
int MakeName (char *str)
#else
int MakeName (str) char *str;
#endif
{
    int newid, idtoken = _IDENTCODE;
    if (str)
    {
        mkidn (str, strlen (str), &idtoken, &newid);
        return (newid);
    }
    else
        return 0;
}/* MakeName */

#if defined(__STDC) || defined(__cplusplus)
int IdnNumb (int id, int num)
#else
int IdnNumb (id, num) int id, num;
#endif
{
    int newid, idtoken = _IDENTCODE;
    char numstring[32];

    sprintf (numstring, "%d", num);
    obstack_strgrow(Csm_obstk, StringTable(id));
    CsmStrPtr = (char *)obstack_strcpy(Csm_obstk, numstring);
    mkidn (CsmStrPtr, strlen (CsmStrPtr), &idtoken, &newid);
    return (newid);
}/* IdnNumb */

#if defined(__STDC) || defined(__cplusplus)
int PreIdnPost (char *pre, int id, char *post)
#else
int PreIdnPost (pre, id, post) char *pre, *post; int id;
#endif
{
    int newid, lg, idtoken = _IDENTCODE;

    obstack_strgrow(Csm_obstk, pre);
    obstack_strgrow(Csm_obstk, StringTable (id));
    CsmStrPtr = (char *)obstack_strcpy(Csm_obstk, post);
    mkidn (CsmStrPtr, strlen (CsmStrPtr), &idtoken, &newid);
    return (newid);
}/* PreIdnPost */
