#ifndef NORESTORE
#include "obsave.h"
#endif
#include "pdl_gen.h"

#ifdef MONITOR
#include "pdl_dapto.h"
#endif

#define PRESENT find(key, _property, (Entry *)&_Item, 0)
#define VALUE (_Item->PropVal)

#define TYPE int

#define ACCESS find(key, _property, (Entry *)&_Item, sizeof(struct intElt))

typedef struct intElt {
	Entry next;
	int selector;
	TYPE PropVal;
} *intProperty;

#if defined(__STDC__) || defined(__cplusplus)
TYPE
Getint (int _property, DefTableKey key, TYPE deflt)
#else
TYPE
Getint (_property, key, deflt)
int _property;
DefTableKey key;
TYPE deflt;
#endif
{  intProperty _Item;
{ if (key == NoKey) return deflt;
  if (PRESENT) return VALUE;
  else return deflt;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
Setint (int _property, DefTableKey key, TYPE _add, TYPE _replace)
#else
void
Setint (_property, key, _add, _replace)
int _property;
DefTableKey key;
TYPE _add;
TYPE _replace;
#endif
{  intProperty _Item;
{ if (key == NoKey) return;
  if (ACCESS) VALUE = _replace;
  else VALUE = _add;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
Resetint (int _property, DefTableKey key, TYPE _val)
#else
void
Resetint (_property, key, _val)
int _property;
DefTableKey key;
TYPE _val;
#endif
{  intProperty _Item;
{ if (key == NoKey) return;
  ACCESS; VALUE = _val;
}
}

#undef ACCESS
#undef TYPE
#define TYPE DefTableKey

#define ACCESS find(key, _property, (Entry *)&_Item, sizeof(struct DefTableKeyElt))

typedef struct DefTableKeyElt {
	Entry next;
	int selector;
	TYPE PropVal;
} *DefTableKeyProperty;

#if defined(__STDC__) || defined(__cplusplus)
TYPE
GetDefTableKey (int _property, DefTableKey key, TYPE deflt)
#else
TYPE
GetDefTableKey (_property, key, deflt)
int _property;
DefTableKey key;
TYPE deflt;
#endif
{  DefTableKeyProperty _Item;
{ if (key == NoKey) return deflt;
  if (PRESENT) return VALUE;
  else return deflt;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
SetDefTableKey (int _property, DefTableKey key, TYPE _add, TYPE _replace)
#else
void
SetDefTableKey (_property, key, _add, _replace)
int _property;
DefTableKey key;
TYPE _add;
TYPE _replace;
#endif
{  DefTableKeyProperty _Item;
{ if (key == NoKey) return;
  if (ACCESS) VALUE = _replace;
  else VALUE = _add;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
ResetDefTableKey (int _property, DefTableKey key, TYPE _val)
#else
void
ResetDefTableKey (_property, key, _val)
int _property;
DefTableKey key;
TYPE _val;
#endif
{  DefTableKeyProperty _Item;
{ if (key == NoKey) return;
  ACCESS; VALUE = _val;
}
}

#undef ACCESS
#undef TYPE
#define TYPE Environment

#define ACCESS find(key, _property, (Entry *)&_Item, sizeof(struct EnvironmentElt))

typedef struct EnvironmentElt {
	Entry next;
	int selector;
	TYPE PropVal;
} *EnvironmentProperty;

#if defined(__STDC__) || defined(__cplusplus)
TYPE
GetEnvironment (int _property, DefTableKey key, TYPE deflt)
#else
TYPE
GetEnvironment (_property, key, deflt)
int _property;
DefTableKey key;
TYPE deflt;
#endif
{  EnvironmentProperty _Item;
{ if (key == NoKey) return deflt;
  if (PRESENT) return VALUE;
  else return deflt;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
SetEnvironment (int _property, DefTableKey key, TYPE _add, TYPE _replace)
#else
void
SetEnvironment (_property, key, _add, _replace)
int _property;
DefTableKey key;
TYPE _add;
TYPE _replace;
#endif
{  EnvironmentProperty _Item;
{ if (key == NoKey) return;
  if (ACCESS) VALUE = _replace;
  else VALUE = _add;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
ResetEnvironment (int _property, DefTableKey key, TYPE _val)
#else
void
ResetEnvironment (_property, key, _val)
int _property;
DefTableKey key;
TYPE _val;
#endif
{  EnvironmentProperty _Item;
{ if (key == NoKey) return;
  ACCESS; VALUE = _val;
}
}

#undef ACCESS
#undef TYPE
#define TYPE SEQAttrrule

#define ACCESS find(key, _property, (Entry *)&_Item, sizeof(struct SEQAttrruleElt))

typedef struct SEQAttrruleElt {
	Entry next;
	int selector;
	TYPE PropVal;
} *SEQAttrruleProperty;

#if defined(__STDC__) || defined(__cplusplus)
TYPE
GetSEQAttrrule (int _property, DefTableKey key, TYPE deflt)
#else
TYPE
GetSEQAttrrule (_property, key, deflt)
int _property;
DefTableKey key;
TYPE deflt;
#endif
{  SEQAttrruleProperty _Item;
{ if (key == NoKey) return deflt;
  if (PRESENT) return VALUE;
  else return deflt;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
SetSEQAttrrule (int _property, DefTableKey key, TYPE _add, TYPE _replace)
#else
void
SetSEQAttrrule (_property, key, _add, _replace)
int _property;
DefTableKey key;
TYPE _add;
TYPE _replace;
#endif
{  SEQAttrruleProperty _Item;
{ if (key == NoKey) return;
  if (ACCESS) VALUE = _replace;
  else VALUE = _add;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
ResetSEQAttrrule (int _property, DefTableKey key, TYPE _val)
#else
void
ResetSEQAttrrule (_property, key, _val)
int _property;
DefTableKey key;
TYPE _val;
#endif
{  SEQAttrruleProperty _Item;
{ if (key == NoKey) return;
  ACCESS; VALUE = _val;
}
}

#undef ACCESS
#undef TYPE
#define TYPE SEQExpr

#define ACCESS find(key, _property, (Entry *)&_Item, sizeof(struct SEQExprElt))

typedef struct SEQExprElt {
	Entry next;
	int selector;
	TYPE PropVal;
} *SEQExprProperty;

#if defined(__STDC__) || defined(__cplusplus)
TYPE
GetSEQExpr (int _property, DefTableKey key, TYPE deflt)
#else
TYPE
GetSEQExpr (_property, key, deflt)
int _property;
DefTableKey key;
TYPE deflt;
#endif
{  SEQExprProperty _Item;
{ if (key == NoKey) return deflt;
  if (PRESENT) return VALUE;
  else return deflt;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
SetSEQExpr (int _property, DefTableKey key, TYPE _add, TYPE _replace)
#else
void
SetSEQExpr (_property, key, _add, _replace)
int _property;
DefTableKey key;
TYPE _add;
TYPE _replace;
#endif
{  SEQExprProperty _Item;
{ if (key == NoKey) return;
  if (ACCESS) VALUE = _replace;
  else VALUE = _add;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
ResetSEQExpr (int _property, DefTableKey key, TYPE _val)
#else
void
ResetSEQExpr (_property, key, _val)
int _property;
DefTableKey key;
TYPE _val;
#endif
{  SEQExprProperty _Item;
{ if (key == NoKey) return;
  ACCESS; VALUE = _val;
}
}

#undef ACCESS
#undef TYPE
#define TYPE CoordRef

#define ACCESS find(key, _property, (Entry *)&_Item, sizeof(struct CoordRefElt))

typedef struct CoordRefElt {
	Entry next;
	int selector;
	TYPE PropVal;
} *CoordRefProperty;

#if defined(__STDC__) || defined(__cplusplus)
TYPE
GetCoordRef (int _property, DefTableKey key, TYPE deflt)
#else
TYPE
GetCoordRef (_property, key, deflt)
int _property;
DefTableKey key;
TYPE deflt;
#endif
{  CoordRefProperty _Item;
{ if (key == NoKey) return deflt;
  if (PRESENT) return VALUE;
  else return deflt;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
SetCoordRef (int _property, DefTableKey key, TYPE _add, TYPE _replace)
#else
void
SetCoordRef (_property, key, _add, _replace)
int _property;
DefTableKey key;
TYPE _add;
TYPE _replace;
#endif
{  CoordRefProperty _Item;
{ if (key == NoKey) return;
  if (ACCESS) VALUE = _replace;
  else VALUE = _add;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
ResetCoordRef (int _property, DefTableKey key, TYPE _val)
#else
void
ResetCoordRef (_property, key, _val)
int _property;
DefTableKey key;
TYPE _val;
#endif
{  CoordRefProperty _Item;
{ if (key == NoKey) return;
  ACCESS; VALUE = _val;
}
}

#undef ACCESS
#undef TYPE
#define TYPE TList

#define ACCESS find(key, _property, (Entry *)&_Item, sizeof(struct TListElt))

typedef struct TListElt {
	Entry next;
	int selector;
	TYPE PropVal;
} *TListProperty;

#if defined(__STDC__) || defined(__cplusplus)
TYPE
GetTList (int _property, DefTableKey key, TYPE deflt)
#else
TYPE
GetTList (_property, key, deflt)
int _property;
DefTableKey key;
TYPE deflt;
#endif
{  TListProperty _Item;
{ if (key == NoKey) return deflt;
  if (PRESENT) return VALUE;
  else return deflt;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
SetTList (int _property, DefTableKey key, TYPE _add, TYPE _replace)
#else
void
SetTList (_property, key, _add, _replace)
int _property;
DefTableKey key;
TYPE _add;
TYPE _replace;
#endif
{  TListProperty _Item;
{ if (key == NoKey) return;
  if (ACCESS) VALUE = _replace;
  else VALUE = _add;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
ResetTList (int _property, DefTableKey key, TYPE _val)
#else
void
ResetTList (_property, key, _val)
int _property;
DefTableKey key;
TYPE _val;
#endif
{  TListProperty _Item;
{ if (key == NoKey) return;
  ACCESS; VALUE = _val;
}
}

#undef ACCESS
#undef TYPE

static struct PdlGenState
{
	struct PropElt PDLe0;
} state = {
	{(Entry)0, 0}
};

#ifndef NORESTORE

void *SaveModulePdlgen()
{
	return (void *)0;
}

void
#if defined(__cplusplus) || defined(__STDC__) 
RestoreModulePdlgen(void *base)
#else
RestoreModulePdlgen(base) void *base;
#endif
{
}

#endif

DefTableKey
#if defined(__STDC__) || defined(__cplusplus)
CloneKey (DefTableKey key)
#else
CloneKey (key)
    DefTableKey key;
#endif
{
  DefTableKey k;
  Entry e;

  if (key == NoKey) return NoKey;
  k = NewKey ();
  for (e = key->List; (e != (Entry)0) && (e->selector != 0);
       e = e->next) {
    switch (e->selector) {
      case 1:
         ResetClpValue (k, ((intProperty)e)->PropVal);
         break;
      case 2:
         ResetTermType (k, ((DefTableKeyProperty)e)->PropVal);
         break;
      case 3:
         ResetOldTerm (k, ((intProperty)e)->PropVal);
         break;
      case 4:
         ResetAttrKind (k, ((intProperty)e)->PropVal);
         break;
      case 5:
         ResetAttrType (k, ((intProperty)e)->PropVal);
         break;
      case 6:
         ResetAttrClass (k, ((intProperty)e)->PropVal);
         break;
      case 7:
         ResetAttrProdDid (k, ((intProperty)e)->PropVal);
         break;
      case 8:
         ResetAttrSymCompNo (k, ((intProperty)e)->PropVal);
         break;
      case 9:
         ResetChnChk (k, ((intProperty)e)->PropVal);
         break;
      case 10:
         ResetDefKind (k, ((intProperty)e)->PropVal);
         break;
      case 11:
         ResetDefinedSym (k, ((intProperty)e)->PropVal);
         break;
      case 12:
         ResetDid (k, ((intProperty)e)->PropVal);
         break;
      case 13:
         ResetIdent (k, ((intProperty)e)->PropVal);
         break;
      case 14:
         ResetAttrScope (k, ((EnvironmentProperty)e)->PropVal);
         break;
      case 15:
         ResetAttrib (k, ((SEQAttrruleProperty)e)->PropVal);
         break;
      case 16:
         ResetUpAttrib (k, ((SEQAttrruleProperty)e)->PropVal);
         break;
      case 17:
         ResetLowAttrib (k, ((SEQAttrruleProperty)e)->PropVal);
         break;
      case 18:
         ResetemptyHEADs (k, ((SEQExprProperty)e)->PropVal);
         break;
      case 19:
         ResetChainStarts (k, ((SEQAttrruleProperty)e)->PropVal);
         break;
      case 20:
         ResetCoord (k, ((CoordRefProperty)e)->PropVal);
         break;
      case 21:
         ResetMakeInh (k, ((intProperty)e)->PropVal);
         break;
      case 22:
         ResetInhTo (k, ((TListProperty)e)->PropVal);
         break;
      case 23:
         ResetInhFrom (k, ((TListProperty)e)->PropVal);
         break;
      case 24:
         ResetRuleProd (k, ((TListProperty)e)->PropVal);
         break;
      case 25:
         ResetRealSym (k, ((intProperty)e)->PropVal);
         break;
      case 26:
         ResetIsApplied (k, ((intProperty)e)->PropVal);
         break;
      case 27:
         ResetIsDefined (k, ((intProperty)e)->PropVal);
         break;
      case 28:
         ResetSymClass (k, ((intProperty)e)->PropVal);
         break;
      case 29:
         ResetIsGen (k, ((intProperty)e)->PropVal);
         break;
      case 30:
         ResetIsRoot (k, ((intProperty)e)->PropVal);
         break;
      case 31:
         ResetRootDid (k, ((intProperty)e)->PropVal);
         break;
      case 32:
         ResetHEADpos (k, ((intProperty)e)->PropVal);
         break;
      case 33:
         ResetTAILpos (k, ((intProperty)e)->PropVal);
         break;
      case 34:
         ResetNextRule (k, ((DefTableKeyProperty)e)->PropVal);
         break;
      case 35:
         ResetListBase (k, ((DefTableKeyProperty)e)->PropVal);
         break;
      case 36:
         ResetListProdLg (k, ((intProperty)e)->PropVal);
         break;
      case 37:
         ResetChkProd (k, ((DefTableKeyProperty)e)->PropVal);
         break;
      case 38:
         ResetProdKind (k, ((intProperty)e)->PropVal);
         break;
      case 39:
         ResetTreeOrClass (k, ((intProperty)e)->PropVal);
         break;
      }
  }
  return k;
}

#ifdef MONITOR
static char *pdl_names[] = {
    (char *)0,
    "ClpValue",
    "TermType",
    "OldTerm",
    "AttrKind",
    "AttrType",
    "AttrClass",
    "AttrProdDid",
    "AttrSymCompNo",
    "ChnChk",
    "DefKind",
    "DefinedSym",
    "Did",
    "Ident",
    "AttrScope",
    "Attrib",
    "UpAttrib",
    "LowAttrib",
    "emptyHEADs",
    "ChainStarts",
    "Coord",
    "MakeInh",
    "InhTo",
    "InhFrom",
    "RuleProd",
    "RealSym",
    "IsApplied",
    "IsDefined",
    "SymClass",
    "IsGen",
    "IsRoot",
    "RootDid",
    "HEADpos",
    "TAILpos",
    "NextRule",
    "ListBase",
    "ListProdLg",
    "ChkProd",
    "ProdKind",
    "TreeOrClass",
};
static char *pdl_types[] = {
    (char *)0,
    "int",
    "DefTableKey",
    "int",
    "int",
    "int",
    "int",
    "int",
    "int",
    "int",
    "int",
    "int",
    "int",
    "int",
    "Environment",
    "SEQAttrrule",
    "SEQAttrrule",
    "SEQAttrrule",
    "SEQExpr",
    "SEQAttrrule",
    "CoordRef",
    "int",
    "TList",
    "TList",
    "TList",
    "int",
    "int",
    "int",
    "int",
    "int",
    "int",
    "int",
    "int",
    "int",
    "DefTableKey",
    "DefTableKey",
    "int",
    "DefTableKey",
    "int",
    "int",
};

void
#if defined(__STDC__) || defined(__cplusplus)
pdl_mon_properties(DefTableKey k)
#else
pdl_mon_properties(k) DefTableKey k;
#endif
{
    Entry e;
    if (k == NoKey) return;
    for (e = k->List; (e != (Entry)0) && (e->selector != 0);
         e = e->next) {
        DAPTO_RESULT_STR (pdl_names[e->selector]);
        DAPTO_RESULT_STR (pdl_types[e->selector]);
        switch (e->selector) {
            case 1:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 2:
#ifdef DAPTO_RESULTDefTableKey
                DAPTO_RESULTDefTableKey (((DefTableKeyProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((DefTableKeyProperty)e)->PropVal);
#endif
                break;
            case 3:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 4:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 5:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 6:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 7:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 8:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 9:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 10:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 11:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 12:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 13:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 14:
#ifdef DAPTO_RESULTEnvironment
                DAPTO_RESULTEnvironment (((EnvironmentProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((EnvironmentProperty)e)->PropVal);
#endif
                break;
            case 15:
#ifdef DAPTO_RESULTSEQAttrrule
                DAPTO_RESULTSEQAttrrule (((SEQAttrruleProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((SEQAttrruleProperty)e)->PropVal);
#endif
                break;
            case 16:
#ifdef DAPTO_RESULTSEQAttrrule
                DAPTO_RESULTSEQAttrrule (((SEQAttrruleProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((SEQAttrruleProperty)e)->PropVal);
#endif
                break;
            case 17:
#ifdef DAPTO_RESULTSEQAttrrule
                DAPTO_RESULTSEQAttrrule (((SEQAttrruleProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((SEQAttrruleProperty)e)->PropVal);
#endif
                break;
            case 18:
#ifdef DAPTO_RESULTSEQExpr
                DAPTO_RESULTSEQExpr (((SEQExprProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((SEQExprProperty)e)->PropVal);
#endif
                break;
            case 19:
#ifdef DAPTO_RESULTSEQAttrrule
                DAPTO_RESULTSEQAttrrule (((SEQAttrruleProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((SEQAttrruleProperty)e)->PropVal);
#endif
                break;
            case 20:
#ifdef DAPTO_RESULTCoordRef
                DAPTO_RESULTCoordRef (((CoordRefProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((CoordRefProperty)e)->PropVal);
#endif
                break;
            case 21:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 22:
#ifdef DAPTO_RESULTTList
                DAPTO_RESULTTList (((TListProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((TListProperty)e)->PropVal);
#endif
                break;
            case 23:
#ifdef DAPTO_RESULTTList
                DAPTO_RESULTTList (((TListProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((TListProperty)e)->PropVal);
#endif
                break;
            case 24:
#ifdef DAPTO_RESULTTList
                DAPTO_RESULTTList (((TListProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((TListProperty)e)->PropVal);
#endif
                break;
            case 25:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 26:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 27:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 28:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 29:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 30:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 31:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 32:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 33:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 34:
#ifdef DAPTO_RESULTDefTableKey
                DAPTO_RESULTDefTableKey (((DefTableKeyProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((DefTableKeyProperty)e)->PropVal);
#endif
                break;
            case 35:
#ifdef DAPTO_RESULTDefTableKey
                DAPTO_RESULTDefTableKey (((DefTableKeyProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((DefTableKeyProperty)e)->PropVal);
#endif
                break;
            case 36:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 37:
#ifdef DAPTO_RESULTDefTableKey
                DAPTO_RESULTDefTableKey (((DefTableKeyProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((DefTableKeyProperty)e)->PropVal);
#endif
                break;
            case 38:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 39:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            default: DAPTO_RESULT_STR ("unknown property");
        }
    }
}
#endif
