#ifndef __MEMCHUNK_H__
#define __MEMCHUNK_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include <stdio.h>

#include "memblock.h"

/****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/

typedef struct memchunk {
        char *memptr;
        int   size;
        int   used;
        int   pos;
} memchunk_t;

/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

extern memchunk_t *memchunk_create_size (int size);
extern void        memchunk_memcpy (memchunk_t *memchunk, const void *src,
                                    int len);
extern void        memchunk_strcpy (memchunk_t *memchunk, const char *str);
extern void        memchunk_intdump (memchunk_t *memchunk, int a);
extern void        memchunk_strdump (memchunk_t *memchunk, const char *str);
extern void        memchunk_reset (memchunk_t *memchunk);
extern void        memchunk_resize_to (memchunk_t *memchunk, int newsize);
extern int         memchunk_data_size (memchunk_t *memchunk);
extern void        memchunk_destroy (memchunk_t *memchunk);

extern void  memchunk_rewind (memchunk_t *memchunk);
extern int   memchunk_intget (memchunk_t *memchunk);
extern char *memchunk_strget (memchunk_t *memchunk);
extern char *memchunk_strget_memblock (memchunk_t *memchunk, memblock_t **);

extern int memchunk_dump (memchunk_t *chunk, FILE *fp);
extern int memchunk_read (memchunk_t *chunk, FILE *fp);

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER memchunk.h
 *
 ****************************************************************************/
#endif
