<?php

#  Copyright (C) 2008 Neil Williams <codehelp@debian.org>
#
#  This package is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

# A few notes:
# 1. This is meant to be included into other PHP scripts
# 2. The CSS from buildd.debian.org is embedded so the colours match
# 3. There are ONLY two files / data sources available to this script -
#    the em_autobuild log and the emtarget file. (It is meant to be 
#    usable on the buildd as well as on www.emdebian.org.)
# 4. The script currently assumes /var/www

if (($_GET['log'] != '') && ($_GET['pkg'] != ''))
{
	# needs support for ARCH in the query string too.
	$pkg = htmlspecialchars ($_GET['pkg']);
	$log = htmlspecialchars ($_GET['log']);
	$pkg = preg_replace ('/\.+\/+/', "", $pkg);
	$pkg = preg_replace ('/\//', "", $pkg);
	$log = preg_replace ('/\.+\/+/', "", $log);
	$logfile = $pkg[0]."/".$pkg."/trunk/".$log;
	print "<h2>Package: $pkg</h2>";
	$safepkg=urlencode($pkg);
	print "<h3>Log: $logfile</h3>";
	print "<a href=\"".$SELF."?log=#$safepkg\">Back</a><br/>\n";
	if (is_file ("/var/www/buildd/$logfile"))
	{
		print "<pre>\n";
		readfile ("/var/www/buildd/$logfile");
		print "</pre>\n";
	}
	exit;
}
?>
<h2>Emdebian target package autobuilder report.</h2>
<p>If the Emdebian patches fail to apply, the build is likely to have failed before
<tt>dpkg-buildpackage</tt> was called and the version string might not be accurate.
The last available version can be identified by clicking on the package name and 
viewing the details of the package in the current Emdebian target repository.
</p>
<p>Automated dependency checks can be overridden manually if the problem is
unlikely to affect Emdebian installations (e.g. -dev or -doc packages or other 
packages not routinely used in Emdebian). Please ask on 
<a href="http://lists.debian.org/debian-embedded/">debian-embedded@lists.debian.org</a>.
</p>
<h3>Comparison with Debian status</h3>
<p><tt>emtargetcmp</tt> provides a summary of <a 
href="status.php">Emdebian packages compared to Debian unstable</a>.
</p>
<h3>Buildd History</h3>
<p>The package name links to the history of previous build attempts
for this package. The version string links to the repository data for
the current version in Emdebian.</p>
<?php
$dirlist = array ();
$pkglist = array ();
if (is_dir ("/var/www/buildd"))
{
	if ($builddh = opendir ("/var/www/buildd"))
	{
		while (($file = readdir ($builddh)) != false)
		{
			if (filetype ($dir . $file) == "dir")
			{
				if ($dir == '.') { continue; }
				if ($dir == '..') { continue; }
				array_push ($dirlist, $file);
			}
		}
		closedir ($builddh);
	}
}
foreach ($dirlist as $dir)
{
	if ($dir == '.') { continue; }
	if ($dir == '..') { continue; }
	if ($builddh = opendir ("/var/www/buildd/$dir"))
	{
		while (($pkg = readdir ($builddh)) != false)
		{
			if (filetype ($dir .'/'. $pkg) == "dir")
			{
				if ($pkg == '.') { continue; }
				if ($pkg == '..') { continue; }
				array_push ($pkglist, $pkg);
			}
		}
		closedir ($builddh);
	}
}
?>
<table class="data">
<tr><th>Package</th><th>Arch</th><th>Version</th>
<th>Latest Build Time</th>
<th>Latest Build State</th>
<th>Possible reasons</th>
</tr>
<?
sort ($pkglist);
$files = array ();
foreach ($pkglist as $key => $pkg)
{
	$last_log=0;
	$check = $key;
	$initchar = $pkg[0];
	if ($builddh = opendir ("/var/www/buildd/$initchar/$pkg/trunk/"))
	{
		while (($logfile = readdir ($builddh)) != false)
		{
			if (filetype ("$initchar/$pkg/trunk/". $logfile) != "dir")
			{
				preg_match ("/-([^-]*)-([0-9]+)\.log$/", $logfile, $matches);
				$arch = $matches[1];
				$time = $matches[2];
				if ($last_log > $time) { continue; }
				$files[$check] = $logfile;
				$last_log = $time;
			}
		}
	}
}
$numok=0;
$numfail=0;
$manual=0;
foreach ($files as $file)
{
	$status=0;
	preg_match ("/(.*)-([^-]*)-([0-9]+)\.log$/", $file, $matches);
	$pkg = $matches[1];
	$initchar = $pkg[0];
	$arch = $matches[2];
	$time = $matches[3];
	$timestr = date ("D jS M, H:i:s T", $time);
	$safefile=urlencode($file);
	$safepkg=urlencode($pkg);
	print "<tr id=\"$pkg\">\n";
	print "<td><a href=\"history.php?pkg=$safepkg\">$pkg</a></td>";
	print "<td>".$arch."</td>";
	$contents = file_get_contents ("$initchar/$pkg/trunk/$file");
	if (preg_match ("#Changes file: /.*/$initchar/$pkg/trunk/${pkg}_(.*)_$arch.changes#", $contents))
	{
		preg_match ("#Changes file: /.*/$initchar/$pkg/trunk/${pkg}_(.*)_$arch.changes#", $contents, $matches);
		print "<td><a href=\"";
		print "http://www.emdebian.org/packages/search.php?package=$safepkg\">";
		print $matches[1]."</a></td>";
	}
	else
	{
		if (preg_match ("/dpkg-buildpackage: source version (is )?(.*)/", $contents, $matches))
		{
			print "<td><a href=\"";
			print "http://www.emdebian.org/packages/search.php?package=$safepkg\">";
			print $matches[2]."</a></td>";
		}
		# special tag line added by emsource >= 1.1.6 to assist in version detection.
		else if (preg_match ("/emsource: Attempted version: (.*)/", $contents, $matches))
		{
			print "<td><a href=\"";
			print "http://www.emdebian.org/packages/search.php?package=$safepkg\">";
			print $matches[1]."</a></td>";
		}
		else
		{
			print "<td>&nbsp;</td>";
		}
	}
	print "<td>".$timestr."</td>";
	if (preg_match ("/dpkg-buildpackage: failure/", $contents)
		|| (! preg_match("/dpkg-genchanges/", $contents))
		|| (! preg_match("/Successful build/", $contents)))
	{
		print "<td class=\"warn\">";
		print "<a href=\"?log=$safefile&amp;pkg=$safepkg\">maybe failed</a>";
		print "</td>\n";
		$status = -1;
		$numfail++;
	}
	else
	{
		print "<td class=\"good\">";
		print "<a href=\"?log=$safefile&amp;pkg=$safepkg\">maybe successful</a>";
		print "</td>\n";
		$status = 1;
		$numok++;
	}
	# Look for the messages put into the build log by embug.
	$fail_pat = "Recording that the package failed to build.";
	$patch_pat = "Recording that the Emdebian SVN patches are out of date for";
	$lintian_pat = "Recording that '.*' has failed a lintian check";
	$fail_patch = "Package failed to build but patches are marked as out of date.";
	$wait_pat = "Recording that .* is waiting for another dependency.";
	# span support for each error.
	$ok="<td class=\"good\">";
	$bad="<td class=\"warn\">";
	if (preg_match("/$patch_pat/", $contents))
	{
		print $bad."Patches failed to apply.</td>\n";
	}
	else if (preg_match("/$fail_pat/", $contents))
	{
		print $bad."Failed to cross-build.</td>\n";
	}
	else if (preg_match("/$fail_patch/", $contents))
	{
		print $bad."Patches out of date.</td>\n";
	}
	else if (preg_match("/$lintian_pat/", $contents))
	{
		print $bad."Lintian errors.</td>\n";
	}
	else if ($status > 0)
	{
		# once uploads are automated, append .upload to log
		# and look for that data here.
		$dput_pat = "Successfully uploaded ?.* ?to ";
		if (preg_match("/$dput_pat/", $contents))
		{
			print $ok."Installed.</td>\n";
		}
		else if (preg_match("/$wait_pat/", $contents))
		{
			$manual++;
			print $ok."Possible dependency problem.</td>\n";
		}
		else
		{
			$manual++;
			print $ok."Manual upload.</td>\n";
		}
	}
	else
	{
		print "<td>&nbsp;</td>\n";
	}
	print "</tr>\n";
}

?>
</table>
</td>
    </tr>
</table>
<?php
if ($numok > 0)
{
	print "<p>$numok";
	print ($numok > 1) ? " packages" : " package";
	print " built successfully.</p>";
}
if ($numfail > 0)
{
	print "<p>$numfail";
	print ($numfail > 1) ? " packages" : " package";
	print " failed to cross build.</p>";
}
if ($manual > 0)
{
	print "<p>$manual";
	print ($manual > 1) ? " packages are" : " package is";
	print " tagged for a manual upload.</p>";
}
$total = $numok + $numfail;
$ok = (int)($numok/$total * 100);
$fail = (int)($numfail/$total * 100);
$notok = 100 - $ok;
$notfail = 100 - $fail;
print "<table style=\"width:$total\">";
print "<tr>";
if ($ok > 50)
{
	print "<td style=\"width:$ok;color: white;background-color: green;\">";
	print "$ok% built OK</td>";
	print "<td style=\"width:$notok;background-color: white;\">&nbsp;</td>";
}
else
{
	print "<td style=\"width:$ok;color: white;background-color: green;\">&nbsp;</td>";
	print "<td style=\"width:$notok;background-color: white;\">$ok% built OK</td>";
}
print "</tr>\n</table>\n";
print "<table style=\"width:$total\">";
print "<tr>";
if ($fail > 50)
{
	print "<td style=\"width:$fail;background-color: red;\">$fail% failed</td>";
	print "<td style=\"width:$notfail;background-color: white;\">&nbsp;</td>";
}
else
{
	print "<td style=\"width:$fail;background-color: red;\">&nbsp;</td>";
	print "<td style=\"width:$notfail;background-color: white;\">$fail% failed</td>";
}
print "</tr>\n</table>\n";

?>
<p><a href="<?php echo "$SELF"; ?>?log=#top">Top</a>.</p>
