"**************************************************************************
"enCore 3.3 to 3.3.1 Patch. 
"Copyright (C) 2002 enCore Open Source Project. All Rights Reserved.
"
"This program is free software; you can redistribute it and/or modify it 
"under the terms of the GNU General Public License as published by the 
"Free Software Foundation; either version 2 of the License, or any later
"version.
"
"It is distributed in the hope that it will be useful, but WITHOUT ANY
"WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS 
"FOR A PARTICULAR PURPOSE. See the GNU General Public License for more 
"details. (http://lingua.utdallas.edu/hw/gpl.html)
"
"You install this code by pasting it into your MOO window. Read the
"instructions and verb code in this file CAREFULLY before you apply the
"patch. You MUST incorporate any changes you have made to verbs that will 
"be affected by this patch BEFORE you apply it, or else your changes WILL 
"BE LOST! 
"
"Commands and verbs MUST be applied in the order they appear in this file.
"Failure to observe these warnings may result in problems and possible 
"damage to your database. Also, to use this patch you must have applied any 
"previous patches BEFORE you apply this one. We recommend that you paste in
"only small portions of the patch at a time so you can check that everything
"is ok as you go along.
"
"BACK UP YOUR DATABASE BEFORE YOU APPLY THIS PATCH!
"
"Jan Rune Holmevik                                           Cynthia Haynes
"Dept. of Humanistic Informatics              School of Arts and Humanities
"University of Bergen                         University of Texas at Dallas
"Sydnesplass 7 HF-bygget                                 PO.Box 830688-JO31
"N-5007 Bergen, Norway                            Richardson, TX 75083-0688
"Email: jan.holmevik@uib.no                    Email: cynthiah@utdallas.edu
"**************************************************************************

@program $wiz_utils:_set_property_flags
"_set_property_flags(object, pname, {owner, flags} or something+\"c\", suspendok)";
"auxiliary to :set_property_flags... don't call this directly.";
if (caller != this)
  return E_PERM;
endif
if (args[4] && $command_utils:running_out_of_time(0))
  suspend(0);
endif
object = args[1];
if (typeof(args[3]) != LIST)
  set_property_info(object, args[2], {object.owner, args[3]});
else
  set_property_info(@args[1..3]);
endif
for kid in (children(object))
  $command_utils:suspend_if_needed(1);
  this:_set_property_flags(@listset(args, kid, 1));
endfor
.

;"Updating properties. Please be patient, this may take a while.";
;$wiz_utils:set_property_flags($encore_web_class, "shared_owners", "c");


@program $xpress_program_editor:save_property_value
"===========================================================";
"Copyright (C) 2001-2002, Jan Rune Holmevik and Alexandre Borgia";
"Save property values via Xpress";
"===========================================================";
if (!caller_perms().wizard)
  return E_PERM;
endif
{user, object, property, value} = args;
alert = "";
value = this:coerce(value);
"Update 12/17/02: The verb now runs with user task perms in order to prevent unauthorized use";
"Check to see if the user has been designated as co-owner of the object.";
if (user in (object.shared_owners))
   set_task_perms(toobj(object.owner));
else
   set_task_perms(user);
endif
"Set new property value if the the object defines the property, otherwise return error message.";
try
  if (value != object.(property))
    object.(property) = value;
    alert = tostr(" Property ", property, " saved.");
  endif  
except error (ANY)
  alert = " Could not save property: " + tostr(error[2]);
endtry
return alert;
.

@set #0.core_version to "3.3.1"

;#0.("core_history") = {{"enCore 3.3.1", "1.8.1", 1040185243}, {"enCore 3.3", "1.8.1", 1040053857}, {"enCore 3.2", "1.8.1", 1001876038}, {"enCore 3.1", "1.8.1", 1000852213}, {"enCore 3.0.2", "1.8.1", 998391691}, {"enCore 3.0.1", "1.8.1", 995638174}, {"enCore 3.0", "1.8.1", 987347897}, {"enCore 2.1.1", "1.8.1", 961336324}, {"enCore 2.1", "1.8.1", 960582191}, {"enCore 2.0.6", "1.8.1", 954635799}, {"enCore 2.0.5", "1.8.1", 953998452}, {"enCore 2.0.4", "1.8.1", 950453897}, {"enCore 2.0.3", "1.8.0r5", 943788625}, {"enCore 2.0.2", "1.8.0r5", 939547732}, {"enCore 2.0.1", "1.8.0r5", 939031601}, {"enCore 2.0", "1.8.0r5", 928255674}, {"enCore 1.1", "1.8.0p6", 908817314}, {"enCore 1.0", "1.8.0p6", 892671137}, "LambdaMOO", "1.8.0p5", 854992537}


;"Done. Your MOO has been updated to enCore version 3.3.1!";

