#include <glib.h>
#include <errno.h>
#include <unistd.h>

#include "entity.h"
#include "baby-entity.h"

static int entity_argc;
static char **entity_argv;

/* For use by renderers.. some need eg, --display etc. */

int
entity_get_argc (void)
{
    return (entity_argc);
}

gchar **
entity_get_argv (void)
{
    return (entity_argv);
}


void
entity_init (int *argc, char ***argv)
{
    gchar working_dir[PATH_MAX];

    entity_argc = *argc;
    entity_argv = *argv;

    EDEBUG (("main", "in entity_init"));
    econfig_init ();

    /* Set this here.. they can override if they want */
    econfig_set_attr ("config-location", DATADIR);

    getcwd (working_dir, PATH_MAX);
    econfig_set_attr ("entity-startup-dir", g_strdup (working_dir));

    enode_init ();
    baby_main_init ();
}


