#include <entity.h>
#include <gnome.h>
#include <rendgnome.h>



/* there are only 17 writiable arguments to the text item */
#define MAX_RECT_ARGS 17
static void
rendcanvas_rect_render (ENode * node)
{
  GtkArg *args;
  EBuf *buf;
  int num_args = 0;
  int alpha = 255, outline_alpha = 255;

  EDEBUG(("canvas", "rendering rect item"));

  args = (GtkArg*)malloc(MAX_RECT_ARGS * sizeof(GtkArg));

  buf = enode_attrib (node, "x1", NULL);
  if (!ebuf_empty(buf)) {    
    double x = strtod (buf->str, NULL);

    EDEBUG(("canvas", "setting x1 attrib to %f", x));

    args[num_args].name = "x1";
    args[num_args].type = GTK_TYPE_DOUBLE;
    args[num_args].d.double_data = x;
    num_args ++;
  }

  buf = enode_attrib (node, "x2", NULL);
  if (!ebuf_empty(buf)) {    
    double x = strtod (buf->str, NULL);

    EDEBUG(("canvas", "setting x2 attrib to %f", x));

    args[num_args].name = "x2";
    args[num_args].type = GTK_TYPE_DOUBLE;
    args[num_args].d.double_data = x;
    num_args ++;
  }

  buf = enode_attrib (node, "y1", NULL);
  if (!ebuf_empty(buf)) {    
    double y = strtod (buf->str, NULL);

    EDEBUG(("canvas", "setting y1 attrib to %f", y));

    args[num_args].name = "y1";
    args[num_args].type = GTK_TYPE_DOUBLE;
    args[num_args].d.double_data = y;
    num_args ++;
  }

  buf = enode_attrib (node, "y2", NULL);
  if (!ebuf_empty(buf)) {    
    double y = strtod (buf->str, NULL);

    EDEBUG(("canvas", "setting y2 attrib to %f", y));

    args[num_args].name = "y2";
    args[num_args].type = GTK_TYPE_DOUBLE;
    args[num_args].d.double_data = y;
    num_args ++;
  }

  
  buf = enode_attrib (node, "alpha", NULL);
  if (!ebuf_empty(buf)) {
    char *tail;

    alpha = strtol (buf->str, &tail, 0);

    if (tail == buf->str)
      alpha = 255;
  }


  buf = enode_attrib (node, "color", NULL);
  if (!ebuf_empty(buf)) {
    GdkColor c;
    int r, g, b;
    guint canvas_color;

    EDEBUG(("canvas", "setting color attrib to %s", buf->str));

    if (gdk_color_parse(buf->str, &c)) {
      r = c.red >> 8;
      g = c.green >> 8;
      b = c.blue >> 8;
      canvas_color = GNOME_CANVAS_COLOR_A (r,g,b,alpha);
      
      args[num_args].name = "fill_color_rgba";
      args[num_args].type = GTK_TYPE_UINT;
      args[num_args].d.uint_data = canvas_color;
      num_args++;
    }
  }

  buf = enode_attrib (node, "outline-alpha", NULL);
  if (!ebuf_empty(buf)) {
    char *tail;

    outline_alpha = strtol (buf->str, &tail, 0);

    if (tail == buf->str)
      outline_alpha = 255;
  }


  buf = enode_attrib (node, "outline-color", NULL);
  if (!ebuf_empty(buf)) {
    GdkColor c;
    int r, g, b;
    guint canvas_color;

    if (gdk_color_parse(buf->str, &c)) {
      r = c.red >> 8;
      g = c.green >> 8;
      b = c.blue >> 8;
      canvas_color = GNOME_CANVAS_COLOR_A (r,g,b,outline_alpha);
      
      args[num_args].name = "outline_color_rgba";
      args[num_args].type = GTK_TYPE_UINT;
      args[num_args].d.uint_data = canvas_color;
      num_args++;
    }
  }



  /* fill in the rest of the rect attrbs here */
  EDEBUG(("canvas", "rect item - %d args.", num_args));

  enode_set_kv (node, "rendcanvas-num-args", num_args);
  enode_set_kv (node, "rendcanvas-args", args);
  enode_set_kv (node, "rendcanvas-type", gnome_canvas_rect_get_type());

  enode_attribs_sync (node);
}

void
rendcanvas_rect_init (RendererFlags flags)
{
  Element *element;

  if (!flags & RENDERER_REGISTER)
    return;

  element = g_new0 (Element, 1);
  element->tag = "canvas-rect";
  element->render_func = rendcanvas_rect_render;
  element->destroy_func = rendcanvas_item_destroy;
  element_register (element);

  rendcanvas_register_pos_attrs (element);

  /* register rect attribs here */
}
