#include <gtk/gtk.h>
#include <stdlib.h>
#include "entity.h"
#include "gtk-common.h"
#include "gtk-widget-attr.h"
#include "toggle-renderer.h"

static void
rendgtk_toggle_button_onclick_callback (GtkWidget * widget, gpointer user_data)
{
    ENode *node = user_data;
    gchar *function = NULL;

    function = enode_attrib_str (node, "onclick", NULL);

    enode_call_ignore_return (node, function, "");
}

static void
rendgtk_toggle_button_onmouseenter_callback (GtkWidget * widget,
					     gpointer user_data)
{
    ENode *node = user_data;
    gchar *function = NULL;

    function = enode_attrib_str (node, "onmouseenter", NULL);

    enode_call_ignore_return (node, function, "");
}

static void
rendgtk_toggle_button_onmouseleave_callback (GtkWidget * widget,
					     gpointer user_data)
{
    ENode *node = user_data;
    gchar *function = NULL;

    function = enode_attrib_str (node, "onmouseleave", NULL);

    enode_call_ignore_return (node, function, "");
}


static void
rendgtk_toggle_button_render (ENode * node)
{
    GtkWidget *button;
    GtkWidget *vbox;

    EDEBUG (("button-renderer", "in rendgtk_button_render"));

    button = gtk_toggle_button_new ();

    vbox = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (button), vbox);

    enode_set_kv (node, "top-widget", button);
    enode_set_kv (node, "bottom-widget", vbox);

    gtk_signal_connect (GTK_OBJECT (button), "clicked",
			rendgtk_toggle_button_onclick_callback, node);
    gtk_signal_connect (GTK_OBJECT (button), "enter",
			rendgtk_toggle_button_onmouseenter_callback, node);
    gtk_signal_connect (GTK_OBJECT (button), "leave",
			rendgtk_toggle_button_onmouseleave_callback, node);
    gtk_signal_connect (GTK_OBJECT (button), "toggled",
			GTK_SIGNAL_FUNC (rendgtk_toggle_ontoggle_callback),
			node);
    gtk_signal_connect (GTK_OBJECT (button), "toggled",
			GTK_SIGNAL_FUNC (rendgtk_toggle_onselect_callback),
			node);


    enode_attribs_sync (node);

    rendgtk_show_cond (node, button);
    gtk_widget_show (vbox);
}


void
toggle_button_renderer_register (void)
{
    Element *element;
    ElementAttr *e_attr;

    element = g_new0 (Element, 1);
    element->render_func = rendgtk_toggle_button_render;
    element->destroy_func = rendgtk_element_destroy;
    element->parent_func = rendgtk_box_pack;
    element->tag = "togglebutton";
    element->description = "Create a new toggle button widget.";
    element_register (element);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "onclick";
    e_attr->description = "Sets up a handler for click events.";
    e_attr->value_desc = "function";
    e_attr->possible_values = "(calling_node)";
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "onmouseenter";
    e_attr->description = "Sets up a handler for mouse enter events.";
    e_attr->value_desc = "function";
    e_attr->possible_values = "(calling_node)";
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "onmouseleave";
    e_attr->description = "Sets up a handler for mouse leave events.";
    e_attr->value_desc = "function";
    e_attr->possible_values = "(calling_node)";
    element_register_attrib (element, e_attr);


    rendgtk_toggle_attr_register (element);
    rendgtk_widget_attr_register (element, GTK_TYPE_TOGGLE_BUTTON);
    rendgtk_containerbox_attr_register (element);
}


