/*
 * screen.h: header for screen.c
 *
 * Written by Matthew Green.
 *
 * Copyright (C) 1993.
 *
 * See the copyright file, or type help ircii copyright
 *
 * @(#)$Id: screen.h,v 1.6 1994/07/02 02:38:10 mrg Exp $
 */

#ifndef _SCREEN_H_
#define _SCREEN_H_

#include "irc_std.h"
#include "window.h"

#define WAIT_PROMPT_LINE        0x01
#define WAIT_PROMPT_KEY         0x02

typedef struct PromptStru
{
	char	*prompt;
	char	*data;
	int	type;
	void	(*func)();
	struct	PromptStru	*next;
}	WaitPrompt;


typedef	struct	ScreenStru
{
	int	screennum;
	Window	*current_window;
	unsigned int	last_window_refnum;	/* reference number of the
						 * window that was last
						 * the current_window */
	Window	*window_list;			/* List of all visible
						 * windows */
	Window	*window_list_end;		/* end of visible window
						 * list */
	Window	*cursor_window;			/* Last window to have
						 * something written to it */
	int	visible_windows;		/* total number of windows */
	WindowStack	*window_stack;		/* the windows here */

	int	meta_hit[10];			/* if one of the meta
						 * keys is hit in this
						 * screen, (0 - 9) that
						 * index is set
						 */

	int	quote_hit;			/* true if a key bound to
						 * QUOTE_CHARACTER has been
						 * hit. */
	int	digraph_hit;			/* A digraph key has been hit */
	int	inside_menu;			/* what it says. */

	unsigned char	digraph_first;

	struct	ScreenStru *prev;		/* These are the Screen list */
	struct	ScreenStru *next;		/* pointers */

	FILE	*fpin;				/* These are the file pointers */
	int	fdin;				/* and descriptions for the */
	FILE	*fpout;				/* screen's input/output */
	int	fdout;

	char	input_buffer[INPUT_BUFFER_SIZE+1];	/* the input buffer */
	int	buffer_pos;			/* and the positions for the */
	int	buffer_min_pos;			/* screen */

	char	saved_input_buffer[INPUT_BUFFER_SIZE+1];
	int	saved_buffer_pos;
	int	saved_min_buffer_pos;

	WaitPrompt	*promptlist;

	char	*redirect_name;
	char	*redirect_token;
	int	redirect_server;

	char	*tty_name;
	int	co;
	int	li;

	int	alive;
}	Screen;

/* Stuff for the screen/xterm junk */

#define ST_NOTHING      -1
#define ST_SCREEN       0
#define ST_XTERM        1

/* This is here because it happens in so many places */
#define curr_scr_win	current_screen->current_window

struct WindowStru;	/* HACK */

extern	void	scrollback_forwards _((char, char *));
extern	void	scrollback_end _((char, char *));
extern	void	scrollback_backwards _((char, char *));
extern	void	scrollback_start _((char, char *));
extern	void	clear_window _((struct WindowStru *));
extern	void	recalculate_window_positions _((void));
extern	int	output_line _((char *, char **, int));
extern	void	recalculate_windows _((void));
#ifdef WINDOW_CREATE
extern	struct WindowStru	*create_additional_screen _((void));
#endif
extern	void	scroll_window _((struct WindowStru *));
extern	struct WindowStru	*new_window _((void));
extern	void	update_all_windows _((void));
extern	void	add_wait_prompt _((char *, void (*)(), char *, int));
extern	void	clear_all_windows _((int));
extern	void	cursor_in_display _((void));
extern	int	is_cursor_in_display _((Screen *));
extern	void	cursor_not_in_display _((void));
extern	void	set_current_screen _((Screen *));
extern	void	redraw_resized _((struct WindowStru *, ShrinkInfo, int));
extern	void	close_all_screen _((void));
extern	int	check_screen_redirect _((char *));
extern	void	do_screens _((fd_set *));

extern	struct WindowStru	*to_window;
extern	Screen	*current_screen;
extern	Screen	*main_screen;
extern	Screen	*last_input_screen;
extern	Screen	*screen_list;

#endif /* _SCREEN_H_ */
