# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2006 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to display XML parse messages.
"""

from qt import *
from XMLMessageForm import XMLMessageForm


class XMLMessageDialog(XMLMessageForm):
    """
    Class implementing a dialog to display XML parse messages.
    """
    def __init__(self, msgs, parent = None):
        """
        Constructor
        
        @param msgs list of tuples of (message type, system id,
            line no, column no, message)
        @param parent parent object of the dialog (QWidget)
        """
        XMLMessageForm.__init__(self,parent)
        
        for type, sysId, line, column, msg in msgs:
            if type == "F":
                self.messages.setColor(Qt.red)
                self.messages.append(self.trUtf8("Fatal Error"))
            elif type == "E":
                self.messages.setColor(Qt.blue)
                self.messages.append(self.trUtf8("Error"))
            elif type == "W":
                self.messages.setColor(Qt.black)
                self.messages.append(self.trUtf8("Warning"))
            
            self.messages.append(sysId)
            self.messages.append(self.trUtf8("Line: %1, Column: %2")
                .arg(line).arg(column))
            self.messages.append(msg)
            
            self.messages.setColor(Qt.black)
            self.messages.append("------")
