-*- indented-text -*-

($Revision: 5.4 $)

ESS: Using SAS
==============

The SAS module in ESS (ESS[SAS]) is currently undergoing development.
It is functional and pretty stable.  Please send any suggestions and 
bug reports to ess-bugs@stat.math.ethz.ch.

ESS (originally S-mode) was initially designed for use with S and
S-PLUS(tm).  ESS has been extended to support other languages, 
including SAS(tm).  The editing of SAS files is based on
the stable, old SAS mode by Cook
(ftp://ftp.biostat.wisc.edu/pub/cook/sas-mode/sas.tar.gz).  Those
editing features and new advanced features are part of ESS[SAS].  
The user interface with ESS[SAS] is similar in behavior to the 
interface for S (unlike Cook's SAS mode) and to the windowing 
interface that SAS itself uses.

We denote by _Emacs_ one of the GNU family of editors, either Emacs
(as developed and maintained by the Free Software Foundation) or
XEmacs (which is a derivative work).

The following is covered in this document:
- general Emacs features.
- Editing files.
- running an interactive SAS process as an inferior process to Emacs
- running a batch SAS process in a shell buffer
- Scenarios for use (possibilities, based on actual usage)
- using transcripts.
- Design Philosophy


Emacs: General features
=======================

We assume that you are familiar with Emacs terminology and syntax:
file, buffer, region, description of keys etc.  If not, please read
the New Users guide (found in the info pages, "C-h i" (by pressing
control h, i) or Tutorial, "C-h t").


ESS[SAS]: Editing Files
=======================

ESS[SAS] is the mode for editing SAS language files.  This mode handles:

- proper indenting, generated by both [Tab] and [Return].
- color and font choices based on syntax.
- ability to send the contents of an entire buffer, a highlighted region,
  or a single line to an inferior SAS process, if one is currently running.
- ability to switch between processes which would be the target of the
  buffer (for the above).
- ability to save and submit the file you are working on as a batch SAS
  process with a single keypress and to continue editing while it is running
- capability of killing the batch SAS process through the shell buffer or
  allow the SAS process to keep on running after you exit Emacs
- single keypress navigation of .sas, .log and .lst files (.log and .lst
  files are automatically refreshed with each keypress)

ESS[SAS], the mode for editing SAS language files, is automatically
turned on when editing a file with a ".sas" suffix (or other, if
specified in ess-site).  The batch processing keypress commands are
enabled by default to use the same function keys that the SAS Display
Manager uses.  The interactive capabilities of ESS require you to
start an inferior SAS process with M-x SAS (described below).

At this writing (ESS release 5.2), the indenting and syntactic
highlighting are usually correct.


ESS[SAS]: Function keys for batch processing
============================================

The description of the setup for function keys for batch processing of
SAS files is unavoidably more complex than we wish it were.  The actual
use of the function keys is simple.  There are five distinct options:

1. (default) Function keys in ESS[SAS] modes do whatever they normally
do in other emacs modes.  Many users will have defined some of the
keys [f2]-f[8] in their .emacs or _emacs file, or will have
installation-wide definitions in their site-start.el file.  By
default, ESS does not override those definitions.  This default is
intended to make ESS[SAS] mode behave similarly to other emacs modes.

2,3,4,5.
Users who are primarily familiar with SAS, and who are learning emacs
as a way to approach SAS, will likely want to duplicate the function
key capabilities that SAS Institute provides with its Display Manager.
There are still options.  SAS provides different function key
definitions with its PC and Unix products; ESS can use either.  The
ESS[SAS] function key definitions can be active in all buffers
(global) or limited (local) only to buffers that have SAS-related file
extensions: .sas, .log, .lst, and "Type-1" which defaults to .txt.
The distinction between local and global appears subtle.  If you want
the ESS[SAS] definitions to work when you are in *shell* or when
editing files other than the file extensions that SAS recognizes, you
will most likely want to use the global definitions.
If you want your function keys to understand SAS batch commands when you
are editing SAS files, and to behave normally when editing other files,
then you will choose the local definitions.

The option can be chosen by the person installing ESS for a site or by
an individual.

The site manager can uncomment only one of the following lines.
ESS[SAS] Function keys are available in ESS[SAS] and related modes if you
uncomment either of the following lines in your ess-site.el:
;;2; (setq ess-sas-local-unix-keys t)
;;3; (setq ess-sas-local-pc-keys t)
ESS[SAS] Function keys are available in all Emacs modes if you
uncomment either of the following lines in your ess-site.el:
;;4; (setq ess-sas-global-unix-keys t)
;;5; (setq ess-sas-global-pc-keys t)
The names -unix- and -pc- have nothing to do with the operating system
that you are running.  Rather they mimic the definitions that the SAS
Display Manager uses by default on those platforms.

The option can be selected by an individual by adding a line to the
.emacs (or _emacs) file, immediately following the
 (load "ess-site")
line.  If your site manager has chosen an option 2,3,4,5 you don't
want, you must turn it off before selecting a different option.  To
turn off an option, add the appropriate line (uncommented) to your
.emacs (_emacs) file.
;;2; (setq ess-sas-local-unix-keys nil)
;;3; (setq ess-sas-local-pc-keys nil)
;;4; (setq ess-sas-global-unix-keys nil)
;;5; (setq ess-sas-global-pc-keys nil)

Finally we get to what the function keys do.

Unix PC
F2   F2 Refresh:revert the buffer with the file if the file on disk is newer
                       than the file currently in the buffer.
F3   F8 Submit: save   the current .sas buffer (which may be the .sas
                       file associated with the .lst or .log file you
                       are actually looking at) to a file and submit
                       the file to a background SAS job.
F4   F5 Program:switch buffer to .sas file.
F5   F6 Log:    switch buffer to .log file, "refresh" and 
                        goto next error message, if any.
F6   F7 Listing:switch buffer to .lst file and "refresh".
F7   F4 Type-1: switch buffer to Type-1 (defaults to .txt) file and "refresh".
F8   F3 Shell:  switch buffer to shell.

Keys [f3]-[f8] mimic SAS Display Manager keys.  One other key has been
provided for convenience.  F2 performs the "refresh" operation on the
current buffer.  "refresh" compares the buffer date stamp with the
file date stamp and replaces the buffer with the file if the file is
newer.  This is the same operation that is automatically performed
when Log, Listing, or Type-1 are pressed.  Type-1 takes you to a file
with a user-specified extension; .txt by default.  You can over-ride
the default, by specifying a different extension in your .emacs file:
(setq ess-sas-suffix-1 '.txt')


ESS[SAS]: TAB key
=================

Again, two options.

The TAB key is bound by default to sas-indent-line.  This function is
used to syntactically indent SAS code so PROC and RUN are in the left
margin, other statements are indented 4 spaces from the margin,
continuation lines are indented 4 spaces in from the beginning column
of that statement.  This is the type of functionality that Emacs
provides in most programming language modes.  This functionality is
equivalent to uncommenting the following line in ess-site.el:
;;; (setq ess-sas-edit-keys-toggle 0)

ESS provides an alternate behavior for the TAB key that makes it
behave as it does on non-emacs terminals, i.e. move the cursor to the
next tab stop.  The alternate behavior also provides a backwards TAB
key: C-TAB.  This functionality is obtained by uncommenting the
following line in ess-site.el:
;;; (setq ess-sas-edit-keys-toggle 1)
Under the alternate behavior, the TAB key is bound to tab-to-tab-stop
and the tab stops are set by default at multiples of 4.


iESS: Inferior ESS processes
============================

iESS (inferior ESS) is the mode for interfacing with active
statistical processes (programs).  

To start up iESS[SAS] mode, use:
   M-x SAS

We plan to add
- The ability to request help from a process for variables and
  functions, and to have the results sent into a separate buffer.
- completion of object names and file names.


ESS[SAS]: Batch processes
=========================

The default command used by the Submmit funciton key (F3 or F8) to submit
a batch SAS job is simply "sas".  If necessary, you can over-ride this in
your .emacs file something like one of the following:
;;; (setq ess-sas-submit-command "nohup nice sas") ;; Unix
;;; (setq ess-sas-submit-command "c:/progra~1/sas/sas.exe") ;; Windows
;;; (setq ess-sas-submit-command "invoke SAS using program file") ;; Mac
Note that when you are specifying a path under Windows, you should
avoid spaces (that is use "progra~1", not "Program Files") and you
should use forward slashes "/".  There may be occasions when you want
to run a particular buffer under a different version of SAS or specify
different options on the command line.  In that case, you can
over-ride ess-sas-submit-command in your local buffer with file
variables or other means.

There is a built-in delay before a batch SAS job is submitted when using
a Unix shell under either Unix or Windows.  This is necessary in many cases 
since the shell might not be ready to receive a command.  This delay is 
currently set high enough so as not to be a problem on any system.  But,
there may be cases when it needs to be set higher, or could be set much
lower to speed things up.  You can over-ride the default in your .emacs
file by (the default of 5 seconds is shown):
(setq ess-sleep-for 5)


Scenarios for use
=================

We present one scenario for using ESS to interact with SAS.
Contributions of examples of how you work with ESS are appreciated
(especially since it helps us determine priorities on future
enhancements)! (comments as to what should be happening are prefixed
by "##").

Batch SAS (-unix-keys illustrated, pc-keys in the comments)
    ## Find the file you want to work with
    C-x C-f myfile.sas
    ## myfile.sas will be in ESS[SAS] mode

    ## Edit as appropriate, then save and submit the batch SAS job.
    ## -pc- F8
    F3

    ## The job runs in the shell buffer while you continue to edit 
    ## myfile.sas.  If you are running a Unix shell under Unix or
    ## Windows, the message buffer will notify you with a shell
    ## notification when the job is complete.  If so, then you 
    ## will also have the option of terminating the batch job
    ## before it is finished.
    ## -pc- F3
    F8

    ## In any case, you may want to visit the .log while the process
    ## is still running (unix only) or when it is done and check for
    ## error messages 
    ## (you will be taken to the next error message, if any).
    ## The .log will be refreshed and you will be placed in it's buffer.
    ## -pc- F6
    F5

    ## Now, refresh the .lst and go to it's buffer.
    ## -pc- F7
    F6

    ## If you wish to make changes, go to the .sas file with
    ## -pc- F5
    F4
    ## and make your editing changes.  The go back to the submit instruction.


Interactive SAS
    ## Find the file you want to work with
    C-x C-f myfile.sas
    ## myfile.sas will be in ESS[SAS] mode

    ## Edit as appropriate, and then start up SAS with the cursor in
    ## the myfile.sas buffer
    M-x SAS

    ## Four buffers will appear on screen:
    ## myfile.sas  in  ESS[SAS]        mode # your source file
    ## *SAS:1*     in  iESS [SAS:1]    mode # ESS communication buffer
    ## *SAS:1.log* in  Shell [] ESStr  mode # SAS log information
    ## *SAS:1.lst* in  Shell [] ESSlst mode # SAS listing information

    ## If you would prefer each of the four buffers to appear in its
    ## own individual frame, you can arrange for that.  Place the
    ## cursor in the buffer displaying myfile.sas.  Enter the
    ## sequence:
    C-c C-w

    ## The cursor will normally be in buffer myfile.sas.
    ## If not, put it there:
    C-x b myfile.sas

    ## Send regions, lines, or the entire file contents to SAS
    ## (regions are most useful).  A highlighted region will normally
    ## begin with the keywords 'DATA' or 'PROC' and end with the
    ## keyword 'RUN;'
    C-c C-r

    ## Information appears in the log buffer, analysis results in the
    ## listing buffer.  In case of errors, make the corrections in the
    ## myfile.sas buffer and resubmit with another C-c C-r

    ## PROC GPLOT graphs will normally be produced in a postscript
    ## file and be viewed later.  Include the lines
    /* required gsoptions for batch files */
    /* comment out these lines for interactive use on X-terminals*/
    filename grafout 'temp.ps';
    goptions device=ps gsfname=grafout gsfmode=append gaccess=sasgastd;
    ## in myfile.sas.

    ## PROC PLOT graphs can be viewed in the listing buffer.  You may
    ## wish to control the vertical spacing to allow the entire plot
    ## to be visible on screen, for example, by
    proc plot; plot a*b / vpos=25;

    ## At the end of the session you may save the log and listing
    ## buffers with the usual C-x C-s commands.  You will be prompted
    ## for a file name.  Typically, the names myfile.log and mfile.lst
    ## will be used.  You will almost certainly want to edit the saved
    ## files before including them in a report.  The files are
    ## read-only by default.  You can make them writable by the Emacs
    ## command C-x C-q.

    ## At the end of the session, the input file myfile.sas will
    ## typically have been revised.  You can save it.  It can be used
    ## later as the beginning of another iESS[SAS] session.  It can
    ## also be used as a batch input file to SAS.

    ## The *SAS:1* buffer is strictly for ESS use.  The user should
    ## never need to read it or write to it.  Refer to the .lst and
    ## .log buffers for monitoring output!


Here is a typical myfile.sas:

    title 'Analysis of Case 0502';

    data case0502;
        infile '/home/public/stat/Data/case0502.asc'
               firstobs=2;
        input percent code;
    run;

    proc glm;
      class code;
      model percent=code /ss1;
    run;



Recommended autoexec.sas
========================

The default settings of the inferior-SAS-args in essd-sas.el
are "-stdio -linesize 80 -noovp -nosyntaxcheck"
with the interpretations:
  -stdio          required to make the redirection of stdio work
  -linesize 80    keeps output lines from folding on standard terminals
  -noovp          prevents error messages from printing 3 times
  -nosyntaxcheck  permits recovery after syntax errors

In addition there are several parameters that can't be set in the
command line.  For these, we recommend the following line appear in
your autoexec.sas in your home directory:

  options noovp pagesize=60 linesize=80 formdlim=' ';

Interpretations

  noovp          prevents error messages from printing 3 time
  pagesize=60    standard printed page length instead of window length
  linesize=80    keeps output lines from folding on standard terminals
  formdlim=' '   blank replaces "C-l" formfeeds to prevent mostly
                 empty pages

The noovp and linesize=80 appear in both the inferior-SAS-args and in
the autoexec.sas.  The redundancy means that these options are in
effect for SAS batch usage and SAS window manager usage as well as for
ESS[SAS] usage.



Using Transcripts
=================

Not yet available.  The intent is that a marked section of a log file
from a previous SAS run can be resubmitted to SAS.  The user would
highlight a region from 'PROC' to 'RUN;' and then send it to the
inferior SAS process with the [RET] key.  ESS would automatically
clean the region (remove line numbers) and send the entire region over
as a single request to SAS.


Design Philosophy
=================

ESS[SAS] mode was designed to aid the user in writing and maintaining
input command files, such as myfile.sas, for SAS.  These are files
containing SAS statements.  In a batch environment such files would be
submitted to SAS by the operating system command:
    sas myfile.sas
In a SAS window environment, these files would be brought into the
"SAS: PROGRAM EDITOR" window and then submitted with the 'Local' 'Submit'
menu commands.

The *SAS:1.log* buffer in ESStr mode corresponds to the file
myfile.log in SAS batch usage and to the "SAS: LOG" window in the SAS
window environment.  All commands submitted to SAS, informative
messages, warnings, and errors appear here.

The *SAS:1.lst* buffer in ESSlst mode corresponds to the file
myfile.lst in SAS batch usage and to the "SAS: OUTPUT" window in the
SAS window environment.  All data related printed output from the
PROCs appear in this window.

The iESS [SAS:1] buffer exists solely as a communications buffer.
Files are edited in the myfile.sas buffer.  The C-c C-r key in
ESS[SAS] mode is the functional equivalent of bringing a file into the
"SAS: PROGRAM EDITOR" window followed by the 'Local' 'Submit' menu
commands.  The user should never use this buffer directly.


The ESS[SAS] mode was written with two primary goals.

1. Using Emacs, a window environment becomes available for dial-up
users who do not have access to the SAS window environment.

2. The authors prefer the Emacs environment for editing and managing
input and output files, even on computer systems which run the SAS
window environment.

A secondary goal was also realized.

3.  With an X-windows terminal connected by ppp at 14400 baud to a
Unix system running SAS, iESS[SAS] interaction with SAS was hundreds
of times faster than the SAS window system.  The savings come because
the ESS windows are subunits of a text-based xterm window, rather than
the remotely managed graphical windows provided by SAS.  (The timings
are SAS timings from the log files.  The SAS windows times include
window management and communications times as well as calculation
times.  The iESS times include only the calculations by the SAS
computing engine.)


Some Frequently Seen Problems
=============================

1. If M-x SAS gives weird errors upon startup, check the following:
   - ess-sas-sh-command (in the ESS source directory) needs to be
     executable (solution: "chmod ugo+rx ess-sas-sh-command").
   - sas isn't in your executable path (verify using "which sas" from
     a shell command-line)
   - you need a copy of SAS (we can't solve this)

2. M-x SAS starts up SAS in the window system (motif, for example),
   instead of starting it up in the emacs buffers.

   Probably the unix command "sas" on your system calls a local
   script which in turn calls the sas executable.  The fix is to
   call the sas executable directly.

   Change the line in ess-sas-sh command from:
      sas </dev/tty 1>$stdout 2>$stderr $@
   to a call to the complete path name of the sas executable on
   your system, for example:
      /usr/local/sas612/sas </dev/tty 1>$stdout 2>$stderr $@

   To find the complete path name on your system, you can
   execute the line (from the unix prompt):
      find / -name 'sas' -exec ls -ld {} \;
   and expect a response similar to the following
   -rwxr-xr-x   1 sas      sas  2441216 Sep  9  1997 /usr/local/sas612/sas
