/*
 *
 *   Copyright (c) International Business Machines  Corp., 2000
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: segoptions.h
 *
 */

#ifndef   SEG_OPTIONS_HEADER
#define   SEG_OPTIONS_HEADER 1


//
// Create Option Info
//
#define SEG_CREATE_OPTION_COUNT                     9

#define SEG_CREATE_OPTION_SIZE_INDEX                0
#define SEG_CREATE_OPTION_SIZE_NAME                 "Size"
#define SEG_CREATE_OPTION_OFFSET_INDEX              1
#define SEG_CREATE_OPTION_OFFSET_NAME               "Offset"
#define SEG_CREATE_OPTION_TYPENAME_INDEX            2
#define SEG_CREATE_OPTION_TYPENAME_NAME             "TypeByName"
#define SEG_CREATE_OPTION_TYPE_INDEX                3
#define SEG_CREATE_OPTION_TYPE_NAME                 "TypeByNumber"
#define SEG_CREATE_OPTION_BOOTABLE_INDEX            4
#define SEG_CREATE_OPTION_BOOTABLE_NAME             "Bootable"
#define SEG_CREATE_OPTION_PRIMARY_PARTITION_INDEX   5
#define SEG_CREATE_OPTION_PRIMARY_PARTITION_NAME    "Primary"
#define SEG_CREATE_OPTION_PARTITIONNAME_INDEX       6
#define SEG_CREATE_OPTION_PARTITIONNAME_NAME        "PartitionName"
#define SEG_CREATE_OPTION_VOLUMENAME_INDEX          7
#define SEG_CREATE_OPTION_VOLUMENAME_NAME           "VolumeName"
#define SEG_CREATE_OPTION_DRIVELETTER_INDEX         8
#define SEG_CREATE_OPTION_DRIVELETTER_NAME          "DriveLetter"

#define MAX_TYPENAME_SIZE                           128
#define OTHER_TYPENAME                              "Other Partition Type"

struct seg_partition_type_info_s {
    char *name;
    int   number;
};

struct disk_type_info_s {
    char *name;
};

//
// Assign Option Info
//
#define SEG_ASSIGN_OPTION_COUNT                     2

#define SEG_ASSIGN_OPTION_TYPENAME_INDEX            0
#define SEG_ASSIGN_OPTION_TYPENAME_NAME             "DiskType"

#define SEG_ASSIGN_OPTION_DISKNAME_INDEX            1
#define SEG_ASSIGN_OPTION_DISKNAME_NAME             "DiskName"



//
// Expand Option Info
//
#define SEG_EXPAND_OPTION_COUNT                     1

#define SEG_EXPAND_OPTION_SIZE_INDEX                0
#define SEG_EXPAND_OPTION_SIZE_NAME                 "Size"



//
//   Shrink Option Info
//
#define SEG_SHRINK_OPTION_COUNT                     1

#define SEG_SHRINK_OPTION_SIZE_INDEX                0
#define SEG_SHRINK_OPTION_SIZE_NAME                 "Size"


// 
//  Seg Info
//
#define SEG_INFO_COUNT            12
#define SEG_INFO_NAME_INDEX       0
#define SEG_INFO_SIZE_INDEX       1
#define SEG_INFO_START_INDEX      2
#define SEG_INFO_FLAGS_INDEX      3
#define SEG_INFO_TYPE_INDEX       4
 
#define SEG_INFO_SLICE_INDEX      5
#define SEG_INFO_TAG_INDEX        6

#define SEG_INFO_BOOT_INDEX       SEG_INFO_SLICE_INDEX
#define SEG_INFO_DSKNAME_INDEX    SEG_INFO_TAG_INDEX
#define SEG_INFO_PNAME_INDEX      7
#define SEG_INFO_VNAME_INDEX      8
#define SEG_INFO_DRVLTR_INDEX     9
#define SEG_INFO_VSN_INDEX       10
#define SEG_INFO_PSN_INDEX       11



// 
//  Plugin Info
//
#define SEG_PLUGIN_INFO_COUNT             5
#define SEG_PLUGIN_INFO_SNAME_INDEX       0
#define SEG_PLUGIN_INFO_LNAME_INDEX       1
#define SEG_PLUGIN_INFO_TYPE_INDEX        2
#define SEG_PLUGIN_INFO_VERSION_INDEX     3
#define SEG_PLUGIN_INFO_REQVERSION_INDEX  4



int         SEG_GetOptionCount(task_context_t * task);

int         SEG_InitTask(task_context_t * context);

int         SEG_SetOption( task_context_t * context, u_int32_t index, value_t * value, u_int32_t * info );

int         SEG_GetInfo( storage_object_t  * object, char * name,  extended_info_array_t * * info);

int         SEG_GetPluginInfo( char * descriptor_name, extended_info_array_t * * info );

int         SEG_SetObjects( task_context_t * context,
                            dlist_t          declined_objects,
                            task_effect_t  * effect );
#endif

