/*
 *
 *   Copyright (c) International Business Machines  Corp., 2000
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: snapshot
 *
 */
 
#ifndef SNAPSHOT_HEADER
#define SNAPSHOT_HEADER

//extern engine_functions_t        *EngFncs;

                        
int             PluginInit( plugin_record_t *pPlugRec );
void            PluginCleanup(plugin_record_t *pPlugRec);
extern          plugin_record_t                *my_plugin_rec;


// Log message macros
#define LOG_CRITICAL(msg, args...)	EngFncs->write_log_entry(CRITICAL,	my_plugin_rec, "%s: " msg, __FUNCTION__ , ## args)
#define LOG_SERIOUS(msg, args...)	EngFncs->write_log_entry(SERIOUS,	my_plugin_rec, "%s: " msg, __FUNCTION__ , ## args)
#define LOG_ERROR(msg, args...)		EngFncs->write_log_entry(ERROR,		my_plugin_rec, "%s: " msg, __FUNCTION__ , ## args)
#define LOG_WARNING(msg, args...)	EngFncs->write_log_entry(WARNING,	my_plugin_rec, "%s: " msg, __FUNCTION__ , ## args)
#define LOG(msg, args...)		EngFncs->write_log_entry(DEFAULT,	my_plugin_rec, "%s: " msg, __FUNCTION__ , ## args)
#define LOG_DETAILS(msg, args...)	EngFncs->write_log_entry(DETAILS,	my_plugin_rec, "%s: " msg, __FUNCTION__ , ## args)
#define LOG_DEBUG(msg, args...)		EngFncs->write_log_entry(DEBUG,		my_plugin_rec, "%s: " msg, __FUNCTION__ , ## args)
#define LOG_EXTRA(msg, args...)		EngFncs->write_log_entry(EXTRA,		my_plugin_rec, "%s: " msg, __FUNCTION__ , ## args)
#define LOG_PROC(msg, args...)		EngFncs->write_log_entry(ENTRY_EXIT,	my_plugin_rec, "%s: " msg, __FUNCTION__ , ## args)
#define LOG_EVERYTHING(msg, args...)	EngFncs->write_log_entry(EVERYTHING,	my_plugin_rec, "%s: " msg, __FUNCTION__ , ## args)

#define SET_STRING(a,b) a = EngFncs->engine_alloc( strlen(b)+1 );if (a ) { strcpy(a, b); } else { rc = ENOMEM; LOG_EXIT(rc);}

#define	LOG_ENTRY		LOG_PROC("Entering\n")
#define LOG_EXIT(x) 		LOG_PROC("Exiting: rc = %d\n", x)
#define RETURN(x)		{LOG_EXIT(x); return(x);}
#endif
