/*
 *
 *   (C) Copyright IBM Corp. 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libmac.so
 *
 *   File: mac_plugin.c
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include <plugin.h>

#include "mac_plugin.h"

/*-------------------------------------------------------------------------------------+
+                                                                                      +
+                         PRIVATE DATA AREAS AND SUBROUTINES                           +
+                                                                                      +
+-------------------------------------------------------------------------------------*/

static plugin_record_t          mac_plugin_record;

plugin_record_t                *mac_plugin = &mac_plugin_record;

struct engine_functions_s      *EngFncs=NULL;


/*-------------------------------------------------------------------------------------+
+                                                                                      +
+                          Plugin Setup and Cleanup Functions                          +
+                                                                                      +
+--------------------------------------------------------------------------------------*/
static int mac_setup( engine_functions_t * engine_functions )
{
        int rc = EINVAL;

        if (engine_functions) {
                engine_functions->write_log_entry( ENTRY_EXIT,
                                                   mac_plugin,
                                                   "mac_setup: entry\n");
                EngFncs = engine_functions;
                rc = 0;
        }

        LOG_EXIT_INT(rc);
        return rc;
}

static void mac_cleanup(void)
{
        LOG_ENTRY();

        delete_all_mac_segment_private_data();
        delete_all_mac_disk_private_data();

        LOG_EXIT_VOID();
}

/*-------------------------------------------------------------------------------------+
+                                                                                      +
+                              PLUGIN FUNCTION TABLE                                   +
+                                                                                      +
+--------------------------------------------------------------------------------------*/
static struct plugin_functions_s mac_plugin_functions = {
        setup_evms_plugin:              mac_setup,
        cleanup_evms_plugin:            mac_cleanup,
        can_set_volume:                 mac_can_set_volume,
        can_delete:                     mac_can_delete,
        discover:                       mac_discover,
        can_unassign:                   mac_can_unassign,
        unassign:                       mac_unassign,
        delete:                         mac_destroy,
        discard:                        mac_discard,
        add_sectors_to_kill_list:       mac_add_sectors_to_kill_list,
        commit_changes:                 mac_commit_changes,
        read:                           mac_read,
        write:                          mac_write,
        set_volume:                     mac_set_volume,
        get_info:                       mac_get_info,
        get_plugin_info:                mac_get_plugin_info,
        can_activate:                   mac_can_activate,
        activate:                       mac_activate,
        can_deactivate:                 mac_can_deactivate,
        deactivate:                     mac_deactivate,
        backup_metadata:                mac_backup_metadata,
};


/*-------------------------------------------------------------------------------------+
+                                                                                      +
+                       BUILD AND EXPORT AN EVMS PLUGIN RECORD                         +
+                                                                                      +
+--------------------------------------------------------------------------------------*/

static plugin_record_t mac_plugin_record = {

        id:                                 SetPluginID(EVMS_OEM_IBM, EVMS_SEGMENT_MANAGER, 8 ),

        version:                            {MAJOR_VERSION, MINOR_VERSION, PATCH_LEVEL},

        required_engine_api_version:        {15,0,0},
        required_plugin_api_version:        {plugin: {13,1,0}},

        short_name:                         "MAC",
        long_name:                          "MAC Segment Manager",
        oem_name:                           "IBM",

        functions:                          {plugin: &mac_plugin_functions},

};

// Vector of plugin record ptrs that we export for the EVMS Engine.
plugin_record_t *evms_plugin_records[] = {
        &mac_plugin_record,
        NULL
};


