/*
 * (C) Copyright IBM Corp. 2001, 2003
 *
 * This program is free software;  you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 * the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program;  if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: plugins/bbr_seg/options.h
 */

#ifndef BBR_OPTIONS_HEADER
#define BBR_OPTIONS_HEADER 1

/*
 * Create Option Info
 */
#define BBR_OPTION_COUNT 0

/* 
 *  BBR Info
 */
#define BBR_INFO_COUNT		6

#define BBR_INFO_NAME_INDEX	0
#define BBR_INFO_UUID_INDEX	1                                        
#define BBR_INFO_SIZE_INDEX	2
#define BBR_INFO_BLKS_INDEX	3
#define BBR_INFO_BLKSZ_INDEX	4
#define BBR_INFO_TBLSZ_INDEX	5
                                        
/* 
 *  Plugin Info
 */
#define BBR_PLUGIN_INFO_COUNT			6

#define BBR_PLUGIN_INFO_SNAME_INDEX		0
#define BBR_PLUGIN_INFO_LNAME_INDEX		1
#define BBR_PLUGIN_INFO_TYPE_INDEX		2
#define BBR_PLUGIN_INFO_VERSION_INDEX		3
#define BBR_PLUGIN_INFO_REQENGSVCVERSION_INDEX	4
#define BBR_PLUGIN_INFO_REQPLUGAPIVERSION_INDEX	5

extern int get_acceptable_create_objects(task_context_t *context);
extern int bbr_get_info(storage_object_t *object, char *name,
			extended_info_array_t **info);
extern int bbr_get_plugin_info(char *descriptor_name, extended_info_array_t **info);

#endif

