/*
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __SNAP_OPTIONS_H__
#define __SNAP_OPTIONS_H__ 1

/* Option definitions */
#define SNAP_OPTION_ORG_VOLUME_NAME	"original"
#define SNAP_OPTION_ORG_VOLUME_INDEX	0
#define SNAP_OPTION_SNAPSHOT_NAME	"snapshot"
#define SNAP_OPTION_SNAPSHOT_INDEX	1
#define SNAP_OPTION_CHUNKSIZE_NAME	"chunksize"
#define SNAP_OPTION_CHUNKSIZE_INDEX	2
#define SNAP_OPTION_WRITEABLE_NAME	"writeable"
#define SNAP_OPTION_WRITEABLE_INDEX	3

/* Plug-in functions. */
#define SNAPSHOT_FUNCTION_RESET		(EVMS_Task_Plugin_Function + 0)
#define SNAPSHOT_FUNCTION_ROLLBACK	(EVMS_Task_Plugin_Function + 1)
#define SNAPSHOT_FUNCTION_COUNT		2

extern void parse_creation_options(option_array_t * options,
				   char ** org_vol_name,
				   char ** snap_name,
				   u_int32_t * chunk_size,
				   int * writeable);
extern int verify_creation_options(char * org_vol_name,
				   char * snap_name,
				   u_int32_t chunk_size,
				   storage_object_t * snap_child);
extern int init_task_create(task_context_t * context);
extern int set_option_create(task_context_t * context,
			     u_int32_t index,
			     value_t * value,
			     task_effect_t * effect);
extern int set_objects_create(task_context_t * context,
			      list_anchor_t declined_objects,
			      task_effect_t * effect);

#endif

