#ifndef POLYH
#define POLYH

#define MAX_POLY_TERMS 5
#define REAL double
#define MAXIT 100
#define MIN_ERROR 0.00001

typedef struct _polynomial_ {
     int terms;
     REAL coeff[MAX_POLY_TERMS];
} polynomial;

typedef polynomial* poly_matrix;

void poly_add(polynomial *, polynomial *, polynomial *);
void poly_eval(polynomial *, REAL, REAL *, REAL *);
void poly_times(polynomial *, polynomial *, polynomial *);
void poly_add(polynomial *, polynomial *, polynomial *);
polynomial* make_poly_2(REAL, REAL);
void poly_sub(polynomial *, polynomial *, polynomial *);
void poly_print(polynomial *);
void poly_determinant(poly_matrix **, int, polynomial *);
poly_matrix **dpoly_matrix(int, int, int, int);
void free_poly_matrix(poly_matrix **);
REAL rtsafe(polynomial *, REAL, REAL, REAL);

#endif /* POLYH */
