/* This file is part of MemMXtest
 * Copyright (C) 1999, 2000  J.A. Bezemer
 * Parts copyright (C) 1995  Chris Brady
 * This program is licensed under the GNU General Public License,
 * see the top-level README file for details.  
 */

/* defines.h - MemMXtest defines */


/* Choose the serial device */
/* 0x03f8 = COM1, 0x02f8 = COM2 */
#define SERIAL_ADR	0x02f8

/* Ifdef SERIAL_SEND_CRLF, then 0x13 is sent after 0x10. Else only 0x10. */
#define noSERIAL_SEND_CRLF

/* Go to command mode before actual testing starts */
#define INITIAL_COMMAND_MODE  0		/* 0 = no, 1 = yes */

/* What memory region should be tested? */
/* 1. Force region. */
#define FORCE_MEM_START	0x0
#define FORCE_MEM_END	0x0

/* 2. If FORCE_MEM_START == 0, then autodetect. Start at this adress: */
/*#define AUTODETECT_START  TESTADR+TESTSZ+UDATASZ  / * Right after code */
#define AUTODETECT_START    0x100000	/* 1 MB */

/* ... but skip this region: */
#define SKIP_START	0xa0000		/* This is the screen/bios area */
#define SKIP_END	0x100000	/* that should not be tested */

/* 3. Manual override before testing starts: set WAIT_FOR_PARAMETERS to 1;
   then use `m'. This will still auto-detect. In case autodetection is not
   allowed, set FORCE_MEM_START to something != 0. */

/* The "standard" delay for tests like March-G and March-UD, in seconds */
#define STD_DELAY	2

/* APM (if available) will blank monitor. We can prevent this. */
#define APM_OFF				/* APM_ON leaves APM on */

/* The screen memory and size */
#define SCREEN_ADR	0xb8000		/* Start of screen memory */
#define SCREEN_COLS	80		/* #columns on screen */
#define SCREEN_ROWS	25		/* #rows on screen */

/* The place and size of code and data */
/* Caution!! Do not change TESTADR or CODESZ without also
   editing the Makefile. (You'll get an error...) */
#define TESTADR		0x1000		/* Final adrs for the test code */
#define CODESZ		0xE000		/* Size of code (".text"+".rodata") */
#define DATASZ		0x1000		/* Size of initialized data (".data") */
#define UDATASZ		0x50000		/* Size of uninit'd data (".bss") */
#define TESTSZ		CODESZ+DATASZ	/* Total size of test */
#define TESTSZ2		0xF000		/* Same but pre-calculated. MUST
					   MATCH TESTSZ! */

/* Bootup stuff */
#define SETUPSECS	4		/* Number of setup sectors */
#define BOOTSEG		0x07c0		/* Segment adrs for inital boot */
#define INITSEG		0x9000		/* Segment adrs for relocated boot */
#define SETUPSEG	INITSEG+0x20	/* Segment adrs for relocated setup */
#define TESTSEG		TESTADR/0x10	/* Final segment adrs for test code */
#define TSTLOAD		0x1000		/* Segment adrs for load of test */
#define KERNEL_CS	0x10		/* 32 bit segment adrs for code */
#define KERNEL_DS	0x18		/* 32 bit segment adrs for data */

/* Passing parameters to the machine-language routines; increase when needed */
#define MAX_PARAMS	16		/* Num of (long) params to pass to/
					   get from routines */
/*  Commonly used parameters have standard numbers/names */
#define P_CONDITION     0		/* Conditional jump: jbe or jae */
#define P_UPADRCODE	1		/* Start of real update_adr code */
#define P_UPADRLEN	2		/* Length " */
#define P_UPADRCODEPRE	3		/* Start of pre-test update_adr code */
#define P_UPADRLENPRE	4		/* Length " */
#define P_POSPATTERNU	5		/* Pattern for p, bits 63-32 */
#define P_POSPATTERNL	6		/* Pattern for p, bits 31-0 */
#define P_NEGPATTERNU	7		/* Pattern for p-inverted, 63-32 */
#define P_NEGPATTERNL	8		/* Pattern for p-inverted, 31-0 */
#define P_CACHEMODE	9		/* Cache mode */
#define P_PSEUDORMASKU	10		/* Pseudo-random XOR mask, 63-32 */
#define P_PSEUDORMASKL	11		/* Pseudo-random XOR mask, 31-0 */

#define P_CACHEMODE_ON	 0		/* Full caching */
#define P_CACHEMODE_OFF	 1		/* No caching */
#define P_CACHEMODE_HALF 2		/* Code cached, data not cached */

#define P_CONDITION_UP   0x76		/* Conditional jump for counting */
#define P_CONDITION_DOWN 0x73		/* up and down: jbe and jae */

#define MAX_ERRORS	1024		/* #longs reserved for reporting
					   errors */
/* Note: one error consumes several longs (could even be test-dependent);
   if there are too much errors, they will not be logged but still counted. */

#define PSEUDOR_DATA_SIZE  16*1024*8	/* Room for 16k 64-bit PR values.
					   Should be power of 2.
					   32k values is largest possible
					   (256 kB). Size is in bytes. */

/* For max. randomness in data, we can shift for example 64 bits at a time.
   Change to PR_SHIFTMOREBITS64 to include support for this. */
#define noPR_SHIFTMOREBITS64
#define PR_SHIFTBITSNO64    64		/* #bits to shift when shifting more */

/* The XOR-mask for the 64-bit pseudo-random generator */
#define PR_XORMASK64	0x3000000008000001ULL

/* Define 5 possible adress-bit schemes, with initial contents.
   A map starting with 0xFF is ignored. */
#define MAX_ADRBITMAPS	5
#define EMPTYADRBITMAP							\
  {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,			\
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,			\
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,			\
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF}
#define ADRBITMAP_LIST_INIT {						\
  {3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27, \
   28,29,30,31,0xFF,0xFF,0xFF},						\
  EMPTYADRBITMAP, EMPTYADRBITMAP, EMPTYADRBITMAP, EMPTYADRBITMAP }

/* "Pre"-test parameters for filling the caches. We use a memory area just
   below 640 kB (= 0xa0000) */
#define PRETEST_START	0x9f000
#define PRETEST_END	0xa0000 - 8
#define PRETEST_ADRMAP							\
 {6, 7, 8, 9, 10, 3, 4, 5,						\
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,			\
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,			\
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF}

/* From update_adr.c, see also mtest.h */
#define ADRCODE_LEN 1024

