/**
 * IceMC - a menu editor for IceWM
 * Copyright (c) 2000 Georg Mittendorfer
 */

// implementation of CLASS IceMenuScanner

// created:       mig 000720
// last modified: mig 000809
// changes:       ----------
#include <limits.h>
#include "IceMenuInCompiler.h"

//////////////////////////////////////////////////////////////////
// constructor & destructor
//////////////////////////////////////////////////////////////////

IceMenuScanner::IceMenuScanner()
{
  ;//qDebug("IceMenuScanner::IceMenuScanner()");
  sy = noSy;
  lnr = 1;
  synr = 1;

  src = new QFile();
  srcStream = new QTextStream();
}

IceMenuScanner::IceMenuScanner(const QString filePath) 
{ 
  ;//qDebug("IceMenuScanner::IceMenuScanner(const QString filePath)");
  sy = noSy;
  lnr = 1;
  synr = 1;

  src = new QFile();
  srcStream = new QTextStream();

  setFile(filePath);
}

IceMenuScanner::~IceMenuScanner()
{
  ;//qDebug("IceMenuScanner::~IceMenuScanner()");
  src->close();
  ;//qDebug("IceMenuScanner::~IceMenuScanner() file closed");
  delete srcStream;
  delete src;
}

//////////////////////////////////////////////////////////////////
// public methods
//////////////////////////////////////////////////////////////////

void IceMenuScanner::setFile(const QString filePath)
{
  src->setName(filePath);
  sy = noSy;
  lnr = 1;
  synr = 1;
  if (src->isOpen())
    src->close();
  src->open(IO_ReadOnly); // IO_Translate?
  if (!src->exists()) {
    qFatal("FATAL: IceMenuScanner::setFile(...) => file not found: " + filePath);
  }
  srcStream->setDevice(src);
  srcLine = srcStream->readLine();
  ch = ' ';
}

IceMenuScanner::symbolCode IceMenuScanner::newSy()
{
  /* note: handles '#' as eol (everything between "..." is handled extra in switch construct) */
  while (isspace(ch) && (ch != '\n') && (ch != '#')) {
    ch = newChar();
  }
  switch (ch) {
  case 0:
    sy = eofSy;
    //    cout << "eof\n\n";
    // ch = newChar();
    break;
  case '#':
    sy = eolSy;
    synr = UINT_MAX;
    // cout << "# (eol)\n";
  case '\n':
    sy = eolSy;
    //    cout << "eol\n";
    ch = newChar();
    break;
  case '{':
    sy = lBraceSy;
    //    cout << '{';
    ch = newChar();
    break;
  case '}':
    sy = rBraceSy;
    //    cout << '}';
    ch = newChar();
    break;
  case '"':
    // every expression enclosed between two quotes is also an identstring
    // i think the IceWM Parser works like this (but i didn't have a closer look)
    ch = newChar();
    identStr = "";
    while ((ch != '"') && (ch!=0)) {
      identStr += ch;
      ch = newChar();
    }
    ch = newChar();
    //    cout << '"' + identStr + '"';
    sy = quotedIdentSy;
    break;
  default:
    if (!isgraph(ch)) { // isgraph == isalnum || ispunct
      sy = noSy;
      qWarning("WARNING: IceMenuScanner::newSy() -> *** not a valid Symbol! ***");
      identStr = "";
    } else {
      identStr = "";
      while ((!isspace(ch)) && (ch!=0) && (ch!='"')) {
 	identStr += ch;
	ch = newChar();
      }
      //      cout << identStr;
      if (identStr == "prog")
	sy = progSy;
      else if (identStr ==  "menu")
	sy = menuSy;
      else if (identStr ==  "separator")
	sy = separatorSy;
      else if (identStr ==  "restart")
	sy = restartSy;
      else
	sy = identSy;
      break;
    }
  }
  //  cout << " ";
  return sy;
};

QString IceMenuScanner::getIdentStr() const
{ 
  return identStr;
}

///////////////////////////////////////////////////////////
// private methods
///////////////////////////////////////////////////////////

QChar IceMenuScanner::newChar()
{
  QChar ch;

  if (srcLine.length() >= synr) {
    ch = srcLine[synr-1];
    synr++;
  } 
  else if (!srcStream->atEnd()) {
    srcLine = srcStream->readLine();
    synr = 1;
    lnr++;
    ch = '\n';
  } 
  else
    ch = 0;

return ch;
}

void IceMenuScanner::getActPos(int& line, int& sy)
{
  line = lnr;
  sy = int(synr);
}












