/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IPALETTE_H
#define IPALETTE_H


#include "icolor.h"
#include "istring.h"

class iImage;
class iPaletteSet;
class iPiecewiseFunction;

class vtkColorTransferFunction;
class vtkLookupTable;


class iPalette 
{
	
	friend class iPaletteSet;

public:
	
	iPalette();
	~iPalette();
	
	inline const iString& GetName() const { return mName; }
	void SetName(const iString &n) { mName = n; }

	iColor GetColor(int n) const;
	inline const iPiecewiseFunction* GetRedComponent() const { return mFun[0]; } 
	inline const iPiecewiseFunction* GetGreenComponent() const { return mFun[1]; } 
	inline const iPiecewiseFunction* GetBlueComponent() const { return mFun[2]; } 

	void SetComponents(const iPiecewiseFunction *r, const iPiecewiseFunction *g, const iPiecewiseFunction *b);

	void Copy(iPalette *p);

	const iImage* GetImage();

	//
	//  For direct editing - use with care as this function requires an explicit call to Update();
	//
	inline iPiecewiseFunction** GetComponents() { return mFun; }
	inline iPiecewiseFunction* GetComponent(int n) { return (n>=0 && n<3) ? mFun[n] : 0; }
	inline const iPiecewiseFunction* const * GetComponents() const { return mFun; }

	void Update();

private:
	
	inline vtkLookupTable* GetLookupTable(bool reverse) const { return mLT[reverse?1:0]; }
	inline vtkColorTransferFunction* GetColorTransferFunction(bool reverse) const { return mCTF[reverse?1:0]; }

	iString mName;
	iPiecewiseFunction *mFun[3];
	vtkColorTransferFunction *mCTF[2];
	vtkLookupTable *mLT[2];

	int mImageWidth, mImageHeight;
	bool mImageNeedsUpdate;
	iImage *mImage;
};

#endif // IPALETTE_H
