/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#if ISHELL_INCLUDED(ISHELL_QT)


#include "iqtwidgetcolorselectionsubject.h"


#include "icolor.h"
#include "ierror.h"

#include "iggwidget.h"

#include "ibgframesubject.h"

#include "iqthelper.h"
#include "iqtwidgethelper.h"

#ifdef IQT_3
#include <qcolordialog.h>
#include <qframe.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#else
#include <QtGui/QColorDialog>
#include <QtGui/QFrame>
#include <QtGui/QGridLayout>
#include <QtGui/QLabel>
#include <QtGui/QPushButton>
#endif


iqtWidgetColorSelectionSubject::iqtWidgetColorSelectionSubject(iggWidget *owner, bool horizontal) : QWidget(iqtHelper::Convert(owner->GetParent())), ibgWidgetColorSelectionSubject(owner,horizontal)
{
	mWidgetHelper = new iqtWidgetHelper(this,owner); IERROR_ASSERT(mWidgetHelper);

	//
	//  Create a layout
	//
	if(this->layout() != 0) delete this->layout();
	QGridLayout *l;
	if(horizontal) l = iqtHelper::NewLayout(this,2); else
	{
		l = iqtHelper::NewLayout(this,1);
#ifdef IQT_3
		l->expand(3,1);
#endif
	}

	mLabel = new QLabel(this);
	mLabel->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	mLabel->setLineWidth(2);
#ifndef IQT_3
#ifndef IQT_40
	mLabel->setAutoFillBackground(true);
#endif
#endif
	mLabel->setScaledContents(true);
	mLabel->setMinimumSize(24,24);
	if(horizontal)
	{
		l->addWidget(mLabel,0,0);
	}
	else
	{
		l->addWidget(mLabel,1,0);
		l->setRowStretch(0,10);
	}

	mButton = new QPushButton(this);
	mButton->setText("Color");
	if(horizontal) l->addWidget(mButton,0,1); else l->addWidget(mButton,2,0);

	this->setSizePolicy(QSizePolicy(QSizePolicy::Minimum,QSizePolicy::Minimum));

	if(!this->connect(mButton,SIGNAL(clicked()),iDynamicCast<iqtWidgetHelper,ibgWidgetHelper>(INFO,mWidgetHelper),SLOT(OnVoid1()))) IERROR_LOW("Missed connection.");
}


iqtWidgetColorSelectionSubject::~iqtWidgetColorSelectionSubject()
{
}


const iColor iqtWidgetColorSelectionSubject::GetColor() const
{
#ifdef IQT_3
	QColor c0 = mLabel->paletteBackgroundColor();
#else
	QColor c0 = mLabel->palette().color(mLabel->backgroundRole());
#endif

	QColor c = QColorDialog::getColor(c0); 
	if(c.isValid())
	{
		iqtHelper::SetBackground(mLabel,c);
	}
	else c = c0;
	return iqtHelper::Convert(c);
}


void iqtWidgetColorSelectionSubject::SetColor(const iColor &v)
{
	iqtHelper::SetBackground(mLabel,iqtHelper::Convert(v));
}

	
void iqtWidgetColorSelectionSubject::SetText(const iString &text)
{
	mButton->setText(iqtHelper::ConvertWithModifiers(mButton,text));
}

#endif
