<?php
/*
  
  File: view.php3
  $Author: chuck $
  $Revision: 2.8.2.27 $
  $Date: 2001/02/28 05:47:59 $
  
  IMP: Copyright 1998, 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
  
  You should have received a copy of the GNU Public
  License along with this package; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
  
*/

require '../lib/horde.lib';
require './lib/imp.lib';           /* IMPlib is the IMP function library  */
require './lib/mimetypes.lib';     /* Mime functions */
require './config/defaults.php3';  /* Defaults configuration file */
require './config/lang.php3';
require './config/html.php3';
require './config/mime.php3';

$language = select_lang();
require './lib/postconf.php3';
$lang = new HordeLocaleLang();
$this_client = new WebClient;

error_reporting($default->error_level);  /* set error level from imp.lib   */

// NOTE: this check for safe_mode will only work if safe_mode is enabled
// in the PHP .ini file; get_cfg_var() doesn't read PHP variables set in
// the Apache configuration files.
if (!get_cfg_var('safe_mode')) {
  set_time_limit($default->max_execution_time);
}

if ($this_client->workaround_broken_ie_download) {
  page_open(array('sess' => 'HordeSessionCached'));
} else {
  page_open(array('sess' => 'HordeSession'));
}
  
page_close();
if (!isset($imp) || !is_object($imp)) {
    header("Location: login.php3?reason=logout");
    exit;
}
$imp->unpickle();
$imp->authenticate();

$structure = imap_fetchstructure($imp->stream, $index, FT_UID);
$foo = false;
$attachments = MimeParseStructure($structure, '', $foo);
if (!isset($actionID)) $actionID = NO_ACTION;
if (($actionID != SAVE_MESSAGE) && ($actionID != VIEW_SOURCE)) {
  $mime = $attachments[$bodypart];
  mimeParse($mime);
}

/* Run through action handlers */
switch ($actionID) {
 case NO_ACTION:
	 break;
	 
 case DOWNLOAD_ATTACH:
	 header("Content-Type: application/x-unknown-$mime->TYPE-$mime->SUBTYPE");    /* This should force a save file dialog...  */
     if ($this_client->broken_disposition) {
         header('Content-Disposition: filename=' . decode_mime_string($mime->name));
     } else {
         header('Content-Disposition: attachment; filename=' . decode_mime_string($mime->name));
     }
	 break;
	 
 case VIEW_ATTACH:
	 if (isset($mime->conf['view_function'])) {
		 header('Content-Type: text/html');
		 header('Content-Disposition: inline; filename=' . decode_mime_string($mime->name));
		 $func = $mime->conf['view_function'];
		 echo $func($mime);
		 exit;
	 }
	 
	 header("Content-Type: $mime->TYPE/$mime->SUBTYPE");
     header('Content-Disposition: inline; filename=' . decode_mime_string($mime->name));
	 break;
	 
 case VIEW_SOURCE:
	 $msg = imap_fetchheader($imp->stream, $index, FT_UID) . "\n" . imap_body($imp->stream, $index, FT_UID);
	 header('Content-Type: text/plain');
	 header('Content-Disposition: inline; filename="Message Source"');
	 header('Content-Length: ' . strlen($msg));
	 echo $msg;
	 exit; 
	 break;
	 
 case SAVE_MESSAGE:
	 $h = imap_header($imp->stream, imap_msgno($imp->stream, $index));
	 if (!empty($h->subject))
		 $name = preg_replace('|\W|', '_', trim(decode_mime_string($h->subject)));
	 else
		 $name = 'message';
	 
	 $from = trim(decode_mime_string(isset($h->fromaddress) ? $h->fromaddress : ''));
     $date = strftime('%a %b %d %H:%M:%S %Y', $h->udate);
	 $body  = 'From ' . $from . ' ' . $date . "\n";
	 $body .= imap_fetchheader($imp->stream, $index, FT_UID);
	 $body .= imap_body ($imp->stream, $index, FT_UID);
     $body = str_replace("\r\n", "\n", $body);
	 
	 header('Content-Type: application/RFC822');
     if ($this_client->broken_disposition) {
         header('Content-Disposition: filename=' . $name);
     } else {
         header('Content-Disposition: attachment; filename=' . $name);
     }
	 break;
}

if ($actionID != SAVE_MESSAGE) {
    $body = imap_fetchbody($imp->stream, $index, $bodypart, FT_UID);
    
    if ($mime->encoding == ENCBASE64)
        $body = imap_base64($body);
    else if ($mime->encoding == ENCQUOTEDPRINTABLE && ($qprint_msg = imap_qprint($body)))
        $body = $qprint_msg;
}

header('Content-Length: ' . strlen($body));
echo $body;

?>
