
#ifndef INTUITIVELY_H
#define INTUITIVELY_H

#define YY_NO_UNPUT

#include <sys/types.h>
#include <pcap.h>
#include <asm/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define INTUITIVELY_CONFFILE "/etc/intuitively/intuitively.conf"

struct host {
  struct sockaddr_storage ip;
  char *mac;
};

struct entry {
  struct sockaddr_storage myip;
  struct sockaddr_storage netmask;
  struct sockaddr_storage gw;
  struct sockaddr_storage broadcast;
  unsigned short pingips;
  struct host pingip[10];

  char *name;
  char *description;
  char *dirroot;
  char *script;
  int dontsetip;
  int defaultlocation;
  struct entry *next;
};

struct switches {
  int force;
  char *device;
  struct entry *location;
  char *locationname;
  char *conffile;
  int verbose;
  int run_scripts;
  int dry_run;
  char *locationfile;
};

void sendarp(struct sockaddr_storage *myip, struct sockaddr_storage *hisip, unsigned char* device);

void parse(char *ptr,struct entry *e);
void send_arps(unsigned char* device, struct entry* e_list);
int main(int argc,char *argv[]);

void read_conffile(struct switches* s);
int parse_commandline(int argc,char **argv, struct switches* s);
int init_libnet(char** device);
pcap_t* init_pcap(unsigned char* device);
struct host* get_answers(pcap_t *pd, struct entry* e);
void get_answer(u_char* answer, const struct pcap_pkthdr* pc, const u_char* packet);

int yyerror(char* msg);
int yylex();
int yyparse();

FILE* yyin;
struct entry *e;
struct switches switches;

#endif
