# -*- text -*-
# --------------------------------------------------------------------
#
# Ipe configuration
#
# --------------------------------------------------------------------
#
# Freetype location
#
# Path to "ft2build.h" (if not on standard include path)
FREETYPE_INCLUDE  = /usr/include/freetype2
# Path to "libfreetype.so" (if not in a standard library directory)
#FREETYPE_LIBS    = /usr/lib
# --------------------------------------------------------------------
#
# Zlib location
#
# Path to "zlib.h" (if not on standard include path)
#ZLIB_INCLUDE     = /usr/include
# Path to "libz.so" (if not in a standard library directory)
#ZLIB_LIBS        = /usr/lib
# --------------------------------------------------------------------
#
# Using threaded Qt library?
#
# Uncomment the next line to use the non-threaded Qt-library
CONFIG     += thread
# --------------------------------------------------------------------
#
# Compile against KDE?
#
# Uncomment next line if you wish to compile Ipe as a KDE application.
# (and no, that doesn't change the name to "kipe")
#CONFIG	      += kde
KDE_INCLUDE   = /usr/include/kde
# --------------------------------------------------------------------
#
# Installing Ipe:
#
IPEVERS = 6.0pre23
#
# IPEPREFIX is the global prefix for the Ipe directory structure, which
# you can override individually for any of the specific directories.
# You could choose "/usr/local" or "/opt/ipe-6.0", or
# even "/usr", or "$(HOME)/ipe-6.0" if you have to install in your home
# directory.
#
# If you are installing Ipe in a networked environment, keep in mind
# that executables, ipelets, and Ipe library are machine-dependent,
# while the documentation and fonts can be shared.
#
#IPEPREFIX  = /usr/local/ipe
#IPEPREFIX  = /usr
#IPEPREFIX  = /opt/ipe-6.0
#
isEmpty( IPEPREFIX ) {
  error( "You need to specify IPEPREFIX!")
}
#
# Where Ipe executables will be installed ('ipe', 'ipe5toxml' etc)
IPEBINDIR  = $${IPEPREFIX}/bin
#
# Where the Ipe libraries will be installed (libipe.so.*)
IPELIBDIR  = $${IPEPREFIX}/lib
#
# Where the header files for Ipelib will be installed:
IPEHEADERDIR = $${IPEPREFIX}/include
#
# Where Ipelets will be installed:
IPELETDIR = $${IPEPREFIX}/lib/ipe/$${IPEVERS}/ipelets
#
# List of paths where Ipe will search for Ipelets:
# (Paths are separated by ":" on Windows and ";" on Unix)
IPELETPATH = $${IPELETDIR}
#
# IPEDOCDIR will contain the Ipe documentation (mostly html files)
#
isEmpty( IPEDOCDIR ) {
  IPEDOCDIR  = $${IPEPREFIX}/share/ipe/$${IPEVERS}/doc
}
#
# IPELANGDIR will contain Ipe UI translations (none exist yet)
#
IPELANGDIR = $${IPEPREFIX}/share/ipe/$${IPEVERS}/languages
#
# IPEMANDIR will contain the Ipe manual pages
#
IPEMANDIR  = $${IPEPREFIX}/share/man/man1
#
# The full path to the Ipe fontmap
#
IPEFONTMAP = $${IPEPREFIX}/share/ipe/$${IPEVERS}/fontmap.xml
#
# The HTML browser started to read the on-line Ipe documentation.
# (not used if compiled against KDE)
IPEBROWSER = mozilla
# --------------------------------------------------------------------
# Standard definitions --- don't change
CONFIG      += warn_on release
CONFIG	    -= qt
linux-g++:QMAKE_CXXFLAGS_WARN_ON += -Werror
# --------------------------------------------------------------------
