/*
 * This program is original work by San Mehat <nettwerk@valinux.com> .
 * This program is distributed under the GNU General Public License (GPL)
 * as outlined in the COPYING file.
 *
 * Copyright (C) 1999, San Mehat, and VA Linux Systems
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * Notes: This is now a stand-alone run-time linkable module for VACM
 * Symbols beginning with 'api' denote a module harness required
 * symbol which should not be renamed. Renaming an 'api' symbol
 * will cause undesired operation, and program failure.
 *
 */

#ifndef _EMP_SENSOR_EVENTS_H
#define _EMP_SENSOR_EVENTS_H

#define SENSOR_CLASS_UNKNOWN    0x00
#define SENSOR_CLASS_DIGITAL    0x01
#define SENSOR_CLASS_THRESHOLD  0x02
#define SENSOR_CLASS_DISCRETE		0x03

typedef struct threshold_event_data
  {
  /* event data byte 1 */
  unsigned char event_trigger_offset    :4  __attribute__ ((packed));
  unsigned char reserved                :1  __attribute__ ((packed));
  #define THRES_EVENT_DATA_BYTE_3_UNSPECIFIED         0x00
  #define THRES_EVENT_DATA_BYTE_3_TRIGGER_THRES_VALUE 0x01
  #define THRES_EVENT_DATA_BYTE_3_OEM_CODE            0x02
  #define THRES_EVENT_DATA_BYTE_3_RESERVED            0x03
  unsigned char byte_3_contents         :2  __attribute__ ((packed));
  #define THRES_EVENT_DATA_BYTE_2_UNSPECIFIED         0x00
  #define THRES_EVENT_DATA_BYTE_2_TRIGGER_READING     0x01
  unsigned char byte_2_contents         :1  __attribute__ ((packed));

  /* event data byte 2 */
  unsigned char trigger_reading             __attribute__ ((packed));

  /* event data byte 3 */
  unsigned char threshold_value             __attribute__ ((packed));
  } THRESHOLD_EVENT_DATA;

typedef struct digital_event_data
  {
  /* event data byte 1 */
  unsigned char digital_event_offset    :1  __attribute__ ((packed));
  unsigned char reserved1               :4  __attribute__ ((packed));
  #define DIG_EVENT_DATA_BYTE_3_UNSPECIFIED           0x00
  #define DIG_EVENT_DATA_BYTE_3_RESERVED1             0x01
  #define DIG_EVENT_DATA_BYTE_3_OEM_CODE              0x02
  #define DIG_EVENT_DATA_BYTE_3_RESERVED2             0x03
  unsigned char byte_3_contents         :2  __attribute__ ((packed));
  unsigned char reserved2               :1  __attribute__ ((packed));

  /* event data byte 2 */
  unsigned char reserved3               :4  __attribute__ ((packed));
  unsigned char sev_event_trig_offset   :4  __attribute__ ((packed));

  /* event data byte 3 */
  unsigned char oem_code                    __attribute__ ((packed));
  } DIGITAL_EVENT_DATA;

typedef struct discrete_event_data
  {
  /* event data byte 1 */
  unsigned char event_trigger_offset    :4  __attribute__ ((packed));
  unsigned char reserved                :1  __attribute__ ((packed));
  #define DIS_EVENT_DATA_BYTE_3_UNSPECIFIED           0x00
  #define DIS_EVENT_DATA_BYTE_3_TRIGGER_THRES_VALUE   0x01
  #define DIS_EVENT_DATA_BYTE_3_OEM_CODE              0x02
  #define DIS_EVENT_DATA_BYTE_3_RESERVED              0x03
  unsigned char byte_3_contents         :2  __attribute__ ((packed));
  #define DIS_EVENT_DATA_BYTE_2_UNSPECIFIED           0x00
  #define DIS_EVENT_DATA_BYTE_2_PREV_STATE_SEVERITY   0x01
  unsigned char byte_2_contents         :1  __attribute__ ((packed));

  /* event data byte 2 */
  unsigned char prev_event_offset       :4  __attribute__ ((packed));
  unsigned char sev_event_trig_offset   :4  __attribute__ ((packed));

  /* event data byte 3 */
  unsigned char oem_code                    __attribute__ ((packed));
  } DISCRETE_EVENT_DATA;
#endif
