#include "../ipsc.h"

struct GipscMain
{
	GtkWidget *app;
	GtkSpinButton *subnet_bits;
	GtkAdjustment *subnet_bits_adj;
	GtkLabel *subnet_bits_label;
	GtkWidget *class_a_button; 
	GtkWidget *class_b_button;
	GtkWidget *class_c_button;
	GtkWidget *notebook;

	/* Signal handler IDs */
	guint subnet_bits_adj_handler_id;
};

struct GipscGeneral
{
	GtkLabel *tab_label;
	GtkEntry *net_bits;
	GtkEntry *netmask;
	GtkEntry *netmask_hex;
	GtkEntry *subnet_max;
	GtkEntry *subnet_bits;
	GtkEntry *subnet_mask;
	GtkEntry *subnet_mask_hex;
	GtkEntry *host_bits;
	GtkEntry *host_max;
	GtkEntry *bitmap;
};

struct GipscSubnets
{
	GtkLabel *tab_label;
	GtkCList *subnet_list;
};

struct GipscHost
{
	GtkLabel *tab_label;
	GtkEntry *addr;
	GtkEntry *addr_hex;
	GtkEntry *subnet_range;
	GtkEntry *subnet_mask;
	GtkEntry *subnet_id;
	GtkEntry *network_id;
	GtkEntry *host_id;
};

struct GipscCidr
{
	GtkLabel *tab_label;
	GtkEntry *cidr_notation;
	GtkEntry *supernet_max;
	GtkEntry *base_network;
	GtkEntry *cisco_wildcard;
	GtkEntry *route_mask;
	GtkEntry *route_mask_hex;
};

typedef struct GipscMain GipscMain;
typedef struct GipscGeneral GipscGeneral;
typedef struct GipscSubnets GipscSubnets;
typedef struct GipscHost GipscHost;
typedef struct GipscCidr GipscCidr;

/*
 * Methods
 */
GtkWidget *gipsc_create_general(GipscGeneral *gw);
GtkWidget *gipsc_create_subnets(GipscSubnets *sw);
GtkWidget *gipsc_create_host(GipscHost *aw);
GtkWidget *gipsc_create_cidr(GipscCidr *cw);

void gipsc_update_general(const GipscGeneral *gw, const Network *n);
void gipsc_update_subnets(const GipscSubnets *sw, const Network *n);
void gipsc_update_host(const GipscHost *hw, const Network *n);
void gipsc_update_cidr(const GipscCidr *cw, const Network *n);
