/*      
 * iroffer by PMG
 * Copyright (C) 1999 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 */

#if !defined _IROFFER_HEADERS
#define _IROFFER_HEADERS

/*------------ includes ------------- */

/* #include <iostream.h> */
#include <stdio.h>
#include <stdlib.h>

#include <string.h>
#include <signal.h>
#include <netdb.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <pwd.h>
#include <regex.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <errno.h>
#include <sys/utsname.h>
#include <sys/resource.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>

#ifdef _OS_SunOS
#include <sys/termios.h>
#include <strings.h>
#endif


/*------------ structures/classes ------------- */

typedef struct {
   char file[maxtextlength],
        desc[maxtextlength],
        note[maxtextlength];
   int offered,
       gets,
       minspeed;
   long size;
   } xdcc;

typedef struct {
   xdcc *xpack;
   char nick[maxtextlengthshort],
        hostname[maxtextlength];
   time_t queuedtime;
   } pqueue;

typedef struct {
   char hostname[maxtextlength];
   char manual,
        ignoring,
        firstignore;
   long bucket,
        lastcontact;
   } igninfo;

typedef struct {
   int listensocket,
       listenport,
       clientsocket,
       filedescriptor,
       twicewait,
       reminded,
       whichtransfer,
       nomin,
       socknotfound,
       id;
   SIGNEDSOCK int addrlen;
   long bytessent,
        startresume,
        lastspeedamt,
        lastcontact,
        connecttime;
   float lastspeed;
   xdcc *xpack;
   struct sockaddr_in serveraddress;
   char nick[maxtextlengthshort],
        hostname[maxtextlength],
        status;
   /* L = listening */
   /* S = Sending */
   /* W = Done reading, waiting for write buffer to be flushed */
   /* E = read/write error, need to kill this transfer */
   /* D = Done */
   
   } transfer;
   

typedef struct {
   int method;
   /* 1 = stdin, 2 = dcc chat, 3 = msg, */
   /* 4 = xdl/channel, 5 = xdl/user, 6 = OUT_S|OUT_L|OUT_D */
   char *snick, *cmd, *arg1e, *arg2e, *arg1, *arg2, *arg3;
   } userinput;

typedef struct {
   void *ptr;
   const char *src;
   time_t alloctime;
   short size;
   } meminfo_t;


/*------------ function declerations ------------- */

/* iroffer.cpp */
void mainloop();
void parseline(char*);
void privmsgparse(char*, char*);
void autosendf(char*);
void sendxdccfile(char*, char*, int, char*);
void addtoqueue(char*, char*, char*, int);
void notifyqueued();
void notifybandwidth();
void sendaqueue(int);

/* display.cpp */
void initscreen();
void checktermsize();
void gototop();
void clearbot();
void gotobot();

/* utilities.cpp */
#ifndef _OS_SunOS
void msleep(int);
#endif _OS_SunOS
int strcmppart(char*, char*);
int strcmpany(char*, char*);
int strcmpend (char*, char*);
char* getpart(char*, int, const char *);
char* caps(char*);
char* sizestr(int, char*,unsigned long);
int highestsock ();
void getos();
int getend(int,int);
int getbeg(int,int);
int getsrv(int,int);
char* getdatestr(char*,time_t);
void logi(int);
void logstat();
unsigned long atoul (char*);
void floodchk();
void ioutputi(int, int);
char* hostmasktoregex(char*);
int verifyadmin(char*);
int packnumtonum(char*);
int sstrlen (char*);
char dayofweektomask(char);
void msglog_add(char*,char*);
char* msglog_howmany(char*);
char *strrev(char*);
#define outerror(a,b) outerror3(a,b,"","")
#define outerror2(a,b,c) outerror3(a,b,c,"")
void outerror3 (int type, char*, char*, char*);
#define log1(x,a)         log6(x,a,NULL,NULL,NULL,NULL,NULL)
#define log2(x,a,b)       log6(x,a,b,NULL,NULL,NULL,NULL)
#define log3(x,a,b,c)     log6(x,a,b,c,NULL,NULL,NULL)
#define log4(x,a,b,c,d)   log6(x,a,b,c,d,NULL,NULL)
#define log5(x,a,b,c,d,e) log6(x,a,b,c,d,e,NULL)
void log6(int, char*, char*, char*, char*, char*, char*);
#define ioutput1(x,y,w,z)           ioutput6(x,y,w,z,NULL,NULL,NULL,NULL,NULL)
#define ioutput2(x,y,w,z,a)         ioutput6(x,y,w,z,a,NULL,NULL,NULL,NULL)
#define ioutput3(x,y,w,z,a,b)       ioutput6(x,y,w,z,a,b,NULL,NULL,NULL)
#define ioutput4(x,y,w,z,a,b,c)     ioutput6(x,y,w,z,a,b,c,NULL,NULL)
#define ioutput5(x,y,w,z,a,b,c,d)   ioutput6(x,y,w,z,a,b,c,d,NULL)
void ioutput6(int, int, char*, char*, char*, char*, char*, char*, char*);
#define privmsg1(x,a)         privmsg5(x,a,"","","","")
#define privmsg2(x,a,b)       privmsg5(x,a,b,"","","")
#define privmsg3(x,a,b,c)     privmsg5(x,a,b,c,"","")
#define privmsg4(x,a,b,c,d)   privmsg5(x,a,b,c,d,"")
void privmsg5(char*, char*, char*, char*, char*, char*);
#define notice1(x,a)         notice5(x,a,"","","","")
#define notice2(x,a,b)       notice5(x,a,b,"","","")
#define notice3(x,a,b,c)     notice5(x,a,b,c,"","")
#define notice4(x,a,b,c,d)   notice5(x,a,b,c,d,"")
void notice5(char*, char*, char*, char*, char*, char*);
void* mycalloc(int, const char *);
void mydeletepart(void *t);
long whatisallocsize(void *t);
int isprintable(char);
char onlyprintable(char a);

/* misc.cpp */
void getconfig (char*);
void getconfig_set (char*,int);
int connectirc (char*);
void initirc();
#define writeserver(x) writeserver2(x,0)
void writeserver2(char*, int);
void sendserver();
void getxdccconfig(char*);
char* getfilename(char*, char*);
void pingserver();
void xdccsave(int);
void writepidfile(char*);
char* getfline(char*, int, int);
void gobackground();
void gothup(int);
void gotserverswitch(int);
void gotsigrehash(int);
void gotalarm(int);
char* getuptime(char*,int);
void parsestdin();
void shutdowniroffer(int);
void switchserver();
char* getstatusline(char*);
char* getstatuslinenums(char*);
void sendxdlqueue();
int isthisforme (char*, char*);
void initvars();
void startupiroffer(char *argv[]);
void isrotatelog();

/* remoteadmin.cpp */
int setupdccchatout(char*);
void setupdccchataccept();
int setupdccchat(char*);
void parsedccchat(char*);
void writedccchat(char*);
void writestatus();

/* plugins.cpp */
#if !defined _IROFFER_NOPLUGINS
void plugin_initialize ();
void plugin_everyloop ();
void plugin_every1sec ();
void plugin_every20sec ();
void plugin_ircprivmsg (char *, char *, char *, char *,
                  char *, char *, char *, char *, char *);
void plugin_ircinput (char *, char *, char *, char *);
#endif

/* transfer.cpp */
void t_initvalues (transfer *t);
void t_setuplisten (transfer *t);
void t_establishcon (transfer *t);
void t_transfersome (transfer *t);
void t_readjunk (transfer *t);
void t_istimeout (transfer *t);
void t_flushed(transfer *t);
void t_closeconn(transfer *t, char*);
void t_setresume(transfer *t, char*);
void t_remind(transfer *t);
void t_checkminspeed(transfer *t);

/* admin.cpp */
void u_fillwith_stdin(userinput *u, char*);
void u_fillwith_dcc(userinput *u, char*);
void u_fillwith_msg(userinput *u, char*, char*);
void u_fillwith_clean(userinput *u);

void u_respond(userinput *u, char*);
void u_parseit(userinput *u);

void u_help(userinput *u);
void u_xdl(userinput *u);
void u_dcl(userinput *u);
void u_dcld(userinput *u);
void u_qul(userinput *u);
void u_close(userinput *u);
void u_nomin(userinput *u);
void u_rmq_rpq(userinput *u);
void u_info(userinput *u);
void u_remove(userinput *u);
void u_send(userinput *u);
void u_psend(userinput *u);
void u_mesg(userinput *u);
void u_mesq(userinput *u);
void u_closedcc();
void u_status(userinput *u);
void u_chfile(userinput *u);
void u_chdesc(userinput *u);
void u_chnote(userinput *u);
void u_chmins(userinput *u);
void u_add(userinput *u);
void u_chatme(userinput *u);
void u_rehash(userinput *u);
void u_botinfo(userinput *u);
void u_ignl(userinput *u);
void u_ignore(userinput *u);
void u_nosave(userinput *u);
void u_nosend(userinput *u);
void u_nolist(userinput *u);
void u_renumber(userinput *u);
void u_msgread(userinput *u);
void u_msgdel(userinput *u);
void u_memstat(userinput *u);
void u_delayedshutdown(userinput *u);


#endif /* _IROFFER_HEADERS */















