package jfractionlab.worksheets;

import jfractionlab.JFractionLab;
/**
 * 
 * @author gnugeo@gnugeo.de
 *
 * an excercise has got two fractions
 * like
 * 4/7 and 3/5
 * every single fraction is not reducable
 * 
 * the numerators can have common factors
 * like
 * 4*8/7 and 3/5*8
 * or
 * 4*8/7*8 and 3/5
 * 
 */
public class MultiplicationExcercise {

	/** numrator_1 and its factor*/
	private int n1=0, fn1=1;
	private int d1=0, fd1=1;
	private int n2=0, fn2=1;
	private int d2=0, fd2=1;
	/** fmax is the maximal value of the factor which is used to create reducable nominator-denominator-pairs
	 * fmax is 1 or 10*/
	private int fmax = 10;
	/** nb_max is the maximal value of a number, that has got a factor
	 * fmax * nb_max <= max !!*/
	private int nb_max = 10;
	/**max is the maximal value of a nominator or denominator. max is 10, 100 or 1000*/
	private int max = 100;

	
	public MultiplicationExcercise(int max){
		if (max == 10){
			this.max = max;
			this.fmax = 1;
			this.nb_max = 10;
		}else if (max == 100){
			this.max = max;
			this.fmax = 10;
			this.nb_max = 10;
		}else{
			throw new IllegalArgumentException( "max has to be 10 or 100" );
		}
		mkExcercise();
	}
	
	public MultiplicationExcercise mkExcercise(){
		//if ran is defined in here, the random numbers are mostly all the same
		int r = JFractionLab.ran.nextInt(6000)+1;
		if(r >= 0 && r <=999){
			//upper_left -> bottom_right
			fn1 = JFractionLab.ran.nextInt(fmax)+1;
			if(fn1 == 1)fn1++;
			fd2 = fn1;
			do{
				n1 = JFractionLab.ran.nextInt(nb_max)+1;
				d1 = JFractionLab.ran.nextInt(max)+1;
			}while ((fn1 * n1) >= d1 || JFractionLab.ggt(n1,d1)>1);
			do{
				n2 = JFractionLab.ran.nextInt(max)+1;
				d2 = JFractionLab.ran.nextInt(nb_max)+1;
			}while (n2 >= d2 || isReducable());
		}else if (r> 999 && r <=1999){
			//upper_left -> bottom_left
			fn1 = JFractionLab.ran.nextInt(fmax)+1;
			if(fn1 == 1)fn1++;
			fd1 = fn1;
			do{
				n1 = JFractionLab.ran.nextInt(nb_max)+1;
				d1 = JFractionLab.ran.nextInt(nb_max)+1;
			}while (n1 >= d1 || JFractionLab.ggt(n1,d1)>1);
			do{
				n2 = JFractionLab.ran.nextInt(nb_max)+1;
				d2 = JFractionLab.ran.nextInt(nb_max)+1;
			}while (n2 >= d2 || isReducable());
		}else if(r> 1999 && r<= 2999){
			//upper_right -> bottom_left
			fn2 = JFractionLab.ran.nextInt(fmax)+1;
			if(fn2 == 1)fn2++;
			fd1 = fn2;
			do{
				n1 = JFractionLab.ran.nextInt(max)+1;
				d1 = JFractionLab.ran.nextInt(nb_max)+1;
			}while (n1 >= (d1 * fd1) || JFractionLab.ggt(n1,d1)>1);
			do{
				n2 = JFractionLab.ran.nextInt(nb_max)+1;
				d2 = JFractionLab.ran.nextInt(max)+1;
			}while ((n2 * fn2) >= d2 || isReducable());
		}else if(r>2999 && r<= 3999){
			//upper_right -> bottom_right
			fn2 = JFractionLab.ran.nextInt(fmax)+1;
			if(fn2 == 1)fn2++;
			fd2 = fn2;
			do{
				n1 = JFractionLab.ran.nextInt(nb_max)+1;
				d1 = JFractionLab.ran.nextInt(nb_max)+1;
			}while (n1 >= d1 || JFractionLab.ggt(n1,d1)>1);
			do{
				n2 = JFractionLab.ran.nextInt(nb_max)+1;
				d2 = JFractionLab.ran.nextInt(nb_max)+1;
			}while (n2 >= d2 || isReducable());
		}else if(r> 3999 && r<= 4999){
			//upper_left -> bottom_left und upper_right -> bottom_right
			fn1 = JFractionLab.ran.nextInt(fmax)+1;
			if(fn1 == 1)fn1++;
			fd1 = fn1;
			fn2 = JFractionLab.ran.nextInt(fmax)+1;
			if(fn2 == 1)fn2++;
			fd2 = fn2;
			do{
				n1 = JFractionLab.ran.nextInt(nb_max)+1;
				d1 = JFractionLab.ran.nextInt(nb_max)+1;
			}while (n1 >= d1 || JFractionLab.ggt(n1,d1)>1);
			do{
				n2 = JFractionLab.ran.nextInt(nb_max)+1;
				d2 = JFractionLab.ran.nextInt(nb_max)+1;
			}while (n2 >= d2 || isReducable());
		}else if(r> 4999 && r<= 6001){
			//upper_left -> bottom_right und upper_right -> bottom_left
			fn1 = JFractionLab.ran.nextInt(fmax)+1;
			if(fn1 == 1)fn1++;
			fd2 = fn1;
			fn2 = JFractionLab.ran.nextInt(fmax)+1;
			if(fn2 == 1)fn2++;
			fd1 = fn2;
			do{
				n1 = JFractionLab.ran.nextInt(nb_max)+1;
				d1 = JFractionLab.ran.nextInt(nb_max)+1;
			}while ((n1 * fn1) >= (d1 * fd1) || JFractionLab.ggt(n1,d1)>1);
			
			do{
				n2 = JFractionLab.ran.nextInt(nb_max)+1;
				d2 = JFractionLab.ran.nextInt(nb_max)+1;
			}while ((n2 * fn2) >= (d2 * fd2) || isReducable());
		}
		return this;
	}
	
	private boolean isReducable(){
		boolean blReturn = false;
		if(JFractionLab.ggt(n1,d1)>1){
			blReturn = true;
		}
		if(JFractionLab.ggt(n1,d2)>1){
			blReturn = true;
		}
		if(JFractionLab.ggt(n2,d1)>1){
			blReturn = true;
		}
		if(JFractionLab.ggt(n2,d2)>1){
			blReturn = true;
		}
		return blReturn;
	}
	
//	private int ggt(int a, int b){
//	     // verwendet wird der erweiterte Euklidsche Algorithmus
//	    if(a==b||b==0) return a;
//	    else return ggt(b,a%b);
//	  }
	
	public int getN1() {return n1;}
	public int getFn1() {return fn1;}
	public int getD1() {return d1;}
	public int getFd1() {return fd1;}
	public int getN2() {return n2;}
	public int getFn2() {return fn2;}
	public int getD2() {return d2;}
	public int getFd2() {return fd2;}
}
