package jfractionlab.worksheets;

import java.io.File;
import java.util.ArrayList;


public class MultiplicationWSGenerator extends WorkSheetGenerator{
	private ArrayList<MultiplicationExcercise> al_excercises;
	
	public MultiplicationWSGenerator(File file, int max){
		super(lang.Messages.getString("multiply_fractions"));
		if (max == 10 || max == 100){
			al_excercises = new ArrayList<MultiplicationExcercise>();
			al_solutionLine = new ArrayList<String>();
			mkExcercises(nb_of_excercises, max);
			generateText();
			writeFiles(file);
		}else{
			throw new IllegalArgumentException( "max has to be 10 or 100" );
		}
	}//Constructor
	
	protected void mkExcercises(int nb, int max){
		for (int i = 0; i<nb; i++){
			al_excercises.add(new MultiplicationExcercise(max));
		}//for
	}//mkFractions
	
	private String writeReduction(int n1, int fn1,int d1,int fd1,int n2,int fn2,int d2,int fd2){
		String strReturn="";
		strReturn +="$\\frac{";
			if(fn1 > 1){
				strReturn += n1+" \\cdot "+fn1;
			}else{
				strReturn += n1;
			}
		strReturn += "}{";//close nominator and open denominator
			if(fd1 > 1){
				strReturn += d1+" \\cdot "+fd1;
			}else{
				strReturn += d1;
			}
		strReturn += "} \\cdot "; //close denominator and "*"
		strReturn +="\\frac{";
			if(fn2 > 1){
				strReturn += n2+" \\cdot "+fn2;
			}else{
				strReturn += n2;
			}
		strReturn += "}{";//close nominator and open denominator
			if(fd2 > 1){
				strReturn += d2+" \\cdot "+fd2;
			}else{
				strReturn += d2;
			}
		strReturn += "}$"; //close denominator
		return strReturn;
	}

	@Override
	protected String writeOneLine(boolean isExcercise, int nb){
		String strReturn = "";
		int n1 = al_excercises.get(nb).getN1();
		int fn1 = al_excercises.get(nb).getFn1();
		int n1fn1= (n1 * fn1);
		
		int d1 = al_excercises.get(nb).getD1();
		int fd1 = al_excercises.get(nb).getFd1();
		int d1fd1 = (d1 * fd1);
		
		int n2 = al_excercises.get(nb).getN2();
		int fn2 = al_excercises.get(nb).getFn2();
		int n2fn2 = (n2 * fn2);
		
		int d2 = al_excercises.get(nb).getD2();
		int fd2 = al_excercises.get(nb).getFd2();
		int d2fd2 = (d2 * fd2);
		//#######
		int n3 = al_excercises.get(nb+1).getN1();
		int fn3 = al_excercises.get(nb+1).getFn1();
		int n3fn3= (n3 * fn3);
		
		int d3 = al_excercises.get(nb+1).getD1();
		int fd3 = al_excercises.get(nb+1).getFd1();
		int d3fd3 = (d3 * fd3);
		
		int n4 = al_excercises.get(nb+1).getN2();
		int fn4 = al_excercises.get(nb+1).getFn2();
		int n4fn4 = (n4 * fn4);
		
		int d4 = al_excercises.get(nb+1).getD2();
		int fd4 = al_excercises.get(nb+1).getFd2();
		int d4fd4 = (d4 * fd4);
		
		if(isExcercise){
			strReturn = String.valueOf((nb+1));
			strReturn += "&";
			strReturn += "$\\frac{"+n1fn1+"}{"+d1fd1+"}";
			strReturn += " \\cdot ";
			strReturn += "\\frac{"+n2fn2+"}{"+d2fd2+"}$";
			strReturn += " =";
			strReturn += "&";
			strReturn += String.valueOf((nb+2));
			strReturn += "&";
			strReturn += "$\\frac{"+n3fn3+"}{"+d3fd3+"}";
			strReturn += " \\cdot ";
			strReturn += "\\frac{"+n4fn4+"}{"+d4fd4+"}$";
			strReturn += " =\\\\";
		}else{
			strReturn = String.valueOf((nb+1));
			strReturn += "&";
			strReturn += "$\\frac{"+n1fn1+"}{"+d1fd1+"}";
			strReturn += " \\cdot ";
			strReturn += "\\frac{"+n2fn2+"}{"+d2fd2+"}$";
			strReturn += " = ";
			strReturn += writeReduction(n1, fn1, d1, fd1, n2, fn2, d2, fd2);
			strReturn += " = ";
			strReturn += "$\\frac{"+n1+" \\cdot "+n2+"}{"+d1+" \\cdot "+d2+"}$";
			strReturn += " = ";
			strReturn += "$\\frac{"+(n1*n2)+"}{"+(d1*d2)+"}$";
			al_solutionLine.add("$\\frac{"+(n1*n2)+"}{"+(d1*d2)+"}$");
			strReturn += "&";
			strReturn += String.valueOf((nb+2));
			strReturn += "&";
			strReturn += "$\\frac{"+n3fn3+"}{"+d3fd3+"}";
			strReturn += " \\cdot ";
			strReturn += "\\frac{"+n4fn4+"}{"+d4fd4+"}$";
			strReturn += " = ";
			strReturn += writeReduction(n3,fn3,d3,fd3,n4,fn4,d4,fd4);
			strReturn += " = ";
			strReturn += "$\\frac{"+n3+" \\cdot "+n4+"}{"+d3+" \\cdot "+d4+"}$";
			strReturn += " = ";
			strReturn += "$\\frac{"+(n3*n4)+"}{"+(d3*d4)+"}$";
			al_solutionLine.add("$\\frac{"+(n3*n4)+"}{"+(d3*d4)+"}$");
			strReturn += "\\\\";
		}
		return strReturn;
	}
	
}//class
