#ifndef K3DSDK_BITMAP_FILTER_H
#define K3DSDK_BITMAP_FILTER_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "ibitmap_sink.h"
#include "ibitmap_source.h"
#include "bitmap.h"
#include "property_collection.h"

namespace k3d
{

template<typename base_t>
class bitmap_filter :
	public base_t,
	public ibitmap_source,
	public ibitmap_sink
{
public:
	bitmap_filter(idocument& Document) :
		base_t(Document),
		m_input(init_name("input") + init_description("Input bitmap [bitmap]") + init_value<bitmap*>(0) + init_document(Document)),
		m_output(init_name("output") + init_description("Output bitmap [bitmap]") + init_document(Document))
	{
		base_t::register_property(m_input);
		base_t::register_property(m_output);
	}

	iproperty& bitmap_source_output()
	{
		return m_output;
	}

	iproperty& bitmap_sink_input()
	{
		return m_input;
	}

protected:
	k3d_data_property(bitmap*, immutable_name, change_signal, no_undo, local_storage, no_constraint) m_input;
	k3d_read_only_data_property(bitmap*, immutable_name, change_signal, no_undo, demand_storage, no_constraint) m_output;
};

} // namespace k3d

#endif // !K3DSDK_BITMAP_FILTER_H


