/***************************************************************************
                          kgrammar.h  -  description
                             -------------------
    begin                : Tue Aug 1 2000
    copyright            : (C) 2000 by Terk Zsolt
    email                : tz124@hszk.bme.hu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KGRAMMAR_H
#define KGRAMMAR_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qlist.h>
#include <qdict.h>
#include <qstring.h>
#include "krule.h"

/**Context-free grammar for Kaptain.
  *@author Terk Zsolt
  */

class KGrammar {
  QDict<int> nonterminals;
  QList<QString> terminals;

  QList<KRule> rules;

  /* The number of the last nonterminal symbol stored, the first is -1, decreasing */
  int lastNonterminal;
  /* The number of the next terminal symbol stored, starting with 0, increasing */
  int nextTerminal;
 public:
	KGrammar();
	~KGrammar();
	
	/* get the rule for the given non-terminal */
	KRule * getRule(int);
	KRule * getTopLevelRule();
  KRule * getStartRule();
		
  /* check if a nonterminal has already been stored */
  bool isNonterminal(QString *);
	/* get the internal number for a non-terminal symbol */
	int storeNonterminal(QString *);
	/* get the internal number for a terminal symbol */
	int storeTerminal(QString *);
	
	/* get value for non-terminal */
	QString getNonterminal(int);
	/* get value for terminal */
	QString getTerminal(int);
	
	/* get a number for a non-terminal which has no name */
	int getNewNonterminal();

	void addRule(KRule *);
		
  /* parse a file */
  bool parse(const char * fname);
  bool check();
};

#endif
