#include <iostream>
#include <qapplication.h>
#include <qstatusbar.h>
#include <qtimer.h>
#include <qmessagebox.h>

#include "smtp.h"
#include "globals.h"
#include "preferences.h"
#include "browser.h"

Smtp::Smtp() : QObject()
{
	QObject::connect( &socket, SIGNAL( connected() ), this, SLOT( connected() ) );
	QObject::connect( &socket, SIGNAL( connectionClosed() ), this, SLOT( closed() ) );
	QObject::connect( &socket, SIGNAL( readyRead() ), this, SLOT( readyRead() ) );

	QObject::connect( browser, SIGNAL( stopSignal() ), this, SLOT( aborted() ) );
}

void Smtp::sendMail( string s1, string s2, string s3, string s4 )
{
	sender = s1;
	receiver = s2;
	subject = s3;
	msg = s4;

	browser->statusBar()->message( "Sending Mail.." );

	myapp->processEvents();

	success = FALSE;
	QTimer::singleShot( config->timeoutValue(), this, SLOT( error() ) );

	socket.connectToHost( (config->smtpServer()).c_str(), 25 );
	socketClosed = FALSE;

	while( !socketClosed )
		myapp->processEvents();

	browser->statusBar()->message( "Ready.." );
}	

void Smtp::connected()
{
//	cout << "connected.." << endl;

	success = TRUE;

	transmitLine( "HELO " + config->smtpServer() );
	transmitLine( "MAIL FROM: " + sender );
	transmitLine( "RCPT TO: " + receiver );
	transmitLine( "DATA" );
	transmitLine( "Subject: " + subject );
	transmitLine( msg );
	transmitLine( "." );
	transmitLine( "QUIT" );
}

void Smtp::transmitLine( string s )
{
	socket.writeBlock( ( s + "\r\n" ).c_str(), s.length()+2 );
//	cout << "!!" << s << endl;
}

void Smtp::readyRead()
{
//	cout << "incoming.." << endl;

	while( socket.canReadLine() )
	{
		string s = (const char *)( socket.readLine() );

		int i;
		while( ( i = s.find_first_of( "\n\r" ) ) != -1 )
			s.erase( i, 1 );

	//	cout << "$" + s << endl;
	}	
}

void Smtp::closed()
{
//	cout << "closed.." << endl;

	socketClosed = TRUE;
}	

void Smtp::error()
{
	if( success )
		return;

	QMessageBox::critical( 0, "Network Error", ( "could not connect to server:\n" +
						     config->smtpServer() ).c_str() ); 
	socketClosed = TRUE;						
}

void Smtp::aborted()
{
	QMessageBox::about( 0, "Aborted", "SMTP Transmission aborted by user" );
	socketClosed = TRUE;
}

