//////////////////////////////////////////////////////////////
//      $Id: pkgInterface.h,v 1.27 2001/04/03 16:17:53 toivo Exp $ 
//
// Author: Toivo Pedaste
//

#ifndef PKG_IFACE_H
#define PKG_IFACE_H

#include "../config.h"
#include <qlist.h>
#include <qstring.h>
#include <qstringlist.h>

#include "packageInfo.h"
#include "procbuf.h"
#include "managementWidget.h"

class packageInfo;
class pkgOptions;
class Locations;
class LcacheObj;
class cacheObj;
class KAccel;
class  KActionCollection;
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

//  flags to install and uninstall
class param
{
public:
  param(QString nameP, bool initP,  bool invertP, QString flagP);
  param(QString nameP, bool initP,  bool invertP, QString flagP, QString flagAP);
  ~param();

  QString name;  // Name of flag
  bool init;         // Initial value
  bool invert;       // Whether it needs to be inverted
  QString flag; // text flag on command
  QString flagA; // text flag on command
}; 

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
class pkgInterface: public QObject 
{
  Q_OBJECT
 
public:
  pkgInterface(QString remote);
  virtual ~pkgInterface();
  
  virtual bool isType(char *buf, const QString &fname) =  0;
  // looks at start of file to check that package is correct type

  virtual void makeMenu(KAccel *keys, KActionCollection* act);
  virtual void setMenu(KActionCollection* act, bool enable);

  virtual packageInfo *getPackageInfo(char mode, const QString &name,
				      const QString &version) =  0;
  // get info on installed or uninstalled package. version is only set if
  // mode is 'i' (ie, if the package is already installed).

  virtual QStringList getFileList(packageInfo *p) =  0;
  // get list of files in the package

  virtual QStringList depends(const QString &name, int src);
  // check dependencies for package

  virtual QStringList verify(packageInfo *p, const QStringList &files);
  // check the installed files in a package

  virtual QStringList FindFile(const QString &name) = 0;
  // search for packages containg a file

  virtual bool parseName(QString name, QString *n, QString *v) = 0;
  // breakup file name into package name and version

  virtual void listPackages(QList<packageInfo> *pki);
  // scan various locations for list of packages

  virtual void listInstalledPackages(QList<packageInfo> *pki) = 0;
  // produce list of currently installed packages

  virtual QStringList  listInstalls(QStringList packs, bool install);
  // Convert list of packages requested to install to list of all packages to install

  virtual void smerge(packageInfo *p);
  // merge in package info entry

  QString getDir(cacheObj *cp);
  // list directory local or remote

  void listDir(QList<packageInfo> *pki, QString fname, QString dir, bool subdirs = FALSE);
  // list the packages in a directory

  packageInfo *collectDir(QString name, QString size, QString dir);
  // build packageInfo object from directory entry

  QString getPackList(cacheObj *cp);
  // get packages information file

  virtual QString  provMap(QString p);
  // convert from package depends to package

  QString setOptions(int flags, QList<param> &params);
  // convert un/install flags to text

  virtual QString doUninstall(int uninstallFlags, QString packs, bool &test);
  virtual QString doInstall(int installFlags, QString packs, bool &test);
  virtual QString uninstall(int uninstallFlags, QList<packageInfo> *p,
				  bool &test);
  virtual QString uninstall(int uninstallFlags, packageInfo *p,
				  bool &test);
  virtual QString install(int installFlags, QList<packageInfo> *p,
				  bool &test);
  virtual QString install(int installFlags, packageInfo *p,
				  bool &test);

  ///////////// DATA ///////////////////////
  //  installationWidget *installation;
  //  pkginstallDialogMult *installationMult;
  pkgOptions *uninstallation, *installation;;
  //  pkguninstallDialogMult *uninstallationMult;
  // install and uninstall widgets for this package type

  QString icon;
  // name icon file
  QString head;
  // capitalized name of package type
  QString name;
  // More descriptive name
  QPixmap pict, bad_pict, new_pict, updated_pict;
  // icons for package states
  QPixmap folder;
  // icon for package group
  QPixmap markInst;
  QPixmap markUnInst;
  // icon indicating mark for install/uninstall

  Locations *locatedialog;
  // dialog for setting the locations of  uninstalled packages
  LcacheObj *packageLoc;
  // List of locations of uninstalled pacckages
  
  bool dirOK;
  // variables related to reading packages from directories

  QString packagePattern;
  QString queryMsg;
  QString typeID;
  // Parameters for reading packages from directories

  QList<param> paramsInst;
  QList<param> paramsUninst;

  bool noFetch;
  // kpackage doesn't fetch this type of package itself

  QString hostName;
  // Hostname to use for ssh

  bool defaultHandle;

  procbuf reader;
  QString procMsg;
  // for running processes

  QString DELMSG;

  bool isRemote;

public slots:
  virtual void setLocation() = 0;
  virtual void setAvail(LcacheObj *) = 0;
};

#endif





