//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _KCM_KBLUETOOTHD_H_
#define _KCM_KBLUETOOTHD_H_

#include <kcmodule.h>
#include <kaboutdata.h>
#include <qguardedptr.h>

class KJanusWidget;
class ServiceTab;
class ScanTab;

class kcm_kbluetoothd: public KCModule
{
    Q_OBJECT

public:
    kcm_kbluetoothd( QWidget *parent=0, const char *name=0 );
    ~kcm_kbluetoothd();

    virtual void load();
    virtual void save();
    virtual void defaults();
    virtual int buttons();
    virtual QString quickHelp() const;
    virtual const KAboutData *aboutData()
    { return myAboutData; };

public slots:
    void configChanged();

private:
      KAboutData *myAboutData;
      QGuardedPtr<KJanusWidget> tabContainer;
      QGuardedPtr<ServiceTab> serviceTab;
      QGuardedPtr<ConfirmationTab> confirmationTab;
      QGuardedPtr<ScanTab> scanTab;
};

#endif
