/*
 *  Copyright (C) 2012 Felix Geyer <debfx@fobos.de>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 or (at your option)
 *  version 3 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef KEEPASSX_AUTOTYPEASSOCIATIONSMODEL_H
#define KEEPASSX_AUTOTYPEASSOCIATIONSMODEL_H

#include <QAbstractListModel>

#include "core/AutoTypeAssociations.h"

class EntryAttributes;

class AutoTypeAssociationsModel : public QAbstractListModel
{
    Q_OBJECT

public:
    explicit AutoTypeAssociationsModel(QObject* parent = Q_NULLPTR);
    void setAutoTypeAssociations(AutoTypeAssociations* autoTypeAssociations);
    int rowCount(const QModelIndex& parent = QModelIndex()) const Q_DECL_OVERRIDE;
    int columnCount(const QModelIndex& parent = QModelIndex()) const Q_DECL_OVERRIDE;
    QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const Q_DECL_OVERRIDE;
    QVariant data(const QModelIndex& index, int role = Qt::DisplayRole) const Q_DECL_OVERRIDE;

public Q_SLOTS:
    void associationChange(int i);
    void associationAboutToAdd(int i);
    void associationAdd();
    void associationAboutToRemove(int i);
    void associationRemove();
    void aboutToReset();
    void reset();

private:
    AutoTypeAssociations* m_autoTypeAssociations;
};

#endif // KEEPASSX_AUTOTYPEASSOCIATIONSMODEL_H
