/* ============================================================
 * Author: M. Asselstine <asselsm@gmail.com>
 * Date  : 05-08-2005
 * Description : The main widget, show photo properties
 *
 * Copyright 2005 by M. Asselstine

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */


#ifndef _KFLICKRWIDGET_H_
#define _KFLICKRWIDGET_H_

#include "photo.h"
#include "flickrcomm.h"
#include "photoproperties.h"
#include "kflickrWidgetUI.h"
#include "kflickrwidgetiface.h"

#include <kurl.h>
#include <qtimer.h>
#include <qwidget.h>
#include <qstring.h>
#include <qstringlist.h>

class QDropEvent;
class QComboBox;
class QPushButton;
class KPushButton;
class PhotoListView;
class QListViewItem;
class UploadProgress;
class PhotoListViewItem;

/**
 * This is our main widget that contains the widgets to manage user accounts
 * and add, remove and edit photos that are intended for upload.
 * @short The Main Widget.
 * @author M. Asselstine <asselsm@gmail.com>
 */
class kflickrWidget : public kflickrWidgetUI, virtual public kflickrWidgetIface
{
    Q_OBJECT

public:
    kflickrWidget(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~kflickrWidget();

    void addPhoto(const KURL &url);
    void addPhoto(const KURL &url, const QString &title, const QStringList &tags, const QString &desc);
    void addPhotos(const KURL::List &urls);

public slots:
    /** See QWidget basic documentation. We have added an extra bit here that will detect if
     *  a backup file exists and if so prompt the user to determine if the backup session
     *  should be restored.
     */
    virtual void show();

    /** Open the "Add Photos" dialog box allowing the user to select new photos to be uploaded. */
    void addPhotos();

    /** Will remove currently selected photos from the m_photolist */
    void removePhotos();

    /** Upload all the photos in the m_photolist */
    void uploadPhotos();

    /** Called to update the sensitivities of the buttons contained in this widget */
    void updateAvailableActions();

    /** Called to update the photo count used in various places like the status bar. */
    void updateCount(QListViewItem*);

    /** Called to allow the widget to properly handle an error that has occured
     *  in our flickr.com class FlickrComm.
     *  @param errstr The error string detailing the communications error.
     */
    void handleCommError(const QString& errstr);
    void dropSlot(QDropEvent*, QListViewItem*);
    void doUserAuthentication(const QString &frob);
    void newBandwidthValue(const QString &val);
    void addUser(const QString &name, const QString &token, const QString &nsid);

private:
    void uploadNextPhoto();
    void hideUploadProgress();
    void showUploadProgress(int numPhotos);

    /** Updates the dialog used to show the upload progress.
     *  @param pixmap The pixmap to display in the dialog
     *  @param job Pointer to a KIO::TransferJob performing a transfer, default 0
     */
    void updateUploadProgress(const QPixmap& pixmap, KIO::TransferJob* job = 0L);

private slots:
    void cancelUpload();
    void authorizeNewUser();

    void refreshCount();
    void editSelected();
    void setActiveUser(const QString &);
    void photoUploadedOK(const QString &);

signals:
    void photoCount(int);
    void bandwidthValue(const QString&);

private:
    int m_currentUserIndex;         /// Index into the m_userNSIDs list for the current user
    QStringList m_userNSIDs;        /// List of all the authorized user NSIDs
    QStringList m_userTokens;       /// List of all the authorized user tokens
    PhotoListView* m_photolist;     /// Pointer to the list of photos
    PhotoProperties* m_photoProps;  /// Pointer to the photo properties editor widget

    QTimer m_timer;                 /// Timer used to update the picture counter
    FlickrComm m_comm;              /// Instance of the communications class used to talk to flickr
    UploadProgress *m_progressDlg;  /// Displays a dialog to provide upload progress
    bool m_uploadInProgress;        /// True if an upload is in progress, false otherwise
};

#endif

