/* translation of file(s)
	"abs.k"
	"main.k"
	"parse.k"
	"error.k"
	"defocc.k"
	"extocc.k"
	"useocc.k"
	"util.k"
	"gen.k"
	"gutil.k"
	"pat.k"
 */
/* generated by:
 *  @(#)$Author: Kimwitu++ version 2.1.3 (C) 1998-2001 Humboldt-University of Berlin $
 */
#define KC_TYPES

#include "k.h"
#include <stdio.h>
#include <ctype.h>
#include <string>
#include <sys/types.h>
#include <stdlib.h>

#ifdef _MSC_VER
#pragma warning( disable : 4786 )
#endif
#include <new>
#include <set>
#include <list>
#include <algorithm>

#if !defined(USE_HASHSET) && (defined(__GNUC__) || defined(__ICC) || defined(__ECC)) \
&& !defined(DONT_USE_HASHSET)
#  define USE_HASHSET
#endif
#ifdef USE_HASHSET
#  if defined(__GNUC__) && __GNUC__>2
#    include <ext/hash_set>
#  else
#    include <hash_set>
#  endif
#endif

using namespace std;

namespace kc {

inline bool ht_less(casestring p1, casestring p2){
    return strcmp(p1->name, p2->name)<0;
}

inline bool ht_less(nocasestring p1, nocasestring p2){
    return strcmp(p1->name, p2->name)<0;
}

inline bool ht_less(real p1, real p2){
    return p1->value < p2->value;
}

inline bool ht_less(integer p1, integer p2){
    return p1->value < p2->value;
}

inline bool ht_less(voidptr p1, voidptr p2){
    return p1->pointer < p2->pointer;
}

bool
ht_less(abstract_phylum p1, abstract_phylum p2)
{
    kc_enum_operators prod_sel=p1->prod_sel();
    kc_enum_operators prod_sel2=p2->prod_sel();
    if(prod_sel<prod_sel2)
	return true;
    if(prod_sel>prod_sel2)
	return false;
    switch(prod_sel) {
	case sel_NoCaseStr:
	    return ht_less(static_cast<nocasestring>(p1),static_cast<nocasestring>(p2));
	case sel__Str:
	    return ht_less(static_cast<casestring>(p1),static_cast<casestring>(p2));
	case sel__Real:
	    return ht_less(static_cast<real>(p1),static_cast<real>(p2));
	case sel__Int:
	    return ht_less(static_cast<integer>(p1),static_cast<integer>(p2));
	case sel__VoidPtr:
	    return ht_less(static_cast<voidptr>(p1),static_cast<voidptr>(p2));
	default: {
	    int i=0;
	    bool still_unique = kc_storageclass_still_uniq[kc_PhylumInfo[p1->phylum()].uniq_stored];
	    abstract_phylum sub1=0;
	    do {
		sub1=p1->subphylum(i);
		abstract_phylum sub2=p2->subphylum(i);
		if(still_unique) {
		    if(sub1<sub2)
			return true;
		    if(sub2<sub1)
			return false;
		}
		else {
		    if(ht_less(sub1, sub2))
			return true;
		    if(ht_less(sub2, sub1))
			return false;
		}
		++i;
	    } while(sub1);
	}
    }
    return false;
}

template<typename T>
class phylum_less : std::binary_function<T, T, bool>
{
    public:
    bool operator()(const T& X, const T& Y) const
	{ return ht_less(X,Y); }
};

inline void deletefun(c_abstract_phylum t){
    delete const_cast<abstract_phylum>(t);
}


#ifdef USE_HASHSET
struct hashitem {
    size_t hashvalue;
    casestring contents;
    hashitem(casestring cs): contents(cs) {
	unsigned long h = 0;
	char *s = cs->name;
	for ( ; *s; ++s)
	    h = 5*h + *s;
	hashvalue=(size_t)h;
    }
};

inline void deletefunhashitem(hashitem t) {
    delete t.contents;
}

#  ifdef __GNUC__
struct eq_hashitem { bool operator()(hashitem hi1, hashitem hi2) const {
	return strcmp(hi1.contents->name, hi2.contents->name) == 0; } };

struct hash_hashitem { size_t operator()(hashitem hi) const {
	return hi.hashvalue; } };

#  else
struct comp_hashitem {
    enum { bucket_size = 4, min_buckets = 8 };
    // bucket_size and min_buckets are just guesses
    size_t operator()(const hashitem hi) const {
	return hi.hashvalue; }
    bool operator()(const hashitem hi1, const hashitem hi2) const {
	return strcmp(hi1.contents->name, hi2.contents->name) < 0; }
};
#  endif // Whether gcc or icc
#endif // Whether hash or not

struct kc_hashtable_level
{
    kc_hashtable_level(bool cod = true): clean_on_destruction(cod) { }
    void clear() {
	_casestring.clear();
	_nocasestring.clear();
	_integer.clear();
	_real.clear();
	_voidptr.clear();
	_abstract_phylum.clear();
    }
    ~kc_hashtable_level() {
	if (clean_on_destruction)
	{
#ifdef USE_HASHSET
	    std::for_each(_casestring.begin(),_casestring.end(),deletefunhashitem);
#else
	    std::for_each(_casestring.begin(),_casestring.end(),deletefun);
#endif
	    std::for_each(_nocasestring.begin(),_nocasestring.end(),deletefun);
	    std::for_each(_integer.begin(),_integer.end(),deletefun);
	    std::for_each(_real.begin(),_real.end(),deletefun);
	    std::for_each(_voidptr.begin(),_voidptr.end(),deletefun);
	    std::for_each(_abstract_phylum.begin(),_abstract_phylum.end(),deletefun);
	}
	clear();
    }
    abstract_phylum check_insert(abstract_phylum t) {
	return *_abstract_phylum.insert(t).first;
    }
    casestring check_insert(casestring t) {
#ifdef USE_HASHSET
	return (*_casestring.insert(hashitem(t)).first).contents;
#else
	return *_casestring.insert(t).first;
#endif
    }
    nocasestring check_insert(nocasestring t) {
	return *_nocasestring.insert(t).first;
    }
    integer check_insert(integer t) {
	return *_integer.insert(t).first;
    }
    real check_insert(real t) {
	return *_real.insert(t).first;
    }
    voidptr check_insert(voidptr t) {
	return *_voidptr.insert(t).first;
    }
private:
    bool clean_on_destruction;
#ifdef USE_HASHSET
#  ifdef __GNUC__
    std::hash_set<hashitem, hash_hashitem, eq_hashitem> _casestring;
#  else
    std::hash_set<hashitem, comp_hashitem> _casestring;
#  endif
#else
    std::set<casestring, phylum_less<casestring> > _casestring;
#endif
    std::set<nocasestring, phylum_less<nocasestring> > _nocasestring;
    std::set<integer, phylum_less<integer> > _integer;
    std::set<real, phylum_less<real> > _real;
    std::set<voidptr, phylum_less<voidptr> > _voidptr;
    std::set<abstract_phylum, phylum_less<abstract_phylum> > _abstract_phylum;
};

class kc_hashtable_stack: public std::list<kc_hashtable_level> {
public:
    kc_hashtable_stack(): _pos(begin()) { }

    void inc_level() { _pos=insert(_pos, kc_hashtable_level()); }
    void dec_level() { if(valid() && _pos!=end()) ++_pos; }
    void free_level() { if(_pos!=begin()) { erase(begin(),_pos);_pos=begin(); } }

    bool valid() const { return !empty(); }
    kc_hashtable_level& get_level() { return *_pos; }

    template<typename T>
    T check_insert(T t) {
	return dynamic_cast<T>((*_pos).check_insert(t));
    }
private:
    iterator _pos;
};

class kc_hashtable_struct_t {
public:
    // don't clean _static_level on destruction (program ends)
    kc_hashtable_struct_t(): _static_level(false), _to_be_freed(false),  _dynamic(false) { }

    template <typename T>
    T kc_ht_check_insert(T t) {
	if(_dynamic && _dynamic_level.valid())
	    return _dynamic_level.check_insert(t);
	else
	    return dynamic_cast<T>(_static_level.check_insert(t));
    }
    void kc_ht_static() {_dynamic=false; }
    void kc_ht_dynamic() {
	_dynamic=true;
	if(!_dynamic_level.valid())
	    _dynamic_level.inc_level();
    }
    void kc_ht_inc_level() { _dynamic_level.inc_level(); }
    void kc_ht_dec_level() { _dynamic_level.dec_level(); }
    void kc_ht_free_level() { _dynamic_level.free_level(); }
    void kc_ht_clear() { _static_level.clear(); _dynamic_level.clear(); _dynamic=false; }
    void kc_ht_reuse() { kc_ht_clear(); }

    bool to_be_freed() { return _to_be_freed; }
    void set_to_be_freed(bool b=true) { _to_be_freed=b; }
private:
    kc_hashtable_level _static_level;
    kc_hashtable_stack _dynamic_level;
    bool _to_be_freed; /* should be true for dynamic, false for statically allocated structures */
    bool _dynamic;
};

kc_tag_nocasestring_NoCaseStr::kc_tag_nocasestring_NoCaseStr(const char* _name) {
    name=strcpy(new char[strlen(_name)+1],_name);
    for (int i=0; (name[i] = tolower(name[i])); ++i );
}
kc_tag_nocasestring_NoCaseStr::kc_tag_nocasestring_NoCaseStr(const char* _name, unsigned int length) {
    name=strncpy(new char[length+1],_name,length);
    name[length]=0;
    for (int i=0; (name[i] = tolower(name[i])); ++i );
}
kc_tag_casestring__Str::kc_tag_casestring__Str(const char* _name) {
    name=strcpy(new char[strlen(_name)+1],_name);
}
kc_tag_casestring__Str::kc_tag_casestring__Str(const char* _name, unsigned int length) {
    name=strncpy(new char[length+1],_name,length);
    name[length]=0;
}
abstract_phylum kc_tag_bindingidmark_BindingIdMark::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return uniqID_1;
    }
    return 0;
}
abstract_phylum kc_tag_bindingidmarks::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return bindingidmark_1;
	case 1: return bindingidmarks_1;
    }
    return 0;
}
abstract_phylum kc_tag_countedphylumdeclaration_CountedPhylumdeclaration::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return uniqID_1;
    }
    return 0;
}
abstract_phylum kc_tag_countedphylumdeclarations::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return countedphylumdeclaration_1;
	case 1: return countedphylumdeclarations_1;
    }
    return 0;
}
abstract_phylum kc_tag_addedphylumdeclaration_AddedPhylumdeclaration::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return uniqID_1;
    }
    return 0;
}
abstract_phylum kc_tag_addedphylumdeclarations::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return addedphylumdeclaration_1;
	case 1: return addedphylumdeclarations_1;
    }
    return 0;
}
abstract_phylum kc_tag_problem_Problem6::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
	case 1: return casestring_2;
	case 2: return casestring_3;
	case 3: return casestring_4;
	case 4: return casestring_5;
	case 5: return casestring_6;
    }
    return 0;
}
abstract_phylum kc_tag_problem_Problem5::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
	case 1: return casestring_2;
	case 2: return casestring_3;
	case 3: return casestring_4;
	case 4: return casestring_5;
    }
    return 0;
}
abstract_phylum kc_tag_problem_Problem4::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
	case 1: return casestring_2;
	case 2: return casestring_3;
	case 3: return casestring_4;
    }
    return 0;
}
abstract_phylum kc_tag_problem_Problem3int1::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
	case 1: return casestring_2;
	case 2: return casestring_3;
	case 3: return integer_1;
	case 4: return casestring_4;
    }
    return 0;
}
abstract_phylum kc_tag_problem_Problem3::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
	case 1: return casestring_2;
	case 2: return casestring_3;
    }
    return 0;
}
abstract_phylum kc_tag_problem_Problem2::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
	case 1: return casestring_2;
    }
    return 0;
}
abstract_phylum kc_tag_problem_Problem1storageoption1ID::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
	case 1: return storageoption_1;
	case 2: return casestring_2;
	case 3: return ID_1;
    }
    return 0;
}
abstract_phylum kc_tag_problem_Problem1INT1ID1ID::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
	case 1: return INT_1;
	case 2: return casestring_2;
	case 3: return ID_1;
	case 4: return casestring_3;
	case 5: return ID_2;
    }
    return 0;
}
abstract_phylum kc_tag_problem_Problem1ID1ID1ID::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
	case 1: return ID_1;
	case 2: return casestring_2;
	case 3: return ID_2;
	case 4: return casestring_3;
	case 5: return ID_3;
    }
    return 0;
}
abstract_phylum kc_tag_problem_Problem1INT1ID::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
	case 1: return INT_1;
	case 2: return casestring_2;
	case 3: return ID_1;
    }
    return 0;
}
abstract_phylum kc_tag_problem_Problem1int1::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
	case 1: return integer_1;
	case 2: return casestring_2;
    }
    return 0;
}
abstract_phylum kc_tag_problem_Problem1INT::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
	case 1: return INT_1;
    }
    return 0;
}
abstract_phylum kc_tag_problem_Problem1t1ID::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
	case 1: return IDtype_1;
	case 2: return casestring_2;
	case 3: return ID_1;
    }
    return 0;
}
abstract_phylum kc_tag_problem_Problem1ID1ID::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
	case 1: return ID_1;
	case 2: return casestring_2;
	case 3: return ID_2;
    }
    return 0;
}
abstract_phylum kc_tag_problem_Problem1we::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
	case 1: return withexpression_1;
    }
    return 0;
}
abstract_phylum kc_tag_problem_Problem1tID::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
	case 1: return ID_1;
    }
    return 0;
}
abstract_phylum kc_tag_problem_Problem1ID::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
	case 1: return ID_1;
    }
    return 0;
}
abstract_phylum kc_tag_problem_Problem1::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
    }
    return 0;
}
abstract_phylum kc_tag_error_Warning::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return fileline_1;
	case 1: return problem_1;
    }
    return 0;
}
abstract_phylum kc_tag_error_NonFatal::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return fileline_1;
	case 1: return problem_1;
    }
    return 0;
}
abstract_phylum kc_tag_error_Fatal::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return fileline_1;
	case 1: return problem_1;
    }
    return 0;
}
abstract_phylum kc_tag_baseclass_list::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return baseclass_list_1;
    }
    return 0;
}
abstract_phylum kc_tag_baseclass_decl_BaseClassDecl::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return baseclass_list_1;
    }
    return 0;
}
abstract_phylum kc_tag_baseclass_declarations::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return baseclass_decl_1;
	case 1: return baseclass_declarations_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_base_init_AcBaseInit::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return ac_constant_expression_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_base_init_list::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return ac_base_init_1;
	case 1: return ac_base_init_list_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_opt_base_init_list_AcYesBaseInit::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_base_init_list_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_constant_expression_list::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return ac_constant_expression_1;
	case 1: return ac_constant_expression_list_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_constant_expression_AcConstExpr::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return Cexpression_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_constant_expression_option_Yesac_constant_expression::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_constant_expression_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_direct_abstract_declarator_AcDirAbsdeclFn::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_direct_abstract_declarator_option_1;
	case 1: return ac_parameter_type_list_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_direct_abstract_declarator_AcDirAbsdeclArray::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_direct_abstract_declarator_option_1;
	case 1: return ac_constant_expression_option_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_direct_abstract_declarator_AcDirAbsdeclPack::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_abstract_declarator_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_direct_abstract_declarator_option_Yesac_direct_abstract_declarator::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_direct_abstract_declarator_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_abstract_declarator_AcAbsdeclDirdecl::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_pointer_option_1;
	case 1: return ac_direct_abstract_declarator_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_abstract_declarator_AcAbsdeclPointer::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_pointer_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_identifier_list::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return ac_identifier_list_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_parameter_declaration_AcParDeclAbsdecl::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_declaration_specifiers_1;
	case 1: return ac_abstract_declarator_1;
	case 2: return ac_constant_expression_option_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_parameter_declaration_AcParDeclDecl::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_declaration_specifiers_1;
	case 1: return ac_declarator_1;
	case 2: return ac_constant_expression_option_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_parameter_list::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return ac_parameter_declaration_1;
	case 1: return ac_parameter_list_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_parameter_type_list_AcParList3Dot::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_parameter_list_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_parameter_type_list_AcParList::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_parameter_list_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_type_qualifier_list::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return ac_type_qualifier_1;
	case 1: return ac_type_qualifier_list_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_class_qualifier_list::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return ac_class_qualifier_list_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_class_qualifier_help_list::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return ac_direct_declarator_1;
	case 1: return ac_class_qualifier_help_list_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_operator_name_AcOperatorName::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_pointer_AcPointerCons::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_type_qualifier_list_1;
	case 1: return ac_pointer_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_pointer_AcPointerNil::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_type_qualifier_list_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_pointer_option_Yespointer::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_pointer_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_direct_declarator_AcOperatorDeclId::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_operator_name_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_direct_declarator_AcMemberDecl::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return ID_2;
	case 2: return ac_constant_expression_list_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_direct_declarator_AcQualifiedDeclProto::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_class_qualifier_list_1;
	case 1: return ac_direct_declarator_1;
	case 2: return ac_parameter_type_list_1;
	case 3: return ac_type_qualifier_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_direct_declarator_AcDirectDeclProto::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_direct_declarator_1;
	case 1: return ac_parameter_type_list_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_direct_declarator_AcDirectDeclArray::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_direct_declarator_1;
	case 1: return ac_constant_expression_option_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_direct_declarator_AcDirectDeclPack::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_declarator_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_direct_declarator_AcDirectDeclId::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_declarator_AcDeclarator::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_pointer_option_1;
	case 1: return ac_ref_option_1;
	case 2: return ac_direct_declarator_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_init_declarator_AcInitDecl::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_declarator_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_init_declarator_list::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return ac_init_declarator_1;
	case 1: return ac_init_declarator_list_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_type_specifier_AcTypeSpec::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_declaration_specifier_AcDeclSpecTypeQual::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_type_qualifier_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_declaration_specifier_AcDeclSpecTypeSpec::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_type_specifier_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_declaration_specifier_AcDeclSpecStorageSpec::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_storage_class_specifier_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_declaration_specifiers::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return ac_declaration_specifier_1;
	case 1: return ac_declaration_specifiers_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_declaration_list::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return ac_declaration_1;
	case 1: return ac_declaration_list_1;
    }
    return 0;
}
abstract_phylum kc_tag_ac_declaration_AcDeclaration::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_declaration_specifiers_1;
	case 1: return ac_init_declarator_list_1;
    }
    return 0;
}
abstract_phylum kc_tag_unparsedeclinfo_Unparsedeclinfo::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return patternrepresentation_1;
	case 1: return patternrepresentation_2;
	case 2: return unparseclause_1;
    }
    return 0;
}
abstract_phylum kc_tag_unparsedeclsinfo::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return unparsedeclinfo_1;
	case 1: return unparsedeclsinfo_1;
    }
    return 0;
}
abstract_phylum kc_tag_unparseviewinfo_Unparseviewinfo::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return unparsedeclsinfo_1;
    }
    return 0;
}
abstract_phylum kc_tag_unparseviewsinfo::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return unparseviewinfo_1;
	case 1: return unparseviewsinfo_1;
    }
    return 0;
}
abstract_phylum kc_tag_rewriteviewinfo_Rewriteviewinfo::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return rewriterulesinfo_1;
    }
    return 0;
}
abstract_phylum kc_tag_rewriteviewsinfo::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return rewriteviewinfo_1;
	case 1: return rewriteviewsinfo_1;
    }
    return 0;
}
abstract_phylum kc_tag_withcaseinfo_Withcaseinfo::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return patternrepresentation_1;
	case 1: return patternrepresentation_2;
	case 2: return Ctext_1;
    }
    return 0;
}
abstract_phylum kc_tag_withcasesinfo::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return withcaseinfo_1;
	case 1: return withcasesinfo_1;
    }
    return 0;
}
abstract_phylum kc_tag_rewriteruleinfo_Rewriteruleinfo::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return patternrepresentation_1;
	case 1: return patternrepresentation_2;
	case 2: return rewriteclause_1;
    }
    return 0;
}
abstract_phylum kc_tag_rewriterulesinfo::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return rewriteruleinfo_1;
	case 1: return rewriterulesinfo_1;
    }
    return 0;
}
abstract_phylum kc_tag_argsnumbers::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return integer_1;
	case 1: return argsnumbers_1;
    }
    return 0;
}
abstract_phylum kc_tag_paths::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return path_1;
	case 1: return paths_1;
    }
    return 0;
}
abstract_phylum kc_tag_path::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return integer_1;
	case 1: return path_1;
    }
    return 0;
}
abstract_phylum kc_tag_elem_patternrepresentation_PRIntLiteral::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return path_1;
	case 1: return INT_1;
    }
    return 0;
}
abstract_phylum kc_tag_elem_patternrepresentation_PRStringLiteral::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return path_1;
	case 1: return CexpressionDQ_1;
    }
    return 0;
}
abstract_phylum kc_tag_elem_patternrepresentation_PRWildcard::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return path_1;
    }
    return 0;
}
abstract_phylum kc_tag_elem_patternrepresentation_PRNonLeafBinding::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return path_1;
	case 1: return ID_1;
	case 2: return patternrepresentation_1;
    }
    return 0;
}
abstract_phylum kc_tag_elem_patternrepresentation_PRUserPredicate::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return Cexpression_1;
    }
    return 0;
}
abstract_phylum kc_tag_elem_patternrepresentation_PROperPredicate::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return path_1;
	case 1: return ID_1;
    }
    return 0;
}
abstract_phylum kc_tag_elem_patternrepresentation_PRVarPredicate::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return paths_1;
	case 1: return ID_1;
	case 2: return patternrepresentation_1;
    }
    return 0;
}
abstract_phylum kc_tag_elem_patternrepresentation_PRBinding::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return path_1;
	case 1: return ID_1;
    }
    return 0;
}
abstract_phylum kc_tag_patternrepresentation::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return elem_patternrepresentation_1;
	case 1: return patternrepresentation_1;
    }
    return 0;
}
abstract_phylum kc_tag_patternrepresentations::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return patternrepresentation_1;
	case 1: return patternrepresentations_1;
    }
    return 0;
}
abstract_phylum kc_tag_two_phyla_TwoPath::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return path_1;
	case 1: return path_2;
    }
    return 0;
}
abstract_phylum kc_tag_two_phyla_TwoPaths::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return paths_1;
	case 1: return paths_2;
    }
    return 0;
}
abstract_phylum kc_tag_two_phyla_TwoElem_patternrepresentation::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return elem_patternrepresentation_1;
	case 1: return elem_patternrepresentation_2;
    }
    return 0;
}
abstract_phylum kc_tag_two_phyla_TwoPatternrepresentation::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return patternrepresentation_1;
	case 1: return patternrepresentation_2;
    }
    return 0;
}
abstract_phylum kc_tag_two_phyla_TwoUnparsedeclinfo::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return unparsedeclinfo_1;
	case 1: return unparsedeclinfo_2;
    }
    return 0;
}
abstract_phylum kc_tag_two_phyla_TwoWithcaseinfo::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return withcaseinfo_1;
	case 1: return withcaseinfo_2;
    }
    return 0;
}
abstract_phylum kc_tag_two_phyla_TwoRewriteruleinfo::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return rewriteruleinfo_1;
	case 1: return rewriteruleinfo_2;
    }
    return 0;
}
abstract_phylum kc_tag_two_phyla_TwoCcode_option::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return Ccode_option_1;
	case 1: return Ccode_option_2;
    }
    return 0;
}
abstract_phylum kc_tag_two_phyla_TwoProductionblock::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return productionblock_1;
	case 1: return productionblock_2;
    }
    return 0;
}
abstract_phylum kc_tag_two_phyla_TwoStorageoption::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return storageoption_1;
	case 1: return storageoption_2;
    }
    return 0;
}
abstract_phylum kc_tag_variables::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return variables_1;
    }
    return 0;
}
abstract_phylum kc_tag_phyla::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return phyla_1;
    }
    return 0;
}
abstract_phylum kc_tag_operators::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return operators_1;
    }
    return 0;
}
abstract_phylum kc_tag_IDtype_ITLanguageName::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return integer_1;
    }
    return 0;
}
abstract_phylum kc_tag_IDtype_ITPatternVariable::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return integer_1;
    }
    return 0;
}
abstract_phylum kc_tag_IDtype_ITUserFunction::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return fnclass_1;
    }
    return 0;
}
abstract_phylum kc_tag_IDtype_ITUserOperator::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return alternative_1;
	case 1: return ID_1;
    }
    return 0;
}
abstract_phylum kc_tag_IDtype_ITPredefinedOperator::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return alternative_1;
	case 1: return ID_1;
    }
    return 0;
}
abstract_phylum kc_tag_IDtype_ITUserPhylum::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return phylumdeclaration_1;
    }
    return 0;
}
abstract_phylum kc_tag_IDtype_ITPredefinedPhylum::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return phylumdeclaration_1;
    }
    return 0;
}
abstract_phylum kc_tag_scopetypefileline_ScopeTypeFileLine::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return integer_1;
	case 1: return IDtype_1;
	case 2: return casestring_1;
	case 3: return integer_2;
    }
    return 0;
}
abstract_phylum kc_tag_scopetypefilelinestack::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return scopetypefileline_1;
	case 1: return scopetypefilelinestack_1;
    }
    return 0;
}
abstract_phylum kc_tag_languagenames::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return languagenames_1;
    }
    return 0;
}
abstract_phylum kc_tag_languageoption_LanguageList::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return languagenames_1;
    }
    return 0;
}
abstract_phylum kc_tag_viewnameoption_YesViewname::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
    }
    return 0;
}
abstract_phylum kc_tag_unpattributes::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return unpattributes_1;
    }
    return 0;
}
abstract_phylum kc_tag_unpsubterm_UnpCastedVariable::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return ID_2;
    }
    return 0;
}
abstract_phylum kc_tag_unpsubterm_UnpDollarvarAttr::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return INT_1;
	case 1: return unpattributes_1;
    }
    return 0;
}
abstract_phylum kc_tag_unpsubterm_UnpSubAttr::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return unpattributes_1;
    }
    return 0;
}
abstract_phylum kc_tag_unpsubterm_UnpDollarvarTerm::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return INT_1;
    }
    return 0;
}
abstract_phylum kc_tag_unpsubterm_UnpSubTerm::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
    }
    return 0;
}
abstract_phylum kc_tag_unparseitem_UViewVarDecl::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return ID_2;
	case 2: return Cexpression_1;
    }
    return 0;
}
abstract_phylum kc_tag_unparseitem_UnpBody::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return languageoption_1;
	case 1: return unparseitems_1;
    }
    return 0;
}
abstract_phylum kc_tag_unparseitem_UnpCtext::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return languageoption_1;
	case 1: return Ctext_1;
    }
    return 0;
}
abstract_phylum kc_tag_unparseitem_UnpSubexpr::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return languageoption_1;
	case 1: return unpsubterm_1;
	case 2: return viewnameoption_1;
    }
    return 0;
}
abstract_phylum kc_tag_unparseitem_UnpStr::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return languageoption_1;
	case 1: return CexpressionDQ_1;
	case 2: return viewnameoption_1;
    }
    return 0;
}
abstract_phylum kc_tag_unparseitems::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return unparseitem_1;
	case 1: return unparseitems_1;
    }
    return 0;
}
abstract_phylum kc_tag_viewnames::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return viewnames_1;
    }
    return 0;
}
abstract_phylum kc_tag_unparseclause_UnparseClause::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return viewnames_1;
	case 1: return unparseitems_1;
    }
    return 0;
}
abstract_phylum kc_tag_unparseclauses::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return unparseclause_1;
	case 1: return unparseclauses_1;
    }
    return 0;
}
abstract_phylum kc_tag_unparsedeclaration_UnparseDeclaration::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return outmostpatterns_1;
	case 1: return unparseclauses_1;
    }
    return 0;
}
abstract_phylum kc_tag_unparsedeclarations::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return unparsedeclaration_1;
	case 1: return unparsedeclarations_1;
    }
    return 0;
}
abstract_phylum kc_tag_withcase_Withcase::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return patternchains_1;
	case 1: return Ctext_1;
    }
    return 0;
}
abstract_phylum kc_tag_withcases::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return withcase_1;
	case 1: return withcases_1;
    }
    return 0;
}
abstract_phylum kc_tag_withexpression_WECexpression::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return Cexpression_1;
    }
    return 0;
}
abstract_phylum kc_tag_withexpression_WEVariable::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
    }
    return 0;
}
abstract_phylum kc_tag_withexpressions::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return withexpression_1;
	case 1: return withexpressions_1;
    }
    return 0;
}
abstract_phylum kc_tag_contextinfo_InForeachContext::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return patternchain_1;
    }
    return 0;
}
abstract_phylum kc_tag_foreach_after_ForeachAfter::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return patternchain_1;
	case 1: return idCexpressions_1;
	case 2: return withexpressions_1;
	case 3: return Ctext_1;
    }
    return 0;
}
abstract_phylum kc_tag_Ctext_elem_CTextWithexpression::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return withexpressions_1;
	case 1: return withcases_1;
	case 2: return contextinfo_1;
    }
    return 0;
}
abstract_phylum kc_tag_Ctext_elem_CTextForeachexpression::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return patternchain_1;
	case 1: return idCexpressions_1;
	case 2: return withexpressions_1;
	case 3: return Ctext_1;
	case 4: return foreach_after_1;
    }
    return 0;
}
abstract_phylum kc_tag_Ctext_elem_CTextCbody::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return Ctext_1;
    }
    return 0;
}
abstract_phylum kc_tag_Ctext_elem_CTextCexpressionSQ::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return CexpressionSQ_1;
    }
    return 0;
}
abstract_phylum kc_tag_Ctext_elem_CTextCexpressionDQ::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return CexpressionDQ_1;
    }
    return 0;
}
abstract_phylum kc_tag_Ctext_elem_CTextNl::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return integer_1;
    }
    return 0;
}
abstract_phylum kc_tag_Ctext_elem_CTextDollarVar::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return INT_1;
    }
    return 0;
}
abstract_phylum kc_tag_Ctext_elem_CTextLine::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
    }
    return 0;
}
abstract_phylum kc_tag_Ctext::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return Ctext_elem_1;
	case 1: return Ctext_1;
    }
    return 0;
}
abstract_phylum kc_tag_fnclass_StaticFn::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
    }
    return 0;
}
abstract_phylum kc_tag_fndeclaration_AcMemberDeclaration::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_declaration_specifiers_1;
	case 1: return ac_declarator_1;
	case 2: return ac_constant_expression_option_1;
	case 3: return fnclass_1;
    }
    return 0;
}
abstract_phylum kc_tag_fndeclaration_FnAcDeclaration::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ac_declaration_specifiers_1;
	case 1: return ac_declarator_1;
	case 2: return ac_declaration_list_1;
	case 3: return ac_opt_base_init_list_1;
	case 4: return Ctext_1;
	case 5: return ID_1;
	case 6: return fnclass_1;
    }
    return 0;
}
abstract_phylum kc_tag_fndeclarations::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return fndeclaration_1;
	case 1: return fndeclarations_1;
    }
    return 0;
}
abstract_phylum kc_tag_fnfile_FnFile::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
    }
    return 0;
}
abstract_phylum kc_tag_fnfiles::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return fnfile_1;
	case 1: return fnfiles_1;
    }
    return 0;
}
abstract_phylum kc_tag_terms::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return term_1;
	case 1: return terms_1;
    }
    return 0;
}
abstract_phylum kc_tag_term_TIntLiteral::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return INT_1;
    }
    return 0;
}
abstract_phylum kc_tag_term_TStringLiteral::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return CexpressionDQ_1;
    }
    return 0;
}
abstract_phylum kc_tag_term_TCTerm::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return CexpressionSQ_1;
    }
    return 0;
}
abstract_phylum kc_tag_term_TMethod::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return term_1;
	case 1: return ID_1;
	case 2: return terms_1;
    }
    return 0;
}
abstract_phylum kc_tag_term_TOperator::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return terms_1;
    }
    return 0;
}
abstract_phylum kc_tag_term_TVariable::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
    }
    return 0;
}
abstract_phylum kc_tag_patterns::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return pattern_1;
	case 1: return patterns_1;
    }
    return 0;
}
abstract_phylum kc_tag_pattern_PIntLiteral::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return INT_1;
    }
    return 0;
}
abstract_phylum kc_tag_pattern_PStringLiteral::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return CexpressionDQ_1;
    }
    return 0;
}
abstract_phylum kc_tag_pattern_PNonLeafVariable::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return pattern_1;
    }
    return 0;
}
abstract_phylum kc_tag_pattern_POperator::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return patterns_1;
    }
    return 0;
}
abstract_phylum kc_tag_pattern_PVariable::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
    }
    return 0;
}
abstract_phylum kc_tag_outmostpattern_OPDefault::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return Cexpression_1;
    }
    return 0;
}
abstract_phylum kc_tag_outmostpattern_OPWildcard::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return Cexpression_1;
    }
    return 0;
}
abstract_phylum kc_tag_outmostpattern_OPNonLeafVariable::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return outmostpattern_1;
    }
    return 0;
}
abstract_phylum kc_tag_outmostpattern_OPOperator::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return patterns_1;
	case 2: return Cexpression_1;
    }
    return 0;
}
abstract_phylum kc_tag_outmostpattern_OPOperatorWildcard::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return Cexpression_1;
    }
    return 0;
}
abstract_phylum kc_tag_patternchainitem_PatternchainitemDollarid::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
    }
    return 0;
}
abstract_phylum kc_tag_patternchainitem_PatternchainitemGroup::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return patternchains_1;
    }
    return 0;
}
abstract_phylum kc_tag_patternchainitem_PatternchainitemOutmost::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return outmostpattern_1;
    }
    return 0;
}
abstract_phylum kc_tag_outmostpatterns::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return outmostpattern_1;
	case 1: return outmostpatterns_1;
    }
    return 0;
}
abstract_phylum kc_tag_patternchain::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return patternchainitem_1;
	case 1: return patternchain_1;
    }
    return 0;
}
abstract_phylum kc_tag_patternchains::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return patternchain_1;
	case 1: return patternchains_1;
    }
    return 0;
}
abstract_phylum kc_tag_rewriteclause_RewriteClause::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return viewnames_1;
	case 1: return term_1;
    }
    return 0;
}
abstract_phylum kc_tag_rewriteclauses::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return rewriteclause_1;
	case 1: return rewriteclauses_1;
    }
    return 0;
}
abstract_phylum kc_tag_rwdeclaration_RwDeclaration::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return outmostpatterns_1;
	case 1: return rewriteclauses_1;
    }
    return 0;
}
abstract_phylum kc_tag_rwdeclarations::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return rwdeclaration_1;
	case 1: return rwdeclarations_1;
    }
    return 0;
}
abstract_phylum kc_tag_includedeclaration_IncludeDeclaration::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
    }
    return 0;
}
abstract_phylum kc_tag_includedeclarations::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return includedeclaration_1;
	case 1: return includedeclarations_1;
    }
    return 0;
}
abstract_phylum kc_tag_includefile_IncludeFile::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
    }
    return 0;
}
abstract_phylum kc_tag_includefiles::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return includefile_1;
	case 1: return includefiles_1;
    }
    return 0;
}
abstract_phylum kc_tag_Ctexts::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return Ctext_1;
	case 1: return Ctexts_1;
    }
    return 0;
}
abstract_phylum kc_tag_idCexpression_IdCexpression::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return Cexpression_1;
    }
    return 0;
}
abstract_phylum kc_tag_idCexpressions::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return idCexpression_1;
	case 1: return idCexpressions_1;
    }
    return 0;
}
abstract_phylum kc_tag_CexpressionSQ_elem_CExpressionSQNl::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return integer_1;
    }
    return 0;
}
abstract_phylum kc_tag_CexpressionSQ_elem_CExpressionSQPart::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
    }
    return 0;
}
abstract_phylum kc_tag_CexpressionSQ::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return CexpressionSQ_elem_1;
	case 1: return CexpressionSQ_1;
    }
    return 0;
}
abstract_phylum kc_tag_CexpressionDQ_elem_CExpressionDQNl::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return integer_1;
    }
    return 0;
}
abstract_phylum kc_tag_CexpressionDQ_elem_CExpressionDQPart::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
    }
    return 0;
}
abstract_phylum kc_tag_CexpressionDQ::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return CexpressionDQ_elem_1;
	case 1: return CexpressionDQ_1;
    }
    return 0;
}
abstract_phylum kc_tag_Cexpression_elem_CExpressionArray::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return Cexpression_1;
    }
    return 0;
}
abstract_phylum kc_tag_Cexpression_elem_CExpressionPack::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return Cexpression_1;
    }
    return 0;
}
abstract_phylum kc_tag_Cexpression_elem_CExpressionSQ::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return CexpressionSQ_1;
    }
    return 0;
}
abstract_phylum kc_tag_Cexpression_elem_CExpressionDQ::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return CexpressionDQ_1;
    }
    return 0;
}
abstract_phylum kc_tag_Cexpression_elem_CExpressionNl::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return integer_1;
    }
    return 0;
}
abstract_phylum kc_tag_Cexpression_elem_CExpressionDollarvar::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return INT_1;
    }
    return 0;
}
abstract_phylum kc_tag_Cexpression_elem_CExpressionPart::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
    }
    return 0;
}
abstract_phylum kc_tag_Cexpression::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return Cexpression_elem_1;
	case 1: return Cexpression_1;
    }
    return 0;
}
abstract_phylum kc_tag_attribute_initialisation_option_Yesattribute_initialisation::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return Cexpression_1;
    }
    return 0;
}
abstract_phylum kc_tag_attribute_Attribute::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return ID_2;
	case 2: return attribute_initialisation_option_1;
    }
    return 0;
}
abstract_phylum kc_tag_attributes::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return attribute_1;
	case 1: return attributes_1;
    }
    return 0;
}
abstract_phylum kc_tag_Ccode_option_CcodeOption::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return attributes_1;
	case 1: return Ctexts_1;
    }
    return 0;
}
abstract_phylum kc_tag_argument_Argument::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return integer_1;
    }
    return 0;
}
abstract_phylum kc_tag_arguments::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return arguments_1;
    }
    return 0;
}
abstract_phylum kc_tag_alternative_Alternative::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return arguments_1;
    }
    return 0;
}
abstract_phylum kc_tag_alternatives::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return alternative_1;
	case 1: return alternatives_1;
    }
    return 0;
}
abstract_phylum kc_tag_productionblock_PredefinedAlternatives::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return alternatives_1;
    }
    return 0;
}
abstract_phylum kc_tag_productionblock_NonlistAlternatives::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return alternatives_1;
    }
    return 0;
}
abstract_phylum kc_tag_productionblock_ListAlternatives::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return alternatives_1;
	case 1: return ID_1;
    }
    return 0;
}
abstract_phylum kc_tag_storageclasses::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return storageclasses_1;
    }
    return 0;
}
abstract_phylum kc_tag_storageoption_PositiveStorageOption::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
    }
    return 0;
}
abstract_phylum kc_tag_storageoption_NegativeStorageOption::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
    }
    return 0;
}
abstract_phylum kc_tag_phylumdeclaration_PhylumDeclaration::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return storageoption_1;
	case 2: return productionblock_1;
	case 3: return Ccode_option_1;
    }
    return 0;
}
abstract_phylum kc_tag_phylumnames::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return ID_1;
	case 1: return phylumnames_1;
    }
    return 0;
}
abstract_phylum kc_tag_phylumdeclarations::subphylum(int no, bool do_attr) const
{
    switch(no){
	case 0: return phylumdeclaration_1;
	case 1: return phylumdeclarations_1;
    }
    return 0;
}
abstract_phylum kc_tag_phylumdeclarationsroot_PhylumDeclarations::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return phylumdeclarations_1;
    }
    return 0;
}
abstract_phylum kc_tag_STRING_String::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
    }
    return 0;
}
abstract_phylum kc_tag_INT_Int::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return integer_1;
    }
    return 0;
}
abstract_phylum kc_tag_ID_Id::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return uniqID_1;
    }
    return 0;
}
abstract_phylum kc_tag_uniqID_Str::subphylum(int no, bool kc_rec) const
{
    switch(no){
	case 0: return casestring_1;
    }
    return 0;
}
void kc_tag_bindingidmark_BindingIdMark::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = uniqID_1 = dynamic_cast<uniqID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_bindingidmarks::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = bindingidmark_1 = dynamic_cast<bindingidmark>(val);break;
	case 1: newval = bindingidmarks_1 = dynamic_cast<bindingidmarks>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_countedphylumdeclaration_CountedPhylumdeclaration::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = uniqID_1 = dynamic_cast<uniqID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_countedphylumdeclarations::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = countedphylumdeclaration_1 = dynamic_cast<countedphylumdeclaration>(val);break;
	case 1: newval = countedphylumdeclarations_1 = dynamic_cast<countedphylumdeclarations>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_addedphylumdeclaration_AddedPhylumdeclaration::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = uniqID_1 = dynamic_cast<uniqID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_addedphylumdeclarations::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = addedphylumdeclaration_1 = dynamic_cast<addedphylumdeclaration>(val);break;
	case 1: newval = addedphylumdeclarations_1 = dynamic_cast<addedphylumdeclarations>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_problem_Problem6::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
	case 1: newval = casestring_2 = dynamic_cast<casestring>(val);break;
	case 2: newval = casestring_3 = dynamic_cast<casestring>(val);break;
	case 3: newval = casestring_4 = dynamic_cast<casestring>(val);break;
	case 4: newval = casestring_5 = dynamic_cast<casestring>(val);break;
	case 5: newval = casestring_6 = dynamic_cast<casestring>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_problem_Problem5::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
	case 1: newval = casestring_2 = dynamic_cast<casestring>(val);break;
	case 2: newval = casestring_3 = dynamic_cast<casestring>(val);break;
	case 3: newval = casestring_4 = dynamic_cast<casestring>(val);break;
	case 4: newval = casestring_5 = dynamic_cast<casestring>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_problem_Problem4::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
	case 1: newval = casestring_2 = dynamic_cast<casestring>(val);break;
	case 2: newval = casestring_3 = dynamic_cast<casestring>(val);break;
	case 3: newval = casestring_4 = dynamic_cast<casestring>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_problem_Problem3int1::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
	case 1: newval = casestring_2 = dynamic_cast<casestring>(val);break;
	case 2: newval = casestring_3 = dynamic_cast<casestring>(val);break;
	case 3: newval = integer_1 = dynamic_cast<integer>(val);break;
	case 4: newval = casestring_4 = dynamic_cast<casestring>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_problem_Problem3::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
	case 1: newval = casestring_2 = dynamic_cast<casestring>(val);break;
	case 2: newval = casestring_3 = dynamic_cast<casestring>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_problem_Problem2::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
	case 1: newval = casestring_2 = dynamic_cast<casestring>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_problem_Problem1storageoption1ID::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
	case 1: newval = storageoption_1 = dynamic_cast<storageoption>(val);break;
	case 2: newval = casestring_2 = dynamic_cast<casestring>(val);break;
	case 3: newval = ID_1 = dynamic_cast<ID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_problem_Problem1INT1ID1ID::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
	case 1: newval = INT_1 = dynamic_cast<INT>(val);break;
	case 2: newval = casestring_2 = dynamic_cast<casestring>(val);break;
	case 3: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 4: newval = casestring_3 = dynamic_cast<casestring>(val);break;
	case 5: newval = ID_2 = dynamic_cast<ID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_problem_Problem1ID1ID1ID::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
	case 1: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 2: newval = casestring_2 = dynamic_cast<casestring>(val);break;
	case 3: newval = ID_2 = dynamic_cast<ID>(val);break;
	case 4: newval = casestring_3 = dynamic_cast<casestring>(val);break;
	case 5: newval = ID_3 = dynamic_cast<ID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_problem_Problem1INT1ID::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
	case 1: newval = INT_1 = dynamic_cast<INT>(val);break;
	case 2: newval = casestring_2 = dynamic_cast<casestring>(val);break;
	case 3: newval = ID_1 = dynamic_cast<ID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_problem_Problem1int1::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
	case 1: newval = integer_1 = dynamic_cast<integer>(val);break;
	case 2: newval = casestring_2 = dynamic_cast<casestring>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_problem_Problem1INT::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
	case 1: newval = INT_1 = dynamic_cast<INT>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_problem_Problem1t1ID::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
	case 1: newval = IDtype_1 = dynamic_cast<IDtype>(val);break;
	case 2: newval = casestring_2 = dynamic_cast<casestring>(val);break;
	case 3: newval = ID_1 = dynamic_cast<ID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_problem_Problem1ID1ID::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
	case 1: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 2: newval = casestring_2 = dynamic_cast<casestring>(val);break;
	case 3: newval = ID_2 = dynamic_cast<ID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_problem_Problem1we::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
	case 1: newval = withexpression_1 = dynamic_cast<withexpression>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_problem_Problem1tID::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
	case 1: newval = ID_1 = dynamic_cast<ID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_problem_Problem1ID::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
	case 1: newval = ID_1 = dynamic_cast<ID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_problem_Problem1::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_error_Warning::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = fileline_1 = dynamic_cast<fileline>(val);break;
	case 1: newval = problem_1 = dynamic_cast<problem>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_error_NonFatal::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = fileline_1 = dynamic_cast<fileline>(val);break;
	case 1: newval = problem_1 = dynamic_cast<problem>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_error_Fatal::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = fileline_1 = dynamic_cast<fileline>(val);break;
	case 1: newval = problem_1 = dynamic_cast<problem>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_baseclass_list::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = baseclass_list_1 = dynamic_cast<baseclass_list>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_baseclass_decl_BaseClassDecl::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = baseclass_list_1 = dynamic_cast<baseclass_list>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_baseclass_declarations::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = baseclass_decl_1 = dynamic_cast<baseclass_decl>(val);break;
	case 1: newval = baseclass_declarations_1 = dynamic_cast<baseclass_declarations>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_base_init_AcBaseInit::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = ac_constant_expression_1 = dynamic_cast<ac_constant_expression>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_base_init_list::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_base_init_1 = dynamic_cast<ac_base_init>(val);break;
	case 1: newval = ac_base_init_list_1 = dynamic_cast<ac_base_init_list>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_opt_base_init_list_AcYesBaseInit::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_base_init_list_1 = dynamic_cast<ac_base_init_list>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_constant_expression_list::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_constant_expression_1 = dynamic_cast<ac_constant_expression>(val);break;
	case 1: newval = ac_constant_expression_list_1 = dynamic_cast<ac_constant_expression_list>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_constant_expression_AcConstExpr::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = Cexpression_1 = dynamic_cast<Cexpression>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_constant_expression_option_Yesac_constant_expression::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_constant_expression_1 = dynamic_cast<ac_constant_expression>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_direct_abstract_declarator_AcDirAbsdeclFn::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_direct_abstract_declarator_option_1 = dynamic_cast<ac_direct_abstract_declarator_option>(val);break;
	case 1: newval = ac_parameter_type_list_1 = dynamic_cast<ac_parameter_type_list>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_direct_abstract_declarator_AcDirAbsdeclArray::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_direct_abstract_declarator_option_1 = dynamic_cast<ac_direct_abstract_declarator_option>(val);break;
	case 1: newval = ac_constant_expression_option_1 = dynamic_cast<ac_constant_expression_option>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_direct_abstract_declarator_AcDirAbsdeclPack::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_abstract_declarator_1 = dynamic_cast<ac_abstract_declarator>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_direct_abstract_declarator_option_Yesac_direct_abstract_declarator::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_direct_abstract_declarator_1 = dynamic_cast<ac_direct_abstract_declarator>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_abstract_declarator_AcAbsdeclDirdecl::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_pointer_option_1 = dynamic_cast<ac_pointer_option>(val);break;
	case 1: newval = ac_direct_abstract_declarator_1 = dynamic_cast<ac_direct_abstract_declarator>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_abstract_declarator_AcAbsdeclPointer::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_pointer_1 = dynamic_cast<ac_pointer>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_identifier_list::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = ac_identifier_list_1 = dynamic_cast<ac_identifier_list>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_parameter_declaration_AcParDeclAbsdecl::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_declaration_specifiers_1 = dynamic_cast<ac_declaration_specifiers>(val);break;
	case 1: newval = ac_abstract_declarator_1 = dynamic_cast<ac_abstract_declarator>(val);break;
	case 2: newval = ac_constant_expression_option_1 = dynamic_cast<ac_constant_expression_option>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_parameter_declaration_AcParDeclDecl::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_declaration_specifiers_1 = dynamic_cast<ac_declaration_specifiers>(val);break;
	case 1: newval = ac_declarator_1 = dynamic_cast<ac_declarator>(val);break;
	case 2: newval = ac_constant_expression_option_1 = dynamic_cast<ac_constant_expression_option>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_parameter_list::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_parameter_declaration_1 = dynamic_cast<ac_parameter_declaration>(val);break;
	case 1: newval = ac_parameter_list_1 = dynamic_cast<ac_parameter_list>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_parameter_type_list_AcParList3Dot::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_parameter_list_1 = dynamic_cast<ac_parameter_list>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_parameter_type_list_AcParList::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_parameter_list_1 = dynamic_cast<ac_parameter_list>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_type_qualifier_list::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_type_qualifier_1 = dynamic_cast<ac_type_qualifier>(val);break;
	case 1: newval = ac_type_qualifier_list_1 = dynamic_cast<ac_type_qualifier_list>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_class_qualifier_list::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = ac_class_qualifier_list_1 = dynamic_cast<ac_class_qualifier_list>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_class_qualifier_help_list::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_direct_declarator_1 = dynamic_cast<ac_direct_declarator>(val);break;
	case 1: newval = ac_class_qualifier_help_list_1 = dynamic_cast<ac_class_qualifier_help_list>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_operator_name_AcOperatorName::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_pointer_AcPointerCons::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_type_qualifier_list_1 = dynamic_cast<ac_type_qualifier_list>(val);break;
	case 1: newval = ac_pointer_1 = dynamic_cast<ac_pointer>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_pointer_AcPointerNil::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_type_qualifier_list_1 = dynamic_cast<ac_type_qualifier_list>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_pointer_option_Yespointer::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_pointer_1 = dynamic_cast<ac_pointer>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_direct_declarator_AcOperatorDeclId::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_operator_name_1 = dynamic_cast<ac_operator_name>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_direct_declarator_AcMemberDecl::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = ID_2 = dynamic_cast<ID>(val);break;
	case 2: newval = ac_constant_expression_list_1 = dynamic_cast<ac_constant_expression_list>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_direct_declarator_AcQualifiedDeclProto::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_class_qualifier_list_1 = dynamic_cast<ac_class_qualifier_list>(val);break;
	case 1: newval = ac_direct_declarator_1 = dynamic_cast<ac_direct_declarator>(val);break;
	case 2: newval = ac_parameter_type_list_1 = dynamic_cast<ac_parameter_type_list>(val);break;
	case 3: newval = ac_type_qualifier_1 = dynamic_cast<ac_type_qualifier>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_direct_declarator_AcDirectDeclProto::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_direct_declarator_1 = dynamic_cast<ac_direct_declarator>(val);break;
	case 1: newval = ac_parameter_type_list_1 = dynamic_cast<ac_parameter_type_list>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_direct_declarator_AcDirectDeclArray::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_direct_declarator_1 = dynamic_cast<ac_direct_declarator>(val);break;
	case 1: newval = ac_constant_expression_option_1 = dynamic_cast<ac_constant_expression_option>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_direct_declarator_AcDirectDeclPack::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_declarator_1 = dynamic_cast<ac_declarator>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_direct_declarator_AcDirectDeclId::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_declarator_AcDeclarator::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_pointer_option_1 = dynamic_cast<ac_pointer_option>(val);break;
	case 1: newval = ac_ref_option_1 = dynamic_cast<ac_ref_option>(val);break;
	case 2: newval = ac_direct_declarator_1 = dynamic_cast<ac_direct_declarator>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_init_declarator_AcInitDecl::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_declarator_1 = dynamic_cast<ac_declarator>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_init_declarator_list::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_init_declarator_1 = dynamic_cast<ac_init_declarator>(val);break;
	case 1: newval = ac_init_declarator_list_1 = dynamic_cast<ac_init_declarator_list>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_type_specifier_AcTypeSpec::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_declaration_specifier_AcDeclSpecTypeQual::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_type_qualifier_1 = dynamic_cast<ac_type_qualifier>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_declaration_specifier_AcDeclSpecTypeSpec::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_type_specifier_1 = dynamic_cast<ac_type_specifier>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_declaration_specifier_AcDeclSpecStorageSpec::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_storage_class_specifier_1 = dynamic_cast<ac_storage_class_specifier>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_declaration_specifiers::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_declaration_specifier_1 = dynamic_cast<ac_declaration_specifier>(val);break;
	case 1: newval = ac_declaration_specifiers_1 = dynamic_cast<ac_declaration_specifiers>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_declaration_list::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_declaration_1 = dynamic_cast<ac_declaration>(val);break;
	case 1: newval = ac_declaration_list_1 = dynamic_cast<ac_declaration_list>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ac_declaration_AcDeclaration::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_declaration_specifiers_1 = dynamic_cast<ac_declaration_specifiers>(val);break;
	case 1: newval = ac_init_declarator_list_1 = dynamic_cast<ac_init_declarator_list>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_unparsedeclinfo_Unparsedeclinfo::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = patternrepresentation_1 = dynamic_cast<patternrepresentation>(val);break;
	case 1: newval = patternrepresentation_2 = dynamic_cast<patternrepresentation>(val);break;
	case 2: newval = unparseclause_1 = dynamic_cast<unparseclause>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_unparsedeclsinfo::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = unparsedeclinfo_1 = dynamic_cast<unparsedeclinfo>(val);break;
	case 1: newval = unparsedeclsinfo_1 = dynamic_cast<unparsedeclsinfo>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_unparseviewinfo_Unparseviewinfo::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = unparsedeclsinfo_1 = dynamic_cast<unparsedeclsinfo>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_unparseviewsinfo::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = unparseviewinfo_1 = dynamic_cast<unparseviewinfo>(val);break;
	case 1: newval = unparseviewsinfo_1 = dynamic_cast<unparseviewsinfo>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_rewriteviewinfo_Rewriteviewinfo::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = rewriterulesinfo_1 = dynamic_cast<rewriterulesinfo>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_rewriteviewsinfo::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = rewriteviewinfo_1 = dynamic_cast<rewriteviewinfo>(val);break;
	case 1: newval = rewriteviewsinfo_1 = dynamic_cast<rewriteviewsinfo>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_withcaseinfo_Withcaseinfo::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = patternrepresentation_1 = dynamic_cast<patternrepresentation>(val);break;
	case 1: newval = patternrepresentation_2 = dynamic_cast<patternrepresentation>(val);break;
	case 2: newval = Ctext_1 = dynamic_cast<Ctext>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_withcasesinfo::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = withcaseinfo_1 = dynamic_cast<withcaseinfo>(val);break;
	case 1: newval = withcasesinfo_1 = dynamic_cast<withcasesinfo>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_rewriteruleinfo_Rewriteruleinfo::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = patternrepresentation_1 = dynamic_cast<patternrepresentation>(val);break;
	case 1: newval = patternrepresentation_2 = dynamic_cast<patternrepresentation>(val);break;
	case 2: newval = rewriteclause_1 = dynamic_cast<rewriteclause>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_rewriterulesinfo::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = rewriteruleinfo_1 = dynamic_cast<rewriteruleinfo>(val);break;
	case 1: newval = rewriterulesinfo_1 = dynamic_cast<rewriterulesinfo>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_argsnumbers::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
	case 1: newval = argsnumbers_1 = dynamic_cast<argsnumbers>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_paths::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = path_1 = dynamic_cast<path>(val);break;
	case 1: newval = paths_1 = dynamic_cast<paths>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_path::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
	case 1: newval = path_1 = dynamic_cast<path>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_elem_patternrepresentation_PRIntLiteral::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = path_1 = dynamic_cast<path>(val);break;
	case 1: newval = INT_1 = dynamic_cast<INT>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_elem_patternrepresentation_PRStringLiteral::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = path_1 = dynamic_cast<path>(val);break;
	case 1: newval = CexpressionDQ_1 = dynamic_cast<CexpressionDQ>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_elem_patternrepresentation_PRWildcard::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = path_1 = dynamic_cast<path>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_elem_patternrepresentation_PRNonLeafBinding::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = path_1 = dynamic_cast<path>(val);break;
	case 1: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 2: newval = patternrepresentation_1 = dynamic_cast<patternrepresentation>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_elem_patternrepresentation_PRUserPredicate::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = Cexpression_1 = dynamic_cast<Cexpression>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_elem_patternrepresentation_PROperPredicate::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = path_1 = dynamic_cast<path>(val);break;
	case 1: newval = ID_1 = dynamic_cast<ID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_elem_patternrepresentation_PRVarPredicate::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = paths_1 = dynamic_cast<paths>(val);break;
	case 1: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 2: newval = patternrepresentation_1 = dynamic_cast<patternrepresentation>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_elem_patternrepresentation_PRBinding::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = path_1 = dynamic_cast<path>(val);break;
	case 1: newval = ID_1 = dynamic_cast<ID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_patternrepresentation::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = elem_patternrepresentation_1 = dynamic_cast<elem_patternrepresentation>(val);break;
	case 1: newval = patternrepresentation_1 = dynamic_cast<patternrepresentation>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_patternrepresentations::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = patternrepresentation_1 = dynamic_cast<patternrepresentation>(val);break;
	case 1: newval = patternrepresentations_1 = dynamic_cast<patternrepresentations>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_two_phyla_TwoPath::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = path_1 = dynamic_cast<path>(val);break;
	case 1: newval = path_2 = dynamic_cast<path>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_two_phyla_TwoPaths::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = paths_1 = dynamic_cast<paths>(val);break;
	case 1: newval = paths_2 = dynamic_cast<paths>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_two_phyla_TwoElem_patternrepresentation::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = elem_patternrepresentation_1 = dynamic_cast<elem_patternrepresentation>(val);break;
	case 1: newval = elem_patternrepresentation_2 = dynamic_cast<elem_patternrepresentation>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_two_phyla_TwoPatternrepresentation::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = patternrepresentation_1 = dynamic_cast<patternrepresentation>(val);break;
	case 1: newval = patternrepresentation_2 = dynamic_cast<patternrepresentation>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_two_phyla_TwoUnparsedeclinfo::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = unparsedeclinfo_1 = dynamic_cast<unparsedeclinfo>(val);break;
	case 1: newval = unparsedeclinfo_2 = dynamic_cast<unparsedeclinfo>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_two_phyla_TwoWithcaseinfo::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = withcaseinfo_1 = dynamic_cast<withcaseinfo>(val);break;
	case 1: newval = withcaseinfo_2 = dynamic_cast<withcaseinfo>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_two_phyla_TwoRewriteruleinfo::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = rewriteruleinfo_1 = dynamic_cast<rewriteruleinfo>(val);break;
	case 1: newval = rewriteruleinfo_2 = dynamic_cast<rewriteruleinfo>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_two_phyla_TwoCcode_option::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = Ccode_option_1 = dynamic_cast<Ccode_option>(val);break;
	case 1: newval = Ccode_option_2 = dynamic_cast<Ccode_option>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_two_phyla_TwoProductionblock::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = productionblock_1 = dynamic_cast<productionblock>(val);break;
	case 1: newval = productionblock_2 = dynamic_cast<productionblock>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_two_phyla_TwoStorageoption::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = storageoption_1 = dynamic_cast<storageoption>(val);break;
	case 1: newval = storageoption_2 = dynamic_cast<storageoption>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_variables::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = variables_1 = dynamic_cast<variables>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_phyla::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = phyla_1 = dynamic_cast<phyla>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_operators::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = operators_1 = dynamic_cast<operators>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_IDtype_ITLanguageName::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_IDtype_ITPatternVariable::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_IDtype_ITUserFunction::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = fnclass_1 = dynamic_cast<fnclass>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_IDtype_ITUserOperator::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = alternative_1 = dynamic_cast<alternative>(val);break;
	case 1: newval = ID_1 = dynamic_cast<ID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_IDtype_ITPredefinedOperator::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = alternative_1 = dynamic_cast<alternative>(val);break;
	case 1: newval = ID_1 = dynamic_cast<ID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_IDtype_ITUserPhylum::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = phylumdeclaration_1 = dynamic_cast<phylumdeclaration>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_IDtype_ITPredefinedPhylum::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = phylumdeclaration_1 = dynamic_cast<phylumdeclaration>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_scopetypefileline_ScopeTypeFileLine::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
	case 1: newval = IDtype_1 = dynamic_cast<IDtype>(val);break;
	case 2: newval = casestring_1 = dynamic_cast<casestring>(val);break;
	case 3: newval = integer_2 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_scopetypefilelinestack::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = scopetypefileline_1 = dynamic_cast<scopetypefileline>(val);break;
	case 1: newval = scopetypefilelinestack_1 = dynamic_cast<scopetypefilelinestack>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_languagenames::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = languagenames_1 = dynamic_cast<languagenames>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_languageoption_LanguageList::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = languagenames_1 = dynamic_cast<languagenames>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_viewnameoption_YesViewname::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_unpattributes::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = unpattributes_1 = dynamic_cast<unpattributes>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_unpsubterm_UnpCastedVariable::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = ID_2 = dynamic_cast<ID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_unpsubterm_UnpDollarvarAttr::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = INT_1 = dynamic_cast<INT>(val);break;
	case 1: newval = unpattributes_1 = dynamic_cast<unpattributes>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_unpsubterm_UnpSubAttr::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = unpattributes_1 = dynamic_cast<unpattributes>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_unpsubterm_UnpDollarvarTerm::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = INT_1 = dynamic_cast<INT>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_unpsubterm_UnpSubTerm::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_unparseitem_UViewVarDecl::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = ID_2 = dynamic_cast<ID>(val);break;
	case 2: newval = Cexpression_1 = dynamic_cast<Cexpression>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_unparseitem_UnpBody::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = languageoption_1 = dynamic_cast<languageoption>(val);break;
	case 1: newval = unparseitems_1 = dynamic_cast<unparseitems>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_unparseitem_UnpCtext::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = languageoption_1 = dynamic_cast<languageoption>(val);break;
	case 1: newval = Ctext_1 = dynamic_cast<Ctext>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_unparseitem_UnpSubexpr::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = languageoption_1 = dynamic_cast<languageoption>(val);break;
	case 1: newval = unpsubterm_1 = dynamic_cast<unpsubterm>(val);break;
	case 2: newval = viewnameoption_1 = dynamic_cast<viewnameoption>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_unparseitem_UnpStr::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = languageoption_1 = dynamic_cast<languageoption>(val);break;
	case 1: newval = CexpressionDQ_1 = dynamic_cast<CexpressionDQ>(val);break;
	case 2: newval = viewnameoption_1 = dynamic_cast<viewnameoption>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_unparseitems::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = unparseitem_1 = dynamic_cast<unparseitem>(val);break;
	case 1: newval = unparseitems_1 = dynamic_cast<unparseitems>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_viewnames::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = viewnames_1 = dynamic_cast<viewnames>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_unparseclause_UnparseClause::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = viewnames_1 = dynamic_cast<viewnames>(val);break;
	case 1: newval = unparseitems_1 = dynamic_cast<unparseitems>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_unparseclauses::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = unparseclause_1 = dynamic_cast<unparseclause>(val);break;
	case 1: newval = unparseclauses_1 = dynamic_cast<unparseclauses>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_unparsedeclaration_UnparseDeclaration::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = outmostpatterns_1 = dynamic_cast<outmostpatterns>(val);break;
	case 1: newval = unparseclauses_1 = dynamic_cast<unparseclauses>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_unparsedeclarations::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = unparsedeclaration_1 = dynamic_cast<unparsedeclaration>(val);break;
	case 1: newval = unparsedeclarations_1 = dynamic_cast<unparsedeclarations>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_withcase_Withcase::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = patternchains_1 = dynamic_cast<patternchains>(val);break;
	case 1: newval = Ctext_1 = dynamic_cast<Ctext>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_withcases::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = withcase_1 = dynamic_cast<withcase>(val);break;
	case 1: newval = withcases_1 = dynamic_cast<withcases>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_withexpression_WECexpression::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = Cexpression_1 = dynamic_cast<Cexpression>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_withexpression_WEVariable::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_withexpressions::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = withexpression_1 = dynamic_cast<withexpression>(val);break;
	case 1: newval = withexpressions_1 = dynamic_cast<withexpressions>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_contextinfo_InForeachContext::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = patternchain_1 = dynamic_cast<patternchain>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_foreach_after_ForeachAfter::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = patternchain_1 = dynamic_cast<patternchain>(val);break;
	case 1: newval = idCexpressions_1 = dynamic_cast<idCexpressions>(val);break;
	case 2: newval = withexpressions_1 = dynamic_cast<withexpressions>(val);break;
	case 3: newval = Ctext_1 = dynamic_cast<Ctext>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_Ctext_elem_CTextWithexpression::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = withexpressions_1 = dynamic_cast<withexpressions>(val);break;
	case 1: newval = withcases_1 = dynamic_cast<withcases>(val);break;
	case 2: newval = contextinfo_1 = dynamic_cast<contextinfo>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_Ctext_elem_CTextForeachexpression::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = patternchain_1 = dynamic_cast<patternchain>(val);break;
	case 1: newval = idCexpressions_1 = dynamic_cast<idCexpressions>(val);break;
	case 2: newval = withexpressions_1 = dynamic_cast<withexpressions>(val);break;
	case 3: newval = Ctext_1 = dynamic_cast<Ctext>(val);break;
	case 4: newval = foreach_after_1 = dynamic_cast<foreach_after>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_Ctext_elem_CTextCbody::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = Ctext_1 = dynamic_cast<Ctext>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_Ctext_elem_CTextCexpressionSQ::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = CexpressionSQ_1 = dynamic_cast<CexpressionSQ>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_Ctext_elem_CTextCexpressionDQ::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = CexpressionDQ_1 = dynamic_cast<CexpressionDQ>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_Ctext_elem_CTextNl::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_Ctext_elem_CTextDollarVar::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = INT_1 = dynamic_cast<INT>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_Ctext_elem_CTextLine::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_Ctext::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = Ctext_elem_1 = dynamic_cast<Ctext_elem>(val);break;
	case 1: newval = Ctext_1 = dynamic_cast<Ctext>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_fnclass_StaticFn::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_fndeclaration_AcMemberDeclaration::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_declaration_specifiers_1 = dynamic_cast<ac_declaration_specifiers>(val);break;
	case 1: newval = ac_declarator_1 = dynamic_cast<ac_declarator>(val);break;
	case 2: newval = ac_constant_expression_option_1 = dynamic_cast<ac_constant_expression_option>(val);break;
	case 3: newval = fnclass_1 = dynamic_cast<fnclass>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_fndeclaration_FnAcDeclaration::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ac_declaration_specifiers_1 = dynamic_cast<ac_declaration_specifiers>(val);break;
	case 1: newval = ac_declarator_1 = dynamic_cast<ac_declarator>(val);break;
	case 2: newval = ac_declaration_list_1 = dynamic_cast<ac_declaration_list>(val);break;
	case 3: newval = ac_opt_base_init_list_1 = dynamic_cast<ac_opt_base_init_list>(val);break;
	case 4: newval = Ctext_1 = dynamic_cast<Ctext>(val);break;
	case 5: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 6: newval = fnclass_1 = dynamic_cast<fnclass>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_fndeclarations::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = fndeclaration_1 = dynamic_cast<fndeclaration>(val);break;
	case 1: newval = fndeclarations_1 = dynamic_cast<fndeclarations>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_fnfile_FnFile::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_fnfiles::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = fnfile_1 = dynamic_cast<fnfile>(val);break;
	case 1: newval = fnfiles_1 = dynamic_cast<fnfiles>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_terms::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = term_1 = dynamic_cast<term>(val);break;
	case 1: newval = terms_1 = dynamic_cast<terms>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_term_TIntLiteral::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = INT_1 = dynamic_cast<INT>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_term_TStringLiteral::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = CexpressionDQ_1 = dynamic_cast<CexpressionDQ>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_term_TCTerm::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = CexpressionSQ_1 = dynamic_cast<CexpressionSQ>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_term_TMethod::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = term_1 = dynamic_cast<term>(val);break;
	case 1: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 2: newval = terms_1 = dynamic_cast<terms>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_term_TOperator::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = terms_1 = dynamic_cast<terms>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_term_TVariable::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_patterns::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = pattern_1 = dynamic_cast<pattern>(val);break;
	case 1: newval = patterns_1 = dynamic_cast<patterns>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_pattern_PIntLiteral::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = INT_1 = dynamic_cast<INT>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_pattern_PStringLiteral::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = CexpressionDQ_1 = dynamic_cast<CexpressionDQ>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_pattern_PNonLeafVariable::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = pattern_1 = dynamic_cast<pattern>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_pattern_POperator::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = patterns_1 = dynamic_cast<patterns>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_pattern_PVariable::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_outmostpattern_OPDefault::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = Cexpression_1 = dynamic_cast<Cexpression>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_outmostpattern_OPWildcard::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = Cexpression_1 = dynamic_cast<Cexpression>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_outmostpattern_OPNonLeafVariable::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = outmostpattern_1 = dynamic_cast<outmostpattern>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_outmostpattern_OPOperator::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = patterns_1 = dynamic_cast<patterns>(val);break;
	case 2: newval = Cexpression_1 = dynamic_cast<Cexpression>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_outmostpattern_OPOperatorWildcard::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = Cexpression_1 = dynamic_cast<Cexpression>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_patternchainitem_PatternchainitemDollarid::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_patternchainitem_PatternchainitemGroup::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = patternchains_1 = dynamic_cast<patternchains>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_patternchainitem_PatternchainitemOutmost::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = outmostpattern_1 = dynamic_cast<outmostpattern>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_outmostpatterns::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = outmostpattern_1 = dynamic_cast<outmostpattern>(val);break;
	case 1: newval = outmostpatterns_1 = dynamic_cast<outmostpatterns>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_patternchain::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = patternchainitem_1 = dynamic_cast<patternchainitem>(val);break;
	case 1: newval = patternchain_1 = dynamic_cast<patternchain>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_patternchains::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = patternchain_1 = dynamic_cast<patternchain>(val);break;
	case 1: newval = patternchains_1 = dynamic_cast<patternchains>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_rewriteclause_RewriteClause::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = viewnames_1 = dynamic_cast<viewnames>(val);break;
	case 1: newval = term_1 = dynamic_cast<term>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_rewriteclauses::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = rewriteclause_1 = dynamic_cast<rewriteclause>(val);break;
	case 1: newval = rewriteclauses_1 = dynamic_cast<rewriteclauses>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_rwdeclaration_RwDeclaration::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = outmostpatterns_1 = dynamic_cast<outmostpatterns>(val);break;
	case 1: newval = rewriteclauses_1 = dynamic_cast<rewriteclauses>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_rwdeclarations::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = rwdeclaration_1 = dynamic_cast<rwdeclaration>(val);break;
	case 1: newval = rwdeclarations_1 = dynamic_cast<rwdeclarations>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_includedeclaration_IncludeDeclaration::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_includedeclarations::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = includedeclaration_1 = dynamic_cast<includedeclaration>(val);break;
	case 1: newval = includedeclarations_1 = dynamic_cast<includedeclarations>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_includefile_IncludeFile::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_includefiles::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = includefile_1 = dynamic_cast<includefile>(val);break;
	case 1: newval = includefiles_1 = dynamic_cast<includefiles>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_Ctexts::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = Ctext_1 = dynamic_cast<Ctext>(val);break;
	case 1: newval = Ctexts_1 = dynamic_cast<Ctexts>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_idCexpression_IdCexpression::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = Cexpression_1 = dynamic_cast<Cexpression>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_idCexpressions::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = idCexpression_1 = dynamic_cast<idCexpression>(val);break;
	case 1: newval = idCexpressions_1 = dynamic_cast<idCexpressions>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_CexpressionSQ_elem_CExpressionSQNl::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_CexpressionSQ_elem_CExpressionSQPart::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_CexpressionSQ::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = CexpressionSQ_elem_1 = dynamic_cast<CexpressionSQ_elem>(val);break;
	case 1: newval = CexpressionSQ_1 = dynamic_cast<CexpressionSQ>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_CexpressionDQ_elem_CExpressionDQNl::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_CexpressionDQ_elem_CExpressionDQPart::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_CexpressionDQ::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = CexpressionDQ_elem_1 = dynamic_cast<CexpressionDQ_elem>(val);break;
	case 1: newval = CexpressionDQ_1 = dynamic_cast<CexpressionDQ>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_Cexpression_elem_CExpressionArray::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = Cexpression_1 = dynamic_cast<Cexpression>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_Cexpression_elem_CExpressionPack::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = Cexpression_1 = dynamic_cast<Cexpression>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_Cexpression_elem_CExpressionSQ::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = CexpressionSQ_1 = dynamic_cast<CexpressionSQ>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_Cexpression_elem_CExpressionDQ::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = CexpressionDQ_1 = dynamic_cast<CexpressionDQ>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_Cexpression_elem_CExpressionNl::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_Cexpression_elem_CExpressionDollarvar::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = INT_1 = dynamic_cast<INT>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_Cexpression_elem_CExpressionPart::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_Cexpression::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = Cexpression_elem_1 = dynamic_cast<Cexpression_elem>(val);break;
	case 1: newval = Cexpression_1 = dynamic_cast<Cexpression>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_attribute_initialisation_option_Yesattribute_initialisation::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = Cexpression_1 = dynamic_cast<Cexpression>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_attribute_Attribute::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = ID_2 = dynamic_cast<ID>(val);break;
	case 2: newval = attribute_initialisation_option_1 = dynamic_cast<attribute_initialisation_option>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_attributes::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = attribute_1 = dynamic_cast<attribute>(val);break;
	case 1: newval = attributes_1 = dynamic_cast<attributes>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_Ccode_option_CcodeOption::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = attributes_1 = dynamic_cast<attributes>(val);break;
	case 1: newval = Ctexts_1 = dynamic_cast<Ctexts>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_argument_Argument::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_arguments::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = arguments_1 = dynamic_cast<arguments>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_alternative_Alternative::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = arguments_1 = dynamic_cast<arguments>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_alternatives::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = alternative_1 = dynamic_cast<alternative>(val);break;
	case 1: newval = alternatives_1 = dynamic_cast<alternatives>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_productionblock_PredefinedAlternatives::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = alternatives_1 = dynamic_cast<alternatives>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_productionblock_NonlistAlternatives::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = alternatives_1 = dynamic_cast<alternatives>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_productionblock_ListAlternatives::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = alternatives_1 = dynamic_cast<alternatives>(val);break;
	case 1: newval = ID_1 = dynamic_cast<ID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_storageclasses::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = storageclasses_1 = dynamic_cast<storageclasses>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_storageoption_PositiveStorageOption::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_storageoption_NegativeStorageOption::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_phylumdeclaration_PhylumDeclaration::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = storageoption_1 = dynamic_cast<storageoption>(val);break;
	case 2: newval = productionblock_1 = dynamic_cast<productionblock>(val);break;
	case 3: newval = Ccode_option_1 = dynamic_cast<Ccode_option>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_phylumnames::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = ID_1 = dynamic_cast<ID>(val);break;
	case 1: newval = phylumnames_1 = dynamic_cast<phylumnames>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_phylumdeclarations::set_subphylum(int no, abstract_phylum val, bool do_attr)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = phylumdeclaration_1 = dynamic_cast<phylumdeclaration>(val);break;
	case 1: newval = phylumdeclarations_1 = dynamic_cast<phylumdeclarations>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_phylumdeclarationsroot_PhylumDeclarations::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = phylumdeclarations_1 = dynamic_cast<phylumdeclarations>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_STRING_String::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_INT_Int::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_ID_Id::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = uniqID_1 = dynamic_cast<uniqID>(val);break;
    }
    assertNonNull(newval,"newval");
}
void kc_tag_uniqID_Str::set_subphylum(int no, abstract_phylum val, bool kc_rec)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
    }
    assertNonNull(newval,"newval");
}

void
copy_attributes(kc_enum_phyla copyPhy, c_abstract_phylum kc_p1, abstract_phylum kc_p2)
{
    switch(copyPhy) {
    case kc_phylum_uniqID: {
	c_uniqID p1 = dynamic_cast<c_uniqID>(kc_p1);
	uniqID p2 = dynamic_cast<uniqID>(kc_p2);
	p2->type = p1->type;
	p2->line = p1->line;
	p2->file = p1->file;
	p2->scopeinfo = p1->scopeinfo;
	break;
    }
    case kc_phylum_ID: {
	c_ID p1 = dynamic_cast<c_ID>(kc_p1);
	ID p2 = dynamic_cast<ID>(kc_p2);
	p2->type = p1->type;
	p2->line = p1->line;
	p2->file = p1->file;
	break;
    }
    case kc_phylum_INT: {
	c_INT p1 = dynamic_cast<c_INT>(kc_p1);
	INT p2 = dynamic_cast<INT>(kc_p2);
	p2->line = p1->line;
	p2->file = p1->file;
	break;
    }
    case kc_phylum_STRING: {
	c_STRING p1 = dynamic_cast<c_STRING>(kc_p1);
	STRING p2 = dynamic_cast<STRING>(kc_p2);
	p2->line = p1->line;
	p2->file = p1->file;
	break;
    }
    case kc_phylum_phylumdeclaration: {
	c_phylumdeclaration p1 = dynamic_cast<c_phylumdeclaration>(kc_p1);
	phylumdeclaration p2 = dynamic_cast<phylumdeclaration>(kc_p2);
	p2->marked = p1->marked;
	p2->additional_members = p1->additional_members;
	p2->base_classes = p1->base_classes;
	break;
    }
    case kc_phylum_storageclasses:
	dynamic_cast<storageclasses>(kc_p2)->phyla = dynamic_cast<c_storageclasses>(kc_p1)->phyla;
	break;
    case kc_phylum_alternative: {
	c_alternative p1 = dynamic_cast<c_alternative>(kc_p1);
	alternative p2 = dynamic_cast<alternative>(kc_p2);
	p2->rewriteinfo = p1->rewriteinfo;
	p2->unparseinfo = p1->unparseinfo;
	p2->additional_members = p1->additional_members;
	p2->base_classes = p1->base_classes;
	break;
    }
    case kc_phylum_arguments:
	dynamic_cast<arguments>(kc_p2)->seqnr = dynamic_cast<c_arguments>(kc_p1)->seqnr;
	break;
    case kc_phylum_Cexpression: {
	c_Cexpression p1 = dynamic_cast<c_Cexpression>(kc_p1);
	Cexpression p2 = dynamic_cast<Cexpression>(kc_p2);
	p2->line = p1->line;
	p2->file = p1->file;
	break;
    }
    case kc_phylum_idCexpression:
	dynamic_cast<idCexpression>(kc_p2)->id = dynamic_cast<c_idCexpression>(kc_p1)->id;
	break;
    case kc_phylum_includefile: {
	c_includefile p1 = dynamic_cast<c_includefile>(kc_p1);
	includefile p2 = dynamic_cast<includefile>(kc_p2);
	p2->inc_type = p1->inc_type;
	p2->inc = p1->inc;
	break;
    }
    case kc_phylum_includedeclaration: {
	c_includedeclaration p1 = dynamic_cast<c_includedeclaration>(kc_p1);
	includedeclaration p2 = dynamic_cast<includedeclaration>(kc_p2);
	p2->line = p1->line;
	p2->file = p1->file;
	break;
    }
    case kc_phylum_patternchains: {
	c_patternchains p1 = dynamic_cast<c_patternchains>(kc_p1);
	patternchains p2 = dynamic_cast<patternchains>(kc_p2);
	p2->line = p1->line;
	p2->file = p1->file;
	break;
    }
    case kc_phylum_patternchain: {
	c_patternchain p1 = dynamic_cast<c_patternchain>(kc_p1);
	patternchain p2 = dynamic_cast<patternchain>(kc_p2);
	p2->line = p1->line;
	p2->file = p1->file;
	break;
    }
    case kc_phylum_patternchainitem: {
	c_patternchainitem p1 = dynamic_cast<c_patternchainitem>(kc_p1);
	patternchainitem p2 = dynamic_cast<patternchainitem>(kc_p2);
	p2->line = p1->line;
	p2->file = p1->file;
	p2->type = p1->type;
	break;
    }
    case kc_phylum_outmostpattern: {
	c_outmostpattern p1 = dynamic_cast<c_outmostpattern>(kc_p1);
	outmostpattern p2 = dynamic_cast<outmostpattern>(kc_p2);
	p2->line = p1->line;
	p2->file = p1->file;
	p2->type = p1->type;
	break;
    }
    case kc_phylum_term: {
	c_term p1 = dynamic_cast<c_term>(kc_p1);
	term p2 = dynamic_cast<term>(kc_p2);
	p2->line = p1->line;
	p2->file = p1->file;
	break;
    }
    case kc_phylum_fnfile:
	dynamic_cast<fnfile>(kc_p2)->fns = dynamic_cast<c_fnfile>(kc_p1)->fns;
	break;
    case kc_phylum_fndeclaration: {
	c_fndeclaration p1 = dynamic_cast<c_fndeclaration>(kc_p1);
	fndeclaration p2 = dynamic_cast<fndeclaration>(kc_p2);
	p2->sorted = p1->sorted;
	p2->last_line = p1->last_line;
	p2->file = p1->file;
	p2->is_attr = p1->is_attr;
	break;
    }
    case kc_phylum_Ctext: {
	c_Ctext p1 = dynamic_cast<c_Ctext>(kc_p1);
	Ctext p2 = dynamic_cast<Ctext>(kc_p2);
	p2->line = p1->line;
	p2->file = p1->file;
	break;
    }
    case kc_phylum_Ctext_elem: {
	c_Ctext_elem p1 = dynamic_cast<c_Ctext_elem>(kc_p1);
	Ctext_elem p2 = dynamic_cast<Ctext_elem>(kc_p2);
	p2->line = p1->line;
	p2->file = p1->file;
	break;
    }
    case kc_phylum_foreach_after: {
	c_foreach_after p1 = dynamic_cast<c_foreach_after>(kc_p1);
	foreach_after p2 = dynamic_cast<foreach_after>(kc_p2);
	p2->line = p1->line;
	p2->file = p1->file;
	break;
    }
    case kc_phylum_withexpressions: {
	c_withexpressions p1 = dynamic_cast<c_withexpressions>(kc_p1);
	withexpressions p2 = dynamic_cast<withexpressions>(kc_p2);
	p2->type = p1->type;
	p2->line = p1->line;
	p2->file = p1->file;
	break;
    }
    case kc_phylum_withexpression: {
	c_withexpression p1 = dynamic_cast<c_withexpression>(kc_p1);
	withexpression p2 = dynamic_cast<withexpression>(kc_p2);
	p2->type = p1->type;
	p2->line = p1->line;
	p2->file = p1->file;
	break;
    }
    case kc_phylum_withcases:
	dynamic_cast<withcases>(kc_p2)->wcinfo = dynamic_cast<c_withcases>(kc_p1)->wcinfo;
	break;
    case kc_phylum_withcase:
	dynamic_cast<withcase>(kc_p2)->wcinfo = dynamic_cast<c_withcase>(kc_p1)->wcinfo;
	break;
    case kc_phylum_unparsedeclaration:
	dynamic_cast<unparsedeclaration>(kc_p2)->patternreps = dynamic_cast<c_unparsedeclaration>(kc_p1)->patternreps;
	break;
    case kc_phylum_viewnames:
	dynamic_cast<viewnames>(kc_p2)->is_extern = dynamic_cast<c_viewnames>(kc_p1)->is_extern;
	break;
    case kc_phylum_unparseitem:
	dynamic_cast<unparseitem>(kc_p2)->text_nr = dynamic_cast<c_unparseitem>(kc_p1)->text_nr;
	break;
    case kc_phylum_fileline: {
	c_fileline p1 = dynamic_cast<c_fileline>(kc_p1);
	fileline p2 = dynamic_cast<fileline>(kc_p2);
	p2->file = p1->file;
	p2->line = p1->line;
	break;
    }
    case kc_phylum_elem_patternrepresentation: {
	c_elem_patternrepresentation p1 = dynamic_cast<c_elem_patternrepresentation>(kc_p1);
	elem_patternrepresentation p2 = dynamic_cast<elem_patternrepresentation>(kc_p2);
	p2->line = p1->line;
	p2->file = p1->file;
	p2->type = p1->type;
	break;
    }
    case kc_phylum_path: {
	c_path p1 = dynamic_cast<c_path>(kc_p1);
	path p2 = dynamic_cast<path>(kc_p2);
	p2->op = p1->op;
	p2->id = p1->id;
	break;
    }
    case kc_phylum_ac_operator_name: {
	c_ac_operator_name p1 = dynamic_cast<c_ac_operator_name>(kc_p1);
	ac_operator_name p2 = dynamic_cast<ac_operator_name>(kc_p2);
	p2->line = p1->line;
	p2->file = p1->file;
	break;
    }
    case kc_phylum_addedphylumdeclaration:
	dynamic_cast<addedphylumdeclaration>(kc_p2)->added = dynamic_cast<c_addedphylumdeclaration>(kc_p1)->added;
	break;
    case kc_phylum_countedphylumdeclaration:
	dynamic_cast<countedphylumdeclaration>(kc_p2)->count = dynamic_cast<c_countedphylumdeclaration>(kc_p1)->count;
	break;
    case kc_phylum_charruns:
	dynamic_cast<charruns>(kc_p2)->number = dynamic_cast<c_charruns>(kc_p1)->number;
	break;
    case kc_phylum_bindingidmark:
	dynamic_cast<bindingidmark>(kc_p2)->marked = dynamic_cast<c_bindingidmark>(kc_p1)->marked;
	break;
    default:
	break; // it's alright, no attributes to copy
    }
    kc_enum_operators copyOp=kc_p1->prod_sel();
    for (int i=kc_OperatorInfo[copyOp].no_attrs-1; i>=0; --i)
	attributeOf(kc_p2, i)=attributeOf(const_cast<abstract_phylum>(kc_p1), i);
}

KC_PHYLUM_INFO kc_PhylumInfo[] = {
    { "", kc_one_before_first_operator, kc_one_before_first_operator, (kc_storageclass_t)0, false }, /* dummy element */
    { "nocasestring", sel_NoCaseStr, sel_NoCaseStr, uniq, false },
    { "casestring", sel__Str, sel__Str, uniq, false },
    { "real", sel__Real, sel__Real, uniq, false },
    { "integer", sel__Int, sel__Int, uniq, false },
    { "voidptr", sel__VoidPtr, sel__VoidPtr, uniq, false },
    { "uniqID", sel_Str, sel_Str, uniq, false },
    { "ID", sel_Id, sel_Id, kc_not_uniq, false },
    { "INT", sel_Int, sel_Int, kc_not_uniq, false },
    { "STRING", sel_String, sel_String, kc_not_uniq, false },
    { "phylumdeclarationsroot", sel_PhylumDeclarations, sel_PhylumDeclarations, kc_not_uniq, false },
    { "phylumdeclarations", sel_Nilphylumdeclarations, sel_Consphylumdeclarations, kc_not_uniq, true },
    { "phylumnames", sel_Nilphylumnames, sel_Consphylumnames, kc_not_uniq, true },
    { "phylumdeclaration", sel_PhylumDeclaration, sel_PhylumDeclaration, kc_not_uniq, false },
    { "storageoption", sel_NoStorageOption, sel_PositiveStorageOption, kc_not_uniq, false },
    { "storageclasses", sel_Nilstorageclasses, sel_Consstorageclasses, kc_not_uniq, true },
    { "productionblock", sel_Emptyproductionblock, sel_PredefinedAlternatives, kc_not_uniq, false },
    { "alternatives", sel_Nilalternatives, sel_Consalternatives, kc_not_uniq, true },
    { "alternative", sel_Alternative, sel_Alternative, kc_not_uniq, false },
    { "arguments", sel_Nilarguments, sel_Consarguments, kc_not_uniq, true },
    { "argument", sel_Argument, sel_Argument, kc_not_uniq, false },
    { "Ccode_option", sel_CcodeOption, sel_CcodeOption, kc_not_uniq, false },
    { "attributes", sel_Nilattributes, sel_Consattributes, kc_not_uniq, true },
    { "attribute", sel_Attribute, sel_Attribute, kc_not_uniq, false },
    { "attribute_initialisation_option", sel_Noattribute_initialisation, sel_Yesattribute_initialisation, kc_not_uniq, false },
    { "Cexpression", sel_NilCexpression, sel_ConsCexpression, kc_not_uniq, true },
    { "Cexpression_elem", sel_CExpressionPart, sel_CExpressionArray, kc_not_uniq, false },
    { "CexpressionDQ", sel_NilCexpressionDQ, sel_ConsCexpressionDQ, kc_not_uniq, true },
    { "CexpressionDQ_elem", sel_CExpressionDQPart, sel_CExpressionDQNl, kc_not_uniq, false },
    { "CexpressionSQ", sel_NilCexpressionSQ, sel_ConsCexpressionSQ, kc_not_uniq, true },
    { "CexpressionSQ_elem", sel_CExpressionSQPart, sel_CExpressionSQNl, kc_not_uniq, false },
    { "idCexpressions", sel_NilidCexpressions, sel_ConsidCexpressions, kc_not_uniq, true },
    { "idCexpression", sel_IdCexpression, sel_IdCexpression, kc_not_uniq, false },
    { "Ctexts", sel_NilCtexts, sel_ConsCtexts, kc_not_uniq, true },
    { "includefiles", sel_Nilincludefiles, sel_Consincludefiles, kc_not_uniq, true },
    { "includefile", sel_IncludeFile, sel_IncludeFile, uniq, false },
    { "includedeclarations", sel_Nilincludedeclarations, sel_Consincludedeclarations, kc_not_uniq, true },
    { "includedeclaration", sel_IncludeDeclaration, sel_IncludeDeclaration, kc_not_uniq, false },
    { "rwdeclarations", sel_Nilrwdeclarations, sel_Consrwdeclarations, kc_not_uniq, true },
    { "rwdeclaration", sel_RwDeclaration, sel_RwDeclaration, kc_not_uniq, false },
    { "rewriteclauses", sel_Nilrewriteclauses, sel_Consrewriteclauses, kc_not_uniq, true },
    { "rewriteclause", sel_RewriteClause, sel_RewriteClause, kc_not_uniq, false },
    { "patternchains", sel_Nilpatternchains, sel_Conspatternchains, kc_not_uniq, true },
    { "patternchain", sel_Nilpatternchain, sel_Conspatternchain, kc_not_uniq, true },
    { "outmostpatterns", sel_Niloutmostpatterns, sel_Consoutmostpatterns, kc_not_uniq, true },
    { "patternchainitem", sel_PatternchainitemOutmost, sel_PatternchainitemDollarid, kc_not_uniq, false },
    { "outmostpattern", sel_OPOperatorWildcard, sel_OPDefault, kc_not_uniq, false },
    { "pattern", sel_PVariable, sel_PIntLiteral, kc_not_uniq, false },
    { "patterns", sel_Nilpatterns, sel_Conspatterns, kc_not_uniq, true },
    { "term", sel_TVariable, sel_TIntLiteral, kc_not_uniq, false },
    { "terms", sel_Nilterms, sel_Consterms, kc_not_uniq, true },
    { "fnfiles", sel_Nilfnfiles, sel_Consfnfiles, kc_not_uniq, true },
    { "fnfile", sel_FnFile, sel_FnFile, uniq, false },
    { "fndeclarations", sel_Nilfndeclarations, sel_Consfndeclarations, kc_not_uniq, true },
    { "fndeclaration", sel_FnAcDeclaration, sel_AcMemberDeclaration, kc_not_uniq, false },
    { "fnclass", sel_GlobalFn, sel_DestructorFn, kc_not_uniq, false },
    { "Ctext", sel_NilCtext, sel_ConsCtext, kc_not_uniq, true },
    { "Ctext_elem", sel_CTextLine, sel_CTextWithexpression, kc_not_uniq, false },
    { "foreach_after", sel_NoForeachAfter, sel_ForeachAfter, kc_not_uniq, false },
    { "contextinfo", sel_InForeachContext, sel_NotInForeachContext, kc_not_uniq, false },
    { "withexpressions", sel_Nilwithexpressions, sel_Conswithexpressions, kc_not_uniq, true },
    { "withexpression", sel_WEVariable, sel_WECexpression, kc_not_uniq, false },
    { "withcases", sel_Nilwithcases, sel_Conswithcases, kc_not_uniq, true },
    { "withcase", sel_Withcase, sel_Withcase, kc_not_uniq, false },
    { "unparsedeclarations", sel_Nilunparsedeclarations, sel_Consunparsedeclarations, kc_not_uniq, true },
    { "unparsedeclaration", sel_UnparseDeclaration, sel_UnparseDeclaration, kc_not_uniq, false },
    { "unparseclauses", sel_Nilunparseclauses, sel_Consunparseclauses, kc_not_uniq, true },
    { "unparseclause", sel_UnparseClause, sel_UnparseClause, kc_not_uniq, false },
    { "viewnames", sel_Nilviewnames, sel_Consviewnames, kc_not_uniq, true },
    { "unparseitems", sel_Nilunparseitems, sel_Consunparseitems, kc_not_uniq, true },
    { "unparseitem", sel_UnpStr, sel_UViewVarDecl, kc_not_uniq, false },
    { "unpsubterm", sel_UnpSubTerm, sel_UnpCastedVariable, kc_not_uniq, false },
    { "unpattributes", sel_Nilunpattributes, sel_Consunpattributes, kc_not_uniq, true },
    { "viewnameoption", sel_NoViewname, sel_YesViewname, kc_not_uniq, false },
    { "languageoption", sel_NoLanguagename, sel_LanguageList, kc_not_uniq, false },
    { "languagenames", sel_Nillanguagenames, sel_Conslanguagenames, kc_not_uniq, true },
    { "fileline", sel_FileLine, sel_PosNoFileLine, kc_not_uniq, false },
    { "scopetypefilelinestack", sel_Nilscopetypefilelinestack, sel_Consscopetypefilelinestack, kc_not_uniq, true },
    { "scopetypefileline", sel_ScopeTypeFileLine, sel_ScopeTypeFileLine, kc_not_uniq, false },
    { "IDtype", sel_ITUnknown, sel_ITLanguageName, kc_not_uniq, false },
    { "operators", sel_Niloperators, sel_Consoperators, kc_not_uniq, true },
    { "phyla", sel_Nilphyla, sel_Consphyla, kc_not_uniq, true },
    { "variables", sel_Nilvariables, sel_Consvariables, kc_not_uniq, true },
    { "dollarvarstatus", sel_DVAllowed, sel_DVDisallowed, kc_not_uniq, false },
    { "two_phyla", sel_TwoStorageoption, sel_TwoPath, kc_not_uniq, false },
    { "tribool", sel_Equal, sel_Bigger, kc_not_uniq, false },
    { "patternrepresentations", sel_Nilpatternrepresentations, sel_Conspatternrepresentations, kc_not_uniq, true },
    { "patternrepresentation", sel_Nilpatternrepresentation, sel_Conspatternrepresentation, kc_not_uniq, true },
    { "elem_patternrepresentation", sel_PRBinding, sel_PRIntLiteral, kc_not_uniq, false },
    { "path", sel_Nilpath, sel_Conspath, kc_not_uniq, true },
    { "paths", sel_Nilpaths, sel_Conspaths, kc_not_uniq, true },
    { "argsnumbers", sel_Nilargsnumbers, sel_Consargsnumbers, kc_not_uniq, true },
    { "rewriterulesinfo", sel_Nilrewriterulesinfo, sel_Consrewriterulesinfo, kc_not_uniq, true },
    { "rewriteruleinfo", sel_Rewriteruleinfo, sel_Rewriteruleinfo, kc_not_uniq, false },
    { "withcasesinfo", sel_Nilwithcasesinfo, sel_Conswithcasesinfo, kc_not_uniq, true },
    { "withcaseinfo", sel_Withcaseinfo, sel_Withcaseinfo, kc_not_uniq, false },
    { "rewriteviewsinfo", sel_Nilrewriteviewsinfo, sel_Consrewriteviewsinfo, kc_not_uniq, true },
    { "rewriteviewinfo", sel_Rewriteviewinfo, sel_Rewriteviewinfo, kc_not_uniq, false },
    { "unparseviewsinfo", sel_Nilunparseviewsinfo, sel_Consunparseviewsinfo, kc_not_uniq, true },
    { "unparseviewinfo", sel_Unparseviewinfo, sel_Unparseviewinfo, kc_not_uniq, false },
    { "unparsedeclsinfo", sel_Nilunparsedeclsinfo, sel_Consunparsedeclsinfo, kc_not_uniq, true },
    { "unparsedeclinfo", sel_Unparsedeclinfo, sel_Unparsedeclinfo, kc_not_uniq, false },
    { "ac_declaration", sel_AcDeclaration, sel_AcDeclaration, kc_not_uniq, false },
    { "ac_declaration_list", sel_Nilac_declaration_list, sel_Consac_declaration_list, kc_not_uniq, true },
    { "ac_declaration_specifiers", sel_Nilac_declaration_specifiers, sel_Consac_declaration_specifiers, kc_not_uniq, true },
    { "ac_declaration_specifier", sel_AcDeclSpecStorageSpec, sel_AcDeclSpecTypeQual, kc_not_uniq, false },
    { "ac_storage_class_specifier", sel_AcAuto, sel_AcVirtual, kc_not_uniq, false },
    { "ac_type_specifier", sel_AcTypeSpec, sel_AcTypeSpec, kc_not_uniq, false },
    { "ac_type_qualifier", sel_AcConst, sel_AcNoQualifier, kc_not_uniq, false },
    { "ac_init_declarator_list", sel_Nilac_init_declarator_list, sel_Consac_init_declarator_list, kc_not_uniq, true },
    { "ac_init_declarator", sel_AcInitDecl, sel_AcInitDecl, kc_not_uniq, false },
    { "ac_declarator", sel_AcDeclarator, sel_AcDeclarator, kc_not_uniq, false },
    { "ac_direct_declarator", sel_AcDirectDeclId, sel_AcOperatorDeclId, kc_not_uniq, false },
    { "ac_pointer_option", sel_Nopointer, sel_Yespointer, kc_not_uniq, false },
    { "ac_pointer", sel_AcPointerNil, sel_AcPointerCons, kc_not_uniq, false },
    { "ac_ref_option", sel_AcNoRef, sel_AcRef, kc_not_uniq, false },
    { "ac_operator_name", sel_AcOperatorName, sel_AcOperatorName, kc_not_uniq, false },
    { "ac_class_qualifier_help_list", sel_Nilac_class_qualifier_help_list, sel_Consac_class_qualifier_help_list, kc_not_uniq, true },
    { "ac_class_qualifier_list", sel_Nilac_class_qualifier_list, sel_Consac_class_qualifier_list, kc_not_uniq, true },
    { "ac_type_qualifier_list", sel_Nilac_type_qualifier_list, sel_Consac_type_qualifier_list, kc_not_uniq, true },
    { "ac_parameter_type_list", sel_AcParList, sel_AcParList3Dot, kc_not_uniq, false },
    { "ac_parameter_list", sel_Nilac_parameter_list, sel_Consac_parameter_list, kc_not_uniq, true },
    { "ac_parameter_declaration", sel_AcParDeclDecl, sel_AcParDeclAbsdecl, kc_not_uniq, false },
    { "ac_identifier_list", sel_Nilac_identifier_list, sel_Consac_identifier_list, kc_not_uniq, true },
    { "ac_abstract_declarator", sel_AcAbsdeclPointer, sel_AcAbsdeclDirdecl, kc_not_uniq, false },
    { "ac_direct_abstract_declarator_option", sel_Noac_direct_abstract_declarator, sel_Yesac_direct_abstract_declarator, kc_not_uniq, false },
    { "ac_direct_abstract_declarator", sel_AcDirAbsdeclPack, sel_AcDirAbsdeclFn, kc_not_uniq, false },
    { "ac_constant_expression_option", sel_Yesac_constant_expression, sel_Noac_constant_expression, kc_not_uniq, false },
    { "ac_constant_expression", sel_AcConstExpr, sel_AcConstExpr, kc_not_uniq, false },
    { "ac_constant_expression_list", sel_Nilac_constant_expression_list, sel_Consac_constant_expression_list, kc_not_uniq, true },
    { "ac_opt_base_init_list", sel_AcNoBaseInit, sel_AcYesBaseInit, kc_not_uniq, false },
    { "ac_base_init_list", sel_Nilac_base_init_list, sel_Consac_base_init_list, kc_not_uniq, true },
    { "ac_base_init", sel_AcBaseInit, sel_AcBaseInit, kc_not_uniq, false },
    { "baseclass_declarations", sel_Nilbaseclass_declarations, sel_Consbaseclass_declarations, kc_not_uniq, true },
    { "baseclass_decl", sel_BaseClassDecl, sel_BaseClassDecl, kc_not_uniq, false },
    { "baseclass_list", sel_Nilbaseclass_list, sel_Consbaseclass_list, kc_not_uniq, true },
    { "error", sel_Fatal, sel_Warning, kc_not_uniq, false },
    { "problem", sel_Problem1, sel_Problem6, kc_not_uniq, false },
    { "addedphylumdeclarations", sel_Niladdedphylumdeclarations, sel_Consaddedphylumdeclarations, kc_not_uniq, true },
    { "addedphylumdeclaration", sel_AddedPhylumdeclaration, sel_AddedPhylumdeclaration, kc_not_uniq, false },
    { "countedphylumdeclarations", sel_Nilcountedphylumdeclarations, sel_Conscountedphylumdeclarations, kc_not_uniq, true },
    { "countedphylumdeclaration", sel_CountedPhylumdeclaration, sel_CountedPhylumdeclaration, uniq, false },
    { "charruns", sel_Newlines, sel_Stars, uniq, false },
    { "bindingidmarks", sel_Nilbindingidmarks, sel_Consbindingidmarks, uniq, true },
    { "bindingidmark", sel_BindingIdMark, sel_BindingIdMark, uniq, false },
    { "", kc_one_before_first_operator, kc_one_before_first_operator, (kc_storageclass_t)0, false } /* last element */
};

static kc_enum_phyla kc_subphyla_Str[] = { kc_phylum_casestring };
static kc_enum_phyla kc_subphyla_Id[] = { kc_phylum_uniqID };
static kc_enum_phyla kc_subphyla_Int[] = { kc_phylum_integer };
static kc_enum_phyla kc_subphyla_String[] = { kc_phylum_casestring };
static kc_enum_phyla kc_subphyla_PhylumDeclarations[] = { kc_phylum_phylumdeclarations };
static kc_enum_phyla kc_subphyla_Consphylumdeclarations[] = { kc_phylum_phylumdeclaration, kc_phylum_phylumdeclarations };
static kc_enum_phyla kc_subphyla_Consphylumnames[] = { kc_phylum_ID, kc_phylum_phylumnames };
static kc_enum_phyla kc_subphyla_PhylumDeclaration[] = { kc_phylum_ID, kc_phylum_storageoption, kc_phylum_productionblock, kc_phylum_Ccode_option };
static kc_enum_phyla kc_subphyla_NegativeStorageOption[] = { kc_phylum_ID };
static kc_enum_phyla kc_subphyla_PositiveStorageOption[] = { kc_phylum_ID };
static kc_enum_phyla kc_subphyla_Consstorageclasses[] = { kc_phylum_ID, kc_phylum_storageclasses };
static kc_enum_phyla kc_subphyla_ListAlternatives[] = { kc_phylum_alternatives, kc_phylum_ID };
static kc_enum_phyla kc_subphyla_NonlistAlternatives[] = { kc_phylum_alternatives };
static kc_enum_phyla kc_subphyla_PredefinedAlternatives[] = { kc_phylum_alternatives };
static kc_enum_phyla kc_subphyla_Consalternatives[] = { kc_phylum_alternative, kc_phylum_alternatives };
static kc_enum_phyla kc_subphyla_Alternative[] = { kc_phylum_ID, kc_phylum_arguments };
static kc_enum_phyla kc_subphyla_Consarguments[] = { kc_phylum_ID, kc_phylum_arguments };
static kc_enum_phyla kc_subphyla_Argument[] = { kc_phylum_ID, kc_phylum_integer };
static kc_enum_phyla kc_subphyla_CcodeOption[] = { kc_phylum_attributes, kc_phylum_Ctexts };
static kc_enum_phyla kc_subphyla_Consattributes[] = { kc_phylum_attribute, kc_phylum_attributes };
static kc_enum_phyla kc_subphyla_Attribute[] = { kc_phylum_ID, kc_phylum_ID, kc_phylum_attribute_initialisation_option };
static kc_enum_phyla kc_subphyla_Yesattribute_initialisation[] = { kc_phylum_Cexpression };
static kc_enum_phyla kc_subphyla_ConsCexpression[] = { kc_phylum_Cexpression_elem, kc_phylum_Cexpression };
static kc_enum_phyla kc_subphyla_CExpressionPart[] = { kc_phylum_casestring };
static kc_enum_phyla kc_subphyla_CExpressionDollarvar[] = { kc_phylum_INT };
static kc_enum_phyla kc_subphyla_CExpressionNl[] = { kc_phylum_integer };
static kc_enum_phyla kc_subphyla_CExpressionDQ[] = { kc_phylum_CexpressionDQ };
static kc_enum_phyla kc_subphyla_CExpressionSQ[] = { kc_phylum_CexpressionSQ };
static kc_enum_phyla kc_subphyla_CExpressionPack[] = { kc_phylum_Cexpression };
static kc_enum_phyla kc_subphyla_CExpressionArray[] = { kc_phylum_Cexpression };
static kc_enum_phyla kc_subphyla_ConsCexpressionDQ[] = { kc_phylum_CexpressionDQ_elem, kc_phylum_CexpressionDQ };
static kc_enum_phyla kc_subphyla_CExpressionDQPart[] = { kc_phylum_casestring };
static kc_enum_phyla kc_subphyla_CExpressionDQNl[] = { kc_phylum_integer };
static kc_enum_phyla kc_subphyla_ConsCexpressionSQ[] = { kc_phylum_CexpressionSQ_elem, kc_phylum_CexpressionSQ };
static kc_enum_phyla kc_subphyla_CExpressionSQPart[] = { kc_phylum_casestring };
static kc_enum_phyla kc_subphyla_CExpressionSQNl[] = { kc_phylum_integer };
static kc_enum_phyla kc_subphyla_ConsidCexpressions[] = { kc_phylum_idCexpression, kc_phylum_idCexpressions };
static kc_enum_phyla kc_subphyla_IdCexpression[] = { kc_phylum_ID, kc_phylum_Cexpression };
static kc_enum_phyla kc_subphyla_ConsCtexts[] = { kc_phylum_Ctext, kc_phylum_Ctexts };
static kc_enum_phyla kc_subphyla_Consincludefiles[] = { kc_phylum_includefile, kc_phylum_includefiles };
static kc_enum_phyla kc_subphyla_IncludeFile[] = { kc_phylum_casestring };
static kc_enum_phyla kc_subphyla_Consincludedeclarations[] = { kc_phylum_includedeclaration, kc_phylum_includedeclarations };
static kc_enum_phyla kc_subphyla_IncludeDeclaration[] = { kc_phylum_casestring };
static kc_enum_phyla kc_subphyla_Consrwdeclarations[] = { kc_phylum_rwdeclaration, kc_phylum_rwdeclarations };
static kc_enum_phyla kc_subphyla_RwDeclaration[] = { kc_phylum_outmostpatterns, kc_phylum_rewriteclauses };
static kc_enum_phyla kc_subphyla_Consrewriteclauses[] = { kc_phylum_rewriteclause, kc_phylum_rewriteclauses };
static kc_enum_phyla kc_subphyla_RewriteClause[] = { kc_phylum_viewnames, kc_phylum_term };
static kc_enum_phyla kc_subphyla_Conspatternchains[] = { kc_phylum_patternchain, kc_phylum_patternchains };
static kc_enum_phyla kc_subphyla_Conspatternchain[] = { kc_phylum_patternchainitem, kc_phylum_patternchain };
static kc_enum_phyla kc_subphyla_Consoutmostpatterns[] = { kc_phylum_outmostpattern, kc_phylum_outmostpatterns };
static kc_enum_phyla kc_subphyla_PatternchainitemOutmost[] = { kc_phylum_outmostpattern };
static kc_enum_phyla kc_subphyla_PatternchainitemGroup[] = { kc_phylum_patternchains };
static kc_enum_phyla kc_subphyla_PatternchainitemDollarid[] = { kc_phylum_ID };
static kc_enum_phyla kc_subphyla_OPOperatorWildcard[] = { kc_phylum_ID, kc_phylum_Cexpression };
static kc_enum_phyla kc_subphyla_OPOperator[] = { kc_phylum_ID, kc_phylum_patterns, kc_phylum_Cexpression };
static kc_enum_phyla kc_subphyla_OPNonLeafVariable[] = { kc_phylum_ID, kc_phylum_outmostpattern };
static kc_enum_phyla kc_subphyla_OPWildcard[] = { kc_phylum_Cexpression };
static kc_enum_phyla kc_subphyla_OPDefault[] = { kc_phylum_Cexpression };
static kc_enum_phyla kc_subphyla_PVariable[] = { kc_phylum_ID };
static kc_enum_phyla kc_subphyla_POperator[] = { kc_phylum_ID, kc_phylum_patterns };
static kc_enum_phyla kc_subphyla_PNonLeafVariable[] = { kc_phylum_ID, kc_phylum_pattern };
static kc_enum_phyla kc_subphyla_PStringLiteral[] = { kc_phylum_CexpressionDQ };
static kc_enum_phyla kc_subphyla_PIntLiteral[] = { kc_phylum_INT };
static kc_enum_phyla kc_subphyla_Conspatterns[] = { kc_phylum_pattern, kc_phylum_patterns };
static kc_enum_phyla kc_subphyla_TVariable[] = { kc_phylum_ID };
static kc_enum_phyla kc_subphyla_TOperator[] = { kc_phylum_ID, kc_phylum_terms };
static kc_enum_phyla kc_subphyla_TMethod[] = { kc_phylum_term, kc_phylum_ID, kc_phylum_terms };
static kc_enum_phyla kc_subphyla_TCTerm[] = { kc_phylum_CexpressionSQ };
static kc_enum_phyla kc_subphyla_TStringLiteral[] = { kc_phylum_CexpressionDQ };
static kc_enum_phyla kc_subphyla_TIntLiteral[] = { kc_phylum_INT };
static kc_enum_phyla kc_subphyla_Consterms[] = { kc_phylum_term, kc_phylum_terms };
static kc_enum_phyla kc_subphyla_Consfnfiles[] = { kc_phylum_fnfile, kc_phylum_fnfiles };
static kc_enum_phyla kc_subphyla_FnFile[] = { kc_phylum_casestring };
static kc_enum_phyla kc_subphyla_Consfndeclarations[] = { kc_phylum_fndeclaration, kc_phylum_fndeclarations };
static kc_enum_phyla kc_subphyla_FnAcDeclaration[] = { kc_phylum_ac_declaration_specifiers, kc_phylum_ac_declarator, kc_phylum_ac_declaration_list, kc_phylum_ac_opt_base_init_list, kc_phylum_Ctext, kc_phylum_ID, kc_phylum_fnclass };
static kc_enum_phyla kc_subphyla_AcMemberDeclaration[] = { kc_phylum_ac_declaration_specifiers, kc_phylum_ac_declarator, kc_phylum_ac_constant_expression_option, kc_phylum_fnclass };
static kc_enum_phyla kc_subphyla_StaticFn[] = { kc_phylum_casestring };
static kc_enum_phyla kc_subphyla_ConsCtext[] = { kc_phylum_Ctext_elem, kc_phylum_Ctext };
static kc_enum_phyla kc_subphyla_CTextLine[] = { kc_phylum_casestring };
static kc_enum_phyla kc_subphyla_CTextDollarVar[] = { kc_phylum_INT };
static kc_enum_phyla kc_subphyla_CTextNl[] = { kc_phylum_integer };
static kc_enum_phyla kc_subphyla_CTextCexpressionDQ[] = { kc_phylum_CexpressionDQ };
static kc_enum_phyla kc_subphyla_CTextCexpressionSQ[] = { kc_phylum_CexpressionSQ };
static kc_enum_phyla kc_subphyla_CTextCbody[] = { kc_phylum_Ctext };
static kc_enum_phyla kc_subphyla_CTextForeachexpression[] = { kc_phylum_patternchain, kc_phylum_idCexpressions, kc_phylum_withexpressions, kc_phylum_Ctext, kc_phylum_foreach_after };
static kc_enum_phyla kc_subphyla_CTextWithexpression[] = { kc_phylum_withexpressions, kc_phylum_withcases, kc_phylum_contextinfo };
static kc_enum_phyla kc_subphyla_ForeachAfter[] = { kc_phylum_patternchain, kc_phylum_idCexpressions, kc_phylum_withexpressions, kc_phylum_Ctext };
static kc_enum_phyla kc_subphyla_InForeachContext[] = { kc_phylum_patternchain };
static kc_enum_phyla kc_subphyla_Conswithexpressions[] = { kc_phylum_withexpression, kc_phylum_withexpressions };
static kc_enum_phyla kc_subphyla_WEVariable[] = { kc_phylum_ID };
static kc_enum_phyla kc_subphyla_WECexpression[] = { kc_phylum_Cexpression };
static kc_enum_phyla kc_subphyla_Conswithcases[] = { kc_phylum_withcase, kc_phylum_withcases };
static kc_enum_phyla kc_subphyla_Withcase[] = { kc_phylum_patternchains, kc_phylum_Ctext };
static kc_enum_phyla kc_subphyla_Consunparsedeclarations[] = { kc_phylum_unparsedeclaration, kc_phylum_unparsedeclarations };
static kc_enum_phyla kc_subphyla_UnparseDeclaration[] = { kc_phylum_outmostpatterns, kc_phylum_unparseclauses };
static kc_enum_phyla kc_subphyla_Consunparseclauses[] = { kc_phylum_unparseclause, kc_phylum_unparseclauses };
static kc_enum_phyla kc_subphyla_UnparseClause[] = { kc_phylum_viewnames, kc_phylum_unparseitems };
static kc_enum_phyla kc_subphyla_Consviewnames[] = { kc_phylum_ID, kc_phylum_viewnames };
static kc_enum_phyla kc_subphyla_Consunparseitems[] = { kc_phylum_unparseitem, kc_phylum_unparseitems };
static kc_enum_phyla kc_subphyla_UnpStr[] = { kc_phylum_languageoption, kc_phylum_CexpressionDQ, kc_phylum_viewnameoption };
static kc_enum_phyla kc_subphyla_UnpSubexpr[] = { kc_phylum_languageoption, kc_phylum_unpsubterm, kc_phylum_viewnameoption };
static kc_enum_phyla kc_subphyla_UnpCtext[] = { kc_phylum_languageoption, kc_phylum_Ctext };
static kc_enum_phyla kc_subphyla_UnpBody[] = { kc_phylum_languageoption, kc_phylum_unparseitems };
static kc_enum_phyla kc_subphyla_UViewVarDecl[] = { kc_phylum_ID, kc_phylum_ID, kc_phylum_Cexpression };
static kc_enum_phyla kc_subphyla_UnpSubTerm[] = { kc_phylum_ID };
static kc_enum_phyla kc_subphyla_UnpDollarvarTerm[] = { kc_phylum_INT };
static kc_enum_phyla kc_subphyla_UnpSubAttr[] = { kc_phylum_ID, kc_phylum_unpattributes };
static kc_enum_phyla kc_subphyla_UnpDollarvarAttr[] = { kc_phylum_INT, kc_phylum_unpattributes };
static kc_enum_phyla kc_subphyla_UnpCastedVariable[] = { kc_phylum_ID, kc_phylum_ID };
static kc_enum_phyla kc_subphyla_Consunpattributes[] = { kc_phylum_ID, kc_phylum_unpattributes };
static kc_enum_phyla kc_subphyla_YesViewname[] = { kc_phylum_ID };
static kc_enum_phyla kc_subphyla_LanguageList[] = { kc_phylum_languagenames };
static kc_enum_phyla kc_subphyla_Conslanguagenames[] = { kc_phylum_ID, kc_phylum_languagenames };
static kc_enum_phyla kc_subphyla_Consscopetypefilelinestack[] = { kc_phylum_scopetypefileline, kc_phylum_scopetypefilelinestack };
static kc_enum_phyla kc_subphyla_ScopeTypeFileLine[] = { kc_phylum_integer, kc_phylum_IDtype, kc_phylum_casestring, kc_phylum_integer };
static kc_enum_phyla kc_subphyla_ITPredefinedPhylum[] = { kc_phylum_phylumdeclaration };
static kc_enum_phyla kc_subphyla_ITUserPhylum[] = { kc_phylum_phylumdeclaration };
static kc_enum_phyla kc_subphyla_ITPredefinedOperator[] = { kc_phylum_alternative, kc_phylum_ID };
static kc_enum_phyla kc_subphyla_ITUserOperator[] = { kc_phylum_alternative, kc_phylum_ID };
static kc_enum_phyla kc_subphyla_ITUserFunction[] = { kc_phylum_fnclass };
static kc_enum_phyla kc_subphyla_ITPatternVariable[] = { kc_phylum_ID, kc_phylum_integer };
static kc_enum_phyla kc_subphyla_ITLanguageName[] = { kc_phylum_integer };
static kc_enum_phyla kc_subphyla_Consoperators[] = { kc_phylum_ID, kc_phylum_operators };
static kc_enum_phyla kc_subphyla_Consphyla[] = { kc_phylum_ID, kc_phylum_phyla };
static kc_enum_phyla kc_subphyla_Consvariables[] = { kc_phylum_ID, kc_phylum_variables };
static kc_enum_phyla kc_subphyla_TwoStorageoption[] = { kc_phylum_storageoption, kc_phylum_storageoption };
static kc_enum_phyla kc_subphyla_TwoProductionblock[] = { kc_phylum_productionblock, kc_phylum_productionblock };
static kc_enum_phyla kc_subphyla_TwoCcode_option[] = { kc_phylum_Ccode_option, kc_phylum_Ccode_option };
static kc_enum_phyla kc_subphyla_TwoRewriteruleinfo[] = { kc_phylum_rewriteruleinfo, kc_phylum_rewriteruleinfo };
static kc_enum_phyla kc_subphyla_TwoWithcaseinfo[] = { kc_phylum_withcaseinfo, kc_phylum_withcaseinfo };
static kc_enum_phyla kc_subphyla_TwoUnparsedeclinfo[] = { kc_phylum_unparsedeclinfo, kc_phylum_unparsedeclinfo };
static kc_enum_phyla kc_subphyla_TwoPatternrepresentation[] = { kc_phylum_patternrepresentation, kc_phylum_patternrepresentation };
static kc_enum_phyla kc_subphyla_TwoElem_patternrepresentation[] = { kc_phylum_elem_patternrepresentation, kc_phylum_elem_patternrepresentation };
static kc_enum_phyla kc_subphyla_TwoPaths[] = { kc_phylum_paths, kc_phylum_paths };
static kc_enum_phyla kc_subphyla_TwoPath[] = { kc_phylum_path, kc_phylum_path };
static kc_enum_phyla kc_subphyla_Conspatternrepresentations[] = { kc_phylum_patternrepresentation, kc_phylum_patternrepresentations };
static kc_enum_phyla kc_subphyla_Conspatternrepresentation[] = { kc_phylum_elem_patternrepresentation, kc_phylum_patternrepresentation };
static kc_enum_phyla kc_subphyla_PRBinding[] = { kc_phylum_path, kc_phylum_ID };
static kc_enum_phyla kc_subphyla_PRVarPredicate[] = { kc_phylum_paths, kc_phylum_ID, kc_phylum_patternrepresentation };
static kc_enum_phyla kc_subphyla_PROperPredicate[] = { kc_phylum_path, kc_phylum_ID };
static kc_enum_phyla kc_subphyla_PRUserPredicate[] = { kc_phylum_Cexpression };
static kc_enum_phyla kc_subphyla_PRNonLeafBinding[] = { kc_phylum_path, kc_phylum_ID, kc_phylum_patternrepresentation };
static kc_enum_phyla kc_subphyla_PRWildcard[] = { kc_phylum_path };
static kc_enum_phyla kc_subphyla_PRStringLiteral[] = { kc_phylum_path, kc_phylum_CexpressionDQ };
static kc_enum_phyla kc_subphyla_PRIntLiteral[] = { kc_phylum_path, kc_phylum_INT };
static kc_enum_phyla kc_subphyla_Conspath[] = { kc_phylum_integer, kc_phylum_path };
static kc_enum_phyla kc_subphyla_Conspaths[] = { kc_phylum_path, kc_phylum_paths };
static kc_enum_phyla kc_subphyla_Consargsnumbers[] = { kc_phylum_integer, kc_phylum_argsnumbers };
static kc_enum_phyla kc_subphyla_Consrewriterulesinfo[] = { kc_phylum_rewriteruleinfo, kc_phylum_rewriterulesinfo };
static kc_enum_phyla kc_subphyla_Rewriteruleinfo[] = { kc_phylum_patternrepresentation, kc_phylum_patternrepresentation, kc_phylum_rewriteclause };
static kc_enum_phyla kc_subphyla_Conswithcasesinfo[] = { kc_phylum_withcaseinfo, kc_phylum_withcasesinfo };
static kc_enum_phyla kc_subphyla_Withcaseinfo[] = { kc_phylum_patternrepresentation, kc_phylum_patternrepresentation, kc_phylum_Ctext };
static kc_enum_phyla kc_subphyla_Consrewriteviewsinfo[] = { kc_phylum_rewriteviewinfo, kc_phylum_rewriteviewsinfo };
static kc_enum_phyla kc_subphyla_Rewriteviewinfo[] = { kc_phylum_ID, kc_phylum_rewriterulesinfo };
static kc_enum_phyla kc_subphyla_Consunparseviewsinfo[] = { kc_phylum_unparseviewinfo, kc_phylum_unparseviewsinfo };
static kc_enum_phyla kc_subphyla_Unparseviewinfo[] = { kc_phylum_ID, kc_phylum_unparsedeclsinfo };
static kc_enum_phyla kc_subphyla_Consunparsedeclsinfo[] = { kc_phylum_unparsedeclinfo, kc_phylum_unparsedeclsinfo };
static kc_enum_phyla kc_subphyla_Unparsedeclinfo[] = { kc_phylum_patternrepresentation, kc_phylum_patternrepresentation, kc_phylum_unparseclause };
static kc_enum_phyla kc_subphyla_AcDeclaration[] = { kc_phylum_ac_declaration_specifiers, kc_phylum_ac_init_declarator_list };
static kc_enum_phyla kc_subphyla_Consac_declaration_list[] = { kc_phylum_ac_declaration, kc_phylum_ac_declaration_list };
static kc_enum_phyla kc_subphyla_Consac_declaration_specifiers[] = { kc_phylum_ac_declaration_specifier, kc_phylum_ac_declaration_specifiers };
static kc_enum_phyla kc_subphyla_AcDeclSpecStorageSpec[] = { kc_phylum_ac_storage_class_specifier };
static kc_enum_phyla kc_subphyla_AcDeclSpecTypeSpec[] = { kc_phylum_ac_type_specifier };
static kc_enum_phyla kc_subphyla_AcDeclSpecTypeQual[] = { kc_phylum_ac_type_qualifier };
static kc_enum_phyla kc_subphyla_AcTypeSpec[] = { kc_phylum_ID };
static kc_enum_phyla kc_subphyla_Consac_init_declarator_list[] = { kc_phylum_ac_init_declarator, kc_phylum_ac_init_declarator_list };
static kc_enum_phyla kc_subphyla_AcInitDecl[] = { kc_phylum_ac_declarator };
static kc_enum_phyla kc_subphyla_AcDeclarator[] = { kc_phylum_ac_pointer_option, kc_phylum_ac_ref_option, kc_phylum_ac_direct_declarator };
static kc_enum_phyla kc_subphyla_AcDirectDeclId[] = { kc_phylum_ID };
static kc_enum_phyla kc_subphyla_AcDirectDeclPack[] = { kc_phylum_ac_declarator };
static kc_enum_phyla kc_subphyla_AcDirectDeclArray[] = { kc_phylum_ac_direct_declarator, kc_phylum_ac_constant_expression_option };
static kc_enum_phyla kc_subphyla_AcDirectDeclProto[] = { kc_phylum_ac_direct_declarator, kc_phylum_ac_parameter_type_list };
static kc_enum_phyla kc_subphyla_AcQualifiedDeclProto[] = { kc_phylum_ac_class_qualifier_list, kc_phylum_ac_direct_declarator, kc_phylum_ac_parameter_type_list, kc_phylum_ac_type_qualifier };
static kc_enum_phyla kc_subphyla_AcMemberDecl[] = { kc_phylum_ID, kc_phylum_ID, kc_phylum_ac_constant_expression_list };
static kc_enum_phyla kc_subphyla_AcOperatorDeclId[] = { kc_phylum_ac_operator_name };
static kc_enum_phyla kc_subphyla_Yespointer[] = { kc_phylum_ac_pointer };
static kc_enum_phyla kc_subphyla_AcPointerNil[] = { kc_phylum_ac_type_qualifier_list };
static kc_enum_phyla kc_subphyla_AcPointerCons[] = { kc_phylum_ac_type_qualifier_list, kc_phylum_ac_pointer };
static kc_enum_phyla kc_subphyla_AcOperatorName[] = { kc_phylum_casestring };
static kc_enum_phyla kc_subphyla_Consac_class_qualifier_help_list[] = { kc_phylum_ac_direct_declarator, kc_phylum_ac_class_qualifier_help_list };
static kc_enum_phyla kc_subphyla_Consac_class_qualifier_list[] = { kc_phylum_ID, kc_phylum_ac_class_qualifier_list };
static kc_enum_phyla kc_subphyla_Consac_type_qualifier_list[] = { kc_phylum_ac_type_qualifier, kc_phylum_ac_type_qualifier_list };
static kc_enum_phyla kc_subphyla_AcParList[] = { kc_phylum_ac_parameter_list };
static kc_enum_phyla kc_subphyla_AcParList3Dot[] = { kc_phylum_ac_parameter_list };
static kc_enum_phyla kc_subphyla_Consac_parameter_list[] = { kc_phylum_ac_parameter_declaration, kc_phylum_ac_parameter_list };
static kc_enum_phyla kc_subphyla_AcParDeclDecl[] = { kc_phylum_ac_declaration_specifiers, kc_phylum_ac_declarator, kc_phylum_ac_constant_expression_option };
static kc_enum_phyla kc_subphyla_AcParDeclAbsdecl[] = { kc_phylum_ac_declaration_specifiers, kc_phylum_ac_abstract_declarator, kc_phylum_ac_constant_expression_option };
static kc_enum_phyla kc_subphyla_Consac_identifier_list[] = { kc_phylum_ID, kc_phylum_ac_identifier_list };
static kc_enum_phyla kc_subphyla_AcAbsdeclPointer[] = { kc_phylum_ac_pointer };
static kc_enum_phyla kc_subphyla_AcAbsdeclDirdecl[] = { kc_phylum_ac_pointer_option, kc_phylum_ac_direct_abstract_declarator };
static kc_enum_phyla kc_subphyla_Yesac_direct_abstract_declarator[] = { kc_phylum_ac_direct_abstract_declarator };
static kc_enum_phyla kc_subphyla_AcDirAbsdeclPack[] = { kc_phylum_ac_abstract_declarator };
static kc_enum_phyla kc_subphyla_AcDirAbsdeclArray[] = { kc_phylum_ac_direct_abstract_declarator_option, kc_phylum_ac_constant_expression_option };
static kc_enum_phyla kc_subphyla_AcDirAbsdeclFn[] = { kc_phylum_ac_direct_abstract_declarator_option, kc_phylum_ac_parameter_type_list };
static kc_enum_phyla kc_subphyla_Yesac_constant_expression[] = { kc_phylum_ac_constant_expression };
static kc_enum_phyla kc_subphyla_AcConstExpr[] = { kc_phylum_Cexpression };
static kc_enum_phyla kc_subphyla_Consac_constant_expression_list[] = { kc_phylum_ac_constant_expression, kc_phylum_ac_constant_expression_list };
static kc_enum_phyla kc_subphyla_AcYesBaseInit[] = { kc_phylum_ac_base_init_list };
static kc_enum_phyla kc_subphyla_Consac_base_init_list[] = { kc_phylum_ac_base_init, kc_phylum_ac_base_init_list };
static kc_enum_phyla kc_subphyla_AcBaseInit[] = { kc_phylum_ID, kc_phylum_ac_constant_expression };
static kc_enum_phyla kc_subphyla_Consbaseclass_declarations[] = { kc_phylum_baseclass_decl, kc_phylum_baseclass_declarations };
static kc_enum_phyla kc_subphyla_BaseClassDecl[] = { kc_phylum_ID, kc_phylum_baseclass_list };
static kc_enum_phyla kc_subphyla_Consbaseclass_list[] = { kc_phylum_ID, kc_phylum_baseclass_list };
static kc_enum_phyla kc_subphyla_Fatal[] = { kc_phylum_fileline, kc_phylum_problem };
static kc_enum_phyla kc_subphyla_NonFatal[] = { kc_phylum_fileline, kc_phylum_problem };
static kc_enum_phyla kc_subphyla_Warning[] = { kc_phylum_fileline, kc_phylum_problem };
static kc_enum_phyla kc_subphyla_Problem1[] = { kc_phylum_casestring };
static kc_enum_phyla kc_subphyla_Problem1ID[] = { kc_phylum_casestring, kc_phylum_ID };
static kc_enum_phyla kc_subphyla_Problem1tID[] = { kc_phylum_casestring, kc_phylum_ID };
static kc_enum_phyla kc_subphyla_Problem1we[] = { kc_phylum_casestring, kc_phylum_withexpression };
static kc_enum_phyla kc_subphyla_Problem1ID1ID[] = { kc_phylum_casestring, kc_phylum_ID, kc_phylum_casestring, kc_phylum_ID };
static kc_enum_phyla kc_subphyla_Problem1t1ID[] = { kc_phylum_casestring, kc_phylum_IDtype, kc_phylum_casestring, kc_phylum_ID };
static kc_enum_phyla kc_subphyla_Problem1INT[] = { kc_phylum_casestring, kc_phylum_INT };
static kc_enum_phyla kc_subphyla_Problem1int1[] = { kc_phylum_casestring, kc_phylum_integer, kc_phylum_casestring };
static kc_enum_phyla kc_subphyla_Problem1INT1ID[] = { kc_phylum_casestring, kc_phylum_INT, kc_phylum_casestring, kc_phylum_ID };
static kc_enum_phyla kc_subphyla_Problem1ID1ID1ID[] = { kc_phylum_casestring, kc_phylum_ID, kc_phylum_casestring, kc_phylum_ID, kc_phylum_casestring, kc_phylum_ID };
static kc_enum_phyla kc_subphyla_Problem1INT1ID1ID[] = { kc_phylum_casestring, kc_phylum_INT, kc_phylum_casestring, kc_phylum_ID, kc_phylum_casestring, kc_phylum_ID };
static kc_enum_phyla kc_subphyla_Problem1storageoption1ID[] = { kc_phylum_casestring, kc_phylum_storageoption, kc_phylum_casestring, kc_phylum_ID };
static kc_enum_phyla kc_subphyla_Problem2[] = { kc_phylum_casestring, kc_phylum_casestring };
static kc_enum_phyla kc_subphyla_Problem3[] = { kc_phylum_casestring, kc_phylum_casestring, kc_phylum_casestring };
static kc_enum_phyla kc_subphyla_Problem3int1[] = { kc_phylum_casestring, kc_phylum_casestring, kc_phylum_casestring, kc_phylum_integer, kc_phylum_casestring };
static kc_enum_phyla kc_subphyla_Problem4[] = { kc_phylum_casestring, kc_phylum_casestring, kc_phylum_casestring, kc_phylum_casestring };
static kc_enum_phyla kc_subphyla_Problem5[] = { kc_phylum_casestring, kc_phylum_casestring, kc_phylum_casestring, kc_phylum_casestring, kc_phylum_casestring };
static kc_enum_phyla kc_subphyla_Problem6[] = { kc_phylum_casestring, kc_phylum_casestring, kc_phylum_casestring, kc_phylum_casestring, kc_phylum_casestring, kc_phylum_casestring };
static kc_enum_phyla kc_subphyla_Consaddedphylumdeclarations[] = { kc_phylum_addedphylumdeclaration, kc_phylum_addedphylumdeclarations };
static kc_enum_phyla kc_subphyla_AddedPhylumdeclaration[] = { kc_phylum_uniqID };
static kc_enum_phyla kc_subphyla_Conscountedphylumdeclarations[] = { kc_phylum_countedphylumdeclaration, kc_phylum_countedphylumdeclarations };
static kc_enum_phyla kc_subphyla_CountedPhylumdeclaration[] = { kc_phylum_uniqID };
static kc_enum_phyla kc_subphyla_Consbindingidmarks[] = { kc_phylum_bindingidmark, kc_phylum_bindingidmarks };
static kc_enum_phyla kc_subphyla_BindingIdMark[] = { kc_phylum_uniqID };


KC_OPERATOR_INFO kc_OperatorInfo[] = {
    { "", 0, 0, kc_one_before_first_phylum, 0, 0, 0, 0 }, /* dummy element */
    { "NoCaseStr", 0, true, kc_phylum_nocasestring, 0, 0, 0, sizeof(kc_tag_nocasestring_NoCaseStr) },
    { "_Str", 0, true, kc_phylum_casestring, 0, 0, 0, sizeof(kc_tag_casestring__Str) },
    { "_Real", 0, true, kc_phylum_real, 0, 0, 0, sizeof(kc_tag_real__Real) },
    { "_Int", 0, true, kc_phylum_integer, 0, 0, 0, sizeof(kc_tag_integer__Int) },
    { "_VoidPtr", 0, true, kc_phylum_voidptr, 0, 0, 0, sizeof(kc_tag_voidptr__VoidPtr) },
    { "Str", 1, false, kc_phylum_uniqID, kc_subphyla_Str, 0, 0, sizeof(kc_tag_uniqID_Str) },
    { "Id", 1, false, kc_phylum_ID, kc_subphyla_Id, 0, 0, sizeof(kc_tag_ID_Id) },
    { "Int", 1, false, kc_phylum_INT, kc_subphyla_Int, 0, 0, sizeof(kc_tag_INT_Int) },
    { "String", 1, false, kc_phylum_STRING, kc_subphyla_String, 0, 0, sizeof(kc_tag_STRING_String) },
    { "PhylumDeclarations", 1, false, kc_phylum_phylumdeclarationsroot, kc_subphyla_PhylumDeclarations, 0, 0, sizeof(kc_tag_phylumdeclarationsroot_PhylumDeclarations) },
    { "Nilphylumdeclarations", 0, false, kc_phylum_phylumdeclarations, 0, 0, 0, sizeof(kc_tag_phylumdeclarations) },
    { "Consphylumdeclarations", 2, false, kc_phylum_phylumdeclarations, kc_subphyla_Consphylumdeclarations, 0, 0, sizeof(kc_tag_phylumdeclarations) },
    { "Nilphylumnames", 0, false, kc_phylum_phylumnames, 0, 0, 0, sizeof(kc_tag_phylumnames) },
    { "Consphylumnames", 2, false, kc_phylum_phylumnames, kc_subphyla_Consphylumnames, 0, 0, sizeof(kc_tag_phylumnames) },
    { "PhylumDeclaration", 4, false, kc_phylum_phylumdeclaration, kc_subphyla_PhylumDeclaration, 0, 0, sizeof(kc_tag_phylumdeclaration_PhylumDeclaration) },
    { "NoStorageOption", 0, false, kc_phylum_storageoption, 0, 0, 0, sizeof(kc_tag_storageoption_NoStorageOption) },
    { "NegativeStorageOption", 1, false, kc_phylum_storageoption, kc_subphyla_NegativeStorageOption, 0, 0, sizeof(kc_tag_storageoption_NegativeStorageOption) },
    { "PositiveStorageOption", 1, false, kc_phylum_storageoption, kc_subphyla_PositiveStorageOption, 0, 0, sizeof(kc_tag_storageoption_PositiveStorageOption) },
    { "Nilstorageclasses", 0, false, kc_phylum_storageclasses, 0, 0, 0, sizeof(kc_tag_storageclasses) },
    { "Consstorageclasses", 2, false, kc_phylum_storageclasses, kc_subphyla_Consstorageclasses, 0, 0, sizeof(kc_tag_storageclasses) },
    { "Emptyproductionblock", 0, false, kc_phylum_productionblock, 0, 0, 0, sizeof(kc_tag_productionblock_Emptyproductionblock) },
    { "ListAlternatives", 2, false, kc_phylum_productionblock, kc_subphyla_ListAlternatives, 0, 0, sizeof(kc_tag_productionblock_ListAlternatives) },
    { "NonlistAlternatives", 1, false, kc_phylum_productionblock, kc_subphyla_NonlistAlternatives, 0, 0, sizeof(kc_tag_productionblock_NonlistAlternatives) },
    { "PredefinedAlternatives", 1, false, kc_phylum_productionblock, kc_subphyla_PredefinedAlternatives, 0, 0, sizeof(kc_tag_productionblock_PredefinedAlternatives) },
    { "Nilalternatives", 0, false, kc_phylum_alternatives, 0, 0, 0, sizeof(kc_tag_alternatives) },
    { "Consalternatives", 2, false, kc_phylum_alternatives, kc_subphyla_Consalternatives, 0, 0, sizeof(kc_tag_alternatives) },
    { "Alternative", 2, false, kc_phylum_alternative, kc_subphyla_Alternative, 0, 0, sizeof(kc_tag_alternative_Alternative) },
    { "Nilarguments", 0, false, kc_phylum_arguments, 0, 0, 0, sizeof(kc_tag_arguments) },
    { "Consarguments", 2, false, kc_phylum_arguments, kc_subphyla_Consarguments, 0, 0, sizeof(kc_tag_arguments) },
    { "Argument", 2, false, kc_phylum_argument, kc_subphyla_Argument, 0, 0, sizeof(kc_tag_argument_Argument) },
    { "CcodeOption", 2, false, kc_phylum_Ccode_option, kc_subphyla_CcodeOption, 0, 0, sizeof(kc_tag_Ccode_option_CcodeOption) },
    { "Nilattributes", 0, false, kc_phylum_attributes, 0, 0, 0, sizeof(kc_tag_attributes) },
    { "Consattributes", 2, false, kc_phylum_attributes, kc_subphyla_Consattributes, 0, 0, sizeof(kc_tag_attributes) },
    { "Attribute", 3, false, kc_phylum_attribute, kc_subphyla_Attribute, 0, 0, sizeof(kc_tag_attribute_Attribute) },
    { "Noattribute_initialisation", 0, false, kc_phylum_attribute_initialisation_option, 0, 0, 0, sizeof(kc_tag_attribute_initialisation_option_Noattribute_initialisation) },
    { "Yesattribute_initialisation", 1, false, kc_phylum_attribute_initialisation_option, kc_subphyla_Yesattribute_initialisation, 0, 0, sizeof(kc_tag_attribute_initialisation_option_Yesattribute_initialisation) },
    { "NilCexpression", 0, false, kc_phylum_Cexpression, 0, 0, 0, sizeof(kc_tag_Cexpression) },
    { "ConsCexpression", 2, false, kc_phylum_Cexpression, kc_subphyla_ConsCexpression, 0, 0, sizeof(kc_tag_Cexpression) },
    { "CExpressionPart", 1, false, kc_phylum_Cexpression_elem, kc_subphyla_CExpressionPart, 0, 0, sizeof(kc_tag_Cexpression_elem_CExpressionPart) },
    { "CExpressionDollarvar", 1, false, kc_phylum_Cexpression_elem, kc_subphyla_CExpressionDollarvar, 0, 0, sizeof(kc_tag_Cexpression_elem_CExpressionDollarvar) },
    { "CExpressionNl", 1, false, kc_phylum_Cexpression_elem, kc_subphyla_CExpressionNl, 0, 0, sizeof(kc_tag_Cexpression_elem_CExpressionNl) },
    { "CExpressionDQ", 1, false, kc_phylum_Cexpression_elem, kc_subphyla_CExpressionDQ, 0, 0, sizeof(kc_tag_Cexpression_elem_CExpressionDQ) },
    { "CExpressionSQ", 1, false, kc_phylum_Cexpression_elem, kc_subphyla_CExpressionSQ, 0, 0, sizeof(kc_tag_Cexpression_elem_CExpressionSQ) },
    { "CExpressionPack", 1, false, kc_phylum_Cexpression_elem, kc_subphyla_CExpressionPack, 0, 0, sizeof(kc_tag_Cexpression_elem_CExpressionPack) },
    { "CExpressionArray", 1, false, kc_phylum_Cexpression_elem, kc_subphyla_CExpressionArray, 0, 0, sizeof(kc_tag_Cexpression_elem_CExpressionArray) },
    { "NilCexpressionDQ", 0, false, kc_phylum_CexpressionDQ, 0, 0, 0, sizeof(kc_tag_CexpressionDQ) },
    { "ConsCexpressionDQ", 2, false, kc_phylum_CexpressionDQ, kc_subphyla_ConsCexpressionDQ, 0, 0, sizeof(kc_tag_CexpressionDQ) },
    { "CExpressionDQPart", 1, false, kc_phylum_CexpressionDQ_elem, kc_subphyla_CExpressionDQPart, 0, 0, sizeof(kc_tag_CexpressionDQ_elem_CExpressionDQPart) },
    { "CExpressionDQNl", 1, false, kc_phylum_CexpressionDQ_elem, kc_subphyla_CExpressionDQNl, 0, 0, sizeof(kc_tag_CexpressionDQ_elem_CExpressionDQNl) },
    { "NilCexpressionSQ", 0, false, kc_phylum_CexpressionSQ, 0, 0, 0, sizeof(kc_tag_CexpressionSQ) },
    { "ConsCexpressionSQ", 2, false, kc_phylum_CexpressionSQ, kc_subphyla_ConsCexpressionSQ, 0, 0, sizeof(kc_tag_CexpressionSQ) },
    { "CExpressionSQPart", 1, false, kc_phylum_CexpressionSQ_elem, kc_subphyla_CExpressionSQPart, 0, 0, sizeof(kc_tag_CexpressionSQ_elem_CExpressionSQPart) },
    { "CExpressionSQNl", 1, false, kc_phylum_CexpressionSQ_elem, kc_subphyla_CExpressionSQNl, 0, 0, sizeof(kc_tag_CexpressionSQ_elem_CExpressionSQNl) },
    { "NilidCexpressions", 0, false, kc_phylum_idCexpressions, 0, 0, 0, sizeof(kc_tag_idCexpressions) },
    { "ConsidCexpressions", 2, false, kc_phylum_idCexpressions, kc_subphyla_ConsidCexpressions, 0, 0, sizeof(kc_tag_idCexpressions) },
    { "IdCexpression", 2, false, kc_phylum_idCexpression, kc_subphyla_IdCexpression, 0, 0, sizeof(kc_tag_idCexpression_IdCexpression) },
    { "NilCtexts", 0, false, kc_phylum_Ctexts, 0, 0, 0, sizeof(kc_tag_Ctexts) },
    { "ConsCtexts", 2, false, kc_phylum_Ctexts, kc_subphyla_ConsCtexts, 0, 0, sizeof(kc_tag_Ctexts) },
    { "Nilincludefiles", 0, false, kc_phylum_includefiles, 0, 0, 0, sizeof(kc_tag_includefiles) },
    { "Consincludefiles", 2, false, kc_phylum_includefiles, kc_subphyla_Consincludefiles, 0, 0, sizeof(kc_tag_includefiles) },
    { "IncludeFile", 1, false, kc_phylum_includefile, kc_subphyla_IncludeFile, 0, 0, sizeof(kc_tag_includefile_IncludeFile) },
    { "Nilincludedeclarations", 0, false, kc_phylum_includedeclarations, 0, 0, 0, sizeof(kc_tag_includedeclarations) },
    { "Consincludedeclarations", 2, false, kc_phylum_includedeclarations, kc_subphyla_Consincludedeclarations, 0, 0, sizeof(kc_tag_includedeclarations) },
    { "IncludeDeclaration", 1, false, kc_phylum_includedeclaration, kc_subphyla_IncludeDeclaration, 0, 0, sizeof(kc_tag_includedeclaration_IncludeDeclaration) },
    { "Nilrwdeclarations", 0, false, kc_phylum_rwdeclarations, 0, 0, 0, sizeof(kc_tag_rwdeclarations) },
    { "Consrwdeclarations", 2, false, kc_phylum_rwdeclarations, kc_subphyla_Consrwdeclarations, 0, 0, sizeof(kc_tag_rwdeclarations) },
    { "RwDeclaration", 2, false, kc_phylum_rwdeclaration, kc_subphyla_RwDeclaration, 0, 0, sizeof(kc_tag_rwdeclaration_RwDeclaration) },
    { "Nilrewriteclauses", 0, false, kc_phylum_rewriteclauses, 0, 0, 0, sizeof(kc_tag_rewriteclauses) },
    { "Consrewriteclauses", 2, false, kc_phylum_rewriteclauses, kc_subphyla_Consrewriteclauses, 0, 0, sizeof(kc_tag_rewriteclauses) },
    { "RewriteClause", 2, false, kc_phylum_rewriteclause, kc_subphyla_RewriteClause, 0, 0, sizeof(kc_tag_rewriteclause_RewriteClause) },
    { "Nilpatternchains", 0, false, kc_phylum_patternchains, 0, 0, 0, sizeof(kc_tag_patternchains) },
    { "Conspatternchains", 2, false, kc_phylum_patternchains, kc_subphyla_Conspatternchains, 0, 0, sizeof(kc_tag_patternchains) },
    { "Nilpatternchain", 0, false, kc_phylum_patternchain, 0, 0, 0, sizeof(kc_tag_patternchain) },
    { "Conspatternchain", 2, false, kc_phylum_patternchain, kc_subphyla_Conspatternchain, 0, 0, sizeof(kc_tag_patternchain) },
    { "Niloutmostpatterns", 0, false, kc_phylum_outmostpatterns, 0, 0, 0, sizeof(kc_tag_outmostpatterns) },
    { "Consoutmostpatterns", 2, false, kc_phylum_outmostpatterns, kc_subphyla_Consoutmostpatterns, 0, 0, sizeof(kc_tag_outmostpatterns) },
    { "PatternchainitemOutmost", 1, false, kc_phylum_patternchainitem, kc_subphyla_PatternchainitemOutmost, 0, 0, sizeof(kc_tag_patternchainitem_PatternchainitemOutmost) },
    { "PatternchainitemGroup", 1, false, kc_phylum_patternchainitem, kc_subphyla_PatternchainitemGroup, 0, 0, sizeof(kc_tag_patternchainitem_PatternchainitemGroup) },
    { "PatternchainitemDollarid", 1, false, kc_phylum_patternchainitem, kc_subphyla_PatternchainitemDollarid, 0, 0, sizeof(kc_tag_patternchainitem_PatternchainitemDollarid) },
    { "OPOperatorWildcard", 2, false, kc_phylum_outmostpattern, kc_subphyla_OPOperatorWildcard, 0, 0, sizeof(kc_tag_outmostpattern_OPOperatorWildcard) },
    { "OPOperator", 3, false, kc_phylum_outmostpattern, kc_subphyla_OPOperator, 0, 0, sizeof(kc_tag_outmostpattern_OPOperator) },
    { "OPNonLeafVariable", 2, false, kc_phylum_outmostpattern, kc_subphyla_OPNonLeafVariable, 0, 0, sizeof(kc_tag_outmostpattern_OPNonLeafVariable) },
    { "OPWildcard", 1, false, kc_phylum_outmostpattern, kc_subphyla_OPWildcard, 0, 0, sizeof(kc_tag_outmostpattern_OPWildcard) },
    { "OPDefault", 1, false, kc_phylum_outmostpattern, kc_subphyla_OPDefault, 0, 0, sizeof(kc_tag_outmostpattern_OPDefault) },
    { "PVariable", 1, false, kc_phylum_pattern, kc_subphyla_PVariable, 0, 0, sizeof(kc_tag_pattern_PVariable) },
    { "POperator", 2, false, kc_phylum_pattern, kc_subphyla_POperator, 0, 0, sizeof(kc_tag_pattern_POperator) },
    { "PNonLeafVariable", 2, false, kc_phylum_pattern, kc_subphyla_PNonLeafVariable, 0, 0, sizeof(kc_tag_pattern_PNonLeafVariable) },
    { "PWildcard", 0, false, kc_phylum_pattern, 0, 0, 0, sizeof(kc_tag_pattern_PWildcard) },
    { "PStringLiteral", 1, false, kc_phylum_pattern, kc_subphyla_PStringLiteral, 0, 0, sizeof(kc_tag_pattern_PStringLiteral) },
    { "PIntLiteral", 1, false, kc_phylum_pattern, kc_subphyla_PIntLiteral, 0, 0, sizeof(kc_tag_pattern_PIntLiteral) },
    { "Nilpatterns", 0, false, kc_phylum_patterns, 0, 0, 0, sizeof(kc_tag_patterns) },
    { "Conspatterns", 2, false, kc_phylum_patterns, kc_subphyla_Conspatterns, 0, 0, sizeof(kc_tag_patterns) },
    { "TVariable", 1, false, kc_phylum_term, kc_subphyla_TVariable, 0, 0, sizeof(kc_tag_term_TVariable) },
    { "TOperator", 2, false, kc_phylum_term, kc_subphyla_TOperator, 0, 0, sizeof(kc_tag_term_TOperator) },
    { "TMethod", 3, false, kc_phylum_term, kc_subphyla_TMethod, 0, 0, sizeof(kc_tag_term_TMethod) },
    { "TCTerm", 1, false, kc_phylum_term, kc_subphyla_TCTerm, 0, 0, sizeof(kc_tag_term_TCTerm) },
    { "TStringLiteral", 1, false, kc_phylum_term, kc_subphyla_TStringLiteral, 0, 0, sizeof(kc_tag_term_TStringLiteral) },
    { "TIntLiteral", 1, false, kc_phylum_term, kc_subphyla_TIntLiteral, 0, 0, sizeof(kc_tag_term_TIntLiteral) },
    { "Nilterms", 0, false, kc_phylum_terms, 0, 0, 0, sizeof(kc_tag_terms) },
    { "Consterms", 2, false, kc_phylum_terms, kc_subphyla_Consterms, 0, 0, sizeof(kc_tag_terms) },
    { "Nilfnfiles", 0, false, kc_phylum_fnfiles, 0, 0, 0, sizeof(kc_tag_fnfiles) },
    { "Consfnfiles", 2, false, kc_phylum_fnfiles, kc_subphyla_Consfnfiles, 0, 0, sizeof(kc_tag_fnfiles) },
    { "FnFile", 1, false, kc_phylum_fnfile, kc_subphyla_FnFile, 0, 0, sizeof(kc_tag_fnfile_FnFile) },
    { "Nilfndeclarations", 0, false, kc_phylum_fndeclarations, 0, 0, 0, sizeof(kc_tag_fndeclarations) },
    { "Consfndeclarations", 2, false, kc_phylum_fndeclarations, kc_subphyla_Consfndeclarations, 0, 0, sizeof(kc_tag_fndeclarations) },
    { "FnAcDeclaration", 7, false, kc_phylum_fndeclaration, kc_subphyla_FnAcDeclaration, 0, 0, sizeof(kc_tag_fndeclaration_FnAcDeclaration) },
    { "AcMemberDeclaration", 4, false, kc_phylum_fndeclaration, kc_subphyla_AcMemberDeclaration, 0, 0, sizeof(kc_tag_fndeclaration_AcMemberDeclaration) },
    { "GlobalFn", 0, false, kc_phylum_fnclass, 0, 0, 0, sizeof(kc_tag_fnclass_GlobalFn) },
    { "StaticFn", 1, false, kc_phylum_fnclass, kc_subphyla_StaticFn, 0, 0, sizeof(kc_tag_fnclass_StaticFn) },
    { "MemberFn", 0, false, kc_phylum_fnclass, 0, 0, 0, sizeof(kc_tag_fnclass_MemberFn) },
    { "ConstructorFn", 0, false, kc_phylum_fnclass, 0, 0, 0, sizeof(kc_tag_fnclass_ConstructorFn) },
    { "DestructorFn", 0, false, kc_phylum_fnclass, 0, 0, 0, sizeof(kc_tag_fnclass_DestructorFn) },
    { "NilCtext", 0, false, kc_phylum_Ctext, 0, 0, 0, sizeof(kc_tag_Ctext) },
    { "ConsCtext", 2, false, kc_phylum_Ctext, kc_subphyla_ConsCtext, 0, 0, sizeof(kc_tag_Ctext) },
    { "CTextLine", 1, false, kc_phylum_Ctext_elem, kc_subphyla_CTextLine, 0, 0, sizeof(kc_tag_Ctext_elem_CTextLine) },
    { "CTextDollarVar", 1, false, kc_phylum_Ctext_elem, kc_subphyla_CTextDollarVar, 0, 0, sizeof(kc_tag_Ctext_elem_CTextDollarVar) },
    { "CTextNl", 1, false, kc_phylum_Ctext_elem, kc_subphyla_CTextNl, 0, 0, sizeof(kc_tag_Ctext_elem_CTextNl) },
    { "CTextCexpressionDQ", 1, false, kc_phylum_Ctext_elem, kc_subphyla_CTextCexpressionDQ, 0, 0, sizeof(kc_tag_Ctext_elem_CTextCexpressionDQ) },
    { "CTextCexpressionSQ", 1, false, kc_phylum_Ctext_elem, kc_subphyla_CTextCexpressionSQ, 0, 0, sizeof(kc_tag_Ctext_elem_CTextCexpressionSQ) },
    { "CTextCbody", 1, false, kc_phylum_Ctext_elem, kc_subphyla_CTextCbody, 0, 0, sizeof(kc_tag_Ctext_elem_CTextCbody) },
    { "CTextForeachexpression", 5, false, kc_phylum_Ctext_elem, kc_subphyla_CTextForeachexpression, 0, 0, sizeof(kc_tag_Ctext_elem_CTextForeachexpression) },
    { "CTextWithexpression", 3, false, kc_phylum_Ctext_elem, kc_subphyla_CTextWithexpression, 0, 0, sizeof(kc_tag_Ctext_elem_CTextWithexpression) },
    { "NoForeachAfter", 0, false, kc_phylum_foreach_after, 0, 0, 0, sizeof(kc_tag_foreach_after_NoForeachAfter) },
    { "ForeachAfter", 4, false, kc_phylum_foreach_after, kc_subphyla_ForeachAfter, 0, 0, sizeof(kc_tag_foreach_after_ForeachAfter) },
    { "InForeachContext", 1, false, kc_phylum_contextinfo, kc_subphyla_InForeachContext, 0, 0, sizeof(kc_tag_contextinfo_InForeachContext) },
    { "NotInForeachContext", 0, false, kc_phylum_contextinfo, 0, 0, 0, sizeof(kc_tag_contextinfo_NotInForeachContext) },
    { "Nilwithexpressions", 0, false, kc_phylum_withexpressions, 0, 0, 0, sizeof(kc_tag_withexpressions) },
    { "Conswithexpressions", 2, false, kc_phylum_withexpressions, kc_subphyla_Conswithexpressions, 0, 0, sizeof(kc_tag_withexpressions) },
    { "WEVariable", 1, false, kc_phylum_withexpression, kc_subphyla_WEVariable, 0, 0, sizeof(kc_tag_withexpression_WEVariable) },
    { "WECexpression", 1, false, kc_phylum_withexpression, kc_subphyla_WECexpression, 0, 0, sizeof(kc_tag_withexpression_WECexpression) },
    { "Nilwithcases", 0, false, kc_phylum_withcases, 0, 0, 0, sizeof(kc_tag_withcases) },
    { "Conswithcases", 2, false, kc_phylum_withcases, kc_subphyla_Conswithcases, 0, 0, sizeof(kc_tag_withcases) },
    { "Withcase", 2, false, kc_phylum_withcase, kc_subphyla_Withcase, 0, 0, sizeof(kc_tag_withcase_Withcase) },
    { "Nilunparsedeclarations", 0, false, kc_phylum_unparsedeclarations, 0, 0, 0, sizeof(kc_tag_unparsedeclarations) },
    { "Consunparsedeclarations", 2, false, kc_phylum_unparsedeclarations, kc_subphyla_Consunparsedeclarations, 0, 0, sizeof(kc_tag_unparsedeclarations) },
    { "UnparseDeclaration", 2, false, kc_phylum_unparsedeclaration, kc_subphyla_UnparseDeclaration, 0, 0, sizeof(kc_tag_unparsedeclaration_UnparseDeclaration) },
    { "Nilunparseclauses", 0, false, kc_phylum_unparseclauses, 0, 0, 0, sizeof(kc_tag_unparseclauses) },
    { "Consunparseclauses", 2, false, kc_phylum_unparseclauses, kc_subphyla_Consunparseclauses, 0, 0, sizeof(kc_tag_unparseclauses) },
    { "UnparseClause", 2, false, kc_phylum_unparseclause, kc_subphyla_UnparseClause, 0, 0, sizeof(kc_tag_unparseclause_UnparseClause) },
    { "Nilviewnames", 0, false, kc_phylum_viewnames, 0, 0, 0, sizeof(kc_tag_viewnames) },
    { "Consviewnames", 2, false, kc_phylum_viewnames, kc_subphyla_Consviewnames, 0, 0, sizeof(kc_tag_viewnames) },
    { "Nilunparseitems", 0, false, kc_phylum_unparseitems, 0, 0, 0, sizeof(kc_tag_unparseitems) },
    { "Consunparseitems", 2, false, kc_phylum_unparseitems, kc_subphyla_Consunparseitems, 0, 0, sizeof(kc_tag_unparseitems) },
    { "UnpStr", 3, false, kc_phylum_unparseitem, kc_subphyla_UnpStr, 0, 0, sizeof(kc_tag_unparseitem_UnpStr) },
    { "UnpSubexpr", 3, false, kc_phylum_unparseitem, kc_subphyla_UnpSubexpr, 0, 0, sizeof(kc_tag_unparseitem_UnpSubexpr) },
    { "UnpCtext", 2, false, kc_phylum_unparseitem, kc_subphyla_UnpCtext, 0, 0, sizeof(kc_tag_unparseitem_UnpCtext) },
    { "UnpBody", 2, false, kc_phylum_unparseitem, kc_subphyla_UnpBody, 0, 0, sizeof(kc_tag_unparseitem_UnpBody) },
    { "UViewVarDecl", 3, false, kc_phylum_unparseitem, kc_subphyla_UViewVarDecl, 0, 0, sizeof(kc_tag_unparseitem_UViewVarDecl) },
    { "UnpSubTerm", 1, false, kc_phylum_unpsubterm, kc_subphyla_UnpSubTerm, 0, 0, sizeof(kc_tag_unpsubterm_UnpSubTerm) },
    { "UnpDollarvarTerm", 1, false, kc_phylum_unpsubterm, kc_subphyla_UnpDollarvarTerm, 0, 0, sizeof(kc_tag_unpsubterm_UnpDollarvarTerm) },
    { "UnpSubAttr", 2, false, kc_phylum_unpsubterm, kc_subphyla_UnpSubAttr, 0, 0, sizeof(kc_tag_unpsubterm_UnpSubAttr) },
    { "UnpDollarvarAttr", 2, false, kc_phylum_unpsubterm, kc_subphyla_UnpDollarvarAttr, 0, 0, sizeof(kc_tag_unpsubterm_UnpDollarvarAttr) },
    { "UnpCastedVariable", 2, false, kc_phylum_unpsubterm, kc_subphyla_UnpCastedVariable, 0, 0, sizeof(kc_tag_unpsubterm_UnpCastedVariable) },
    { "Nilunpattributes", 0, false, kc_phylum_unpattributes, 0, 0, 0, sizeof(kc_tag_unpattributes) },
    { "Consunpattributes", 2, false, kc_phylum_unpattributes, kc_subphyla_Consunpattributes, 0, 0, sizeof(kc_tag_unpattributes) },
    { "NoViewname", 0, false, kc_phylum_viewnameoption, 0, 0, 0, sizeof(kc_tag_viewnameoption_NoViewname) },
    { "YesViewname", 1, false, kc_phylum_viewnameoption, kc_subphyla_YesViewname, 0, 0, sizeof(kc_tag_viewnameoption_YesViewname) },
    { "NoLanguagename", 0, false, kc_phylum_languageoption, 0, 0, 0, sizeof(kc_tag_languageoption_NoLanguagename) },
    { "LanguageList", 1, false, kc_phylum_languageoption, kc_subphyla_LanguageList, 0, 0, sizeof(kc_tag_languageoption_LanguageList) },
    { "Nillanguagenames", 0, false, kc_phylum_languagenames, 0, 0, 0, sizeof(kc_tag_languagenames) },
    { "Conslanguagenames", 2, false, kc_phylum_languagenames, kc_subphyla_Conslanguagenames, 0, 0, sizeof(kc_tag_languagenames) },
    { "FileLine", 0, false, kc_phylum_fileline, 0, 0, 0, sizeof(kc_tag_fileline_FileLine) },
    { "NoFileLine", 0, false, kc_phylum_fileline, 0, 0, 0, sizeof(kc_tag_fileline_NoFileLine) },
    { "PosNoFileLine", 0, false, kc_phylum_fileline, 0, 0, 0, sizeof(kc_tag_fileline_PosNoFileLine) },
    { "Nilscopetypefilelinestack", 0, false, kc_phylum_scopetypefilelinestack, 0, 0, 0, sizeof(kc_tag_scopetypefilelinestack) },
    { "Consscopetypefilelinestack", 2, false, kc_phylum_scopetypefilelinestack, kc_subphyla_Consscopetypefilelinestack, 0, 0, sizeof(kc_tag_scopetypefilelinestack) },
    { "ScopeTypeFileLine", 4, false, kc_phylum_scopetypefileline, kc_subphyla_ScopeTypeFileLine, 0, 0, sizeof(kc_tag_scopetypefileline_ScopeTypeFileLine) },
    { "ITUnknown", 0, false, kc_phylum_IDtype, 0, 0, 0, sizeof(kc_tag_IDtype_ITUnknown) },
    { "ITPredefinedPhylum", 1, false, kc_phylum_IDtype, kc_subphyla_ITPredefinedPhylum, 0, 0, sizeof(kc_tag_IDtype_ITPredefinedPhylum) },
    { "ITUserPhylum", 1, false, kc_phylum_IDtype, kc_subphyla_ITUserPhylum, 0, 0, sizeof(kc_tag_IDtype_ITUserPhylum) },
    { "ITPredefinedOperator", 2, false, kc_phylum_IDtype, kc_subphyla_ITPredefinedOperator, 0, 0, sizeof(kc_tag_IDtype_ITPredefinedOperator) },
    { "ITUserOperator", 2, false, kc_phylum_IDtype, kc_subphyla_ITUserOperator, 0, 0, sizeof(kc_tag_IDtype_ITUserOperator) },
    { "ITPredefinedStorageClass", 0, false, kc_phylum_IDtype, 0, 0, 0, sizeof(kc_tag_IDtype_ITPredefinedStorageClass) },
    { "ITStorageClass", 0, false, kc_phylum_IDtype, 0, 0, 0, sizeof(kc_tag_IDtype_ITStorageClass) },
    { "ITPredefinedUView", 0, false, kc_phylum_IDtype, 0, 0, 0, sizeof(kc_tag_IDtype_ITPredefinedUView) },
    { "ITUserUView", 0, false, kc_phylum_IDtype, 0, 0, 0, sizeof(kc_tag_IDtype_ITUserUView) },
    { "ITUViewVar", 0, false, kc_phylum_IDtype, 0, 0, 0, sizeof(kc_tag_IDtype_ITUViewVar) },
    { "ITPredefinedRView", 0, false, kc_phylum_IDtype, 0, 0, 0, sizeof(kc_tag_IDtype_ITPredefinedRView) },
    { "ITUserRView", 0, false, kc_phylum_IDtype, 0, 0, 0, sizeof(kc_tag_IDtype_ITUserRView) },
    { "ITUserFunction", 1, false, kc_phylum_IDtype, kc_subphyla_ITUserFunction, 0, 0, sizeof(kc_tag_IDtype_ITUserFunction) },
    { "ITPatternVariable", 2, false, kc_phylum_IDtype, kc_subphyla_ITPatternVariable, 0, 0, sizeof(kc_tag_IDtype_ITPatternVariable) },
    { "ITLanguageName", 1, false, kc_phylum_IDtype, kc_subphyla_ITLanguageName, 0, 0, sizeof(kc_tag_IDtype_ITLanguageName) },
    { "Niloperators", 0, false, kc_phylum_operators, 0, 0, 0, sizeof(kc_tag_operators) },
    { "Consoperators", 2, false, kc_phylum_operators, kc_subphyla_Consoperators, 0, 0, sizeof(kc_tag_operators) },
    { "Nilphyla", 0, false, kc_phylum_phyla, 0, 0, 0, sizeof(kc_tag_phyla) },
    { "Consphyla", 2, false, kc_phylum_phyla, kc_subphyla_Consphyla, 0, 0, sizeof(kc_tag_phyla) },
    { "Nilvariables", 0, false, kc_phylum_variables, 0, 0, 0, sizeof(kc_tag_variables) },
    { "Consvariables", 2, false, kc_phylum_variables, kc_subphyla_Consvariables, 0, 0, sizeof(kc_tag_variables) },
    { "DVAllowed", 0, false, kc_phylum_dollarvarstatus, 0, 0, 0, sizeof(kc_tag_dollarvarstatus_DVAllowed) },
    { "DVDisallowed", 0, false, kc_phylum_dollarvarstatus, 0, 0, 0, sizeof(kc_tag_dollarvarstatus_DVDisallowed) },
    { "TwoStorageoption", 2, false, kc_phylum_two_phyla, kc_subphyla_TwoStorageoption, 0, 0, sizeof(kc_tag_two_phyla_TwoStorageoption) },
    { "TwoProductionblock", 2, false, kc_phylum_two_phyla, kc_subphyla_TwoProductionblock, 0, 0, sizeof(kc_tag_two_phyla_TwoProductionblock) },
    { "TwoCcode_option", 2, false, kc_phylum_two_phyla, kc_subphyla_TwoCcode_option, 0, 0, sizeof(kc_tag_two_phyla_TwoCcode_option) },
    { "TwoRewriteruleinfo", 2, false, kc_phylum_two_phyla, kc_subphyla_TwoRewriteruleinfo, 0, 0, sizeof(kc_tag_two_phyla_TwoRewriteruleinfo) },
    { "TwoWithcaseinfo", 2, false, kc_phylum_two_phyla, kc_subphyla_TwoWithcaseinfo, 0, 0, sizeof(kc_tag_two_phyla_TwoWithcaseinfo) },
    { "TwoUnparsedeclinfo", 2, false, kc_phylum_two_phyla, kc_subphyla_TwoUnparsedeclinfo, 0, 0, sizeof(kc_tag_two_phyla_TwoUnparsedeclinfo) },
    { "TwoPatternrepresentation", 2, false, kc_phylum_two_phyla, kc_subphyla_TwoPatternrepresentation, 0, 0, sizeof(kc_tag_two_phyla_TwoPatternrepresentation) },
    { "TwoElem_patternrepresentation", 2, false, kc_phylum_two_phyla, kc_subphyla_TwoElem_patternrepresentation, 0, 0, sizeof(kc_tag_two_phyla_TwoElem_patternrepresentation) },
    { "TwoPaths", 2, false, kc_phylum_two_phyla, kc_subphyla_TwoPaths, 0, 0, sizeof(kc_tag_two_phyla_TwoPaths) },
    { "TwoPath", 2, false, kc_phylum_two_phyla, kc_subphyla_TwoPath, 0, 0, sizeof(kc_tag_two_phyla_TwoPath) },
    { "Equal", 0, false, kc_phylum_tribool, 0, 0, 0, sizeof(kc_tag_tribool_Equal) },
    { "Smaller", 0, false, kc_phylum_tribool, 0, 0, 0, sizeof(kc_tag_tribool_Smaller) },
    { "Bigger", 0, false, kc_phylum_tribool, 0, 0, 0, sizeof(kc_tag_tribool_Bigger) },
    { "Nilpatternrepresentations", 0, false, kc_phylum_patternrepresentations, 0, 0, 0, sizeof(kc_tag_patternrepresentations) },
    { "Conspatternrepresentations", 2, false, kc_phylum_patternrepresentations, kc_subphyla_Conspatternrepresentations, 0, 0, sizeof(kc_tag_patternrepresentations) },
    { "Nilpatternrepresentation", 0, false, kc_phylum_patternrepresentation, 0, 0, 0, sizeof(kc_tag_patternrepresentation) },
    { "Conspatternrepresentation", 2, false, kc_phylum_patternrepresentation, kc_subphyla_Conspatternrepresentation, 0, 0, sizeof(kc_tag_patternrepresentation) },
    { "PRBinding", 2, false, kc_phylum_elem_patternrepresentation, kc_subphyla_PRBinding, 0, 0, sizeof(kc_tag_elem_patternrepresentation_PRBinding) },
    { "PRVarPredicate", 3, false, kc_phylum_elem_patternrepresentation, kc_subphyla_PRVarPredicate, 0, 0, sizeof(kc_tag_elem_patternrepresentation_PRVarPredicate) },
    { "PROperPredicate", 2, false, kc_phylum_elem_patternrepresentation, kc_subphyla_PROperPredicate, 0, 0, sizeof(kc_tag_elem_patternrepresentation_PROperPredicate) },
    { "PRUserPredicate", 1, false, kc_phylum_elem_patternrepresentation, kc_subphyla_PRUserPredicate, 0, 0, sizeof(kc_tag_elem_patternrepresentation_PRUserPredicate) },
    { "PRNonLeafBinding", 3, false, kc_phylum_elem_patternrepresentation, kc_subphyla_PRNonLeafBinding, 0, 0, sizeof(kc_tag_elem_patternrepresentation_PRNonLeafBinding) },
    { "PRWildcard", 1, false, kc_phylum_elem_patternrepresentation, kc_subphyla_PRWildcard, 0, 0, sizeof(kc_tag_elem_patternrepresentation_PRWildcard) },
    { "PRDefault", 0, false, kc_phylum_elem_patternrepresentation, 0, 0, 0, sizeof(kc_tag_elem_patternrepresentation_PRDefault) },
    { "PRStringLiteral", 2, false, kc_phylum_elem_patternrepresentation, kc_subphyla_PRStringLiteral, 0, 0, sizeof(kc_tag_elem_patternrepresentation_PRStringLiteral) },
    { "PRIntLiteral", 2, false, kc_phylum_elem_patternrepresentation, kc_subphyla_PRIntLiteral, 0, 0, sizeof(kc_tag_elem_patternrepresentation_PRIntLiteral) },
    { "Nilpath", 0, false, kc_phylum_path, 0, 0, 0, sizeof(kc_tag_path) },
    { "Conspath", 2, false, kc_phylum_path, kc_subphyla_Conspath, 0, 0, sizeof(kc_tag_path) },
    { "Nilpaths", 0, false, kc_phylum_paths, 0, 0, 0, sizeof(kc_tag_paths) },
    { "Conspaths", 2, false, kc_phylum_paths, kc_subphyla_Conspaths, 0, 0, sizeof(kc_tag_paths) },
    { "Nilargsnumbers", 0, false, kc_phylum_argsnumbers, 0, 0, 0, sizeof(kc_tag_argsnumbers) },
    { "Consargsnumbers", 2, false, kc_phylum_argsnumbers, kc_subphyla_Consargsnumbers, 0, 0, sizeof(kc_tag_argsnumbers) },
    { "Nilrewriterulesinfo", 0, false, kc_phylum_rewriterulesinfo, 0, 0, 0, sizeof(kc_tag_rewriterulesinfo) },
    { "Consrewriterulesinfo", 2, false, kc_phylum_rewriterulesinfo, kc_subphyla_Consrewriterulesinfo, 0, 0, sizeof(kc_tag_rewriterulesinfo) },
    { "Rewriteruleinfo", 3, false, kc_phylum_rewriteruleinfo, kc_subphyla_Rewriteruleinfo, 0, 0, sizeof(kc_tag_rewriteruleinfo_Rewriteruleinfo) },
    { "Nilwithcasesinfo", 0, false, kc_phylum_withcasesinfo, 0, 0, 0, sizeof(kc_tag_withcasesinfo) },
    { "Conswithcasesinfo", 2, false, kc_phylum_withcasesinfo, kc_subphyla_Conswithcasesinfo, 0, 0, sizeof(kc_tag_withcasesinfo) },
    { "Withcaseinfo", 3, false, kc_phylum_withcaseinfo, kc_subphyla_Withcaseinfo, 0, 0, sizeof(kc_tag_withcaseinfo_Withcaseinfo) },
    { "Nilrewriteviewsinfo", 0, false, kc_phylum_rewriteviewsinfo, 0, 0, 0, sizeof(kc_tag_rewriteviewsinfo) },
    { "Consrewriteviewsinfo", 2, false, kc_phylum_rewriteviewsinfo, kc_subphyla_Consrewriteviewsinfo, 0, 0, sizeof(kc_tag_rewriteviewsinfo) },
    { "Rewriteviewinfo", 2, false, kc_phylum_rewriteviewinfo, kc_subphyla_Rewriteviewinfo, 0, 0, sizeof(kc_tag_rewriteviewinfo_Rewriteviewinfo) },
    { "Nilunparseviewsinfo", 0, false, kc_phylum_unparseviewsinfo, 0, 0, 0, sizeof(kc_tag_unparseviewsinfo) },
    { "Consunparseviewsinfo", 2, false, kc_phylum_unparseviewsinfo, kc_subphyla_Consunparseviewsinfo, 0, 0, sizeof(kc_tag_unparseviewsinfo) },
    { "Unparseviewinfo", 2, false, kc_phylum_unparseviewinfo, kc_subphyla_Unparseviewinfo, 0, 0, sizeof(kc_tag_unparseviewinfo_Unparseviewinfo) },
    { "Nilunparsedeclsinfo", 0, false, kc_phylum_unparsedeclsinfo, 0, 0, 0, sizeof(kc_tag_unparsedeclsinfo) },
    { "Consunparsedeclsinfo", 2, false, kc_phylum_unparsedeclsinfo, kc_subphyla_Consunparsedeclsinfo, 0, 0, sizeof(kc_tag_unparsedeclsinfo) },
    { "Unparsedeclinfo", 3, false, kc_phylum_unparsedeclinfo, kc_subphyla_Unparsedeclinfo, 0, 0, sizeof(kc_tag_unparsedeclinfo_Unparsedeclinfo) },
    { "AcDeclaration", 2, false, kc_phylum_ac_declaration, kc_subphyla_AcDeclaration, 0, 0, sizeof(kc_tag_ac_declaration_AcDeclaration) },
    { "Nilac_declaration_list", 0, false, kc_phylum_ac_declaration_list, 0, 0, 0, sizeof(kc_tag_ac_declaration_list) },
    { "Consac_declaration_list", 2, false, kc_phylum_ac_declaration_list, kc_subphyla_Consac_declaration_list, 0, 0, sizeof(kc_tag_ac_declaration_list) },
    { "Nilac_declaration_specifiers", 0, false, kc_phylum_ac_declaration_specifiers, 0, 0, 0, sizeof(kc_tag_ac_declaration_specifiers) },
    { "Consac_declaration_specifiers", 2, false, kc_phylum_ac_declaration_specifiers, kc_subphyla_Consac_declaration_specifiers, 0, 0, sizeof(kc_tag_ac_declaration_specifiers) },
    { "AcDeclSpecStorageSpec", 1, false, kc_phylum_ac_declaration_specifier, kc_subphyla_AcDeclSpecStorageSpec, 0, 0, sizeof(kc_tag_ac_declaration_specifier_AcDeclSpecStorageSpec) },
    { "AcDeclSpecTypeSpec", 1, false, kc_phylum_ac_declaration_specifier, kc_subphyla_AcDeclSpecTypeSpec, 0, 0, sizeof(kc_tag_ac_declaration_specifier_AcDeclSpecTypeSpec) },
    { "AcDeclSpecTypeQual", 1, false, kc_phylum_ac_declaration_specifier, kc_subphyla_AcDeclSpecTypeQual, 0, 0, sizeof(kc_tag_ac_declaration_specifier_AcDeclSpecTypeQual) },
    { "AcAuto", 0, false, kc_phylum_ac_storage_class_specifier, 0, 0, 0, sizeof(kc_tag_ac_storage_class_specifier_AcAuto) },
    { "AcRegister", 0, false, kc_phylum_ac_storage_class_specifier, 0, 0, 0, sizeof(kc_tag_ac_storage_class_specifier_AcRegister) },
    { "AcStatic", 0, false, kc_phylum_ac_storage_class_specifier, 0, 0, 0, sizeof(kc_tag_ac_storage_class_specifier_AcStatic) },
    { "AcExtern", 0, false, kc_phylum_ac_storage_class_specifier, 0, 0, 0, sizeof(kc_tag_ac_storage_class_specifier_AcExtern) },
    { "AcTypedef", 0, false, kc_phylum_ac_storage_class_specifier, 0, 0, 0, sizeof(kc_tag_ac_storage_class_specifier_AcTypedef) },
    { "AcVirtual", 0, false, kc_phylum_ac_storage_class_specifier, 0, 0, 0, sizeof(kc_tag_ac_storage_class_specifier_AcVirtual) },
    { "AcTypeSpec", 1, false, kc_phylum_ac_type_specifier, kc_subphyla_AcTypeSpec, 0, 0, sizeof(kc_tag_ac_type_specifier_AcTypeSpec) },
    { "AcConst", 0, false, kc_phylum_ac_type_qualifier, 0, 0, 0, sizeof(kc_tag_ac_type_qualifier_AcConst) },
    { "AcVolatile", 0, false, kc_phylum_ac_type_qualifier, 0, 0, 0, sizeof(kc_tag_ac_type_qualifier_AcVolatile) },
    { "AcUnsigned", 0, false, kc_phylum_ac_type_qualifier, 0, 0, 0, sizeof(kc_tag_ac_type_qualifier_AcUnsigned) },
    { "AcNoQualifier", 0, false, kc_phylum_ac_type_qualifier, 0, 0, 0, sizeof(kc_tag_ac_type_qualifier_AcNoQualifier) },
    { "Nilac_init_declarator_list", 0, false, kc_phylum_ac_init_declarator_list, 0, 0, 0, sizeof(kc_tag_ac_init_declarator_list) },
    { "Consac_init_declarator_list", 2, false, kc_phylum_ac_init_declarator_list, kc_subphyla_Consac_init_declarator_list, 0, 0, sizeof(kc_tag_ac_init_declarator_list) },
    { "AcInitDecl", 1, false, kc_phylum_ac_init_declarator, kc_subphyla_AcInitDecl, 0, 0, sizeof(kc_tag_ac_init_declarator_AcInitDecl) },
    { "AcDeclarator", 3, false, kc_phylum_ac_declarator, kc_subphyla_AcDeclarator, 0, 0, sizeof(kc_tag_ac_declarator_AcDeclarator) },
    { "AcDirectDeclId", 1, false, kc_phylum_ac_direct_declarator, kc_subphyla_AcDirectDeclId, 0, 0, sizeof(kc_tag_ac_direct_declarator_AcDirectDeclId) },
    { "AcDirectDeclPack", 1, false, kc_phylum_ac_direct_declarator, kc_subphyla_AcDirectDeclPack, 0, 0, sizeof(kc_tag_ac_direct_declarator_AcDirectDeclPack) },
    { "AcDirectDeclArray", 2, false, kc_phylum_ac_direct_declarator, kc_subphyla_AcDirectDeclArray, 0, 0, sizeof(kc_tag_ac_direct_declarator_AcDirectDeclArray) },
    { "AcDirectDeclProto", 2, false, kc_phylum_ac_direct_declarator, kc_subphyla_AcDirectDeclProto, 0, 0, sizeof(kc_tag_ac_direct_declarator_AcDirectDeclProto) },
    { "AcQualifiedDeclProto", 4, false, kc_phylum_ac_direct_declarator, kc_subphyla_AcQualifiedDeclProto, 0, 0, sizeof(kc_tag_ac_direct_declarator_AcQualifiedDeclProto) },
    { "AcMemberDecl", 3, false, kc_phylum_ac_direct_declarator, kc_subphyla_AcMemberDecl, 0, 0, sizeof(kc_tag_ac_direct_declarator_AcMemberDecl) },
    { "AcOperatorDeclId", 1, false, kc_phylum_ac_direct_declarator, kc_subphyla_AcOperatorDeclId, 0, 0, sizeof(kc_tag_ac_direct_declarator_AcOperatorDeclId) },
    { "Nopointer", 0, false, kc_phylum_ac_pointer_option, 0, 0, 0, sizeof(kc_tag_ac_pointer_option_Nopointer) },
    { "Yespointer", 1, false, kc_phylum_ac_pointer_option, kc_subphyla_Yespointer, 0, 0, sizeof(kc_tag_ac_pointer_option_Yespointer) },
    { "AcPointerNil", 1, false, kc_phylum_ac_pointer, kc_subphyla_AcPointerNil, 0, 0, sizeof(kc_tag_ac_pointer_AcPointerNil) },
    { "AcPointerCons", 2, false, kc_phylum_ac_pointer, kc_subphyla_AcPointerCons, 0, 0, sizeof(kc_tag_ac_pointer_AcPointerCons) },
    { "AcNoRef", 0, false, kc_phylum_ac_ref_option, 0, 0, 0, sizeof(kc_tag_ac_ref_option_AcNoRef) },
    { "AcRef", 0, false, kc_phylum_ac_ref_option, 0, 0, 0, sizeof(kc_tag_ac_ref_option_AcRef) },
    { "AcOperatorName", 1, false, kc_phylum_ac_operator_name, kc_subphyla_AcOperatorName, 0, 0, sizeof(kc_tag_ac_operator_name_AcOperatorName) },
    { "Nilac_class_qualifier_help_list", 0, false, kc_phylum_ac_class_qualifier_help_list, 0, 0, 0, sizeof(kc_tag_ac_class_qualifier_help_list) },
    { "Consac_class_qualifier_help_list", 2, false, kc_phylum_ac_class_qualifier_help_list, kc_subphyla_Consac_class_qualifier_help_list, 0, 0, sizeof(kc_tag_ac_class_qualifier_help_list) },
    { "Nilac_class_qualifier_list", 0, false, kc_phylum_ac_class_qualifier_list, 0, 0, 0, sizeof(kc_tag_ac_class_qualifier_list) },
    { "Consac_class_qualifier_list", 2, false, kc_phylum_ac_class_qualifier_list, kc_subphyla_Consac_class_qualifier_list, 0, 0, sizeof(kc_tag_ac_class_qualifier_list) },
    { "Nilac_type_qualifier_list", 0, false, kc_phylum_ac_type_qualifier_list, 0, 0, 0, sizeof(kc_tag_ac_type_qualifier_list) },
    { "Consac_type_qualifier_list", 2, false, kc_phylum_ac_type_qualifier_list, kc_subphyla_Consac_type_qualifier_list, 0, 0, sizeof(kc_tag_ac_type_qualifier_list) },
    { "AcParList", 1, false, kc_phylum_ac_parameter_type_list, kc_subphyla_AcParList, 0, 0, sizeof(kc_tag_ac_parameter_type_list_AcParList) },
    { "AcParList3Dot", 1, false, kc_phylum_ac_parameter_type_list, kc_subphyla_AcParList3Dot, 0, 0, sizeof(kc_tag_ac_parameter_type_list_AcParList3Dot) },
    { "Nilac_parameter_list", 0, false, kc_phylum_ac_parameter_list, 0, 0, 0, sizeof(kc_tag_ac_parameter_list) },
    { "Consac_parameter_list", 2, false, kc_phylum_ac_parameter_list, kc_subphyla_Consac_parameter_list, 0, 0, sizeof(kc_tag_ac_parameter_list) },
    { "AcParDeclDecl", 3, false, kc_phylum_ac_parameter_declaration, kc_subphyla_AcParDeclDecl, 0, 0, sizeof(kc_tag_ac_parameter_declaration_AcParDeclDecl) },
    { "AcParDeclAbsdecl", 3, false, kc_phylum_ac_parameter_declaration, kc_subphyla_AcParDeclAbsdecl, 0, 0, sizeof(kc_tag_ac_parameter_declaration_AcParDeclAbsdecl) },
    { "Nilac_identifier_list", 0, false, kc_phylum_ac_identifier_list, 0, 0, 0, sizeof(kc_tag_ac_identifier_list) },
    { "Consac_identifier_list", 2, false, kc_phylum_ac_identifier_list, kc_subphyla_Consac_identifier_list, 0, 0, sizeof(kc_tag_ac_identifier_list) },
    { "AcAbsdeclPointer", 1, false, kc_phylum_ac_abstract_declarator, kc_subphyla_AcAbsdeclPointer, 0, 0, sizeof(kc_tag_ac_abstract_declarator_AcAbsdeclPointer) },
    { "AcAbsdeclDirdecl", 2, false, kc_phylum_ac_abstract_declarator, kc_subphyla_AcAbsdeclDirdecl, 0, 0, sizeof(kc_tag_ac_abstract_declarator_AcAbsdeclDirdecl) },
    { "Noac_direct_abstract_declarator", 0, false, kc_phylum_ac_direct_abstract_declarator_option, 0, 0, 0, sizeof(kc_tag_ac_direct_abstract_declarator_option_Noac_direct_abstract_declarator) },
    { "Yesac_direct_abstract_declarator", 1, false, kc_phylum_ac_direct_abstract_declarator_option, kc_subphyla_Yesac_direct_abstract_declarator, 0, 0, sizeof(kc_tag_ac_direct_abstract_declarator_option_Yesac_direct_abstract_declarator) },
    { "AcDirAbsdeclPack", 1, false, kc_phylum_ac_direct_abstract_declarator, kc_subphyla_AcDirAbsdeclPack, 0, 0, sizeof(kc_tag_ac_direct_abstract_declarator_AcDirAbsdeclPack) },
    { "AcDirAbsdeclArray", 2, false, kc_phylum_ac_direct_abstract_declarator, kc_subphyla_AcDirAbsdeclArray, 0, 0, sizeof(kc_tag_ac_direct_abstract_declarator_AcDirAbsdeclArray) },
    { "AcDirAbsdeclFn", 2, false, kc_phylum_ac_direct_abstract_declarator, kc_subphyla_AcDirAbsdeclFn, 0, 0, sizeof(kc_tag_ac_direct_abstract_declarator_AcDirAbsdeclFn) },
    { "Yesac_constant_expression", 1, false, kc_phylum_ac_constant_expression_option, kc_subphyla_Yesac_constant_expression, 0, 0, sizeof(kc_tag_ac_constant_expression_option_Yesac_constant_expression) },
    { "Noac_constant_expression", 0, false, kc_phylum_ac_constant_expression_option, 0, 0, 0, sizeof(kc_tag_ac_constant_expression_option_Noac_constant_expression) },
    { "AcConstExpr", 1, false, kc_phylum_ac_constant_expression, kc_subphyla_AcConstExpr, 0, 0, sizeof(kc_tag_ac_constant_expression_AcConstExpr) },
    { "Nilac_constant_expression_list", 0, false, kc_phylum_ac_constant_expression_list, 0, 0, 0, sizeof(kc_tag_ac_constant_expression_list) },
    { "Consac_constant_expression_list", 2, false, kc_phylum_ac_constant_expression_list, kc_subphyla_Consac_constant_expression_list, 0, 0, sizeof(kc_tag_ac_constant_expression_list) },
    { "AcNoBaseInit", 0, false, kc_phylum_ac_opt_base_init_list, 0, 0, 0, sizeof(kc_tag_ac_opt_base_init_list_AcNoBaseInit) },
    { "AcYesBaseInit", 1, false, kc_phylum_ac_opt_base_init_list, kc_subphyla_AcYesBaseInit, 0, 0, sizeof(kc_tag_ac_opt_base_init_list_AcYesBaseInit) },
    { "Nilac_base_init_list", 0, false, kc_phylum_ac_base_init_list, 0, 0, 0, sizeof(kc_tag_ac_base_init_list) },
    { "Consac_base_init_list", 2, false, kc_phylum_ac_base_init_list, kc_subphyla_Consac_base_init_list, 0, 0, sizeof(kc_tag_ac_base_init_list) },
    { "AcBaseInit", 2, false, kc_phylum_ac_base_init, kc_subphyla_AcBaseInit, 0, 0, sizeof(kc_tag_ac_base_init_AcBaseInit) },
    { "Nilbaseclass_declarations", 0, false, kc_phylum_baseclass_declarations, 0, 0, 0, sizeof(kc_tag_baseclass_declarations) },
    { "Consbaseclass_declarations", 2, false, kc_phylum_baseclass_declarations, kc_subphyla_Consbaseclass_declarations, 0, 0, sizeof(kc_tag_baseclass_declarations) },
    { "BaseClassDecl", 2, false, kc_phylum_baseclass_decl, kc_subphyla_BaseClassDecl, 0, 0, sizeof(kc_tag_baseclass_decl_BaseClassDecl) },
    { "Nilbaseclass_list", 0, false, kc_phylum_baseclass_list, 0, 0, 0, sizeof(kc_tag_baseclass_list) },
    { "Consbaseclass_list", 2, false, kc_phylum_baseclass_list, kc_subphyla_Consbaseclass_list, 0, 0, sizeof(kc_tag_baseclass_list) },
    { "Fatal", 2, false, kc_phylum_error, kc_subphyla_Fatal, 0, 0, sizeof(kc_tag_error_Fatal) },
    { "NonFatal", 2, false, kc_phylum_error, kc_subphyla_NonFatal, 0, 0, sizeof(kc_tag_error_NonFatal) },
    { "Warning", 2, false, kc_phylum_error, kc_subphyla_Warning, 0, 0, sizeof(kc_tag_error_Warning) },
    { "Problem1", 1, false, kc_phylum_problem, kc_subphyla_Problem1, 0, 0, sizeof(kc_tag_problem_Problem1) },
    { "Problem1ID", 2, false, kc_phylum_problem, kc_subphyla_Problem1ID, 0, 0, sizeof(kc_tag_problem_Problem1ID) },
    { "Problem1tID", 2, false, kc_phylum_problem, kc_subphyla_Problem1tID, 0, 0, sizeof(kc_tag_problem_Problem1tID) },
    { "Problem1we", 2, false, kc_phylum_problem, kc_subphyla_Problem1we, 0, 0, sizeof(kc_tag_problem_Problem1we) },
    { "Problem1ID1ID", 4, false, kc_phylum_problem, kc_subphyla_Problem1ID1ID, 0, 0, sizeof(kc_tag_problem_Problem1ID1ID) },
    { "Problem1t1ID", 4, false, kc_phylum_problem, kc_subphyla_Problem1t1ID, 0, 0, sizeof(kc_tag_problem_Problem1t1ID) },
    { "Problem1INT", 2, false, kc_phylum_problem, kc_subphyla_Problem1INT, 0, 0, sizeof(kc_tag_problem_Problem1INT) },
    { "Problem1int1", 3, false, kc_phylum_problem, kc_subphyla_Problem1int1, 0, 0, sizeof(kc_tag_problem_Problem1int1) },
    { "Problem1INT1ID", 4, false, kc_phylum_problem, kc_subphyla_Problem1INT1ID, 0, 0, sizeof(kc_tag_problem_Problem1INT1ID) },
    { "Problem1ID1ID1ID", 6, false, kc_phylum_problem, kc_subphyla_Problem1ID1ID1ID, 0, 0, sizeof(kc_tag_problem_Problem1ID1ID1ID) },
    { "Problem1INT1ID1ID", 6, false, kc_phylum_problem, kc_subphyla_Problem1INT1ID1ID, 0, 0, sizeof(kc_tag_problem_Problem1INT1ID1ID) },
    { "Problem1storageoption1ID", 4, false, kc_phylum_problem, kc_subphyla_Problem1storageoption1ID, 0, 0, sizeof(kc_tag_problem_Problem1storageoption1ID) },
    { "Problem2", 2, false, kc_phylum_problem, kc_subphyla_Problem2, 0, 0, sizeof(kc_tag_problem_Problem2) },
    { "Problem3", 3, false, kc_phylum_problem, kc_subphyla_Problem3, 0, 0, sizeof(kc_tag_problem_Problem3) },
    { "Problem3int1", 5, false, kc_phylum_problem, kc_subphyla_Problem3int1, 0, 0, sizeof(kc_tag_problem_Problem3int1) },
    { "Problem4", 4, false, kc_phylum_problem, kc_subphyla_Problem4, 0, 0, sizeof(kc_tag_problem_Problem4) },
    { "Problem5", 5, false, kc_phylum_problem, kc_subphyla_Problem5, 0, 0, sizeof(kc_tag_problem_Problem5) },
    { "Problem6", 6, false, kc_phylum_problem, kc_subphyla_Problem6, 0, 0, sizeof(kc_tag_problem_Problem6) },
    { "Niladdedphylumdeclarations", 0, false, kc_phylum_addedphylumdeclarations, 0, 0, 0, sizeof(kc_tag_addedphylumdeclarations) },
    { "Consaddedphylumdeclarations", 2, false, kc_phylum_addedphylumdeclarations, kc_subphyla_Consaddedphylumdeclarations, 0, 0, sizeof(kc_tag_addedphylumdeclarations) },
    { "AddedPhylumdeclaration", 1, false, kc_phylum_addedphylumdeclaration, kc_subphyla_AddedPhylumdeclaration, 0, 0, sizeof(kc_tag_addedphylumdeclaration_AddedPhylumdeclaration) },
    { "Nilcountedphylumdeclarations", 0, false, kc_phylum_countedphylumdeclarations, 0, 0, 0, sizeof(kc_tag_countedphylumdeclarations) },
    { "Conscountedphylumdeclarations", 2, false, kc_phylum_countedphylumdeclarations, kc_subphyla_Conscountedphylumdeclarations, 0, 0, sizeof(kc_tag_countedphylumdeclarations) },
    { "CountedPhylumdeclaration", 1, false, kc_phylum_countedphylumdeclaration, kc_subphyla_CountedPhylumdeclaration, 0, 0, sizeof(kc_tag_countedphylumdeclaration_CountedPhylumdeclaration) },
    { "Newlines", 0, false, kc_phylum_charruns, 0, 0, 0, sizeof(kc_tag_charruns_Newlines) },
    { "QuotedNewlines", 0, false, kc_phylum_charruns, 0, 0, 0, sizeof(kc_tag_charruns_QuotedNewlines) },
    { "Stars", 0, false, kc_phylum_charruns, 0, 0, 0, sizeof(kc_tag_charruns_Stars) },
    { "Nilbindingidmarks", 0, false, kc_phylum_bindingidmarks, 0, 0, 0, sizeof(kc_tag_bindingidmarks) },
    { "Consbindingidmarks", 2, false, kc_phylum_bindingidmarks, kc_subphyla_Consbindingidmarks, 0, 0, sizeof(kc_tag_bindingidmarks) },
    { "BindingIdMark", 1, false, kc_phylum_bindingidmark, kc_subphyla_BindingIdMark, 0, 0, sizeof(kc_tag_bindingidmark_BindingIdMark) },
    { "", 0, 0, kc_one_before_first_phylum, 0, 0, 0, 0 } /* last element */
};

static kc_enum_phyla kc_phylumstorageclass_uniq[] = { kc_one_before_first_phylum, kc_phylum_nocasestring, kc_phylum_casestring, kc_phylum_real, kc_phylum_integer, kc_phylum_voidptr, kc_phylum_uniqID, kc_phylum_includefile, kc_phylum_fnfile, kc_phylum_countedphylumdeclaration, kc_phylum_charruns, kc_phylum_bindingidmarks, kc_phylum_bindingidmark, kc_last_phylum };

KC_UNIQ_INFO kc_UniqInfo[] = {
    (KC_UNIQ_INFO)0,
    kc_phylumstorageclass_uniq
};

} // namespace kc
using namespace kc;
/* included stuff */
#include "gutil.h"

//
// The Termprocessor Kimwitu++
//
// Copyright (C) 1991 University of Twente, Dept TIOS.
// Copyright (C) 1998-2001 Humboldt-University of Berlin, Institute of Informatics
// All rights reserved.
//
//

/* end included stuff */


namespace kc {

void
kc_no_default_in_with( const char *kc_func, int kc_line, const char *kc_file )
{
    fflush(stdout);
#ifdef _WINDOWS
    TRACE3( KC_NO_DEFAULT_IN_WITH, kc_func, kc_file, kc_line );
#ifdef _DEBUG
    if (AfxAssertFailedLine(kc_file, kc_line))
#endif
	AfxDebugBreak();
#else
    fprintf( stderr, KC_NO_DEFAULT_IN_WITH, kc_func, kc_file, kc_line );
#ifndef KC_NODEFAULT_NO_ABORT
    abort();
#else
    exit( 1 );
#endif
#endif
}

void
kc_returnless_function( const char *kc_func, int kc_line, const char *kc_file )
{
    fflush(stdout);
#ifdef _WINDOWS
    TRACE3( "Internal Error: function %s does not return a value, at %s:%d", kc_func, kc_file, kc_line );
#ifdef _DEBUG
    if (AfxAssertFailedLine(kc_file, kc_line))
#endif
	AfxDebugBreak();
#else
    fprintf( stderr, "Internal Error: function %s does not return a value, at %s:%d", kc_func, kc_file, kc_line );
#ifndef KC_NODEFAULT_NO_ABORT
    abort();
#else
    exit( 1 );
#endif
#endif
}

void
kc_assertionFailed(const char *kc_fn, int kc_l)
{
    fflush(stdout);
#ifdef _WINDOWS
    TRACE2( "Internal Error: Assertion failed at %s:%d\n", kc_fn, kc_l );
#ifdef _DEBUG
    if (AfxAssertFailedLine(kc_fn, kc_l))
#endif
	AfxDebugBreak();
#else
    fprintf( stderr, "Internal Error: Assertion failed at %s:%d\n", kc_fn, kc_l );
#ifndef KC_ASSERT_NO_ABORT
    abort();
#else
    exit( 1 );
#endif
#endif
}

void
kc_assertionReasonFailed(const char *kc_fn, int kc_l, const char *kc_s)
{
    fflush(stdout);
#ifdef _WINDOWS
    TRACE3( "Internal Error: Assertion failed at file %s:%d: %s\n", kc_fn, kc_l, kc_s );
#ifdef _DEBUG
    if (AfxAssertFailedLine(kc_fn, kc_l))
#endif
	AfxDebugBreak();
#else
    fprintf( stderr, "Internal Error: Assertion failed at file %s:%d: %s\n", kc_fn, kc_l, kc_s );
#ifndef KC_ASSERT_NO_ABORT
    abort();
#else
    exit( 1 );
#endif
#endif
}

void
kc_assertionNonNullFailed(const char *kc_fn, int kc_l, const char *kc_str)
{
    fflush(stdout);
#ifdef _WINDOWS
    TRACE3( "Internal Error: Assertion failed at %s:%d: pointer %s is NULL\n", kc_fn, kc_l, kc_str);
#ifdef _DEBUG
    if (AfxAssertFailedLine(kc_fn, kc_l))
#endif
	AfxDebugBreak();
#else
    fprintf( stderr, "Internal Error: Assertion failed at %s:%d: pointer %s is NULL\n", kc_fn, kc_l, kc_str );
#ifndef KC_ASSERT_NO_ABORT
    abort();
#else
    exit( 1 );
#endif
#endif
}

void
kc_assertionOperatorInPhylumFailed(int kc_op, const char *kc_str1, const char *kc_str2, const char *kc_phy, const char *kc_fn, int kc_l)
{
    fflush(stdout);
#ifdef _WINDOWS
    if ((kc_op <= kc_one_before_first_operator) || (kc_op >= kc_last_operator)) {
	TRACE ("Internal Error: Assertion failed at %s:%d: illegal value for (%s) %s%s: %d not a valid operator\n",
	    kc_fn, kc_l, kc_phy, kc_str1, kc_str2, kc_op );
    } else {
	TRACE( "Internal Error: Assertion failed at %s:%d: illegal value for (%s) %s%s: %s (%d) is a value of %s\n",
	    kc_fn, kc_l, kc_phy, kc_str1, kc_str2, kc_OperatorInfo[kc_op].name, kc_op, kc_PhylumInfo[kc_OperatorInfo[kc_op].phylum].name );
    }
#ifdef _DEBUG
    if (AfxAssertFailedLine(kc_fn, kc_l))
#endif
	AfxDebugBreak();
#else
    if ((kc_op <= kc_one_before_first_operator) || (kc_op >= kc_last_operator)) {
	fprintf( stderr, "Internal Error: Assertion failed at %s:%d: illegal value for (%s) %s%s: %d not a valid operator\n",
	    kc_fn, kc_l, kc_phy, kc_str1, kc_str2, kc_op );
    } else {
	fprintf( stderr, "Internal Error: Assertion failed at %s:%d: illegal value for (%s) %s%s: %s (%d) is a value of %s\n",
	    kc_fn, kc_l, kc_phy, kc_str1, kc_str2, kc_OperatorInfo[kc_op].name, kc_op, kc_PhylumInfo[kc_OperatorInfo[kc_op].phylum].name );
    }
#ifndef KC_ASSERT_NO_ABORT
    abort();
#else
    exit( 1 );
#endif
#endif
}

void kc_invalid_operator( const char *kc_func_prefix, kc_enum_phyla kc_phy, int kc_line, const char *kc_file, kc_enum_operators kc_oper )
{
    fflush(stdout);
#ifdef _WINDOWS
    TRACE( "Internal Error: invalid operator code in %s%s at %s:%d: %s\n", kc_func_prefix, kc_phylumname_or_error( kc_phy ), kc_file, kc_line, kc_operatorname_or_error( kc_oper ));
#ifdef _DEBUG
    if (AfxAssertFailedLine(kc_file, kc_line))
#endif
	AfxDebugBreak();
#else
    fprintf( stderr, "Internal Error: invalid operator code in %s%s at %s:%d: %s\n", kc_func_prefix, kc_phylumname_or_error( kc_phy ), kc_file, kc_line, kc_operatorname_or_error( kc_oper ));
#ifndef KC_INVALID_OPERATOR_NO_ABORT
    abort();
#else
    exit( 1 );
#endif
#endif
}
const kc_enum_phyla kc_tag_nocasestring::phylum_sel_ = kc_phylum_nocasestring;
const kc_enum_phyla kc_tag_casestring::phylum_sel_ = kc_phylum_casestring;
const kc_enum_phyla kc_tag_real::phylum_sel_ = kc_phylum_real;
kc_tag_real__Real::kc_tag_real__Real(REAL _value)
    : value(_value) { }
const kc_enum_phyla kc_tag_integer::phylum_sel_ = kc_phylum_integer;
kc_tag_integer__Int::kc_tag_integer__Int(INTEGER _value)
    : value(_value) { }
const kc_enum_phyla kc_tag_voidptr::phylum_sel_ = kc_phylum_voidptr;
kc_tag_voidptr__VoidPtr::kc_tag_voidptr__VoidPtr(kc_voidptr_t _pointer)
    : pointer(_pointer) { }
const kc_enum_phyla kc_tag_uniqID::phylum_sel_ = kc_phylum_uniqID;
kc_tag_uniqID_Str::kc_tag_uniqID_Str(casestring _casestring_1)
    : casestring_1(_casestring_1) { }
const kc_enum_phyla kc_tag_ID::phylum_sel_ = kc_phylum_ID;
kc_tag_ID_Id::kc_tag_ID_Id(uniqID _uniqID_1)
    : uniqID_1(_uniqID_1) { }
const kc_enum_phyla kc_tag_INT::phylum_sel_ = kc_phylum_INT;
kc_tag_INT_Int::kc_tag_INT_Int(integer _integer_1)
    : integer_1(_integer_1) { }
const kc_enum_phyla kc_tag_STRING::phylum_sel_ = kc_phylum_STRING;
kc_tag_STRING_String::kc_tag_STRING_String(casestring _casestring_1)
    : casestring_1(_casestring_1) { }
const kc_enum_phyla kc_tag_phylumdeclarationsroot::phylum_sel_ = kc_phylum_phylumdeclarationsroot;
kc_tag_phylumdeclarationsroot_PhylumDeclarations::kc_tag_phylumdeclarationsroot_PhylumDeclarations(phylumdeclarations _phylumdeclarations_1)
    : phylumdeclarations_1(_phylumdeclarations_1) { }
kc_tag_phylumdeclarations::kc_tag_phylumdeclarations(phylumdeclaration p1 , phylumdeclarations p2)
    : phylumdeclaration_1(p1), phylumdeclarations_1(p2) { }
kc_tag_phylumnames::kc_tag_phylumnames(ID p1 , phylumnames p2)
    : ID_1(p1), phylumnames_1(p2) { }
const kc_enum_phyla kc_tag_phylumdeclaration::phylum_sel_ = kc_phylum_phylumdeclaration;
kc_tag_phylumdeclaration_PhylumDeclaration::kc_tag_phylumdeclaration_PhylumDeclaration(ID _ID_1, storageoption _storageoption_1, productionblock _productionblock_1, Ccode_option _Ccode_option_1)
    : ID_1(_ID_1), storageoption_1(_storageoption_1), productionblock_1(_productionblock_1), Ccode_option_1(_Ccode_option_1) { }
const kc_enum_phyla kc_tag_storageoption::phylum_sel_ = kc_phylum_storageoption;
kc_tag_storageoption_PositiveStorageOption::kc_tag_storageoption_PositiveStorageOption(ID _ID_1)
    : ID_1(_ID_1) { }
kc_tag_storageoption_NegativeStorageOption::kc_tag_storageoption_NegativeStorageOption(ID _ID_1)
    : ID_1(_ID_1) { }
kc_tag_storageoption_NoStorageOption::kc_tag_storageoption_NoStorageOption()
    { }
kc_tag_storageclasses::kc_tag_storageclasses(ID p1 , storageclasses p2)
    : ID_1(p1), storageclasses_1(p2) { }
const kc_enum_phyla kc_tag_productionblock::phylum_sel_ = kc_phylum_productionblock;
kc_tag_productionblock_PredefinedAlternatives::kc_tag_productionblock_PredefinedAlternatives(alternatives _alternatives_1)
    : alternatives_1(_alternatives_1) { }
kc_tag_productionblock_NonlistAlternatives::kc_tag_productionblock_NonlistAlternatives(alternatives _alternatives_1)
    : alternatives_1(_alternatives_1) { }
kc_tag_productionblock_ListAlternatives::kc_tag_productionblock_ListAlternatives(alternatives _alternatives_1, ID _ID_1)
    : alternatives_1(_alternatives_1), ID_1(_ID_1) { }
kc_tag_productionblock_Emptyproductionblock::kc_tag_productionblock_Emptyproductionblock()
    { }
kc_tag_alternatives::kc_tag_alternatives(alternative p1 , alternatives p2)
    : alternative_1(p1), alternatives_1(p2) { }
const kc_enum_phyla kc_tag_alternative::phylum_sel_ = kc_phylum_alternative;
kc_tag_alternative_Alternative::kc_tag_alternative_Alternative(ID _ID_1, arguments _arguments_1)
    : ID_1(_ID_1), arguments_1(_arguments_1) { }
kc_tag_arguments::kc_tag_arguments(ID p1 , arguments p2)
    : ID_1(p1), arguments_1(p2) { }
const kc_enum_phyla kc_tag_argument::phylum_sel_ = kc_phylum_argument;
kc_tag_argument_Argument::kc_tag_argument_Argument(ID _ID_1, integer _integer_1)
    : ID_1(_ID_1), integer_1(_integer_1) { }
const kc_enum_phyla kc_tag_Ccode_option::phylum_sel_ = kc_phylum_Ccode_option;
kc_tag_Ccode_option_CcodeOption::kc_tag_Ccode_option_CcodeOption(attributes _attributes_1, Ctexts _Ctexts_1)
    : attributes_1(_attributes_1), Ctexts_1(_Ctexts_1) { }
kc_tag_attributes::kc_tag_attributes(attribute p1 , attributes p2)
    : attribute_1(p1), attributes_1(p2) { }
const kc_enum_phyla kc_tag_attribute::phylum_sel_ = kc_phylum_attribute;
kc_tag_attribute_Attribute::kc_tag_attribute_Attribute(ID _ID_1, ID _ID_2, attribute_initialisation_option _attribute_initialisation_option_1)
    : ID_1(_ID_1), ID_2(_ID_2), attribute_initialisation_option_1(_attribute_initialisation_option_1) { }
const kc_enum_phyla kc_tag_attribute_initialisation_option::phylum_sel_ = kc_phylum_attribute_initialisation_option;
kc_tag_attribute_initialisation_option_Yesattribute_initialisation::kc_tag_attribute_initialisation_option_Yesattribute_initialisation(Cexpression _Cexpression_1)
    : Cexpression_1(_Cexpression_1) { }
kc_tag_attribute_initialisation_option_Noattribute_initialisation::kc_tag_attribute_initialisation_option_Noattribute_initialisation()
    { }
kc_tag_Cexpression::kc_tag_Cexpression(Cexpression_elem p1 , Cexpression p2)
    : Cexpression_elem_1(p1), Cexpression_1(p2) { }
const kc_enum_phyla kc_tag_Cexpression_elem::phylum_sel_ = kc_phylum_Cexpression_elem;
kc_tag_Cexpression_elem_CExpressionArray::kc_tag_Cexpression_elem_CExpressionArray(Cexpression _Cexpression_1)
    : Cexpression_1(_Cexpression_1) { }
kc_tag_Cexpression_elem_CExpressionPack::kc_tag_Cexpression_elem_CExpressionPack(Cexpression _Cexpression_1)
    : Cexpression_1(_Cexpression_1) { }
kc_tag_Cexpression_elem_CExpressionSQ::kc_tag_Cexpression_elem_CExpressionSQ(CexpressionSQ _CexpressionSQ_1)
    : CexpressionSQ_1(_CexpressionSQ_1) { }
kc_tag_Cexpression_elem_CExpressionDQ::kc_tag_Cexpression_elem_CExpressionDQ(CexpressionDQ _CexpressionDQ_1)
    : CexpressionDQ_1(_CexpressionDQ_1) { }
kc_tag_Cexpression_elem_CExpressionNl::kc_tag_Cexpression_elem_CExpressionNl(integer _integer_1)
    : integer_1(_integer_1) { }
kc_tag_Cexpression_elem_CExpressionDollarvar::kc_tag_Cexpression_elem_CExpressionDollarvar(INT _INT_1)
    : INT_1(_INT_1) { }
kc_tag_Cexpression_elem_CExpressionPart::kc_tag_Cexpression_elem_CExpressionPart(casestring _casestring_1)
    : casestring_1(_casestring_1) { }
kc_tag_CexpressionDQ::kc_tag_CexpressionDQ(CexpressionDQ_elem p1 , CexpressionDQ p2)
    : CexpressionDQ_elem_1(p1), CexpressionDQ_1(p2) { }
const kc_enum_phyla kc_tag_CexpressionDQ_elem::phylum_sel_ = kc_phylum_CexpressionDQ_elem;
kc_tag_CexpressionDQ_elem_CExpressionDQNl::kc_tag_CexpressionDQ_elem_CExpressionDQNl(integer _integer_1)
    : integer_1(_integer_1) { }
kc_tag_CexpressionDQ_elem_CExpressionDQPart::kc_tag_CexpressionDQ_elem_CExpressionDQPart(casestring _casestring_1)
    : casestring_1(_casestring_1) { }
kc_tag_CexpressionSQ::kc_tag_CexpressionSQ(CexpressionSQ_elem p1 , CexpressionSQ p2)
    : CexpressionSQ_elem_1(p1), CexpressionSQ_1(p2) { }
const kc_enum_phyla kc_tag_CexpressionSQ_elem::phylum_sel_ = kc_phylum_CexpressionSQ_elem;
kc_tag_CexpressionSQ_elem_CExpressionSQNl::kc_tag_CexpressionSQ_elem_CExpressionSQNl(integer _integer_1)
    : integer_1(_integer_1) { }
kc_tag_CexpressionSQ_elem_CExpressionSQPart::kc_tag_CexpressionSQ_elem_CExpressionSQPart(casestring _casestring_1)
    : casestring_1(_casestring_1) { }
kc_tag_idCexpressions::kc_tag_idCexpressions(idCexpression p1 , idCexpressions p2)
    : idCexpression_1(p1), idCexpressions_1(p2) { }
const kc_enum_phyla kc_tag_idCexpression::phylum_sel_ = kc_phylum_idCexpression;
kc_tag_idCexpression_IdCexpression::kc_tag_idCexpression_IdCexpression(ID _ID_1, Cexpression _Cexpression_1)
    : ID_1(_ID_1), Cexpression_1(_Cexpression_1) { }
kc_tag_Ctexts::kc_tag_Ctexts(Ctext p1 , Ctexts p2)
    : Ctext_1(p1), Ctexts_1(p2) { }
kc_tag_includefiles::kc_tag_includefiles(includefile p1 , includefiles p2)
    : includefile_1(p1), includefiles_1(p2) { }
const kc_enum_phyla kc_tag_includefile::phylum_sel_ = kc_phylum_includefile;
kc_tag_includefile_IncludeFile::kc_tag_includefile_IncludeFile(casestring _casestring_1)
    : casestring_1(_casestring_1) { }
kc_tag_includedeclarations::kc_tag_includedeclarations(includedeclaration p1 , includedeclarations p2)
    : includedeclaration_1(p1), includedeclarations_1(p2) { }
const kc_enum_phyla kc_tag_includedeclaration::phylum_sel_ = kc_phylum_includedeclaration;
kc_tag_includedeclaration_IncludeDeclaration::kc_tag_includedeclaration_IncludeDeclaration(casestring _casestring_1)
    : casestring_1(_casestring_1) { }
kc_tag_rwdeclarations::kc_tag_rwdeclarations(rwdeclaration p1 , rwdeclarations p2)
    : rwdeclaration_1(p1), rwdeclarations_1(p2) { }
const kc_enum_phyla kc_tag_rwdeclaration::phylum_sel_ = kc_phylum_rwdeclaration;
kc_tag_rwdeclaration_RwDeclaration::kc_tag_rwdeclaration_RwDeclaration(outmostpatterns _outmostpatterns_1, rewriteclauses _rewriteclauses_1)
    : outmostpatterns_1(_outmostpatterns_1), rewriteclauses_1(_rewriteclauses_1) { }
kc_tag_rewriteclauses::kc_tag_rewriteclauses(rewriteclause p1 , rewriteclauses p2)
    : rewriteclause_1(p1), rewriteclauses_1(p2) { }
const kc_enum_phyla kc_tag_rewriteclause::phylum_sel_ = kc_phylum_rewriteclause;
kc_tag_rewriteclause_RewriteClause::kc_tag_rewriteclause_RewriteClause(viewnames _viewnames_1, term _term_1)
    : viewnames_1(_viewnames_1), term_1(_term_1) { }
kc_tag_patternchains::kc_tag_patternchains(patternchain p1 , patternchains p2)
    : patternchain_1(p1), patternchains_1(p2) { }
kc_tag_patternchain::kc_tag_patternchain(patternchainitem p1 , patternchain p2)
    : patternchainitem_1(p1), patternchain_1(p2) { }
kc_tag_outmostpatterns::kc_tag_outmostpatterns(outmostpattern p1 , outmostpatterns p2)
    : outmostpattern_1(p1), outmostpatterns_1(p2) { }
const kc_enum_phyla kc_tag_patternchainitem::phylum_sel_ = kc_phylum_patternchainitem;
kc_tag_patternchainitem_PatternchainitemDollarid::kc_tag_patternchainitem_PatternchainitemDollarid(ID _ID_1)
    : ID_1(_ID_1) { }
kc_tag_patternchainitem_PatternchainitemGroup::kc_tag_patternchainitem_PatternchainitemGroup(patternchains _patternchains_1)
    : patternchains_1(_patternchains_1) { }
kc_tag_patternchainitem_PatternchainitemOutmost::kc_tag_patternchainitem_PatternchainitemOutmost(outmostpattern _outmostpattern_1)
    : outmostpattern_1(_outmostpattern_1) { }
const kc_enum_phyla kc_tag_outmostpattern::phylum_sel_ = kc_phylum_outmostpattern;
kc_tag_outmostpattern_OPDefault::kc_tag_outmostpattern_OPDefault(Cexpression _Cexpression_1)
    : Cexpression_1(_Cexpression_1) { }
kc_tag_outmostpattern_OPWildcard::kc_tag_outmostpattern_OPWildcard(Cexpression _Cexpression_1)
    : Cexpression_1(_Cexpression_1) { }
kc_tag_outmostpattern_OPNonLeafVariable::kc_tag_outmostpattern_OPNonLeafVariable(ID _ID_1, outmostpattern _outmostpattern_1)
    : ID_1(_ID_1), outmostpattern_1(_outmostpattern_1) { }
kc_tag_outmostpattern_OPOperator::kc_tag_outmostpattern_OPOperator(ID _ID_1, patterns _patterns_1, Cexpression _Cexpression_1)
    : ID_1(_ID_1), patterns_1(_patterns_1), Cexpression_1(_Cexpression_1) { }
kc_tag_outmostpattern_OPOperatorWildcard::kc_tag_outmostpattern_OPOperatorWildcard(ID _ID_1, Cexpression _Cexpression_1)
    : ID_1(_ID_1), Cexpression_1(_Cexpression_1) { }
const kc_enum_phyla kc_tag_pattern::phylum_sel_ = kc_phylum_pattern;
kc_tag_pattern_PIntLiteral::kc_tag_pattern_PIntLiteral(INT _INT_1)
    : INT_1(_INT_1) { }
kc_tag_pattern_PStringLiteral::kc_tag_pattern_PStringLiteral(CexpressionDQ _CexpressionDQ_1)
    : CexpressionDQ_1(_CexpressionDQ_1) { }
kc_tag_pattern_PWildcard::kc_tag_pattern_PWildcard()
    { }
kc_tag_pattern_PNonLeafVariable::kc_tag_pattern_PNonLeafVariable(ID _ID_1, pattern _pattern_1)
    : ID_1(_ID_1), pattern_1(_pattern_1) { }
kc_tag_pattern_POperator::kc_tag_pattern_POperator(ID _ID_1, patterns _patterns_1)
    : ID_1(_ID_1), patterns_1(_patterns_1) { }
kc_tag_pattern_PVariable::kc_tag_pattern_PVariable(ID _ID_1)
    : ID_1(_ID_1) { }
kc_tag_patterns::kc_tag_patterns(pattern p1 , patterns p2)
    : pattern_1(p1), patterns_1(p2) { }
const kc_enum_phyla kc_tag_term::phylum_sel_ = kc_phylum_term;
kc_tag_term_TIntLiteral::kc_tag_term_TIntLiteral(INT _INT_1)
    : INT_1(_INT_1) { }
kc_tag_term_TStringLiteral::kc_tag_term_TStringLiteral(CexpressionDQ _CexpressionDQ_1)
    : CexpressionDQ_1(_CexpressionDQ_1) { }
kc_tag_term_TCTerm::kc_tag_term_TCTerm(CexpressionSQ _CexpressionSQ_1)
    : CexpressionSQ_1(_CexpressionSQ_1) { }
kc_tag_term_TMethod::kc_tag_term_TMethod(term _term_1, ID _ID_1, terms _terms_1)
    : term_1(_term_1), ID_1(_ID_1), terms_1(_terms_1) { }
kc_tag_term_TOperator::kc_tag_term_TOperator(ID _ID_1, terms _terms_1)
    : ID_1(_ID_1), terms_1(_terms_1) { }
kc_tag_term_TVariable::kc_tag_term_TVariable(ID _ID_1)
    : ID_1(_ID_1) { }
kc_tag_terms::kc_tag_terms(term p1 , terms p2)
    : term_1(p1), terms_1(p2) { }
kc_tag_fnfiles::kc_tag_fnfiles(fnfile p1 , fnfiles p2)
    : fnfile_1(p1), fnfiles_1(p2) { }
const kc_enum_phyla kc_tag_fnfile::phylum_sel_ = kc_phylum_fnfile;
kc_tag_fnfile_FnFile::kc_tag_fnfile_FnFile(casestring _casestring_1)
    : casestring_1(_casestring_1) { }
kc_tag_fndeclarations::kc_tag_fndeclarations(fndeclaration p1 , fndeclarations p2)
    : fndeclaration_1(p1), fndeclarations_1(p2) { }
const kc_enum_phyla kc_tag_fndeclaration::phylum_sel_ = kc_phylum_fndeclaration;
kc_tag_fndeclaration_AcMemberDeclaration::kc_tag_fndeclaration_AcMemberDeclaration(ac_declaration_specifiers _ac_declaration_specifiers_1, ac_declarator _ac_declarator_1, ac_constant_expression_option _ac_constant_expression_option_1, fnclass _fnclass_1)
    : ac_declaration_specifiers_1(_ac_declaration_specifiers_1), ac_declarator_1(_ac_declarator_1), ac_constant_expression_option_1(_ac_constant_expression_option_1), fnclass_1(_fnclass_1) { }
kc_tag_fndeclaration_FnAcDeclaration::kc_tag_fndeclaration_FnAcDeclaration(ac_declaration_specifiers _ac_declaration_specifiers_1, ac_declarator _ac_declarator_1, ac_declaration_list _ac_declaration_list_1, ac_opt_base_init_list _ac_opt_base_init_list_1, Ctext _Ctext_1, ID _ID_1, fnclass _fnclass_1)
    : ac_declaration_specifiers_1(_ac_declaration_specifiers_1), ac_declarator_1(_ac_declarator_1), ac_declaration_list_1(_ac_declaration_list_1), ac_opt_base_init_list_1(_ac_opt_base_init_list_1), Ctext_1(_Ctext_1), ID_1(_ID_1), fnclass_1(_fnclass_1) { }
const kc_enum_phyla kc_tag_fnclass::phylum_sel_ = kc_phylum_fnclass;
kc_tag_fnclass_DestructorFn::kc_tag_fnclass_DestructorFn()
    { }
kc_tag_fnclass_ConstructorFn::kc_tag_fnclass_ConstructorFn()
    { }
kc_tag_fnclass_MemberFn::kc_tag_fnclass_MemberFn()
    { }
kc_tag_fnclass_StaticFn::kc_tag_fnclass_StaticFn(casestring _casestring_1)
    : casestring_1(_casestring_1) { }
kc_tag_fnclass_GlobalFn::kc_tag_fnclass_GlobalFn()
    { }
kc_tag_Ctext::kc_tag_Ctext(Ctext_elem p1 , Ctext p2)
    : Ctext_elem_1(p1), Ctext_1(p2) { }
const kc_enum_phyla kc_tag_Ctext_elem::phylum_sel_ = kc_phylum_Ctext_elem;
kc_tag_Ctext_elem_CTextWithexpression::kc_tag_Ctext_elem_CTextWithexpression(withexpressions _withexpressions_1, withcases _withcases_1, contextinfo _contextinfo_1)
    : withexpressions_1(_withexpressions_1), withcases_1(_withcases_1), contextinfo_1(_contextinfo_1) { }
kc_tag_Ctext_elem_CTextForeachexpression::kc_tag_Ctext_elem_CTextForeachexpression(patternchain _patternchain_1, idCexpressions _idCexpressions_1, withexpressions _withexpressions_1, Ctext _Ctext_1, foreach_after _foreach_after_1)
    : patternchain_1(_patternchain_1), idCexpressions_1(_idCexpressions_1), withexpressions_1(_withexpressions_1), Ctext_1(_Ctext_1), foreach_after_1(_foreach_after_1) { }
kc_tag_Ctext_elem_CTextCbody::kc_tag_Ctext_elem_CTextCbody(Ctext _Ctext_1)
    : Ctext_1(_Ctext_1) { }
kc_tag_Ctext_elem_CTextCexpressionSQ::kc_tag_Ctext_elem_CTextCexpressionSQ(CexpressionSQ _CexpressionSQ_1)
    : CexpressionSQ_1(_CexpressionSQ_1) { }
kc_tag_Ctext_elem_CTextCexpressionDQ::kc_tag_Ctext_elem_CTextCexpressionDQ(CexpressionDQ _CexpressionDQ_1)
    : CexpressionDQ_1(_CexpressionDQ_1) { }
kc_tag_Ctext_elem_CTextNl::kc_tag_Ctext_elem_CTextNl(integer _integer_1)
    : integer_1(_integer_1) { }
kc_tag_Ctext_elem_CTextDollarVar::kc_tag_Ctext_elem_CTextDollarVar(INT _INT_1)
    : INT_1(_INT_1) { }
kc_tag_Ctext_elem_CTextLine::kc_tag_Ctext_elem_CTextLine(casestring _casestring_1)
    : casestring_1(_casestring_1) { }
const kc_enum_phyla kc_tag_foreach_after::phylum_sel_ = kc_phylum_foreach_after;
kc_tag_foreach_after_ForeachAfter::kc_tag_foreach_after_ForeachAfter(patternchain _patternchain_1, idCexpressions _idCexpressions_1, withexpressions _withexpressions_1, Ctext _Ctext_1)
    : patternchain_1(_patternchain_1), idCexpressions_1(_idCexpressions_1), withexpressions_1(_withexpressions_1), Ctext_1(_Ctext_1) { }
kc_tag_foreach_after_NoForeachAfter::kc_tag_foreach_after_NoForeachAfter()
    { }
const kc_enum_phyla kc_tag_contextinfo::phylum_sel_ = kc_phylum_contextinfo;
kc_tag_contextinfo_NotInForeachContext::kc_tag_contextinfo_NotInForeachContext()
    { }
kc_tag_contextinfo_InForeachContext::kc_tag_contextinfo_InForeachContext(patternchain _patternchain_1)
    : patternchain_1(_patternchain_1) { }
kc_tag_withexpressions::kc_tag_withexpressions(withexpression p1 , withexpressions p2)
    : withexpression_1(p1), withexpressions_1(p2) { }
const kc_enum_phyla kc_tag_withexpression::phylum_sel_ = kc_phylum_withexpression;
kc_tag_withexpression_WECexpression::kc_tag_withexpression_WECexpression(Cexpression _Cexpression_1)
    : Cexpression_1(_Cexpression_1) { }
kc_tag_withexpression_WEVariable::kc_tag_withexpression_WEVariable(ID _ID_1)
    : ID_1(_ID_1) { }
kc_tag_withcases::kc_tag_withcases(withcase p1 , withcases p2)
    : withcase_1(p1), withcases_1(p2) { }
const kc_enum_phyla kc_tag_withcase::phylum_sel_ = kc_phylum_withcase;
kc_tag_withcase_Withcase::kc_tag_withcase_Withcase(patternchains _patternchains_1, Ctext _Ctext_1)
    : patternchains_1(_patternchains_1), Ctext_1(_Ctext_1) { }
kc_tag_unparsedeclarations::kc_tag_unparsedeclarations(unparsedeclaration p1 , unparsedeclarations p2)
    : unparsedeclaration_1(p1), unparsedeclarations_1(p2) { }
const kc_enum_phyla kc_tag_unparsedeclaration::phylum_sel_ = kc_phylum_unparsedeclaration;
kc_tag_unparsedeclaration_UnparseDeclaration::kc_tag_unparsedeclaration_UnparseDeclaration(outmostpatterns _outmostpatterns_1, unparseclauses _unparseclauses_1)
    : outmostpatterns_1(_outmostpatterns_1), unparseclauses_1(_unparseclauses_1) { }
kc_tag_unparseclauses::kc_tag_unparseclauses(unparseclause p1 , unparseclauses p2)
    : unparseclause_1(p1), unparseclauses_1(p2) { }
const kc_enum_phyla kc_tag_unparseclause::phylum_sel_ = kc_phylum_unparseclause;
kc_tag_unparseclause_UnparseClause::kc_tag_unparseclause_UnparseClause(viewnames _viewnames_1, unparseitems _unparseitems_1)
    : viewnames_1(_viewnames_1), unparseitems_1(_unparseitems_1) { }
kc_tag_viewnames::kc_tag_viewnames(ID p1 , viewnames p2)
    : ID_1(p1), viewnames_1(p2) { }
kc_tag_unparseitems::kc_tag_unparseitems(unparseitem p1 , unparseitems p2)
    : unparseitem_1(p1), unparseitems_1(p2) { }
const kc_enum_phyla kc_tag_unparseitem::phylum_sel_ = kc_phylum_unparseitem;
kc_tag_unparseitem_UViewVarDecl::kc_tag_unparseitem_UViewVarDecl(ID _ID_1, ID _ID_2, Cexpression _Cexpression_1)
    : ID_1(_ID_1), ID_2(_ID_2), Cexpression_1(_Cexpression_1) { }
kc_tag_unparseitem_UnpBody::kc_tag_unparseitem_UnpBody(languageoption _languageoption_1, unparseitems _unparseitems_1)
    : languageoption_1(_languageoption_1), unparseitems_1(_unparseitems_1) { }
kc_tag_unparseitem_UnpCtext::kc_tag_unparseitem_UnpCtext(languageoption _languageoption_1, Ctext _Ctext_1)
    : languageoption_1(_languageoption_1), Ctext_1(_Ctext_1) { }
kc_tag_unparseitem_UnpSubexpr::kc_tag_unparseitem_UnpSubexpr(languageoption _languageoption_1, unpsubterm _unpsubterm_1, viewnameoption _viewnameoption_1)
    : languageoption_1(_languageoption_1), unpsubterm_1(_unpsubterm_1), viewnameoption_1(_viewnameoption_1) { }
kc_tag_unparseitem_UnpStr::kc_tag_unparseitem_UnpStr(languageoption _languageoption_1, CexpressionDQ _CexpressionDQ_1, viewnameoption _viewnameoption_1)
    : languageoption_1(_languageoption_1), CexpressionDQ_1(_CexpressionDQ_1), viewnameoption_1(_viewnameoption_1) { }
const kc_enum_phyla kc_tag_unpsubterm::phylum_sel_ = kc_phylum_unpsubterm;
kc_tag_unpsubterm_UnpCastedVariable::kc_tag_unpsubterm_UnpCastedVariable(ID _ID_1, ID _ID_2)
    : ID_1(_ID_1), ID_2(_ID_2) { }
kc_tag_unpsubterm_UnpDollarvarAttr::kc_tag_unpsubterm_UnpDollarvarAttr(INT _INT_1, unpattributes _unpattributes_1)
    : INT_1(_INT_1), unpattributes_1(_unpattributes_1) { }
kc_tag_unpsubterm_UnpSubAttr::kc_tag_unpsubterm_UnpSubAttr(ID _ID_1, unpattributes _unpattributes_1)
    : ID_1(_ID_1), unpattributes_1(_unpattributes_1) { }
kc_tag_unpsubterm_UnpDollarvarTerm::kc_tag_unpsubterm_UnpDollarvarTerm(INT _INT_1)
    : INT_1(_INT_1) { }
kc_tag_unpsubterm_UnpSubTerm::kc_tag_unpsubterm_UnpSubTerm(ID _ID_1)
    : ID_1(_ID_1) { }
kc_tag_unpattributes::kc_tag_unpattributes(ID p1 , unpattributes p2)
    : ID_1(p1), unpattributes_1(p2) { }
const kc_enum_phyla kc_tag_viewnameoption::phylum_sel_ = kc_phylum_viewnameoption;
kc_tag_viewnameoption_YesViewname::kc_tag_viewnameoption_YesViewname(ID _ID_1)
    : ID_1(_ID_1) { }
kc_tag_viewnameoption_NoViewname::kc_tag_viewnameoption_NoViewname()
    { }
const kc_enum_phyla kc_tag_languageoption::phylum_sel_ = kc_phylum_languageoption;
kc_tag_languageoption_LanguageList::kc_tag_languageoption_LanguageList(languagenames _languagenames_1)
    : languagenames_1(_languagenames_1) { }
kc_tag_languageoption_NoLanguagename::kc_tag_languageoption_NoLanguagename()
    { }
kc_tag_languagenames::kc_tag_languagenames(ID p1 , languagenames p2)
    : ID_1(p1), languagenames_1(p2) { }
const kc_enum_phyla kc_tag_fileline::phylum_sel_ = kc_phylum_fileline;
kc_tag_fileline_PosNoFileLine::kc_tag_fileline_PosNoFileLine()
    { }
kc_tag_fileline_NoFileLine::kc_tag_fileline_NoFileLine()
    { }
kc_tag_scopetypefilelinestack::kc_tag_scopetypefilelinestack(scopetypefileline p1 , scopetypefilelinestack p2)
    : scopetypefileline_1(p1), scopetypefilelinestack_1(p2) { }
const kc_enum_phyla kc_tag_scopetypefileline::phylum_sel_ = kc_phylum_scopetypefileline;
kc_tag_scopetypefileline_ScopeTypeFileLine::kc_tag_scopetypefileline_ScopeTypeFileLine(integer _integer_1, IDtype _IDtype_1, casestring _casestring_1, integer _integer_2)
    : integer_1(_integer_1), IDtype_1(_IDtype_1), casestring_1(_casestring_1), integer_2(_integer_2) { }
const kc_enum_phyla kc_tag_IDtype::phylum_sel_ = kc_phylum_IDtype;
kc_tag_IDtype_ITLanguageName::kc_tag_IDtype_ITLanguageName(integer _integer_1)
    : integer_1(_integer_1) { }
kc_tag_IDtype_ITPatternVariable::kc_tag_IDtype_ITPatternVariable(ID _ID_1, integer _integer_1)
    : ID_1(_ID_1), integer_1(_integer_1) { }
kc_tag_IDtype_ITUserFunction::kc_tag_IDtype_ITUserFunction(fnclass _fnclass_1)
    : fnclass_1(_fnclass_1) { }
kc_tag_IDtype_ITUserRView::kc_tag_IDtype_ITUserRView()
    { }
kc_tag_IDtype_ITPredefinedRView::kc_tag_IDtype_ITPredefinedRView()
    { }
kc_tag_IDtype_ITUViewVar::kc_tag_IDtype_ITUViewVar()
    { }
kc_tag_IDtype_ITUserUView::kc_tag_IDtype_ITUserUView()
    { }
kc_tag_IDtype_ITPredefinedUView::kc_tag_IDtype_ITPredefinedUView()
    { }
kc_tag_IDtype_ITStorageClass::kc_tag_IDtype_ITStorageClass()
    { }
kc_tag_IDtype_ITPredefinedStorageClass::kc_tag_IDtype_ITPredefinedStorageClass()
    { }
kc_tag_IDtype_ITUserOperator::kc_tag_IDtype_ITUserOperator(alternative _alternative_1, ID _ID_1)
    : alternative_1(_alternative_1), ID_1(_ID_1) { }
kc_tag_IDtype_ITPredefinedOperator::kc_tag_IDtype_ITPredefinedOperator(alternative _alternative_1, ID _ID_1)
    : alternative_1(_alternative_1), ID_1(_ID_1) { }
kc_tag_IDtype_ITUserPhylum::kc_tag_IDtype_ITUserPhylum(phylumdeclaration _phylumdeclaration_1)
    : phylumdeclaration_1(_phylumdeclaration_1) { }
kc_tag_IDtype_ITPredefinedPhylum::kc_tag_IDtype_ITPredefinedPhylum(phylumdeclaration _phylumdeclaration_1)
    : phylumdeclaration_1(_phylumdeclaration_1) { }
kc_tag_IDtype_ITUnknown::kc_tag_IDtype_ITUnknown()
    { }
kc_tag_operators::kc_tag_operators(ID p1 , operators p2)
    : ID_1(p1), operators_1(p2) { }
kc_tag_phyla::kc_tag_phyla(ID p1 , phyla p2)
    : ID_1(p1), phyla_1(p2) { }
kc_tag_variables::kc_tag_variables(ID p1 , variables p2)
    : ID_1(p1), variables_1(p2) { }
const kc_enum_phyla kc_tag_dollarvarstatus::phylum_sel_ = kc_phylum_dollarvarstatus;
kc_tag_dollarvarstatus_DVDisallowed::kc_tag_dollarvarstatus_DVDisallowed()
    { }
kc_tag_dollarvarstatus_DVAllowed::kc_tag_dollarvarstatus_DVAllowed()
    { }
const kc_enum_phyla kc_tag_two_phyla::phylum_sel_ = kc_phylum_two_phyla;
kc_tag_two_phyla_TwoPath::kc_tag_two_phyla_TwoPath(path _path_1, path _path_2)
    : path_1(_path_1), path_2(_path_2) { }
kc_tag_two_phyla_TwoPaths::kc_tag_two_phyla_TwoPaths(paths _paths_1, paths _paths_2)
    : paths_1(_paths_1), paths_2(_paths_2) { }
kc_tag_two_phyla_TwoElem_patternrepresentation::kc_tag_two_phyla_TwoElem_patternrepresentation(elem_patternrepresentation _elem_patternrepresentation_1, elem_patternrepresentation _elem_patternrepresentation_2)
    : elem_patternrepresentation_1(_elem_patternrepresentation_1), elem_patternrepresentation_2(_elem_patternrepresentation_2) { }
kc_tag_two_phyla_TwoPatternrepresentation::kc_tag_two_phyla_TwoPatternrepresentation(patternrepresentation _patternrepresentation_1, patternrepresentation _patternrepresentation_2)
    : patternrepresentation_1(_patternrepresentation_1), patternrepresentation_2(_patternrepresentation_2) { }
kc_tag_two_phyla_TwoUnparsedeclinfo::kc_tag_two_phyla_TwoUnparsedeclinfo(unparsedeclinfo _unparsedeclinfo_1, unparsedeclinfo _unparsedeclinfo_2)
    : unparsedeclinfo_1(_unparsedeclinfo_1), unparsedeclinfo_2(_unparsedeclinfo_2) { }
kc_tag_two_phyla_TwoWithcaseinfo::kc_tag_two_phyla_TwoWithcaseinfo(withcaseinfo _withcaseinfo_1, withcaseinfo _withcaseinfo_2)
    : withcaseinfo_1(_withcaseinfo_1), withcaseinfo_2(_withcaseinfo_2) { }
kc_tag_two_phyla_TwoRewriteruleinfo::kc_tag_two_phyla_TwoRewriteruleinfo(rewriteruleinfo _rewriteruleinfo_1, rewriteruleinfo _rewriteruleinfo_2)
    : rewriteruleinfo_1(_rewriteruleinfo_1), rewriteruleinfo_2(_rewriteruleinfo_2) { }
kc_tag_two_phyla_TwoCcode_option::kc_tag_two_phyla_TwoCcode_option(Ccode_option _Ccode_option_1, Ccode_option _Ccode_option_2)
    : Ccode_option_1(_Ccode_option_1), Ccode_option_2(_Ccode_option_2) { }
kc_tag_two_phyla_TwoProductionblock::kc_tag_two_phyla_TwoProductionblock(productionblock _productionblock_1, productionblock _productionblock_2)
    : productionblock_1(_productionblock_1), productionblock_2(_productionblock_2) { }
kc_tag_two_phyla_TwoStorageoption::kc_tag_two_phyla_TwoStorageoption(storageoption _storageoption_1, storageoption _storageoption_2)
    : storageoption_1(_storageoption_1), storageoption_2(_storageoption_2) { }
const kc_enum_phyla kc_tag_tribool::phylum_sel_ = kc_phylum_tribool;
kc_tag_tribool_Bigger::kc_tag_tribool_Bigger()
    { }
kc_tag_tribool_Smaller::kc_tag_tribool_Smaller()
    { }
kc_tag_tribool_Equal::kc_tag_tribool_Equal()
    { }
kc_tag_patternrepresentations::kc_tag_patternrepresentations(patternrepresentation p1 , patternrepresentations p2)
    : patternrepresentation_1(p1), patternrepresentations_1(p2) { }
kc_tag_patternrepresentation::kc_tag_patternrepresentation(elem_patternrepresentation p1 , patternrepresentation p2)
    : elem_patternrepresentation_1(p1), patternrepresentation_1(p2) { }
const kc_enum_phyla kc_tag_elem_patternrepresentation::phylum_sel_ = kc_phylum_elem_patternrepresentation;
kc_tag_elem_patternrepresentation_PRIntLiteral::kc_tag_elem_patternrepresentation_PRIntLiteral(path _path_1, INT _INT_1)
    : path_1(_path_1), INT_1(_INT_1) { }
kc_tag_elem_patternrepresentation_PRStringLiteral::kc_tag_elem_patternrepresentation_PRStringLiteral(path _path_1, CexpressionDQ _CexpressionDQ_1)
    : path_1(_path_1), CexpressionDQ_1(_CexpressionDQ_1) { }
kc_tag_elem_patternrepresentation_PRDefault::kc_tag_elem_patternrepresentation_PRDefault()
    { }
kc_tag_elem_patternrepresentation_PRWildcard::kc_tag_elem_patternrepresentation_PRWildcard(path _path_1)
    : path_1(_path_1) { }
kc_tag_elem_patternrepresentation_PRNonLeafBinding::kc_tag_elem_patternrepresentation_PRNonLeafBinding(path _path_1, ID _ID_1, patternrepresentation _patternrepresentation_1)
    : path_1(_path_1), ID_1(_ID_1), patternrepresentation_1(_patternrepresentation_1) { }
kc_tag_elem_patternrepresentation_PRUserPredicate::kc_tag_elem_patternrepresentation_PRUserPredicate(Cexpression _Cexpression_1)
    : Cexpression_1(_Cexpression_1) { }
kc_tag_elem_patternrepresentation_PROperPredicate::kc_tag_elem_patternrepresentation_PROperPredicate(path _path_1, ID _ID_1)
    : path_1(_path_1), ID_1(_ID_1) { }
kc_tag_elem_patternrepresentation_PRVarPredicate::kc_tag_elem_patternrepresentation_PRVarPredicate(paths _paths_1, ID _ID_1, patternrepresentation _patternrepresentation_1)
    : paths_1(_paths_1), ID_1(_ID_1), patternrepresentation_1(_patternrepresentation_1) { }
kc_tag_elem_patternrepresentation_PRBinding::kc_tag_elem_patternrepresentation_PRBinding(path _path_1, ID _ID_1)
    : path_1(_path_1), ID_1(_ID_1) { }
kc_tag_path::kc_tag_path(integer p1 , path p2)
    : integer_1(p1), path_1(p2) { }
kc_tag_paths::kc_tag_paths(path p1 , paths p2)
    : path_1(p1), paths_1(p2) { }
kc_tag_argsnumbers::kc_tag_argsnumbers(integer p1 , argsnumbers p2)
    : integer_1(p1), argsnumbers_1(p2) { }
kc_tag_rewriterulesinfo::kc_tag_rewriterulesinfo(rewriteruleinfo p1 , rewriterulesinfo p2)
    : rewriteruleinfo_1(p1), rewriterulesinfo_1(p2) { }
const kc_enum_phyla kc_tag_rewriteruleinfo::phylum_sel_ = kc_phylum_rewriteruleinfo;
kc_tag_rewriteruleinfo_Rewriteruleinfo::kc_tag_rewriteruleinfo_Rewriteruleinfo(patternrepresentation _patternrepresentation_1, patternrepresentation _patternrepresentation_2, rewriteclause _rewriteclause_1)
    : patternrepresentation_1(_patternrepresentation_1), patternrepresentation_2(_patternrepresentation_2), rewriteclause_1(_rewriteclause_1) { }
kc_tag_withcasesinfo::kc_tag_withcasesinfo(withcaseinfo p1 , withcasesinfo p2)
    : withcaseinfo_1(p1), withcasesinfo_1(p2) { }
const kc_enum_phyla kc_tag_withcaseinfo::phylum_sel_ = kc_phylum_withcaseinfo;
kc_tag_withcaseinfo_Withcaseinfo::kc_tag_withcaseinfo_Withcaseinfo(patternrepresentation _patternrepresentation_1, patternrepresentation _patternrepresentation_2, Ctext _Ctext_1)
    : patternrepresentation_1(_patternrepresentation_1), patternrepresentation_2(_patternrepresentation_2), Ctext_1(_Ctext_1) { }
kc_tag_rewriteviewsinfo::kc_tag_rewriteviewsinfo(rewriteviewinfo p1 , rewriteviewsinfo p2)
    : rewriteviewinfo_1(p1), rewriteviewsinfo_1(p2) { }
const kc_enum_phyla kc_tag_rewriteviewinfo::phylum_sel_ = kc_phylum_rewriteviewinfo;
kc_tag_rewriteviewinfo_Rewriteviewinfo::kc_tag_rewriteviewinfo_Rewriteviewinfo(ID _ID_1, rewriterulesinfo _rewriterulesinfo_1)
    : ID_1(_ID_1), rewriterulesinfo_1(_rewriterulesinfo_1) { }
kc_tag_unparseviewsinfo::kc_tag_unparseviewsinfo(unparseviewinfo p1 , unparseviewsinfo p2)
    : unparseviewinfo_1(p1), unparseviewsinfo_1(p2) { }
const kc_enum_phyla kc_tag_unparseviewinfo::phylum_sel_ = kc_phylum_unparseviewinfo;
kc_tag_unparseviewinfo_Unparseviewinfo::kc_tag_unparseviewinfo_Unparseviewinfo(ID _ID_1, unparsedeclsinfo _unparsedeclsinfo_1)
    : ID_1(_ID_1), unparsedeclsinfo_1(_unparsedeclsinfo_1) { }
kc_tag_unparsedeclsinfo::kc_tag_unparsedeclsinfo(unparsedeclinfo p1 , unparsedeclsinfo p2)
    : unparsedeclinfo_1(p1), unparsedeclsinfo_1(p2) { }
const kc_enum_phyla kc_tag_unparsedeclinfo::phylum_sel_ = kc_phylum_unparsedeclinfo;
kc_tag_unparsedeclinfo_Unparsedeclinfo::kc_tag_unparsedeclinfo_Unparsedeclinfo(patternrepresentation _patternrepresentation_1, patternrepresentation _patternrepresentation_2, unparseclause _unparseclause_1)
    : patternrepresentation_1(_patternrepresentation_1), patternrepresentation_2(_patternrepresentation_2), unparseclause_1(_unparseclause_1) { }
const kc_enum_phyla kc_tag_ac_declaration::phylum_sel_ = kc_phylum_ac_declaration;
kc_tag_ac_declaration_AcDeclaration::kc_tag_ac_declaration_AcDeclaration(ac_declaration_specifiers _ac_declaration_specifiers_1, ac_init_declarator_list _ac_init_declarator_list_1)
    : ac_declaration_specifiers_1(_ac_declaration_specifiers_1), ac_init_declarator_list_1(_ac_init_declarator_list_1) { }
kc_tag_ac_declaration_list::kc_tag_ac_declaration_list(ac_declaration p1 , ac_declaration_list p2)
    : ac_declaration_1(p1), ac_declaration_list_1(p2) { }
kc_tag_ac_declaration_specifiers::kc_tag_ac_declaration_specifiers(ac_declaration_specifier p1 , ac_declaration_specifiers p2)
    : ac_declaration_specifier_1(p1), ac_declaration_specifiers_1(p2) { }
const kc_enum_phyla kc_tag_ac_declaration_specifier::phylum_sel_ = kc_phylum_ac_declaration_specifier;
kc_tag_ac_declaration_specifier_AcDeclSpecTypeQual::kc_tag_ac_declaration_specifier_AcDeclSpecTypeQual(ac_type_qualifier _ac_type_qualifier_1)
    : ac_type_qualifier_1(_ac_type_qualifier_1) { }
kc_tag_ac_declaration_specifier_AcDeclSpecTypeSpec::kc_tag_ac_declaration_specifier_AcDeclSpecTypeSpec(ac_type_specifier _ac_type_specifier_1)
    : ac_type_specifier_1(_ac_type_specifier_1) { }
kc_tag_ac_declaration_specifier_AcDeclSpecStorageSpec::kc_tag_ac_declaration_specifier_AcDeclSpecStorageSpec(ac_storage_class_specifier _ac_storage_class_specifier_1)
    : ac_storage_class_specifier_1(_ac_storage_class_specifier_1) { }
const kc_enum_phyla kc_tag_ac_storage_class_specifier::phylum_sel_ = kc_phylum_ac_storage_class_specifier;
kc_tag_ac_storage_class_specifier_AcVirtual::kc_tag_ac_storage_class_specifier_AcVirtual()
    { }
kc_tag_ac_storage_class_specifier_AcTypedef::kc_tag_ac_storage_class_specifier_AcTypedef()
    { }
kc_tag_ac_storage_class_specifier_AcExtern::kc_tag_ac_storage_class_specifier_AcExtern()
    { }
kc_tag_ac_storage_class_specifier_AcStatic::kc_tag_ac_storage_class_specifier_AcStatic()
    { }
kc_tag_ac_storage_class_specifier_AcRegister::kc_tag_ac_storage_class_specifier_AcRegister()
    { }
kc_tag_ac_storage_class_specifier_AcAuto::kc_tag_ac_storage_class_specifier_AcAuto()
    { }
const kc_enum_phyla kc_tag_ac_type_specifier::phylum_sel_ = kc_phylum_ac_type_specifier;
kc_tag_ac_type_specifier_AcTypeSpec::kc_tag_ac_type_specifier_AcTypeSpec(ID _ID_1)
    : ID_1(_ID_1) { }
const kc_enum_phyla kc_tag_ac_type_qualifier::phylum_sel_ = kc_phylum_ac_type_qualifier;
kc_tag_ac_type_qualifier_AcNoQualifier::kc_tag_ac_type_qualifier_AcNoQualifier()
    { }
kc_tag_ac_type_qualifier_AcUnsigned::kc_tag_ac_type_qualifier_AcUnsigned()
    { }
kc_tag_ac_type_qualifier_AcVolatile::kc_tag_ac_type_qualifier_AcVolatile()
    { }
kc_tag_ac_type_qualifier_AcConst::kc_tag_ac_type_qualifier_AcConst()
    { }
kc_tag_ac_init_declarator_list::kc_tag_ac_init_declarator_list(ac_init_declarator p1 , ac_init_declarator_list p2)
    : ac_init_declarator_1(p1), ac_init_declarator_list_1(p2) { }
const kc_enum_phyla kc_tag_ac_init_declarator::phylum_sel_ = kc_phylum_ac_init_declarator;
kc_tag_ac_init_declarator_AcInitDecl::kc_tag_ac_init_declarator_AcInitDecl(ac_declarator _ac_declarator_1)
    : ac_declarator_1(_ac_declarator_1) { }
const kc_enum_phyla kc_tag_ac_declarator::phylum_sel_ = kc_phylum_ac_declarator;
kc_tag_ac_declarator_AcDeclarator::kc_tag_ac_declarator_AcDeclarator(ac_pointer_option _ac_pointer_option_1, ac_ref_option _ac_ref_option_1, ac_direct_declarator _ac_direct_declarator_1)
    : ac_pointer_option_1(_ac_pointer_option_1), ac_ref_option_1(_ac_ref_option_1), ac_direct_declarator_1(_ac_direct_declarator_1) { }
const kc_enum_phyla kc_tag_ac_direct_declarator::phylum_sel_ = kc_phylum_ac_direct_declarator;
kc_tag_ac_direct_declarator_AcOperatorDeclId::kc_tag_ac_direct_declarator_AcOperatorDeclId(ac_operator_name _ac_operator_name_1)
    : ac_operator_name_1(_ac_operator_name_1) { }
kc_tag_ac_direct_declarator_AcMemberDecl::kc_tag_ac_direct_declarator_AcMemberDecl(ID _ID_1, ID _ID_2, ac_constant_expression_list _ac_constant_expression_list_1)
    : ID_1(_ID_1), ID_2(_ID_2), ac_constant_expression_list_1(_ac_constant_expression_list_1) { }
kc_tag_ac_direct_declarator_AcQualifiedDeclProto::kc_tag_ac_direct_declarator_AcQualifiedDeclProto(ac_class_qualifier_list _ac_class_qualifier_list_1, ac_direct_declarator _ac_direct_declarator_1, ac_parameter_type_list _ac_parameter_type_list_1, ac_type_qualifier _ac_type_qualifier_1)
    : ac_class_qualifier_list_1(_ac_class_qualifier_list_1), ac_direct_declarator_1(_ac_direct_declarator_1), ac_parameter_type_list_1(_ac_parameter_type_list_1), ac_type_qualifier_1(_ac_type_qualifier_1) { }
kc_tag_ac_direct_declarator_AcDirectDeclProto::kc_tag_ac_direct_declarator_AcDirectDeclProto(ac_direct_declarator _ac_direct_declarator_1, ac_parameter_type_list _ac_parameter_type_list_1)
    : ac_direct_declarator_1(_ac_direct_declarator_1), ac_parameter_type_list_1(_ac_parameter_type_list_1) { }
kc_tag_ac_direct_declarator_AcDirectDeclArray::kc_tag_ac_direct_declarator_AcDirectDeclArray(ac_direct_declarator _ac_direct_declarator_1, ac_constant_expression_option _ac_constant_expression_option_1)
    : ac_direct_declarator_1(_ac_direct_declarator_1), ac_constant_expression_option_1(_ac_constant_expression_option_1) { }
kc_tag_ac_direct_declarator_AcDirectDeclPack::kc_tag_ac_direct_declarator_AcDirectDeclPack(ac_declarator _ac_declarator_1)
    : ac_declarator_1(_ac_declarator_1) { }
kc_tag_ac_direct_declarator_AcDirectDeclId::kc_tag_ac_direct_declarator_AcDirectDeclId(ID _ID_1)
    : ID_1(_ID_1) { }
const kc_enum_phyla kc_tag_ac_pointer_option::phylum_sel_ = kc_phylum_ac_pointer_option;
kc_tag_ac_pointer_option_Yespointer::kc_tag_ac_pointer_option_Yespointer(ac_pointer _ac_pointer_1)
    : ac_pointer_1(_ac_pointer_1) { }
kc_tag_ac_pointer_option_Nopointer::kc_tag_ac_pointer_option_Nopointer()
    { }
const kc_enum_phyla kc_tag_ac_pointer::phylum_sel_ = kc_phylum_ac_pointer;
kc_tag_ac_pointer_AcPointerCons::kc_tag_ac_pointer_AcPointerCons(ac_type_qualifier_list _ac_type_qualifier_list_1, ac_pointer _ac_pointer_1)
    : ac_type_qualifier_list_1(_ac_type_qualifier_list_1), ac_pointer_1(_ac_pointer_1) { }
kc_tag_ac_pointer_AcPointerNil::kc_tag_ac_pointer_AcPointerNil(ac_type_qualifier_list _ac_type_qualifier_list_1)
    : ac_type_qualifier_list_1(_ac_type_qualifier_list_1) { }
const kc_enum_phyla kc_tag_ac_ref_option::phylum_sel_ = kc_phylum_ac_ref_option;
kc_tag_ac_ref_option_AcRef::kc_tag_ac_ref_option_AcRef()
    { }
kc_tag_ac_ref_option_AcNoRef::kc_tag_ac_ref_option_AcNoRef()
    { }
const kc_enum_phyla kc_tag_ac_operator_name::phylum_sel_ = kc_phylum_ac_operator_name;
kc_tag_ac_operator_name_AcOperatorName::kc_tag_ac_operator_name_AcOperatorName(casestring _casestring_1)
    : casestring_1(_casestring_1) { }
kc_tag_ac_class_qualifier_help_list::kc_tag_ac_class_qualifier_help_list(ac_direct_declarator p1 , ac_class_qualifier_help_list p2)
    : ac_direct_declarator_1(p1), ac_class_qualifier_help_list_1(p2) { }
kc_tag_ac_class_qualifier_list::kc_tag_ac_class_qualifier_list(ID p1 , ac_class_qualifier_list p2)
    : ID_1(p1), ac_class_qualifier_list_1(p2) { }
kc_tag_ac_type_qualifier_list::kc_tag_ac_type_qualifier_list(ac_type_qualifier p1 , ac_type_qualifier_list p2)
    : ac_type_qualifier_1(p1), ac_type_qualifier_list_1(p2) { }
const kc_enum_phyla kc_tag_ac_parameter_type_list::phylum_sel_ = kc_phylum_ac_parameter_type_list;
kc_tag_ac_parameter_type_list_AcParList3Dot::kc_tag_ac_parameter_type_list_AcParList3Dot(ac_parameter_list _ac_parameter_list_1)
    : ac_parameter_list_1(_ac_parameter_list_1) { }
kc_tag_ac_parameter_type_list_AcParList::kc_tag_ac_parameter_type_list_AcParList(ac_parameter_list _ac_parameter_list_1)
    : ac_parameter_list_1(_ac_parameter_list_1) { }
kc_tag_ac_parameter_list::kc_tag_ac_parameter_list(ac_parameter_declaration p1 , ac_parameter_list p2)
    : ac_parameter_declaration_1(p1), ac_parameter_list_1(p2) { }
const kc_enum_phyla kc_tag_ac_parameter_declaration::phylum_sel_ = kc_phylum_ac_parameter_declaration;
kc_tag_ac_parameter_declaration_AcParDeclAbsdecl::kc_tag_ac_parameter_declaration_AcParDeclAbsdecl(ac_declaration_specifiers _ac_declaration_specifiers_1, ac_abstract_declarator _ac_abstract_declarator_1, ac_constant_expression_option _ac_constant_expression_option_1)
    : ac_declaration_specifiers_1(_ac_declaration_specifiers_1), ac_abstract_declarator_1(_ac_abstract_declarator_1), ac_constant_expression_option_1(_ac_constant_expression_option_1) { }
kc_tag_ac_parameter_declaration_AcParDeclDecl::kc_tag_ac_parameter_declaration_AcParDeclDecl(ac_declaration_specifiers _ac_declaration_specifiers_1, ac_declarator _ac_declarator_1, ac_constant_expression_option _ac_constant_expression_option_1)
    : ac_declaration_specifiers_1(_ac_declaration_specifiers_1), ac_declarator_1(_ac_declarator_1), ac_constant_expression_option_1(_ac_constant_expression_option_1) { }
kc_tag_ac_identifier_list::kc_tag_ac_identifier_list(ID p1 , ac_identifier_list p2)
    : ID_1(p1), ac_identifier_list_1(p2) { }
const kc_enum_phyla kc_tag_ac_abstract_declarator::phylum_sel_ = kc_phylum_ac_abstract_declarator;
kc_tag_ac_abstract_declarator_AcAbsdeclDirdecl::kc_tag_ac_abstract_declarator_AcAbsdeclDirdecl(ac_pointer_option _ac_pointer_option_1, ac_direct_abstract_declarator _ac_direct_abstract_declarator_1)
    : ac_pointer_option_1(_ac_pointer_option_1), ac_direct_abstract_declarator_1(_ac_direct_abstract_declarator_1) { }
kc_tag_ac_abstract_declarator_AcAbsdeclPointer::kc_tag_ac_abstract_declarator_AcAbsdeclPointer(ac_pointer _ac_pointer_1)
    : ac_pointer_1(_ac_pointer_1) { }
const kc_enum_phyla kc_tag_ac_direct_abstract_declarator_option::phylum_sel_ = kc_phylum_ac_direct_abstract_declarator_option;
kc_tag_ac_direct_abstract_declarator_option_Yesac_direct_abstract_declarator::kc_tag_ac_direct_abstract_declarator_option_Yesac_direct_abstract_declarator(ac_direct_abstract_declarator _ac_direct_abstract_declarator_1)
    : ac_direct_abstract_declarator_1(_ac_direct_abstract_declarator_1) { }
kc_tag_ac_direct_abstract_declarator_option_Noac_direct_abstract_declarator::kc_tag_ac_direct_abstract_declarator_option_Noac_direct_abstract_declarator()
    { }
const kc_enum_phyla kc_tag_ac_direct_abstract_declarator::phylum_sel_ = kc_phylum_ac_direct_abstract_declarator;
kc_tag_ac_direct_abstract_declarator_AcDirAbsdeclFn::kc_tag_ac_direct_abstract_declarator_AcDirAbsdeclFn(ac_direct_abstract_declarator_option _ac_direct_abstract_declarator_option_1, ac_parameter_type_list _ac_parameter_type_list_1)
    : ac_direct_abstract_declarator_option_1(_ac_direct_abstract_declarator_option_1), ac_parameter_type_list_1(_ac_parameter_type_list_1) { }
kc_tag_ac_direct_abstract_declarator_AcDirAbsdeclArray::kc_tag_ac_direct_abstract_declarator_AcDirAbsdeclArray(ac_direct_abstract_declarator_option _ac_direct_abstract_declarator_option_1, ac_constant_expression_option _ac_constant_expression_option_1)
    : ac_direct_abstract_declarator_option_1(_ac_direct_abstract_declarator_option_1), ac_constant_expression_option_1(_ac_constant_expression_option_1) { }
kc_tag_ac_direct_abstract_declarator_AcDirAbsdeclPack::kc_tag_ac_direct_abstract_declarator_AcDirAbsdeclPack(ac_abstract_declarator _ac_abstract_declarator_1)
    : ac_abstract_declarator_1(_ac_abstract_declarator_1) { }
const kc_enum_phyla kc_tag_ac_constant_expression_option::phylum_sel_ = kc_phylum_ac_constant_expression_option;
kc_tag_ac_constant_expression_option_Noac_constant_expression::kc_tag_ac_constant_expression_option_Noac_constant_expression()
    { }
kc_tag_ac_constant_expression_option_Yesac_constant_expression::kc_tag_ac_constant_expression_option_Yesac_constant_expression(ac_constant_expression _ac_constant_expression_1)
    : ac_constant_expression_1(_ac_constant_expression_1) { }
const kc_enum_phyla kc_tag_ac_constant_expression::phylum_sel_ = kc_phylum_ac_constant_expression;
kc_tag_ac_constant_expression_AcConstExpr::kc_tag_ac_constant_expression_AcConstExpr(Cexpression _Cexpression_1)
    : Cexpression_1(_Cexpression_1) { }
kc_tag_ac_constant_expression_list::kc_tag_ac_constant_expression_list(ac_constant_expression p1 , ac_constant_expression_list p2)
    : ac_constant_expression_1(p1), ac_constant_expression_list_1(p2) { }
const kc_enum_phyla kc_tag_ac_opt_base_init_list::phylum_sel_ = kc_phylum_ac_opt_base_init_list;
kc_tag_ac_opt_base_init_list_AcYesBaseInit::kc_tag_ac_opt_base_init_list_AcYesBaseInit(ac_base_init_list _ac_base_init_list_1)
    : ac_base_init_list_1(_ac_base_init_list_1) { }
kc_tag_ac_opt_base_init_list_AcNoBaseInit::kc_tag_ac_opt_base_init_list_AcNoBaseInit()
    { }
kc_tag_ac_base_init_list::kc_tag_ac_base_init_list(ac_base_init p1 , ac_base_init_list p2)
    : ac_base_init_1(p1), ac_base_init_list_1(p2) { }
const kc_enum_phyla kc_tag_ac_base_init::phylum_sel_ = kc_phylum_ac_base_init;
kc_tag_ac_base_init_AcBaseInit::kc_tag_ac_base_init_AcBaseInit(ID _ID_1, ac_constant_expression _ac_constant_expression_1)
    : ID_1(_ID_1), ac_constant_expression_1(_ac_constant_expression_1) { }
kc_tag_baseclass_declarations::kc_tag_baseclass_declarations(baseclass_decl p1 , baseclass_declarations p2)
    : baseclass_decl_1(p1), baseclass_declarations_1(p2) { }
const kc_enum_phyla kc_tag_baseclass_decl::phylum_sel_ = kc_phylum_baseclass_decl;
kc_tag_baseclass_decl_BaseClassDecl::kc_tag_baseclass_decl_BaseClassDecl(ID _ID_1, baseclass_list _baseclass_list_1)
    : ID_1(_ID_1), baseclass_list_1(_baseclass_list_1) { }
kc_tag_baseclass_list::kc_tag_baseclass_list(ID p1 , baseclass_list p2)
    : ID_1(p1), baseclass_list_1(p2) { }
const kc_enum_phyla kc_tag_error::phylum_sel_ = kc_phylum_error;
kc_tag_error_Warning::kc_tag_error_Warning(fileline _fileline_1, problem _problem_1)
    : fileline_1(_fileline_1), problem_1(_problem_1) { }
kc_tag_error_NonFatal::kc_tag_error_NonFatal(fileline _fileline_1, problem _problem_1)
    : fileline_1(_fileline_1), problem_1(_problem_1) { }
kc_tag_error_Fatal::kc_tag_error_Fatal(fileline _fileline_1, problem _problem_1)
    : fileline_1(_fileline_1), problem_1(_problem_1) { }
const kc_enum_phyla kc_tag_problem::phylum_sel_ = kc_phylum_problem;
kc_tag_problem_Problem6::kc_tag_problem_Problem6(casestring _casestring_1, casestring _casestring_2, casestring _casestring_3, casestring _casestring_4, casestring _casestring_5, casestring _casestring_6)
    : casestring_1(_casestring_1), casestring_2(_casestring_2), casestring_3(_casestring_3), casestring_4(_casestring_4), casestring_5(_casestring_5), casestring_6(_casestring_6) { }
kc_tag_problem_Problem5::kc_tag_problem_Problem5(casestring _casestring_1, casestring _casestring_2, casestring _casestring_3, casestring _casestring_4, casestring _casestring_5)
    : casestring_1(_casestring_1), casestring_2(_casestring_2), casestring_3(_casestring_3), casestring_4(_casestring_4), casestring_5(_casestring_5) { }
kc_tag_problem_Problem4::kc_tag_problem_Problem4(casestring _casestring_1, casestring _casestring_2, casestring _casestring_3, casestring _casestring_4)
    : casestring_1(_casestring_1), casestring_2(_casestring_2), casestring_3(_casestring_3), casestring_4(_casestring_4) { }
kc_tag_problem_Problem3int1::kc_tag_problem_Problem3int1(casestring _casestring_1, casestring _casestring_2, casestring _casestring_3, integer _integer_1, casestring _casestring_4)
    : casestring_1(_casestring_1), casestring_2(_casestring_2), casestring_3(_casestring_3), integer_1(_integer_1), casestring_4(_casestring_4) { }
kc_tag_problem_Problem3::kc_tag_problem_Problem3(casestring _casestring_1, casestring _casestring_2, casestring _casestring_3)
    : casestring_1(_casestring_1), casestring_2(_casestring_2), casestring_3(_casestring_3) { }
kc_tag_problem_Problem2::kc_tag_problem_Problem2(casestring _casestring_1, casestring _casestring_2)
    : casestring_1(_casestring_1), casestring_2(_casestring_2) { }
kc_tag_problem_Problem1storageoption1ID::kc_tag_problem_Problem1storageoption1ID(casestring _casestring_1, storageoption _storageoption_1, casestring _casestring_2, ID _ID_1)
    : casestring_1(_casestring_1), storageoption_1(_storageoption_1), casestring_2(_casestring_2), ID_1(_ID_1) { }
kc_tag_problem_Problem1INT1ID1ID::kc_tag_problem_Problem1INT1ID1ID(casestring _casestring_1, INT _INT_1, casestring _casestring_2, ID _ID_1, casestring _casestring_3, ID _ID_2)
    : casestring_1(_casestring_1), INT_1(_INT_1), casestring_2(_casestring_2), ID_1(_ID_1), casestring_3(_casestring_3), ID_2(_ID_2) { }
kc_tag_problem_Problem1ID1ID1ID::kc_tag_problem_Problem1ID1ID1ID(casestring _casestring_1, ID _ID_1, casestring _casestring_2, ID _ID_2, casestring _casestring_3, ID _ID_3)
    : casestring_1(_casestring_1), ID_1(_ID_1), casestring_2(_casestring_2), ID_2(_ID_2), casestring_3(_casestring_3), ID_3(_ID_3) { }
kc_tag_problem_Problem1INT1ID::kc_tag_problem_Problem1INT1ID(casestring _casestring_1, INT _INT_1, casestring _casestring_2, ID _ID_1)
    : casestring_1(_casestring_1), INT_1(_INT_1), casestring_2(_casestring_2), ID_1(_ID_1) { }
kc_tag_problem_Problem1int1::kc_tag_problem_Problem1int1(casestring _casestring_1, integer _integer_1, casestring _casestring_2)
    : casestring_1(_casestring_1), integer_1(_integer_1), casestring_2(_casestring_2) { }
kc_tag_problem_Problem1INT::kc_tag_problem_Problem1INT(casestring _casestring_1, INT _INT_1)
    : casestring_1(_casestring_1), INT_1(_INT_1) { }
kc_tag_problem_Problem1t1ID::kc_tag_problem_Problem1t1ID(casestring _casestring_1, IDtype _IDtype_1, casestring _casestring_2, ID _ID_1)
    : casestring_1(_casestring_1), IDtype_1(_IDtype_1), casestring_2(_casestring_2), ID_1(_ID_1) { }
kc_tag_problem_Problem1ID1ID::kc_tag_problem_Problem1ID1ID(casestring _casestring_1, ID _ID_1, casestring _casestring_2, ID _ID_2)
    : casestring_1(_casestring_1), ID_1(_ID_1), casestring_2(_casestring_2), ID_2(_ID_2) { }
kc_tag_problem_Problem1we::kc_tag_problem_Problem1we(casestring _casestring_1, withexpression _withexpression_1)
    : casestring_1(_casestring_1), withexpression_1(_withexpression_1) { }
kc_tag_problem_Problem1tID::kc_tag_problem_Problem1tID(casestring _casestring_1, ID _ID_1)
    : casestring_1(_casestring_1), ID_1(_ID_1) { }
kc_tag_problem_Problem1ID::kc_tag_problem_Problem1ID(casestring _casestring_1, ID _ID_1)
    : casestring_1(_casestring_1), ID_1(_ID_1) { }
kc_tag_problem_Problem1::kc_tag_problem_Problem1(casestring _casestring_1)
    : casestring_1(_casestring_1) { }
kc_tag_addedphylumdeclarations::kc_tag_addedphylumdeclarations(addedphylumdeclaration p1 , addedphylumdeclarations p2)
    : addedphylumdeclaration_1(p1), addedphylumdeclarations_1(p2) { }
const kc_enum_phyla kc_tag_addedphylumdeclaration::phylum_sel_ = kc_phylum_addedphylumdeclaration;
kc_tag_addedphylumdeclaration_AddedPhylumdeclaration::kc_tag_addedphylumdeclaration_AddedPhylumdeclaration(uniqID _uniqID_1)
    : uniqID_1(_uniqID_1) { }
kc_tag_countedphylumdeclarations::kc_tag_countedphylumdeclarations(countedphylumdeclaration p1 , countedphylumdeclarations p2)
    : countedphylumdeclaration_1(p1), countedphylumdeclarations_1(p2) { }
const kc_enum_phyla kc_tag_countedphylumdeclaration::phylum_sel_ = kc_phylum_countedphylumdeclaration;
kc_tag_countedphylumdeclaration_CountedPhylumdeclaration::kc_tag_countedphylumdeclaration_CountedPhylumdeclaration(uniqID _uniqID_1)
    : uniqID_1(_uniqID_1) { }
const kc_enum_phyla kc_tag_charruns::phylum_sel_ = kc_phylum_charruns;
kc_tag_charruns_Stars::kc_tag_charruns_Stars()
    { }
kc_tag_charruns_QuotedNewlines::kc_tag_charruns_QuotedNewlines()
    { }
kc_tag_charruns_Newlines::kc_tag_charruns_Newlines()
    { }
kc_tag_bindingidmarks::kc_tag_bindingidmarks(bindingidmark p1 , bindingidmarks p2)
    : bindingidmark_1(p1), bindingidmarks_1(p2) { }
const kc_enum_phyla kc_tag_bindingidmark::phylum_sel_ = kc_phylum_bindingidmark;
kc_tag_bindingidmark_BindingIdMark::kc_tag_bindingidmark_BindingIdMark(uniqID _uniqID_1)
    : uniqID_1(_uniqID_1) { }

#ifdef KC_STATISTICS
KC_OPERATOR_STATISTICS kc_OperatorStatistics[KC_NO_OF_OPERATORS];
static int kc_casestring_strlen =0;
static int kc_nocasestring_strlen =0;
#  define KC_COLLECT_STATS0(v) v
#else
#  define KC_COLLECT_STATS0(v)
#endif

#ifndef KC_CREATE_STATS
#  define KC_CREATE_STATS(oper) kc_OperatorStatistics[oper].created++;
#endif
#ifndef KC_EXISTINGNOTFOUND_STATS
#  define KC_EXISTINGNOTFOUND_STATS(oper) kc_OperatorStatistics[oper].existing_not_found++;
#endif

#ifndef KC_FREE_CALLED_STATS
#  define KC_FREE_CALLED_STATS(oper,rec) kc_OperatorStatistics[oper].free_called[(rec?true:false)]++;
#endif

#ifndef KC_FREED_STATS
#  define KC_FREED_STATS(oper,rec) kc_OperatorStatistics[oper].freed[(rec?true:false)]++;
#endif
static kc_hashtable_struct_t kc_not_uniq_static_hashtable;
static kc_hashtable_struct_t uniq_static_hashtable;

bool kc_storageclass_still_uniq[] = {
    true, true };

kc_hashtable_t kc_hashtables[] = {
    &kc_not_uniq_static_hashtable,
    &uniq_static_hashtable,
};

const char* kc_storageclassnames[] = { "kc_not_uniq", "uniq" };

namespace { // all local to k.cc

uniqID kc_initialize_uniqID(uniqID kc_x)
{
    kc_x->type =  ITUnknown();
    kc_x->line =  0;
    kc_x->file =  mkcasestring("");
    kc_x->scopeinfo =  Nilscopetypefilelinestack();

    return kc_x;
}

ID kc_initialize_ID(ID kc_x)
{
    kc_x->type =  ITUnknown();
    kc_x->line =  0;
    kc_x->file =  mkcasestring("");

    return kc_x;
}

INT kc_initialize_INT(INT kc_x)
{
    kc_x->line =  0;
    kc_x->file =  mkcasestring("");

    return kc_x;
}

STRING kc_initialize_STRING(STRING kc_x)
{
    kc_x->line =  0;
    kc_x->file =  mkcasestring("");

    return kc_x;
}

phylumdeclaration kc_initialize_phylumdeclaration(phylumdeclaration kc_x)
{
    kc_x->marked =  0;
    kc_x->additional_members = Nilfndeclarations();
    kc_x->base_classes = Nilbaseclass_list();

    return kc_x;
}

storageclasses kc_initialize_storageclasses(storageclasses kc_x)
{
    kc_x->phyla =  Nilphylumnames();

    return kc_x;
}

alternative kc_initialize_alternative(alternative kc_x)
{
    kc_x->rewriteinfo =  Nilrewriterulesinfo();
    kc_x->unparseinfo =  Nilunparsedeclsinfo();
    kc_x->additional_members = Nilfndeclarations();
    kc_x->base_classes = Nilbaseclass_list();

    return kc_x;
}

Cexpression kc_initialize_Cexpression(Cexpression kc_x)
{
    kc_x->line =  0;
    kc_x->file =  mkcasestring("");

    return kc_x;
}

idCexpression kc_initialize_idCexpression(idCexpression kc_x)
{
    kc_x->id =  f_emptyId();

    return kc_x;
}

includefile kc_initialize_includefile(includefile kc_x)
{
    kc_x->inc_type =  include_unknown;
    kc_x->inc[0] = Nilincludedeclarations();
    kc_x->inc[1] = Nilincludedeclarations();
    if (Theincludefiles == 0) {
	Theincludefiles = Consincludefiles( kc_x, Nilincludefiles());
    } else {
	Theincludefiles = Consincludefiles( kc_x, Theincludefiles);
    }


    return kc_x;
}

includedeclaration kc_initialize_includedeclaration(includedeclaration kc_x)
{
    kc_x->line =  0;
    kc_x->file =  mkcasestring("");

    return kc_x;
}

patternchains kc_initialize_patternchains(patternchains kc_x)
{
    kc_x->line =  0;
    kc_x->file =  mkcasestring("");

    return kc_x;
}

patternchain kc_initialize_patternchain(patternchain kc_x)
{
    kc_x->line =  0;
    kc_x->file =  mkcasestring("");

    return kc_x;
}

patternchainitem kc_initialize_patternchainitem(patternchainitem kc_x)
{
    kc_x->line =  0;
    kc_x->file =  mkcasestring("");
    kc_x->type =  f_emptyId();

    return kc_x;
}

outmostpattern kc_initialize_outmostpattern(outmostpattern kc_x)
{
    kc_x->line =  0;
    kc_x->file =  mkcasestring("");
    kc_x->type =  f_emptyId();

    return kc_x;
}

term kc_initialize_term(term kc_x)
{
    kc_x->line =  0;
    kc_x->file =  mkcasestring("");

    return kc_x;
}

fnfile kc_initialize_fnfile(fnfile kc_x)
{
    kc_x->fns = Nilfndeclarations();
    if (Thefnfiles == 0) {
	Thefnfiles = Consfnfiles( kc_x, Nilfnfiles());
    } else {
	Thefnfiles = Consfnfiles( kc_x, Thefnfiles);
    }


    return kc_x;
}

fndeclaration kc_initialize_fndeclaration(fndeclaration kc_x)
{
    kc_x->last_line =  0;
    kc_x->file =  mkcasestring("");
    {
	fndeclaration kc_selvar_0_1 = phylum_cast<fndeclaration>(kc_x);

	if ((kc_selvar_0_1->prod_sel() == sel_FnAcDeclaration)) {
	    const ac_declarator fn_args = phylum_cast<const kc_tag_fndeclaration_FnAcDeclaration*>(kc_selvar_0_1)->ac_declarator_1;
	    const ac_declaration_list C_vardecls = phylum_cast<const kc_tag_fndeclaration_FnAcDeclaration*>(kc_selvar_0_1)->ac_declaration_list_1;

	    kc_selvar_0_1->sorted = sort_extend_parameter_type_list( C_vardecls, fn_args );

	} else
	{
	    kc_selvar_0_1->sorted = AcParList( Nilac_parameter_list() ); 
	}
    }


    return kc_x;
}

Ctext kc_initialize_Ctext(Ctext kc_x)
{
    kc_x->line =  0;
    kc_x->file =  mkcasestring("");

    return kc_x;
}

Ctext_elem kc_initialize_Ctext_elem(Ctext_elem kc_x)
{
    kc_x->line =  0;
    kc_x->file =  mkcasestring("");

    return kc_x;
}

foreach_after kc_initialize_foreach_after(foreach_after kc_x)
{
    kc_x->line =  0;
    kc_x->file =  mkcasestring("");

    return kc_x;
}

withexpressions kc_initialize_withexpressions(withexpressions kc_x)
{
    kc_x->type =  0;
    kc_x->line =  0;
    kc_x->file =  mkcasestring("");
    {
	withexpressions kc_selvar_0_1 = phylum_cast<withexpressions>(kc_x);

	if ((kc_selvar_0_1->prod_sel() == sel_Conswithexpressions)) {
	    const withexpression h = (kc_selvar_0_1)->withexpression_1;
	    const withexpressions t = (kc_selvar_0_1)->withexpressions_1;

	    kc_selvar_0_1->type = Consphylumnames( h->type, t->type );
	    kc_selvar_0_1->line = h->line;
	    kc_selvar_0_1->file = h->file;

	} else
	    if ((kc_selvar_0_1->prod_sel() == sel_Nilwithexpressions)) {

	    kc_selvar_0_1->type = Nilphylumnames();

	} else
	    kc_no_default_in_with( "", __LINE__, __FILE__ );
    }


    return kc_x;
}

withexpression kc_initialize_withexpression(withexpression kc_x)
{
    kc_x->type =  f_emptyId();
    kc_x->line =  0;
    kc_x->file =  mkcasestring("");

    {
	withexpression kc_selvar_0_1 = phylum_cast<withexpression>(kc_x);

	if ((kc_selvar_0_1->prod_sel() == sel_WECexpression)) {
	    const Cexpression e = phylum_cast<const kc_tag_withexpression_WECexpression*>(kc_selvar_0_1)->Cexpression_1;

	    kc_selvar_0_1->line = e->line;
	    kc_selvar_0_1->file = e->file;

	} else
	    if ((kc_selvar_0_1->prod_sel() == sel_WEVariable)) {
	    const ID id = phylum_cast<const kc_tag_withexpression_WEVariable*>(kc_selvar_0_1)->ID_1;

	    kc_selvar_0_1->line = id->line;
	    kc_selvar_0_1->file = id->file;

	} else
	    kc_no_default_in_with( "", __LINE__, __FILE__ );
    }


    return kc_x;
}

viewnames kc_initialize_viewnames(viewnames kc_x)
{
    kc_x->is_extern = false;

    return kc_x;
}

unparseitem kc_initialize_unparseitem(unparseitem kc_x)
{
    kc_x->text_nr = 0;

    return kc_x;
}

elem_patternrepresentation kc_initialize_elem_patternrepresentation(elem_patternrepresentation kc_x)
{
    kc_x->line =  0;
    kc_x->file =  mkcasestring("");
    kc_x->type =  f_emptyId();

    return kc_x;
}

path kc_initialize_path(path kc_x)
{
    kc_x->op =  f_emptyId();
    kc_x->id =  f_emptyId();

    return kc_x;
}

ac_operator_name kc_initialize_ac_operator_name(ac_operator_name kc_x)
{
    kc_x->line =  0;
    kc_x->file =  mkcasestring("");

    return kc_x;
}

addedphylumdeclaration kc_initialize_addedphylumdeclaration(addedphylumdeclaration kc_x)
{
    kc_x->added =  false;
    if (!pl_addedphylumdeclarations)
    pl_addedphylumdeclarations =
    Consaddedphylumdeclarations( kc_x, Niladdedphylumdeclarations() );
    else
    pl_addedphylumdeclarations =
    Consaddedphylumdeclarations( kc_x, pl_addedphylumdeclarations );


    return kc_x;
}

countedphylumdeclaration kc_initialize_countedphylumdeclaration(countedphylumdeclaration kc_x)
{
    kc_x->count =  0;
    if (!pl_countedphylumdeclarations)
    pl_countedphylumdeclarations =
    Conscountedphylumdeclarations( kc_x, Nilcountedphylumdeclarations() );
    else
    pl_countedphylumdeclarations =
    Conscountedphylumdeclarations( kc_x, pl_countedphylumdeclarations );


    return kc_x;
}

bindingidmark kc_initialize_bindingidmark(bindingidmark kc_x)
{
    kc_x->marked =  false;

    if (! Thebindingidmarks)
    Thebindingidmarks = Consbindingidmarks( kc_x, Nilbindingidmarks() );
    else
    Thebindingidmarks = Consbindingidmarks( kc_x, Thebindingidmarks );


    return kc_x;
}


} // namespace

kc_enum_phyla kc_tag_abstract_phylum::phylum() const {
    return kc_OperatorInfo[prod_sel()].phylum;
}

const char* kc_tag_abstract_phylum::phylum_name() const {
    return kc_PhylumInfo[phylum()].name;
}
const char* kc_tag_abstract_phylum::op_name() const {
    return kc_OperatorInfo[prod_sel()].name;
}

casestring
mkcasestring(const char *kc_s)
{
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel__Str));

    casestring kc_x=new kc_tag_casestring__Str(kc_s);
    casestring unique_kc_x=kc_hashtables[uniq]->kc_ht_check_insert(kc_x);
    if(unique_kc_x!=kc_x) {
	delete kc_x;
	kc_x=unique_kc_x;
    }
    else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel__Str));
	kc_x->post_create();
    }

    return kc_x;
}

casestring
mkcasestring(const char *kc_s, unsigned int length)
{
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel__Str));

    casestring kc_x=new kc_tag_casestring__Str(kc_s,length);
    casestring unique_kc_x=kc_hashtables[uniq]->kc_ht_check_insert(kc_x);
    if(unique_kc_x!=kc_x) {
	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel__Str));
	kc_x->post_create();
    }

    return kc_x;
}

nocasestring
mknocasestring(const char *kc_s)
{
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NoCaseStr));

    nocasestring kc_x=new kc_tag_nocasestring_NoCaseStr(kc_s);
    nocasestring unique_kc_x=kc_hashtables[uniq]->kc_ht_check_insert(kc_x);
    if(unique_kc_x!=kc_x) {
	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NoCaseStr));
	kc_x->post_create();
    }

    return kc_x;
}

nocasestring
mknocasestring(const char *kc_s, unsigned int length)
{
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NoCaseStr));

    nocasestring kc_x=new kc_tag_nocasestring_NoCaseStr(kc_s,length);
    nocasestring unique_kc_x=kc_hashtables[uniq]->kc_ht_check_insert(kc_x);
    if(unique_kc_x!=kc_x) {
	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NoCaseStr));
	kc_x->post_create();
    }

    return kc_x;
}

integer
mkinteger(const INTEGER kc_i)
{
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel__Int));

    integer kc_x =new kc_tag_integer__Int(kc_i);
    integer unique_kc_x=kc_hashtables[uniq]->kc_ht_check_insert(kc_x);
    if(unique_kc_x!=kc_x) {
	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel__Int));
	kc_x->post_create();
    }

    return kc_x;
}

real
mkreal(const REAL kc_r)
{
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel__Real));

    real kc_x=new kc_tag_real__Real(kc_r);
    real unique_kc_x=kc_hashtables[uniq]->kc_ht_check_insert(kc_x);
    if(unique_kc_x!=kc_x) {
	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel__Real));
	kc_x->post_create();
    }

    return kc_x;
}

voidptr
mkvoidptr(void *kc_p)
{
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel__VoidPtr));
    voidptr kc_x=new kc_tag_voidptr__VoidPtr(kc_p);
    voidptr unique_kc_x=kc_hashtables[uniq]->kc_ht_check_insert(kc_x);
    if(unique_kc_x!=kc_x) {
	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel__VoidPtr));
	kc_x->post_create();
    }
    return kc_x;
}

uniqID
Str(casestring _casestring_1) {
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Str));
    uniqID kc_x=new kc_tag_uniqID_Str(_casestring_1);
    uniqID unique_kc_x= kc_hashtables[uniq]->kc_ht_check_insert(kc_x);
    if(unique_kc_x!=kc_x) {
	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Str));
	kc_x->post_create();
	kc_x = kc_initialize_uniqID(kc_x);
    }
    return static_cast<kc_tag_uniqID_Str*>(kc_x);
}

ID
Id(uniqID _uniqID_1) {
    ID kc_x = new kc_tag_ID_Id(_uniqID_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Id));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Id));
    kc_x->post_create();
    kc_x = kc_initialize_ID(kc_x);
    return static_cast<kc_tag_ID_Id*>(kc_x);
}

INT
Int(integer _integer_1) {
    INT kc_x = new kc_tag_INT_Int(_integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Int));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Int));
    kc_x->post_create();
    kc_x = kc_initialize_INT(kc_x);
    return static_cast<kc_tag_INT_Int*>(kc_x);
}

STRING
String(casestring _casestring_1) {
    STRING kc_x = new kc_tag_STRING_String(_casestring_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_String));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_String));
    kc_x->post_create();
    kc_x = kc_initialize_STRING(kc_x);
    return static_cast<kc_tag_STRING_String*>(kc_x);
}

phylumdeclarationsroot
PhylumDeclarations(phylumdeclarations _phylumdeclarations_1) {
    phylumdeclarationsroot kc_x = new kc_tag_phylumdeclarationsroot_PhylumDeclarations(_phylumdeclarations_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_PhylumDeclarations));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_PhylumDeclarations));
    kc_x->post_create();
    return static_cast<kc_tag_phylumdeclarationsroot_PhylumDeclarations*>(kc_x);
}

phylumdeclarations
Nilphylumdeclarations() {
    phylumdeclarations kc_x = new kc_tag_phylumdeclarations();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilphylumdeclarations));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilphylumdeclarations));
    kc_x->post_create();
    return static_cast<kc_tag_phylumdeclarations*>(kc_x);
}

phylumdeclarations
Consphylumdeclarations(phylumdeclaration _phylumdeclaration_1, phylumdeclarations _phylumdeclarations_1) {
    phylumdeclarations kc_x = new kc_tag_phylumdeclarations(_phylumdeclaration_1, _phylumdeclarations_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consphylumdeclarations));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consphylumdeclarations));
    kc_x->post_create();
    return static_cast<kc_tag_phylumdeclarations*>(kc_x);
}

phylumnames
Nilphylumnames() {
    phylumnames kc_x = new kc_tag_phylumnames();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilphylumnames));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilphylumnames));
    kc_x->post_create();
    return static_cast<kc_tag_phylumnames*>(kc_x);
}

phylumnames
Consphylumnames(ID _ID_1, phylumnames _phylumnames_1) {
    phylumnames kc_x = new kc_tag_phylumnames(_ID_1, _phylumnames_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consphylumnames));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consphylumnames));
    kc_x->post_create();
    return static_cast<kc_tag_phylumnames*>(kc_x);
}

phylumdeclaration
PhylumDeclaration(ID _ID_1, storageoption _storageoption_1, productionblock _productionblock_1, Ccode_option _Ccode_option_1) {
    phylumdeclaration kc_x = new kc_tag_phylumdeclaration_PhylumDeclaration(_ID_1, _storageoption_1, _productionblock_1, _Ccode_option_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_PhylumDeclaration));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_PhylumDeclaration));
    kc_x->post_create();
    kc_x = kc_initialize_phylumdeclaration(kc_x);
    return static_cast<kc_tag_phylumdeclaration_PhylumDeclaration*>(kc_x);
}

storageoption
NoStorageOption() {
    storageoption kc_x = new kc_tag_storageoption_NoStorageOption();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NoStorageOption));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NoStorageOption));
    kc_x->post_create();
    return static_cast<kc_tag_storageoption_NoStorageOption*>(kc_x);
}

storageoption
NegativeStorageOption(ID _ID_1) {
    storageoption kc_x = new kc_tag_storageoption_NegativeStorageOption(_ID_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NegativeStorageOption));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NegativeStorageOption));
    kc_x->post_create();
    return static_cast<kc_tag_storageoption_NegativeStorageOption*>(kc_x);
}

storageoption
PositiveStorageOption(ID _ID_1) {
    storageoption kc_x = new kc_tag_storageoption_PositiveStorageOption(_ID_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_PositiveStorageOption));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_PositiveStorageOption));
    kc_x->post_create();
    return static_cast<kc_tag_storageoption_PositiveStorageOption*>(kc_x);
}

storageclasses
Nilstorageclasses() {
    storageclasses kc_x = new kc_tag_storageclasses();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilstorageclasses));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilstorageclasses));
    kc_x->post_create();
    kc_x = kc_initialize_storageclasses(kc_x);
    return static_cast<kc_tag_storageclasses*>(kc_x);
}

storageclasses
Consstorageclasses(ID _ID_1, storageclasses _storageclasses_1) {
    storageclasses kc_x = new kc_tag_storageclasses(_ID_1, _storageclasses_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consstorageclasses));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consstorageclasses));
    kc_x->post_create();
    kc_x = kc_initialize_storageclasses(kc_x);
    return static_cast<kc_tag_storageclasses*>(kc_x);
}

productionblock
Emptyproductionblock() {
    productionblock kc_x = new kc_tag_productionblock_Emptyproductionblock();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Emptyproductionblock));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Emptyproductionblock));
    kc_x->post_create();
    return static_cast<kc_tag_productionblock_Emptyproductionblock*>(kc_x);
}

productionblock
ListAlternatives(alternatives _alternatives_1, ID _ID_1) {
    productionblock kc_x = new kc_tag_productionblock_ListAlternatives(_alternatives_1, _ID_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ListAlternatives));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ListAlternatives));
    kc_x->post_create();
    return static_cast<kc_tag_productionblock_ListAlternatives*>(kc_x);
}

productionblock
NonlistAlternatives(alternatives _alternatives_1) {
    productionblock kc_x = new kc_tag_productionblock_NonlistAlternatives(_alternatives_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NonlistAlternatives));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NonlistAlternatives));
    kc_x->post_create();
    return static_cast<kc_tag_productionblock_NonlistAlternatives*>(kc_x);
}

productionblock
PredefinedAlternatives(alternatives _alternatives_1) {
    productionblock kc_x = new kc_tag_productionblock_PredefinedAlternatives(_alternatives_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_PredefinedAlternatives));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_PredefinedAlternatives));
    kc_x->post_create();
    return static_cast<kc_tag_productionblock_PredefinedAlternatives*>(kc_x);
}

alternatives
Nilalternatives() {
    alternatives kc_x = new kc_tag_alternatives();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilalternatives));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilalternatives));
    kc_x->post_create();
    return static_cast<kc_tag_alternatives*>(kc_x);
}

alternatives
Consalternatives(alternative _alternative_1, alternatives _alternatives_1) {
    alternatives kc_x = new kc_tag_alternatives(_alternative_1, _alternatives_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consalternatives));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consalternatives));
    kc_x->post_create();
    return static_cast<kc_tag_alternatives*>(kc_x);
}

alternative
Alternative(ID _ID_1, arguments _arguments_1) {
    alternative kc_x = new kc_tag_alternative_Alternative(_ID_1, _arguments_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Alternative));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Alternative));
    kc_x->post_create();
    kc_x = kc_initialize_alternative(kc_x);
    return static_cast<kc_tag_alternative_Alternative*>(kc_x);
}

arguments
Nilarguments() {
    arguments kc_x = new kc_tag_arguments();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilarguments));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilarguments));
    kc_x->post_create();
    return static_cast<kc_tag_arguments*>(kc_x);
}

arguments
Consarguments(ID _ID_1, arguments _arguments_1) {
    arguments kc_x = new kc_tag_arguments(_ID_1, _arguments_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consarguments));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consarguments));
    kc_x->post_create();
    return static_cast<kc_tag_arguments*>(kc_x);
}

argument
Argument(ID _ID_1, integer _integer_1) {
    argument kc_x = new kc_tag_argument_Argument(_ID_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Argument));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Argument));
    kc_x->post_create();
    return static_cast<kc_tag_argument_Argument*>(kc_x);
}

Ccode_option
CcodeOption(attributes _attributes_1, Ctexts _Ctexts_1) {
    Ccode_option kc_x = new kc_tag_Ccode_option_CcodeOption(_attributes_1, _Ctexts_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CcodeOption));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CcodeOption));
    kc_x->post_create();
    return static_cast<kc_tag_Ccode_option_CcodeOption*>(kc_x);
}

attributes
Nilattributes() {
    attributes kc_x = new kc_tag_attributes();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilattributes));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilattributes));
    kc_x->post_create();
    return static_cast<kc_tag_attributes*>(kc_x);
}

attributes
Consattributes(attribute _attribute_1, attributes _attributes_1) {
    attributes kc_x = new kc_tag_attributes(_attribute_1, _attributes_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consattributes));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consattributes));
    kc_x->post_create();
    return static_cast<kc_tag_attributes*>(kc_x);
}

attribute
Attribute(ID _ID_1, ID _ID_2, attribute_initialisation_option _attribute_initialisation_option_1) {
    attribute kc_x = new kc_tag_attribute_Attribute(_ID_1, _ID_2, _attribute_initialisation_option_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Attribute));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Attribute));
    kc_x->post_create();
    return static_cast<kc_tag_attribute_Attribute*>(kc_x);
}

attribute_initialisation_option
Noattribute_initialisation() {
    attribute_initialisation_option kc_x = new kc_tag_attribute_initialisation_option_Noattribute_initialisation();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Noattribute_initialisation));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Noattribute_initialisation));
    kc_x->post_create();
    return static_cast<kc_tag_attribute_initialisation_option_Noattribute_initialisation*>(kc_x);
}

attribute_initialisation_option
Yesattribute_initialisation(Cexpression _Cexpression_1) {
    attribute_initialisation_option kc_x = new kc_tag_attribute_initialisation_option_Yesattribute_initialisation(_Cexpression_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Yesattribute_initialisation));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Yesattribute_initialisation));
    kc_x->post_create();
    return static_cast<kc_tag_attribute_initialisation_option_Yesattribute_initialisation*>(kc_x);
}

Cexpression
NilCexpression() {
    Cexpression kc_x = new kc_tag_Cexpression();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NilCexpression));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NilCexpression));
    kc_x->post_create();
    kc_x = kc_initialize_Cexpression(kc_x);
    return static_cast<kc_tag_Cexpression*>(kc_x);
}

Cexpression
ConsCexpression(Cexpression_elem _Cexpression_elem_1, Cexpression _Cexpression_1) {
    Cexpression kc_x = new kc_tag_Cexpression(_Cexpression_elem_1, _Cexpression_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConsCexpression));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConsCexpression));
    kc_x->post_create();
    kc_x = kc_initialize_Cexpression(kc_x);
    return static_cast<kc_tag_Cexpression*>(kc_x);
}

Cexpression_elem
CExpressionPart(casestring _casestring_1) {
    Cexpression_elem kc_x = new kc_tag_Cexpression_elem_CExpressionPart(_casestring_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CExpressionPart));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CExpressionPart));
    kc_x->post_create();
    return static_cast<kc_tag_Cexpression_elem_CExpressionPart*>(kc_x);
}

Cexpression_elem
CExpressionDollarvar(INT _INT_1) {
    Cexpression_elem kc_x = new kc_tag_Cexpression_elem_CExpressionDollarvar(_INT_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CExpressionDollarvar));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CExpressionDollarvar));
    kc_x->post_create();
    return static_cast<kc_tag_Cexpression_elem_CExpressionDollarvar*>(kc_x);
}

Cexpression_elem
CExpressionNl(integer _integer_1) {
    Cexpression_elem kc_x = new kc_tag_Cexpression_elem_CExpressionNl(_integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CExpressionNl));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CExpressionNl));
    kc_x->post_create();
    return static_cast<kc_tag_Cexpression_elem_CExpressionNl*>(kc_x);
}

Cexpression_elem
CExpressionDQ(CexpressionDQ _CexpressionDQ_1) {
    Cexpression_elem kc_x = new kc_tag_Cexpression_elem_CExpressionDQ(_CexpressionDQ_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CExpressionDQ));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CExpressionDQ));
    kc_x->post_create();
    return static_cast<kc_tag_Cexpression_elem_CExpressionDQ*>(kc_x);
}

Cexpression_elem
CExpressionSQ(CexpressionSQ _CexpressionSQ_1) {
    Cexpression_elem kc_x = new kc_tag_Cexpression_elem_CExpressionSQ(_CexpressionSQ_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CExpressionSQ));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CExpressionSQ));
    kc_x->post_create();
    return static_cast<kc_tag_Cexpression_elem_CExpressionSQ*>(kc_x);
}

Cexpression_elem
CExpressionPack(Cexpression _Cexpression_1) {
    Cexpression_elem kc_x = new kc_tag_Cexpression_elem_CExpressionPack(_Cexpression_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CExpressionPack));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CExpressionPack));
    kc_x->post_create();
    return static_cast<kc_tag_Cexpression_elem_CExpressionPack*>(kc_x);
}

Cexpression_elem
CExpressionArray(Cexpression _Cexpression_1) {
    Cexpression_elem kc_x = new kc_tag_Cexpression_elem_CExpressionArray(_Cexpression_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CExpressionArray));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CExpressionArray));
    kc_x->post_create();
    return static_cast<kc_tag_Cexpression_elem_CExpressionArray*>(kc_x);
}

CexpressionDQ
NilCexpressionDQ() {
    CexpressionDQ kc_x = new kc_tag_CexpressionDQ();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NilCexpressionDQ));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NilCexpressionDQ));
    kc_x->post_create();
    return static_cast<kc_tag_CexpressionDQ*>(kc_x);
}

CexpressionDQ
ConsCexpressionDQ(CexpressionDQ_elem _CexpressionDQ_elem_1, CexpressionDQ _CexpressionDQ_1) {
    CexpressionDQ kc_x = new kc_tag_CexpressionDQ(_CexpressionDQ_elem_1, _CexpressionDQ_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConsCexpressionDQ));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConsCexpressionDQ));
    kc_x->post_create();
    return static_cast<kc_tag_CexpressionDQ*>(kc_x);
}

CexpressionDQ_elem
CExpressionDQPart(casestring _casestring_1) {
    CexpressionDQ_elem kc_x = new kc_tag_CexpressionDQ_elem_CExpressionDQPart(_casestring_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CExpressionDQPart));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CExpressionDQPart));
    kc_x->post_create();
    return static_cast<kc_tag_CexpressionDQ_elem_CExpressionDQPart*>(kc_x);
}

CexpressionDQ_elem
CExpressionDQNl(integer _integer_1) {
    CexpressionDQ_elem kc_x = new kc_tag_CexpressionDQ_elem_CExpressionDQNl(_integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CExpressionDQNl));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CExpressionDQNl));
    kc_x->post_create();
    return static_cast<kc_tag_CexpressionDQ_elem_CExpressionDQNl*>(kc_x);
}

CexpressionSQ
NilCexpressionSQ() {
    CexpressionSQ kc_x = new kc_tag_CexpressionSQ();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NilCexpressionSQ));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NilCexpressionSQ));
    kc_x->post_create();
    return static_cast<kc_tag_CexpressionSQ*>(kc_x);
}

CexpressionSQ
ConsCexpressionSQ(CexpressionSQ_elem _CexpressionSQ_elem_1, CexpressionSQ _CexpressionSQ_1) {
    CexpressionSQ kc_x = new kc_tag_CexpressionSQ(_CexpressionSQ_elem_1, _CexpressionSQ_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConsCexpressionSQ));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConsCexpressionSQ));
    kc_x->post_create();
    return static_cast<kc_tag_CexpressionSQ*>(kc_x);
}

CexpressionSQ_elem
CExpressionSQPart(casestring _casestring_1) {
    CexpressionSQ_elem kc_x = new kc_tag_CexpressionSQ_elem_CExpressionSQPart(_casestring_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CExpressionSQPart));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CExpressionSQPart));
    kc_x->post_create();
    return static_cast<kc_tag_CexpressionSQ_elem_CExpressionSQPart*>(kc_x);
}

CexpressionSQ_elem
CExpressionSQNl(integer _integer_1) {
    CexpressionSQ_elem kc_x = new kc_tag_CexpressionSQ_elem_CExpressionSQNl(_integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CExpressionSQNl));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CExpressionSQNl));
    kc_x->post_create();
    return static_cast<kc_tag_CexpressionSQ_elem_CExpressionSQNl*>(kc_x);
}

idCexpressions
NilidCexpressions() {
    idCexpressions kc_x = new kc_tag_idCexpressions();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NilidCexpressions));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NilidCexpressions));
    kc_x->post_create();
    return static_cast<kc_tag_idCexpressions*>(kc_x);
}

idCexpressions
ConsidCexpressions(idCexpression _idCexpression_1, idCexpressions _idCexpressions_1) {
    idCexpressions kc_x = new kc_tag_idCexpressions(_idCexpression_1, _idCexpressions_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConsidCexpressions));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConsidCexpressions));
    kc_x->post_create();
    return static_cast<kc_tag_idCexpressions*>(kc_x);
}

idCexpression
IdCexpression(ID _ID_1, Cexpression _Cexpression_1) {
    idCexpression kc_x = new kc_tag_idCexpression_IdCexpression(_ID_1, _Cexpression_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_IdCexpression));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_IdCexpression));
    kc_x->post_create();
    kc_x = kc_initialize_idCexpression(kc_x);
    return static_cast<kc_tag_idCexpression_IdCexpression*>(kc_x);
}

Ctexts
NilCtexts() {
    Ctexts kc_x = new kc_tag_Ctexts();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NilCtexts));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NilCtexts));
    kc_x->post_create();
    return static_cast<kc_tag_Ctexts*>(kc_x);
}

Ctexts
ConsCtexts(Ctext _Ctext_1, Ctexts _Ctexts_1) {
    Ctexts kc_x = new kc_tag_Ctexts(_Ctext_1, _Ctexts_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConsCtexts));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConsCtexts));
    kc_x->post_create();
    return static_cast<kc_tag_Ctexts*>(kc_x);
}

includefiles
Nilincludefiles() {
    includefiles kc_x = new kc_tag_includefiles();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilincludefiles));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilincludefiles));
    kc_x->post_create();
    return static_cast<kc_tag_includefiles*>(kc_x);
}

includefiles
Consincludefiles(includefile _includefile_1, includefiles _includefiles_1) {
    includefiles kc_x = new kc_tag_includefiles(_includefile_1, _includefiles_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consincludefiles));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consincludefiles));
    kc_x->post_create();
    return static_cast<kc_tag_includefiles*>(kc_x);
}

includefile
IncludeFile(casestring _casestring_1) {
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_IncludeFile));
    includefile kc_x=new kc_tag_includefile_IncludeFile(_casestring_1);
    includefile unique_kc_x= kc_hashtables[uniq]->kc_ht_check_insert(kc_x);
    if(unique_kc_x!=kc_x) {
	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_IncludeFile));
	kc_x->post_create();
	kc_x = kc_initialize_includefile(kc_x);
    }
    return static_cast<kc_tag_includefile_IncludeFile*>(kc_x);
}

includedeclarations
Nilincludedeclarations() {
    includedeclarations kc_x = new kc_tag_includedeclarations();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilincludedeclarations));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilincludedeclarations));
    kc_x->post_create();
    return static_cast<kc_tag_includedeclarations*>(kc_x);
}

includedeclarations
Consincludedeclarations(includedeclaration _includedeclaration_1, includedeclarations _includedeclarations_1) {
    includedeclarations kc_x = new kc_tag_includedeclarations(_includedeclaration_1, _includedeclarations_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consincludedeclarations));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consincludedeclarations));
    kc_x->post_create();
    return static_cast<kc_tag_includedeclarations*>(kc_x);
}

includedeclaration
IncludeDeclaration(casestring _casestring_1) {
    includedeclaration kc_x = new kc_tag_includedeclaration_IncludeDeclaration(_casestring_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_IncludeDeclaration));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_IncludeDeclaration));
    kc_x->post_create();
    kc_x = kc_initialize_includedeclaration(kc_x);
    return static_cast<kc_tag_includedeclaration_IncludeDeclaration*>(kc_x);
}

rwdeclarations
Nilrwdeclarations() {
    rwdeclarations kc_x = new kc_tag_rwdeclarations();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilrwdeclarations));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilrwdeclarations));
    kc_x->post_create();
    return static_cast<kc_tag_rwdeclarations*>(kc_x);
}

rwdeclarations
Consrwdeclarations(rwdeclaration _rwdeclaration_1, rwdeclarations _rwdeclarations_1) {
    rwdeclarations kc_x = new kc_tag_rwdeclarations(_rwdeclaration_1, _rwdeclarations_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consrwdeclarations));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consrwdeclarations));
    kc_x->post_create();
    return static_cast<kc_tag_rwdeclarations*>(kc_x);
}

rwdeclaration
RwDeclaration(outmostpatterns _outmostpatterns_1, rewriteclauses _rewriteclauses_1) {
    rwdeclaration kc_x = new kc_tag_rwdeclaration_RwDeclaration(_outmostpatterns_1, _rewriteclauses_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_RwDeclaration));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_RwDeclaration));
    kc_x->post_create();
    return static_cast<kc_tag_rwdeclaration_RwDeclaration*>(kc_x);
}

rewriteclauses
Nilrewriteclauses() {
    rewriteclauses kc_x = new kc_tag_rewriteclauses();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilrewriteclauses));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilrewriteclauses));
    kc_x->post_create();
    return static_cast<kc_tag_rewriteclauses*>(kc_x);
}

rewriteclauses
Consrewriteclauses(rewriteclause _rewriteclause_1, rewriteclauses _rewriteclauses_1) {
    rewriteclauses kc_x = new kc_tag_rewriteclauses(_rewriteclause_1, _rewriteclauses_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consrewriteclauses));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consrewriteclauses));
    kc_x->post_create();
    return static_cast<kc_tag_rewriteclauses*>(kc_x);
}

rewriteclause
RewriteClause(viewnames _viewnames_1, term _term_1) {
    rewriteclause kc_x = new kc_tag_rewriteclause_RewriteClause(_viewnames_1, _term_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_RewriteClause));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_RewriteClause));
    kc_x->post_create();
    return static_cast<kc_tag_rewriteclause_RewriteClause*>(kc_x);
}

patternchains
Nilpatternchains() {
    patternchains kc_x = new kc_tag_patternchains();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilpatternchains));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilpatternchains));
    kc_x->post_create();
    kc_x = kc_initialize_patternchains(kc_x);
    return static_cast<kc_tag_patternchains*>(kc_x);
}

patternchains
Conspatternchains(patternchain _patternchain_1, patternchains _patternchains_1) {
    patternchains kc_x = new kc_tag_patternchains(_patternchain_1, _patternchains_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Conspatternchains));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Conspatternchains));
    kc_x->post_create();
    kc_x = kc_initialize_patternchains(kc_x);
    return static_cast<kc_tag_patternchains*>(kc_x);
}

patternchain
Nilpatternchain() {
    patternchain kc_x = new kc_tag_patternchain();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilpatternchain));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilpatternchain));
    kc_x->post_create();
    kc_x = kc_initialize_patternchain(kc_x);
    return static_cast<kc_tag_patternchain*>(kc_x);
}

patternchain
Conspatternchain(patternchainitem _patternchainitem_1, patternchain _patternchain_1) {
    patternchain kc_x = new kc_tag_patternchain(_patternchainitem_1, _patternchain_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Conspatternchain));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Conspatternchain));
    kc_x->post_create();
    kc_x = kc_initialize_patternchain(kc_x);
    return static_cast<kc_tag_patternchain*>(kc_x);
}

outmostpatterns
Niloutmostpatterns() {
    outmostpatterns kc_x = new kc_tag_outmostpatterns();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Niloutmostpatterns));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Niloutmostpatterns));
    kc_x->post_create();
    return static_cast<kc_tag_outmostpatterns*>(kc_x);
}

outmostpatterns
Consoutmostpatterns(outmostpattern _outmostpattern_1, outmostpatterns _outmostpatterns_1) {
    outmostpatterns kc_x = new kc_tag_outmostpatterns(_outmostpattern_1, _outmostpatterns_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consoutmostpatterns));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consoutmostpatterns));
    kc_x->post_create();
    return static_cast<kc_tag_outmostpatterns*>(kc_x);
}

patternchainitem
PatternchainitemOutmost(outmostpattern _outmostpattern_1) {
    patternchainitem kc_x = new kc_tag_patternchainitem_PatternchainitemOutmost(_outmostpattern_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_PatternchainitemOutmost));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_PatternchainitemOutmost));
    kc_x->post_create();
    kc_x = kc_initialize_patternchainitem(kc_x);
    return static_cast<kc_tag_patternchainitem_PatternchainitemOutmost*>(kc_x);
}

patternchainitem
PatternchainitemGroup(patternchains _patternchains_1) {
    patternchainitem kc_x = new kc_tag_patternchainitem_PatternchainitemGroup(_patternchains_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_PatternchainitemGroup));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_PatternchainitemGroup));
    kc_x->post_create();
    kc_x = kc_initialize_patternchainitem(kc_x);
    return static_cast<kc_tag_patternchainitem_PatternchainitemGroup*>(kc_x);
}

patternchainitem
PatternchainitemDollarid(ID _ID_1) {
    patternchainitem kc_x = new kc_tag_patternchainitem_PatternchainitemDollarid(_ID_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_PatternchainitemDollarid));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_PatternchainitemDollarid));
    kc_x->post_create();
    kc_x = kc_initialize_patternchainitem(kc_x);
    return static_cast<kc_tag_patternchainitem_PatternchainitemDollarid*>(kc_x);
}

outmostpattern
OPOperatorWildcard(ID _ID_1, Cexpression _Cexpression_1) {
    outmostpattern kc_x = new kc_tag_outmostpattern_OPOperatorWildcard(_ID_1, _Cexpression_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_OPOperatorWildcard));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_OPOperatorWildcard));
    kc_x->post_create();
    kc_x = kc_initialize_outmostpattern(kc_x);
    return static_cast<kc_tag_outmostpattern_OPOperatorWildcard*>(kc_x);
}

outmostpattern
OPOperator(ID _ID_1, patterns _patterns_1, Cexpression _Cexpression_1) {
    outmostpattern kc_x = new kc_tag_outmostpattern_OPOperator(_ID_1, _patterns_1, _Cexpression_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_OPOperator));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_OPOperator));
    kc_x->post_create();
    kc_x = kc_initialize_outmostpattern(kc_x);
    return static_cast<kc_tag_outmostpattern_OPOperator*>(kc_x);
}

outmostpattern
OPNonLeafVariable(ID _ID_1, outmostpattern _outmostpattern_1) {
    outmostpattern kc_x = new kc_tag_outmostpattern_OPNonLeafVariable(_ID_1, _outmostpattern_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_OPNonLeafVariable));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_OPNonLeafVariable));
    kc_x->post_create();
    kc_x = kc_initialize_outmostpattern(kc_x);
    return static_cast<kc_tag_outmostpattern_OPNonLeafVariable*>(kc_x);
}

outmostpattern
OPWildcard(Cexpression _Cexpression_1) {
    outmostpattern kc_x = new kc_tag_outmostpattern_OPWildcard(_Cexpression_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_OPWildcard));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_OPWildcard));
    kc_x->post_create();
    kc_x = kc_initialize_outmostpattern(kc_x);
    return static_cast<kc_tag_outmostpattern_OPWildcard*>(kc_x);
}

outmostpattern
OPDefault(Cexpression _Cexpression_1) {
    outmostpattern kc_x = new kc_tag_outmostpattern_OPDefault(_Cexpression_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_OPDefault));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_OPDefault));
    kc_x->post_create();
    kc_x = kc_initialize_outmostpattern(kc_x);
    return static_cast<kc_tag_outmostpattern_OPDefault*>(kc_x);
}

pattern
PVariable(ID _ID_1) {
    pattern kc_x = new kc_tag_pattern_PVariable(_ID_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_PVariable));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_PVariable));
    kc_x->post_create();
    return static_cast<kc_tag_pattern_PVariable*>(kc_x);
}

pattern
POperator(ID _ID_1, patterns _patterns_1) {
    pattern kc_x = new kc_tag_pattern_POperator(_ID_1, _patterns_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_POperator));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_POperator));
    kc_x->post_create();
    return static_cast<kc_tag_pattern_POperator*>(kc_x);
}

pattern
PNonLeafVariable(ID _ID_1, pattern _pattern_1) {
    pattern kc_x = new kc_tag_pattern_PNonLeafVariable(_ID_1, _pattern_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_PNonLeafVariable));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_PNonLeafVariable));
    kc_x->post_create();
    return static_cast<kc_tag_pattern_PNonLeafVariable*>(kc_x);
}

pattern
PWildcard() {
    pattern kc_x = new kc_tag_pattern_PWildcard();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_PWildcard));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_PWildcard));
    kc_x->post_create();
    return static_cast<kc_tag_pattern_PWildcard*>(kc_x);
}

pattern
PStringLiteral(CexpressionDQ _CexpressionDQ_1) {
    pattern kc_x = new kc_tag_pattern_PStringLiteral(_CexpressionDQ_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_PStringLiteral));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_PStringLiteral));
    kc_x->post_create();
    return static_cast<kc_tag_pattern_PStringLiteral*>(kc_x);
}

pattern
PIntLiteral(INT _INT_1) {
    pattern kc_x = new kc_tag_pattern_PIntLiteral(_INT_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_PIntLiteral));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_PIntLiteral));
    kc_x->post_create();
    return static_cast<kc_tag_pattern_PIntLiteral*>(kc_x);
}

patterns
Nilpatterns() {
    patterns kc_x = new kc_tag_patterns();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilpatterns));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilpatterns));
    kc_x->post_create();
    return static_cast<kc_tag_patterns*>(kc_x);
}

patterns
Conspatterns(pattern _pattern_1, patterns _patterns_1) {
    patterns kc_x = new kc_tag_patterns(_pattern_1, _patterns_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Conspatterns));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Conspatterns));
    kc_x->post_create();
    return static_cast<kc_tag_patterns*>(kc_x);
}

term
TVariable(ID _ID_1) {
    term kc_x = new kc_tag_term_TVariable(_ID_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_TVariable));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_TVariable));
    kc_x->post_create();
    kc_x = kc_initialize_term(kc_x);
    return static_cast<kc_tag_term_TVariable*>(kc_x);
}

term
TOperator(ID _ID_1, terms _terms_1) {
    term kc_x = new kc_tag_term_TOperator(_ID_1, _terms_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_TOperator));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_TOperator));
    kc_x->post_create();
    kc_x = kc_initialize_term(kc_x);
    return static_cast<kc_tag_term_TOperator*>(kc_x);
}

term
TMethod(term _term_1, ID _ID_1, terms _terms_1) {
    term kc_x = new kc_tag_term_TMethod(_term_1, _ID_1, _terms_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_TMethod));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_TMethod));
    kc_x->post_create();
    kc_x = kc_initialize_term(kc_x);
    return static_cast<kc_tag_term_TMethod*>(kc_x);
}

term
TCTerm(CexpressionSQ _CexpressionSQ_1) {
    term kc_x = new kc_tag_term_TCTerm(_CexpressionSQ_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_TCTerm));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_TCTerm));
    kc_x->post_create();
    kc_x = kc_initialize_term(kc_x);
    return static_cast<kc_tag_term_TCTerm*>(kc_x);
}

term
TStringLiteral(CexpressionDQ _CexpressionDQ_1) {
    term kc_x = new kc_tag_term_TStringLiteral(_CexpressionDQ_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_TStringLiteral));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_TStringLiteral));
    kc_x->post_create();
    kc_x = kc_initialize_term(kc_x);
    return static_cast<kc_tag_term_TStringLiteral*>(kc_x);
}

term
TIntLiteral(INT _INT_1) {
    term kc_x = new kc_tag_term_TIntLiteral(_INT_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_TIntLiteral));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_TIntLiteral));
    kc_x->post_create();
    kc_x = kc_initialize_term(kc_x);
    return static_cast<kc_tag_term_TIntLiteral*>(kc_x);
}

terms
Nilterms() {
    terms kc_x = new kc_tag_terms();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilterms));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilterms));
    kc_x->post_create();
    return static_cast<kc_tag_terms*>(kc_x);
}

terms
Consterms(term _term_1, terms _terms_1) {
    terms kc_x = new kc_tag_terms(_term_1, _terms_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consterms));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consterms));
    kc_x->post_create();
    return static_cast<kc_tag_terms*>(kc_x);
}

fnfiles
Nilfnfiles() {
    fnfiles kc_x = new kc_tag_fnfiles();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilfnfiles));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilfnfiles));
    kc_x->post_create();
    return static_cast<kc_tag_fnfiles*>(kc_x);
}

fnfiles
Consfnfiles(fnfile _fnfile_1, fnfiles _fnfiles_1) {
    fnfiles kc_x = new kc_tag_fnfiles(_fnfile_1, _fnfiles_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consfnfiles));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consfnfiles));
    kc_x->post_create();
    return static_cast<kc_tag_fnfiles*>(kc_x);
}

fnfile
FnFile(casestring _casestring_1) {
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_FnFile));
    fnfile kc_x=new kc_tag_fnfile_FnFile(_casestring_1);
    fnfile unique_kc_x= kc_hashtables[uniq]->kc_ht_check_insert(kc_x);
    if(unique_kc_x!=kc_x) {
	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_FnFile));
	kc_x->post_create();
	kc_x = kc_initialize_fnfile(kc_x);
    }
    return static_cast<kc_tag_fnfile_FnFile*>(kc_x);
}

fndeclarations
Nilfndeclarations() {
    fndeclarations kc_x = new kc_tag_fndeclarations();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilfndeclarations));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilfndeclarations));
    kc_x->post_create();
    return static_cast<kc_tag_fndeclarations*>(kc_x);
}

fndeclarations
Consfndeclarations(fndeclaration _fndeclaration_1, fndeclarations _fndeclarations_1) {
    fndeclarations kc_x = new kc_tag_fndeclarations(_fndeclaration_1, _fndeclarations_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consfndeclarations));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consfndeclarations));
    kc_x->post_create();
    return static_cast<kc_tag_fndeclarations*>(kc_x);
}

fndeclaration
FnAcDeclaration(ac_declaration_specifiers _ac_declaration_specifiers_1, ac_declarator _ac_declarator_1, ac_declaration_list _ac_declaration_list_1, ac_opt_base_init_list _ac_opt_base_init_list_1, Ctext _Ctext_1, ID _ID_1, fnclass _fnclass_1) {
    fndeclaration kc_x = new kc_tag_fndeclaration_FnAcDeclaration(_ac_declaration_specifiers_1, _ac_declarator_1, _ac_declaration_list_1, _ac_opt_base_init_list_1, _Ctext_1, _ID_1, _fnclass_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_FnAcDeclaration));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_FnAcDeclaration));
    kc_x->post_create();
    kc_x = kc_initialize_fndeclaration(kc_x);
    return static_cast<kc_tag_fndeclaration_FnAcDeclaration*>(kc_x);
}

fndeclaration
AcMemberDeclaration(ac_declaration_specifiers _ac_declaration_specifiers_1, ac_declarator _ac_declarator_1, ac_constant_expression_option _ac_constant_expression_option_1, fnclass _fnclass_1) {
    fndeclaration kc_x = new kc_tag_fndeclaration_AcMemberDeclaration(_ac_declaration_specifiers_1, _ac_declarator_1, _ac_constant_expression_option_1, _fnclass_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcMemberDeclaration));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcMemberDeclaration));
    kc_x->post_create();
    kc_x = kc_initialize_fndeclaration(kc_x);
    return static_cast<kc_tag_fndeclaration_AcMemberDeclaration*>(kc_x);
}

fnclass
GlobalFn() {
    fnclass kc_x = new kc_tag_fnclass_GlobalFn();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_GlobalFn));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_GlobalFn));
    kc_x->post_create();
    return static_cast<kc_tag_fnclass_GlobalFn*>(kc_x);
}

fnclass
StaticFn(casestring _casestring_1) {
    fnclass kc_x = new kc_tag_fnclass_StaticFn(_casestring_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_StaticFn));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_StaticFn));
    kc_x->post_create();
    return static_cast<kc_tag_fnclass_StaticFn*>(kc_x);
}

fnclass
MemberFn() {
    fnclass kc_x = new kc_tag_fnclass_MemberFn();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_MemberFn));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_MemberFn));
    kc_x->post_create();
    return static_cast<kc_tag_fnclass_MemberFn*>(kc_x);
}

fnclass
ConstructorFn() {
    fnclass kc_x = new kc_tag_fnclass_ConstructorFn();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstructorFn));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstructorFn));
    kc_x->post_create();
    return static_cast<kc_tag_fnclass_ConstructorFn*>(kc_x);
}

fnclass
DestructorFn() {
    fnclass kc_x = new kc_tag_fnclass_DestructorFn();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_DestructorFn));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_DestructorFn));
    kc_x->post_create();
    return static_cast<kc_tag_fnclass_DestructorFn*>(kc_x);
}

Ctext
NilCtext() {
    Ctext kc_x = new kc_tag_Ctext();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NilCtext));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NilCtext));
    kc_x->post_create();
    kc_x = kc_initialize_Ctext(kc_x);
    return static_cast<kc_tag_Ctext*>(kc_x);
}

Ctext
ConsCtext(Ctext_elem _Ctext_elem_1, Ctext _Ctext_1) {
    Ctext kc_x = new kc_tag_Ctext(_Ctext_elem_1, _Ctext_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConsCtext));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConsCtext));
    kc_x->post_create();
    kc_x = kc_initialize_Ctext(kc_x);
    return static_cast<kc_tag_Ctext*>(kc_x);
}

Ctext_elem
CTextLine(casestring _casestring_1) {
    Ctext_elem kc_x = new kc_tag_Ctext_elem_CTextLine(_casestring_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CTextLine));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CTextLine));
    kc_x->post_create();
    kc_x = kc_initialize_Ctext_elem(kc_x);
    return static_cast<kc_tag_Ctext_elem_CTextLine*>(kc_x);
}

Ctext_elem
CTextDollarVar(INT _INT_1) {
    Ctext_elem kc_x = new kc_tag_Ctext_elem_CTextDollarVar(_INT_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CTextDollarVar));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CTextDollarVar));
    kc_x->post_create();
    kc_x = kc_initialize_Ctext_elem(kc_x);
    return static_cast<kc_tag_Ctext_elem_CTextDollarVar*>(kc_x);
}

Ctext_elem
CTextNl(integer _integer_1) {
    Ctext_elem kc_x = new kc_tag_Ctext_elem_CTextNl(_integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CTextNl));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CTextNl));
    kc_x->post_create();
    kc_x = kc_initialize_Ctext_elem(kc_x);
    return static_cast<kc_tag_Ctext_elem_CTextNl*>(kc_x);
}

Ctext_elem
CTextCexpressionDQ(CexpressionDQ _CexpressionDQ_1) {
    Ctext_elem kc_x = new kc_tag_Ctext_elem_CTextCexpressionDQ(_CexpressionDQ_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CTextCexpressionDQ));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CTextCexpressionDQ));
    kc_x->post_create();
    kc_x = kc_initialize_Ctext_elem(kc_x);
    return static_cast<kc_tag_Ctext_elem_CTextCexpressionDQ*>(kc_x);
}

Ctext_elem
CTextCexpressionSQ(CexpressionSQ _CexpressionSQ_1) {
    Ctext_elem kc_x = new kc_tag_Ctext_elem_CTextCexpressionSQ(_CexpressionSQ_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CTextCexpressionSQ));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CTextCexpressionSQ));
    kc_x->post_create();
    kc_x = kc_initialize_Ctext_elem(kc_x);
    return static_cast<kc_tag_Ctext_elem_CTextCexpressionSQ*>(kc_x);
}

Ctext_elem
CTextCbody(Ctext _Ctext_1) {
    Ctext_elem kc_x = new kc_tag_Ctext_elem_CTextCbody(_Ctext_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CTextCbody));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CTextCbody));
    kc_x->post_create();
    kc_x = kc_initialize_Ctext_elem(kc_x);
    return static_cast<kc_tag_Ctext_elem_CTextCbody*>(kc_x);
}

Ctext_elem
CTextForeachexpression(patternchain _patternchain_1, idCexpressions _idCexpressions_1, withexpressions _withexpressions_1, Ctext _Ctext_1, foreach_after _foreach_after_1) {
    Ctext_elem kc_x = new kc_tag_Ctext_elem_CTextForeachexpression(_patternchain_1, _idCexpressions_1, _withexpressions_1, _Ctext_1, _foreach_after_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CTextForeachexpression));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CTextForeachexpression));
    kc_x->post_create();
    kc_x = kc_initialize_Ctext_elem(kc_x);
    return static_cast<kc_tag_Ctext_elem_CTextForeachexpression*>(kc_x);
}

Ctext_elem
CTextWithexpression(withexpressions _withexpressions_1, withcases _withcases_1, contextinfo _contextinfo_1) {
    Ctext_elem kc_x = new kc_tag_Ctext_elem_CTextWithexpression(_withexpressions_1, _withcases_1, _contextinfo_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CTextWithexpression));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CTextWithexpression));
    kc_x->post_create();
    kc_x = kc_initialize_Ctext_elem(kc_x);
    return static_cast<kc_tag_Ctext_elem_CTextWithexpression*>(kc_x);
}

foreach_after
NoForeachAfter() {
    foreach_after kc_x = new kc_tag_foreach_after_NoForeachAfter();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NoForeachAfter));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NoForeachAfter));
    kc_x->post_create();
    kc_x = kc_initialize_foreach_after(kc_x);
    return static_cast<kc_tag_foreach_after_NoForeachAfter*>(kc_x);
}

foreach_after
ForeachAfter(patternchain _patternchain_1, idCexpressions _idCexpressions_1, withexpressions _withexpressions_1, Ctext _Ctext_1) {
    foreach_after kc_x = new kc_tag_foreach_after_ForeachAfter(_patternchain_1, _idCexpressions_1, _withexpressions_1, _Ctext_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ForeachAfter));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ForeachAfter));
    kc_x->post_create();
    kc_x = kc_initialize_foreach_after(kc_x);
    return static_cast<kc_tag_foreach_after_ForeachAfter*>(kc_x);
}

contextinfo
InForeachContext(patternchain _patternchain_1) {
    contextinfo kc_x = new kc_tag_contextinfo_InForeachContext(_patternchain_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_InForeachContext));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_InForeachContext));
    kc_x->post_create();
    return static_cast<kc_tag_contextinfo_InForeachContext*>(kc_x);
}

contextinfo
NotInForeachContext() {
    contextinfo kc_x = new kc_tag_contextinfo_NotInForeachContext();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NotInForeachContext));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NotInForeachContext));
    kc_x->post_create();
    return static_cast<kc_tag_contextinfo_NotInForeachContext*>(kc_x);
}

withexpressions
Nilwithexpressions() {
    withexpressions kc_x = new kc_tag_withexpressions();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilwithexpressions));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilwithexpressions));
    kc_x->post_create();
    kc_x = kc_initialize_withexpressions(kc_x);
    return static_cast<kc_tag_withexpressions*>(kc_x);
}

withexpressions
Conswithexpressions(withexpression _withexpression_1, withexpressions _withexpressions_1) {
    withexpressions kc_x = new kc_tag_withexpressions(_withexpression_1, _withexpressions_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Conswithexpressions));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Conswithexpressions));
    kc_x->post_create();
    kc_x = kc_initialize_withexpressions(kc_x);
    return static_cast<kc_tag_withexpressions*>(kc_x);
}

withexpression
WEVariable(ID _ID_1) {
    withexpression kc_x = new kc_tag_withexpression_WEVariable(_ID_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_WEVariable));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_WEVariable));
    kc_x->post_create();
    kc_x = kc_initialize_withexpression(kc_x);
    return static_cast<kc_tag_withexpression_WEVariable*>(kc_x);
}

withexpression
WECexpression(Cexpression _Cexpression_1) {
    withexpression kc_x = new kc_tag_withexpression_WECexpression(_Cexpression_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_WECexpression));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_WECexpression));
    kc_x->post_create();
    kc_x = kc_initialize_withexpression(kc_x);
    return static_cast<kc_tag_withexpression_WECexpression*>(kc_x);
}

withcases
Nilwithcases() {
    withcases kc_x = new kc_tag_withcases();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilwithcases));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilwithcases));
    kc_x->post_create();
    return static_cast<kc_tag_withcases*>(kc_x);
}

withcases
Conswithcases(withcase _withcase_1, withcases _withcases_1) {
    withcases kc_x = new kc_tag_withcases(_withcase_1, _withcases_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Conswithcases));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Conswithcases));
    kc_x->post_create();
    return static_cast<kc_tag_withcases*>(kc_x);
}

withcase
Withcase(patternchains _patternchains_1, Ctext _Ctext_1) {
    withcase kc_x = new kc_tag_withcase_Withcase(_patternchains_1, _Ctext_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Withcase));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Withcase));
    kc_x->post_create();
    return static_cast<kc_tag_withcase_Withcase*>(kc_x);
}

unparsedeclarations
Nilunparsedeclarations() {
    unparsedeclarations kc_x = new kc_tag_unparsedeclarations();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilunparsedeclarations));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilunparsedeclarations));
    kc_x->post_create();
    return static_cast<kc_tag_unparsedeclarations*>(kc_x);
}

unparsedeclarations
Consunparsedeclarations(unparsedeclaration _unparsedeclaration_1, unparsedeclarations _unparsedeclarations_1) {
    unparsedeclarations kc_x = new kc_tag_unparsedeclarations(_unparsedeclaration_1, _unparsedeclarations_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consunparsedeclarations));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consunparsedeclarations));
    kc_x->post_create();
    return static_cast<kc_tag_unparsedeclarations*>(kc_x);
}

unparsedeclaration
UnparseDeclaration(outmostpatterns _outmostpatterns_1, unparseclauses _unparseclauses_1) {
    unparsedeclaration kc_x = new kc_tag_unparsedeclaration_UnparseDeclaration(_outmostpatterns_1, _unparseclauses_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_UnparseDeclaration));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_UnparseDeclaration));
    kc_x->post_create();
    return static_cast<kc_tag_unparsedeclaration_UnparseDeclaration*>(kc_x);
}

unparseclauses
Nilunparseclauses() {
    unparseclauses kc_x = new kc_tag_unparseclauses();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilunparseclauses));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilunparseclauses));
    kc_x->post_create();
    return static_cast<kc_tag_unparseclauses*>(kc_x);
}

unparseclauses
Consunparseclauses(unparseclause _unparseclause_1, unparseclauses _unparseclauses_1) {
    unparseclauses kc_x = new kc_tag_unparseclauses(_unparseclause_1, _unparseclauses_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consunparseclauses));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consunparseclauses));
    kc_x->post_create();
    return static_cast<kc_tag_unparseclauses*>(kc_x);
}

unparseclause
UnparseClause(viewnames _viewnames_1, unparseitems _unparseitems_1) {
    unparseclause kc_x = new kc_tag_unparseclause_UnparseClause(_viewnames_1, _unparseitems_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_UnparseClause));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_UnparseClause));
    kc_x->post_create();
    return static_cast<kc_tag_unparseclause_UnparseClause*>(kc_x);
}

viewnames
Nilviewnames() {
    viewnames kc_x = new kc_tag_viewnames();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilviewnames));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilviewnames));
    kc_x->post_create();
    kc_x = kc_initialize_viewnames(kc_x);
    return static_cast<kc_tag_viewnames*>(kc_x);
}

viewnames
Consviewnames(ID _ID_1, viewnames _viewnames_1) {
    viewnames kc_x = new kc_tag_viewnames(_ID_1, _viewnames_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consviewnames));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consviewnames));
    kc_x->post_create();
    kc_x = kc_initialize_viewnames(kc_x);
    return static_cast<kc_tag_viewnames*>(kc_x);
}

unparseitems
Nilunparseitems() {
    unparseitems kc_x = new kc_tag_unparseitems();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilunparseitems));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilunparseitems));
    kc_x->post_create();
    return static_cast<kc_tag_unparseitems*>(kc_x);
}

unparseitems
Consunparseitems(unparseitem _unparseitem_1, unparseitems _unparseitems_1) {
    unparseitems kc_x = new kc_tag_unparseitems(_unparseitem_1, _unparseitems_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consunparseitems));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consunparseitems));
    kc_x->post_create();
    return static_cast<kc_tag_unparseitems*>(kc_x);
}

unparseitem
UnpStr(languageoption _languageoption_1, CexpressionDQ _CexpressionDQ_1, viewnameoption _viewnameoption_1) {
    unparseitem kc_x = new kc_tag_unparseitem_UnpStr(_languageoption_1, _CexpressionDQ_1, _viewnameoption_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_UnpStr));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_UnpStr));
    kc_x->post_create();
    kc_x = kc_initialize_unparseitem(kc_x);
    return static_cast<kc_tag_unparseitem_UnpStr*>(kc_x);
}

unparseitem
UnpSubexpr(languageoption _languageoption_1, unpsubterm _unpsubterm_1, viewnameoption _viewnameoption_1) {
    unparseitem kc_x = new kc_tag_unparseitem_UnpSubexpr(_languageoption_1, _unpsubterm_1, _viewnameoption_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_UnpSubexpr));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_UnpSubexpr));
    kc_x->post_create();
    kc_x = kc_initialize_unparseitem(kc_x);
    return static_cast<kc_tag_unparseitem_UnpSubexpr*>(kc_x);
}

unparseitem
UnpCtext(languageoption _languageoption_1, Ctext _Ctext_1) {
    unparseitem kc_x = new kc_tag_unparseitem_UnpCtext(_languageoption_1, _Ctext_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_UnpCtext));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_UnpCtext));
    kc_x->post_create();
    kc_x = kc_initialize_unparseitem(kc_x);
    return static_cast<kc_tag_unparseitem_UnpCtext*>(kc_x);
}

unparseitem
UnpBody(languageoption _languageoption_1, unparseitems _unparseitems_1) {
    unparseitem kc_x = new kc_tag_unparseitem_UnpBody(_languageoption_1, _unparseitems_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_UnpBody));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_UnpBody));
    kc_x->post_create();
    kc_x = kc_initialize_unparseitem(kc_x);
    return static_cast<kc_tag_unparseitem_UnpBody*>(kc_x);
}

unparseitem
UViewVarDecl(ID _ID_1, ID _ID_2, Cexpression _Cexpression_1) {
    unparseitem kc_x = new kc_tag_unparseitem_UViewVarDecl(_ID_1, _ID_2, _Cexpression_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_UViewVarDecl));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_UViewVarDecl));
    kc_x->post_create();
    kc_x = kc_initialize_unparseitem(kc_x);
    return static_cast<kc_tag_unparseitem_UViewVarDecl*>(kc_x);
}

unpsubterm
UnpSubTerm(ID _ID_1) {
    unpsubterm kc_x = new kc_tag_unpsubterm_UnpSubTerm(_ID_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_UnpSubTerm));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_UnpSubTerm));
    kc_x->post_create();
    return static_cast<kc_tag_unpsubterm_UnpSubTerm*>(kc_x);
}

unpsubterm
UnpDollarvarTerm(INT _INT_1) {
    unpsubterm kc_x = new kc_tag_unpsubterm_UnpDollarvarTerm(_INT_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_UnpDollarvarTerm));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_UnpDollarvarTerm));
    kc_x->post_create();
    return static_cast<kc_tag_unpsubterm_UnpDollarvarTerm*>(kc_x);
}

unpsubterm
UnpSubAttr(ID _ID_1, unpattributes _unpattributes_1) {
    unpsubterm kc_x = new kc_tag_unpsubterm_UnpSubAttr(_ID_1, _unpattributes_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_UnpSubAttr));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_UnpSubAttr));
    kc_x->post_create();
    return static_cast<kc_tag_unpsubterm_UnpSubAttr*>(kc_x);
}

unpsubterm
UnpDollarvarAttr(INT _INT_1, unpattributes _unpattributes_1) {
    unpsubterm kc_x = new kc_tag_unpsubterm_UnpDollarvarAttr(_INT_1, _unpattributes_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_UnpDollarvarAttr));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_UnpDollarvarAttr));
    kc_x->post_create();
    return static_cast<kc_tag_unpsubterm_UnpDollarvarAttr*>(kc_x);
}

unpsubterm
UnpCastedVariable(ID _ID_1, ID _ID_2) {
    unpsubterm kc_x = new kc_tag_unpsubterm_UnpCastedVariable(_ID_1, _ID_2);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_UnpCastedVariable));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_UnpCastedVariable));
    kc_x->post_create();
    return static_cast<kc_tag_unpsubterm_UnpCastedVariable*>(kc_x);
}

unpattributes
Nilunpattributes() {
    unpattributes kc_x = new kc_tag_unpattributes();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilunpattributes));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilunpattributes));
    kc_x->post_create();
    return static_cast<kc_tag_unpattributes*>(kc_x);
}

unpattributes
Consunpattributes(ID _ID_1, unpattributes _unpattributes_1) {
    unpattributes kc_x = new kc_tag_unpattributes(_ID_1, _unpattributes_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consunpattributes));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consunpattributes));
    kc_x->post_create();
    return static_cast<kc_tag_unpattributes*>(kc_x);
}

viewnameoption
NoViewname() {
    viewnameoption kc_x = new kc_tag_viewnameoption_NoViewname();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NoViewname));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NoViewname));
    kc_x->post_create();
    return static_cast<kc_tag_viewnameoption_NoViewname*>(kc_x);
}

viewnameoption
YesViewname(ID _ID_1) {
    viewnameoption kc_x = new kc_tag_viewnameoption_YesViewname(_ID_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_YesViewname));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_YesViewname));
    kc_x->post_create();
    return static_cast<kc_tag_viewnameoption_YesViewname*>(kc_x);
}

languageoption
NoLanguagename() {
    languageoption kc_x = new kc_tag_languageoption_NoLanguagename();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NoLanguagename));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NoLanguagename));
    kc_x->post_create();
    return static_cast<kc_tag_languageoption_NoLanguagename*>(kc_x);
}

languageoption
LanguageList(languagenames _languagenames_1) {
    languageoption kc_x = new kc_tag_languageoption_LanguageList(_languagenames_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_LanguageList));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_LanguageList));
    kc_x->post_create();
    return static_cast<kc_tag_languageoption_LanguageList*>(kc_x);
}

languagenames
Nillanguagenames() {
    languagenames kc_x = new kc_tag_languagenames();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nillanguagenames));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nillanguagenames));
    kc_x->post_create();
    return static_cast<kc_tag_languagenames*>(kc_x);
}

languagenames
Conslanguagenames(ID _ID_1, languagenames _languagenames_1) {
    languagenames kc_x = new kc_tag_languagenames(_ID_1, _languagenames_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Conslanguagenames));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Conslanguagenames));
    kc_x->post_create();
    return static_cast<kc_tag_languagenames*>(kc_x);
}

fileline
FileLine(casestring _file, int _line) {
    fileline kc_x = new kc_tag_fileline_FileLine(_file, _line);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_FileLine));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_FileLine));
    kc_x->post_create();
    return static_cast<kc_tag_fileline_FileLine*>(kc_x);
}

fileline
NoFileLine() {
    fileline kc_x = new kc_tag_fileline_NoFileLine();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NoFileLine));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NoFileLine));
    kc_x->post_create();
    return static_cast<kc_tag_fileline_NoFileLine*>(kc_x);
}

fileline
PosNoFileLine() {
    fileline kc_x = new kc_tag_fileline_PosNoFileLine();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_PosNoFileLine));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_PosNoFileLine));
    kc_x->post_create();
    return static_cast<kc_tag_fileline_PosNoFileLine*>(kc_x);
}

scopetypefilelinestack
Nilscopetypefilelinestack() {
    scopetypefilelinestack kc_x = new kc_tag_scopetypefilelinestack();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilscopetypefilelinestack));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilscopetypefilelinestack));
    kc_x->post_create();
    return static_cast<kc_tag_scopetypefilelinestack*>(kc_x);
}

scopetypefilelinestack
Consscopetypefilelinestack(scopetypefileline _scopetypefileline_1, scopetypefilelinestack _scopetypefilelinestack_1) {
    scopetypefilelinestack kc_x = new kc_tag_scopetypefilelinestack(_scopetypefileline_1, _scopetypefilelinestack_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consscopetypefilelinestack));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consscopetypefilelinestack));
    kc_x->post_create();
    return static_cast<kc_tag_scopetypefilelinestack*>(kc_x);
}

scopetypefileline
ScopeTypeFileLine(integer _integer_1, IDtype _IDtype_1, casestring _casestring_1, integer _integer_2) {
    scopetypefileline kc_x = new kc_tag_scopetypefileline_ScopeTypeFileLine(_integer_1, _IDtype_1, _casestring_1, _integer_2);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ScopeTypeFileLine));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ScopeTypeFileLine));
    kc_x->post_create();
    return static_cast<kc_tag_scopetypefileline_ScopeTypeFileLine*>(kc_x);
}

IDtype
ITUnknown() {
    IDtype kc_x = new kc_tag_IDtype_ITUnknown();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ITUnknown));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ITUnknown));
    kc_x->post_create();
    return static_cast<kc_tag_IDtype_ITUnknown*>(kc_x);
}

IDtype
ITPredefinedPhylum(phylumdeclaration _phylumdeclaration_1) {
    IDtype kc_x = new kc_tag_IDtype_ITPredefinedPhylum(_phylumdeclaration_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ITPredefinedPhylum));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ITPredefinedPhylum));
    kc_x->post_create();
    return static_cast<kc_tag_IDtype_ITPredefinedPhylum*>(kc_x);
}

IDtype
ITUserPhylum(phylumdeclaration _phylumdeclaration_1) {
    IDtype kc_x = new kc_tag_IDtype_ITUserPhylum(_phylumdeclaration_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ITUserPhylum));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ITUserPhylum));
    kc_x->post_create();
    return static_cast<kc_tag_IDtype_ITUserPhylum*>(kc_x);
}

IDtype
ITPredefinedOperator(alternative _alternative_1, ID _ID_1) {
    IDtype kc_x = new kc_tag_IDtype_ITPredefinedOperator(_alternative_1, _ID_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ITPredefinedOperator));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ITPredefinedOperator));
    kc_x->post_create();
    return static_cast<kc_tag_IDtype_ITPredefinedOperator*>(kc_x);
}

IDtype
ITUserOperator(alternative _alternative_1, ID _ID_1) {
    IDtype kc_x = new kc_tag_IDtype_ITUserOperator(_alternative_1, _ID_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ITUserOperator));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ITUserOperator));
    kc_x->post_create();
    return static_cast<kc_tag_IDtype_ITUserOperator*>(kc_x);
}

IDtype
ITPredefinedStorageClass() {
    IDtype kc_x = new kc_tag_IDtype_ITPredefinedStorageClass();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ITPredefinedStorageClass));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ITPredefinedStorageClass));
    kc_x->post_create();
    return static_cast<kc_tag_IDtype_ITPredefinedStorageClass*>(kc_x);
}

IDtype
ITStorageClass() {
    IDtype kc_x = new kc_tag_IDtype_ITStorageClass();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ITStorageClass));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ITStorageClass));
    kc_x->post_create();
    return static_cast<kc_tag_IDtype_ITStorageClass*>(kc_x);
}

IDtype
ITPredefinedUView() {
    IDtype kc_x = new kc_tag_IDtype_ITPredefinedUView();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ITPredefinedUView));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ITPredefinedUView));
    kc_x->post_create();
    return static_cast<kc_tag_IDtype_ITPredefinedUView*>(kc_x);
}

IDtype
ITUserUView() {
    IDtype kc_x = new kc_tag_IDtype_ITUserUView();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ITUserUView));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ITUserUView));
    kc_x->post_create();
    return static_cast<kc_tag_IDtype_ITUserUView*>(kc_x);
}

IDtype
ITUViewVar() {
    IDtype kc_x = new kc_tag_IDtype_ITUViewVar();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ITUViewVar));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ITUViewVar));
    kc_x->post_create();
    return static_cast<kc_tag_IDtype_ITUViewVar*>(kc_x);
}

IDtype
ITPredefinedRView() {
    IDtype kc_x = new kc_tag_IDtype_ITPredefinedRView();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ITPredefinedRView));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ITPredefinedRView));
    kc_x->post_create();
    return static_cast<kc_tag_IDtype_ITPredefinedRView*>(kc_x);
}

IDtype
ITUserRView() {
    IDtype kc_x = new kc_tag_IDtype_ITUserRView();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ITUserRView));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ITUserRView));
    kc_x->post_create();
    return static_cast<kc_tag_IDtype_ITUserRView*>(kc_x);
}

IDtype
ITUserFunction(fnclass _fnclass_1) {
    IDtype kc_x = new kc_tag_IDtype_ITUserFunction(_fnclass_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ITUserFunction));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ITUserFunction));
    kc_x->post_create();
    return static_cast<kc_tag_IDtype_ITUserFunction*>(kc_x);
}

IDtype
ITPatternVariable(ID _ID_1, integer _integer_1) {
    IDtype kc_x = new kc_tag_IDtype_ITPatternVariable(_ID_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ITPatternVariable));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ITPatternVariable));
    kc_x->post_create();
    return static_cast<kc_tag_IDtype_ITPatternVariable*>(kc_x);
}

IDtype
ITLanguageName(integer _integer_1) {
    IDtype kc_x = new kc_tag_IDtype_ITLanguageName(_integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ITLanguageName));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ITLanguageName));
    kc_x->post_create();
    return static_cast<kc_tag_IDtype_ITLanguageName*>(kc_x);
}

operators
Niloperators() {
    operators kc_x = new kc_tag_operators();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Niloperators));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Niloperators));
    kc_x->post_create();
    return static_cast<kc_tag_operators*>(kc_x);
}

operators
Consoperators(ID _ID_1, operators _operators_1) {
    operators kc_x = new kc_tag_operators(_ID_1, _operators_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consoperators));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consoperators));
    kc_x->post_create();
    return static_cast<kc_tag_operators*>(kc_x);
}

phyla
Nilphyla() {
    phyla kc_x = new kc_tag_phyla();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilphyla));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilphyla));
    kc_x->post_create();
    return static_cast<kc_tag_phyla*>(kc_x);
}

phyla
Consphyla(ID _ID_1, phyla _phyla_1) {
    phyla kc_x = new kc_tag_phyla(_ID_1, _phyla_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consphyla));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consphyla));
    kc_x->post_create();
    return static_cast<kc_tag_phyla*>(kc_x);
}

variables
Nilvariables() {
    variables kc_x = new kc_tag_variables();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilvariables));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilvariables));
    kc_x->post_create();
    return static_cast<kc_tag_variables*>(kc_x);
}

variables
Consvariables(ID _ID_1, variables _variables_1) {
    variables kc_x = new kc_tag_variables(_ID_1, _variables_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consvariables));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consvariables));
    kc_x->post_create();
    return static_cast<kc_tag_variables*>(kc_x);
}

dollarvarstatus
DVAllowed() {
    dollarvarstatus kc_x = new kc_tag_dollarvarstatus_DVAllowed();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_DVAllowed));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_DVAllowed));
    kc_x->post_create();
    return static_cast<kc_tag_dollarvarstatus_DVAllowed*>(kc_x);
}

dollarvarstatus
DVDisallowed() {
    dollarvarstatus kc_x = new kc_tag_dollarvarstatus_DVDisallowed();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_DVDisallowed));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_DVDisallowed));
    kc_x->post_create();
    return static_cast<kc_tag_dollarvarstatus_DVDisallowed*>(kc_x);
}

two_phyla
TwoStorageoption(storageoption _storageoption_1, storageoption _storageoption_2) {
    two_phyla kc_x = new kc_tag_two_phyla_TwoStorageoption(_storageoption_1, _storageoption_2);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_TwoStorageoption));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_TwoStorageoption));
    kc_x->post_create();
    return static_cast<kc_tag_two_phyla_TwoStorageoption*>(kc_x);
}

two_phyla
TwoProductionblock(productionblock _productionblock_1, productionblock _productionblock_2) {
    two_phyla kc_x = new kc_tag_two_phyla_TwoProductionblock(_productionblock_1, _productionblock_2);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_TwoProductionblock));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_TwoProductionblock));
    kc_x->post_create();
    return static_cast<kc_tag_two_phyla_TwoProductionblock*>(kc_x);
}

two_phyla
TwoCcode_option(Ccode_option _Ccode_option_1, Ccode_option _Ccode_option_2) {
    two_phyla kc_x = new kc_tag_two_phyla_TwoCcode_option(_Ccode_option_1, _Ccode_option_2);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_TwoCcode_option));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_TwoCcode_option));
    kc_x->post_create();
    return static_cast<kc_tag_two_phyla_TwoCcode_option*>(kc_x);
}

two_phyla
TwoRewriteruleinfo(rewriteruleinfo _rewriteruleinfo_1, rewriteruleinfo _rewriteruleinfo_2) {
    two_phyla kc_x = new kc_tag_two_phyla_TwoRewriteruleinfo(_rewriteruleinfo_1, _rewriteruleinfo_2);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_TwoRewriteruleinfo));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_TwoRewriteruleinfo));
    kc_x->post_create();
    return static_cast<kc_tag_two_phyla_TwoRewriteruleinfo*>(kc_x);
}

two_phyla
TwoWithcaseinfo(withcaseinfo _withcaseinfo_1, withcaseinfo _withcaseinfo_2) {
    two_phyla kc_x = new kc_tag_two_phyla_TwoWithcaseinfo(_withcaseinfo_1, _withcaseinfo_2);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_TwoWithcaseinfo));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_TwoWithcaseinfo));
    kc_x->post_create();
    return static_cast<kc_tag_two_phyla_TwoWithcaseinfo*>(kc_x);
}

two_phyla
TwoUnparsedeclinfo(unparsedeclinfo _unparsedeclinfo_1, unparsedeclinfo _unparsedeclinfo_2) {
    two_phyla kc_x = new kc_tag_two_phyla_TwoUnparsedeclinfo(_unparsedeclinfo_1, _unparsedeclinfo_2);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_TwoUnparsedeclinfo));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_TwoUnparsedeclinfo));
    kc_x->post_create();
    return static_cast<kc_tag_two_phyla_TwoUnparsedeclinfo*>(kc_x);
}

two_phyla
TwoPatternrepresentation(patternrepresentation _patternrepresentation_1, patternrepresentation _patternrepresentation_2) {
    two_phyla kc_x = new kc_tag_two_phyla_TwoPatternrepresentation(_patternrepresentation_1, _patternrepresentation_2);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_TwoPatternrepresentation));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_TwoPatternrepresentation));
    kc_x->post_create();
    return static_cast<kc_tag_two_phyla_TwoPatternrepresentation*>(kc_x);
}

two_phyla
TwoElem_patternrepresentation(elem_patternrepresentation _elem_patternrepresentation_1, elem_patternrepresentation _elem_patternrepresentation_2) {
    two_phyla kc_x = new kc_tag_two_phyla_TwoElem_patternrepresentation(_elem_patternrepresentation_1, _elem_patternrepresentation_2);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_TwoElem_patternrepresentation));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_TwoElem_patternrepresentation));
    kc_x->post_create();
    return static_cast<kc_tag_two_phyla_TwoElem_patternrepresentation*>(kc_x);
}

two_phyla
TwoPaths(paths _paths_1, paths _paths_2) {
    two_phyla kc_x = new kc_tag_two_phyla_TwoPaths(_paths_1, _paths_2);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_TwoPaths));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_TwoPaths));
    kc_x->post_create();
    return static_cast<kc_tag_two_phyla_TwoPaths*>(kc_x);
}

two_phyla
TwoPath(path _path_1, path _path_2) {
    two_phyla kc_x = new kc_tag_two_phyla_TwoPath(_path_1, _path_2);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_TwoPath));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_TwoPath));
    kc_x->post_create();
    return static_cast<kc_tag_two_phyla_TwoPath*>(kc_x);
}

tribool
Equal() {
    tribool kc_x = new kc_tag_tribool_Equal();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Equal));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Equal));
    kc_x->post_create();
    return static_cast<kc_tag_tribool_Equal*>(kc_x);
}

tribool
Smaller() {
    tribool kc_x = new kc_tag_tribool_Smaller();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Smaller));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Smaller));
    kc_x->post_create();
    return static_cast<kc_tag_tribool_Smaller*>(kc_x);
}

tribool
Bigger() {
    tribool kc_x = new kc_tag_tribool_Bigger();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Bigger));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Bigger));
    kc_x->post_create();
    return static_cast<kc_tag_tribool_Bigger*>(kc_x);
}

patternrepresentations
Nilpatternrepresentations() {
    patternrepresentations kc_x = new kc_tag_patternrepresentations();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilpatternrepresentations));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilpatternrepresentations));
    kc_x->post_create();
    return static_cast<kc_tag_patternrepresentations*>(kc_x);
}

patternrepresentations
Conspatternrepresentations(patternrepresentation _patternrepresentation_1, patternrepresentations _patternrepresentations_1) {
    patternrepresentations kc_x = new kc_tag_patternrepresentations(_patternrepresentation_1, _patternrepresentations_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Conspatternrepresentations));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Conspatternrepresentations));
    kc_x->post_create();
    return static_cast<kc_tag_patternrepresentations*>(kc_x);
}

patternrepresentation
Nilpatternrepresentation() {
    patternrepresentation kc_x = new kc_tag_patternrepresentation();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilpatternrepresentation));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilpatternrepresentation));
    kc_x->post_create();
    return static_cast<kc_tag_patternrepresentation*>(kc_x);
}

patternrepresentation
Conspatternrepresentation(elem_patternrepresentation _elem_patternrepresentation_1, patternrepresentation _patternrepresentation_1) {
    patternrepresentation kc_x = new kc_tag_patternrepresentation(_elem_patternrepresentation_1, _patternrepresentation_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Conspatternrepresentation));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Conspatternrepresentation));
    kc_x->post_create();
    return static_cast<kc_tag_patternrepresentation*>(kc_x);
}

elem_patternrepresentation
PRBinding(path _path_1, ID _ID_1) {
    elem_patternrepresentation kc_x = new kc_tag_elem_patternrepresentation_PRBinding(_path_1, _ID_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_PRBinding));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_PRBinding));
    kc_x->post_create();
    kc_x = kc_initialize_elem_patternrepresentation(kc_x);
    return static_cast<kc_tag_elem_patternrepresentation_PRBinding*>(kc_x);
}

elem_patternrepresentation
PRVarPredicate(paths _paths_1, ID _ID_1, patternrepresentation _patternrepresentation_1) {
    elem_patternrepresentation kc_x = new kc_tag_elem_patternrepresentation_PRVarPredicate(_paths_1, _ID_1, _patternrepresentation_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_PRVarPredicate));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_PRVarPredicate));
    kc_x->post_create();
    kc_x = kc_initialize_elem_patternrepresentation(kc_x);
    return static_cast<kc_tag_elem_patternrepresentation_PRVarPredicate*>(kc_x);
}

elem_patternrepresentation
PROperPredicate(path _path_1, ID _ID_1) {
    elem_patternrepresentation kc_x = new kc_tag_elem_patternrepresentation_PROperPredicate(_path_1, _ID_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_PROperPredicate));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_PROperPredicate));
    kc_x->post_create();
    kc_x = kc_initialize_elem_patternrepresentation(kc_x);
    return static_cast<kc_tag_elem_patternrepresentation_PROperPredicate*>(kc_x);
}

elem_patternrepresentation
PRUserPredicate(Cexpression _Cexpression_1) {
    elem_patternrepresentation kc_x = new kc_tag_elem_patternrepresentation_PRUserPredicate(_Cexpression_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_PRUserPredicate));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_PRUserPredicate));
    kc_x->post_create();
    kc_x = kc_initialize_elem_patternrepresentation(kc_x);
    return static_cast<kc_tag_elem_patternrepresentation_PRUserPredicate*>(kc_x);
}

elem_patternrepresentation
PRNonLeafBinding(path _path_1, ID _ID_1, patternrepresentation _patternrepresentation_1) {
    elem_patternrepresentation kc_x = new kc_tag_elem_patternrepresentation_PRNonLeafBinding(_path_1, _ID_1, _patternrepresentation_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_PRNonLeafBinding));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_PRNonLeafBinding));
    kc_x->post_create();
    kc_x = kc_initialize_elem_patternrepresentation(kc_x);
    return static_cast<kc_tag_elem_patternrepresentation_PRNonLeafBinding*>(kc_x);
}

elem_patternrepresentation
PRWildcard(path _path_1) {
    elem_patternrepresentation kc_x = new kc_tag_elem_patternrepresentation_PRWildcard(_path_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_PRWildcard));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_PRWildcard));
    kc_x->post_create();
    kc_x = kc_initialize_elem_patternrepresentation(kc_x);
    return static_cast<kc_tag_elem_patternrepresentation_PRWildcard*>(kc_x);
}

elem_patternrepresentation
PRDefault() {
    elem_patternrepresentation kc_x = new kc_tag_elem_patternrepresentation_PRDefault();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_PRDefault));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_PRDefault));
    kc_x->post_create();
    kc_x = kc_initialize_elem_patternrepresentation(kc_x);
    return static_cast<kc_tag_elem_patternrepresentation_PRDefault*>(kc_x);
}

elem_patternrepresentation
PRStringLiteral(path _path_1, CexpressionDQ _CexpressionDQ_1) {
    elem_patternrepresentation kc_x = new kc_tag_elem_patternrepresentation_PRStringLiteral(_path_1, _CexpressionDQ_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_PRStringLiteral));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_PRStringLiteral));
    kc_x->post_create();
    kc_x = kc_initialize_elem_patternrepresentation(kc_x);
    return static_cast<kc_tag_elem_patternrepresentation_PRStringLiteral*>(kc_x);
}

elem_patternrepresentation
PRIntLiteral(path _path_1, INT _INT_1) {
    elem_patternrepresentation kc_x = new kc_tag_elem_patternrepresentation_PRIntLiteral(_path_1, _INT_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_PRIntLiteral));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_PRIntLiteral));
    kc_x->post_create();
    kc_x = kc_initialize_elem_patternrepresentation(kc_x);
    return static_cast<kc_tag_elem_patternrepresentation_PRIntLiteral*>(kc_x);
}

path
Nilpath() {
    path kc_x = new kc_tag_path();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilpath));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilpath));
    kc_x->post_create();
    kc_x = kc_initialize_path(kc_x);
    return static_cast<kc_tag_path*>(kc_x);
}

path
Conspath(integer _integer_1, path _path_1) {
    path kc_x = new kc_tag_path(_integer_1, _path_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Conspath));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Conspath));
    kc_x->post_create();
    kc_x = kc_initialize_path(kc_x);
    return static_cast<kc_tag_path*>(kc_x);
}

paths
Nilpaths() {
    paths kc_x = new kc_tag_paths();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilpaths));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilpaths));
    kc_x->post_create();
    return static_cast<kc_tag_paths*>(kc_x);
}

paths
Conspaths(path _path_1, paths _paths_1) {
    paths kc_x = new kc_tag_paths(_path_1, _paths_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Conspaths));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Conspaths));
    kc_x->post_create();
    return static_cast<kc_tag_paths*>(kc_x);
}

argsnumbers
Nilargsnumbers() {
    argsnumbers kc_x = new kc_tag_argsnumbers();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilargsnumbers));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilargsnumbers));
    kc_x->post_create();
    return static_cast<kc_tag_argsnumbers*>(kc_x);
}

argsnumbers
Consargsnumbers(integer _integer_1, argsnumbers _argsnumbers_1) {
    argsnumbers kc_x = new kc_tag_argsnumbers(_integer_1, _argsnumbers_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consargsnumbers));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consargsnumbers));
    kc_x->post_create();
    return static_cast<kc_tag_argsnumbers*>(kc_x);
}

rewriterulesinfo
Nilrewriterulesinfo() {
    rewriterulesinfo kc_x = new kc_tag_rewriterulesinfo();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilrewriterulesinfo));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilrewriterulesinfo));
    kc_x->post_create();
    return static_cast<kc_tag_rewriterulesinfo*>(kc_x);
}

rewriterulesinfo
Consrewriterulesinfo(rewriteruleinfo _rewriteruleinfo_1, rewriterulesinfo _rewriterulesinfo_1) {
    rewriterulesinfo kc_x = new kc_tag_rewriterulesinfo(_rewriteruleinfo_1, _rewriterulesinfo_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consrewriterulesinfo));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consrewriterulesinfo));
    kc_x->post_create();
    return static_cast<kc_tag_rewriterulesinfo*>(kc_x);
}

rewriteruleinfo
Rewriteruleinfo(patternrepresentation _patternrepresentation_1, patternrepresentation _patternrepresentation_2, rewriteclause _rewriteclause_1) {
    rewriteruleinfo kc_x = new kc_tag_rewriteruleinfo_Rewriteruleinfo(_patternrepresentation_1, _patternrepresentation_2, _rewriteclause_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Rewriteruleinfo));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Rewriteruleinfo));
    kc_x->post_create();
    return static_cast<kc_tag_rewriteruleinfo_Rewriteruleinfo*>(kc_x);
}

withcasesinfo
Nilwithcasesinfo() {
    withcasesinfo kc_x = new kc_tag_withcasesinfo();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilwithcasesinfo));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilwithcasesinfo));
    kc_x->post_create();
    return static_cast<kc_tag_withcasesinfo*>(kc_x);
}

withcasesinfo
Conswithcasesinfo(withcaseinfo _withcaseinfo_1, withcasesinfo _withcasesinfo_1) {
    withcasesinfo kc_x = new kc_tag_withcasesinfo(_withcaseinfo_1, _withcasesinfo_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Conswithcasesinfo));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Conswithcasesinfo));
    kc_x->post_create();
    return static_cast<kc_tag_withcasesinfo*>(kc_x);
}

withcaseinfo
Withcaseinfo(patternrepresentation _patternrepresentation_1, patternrepresentation _patternrepresentation_2, Ctext _Ctext_1) {
    withcaseinfo kc_x = new kc_tag_withcaseinfo_Withcaseinfo(_patternrepresentation_1, _patternrepresentation_2, _Ctext_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Withcaseinfo));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Withcaseinfo));
    kc_x->post_create();
    return static_cast<kc_tag_withcaseinfo_Withcaseinfo*>(kc_x);
}

rewriteviewsinfo
Nilrewriteviewsinfo() {
    rewriteviewsinfo kc_x = new kc_tag_rewriteviewsinfo();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilrewriteviewsinfo));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilrewriteviewsinfo));
    kc_x->post_create();
    return static_cast<kc_tag_rewriteviewsinfo*>(kc_x);
}

rewriteviewsinfo
Consrewriteviewsinfo(rewriteviewinfo _rewriteviewinfo_1, rewriteviewsinfo _rewriteviewsinfo_1) {
    rewriteviewsinfo kc_x = new kc_tag_rewriteviewsinfo(_rewriteviewinfo_1, _rewriteviewsinfo_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consrewriteviewsinfo));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consrewriteviewsinfo));
    kc_x->post_create();
    return static_cast<kc_tag_rewriteviewsinfo*>(kc_x);
}

rewriteviewinfo
Rewriteviewinfo(ID _ID_1, rewriterulesinfo _rewriterulesinfo_1) {
    rewriteviewinfo kc_x = new kc_tag_rewriteviewinfo_Rewriteviewinfo(_ID_1, _rewriterulesinfo_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Rewriteviewinfo));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Rewriteviewinfo));
    kc_x->post_create();
    return static_cast<kc_tag_rewriteviewinfo_Rewriteviewinfo*>(kc_x);
}

unparseviewsinfo
Nilunparseviewsinfo() {
    unparseviewsinfo kc_x = new kc_tag_unparseviewsinfo();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilunparseviewsinfo));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilunparseviewsinfo));
    kc_x->post_create();
    return static_cast<kc_tag_unparseviewsinfo*>(kc_x);
}

unparseviewsinfo
Consunparseviewsinfo(unparseviewinfo _unparseviewinfo_1, unparseviewsinfo _unparseviewsinfo_1) {
    unparseviewsinfo kc_x = new kc_tag_unparseviewsinfo(_unparseviewinfo_1, _unparseviewsinfo_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consunparseviewsinfo));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consunparseviewsinfo));
    kc_x->post_create();
    return static_cast<kc_tag_unparseviewsinfo*>(kc_x);
}

unparseviewinfo
Unparseviewinfo(ID _ID_1, unparsedeclsinfo _unparsedeclsinfo_1) {
    unparseviewinfo kc_x = new kc_tag_unparseviewinfo_Unparseviewinfo(_ID_1, _unparsedeclsinfo_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Unparseviewinfo));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Unparseviewinfo));
    kc_x->post_create();
    return static_cast<kc_tag_unparseviewinfo_Unparseviewinfo*>(kc_x);
}

unparsedeclsinfo
Nilunparsedeclsinfo() {
    unparsedeclsinfo kc_x = new kc_tag_unparsedeclsinfo();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilunparsedeclsinfo));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilunparsedeclsinfo));
    kc_x->post_create();
    return static_cast<kc_tag_unparsedeclsinfo*>(kc_x);
}

unparsedeclsinfo
Consunparsedeclsinfo(unparsedeclinfo _unparsedeclinfo_1, unparsedeclsinfo _unparsedeclsinfo_1) {
    unparsedeclsinfo kc_x = new kc_tag_unparsedeclsinfo(_unparsedeclinfo_1, _unparsedeclsinfo_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consunparsedeclsinfo));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consunparsedeclsinfo));
    kc_x->post_create();
    return static_cast<kc_tag_unparsedeclsinfo*>(kc_x);
}

unparsedeclinfo
Unparsedeclinfo(patternrepresentation _patternrepresentation_1, patternrepresentation _patternrepresentation_2, unparseclause _unparseclause_1) {
    unparsedeclinfo kc_x = new kc_tag_unparsedeclinfo_Unparsedeclinfo(_patternrepresentation_1, _patternrepresentation_2, _unparseclause_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Unparsedeclinfo));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Unparsedeclinfo));
    kc_x->post_create();
    return static_cast<kc_tag_unparsedeclinfo_Unparsedeclinfo*>(kc_x);
}

ac_declaration
AcDeclaration(ac_declaration_specifiers _ac_declaration_specifiers_1, ac_init_declarator_list _ac_init_declarator_list_1) {
    ac_declaration kc_x = new kc_tag_ac_declaration_AcDeclaration(_ac_declaration_specifiers_1, _ac_init_declarator_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcDeclaration));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcDeclaration));
    kc_x->post_create();
    return static_cast<kc_tag_ac_declaration_AcDeclaration*>(kc_x);
}

ac_declaration_list
Nilac_declaration_list() {
    ac_declaration_list kc_x = new kc_tag_ac_declaration_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilac_declaration_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilac_declaration_list));
    kc_x->post_create();
    return static_cast<kc_tag_ac_declaration_list*>(kc_x);
}

ac_declaration_list
Consac_declaration_list(ac_declaration _ac_declaration_1, ac_declaration_list _ac_declaration_list_1) {
    ac_declaration_list kc_x = new kc_tag_ac_declaration_list(_ac_declaration_1, _ac_declaration_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consac_declaration_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consac_declaration_list));
    kc_x->post_create();
    return static_cast<kc_tag_ac_declaration_list*>(kc_x);
}

ac_declaration_specifiers
Nilac_declaration_specifiers() {
    ac_declaration_specifiers kc_x = new kc_tag_ac_declaration_specifiers();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilac_declaration_specifiers));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilac_declaration_specifiers));
    kc_x->post_create();
    return static_cast<kc_tag_ac_declaration_specifiers*>(kc_x);
}

ac_declaration_specifiers
Consac_declaration_specifiers(ac_declaration_specifier _ac_declaration_specifier_1, ac_declaration_specifiers _ac_declaration_specifiers_1) {
    ac_declaration_specifiers kc_x = new kc_tag_ac_declaration_specifiers(_ac_declaration_specifier_1, _ac_declaration_specifiers_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consac_declaration_specifiers));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consac_declaration_specifiers));
    kc_x->post_create();
    return static_cast<kc_tag_ac_declaration_specifiers*>(kc_x);
}

ac_declaration_specifier
AcDeclSpecStorageSpec(ac_storage_class_specifier _ac_storage_class_specifier_1) {
    ac_declaration_specifier kc_x = new kc_tag_ac_declaration_specifier_AcDeclSpecStorageSpec(_ac_storage_class_specifier_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcDeclSpecStorageSpec));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcDeclSpecStorageSpec));
    kc_x->post_create();
    return static_cast<kc_tag_ac_declaration_specifier_AcDeclSpecStorageSpec*>(kc_x);
}

ac_declaration_specifier
AcDeclSpecTypeSpec(ac_type_specifier _ac_type_specifier_1) {
    ac_declaration_specifier kc_x = new kc_tag_ac_declaration_specifier_AcDeclSpecTypeSpec(_ac_type_specifier_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcDeclSpecTypeSpec));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcDeclSpecTypeSpec));
    kc_x->post_create();
    return static_cast<kc_tag_ac_declaration_specifier_AcDeclSpecTypeSpec*>(kc_x);
}

ac_declaration_specifier
AcDeclSpecTypeQual(ac_type_qualifier _ac_type_qualifier_1) {
    ac_declaration_specifier kc_x = new kc_tag_ac_declaration_specifier_AcDeclSpecTypeQual(_ac_type_qualifier_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcDeclSpecTypeQual));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcDeclSpecTypeQual));
    kc_x->post_create();
    return static_cast<kc_tag_ac_declaration_specifier_AcDeclSpecTypeQual*>(kc_x);
}

ac_storage_class_specifier
AcAuto() {
    ac_storage_class_specifier kc_x = new kc_tag_ac_storage_class_specifier_AcAuto();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcAuto));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcAuto));
    kc_x->post_create();
    return static_cast<kc_tag_ac_storage_class_specifier_AcAuto*>(kc_x);
}

ac_storage_class_specifier
AcRegister() {
    ac_storage_class_specifier kc_x = new kc_tag_ac_storage_class_specifier_AcRegister();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcRegister));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcRegister));
    kc_x->post_create();
    return static_cast<kc_tag_ac_storage_class_specifier_AcRegister*>(kc_x);
}

ac_storage_class_specifier
AcStatic() {
    ac_storage_class_specifier kc_x = new kc_tag_ac_storage_class_specifier_AcStatic();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcStatic));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcStatic));
    kc_x->post_create();
    return static_cast<kc_tag_ac_storage_class_specifier_AcStatic*>(kc_x);
}

ac_storage_class_specifier
AcExtern() {
    ac_storage_class_specifier kc_x = new kc_tag_ac_storage_class_specifier_AcExtern();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcExtern));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcExtern));
    kc_x->post_create();
    return static_cast<kc_tag_ac_storage_class_specifier_AcExtern*>(kc_x);
}

ac_storage_class_specifier
AcTypedef() {
    ac_storage_class_specifier kc_x = new kc_tag_ac_storage_class_specifier_AcTypedef();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcTypedef));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcTypedef));
    kc_x->post_create();
    return static_cast<kc_tag_ac_storage_class_specifier_AcTypedef*>(kc_x);
}

ac_storage_class_specifier
AcVirtual() {
    ac_storage_class_specifier kc_x = new kc_tag_ac_storage_class_specifier_AcVirtual();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcVirtual));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcVirtual));
    kc_x->post_create();
    return static_cast<kc_tag_ac_storage_class_specifier_AcVirtual*>(kc_x);
}

ac_type_specifier
AcTypeSpec(ID _ID_1) {
    ac_type_specifier kc_x = new kc_tag_ac_type_specifier_AcTypeSpec(_ID_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcTypeSpec));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcTypeSpec));
    kc_x->post_create();
    return static_cast<kc_tag_ac_type_specifier_AcTypeSpec*>(kc_x);
}

ac_type_qualifier
AcConst() {
    ac_type_qualifier kc_x = new kc_tag_ac_type_qualifier_AcConst();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcConst));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcConst));
    kc_x->post_create();
    return static_cast<kc_tag_ac_type_qualifier_AcConst*>(kc_x);
}

ac_type_qualifier
AcVolatile() {
    ac_type_qualifier kc_x = new kc_tag_ac_type_qualifier_AcVolatile();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcVolatile));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcVolatile));
    kc_x->post_create();
    return static_cast<kc_tag_ac_type_qualifier_AcVolatile*>(kc_x);
}

ac_type_qualifier
AcUnsigned() {
    ac_type_qualifier kc_x = new kc_tag_ac_type_qualifier_AcUnsigned();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcUnsigned));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcUnsigned));
    kc_x->post_create();
    return static_cast<kc_tag_ac_type_qualifier_AcUnsigned*>(kc_x);
}

ac_type_qualifier
AcNoQualifier() {
    ac_type_qualifier kc_x = new kc_tag_ac_type_qualifier_AcNoQualifier();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcNoQualifier));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcNoQualifier));
    kc_x->post_create();
    return static_cast<kc_tag_ac_type_qualifier_AcNoQualifier*>(kc_x);
}

ac_init_declarator_list
Nilac_init_declarator_list() {
    ac_init_declarator_list kc_x = new kc_tag_ac_init_declarator_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilac_init_declarator_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilac_init_declarator_list));
    kc_x->post_create();
    return static_cast<kc_tag_ac_init_declarator_list*>(kc_x);
}

ac_init_declarator_list
Consac_init_declarator_list(ac_init_declarator _ac_init_declarator_1, ac_init_declarator_list _ac_init_declarator_list_1) {
    ac_init_declarator_list kc_x = new kc_tag_ac_init_declarator_list(_ac_init_declarator_1, _ac_init_declarator_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consac_init_declarator_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consac_init_declarator_list));
    kc_x->post_create();
    return static_cast<kc_tag_ac_init_declarator_list*>(kc_x);
}

ac_init_declarator
AcInitDecl(ac_declarator _ac_declarator_1) {
    ac_init_declarator kc_x = new kc_tag_ac_init_declarator_AcInitDecl(_ac_declarator_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcInitDecl));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcInitDecl));
    kc_x->post_create();
    return static_cast<kc_tag_ac_init_declarator_AcInitDecl*>(kc_x);
}

ac_declarator
AcDeclarator(ac_pointer_option _ac_pointer_option_1, ac_ref_option _ac_ref_option_1, ac_direct_declarator _ac_direct_declarator_1) {
    ac_declarator kc_x = new kc_tag_ac_declarator_AcDeclarator(_ac_pointer_option_1, _ac_ref_option_1, _ac_direct_declarator_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcDeclarator));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcDeclarator));
    kc_x->post_create();
    return static_cast<kc_tag_ac_declarator_AcDeclarator*>(kc_x);
}

ac_direct_declarator
AcDirectDeclId(ID _ID_1) {
    ac_direct_declarator kc_x = new kc_tag_ac_direct_declarator_AcDirectDeclId(_ID_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcDirectDeclId));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcDirectDeclId));
    kc_x->post_create();
    return static_cast<kc_tag_ac_direct_declarator_AcDirectDeclId*>(kc_x);
}

ac_direct_declarator
AcDirectDeclPack(ac_declarator _ac_declarator_1) {
    ac_direct_declarator kc_x = new kc_tag_ac_direct_declarator_AcDirectDeclPack(_ac_declarator_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcDirectDeclPack));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcDirectDeclPack));
    kc_x->post_create();
    return static_cast<kc_tag_ac_direct_declarator_AcDirectDeclPack*>(kc_x);
}

ac_direct_declarator
AcDirectDeclArray(ac_direct_declarator _ac_direct_declarator_1, ac_constant_expression_option _ac_constant_expression_option_1) {
    ac_direct_declarator kc_x = new kc_tag_ac_direct_declarator_AcDirectDeclArray(_ac_direct_declarator_1, _ac_constant_expression_option_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcDirectDeclArray));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcDirectDeclArray));
    kc_x->post_create();
    return static_cast<kc_tag_ac_direct_declarator_AcDirectDeclArray*>(kc_x);
}

ac_direct_declarator
AcDirectDeclProto(ac_direct_declarator _ac_direct_declarator_1, ac_parameter_type_list _ac_parameter_type_list_1) {
    ac_direct_declarator kc_x = new kc_tag_ac_direct_declarator_AcDirectDeclProto(_ac_direct_declarator_1, _ac_parameter_type_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcDirectDeclProto));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcDirectDeclProto));
    kc_x->post_create();
    return static_cast<kc_tag_ac_direct_declarator_AcDirectDeclProto*>(kc_x);
}

ac_direct_declarator
AcQualifiedDeclProto(ac_class_qualifier_list _ac_class_qualifier_list_1, ac_direct_declarator _ac_direct_declarator_1, ac_parameter_type_list _ac_parameter_type_list_1, ac_type_qualifier _ac_type_qualifier_1) {
    ac_direct_declarator kc_x = new kc_tag_ac_direct_declarator_AcQualifiedDeclProto(_ac_class_qualifier_list_1, _ac_direct_declarator_1, _ac_parameter_type_list_1, _ac_type_qualifier_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcQualifiedDeclProto));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcQualifiedDeclProto));
    kc_x->post_create();
    return static_cast<kc_tag_ac_direct_declarator_AcQualifiedDeclProto*>(kc_x);
}

ac_direct_declarator
AcMemberDecl(ID _ID_1, ID _ID_2, ac_constant_expression_list _ac_constant_expression_list_1) {
    ac_direct_declarator kc_x = new kc_tag_ac_direct_declarator_AcMemberDecl(_ID_1, _ID_2, _ac_constant_expression_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcMemberDecl));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcMemberDecl));
    kc_x->post_create();
    return static_cast<kc_tag_ac_direct_declarator_AcMemberDecl*>(kc_x);
}

ac_direct_declarator
AcOperatorDeclId(ac_operator_name _ac_operator_name_1) {
    ac_direct_declarator kc_x = new kc_tag_ac_direct_declarator_AcOperatorDeclId(_ac_operator_name_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcOperatorDeclId));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcOperatorDeclId));
    kc_x->post_create();
    return static_cast<kc_tag_ac_direct_declarator_AcOperatorDeclId*>(kc_x);
}

ac_pointer_option
Nopointer() {
    ac_pointer_option kc_x = new kc_tag_ac_pointer_option_Nopointer();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nopointer));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nopointer));
    kc_x->post_create();
    return static_cast<kc_tag_ac_pointer_option_Nopointer*>(kc_x);
}

ac_pointer_option
Yespointer(ac_pointer _ac_pointer_1) {
    ac_pointer_option kc_x = new kc_tag_ac_pointer_option_Yespointer(_ac_pointer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Yespointer));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Yespointer));
    kc_x->post_create();
    return static_cast<kc_tag_ac_pointer_option_Yespointer*>(kc_x);
}

ac_pointer
AcPointerNil(ac_type_qualifier_list _ac_type_qualifier_list_1) {
    ac_pointer kc_x = new kc_tag_ac_pointer_AcPointerNil(_ac_type_qualifier_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcPointerNil));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcPointerNil));
    kc_x->post_create();
    return static_cast<kc_tag_ac_pointer_AcPointerNil*>(kc_x);
}

ac_pointer
AcPointerCons(ac_type_qualifier_list _ac_type_qualifier_list_1, ac_pointer _ac_pointer_1) {
    ac_pointer kc_x = new kc_tag_ac_pointer_AcPointerCons(_ac_type_qualifier_list_1, _ac_pointer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcPointerCons));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcPointerCons));
    kc_x->post_create();
    return static_cast<kc_tag_ac_pointer_AcPointerCons*>(kc_x);
}

ac_ref_option
AcNoRef() {
    ac_ref_option kc_x = new kc_tag_ac_ref_option_AcNoRef();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcNoRef));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcNoRef));
    kc_x->post_create();
    return static_cast<kc_tag_ac_ref_option_AcNoRef*>(kc_x);
}

ac_ref_option
AcRef() {
    ac_ref_option kc_x = new kc_tag_ac_ref_option_AcRef();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcRef));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcRef));
    kc_x->post_create();
    return static_cast<kc_tag_ac_ref_option_AcRef*>(kc_x);
}

ac_operator_name
AcOperatorName(casestring _casestring_1) {
    ac_operator_name kc_x = new kc_tag_ac_operator_name_AcOperatorName(_casestring_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcOperatorName));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcOperatorName));
    kc_x->post_create();
    kc_x = kc_initialize_ac_operator_name(kc_x);
    return static_cast<kc_tag_ac_operator_name_AcOperatorName*>(kc_x);
}

ac_class_qualifier_help_list
Nilac_class_qualifier_help_list() {
    ac_class_qualifier_help_list kc_x = new kc_tag_ac_class_qualifier_help_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilac_class_qualifier_help_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilac_class_qualifier_help_list));
    kc_x->post_create();
    return static_cast<kc_tag_ac_class_qualifier_help_list*>(kc_x);
}

ac_class_qualifier_help_list
Consac_class_qualifier_help_list(ac_direct_declarator _ac_direct_declarator_1, ac_class_qualifier_help_list _ac_class_qualifier_help_list_1) {
    ac_class_qualifier_help_list kc_x = new kc_tag_ac_class_qualifier_help_list(_ac_direct_declarator_1, _ac_class_qualifier_help_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consac_class_qualifier_help_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consac_class_qualifier_help_list));
    kc_x->post_create();
    return static_cast<kc_tag_ac_class_qualifier_help_list*>(kc_x);
}

ac_class_qualifier_list
Nilac_class_qualifier_list() {
    ac_class_qualifier_list kc_x = new kc_tag_ac_class_qualifier_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilac_class_qualifier_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilac_class_qualifier_list));
    kc_x->post_create();
    return static_cast<kc_tag_ac_class_qualifier_list*>(kc_x);
}

ac_class_qualifier_list
Consac_class_qualifier_list(ID _ID_1, ac_class_qualifier_list _ac_class_qualifier_list_1) {
    ac_class_qualifier_list kc_x = new kc_tag_ac_class_qualifier_list(_ID_1, _ac_class_qualifier_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consac_class_qualifier_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consac_class_qualifier_list));
    kc_x->post_create();
    return static_cast<kc_tag_ac_class_qualifier_list*>(kc_x);
}

ac_type_qualifier_list
Nilac_type_qualifier_list() {
    ac_type_qualifier_list kc_x = new kc_tag_ac_type_qualifier_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilac_type_qualifier_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilac_type_qualifier_list));
    kc_x->post_create();
    return static_cast<kc_tag_ac_type_qualifier_list*>(kc_x);
}

ac_type_qualifier_list
Consac_type_qualifier_list(ac_type_qualifier _ac_type_qualifier_1, ac_type_qualifier_list _ac_type_qualifier_list_1) {
    ac_type_qualifier_list kc_x = new kc_tag_ac_type_qualifier_list(_ac_type_qualifier_1, _ac_type_qualifier_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consac_type_qualifier_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consac_type_qualifier_list));
    kc_x->post_create();
    return static_cast<kc_tag_ac_type_qualifier_list*>(kc_x);
}

ac_parameter_type_list
AcParList(ac_parameter_list _ac_parameter_list_1) {
    ac_parameter_type_list kc_x = new kc_tag_ac_parameter_type_list_AcParList(_ac_parameter_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcParList));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcParList));
    kc_x->post_create();
    return static_cast<kc_tag_ac_parameter_type_list_AcParList*>(kc_x);
}

ac_parameter_type_list
AcParList3Dot(ac_parameter_list _ac_parameter_list_1) {
    ac_parameter_type_list kc_x = new kc_tag_ac_parameter_type_list_AcParList3Dot(_ac_parameter_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcParList3Dot));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcParList3Dot));
    kc_x->post_create();
    return static_cast<kc_tag_ac_parameter_type_list_AcParList3Dot*>(kc_x);
}

ac_parameter_list
Nilac_parameter_list() {
    ac_parameter_list kc_x = new kc_tag_ac_parameter_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilac_parameter_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilac_parameter_list));
    kc_x->post_create();
    return static_cast<kc_tag_ac_parameter_list*>(kc_x);
}

ac_parameter_list
Consac_parameter_list(ac_parameter_declaration _ac_parameter_declaration_1, ac_parameter_list _ac_parameter_list_1) {
    ac_parameter_list kc_x = new kc_tag_ac_parameter_list(_ac_parameter_declaration_1, _ac_parameter_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consac_parameter_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consac_parameter_list));
    kc_x->post_create();
    return static_cast<kc_tag_ac_parameter_list*>(kc_x);
}

ac_parameter_declaration
AcParDeclDecl(ac_declaration_specifiers _ac_declaration_specifiers_1, ac_declarator _ac_declarator_1, ac_constant_expression_option _ac_constant_expression_option_1) {
    ac_parameter_declaration kc_x = new kc_tag_ac_parameter_declaration_AcParDeclDecl(_ac_declaration_specifiers_1, _ac_declarator_1, _ac_constant_expression_option_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcParDeclDecl));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcParDeclDecl));
    kc_x->post_create();
    return static_cast<kc_tag_ac_parameter_declaration_AcParDeclDecl*>(kc_x);
}

ac_parameter_declaration
AcParDeclAbsdecl(ac_declaration_specifiers _ac_declaration_specifiers_1, ac_abstract_declarator _ac_abstract_declarator_1, ac_constant_expression_option _ac_constant_expression_option_1) {
    ac_parameter_declaration kc_x = new kc_tag_ac_parameter_declaration_AcParDeclAbsdecl(_ac_declaration_specifiers_1, _ac_abstract_declarator_1, _ac_constant_expression_option_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcParDeclAbsdecl));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcParDeclAbsdecl));
    kc_x->post_create();
    return static_cast<kc_tag_ac_parameter_declaration_AcParDeclAbsdecl*>(kc_x);
}

ac_identifier_list
Nilac_identifier_list() {
    ac_identifier_list kc_x = new kc_tag_ac_identifier_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilac_identifier_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilac_identifier_list));
    kc_x->post_create();
    return static_cast<kc_tag_ac_identifier_list*>(kc_x);
}

ac_identifier_list
Consac_identifier_list(ID _ID_1, ac_identifier_list _ac_identifier_list_1) {
    ac_identifier_list kc_x = new kc_tag_ac_identifier_list(_ID_1, _ac_identifier_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consac_identifier_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consac_identifier_list));
    kc_x->post_create();
    return static_cast<kc_tag_ac_identifier_list*>(kc_x);
}

ac_abstract_declarator
AcAbsdeclPointer(ac_pointer _ac_pointer_1) {
    ac_abstract_declarator kc_x = new kc_tag_ac_abstract_declarator_AcAbsdeclPointer(_ac_pointer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcAbsdeclPointer));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcAbsdeclPointer));
    kc_x->post_create();
    return static_cast<kc_tag_ac_abstract_declarator_AcAbsdeclPointer*>(kc_x);
}

ac_abstract_declarator
AcAbsdeclDirdecl(ac_pointer_option _ac_pointer_option_1, ac_direct_abstract_declarator _ac_direct_abstract_declarator_1) {
    ac_abstract_declarator kc_x = new kc_tag_ac_abstract_declarator_AcAbsdeclDirdecl(_ac_pointer_option_1, _ac_direct_abstract_declarator_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcAbsdeclDirdecl));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcAbsdeclDirdecl));
    kc_x->post_create();
    return static_cast<kc_tag_ac_abstract_declarator_AcAbsdeclDirdecl*>(kc_x);
}

ac_direct_abstract_declarator_option
Noac_direct_abstract_declarator() {
    ac_direct_abstract_declarator_option kc_x = new kc_tag_ac_direct_abstract_declarator_option_Noac_direct_abstract_declarator();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Noac_direct_abstract_declarator));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Noac_direct_abstract_declarator));
    kc_x->post_create();
    return static_cast<kc_tag_ac_direct_abstract_declarator_option_Noac_direct_abstract_declarator*>(kc_x);
}

ac_direct_abstract_declarator_option
Yesac_direct_abstract_declarator(ac_direct_abstract_declarator _ac_direct_abstract_declarator_1) {
    ac_direct_abstract_declarator_option kc_x = new kc_tag_ac_direct_abstract_declarator_option_Yesac_direct_abstract_declarator(_ac_direct_abstract_declarator_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Yesac_direct_abstract_declarator));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Yesac_direct_abstract_declarator));
    kc_x->post_create();
    return static_cast<kc_tag_ac_direct_abstract_declarator_option_Yesac_direct_abstract_declarator*>(kc_x);
}

ac_direct_abstract_declarator
AcDirAbsdeclPack(ac_abstract_declarator _ac_abstract_declarator_1) {
    ac_direct_abstract_declarator kc_x = new kc_tag_ac_direct_abstract_declarator_AcDirAbsdeclPack(_ac_abstract_declarator_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcDirAbsdeclPack));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcDirAbsdeclPack));
    kc_x->post_create();
    return static_cast<kc_tag_ac_direct_abstract_declarator_AcDirAbsdeclPack*>(kc_x);
}

ac_direct_abstract_declarator
AcDirAbsdeclArray(ac_direct_abstract_declarator_option _ac_direct_abstract_declarator_option_1, ac_constant_expression_option _ac_constant_expression_option_1) {
    ac_direct_abstract_declarator kc_x = new kc_tag_ac_direct_abstract_declarator_AcDirAbsdeclArray(_ac_direct_abstract_declarator_option_1, _ac_constant_expression_option_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcDirAbsdeclArray));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcDirAbsdeclArray));
    kc_x->post_create();
    return static_cast<kc_tag_ac_direct_abstract_declarator_AcDirAbsdeclArray*>(kc_x);
}

ac_direct_abstract_declarator
AcDirAbsdeclFn(ac_direct_abstract_declarator_option _ac_direct_abstract_declarator_option_1, ac_parameter_type_list _ac_parameter_type_list_1) {
    ac_direct_abstract_declarator kc_x = new kc_tag_ac_direct_abstract_declarator_AcDirAbsdeclFn(_ac_direct_abstract_declarator_option_1, _ac_parameter_type_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcDirAbsdeclFn));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcDirAbsdeclFn));
    kc_x->post_create();
    return static_cast<kc_tag_ac_direct_abstract_declarator_AcDirAbsdeclFn*>(kc_x);
}

ac_constant_expression_option
Yesac_constant_expression(ac_constant_expression _ac_constant_expression_1) {
    ac_constant_expression_option kc_x = new kc_tag_ac_constant_expression_option_Yesac_constant_expression(_ac_constant_expression_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Yesac_constant_expression));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Yesac_constant_expression));
    kc_x->post_create();
    return static_cast<kc_tag_ac_constant_expression_option_Yesac_constant_expression*>(kc_x);
}

ac_constant_expression_option
Noac_constant_expression() {
    ac_constant_expression_option kc_x = new kc_tag_ac_constant_expression_option_Noac_constant_expression();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Noac_constant_expression));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Noac_constant_expression));
    kc_x->post_create();
    return static_cast<kc_tag_ac_constant_expression_option_Noac_constant_expression*>(kc_x);
}

ac_constant_expression
AcConstExpr(Cexpression _Cexpression_1) {
    ac_constant_expression kc_x = new kc_tag_ac_constant_expression_AcConstExpr(_Cexpression_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcConstExpr));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcConstExpr));
    kc_x->post_create();
    return static_cast<kc_tag_ac_constant_expression_AcConstExpr*>(kc_x);
}

ac_constant_expression_list
Nilac_constant_expression_list() {
    ac_constant_expression_list kc_x = new kc_tag_ac_constant_expression_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilac_constant_expression_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilac_constant_expression_list));
    kc_x->post_create();
    return static_cast<kc_tag_ac_constant_expression_list*>(kc_x);
}

ac_constant_expression_list
Consac_constant_expression_list(ac_constant_expression _ac_constant_expression_1, ac_constant_expression_list _ac_constant_expression_list_1) {
    ac_constant_expression_list kc_x = new kc_tag_ac_constant_expression_list(_ac_constant_expression_1, _ac_constant_expression_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consac_constant_expression_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consac_constant_expression_list));
    kc_x->post_create();
    return static_cast<kc_tag_ac_constant_expression_list*>(kc_x);
}

ac_opt_base_init_list
AcNoBaseInit() {
    ac_opt_base_init_list kc_x = new kc_tag_ac_opt_base_init_list_AcNoBaseInit();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcNoBaseInit));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcNoBaseInit));
    kc_x->post_create();
    return static_cast<kc_tag_ac_opt_base_init_list_AcNoBaseInit*>(kc_x);
}

ac_opt_base_init_list
AcYesBaseInit(ac_base_init_list _ac_base_init_list_1) {
    ac_opt_base_init_list kc_x = new kc_tag_ac_opt_base_init_list_AcYesBaseInit(_ac_base_init_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcYesBaseInit));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcYesBaseInit));
    kc_x->post_create();
    return static_cast<kc_tag_ac_opt_base_init_list_AcYesBaseInit*>(kc_x);
}

ac_base_init_list
Nilac_base_init_list() {
    ac_base_init_list kc_x = new kc_tag_ac_base_init_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilac_base_init_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilac_base_init_list));
    kc_x->post_create();
    return static_cast<kc_tag_ac_base_init_list*>(kc_x);
}

ac_base_init_list
Consac_base_init_list(ac_base_init _ac_base_init_1, ac_base_init_list _ac_base_init_list_1) {
    ac_base_init_list kc_x = new kc_tag_ac_base_init_list(_ac_base_init_1, _ac_base_init_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consac_base_init_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consac_base_init_list));
    kc_x->post_create();
    return static_cast<kc_tag_ac_base_init_list*>(kc_x);
}

ac_base_init
AcBaseInit(ID _ID_1, ac_constant_expression _ac_constant_expression_1) {
    ac_base_init kc_x = new kc_tag_ac_base_init_AcBaseInit(_ID_1, _ac_constant_expression_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AcBaseInit));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AcBaseInit));
    kc_x->post_create();
    return static_cast<kc_tag_ac_base_init_AcBaseInit*>(kc_x);
}

baseclass_declarations
Nilbaseclass_declarations() {
    baseclass_declarations kc_x = new kc_tag_baseclass_declarations();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilbaseclass_declarations));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilbaseclass_declarations));
    kc_x->post_create();
    return static_cast<kc_tag_baseclass_declarations*>(kc_x);
}

baseclass_declarations
Consbaseclass_declarations(baseclass_decl _baseclass_decl_1, baseclass_declarations _baseclass_declarations_1) {
    baseclass_declarations kc_x = new kc_tag_baseclass_declarations(_baseclass_decl_1, _baseclass_declarations_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consbaseclass_declarations));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consbaseclass_declarations));
    kc_x->post_create();
    return static_cast<kc_tag_baseclass_declarations*>(kc_x);
}

baseclass_decl
BaseClassDecl(ID _ID_1, baseclass_list _baseclass_list_1) {
    baseclass_decl kc_x = new kc_tag_baseclass_decl_BaseClassDecl(_ID_1, _baseclass_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_BaseClassDecl));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_BaseClassDecl));
    kc_x->post_create();
    return static_cast<kc_tag_baseclass_decl_BaseClassDecl*>(kc_x);
}

baseclass_list
Nilbaseclass_list() {
    baseclass_list kc_x = new kc_tag_baseclass_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilbaseclass_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilbaseclass_list));
    kc_x->post_create();
    return static_cast<kc_tag_baseclass_list*>(kc_x);
}

baseclass_list
Consbaseclass_list(ID _ID_1, baseclass_list _baseclass_list_1) {
    baseclass_list kc_x = new kc_tag_baseclass_list(_ID_1, _baseclass_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consbaseclass_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consbaseclass_list));
    kc_x->post_create();
    return static_cast<kc_tag_baseclass_list*>(kc_x);
}

error
Fatal(fileline _fileline_1, problem _problem_1) {
    error kc_x = new kc_tag_error_Fatal(_fileline_1, _problem_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Fatal));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Fatal));
    kc_x->post_create();
    return static_cast<kc_tag_error_Fatal*>(kc_x);
}

error
NonFatal(fileline _fileline_1, problem _problem_1) {
    error kc_x = new kc_tag_error_NonFatal(_fileline_1, _problem_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NonFatal));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NonFatal));
    kc_x->post_create();
    return static_cast<kc_tag_error_NonFatal*>(kc_x);
}

error
Warning(fileline _fileline_1, problem _problem_1) {
    error kc_x = new kc_tag_error_Warning(_fileline_1, _problem_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Warning));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Warning));
    kc_x->post_create();
    return static_cast<kc_tag_error_Warning*>(kc_x);
}

problem
Problem1(casestring _casestring_1) {
    problem kc_x = new kc_tag_problem_Problem1(_casestring_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Problem1));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Problem1));
    kc_x->post_create();
    return static_cast<kc_tag_problem_Problem1*>(kc_x);
}

problem
Problem1ID(casestring _casestring_1, ID _ID_1) {
    problem kc_x = new kc_tag_problem_Problem1ID(_casestring_1, _ID_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Problem1ID));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Problem1ID));
    kc_x->post_create();
    return static_cast<kc_tag_problem_Problem1ID*>(kc_x);
}

problem
Problem1tID(casestring _casestring_1, ID _ID_1) {
    problem kc_x = new kc_tag_problem_Problem1tID(_casestring_1, _ID_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Problem1tID));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Problem1tID));
    kc_x->post_create();
    return static_cast<kc_tag_problem_Problem1tID*>(kc_x);
}

problem
Problem1we(casestring _casestring_1, withexpression _withexpression_1) {
    problem kc_x = new kc_tag_problem_Problem1we(_casestring_1, _withexpression_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Problem1we));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Problem1we));
    kc_x->post_create();
    return static_cast<kc_tag_problem_Problem1we*>(kc_x);
}

problem
Problem1ID1ID(casestring _casestring_1, ID _ID_1, casestring _casestring_2, ID _ID_2) {
    problem kc_x = new kc_tag_problem_Problem1ID1ID(_casestring_1, _ID_1, _casestring_2, _ID_2);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Problem1ID1ID));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Problem1ID1ID));
    kc_x->post_create();
    return static_cast<kc_tag_problem_Problem1ID1ID*>(kc_x);
}

problem
Problem1t1ID(casestring _casestring_1, IDtype _IDtype_1, casestring _casestring_2, ID _ID_1) {
    problem kc_x = new kc_tag_problem_Problem1t1ID(_casestring_1, _IDtype_1, _casestring_2, _ID_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Problem1t1ID));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Problem1t1ID));
    kc_x->post_create();
    return static_cast<kc_tag_problem_Problem1t1ID*>(kc_x);
}

problem
Problem1INT(casestring _casestring_1, INT _INT_1) {
    problem kc_x = new kc_tag_problem_Problem1INT(_casestring_1, _INT_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Problem1INT));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Problem1INT));
    kc_x->post_create();
    return static_cast<kc_tag_problem_Problem1INT*>(kc_x);
}

problem
Problem1int1(casestring _casestring_1, integer _integer_1, casestring _casestring_2) {
    problem kc_x = new kc_tag_problem_Problem1int1(_casestring_1, _integer_1, _casestring_2);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Problem1int1));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Problem1int1));
    kc_x->post_create();
    return static_cast<kc_tag_problem_Problem1int1*>(kc_x);
}

problem
Problem1INT1ID(casestring _casestring_1, INT _INT_1, casestring _casestring_2, ID _ID_1) {
    problem kc_x = new kc_tag_problem_Problem1INT1ID(_casestring_1, _INT_1, _casestring_2, _ID_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Problem1INT1ID));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Problem1INT1ID));
    kc_x->post_create();
    return static_cast<kc_tag_problem_Problem1INT1ID*>(kc_x);
}

problem
Problem1ID1ID1ID(casestring _casestring_1, ID _ID_1, casestring _casestring_2, ID _ID_2, casestring _casestring_3, ID _ID_3) {
    problem kc_x = new kc_tag_problem_Problem1ID1ID1ID(_casestring_1, _ID_1, _casestring_2, _ID_2, _casestring_3, _ID_3);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Problem1ID1ID1ID));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Problem1ID1ID1ID));
    kc_x->post_create();
    return static_cast<kc_tag_problem_Problem1ID1ID1ID*>(kc_x);
}

problem
Problem1INT1ID1ID(casestring _casestring_1, INT _INT_1, casestring _casestring_2, ID _ID_1, casestring _casestring_3, ID _ID_2) {
    problem kc_x = new kc_tag_problem_Problem1INT1ID1ID(_casestring_1, _INT_1, _casestring_2, _ID_1, _casestring_3, _ID_2);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Problem1INT1ID1ID));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Problem1INT1ID1ID));
    kc_x->post_create();
    return static_cast<kc_tag_problem_Problem1INT1ID1ID*>(kc_x);
}

problem
Problem1storageoption1ID(casestring _casestring_1, storageoption _storageoption_1, casestring _casestring_2, ID _ID_1) {
    problem kc_x = new kc_tag_problem_Problem1storageoption1ID(_casestring_1, _storageoption_1, _casestring_2, _ID_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Problem1storageoption1ID));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Problem1storageoption1ID));
    kc_x->post_create();
    return static_cast<kc_tag_problem_Problem1storageoption1ID*>(kc_x);
}

problem
Problem2(casestring _casestring_1, casestring _casestring_2) {
    problem kc_x = new kc_tag_problem_Problem2(_casestring_1, _casestring_2);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Problem2));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Problem2));
    kc_x->post_create();
    return static_cast<kc_tag_problem_Problem2*>(kc_x);
}

problem
Problem3(casestring _casestring_1, casestring _casestring_2, casestring _casestring_3) {
    problem kc_x = new kc_tag_problem_Problem3(_casestring_1, _casestring_2, _casestring_3);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Problem3));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Problem3));
    kc_x->post_create();
    return static_cast<kc_tag_problem_Problem3*>(kc_x);
}

problem
Problem3int1(casestring _casestring_1, casestring _casestring_2, casestring _casestring_3, integer _integer_1, casestring _casestring_4) {
    problem kc_x = new kc_tag_problem_Problem3int1(_casestring_1, _casestring_2, _casestring_3, _integer_1, _casestring_4);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Problem3int1));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Problem3int1));
    kc_x->post_create();
    return static_cast<kc_tag_problem_Problem3int1*>(kc_x);
}

problem
Problem4(casestring _casestring_1, casestring _casestring_2, casestring _casestring_3, casestring _casestring_4) {
    problem kc_x = new kc_tag_problem_Problem4(_casestring_1, _casestring_2, _casestring_3, _casestring_4);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Problem4));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Problem4));
    kc_x->post_create();
    return static_cast<kc_tag_problem_Problem4*>(kc_x);
}

problem
Problem5(casestring _casestring_1, casestring _casestring_2, casestring _casestring_3, casestring _casestring_4, casestring _casestring_5) {
    problem kc_x = new kc_tag_problem_Problem5(_casestring_1, _casestring_2, _casestring_3, _casestring_4, _casestring_5);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Problem5));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Problem5));
    kc_x->post_create();
    return static_cast<kc_tag_problem_Problem5*>(kc_x);
}

problem
Problem6(casestring _casestring_1, casestring _casestring_2, casestring _casestring_3, casestring _casestring_4, casestring _casestring_5, casestring _casestring_6) {
    problem kc_x = new kc_tag_problem_Problem6(_casestring_1, _casestring_2, _casestring_3, _casestring_4, _casestring_5, _casestring_6);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Problem6));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Problem6));
    kc_x->post_create();
    return static_cast<kc_tag_problem_Problem6*>(kc_x);
}

addedphylumdeclarations
Niladdedphylumdeclarations() {
    addedphylumdeclarations kc_x = new kc_tag_addedphylumdeclarations();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Niladdedphylumdeclarations));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Niladdedphylumdeclarations));
    kc_x->post_create();
    return static_cast<kc_tag_addedphylumdeclarations*>(kc_x);
}

addedphylumdeclarations
Consaddedphylumdeclarations(addedphylumdeclaration _addedphylumdeclaration_1, addedphylumdeclarations _addedphylumdeclarations_1) {
    addedphylumdeclarations kc_x = new kc_tag_addedphylumdeclarations(_addedphylumdeclaration_1, _addedphylumdeclarations_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consaddedphylumdeclarations));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consaddedphylumdeclarations));
    kc_x->post_create();
    return static_cast<kc_tag_addedphylumdeclarations*>(kc_x);
}

addedphylumdeclaration
AddedPhylumdeclaration(uniqID _uniqID_1) {
    addedphylumdeclaration kc_x = new kc_tag_addedphylumdeclaration_AddedPhylumdeclaration(_uniqID_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AddedPhylumdeclaration));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AddedPhylumdeclaration));
    kc_x->post_create();
    kc_x = kc_initialize_addedphylumdeclaration(kc_x);
    return static_cast<kc_tag_addedphylumdeclaration_AddedPhylumdeclaration*>(kc_x);
}

countedphylumdeclarations
Nilcountedphylumdeclarations() {
    countedphylumdeclarations kc_x = new kc_tag_countedphylumdeclarations();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilcountedphylumdeclarations));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilcountedphylumdeclarations));
    kc_x->post_create();
    return static_cast<kc_tag_countedphylumdeclarations*>(kc_x);
}

countedphylumdeclarations
Conscountedphylumdeclarations(countedphylumdeclaration _countedphylumdeclaration_1, countedphylumdeclarations _countedphylumdeclarations_1) {
    countedphylumdeclarations kc_x = new kc_tag_countedphylumdeclarations(_countedphylumdeclaration_1, _countedphylumdeclarations_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Conscountedphylumdeclarations));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Conscountedphylumdeclarations));
    kc_x->post_create();
    return static_cast<kc_tag_countedphylumdeclarations*>(kc_x);
}

countedphylumdeclaration
CountedPhylumdeclaration(uniqID _uniqID_1) {
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CountedPhylumdeclaration));
    countedphylumdeclaration kc_x=new kc_tag_countedphylumdeclaration_CountedPhylumdeclaration(_uniqID_1);
    countedphylumdeclaration unique_kc_x= kc_hashtables[uniq]->kc_ht_check_insert(kc_x);
    if(unique_kc_x!=kc_x) {
	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CountedPhylumdeclaration));
	kc_x->post_create();
	kc_x = kc_initialize_countedphylumdeclaration(kc_x);
    }
    return static_cast<kc_tag_countedphylumdeclaration_CountedPhylumdeclaration*>(kc_x);
}

charruns
Newlines() {
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Newlines));
    charruns kc_x=new kc_tag_charruns_Newlines();
    charruns unique_kc_x= kc_hashtables[uniq]->kc_ht_check_insert(kc_x);
    if(unique_kc_x!=kc_x) {
	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Newlines));
	kc_x->post_create();
    }
    return static_cast<kc_tag_charruns_Newlines*>(kc_x);
}

charruns
QuotedNewlines() {
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_QuotedNewlines));
    charruns kc_x=new kc_tag_charruns_QuotedNewlines();
    charruns unique_kc_x= kc_hashtables[uniq]->kc_ht_check_insert(kc_x);
    if(unique_kc_x!=kc_x) {
	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_QuotedNewlines));
	kc_x->post_create();
    }
    return static_cast<kc_tag_charruns_QuotedNewlines*>(kc_x);
}

charruns
Stars() {
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Stars));
    charruns kc_x=new kc_tag_charruns_Stars();
    charruns unique_kc_x= kc_hashtables[uniq]->kc_ht_check_insert(kc_x);
    if(unique_kc_x!=kc_x) {
	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Stars));
	kc_x->post_create();
    }
    return static_cast<kc_tag_charruns_Stars*>(kc_x);
}

bindingidmarks
Nilbindingidmarks() {
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilbindingidmarks));
    bindingidmarks kc_x=new kc_tag_bindingidmarks();
    bindingidmarks unique_kc_x= kc_hashtables[uniq]->kc_ht_check_insert(kc_x);
    if(unique_kc_x!=kc_x) {
	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilbindingidmarks));
	kc_x->post_create();
    }
    return static_cast<kc_tag_bindingidmarks*>(kc_x);
}

bindingidmarks
Consbindingidmarks(bindingidmark _bindingidmark_1, bindingidmarks _bindingidmarks_1) {
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consbindingidmarks));
    bindingidmarks kc_x=new kc_tag_bindingidmarks(_bindingidmark_1, _bindingidmarks_1);
    bindingidmarks unique_kc_x= kc_hashtables[uniq]->kc_ht_check_insert(kc_x);
    if(unique_kc_x!=kc_x) {
	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consbindingidmarks));
	kc_x->post_create();
    }
    return static_cast<kc_tag_bindingidmarks*>(kc_x);
}

bindingidmark
BindingIdMark(uniqID _uniqID_1) {
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_BindingIdMark));
    bindingidmark kc_x=new kc_tag_bindingidmark_BindingIdMark(_uniqID_1);
    bindingidmark unique_kc_x= kc_hashtables[uniq]->kc_ht_check_insert(kc_x);
    if(unique_kc_x!=kc_x) {
	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_BindingIdMark));
	kc_x->post_create();
	kc_x = kc_initialize_bindingidmark(kc_x);
    }
    return static_cast<kc_tag_bindingidmark_BindingIdMark*>(kc_x);
}


abstract_phylum
kc_create(kc_enum_operators createOp, abstract_phylum kc_p1, abstract_phylum kc_p2, abstract_phylum kc_p3, abstract_phylum kc_p4, abstract_phylum kc_p5, abstract_phylum kc_p6, abstract_phylum kc_p7)
{
    switch(createOp) {
    case sel__VoidPtr:
    case sel__Int:
    case sel__Real:
    case sel__Str:
    case sel_NoCaseStr:
	assertionFailed("Cannot create this kind of phylum - predefined phyla must be handled seperately");
    case sel_BindingIdMark:
	return BindingIdMark(phylum_cast<uniqID>(kc_p1));
    case sel_Consbindingidmarks:
	return Consbindingidmarks(phylum_cast<bindingidmark>(kc_p1), phylum_cast<bindingidmarks>(kc_p2));
    case sel_Nilbindingidmarks:
	return Nilbindingidmarks();
    case sel_Stars:
	return Stars();
    case sel_QuotedNewlines:
	return QuotedNewlines();
    case sel_Newlines:
	return Newlines();
    case sel_CountedPhylumdeclaration:
	return CountedPhylumdeclaration(phylum_cast<uniqID>(kc_p1));
    case sel_Conscountedphylumdeclarations:
	return Conscountedphylumdeclarations(phylum_cast<countedphylumdeclaration>(kc_p1), phylum_cast<countedphylumdeclarations>(kc_p2));
    case sel_Nilcountedphylumdeclarations:
	return Nilcountedphylumdeclarations();
    case sel_AddedPhylumdeclaration:
	return AddedPhylumdeclaration(phylum_cast<uniqID>(kc_p1));
    case sel_Consaddedphylumdeclarations:
	return Consaddedphylumdeclarations(phylum_cast<addedphylumdeclaration>(kc_p1), phylum_cast<addedphylumdeclarations>(kc_p2));
    case sel_Niladdedphylumdeclarations:
	return Niladdedphylumdeclarations();
    case sel_Problem6:
	return Problem6(phylum_cast<casestring>(kc_p1), phylum_cast<casestring>(kc_p2), phylum_cast<casestring>(kc_p3), phylum_cast<casestring>(kc_p4), phylum_cast<casestring>(kc_p5), phylum_cast<casestring>(kc_p6));
    case sel_Problem5:
	return Problem5(phylum_cast<casestring>(kc_p1), phylum_cast<casestring>(kc_p2), phylum_cast<casestring>(kc_p3), phylum_cast<casestring>(kc_p4), phylum_cast<casestring>(kc_p5));
    case sel_Problem4:
	return Problem4(phylum_cast<casestring>(kc_p1), phylum_cast<casestring>(kc_p2), phylum_cast<casestring>(kc_p3), phylum_cast<casestring>(kc_p4));
    case sel_Problem3int1:
	return Problem3int1(phylum_cast<casestring>(kc_p1), phylum_cast<casestring>(kc_p2), phylum_cast<casestring>(kc_p3), phylum_cast<integer>(kc_p4), phylum_cast<casestring>(kc_p5));
    case sel_Problem3:
	return Problem3(phylum_cast<casestring>(kc_p1), phylum_cast<casestring>(kc_p2), phylum_cast<casestring>(kc_p3));
    case sel_Problem2:
	return Problem2(phylum_cast<casestring>(kc_p1), phylum_cast<casestring>(kc_p2));
    case sel_Problem1storageoption1ID:
	return Problem1storageoption1ID(phylum_cast<casestring>(kc_p1), phylum_cast<storageoption>(kc_p2), phylum_cast<casestring>(kc_p3), phylum_cast<ID>(kc_p4));
    case sel_Problem1INT1ID1ID:
	return Problem1INT1ID1ID(phylum_cast<casestring>(kc_p1), phylum_cast<INT>(kc_p2), phylum_cast<casestring>(kc_p3), phylum_cast<ID>(kc_p4), phylum_cast<casestring>(kc_p5), phylum_cast<ID>(kc_p6));
    case sel_Problem1ID1ID1ID:
	return Problem1ID1ID1ID(phylum_cast<casestring>(kc_p1), phylum_cast<ID>(kc_p2), phylum_cast<casestring>(kc_p3), phylum_cast<ID>(kc_p4), phylum_cast<casestring>(kc_p5), phylum_cast<ID>(kc_p6));
    case sel_Problem1INT1ID:
	return Problem1INT1ID(phylum_cast<casestring>(kc_p1), phylum_cast<INT>(kc_p2), phylum_cast<casestring>(kc_p3), phylum_cast<ID>(kc_p4));
    case sel_Problem1int1:
	return Problem1int1(phylum_cast<casestring>(kc_p1), phylum_cast<integer>(kc_p2), phylum_cast<casestring>(kc_p3));
    case sel_Problem1INT:
	return Problem1INT(phylum_cast<casestring>(kc_p1), phylum_cast<INT>(kc_p2));
    case sel_Problem1t1ID:
	return Problem1t1ID(phylum_cast<casestring>(kc_p1), phylum_cast<IDtype>(kc_p2), phylum_cast<casestring>(kc_p3), phylum_cast<ID>(kc_p4));
    case sel_Problem1ID1ID:
	return Problem1ID1ID(phylum_cast<casestring>(kc_p1), phylum_cast<ID>(kc_p2), phylum_cast<casestring>(kc_p3), phylum_cast<ID>(kc_p4));
    case sel_Problem1we:
	return Problem1we(phylum_cast<casestring>(kc_p1), phylum_cast<withexpression>(kc_p2));
    case sel_Problem1tID:
	return Problem1tID(phylum_cast<casestring>(kc_p1), phylum_cast<ID>(kc_p2));
    case sel_Problem1ID:
	return Problem1ID(phylum_cast<casestring>(kc_p1), phylum_cast<ID>(kc_p2));
    case sel_Problem1:
	return Problem1(phylum_cast<casestring>(kc_p1));
    case sel_Warning:
	return Warning(phylum_cast<fileline>(kc_p1), phylum_cast<problem>(kc_p2));
    case sel_NonFatal:
	return NonFatal(phylum_cast<fileline>(kc_p1), phylum_cast<problem>(kc_p2));
    case sel_Fatal:
	return Fatal(phylum_cast<fileline>(kc_p1), phylum_cast<problem>(kc_p2));
    case sel_Consbaseclass_list:
	return Consbaseclass_list(phylum_cast<ID>(kc_p1), phylum_cast<baseclass_list>(kc_p2));
    case sel_Nilbaseclass_list:
	return Nilbaseclass_list();
    case sel_BaseClassDecl:
	return BaseClassDecl(phylum_cast<ID>(kc_p1), phylum_cast<baseclass_list>(kc_p2));
    case sel_Consbaseclass_declarations:
	return Consbaseclass_declarations(phylum_cast<baseclass_decl>(kc_p1), phylum_cast<baseclass_declarations>(kc_p2));
    case sel_Nilbaseclass_declarations:
	return Nilbaseclass_declarations();
    case sel_AcBaseInit:
	return AcBaseInit(phylum_cast<ID>(kc_p1), phylum_cast<ac_constant_expression>(kc_p2));
    case sel_Consac_base_init_list:
	return Consac_base_init_list(phylum_cast<ac_base_init>(kc_p1), phylum_cast<ac_base_init_list>(kc_p2));
    case sel_Nilac_base_init_list:
	return Nilac_base_init_list();
    case sel_AcYesBaseInit:
	return AcYesBaseInit(phylum_cast<ac_base_init_list>(kc_p1));
    case sel_AcNoBaseInit:
	return AcNoBaseInit();
    case sel_Consac_constant_expression_list:
	return Consac_constant_expression_list(phylum_cast<ac_constant_expression>(kc_p1), phylum_cast<ac_constant_expression_list>(kc_p2));
    case sel_Nilac_constant_expression_list:
	return Nilac_constant_expression_list();
    case sel_AcConstExpr:
	return AcConstExpr(phylum_cast<Cexpression>(kc_p1));
    case sel_Noac_constant_expression:
	return Noac_constant_expression();
    case sel_Yesac_constant_expression:
	return Yesac_constant_expression(phylum_cast<ac_constant_expression>(kc_p1));
    case sel_AcDirAbsdeclFn:
	return AcDirAbsdeclFn(phylum_cast<ac_direct_abstract_declarator_option>(kc_p1), phylum_cast<ac_parameter_type_list>(kc_p2));
    case sel_AcDirAbsdeclArray:
	return AcDirAbsdeclArray(phylum_cast<ac_direct_abstract_declarator_option>(kc_p1), phylum_cast<ac_constant_expression_option>(kc_p2));
    case sel_AcDirAbsdeclPack:
	return AcDirAbsdeclPack(phylum_cast<ac_abstract_declarator>(kc_p1));
    case sel_Yesac_direct_abstract_declarator:
	return Yesac_direct_abstract_declarator(phylum_cast<ac_direct_abstract_declarator>(kc_p1));
    case sel_Noac_direct_abstract_declarator:
	return Noac_direct_abstract_declarator();
    case sel_AcAbsdeclDirdecl:
	return AcAbsdeclDirdecl(phylum_cast<ac_pointer_option>(kc_p1), phylum_cast<ac_direct_abstract_declarator>(kc_p2));
    case sel_AcAbsdeclPointer:
	return AcAbsdeclPointer(phylum_cast<ac_pointer>(kc_p1));
    case sel_Consac_identifier_list:
	return Consac_identifier_list(phylum_cast<ID>(kc_p1), phylum_cast<ac_identifier_list>(kc_p2));
    case sel_Nilac_identifier_list:
	return Nilac_identifier_list();
    case sel_AcParDeclAbsdecl:
	return AcParDeclAbsdecl(phylum_cast<ac_declaration_specifiers>(kc_p1), phylum_cast<ac_abstract_declarator>(kc_p2), phylum_cast<ac_constant_expression_option>(kc_p3));
    case sel_AcParDeclDecl:
	return AcParDeclDecl(phylum_cast<ac_declaration_specifiers>(kc_p1), phylum_cast<ac_declarator>(kc_p2), phylum_cast<ac_constant_expression_option>(kc_p3));
    case sel_Consac_parameter_list:
	return Consac_parameter_list(phylum_cast<ac_parameter_declaration>(kc_p1), phylum_cast<ac_parameter_list>(kc_p2));
    case sel_Nilac_parameter_list:
	return Nilac_parameter_list();
    case sel_AcParList3Dot:
	return AcParList3Dot(phylum_cast<ac_parameter_list>(kc_p1));
    case sel_AcParList:
	return AcParList(phylum_cast<ac_parameter_list>(kc_p1));
    case sel_Consac_type_qualifier_list:
	return Consac_type_qualifier_list(phylum_cast<ac_type_qualifier>(kc_p1), phylum_cast<ac_type_qualifier_list>(kc_p2));
    case sel_Nilac_type_qualifier_list:
	return Nilac_type_qualifier_list();
    case sel_Consac_class_qualifier_list:
	return Consac_class_qualifier_list(phylum_cast<ID>(kc_p1), phylum_cast<ac_class_qualifier_list>(kc_p2));
    case sel_Nilac_class_qualifier_list:
	return Nilac_class_qualifier_list();
    case sel_Consac_class_qualifier_help_list:
	return Consac_class_qualifier_help_list(phylum_cast<ac_direct_declarator>(kc_p1), phylum_cast<ac_class_qualifier_help_list>(kc_p2));
    case sel_Nilac_class_qualifier_help_list:
	return Nilac_class_qualifier_help_list();
    case sel_AcOperatorName:
	return AcOperatorName(phylum_cast<casestring>(kc_p1));
    case sel_AcRef:
	return AcRef();
    case sel_AcNoRef:
	return AcNoRef();
    case sel_AcPointerCons:
	return AcPointerCons(phylum_cast<ac_type_qualifier_list>(kc_p1), phylum_cast<ac_pointer>(kc_p2));
    case sel_AcPointerNil:
	return AcPointerNil(phylum_cast<ac_type_qualifier_list>(kc_p1));
    case sel_Yespointer:
	return Yespointer(phylum_cast<ac_pointer>(kc_p1));
    case sel_Nopointer:
	return Nopointer();
    case sel_AcOperatorDeclId:
	return AcOperatorDeclId(phylum_cast<ac_operator_name>(kc_p1));
    case sel_AcMemberDecl:
	return AcMemberDecl(phylum_cast<ID>(kc_p1), phylum_cast<ID>(kc_p2), phylum_cast<ac_constant_expression_list>(kc_p3));
    case sel_AcQualifiedDeclProto:
	return AcQualifiedDeclProto(phylum_cast<ac_class_qualifier_list>(kc_p1), phylum_cast<ac_direct_declarator>(kc_p2), phylum_cast<ac_parameter_type_list>(kc_p3), phylum_cast<ac_type_qualifier>(kc_p4));
    case sel_AcDirectDeclProto:
	return AcDirectDeclProto(phylum_cast<ac_direct_declarator>(kc_p1), phylum_cast<ac_parameter_type_list>(kc_p2));
    case sel_AcDirectDeclArray:
	return AcDirectDeclArray(phylum_cast<ac_direct_declarator>(kc_p1), phylum_cast<ac_constant_expression_option>(kc_p2));
    case sel_AcDirectDeclPack:
	return AcDirectDeclPack(phylum_cast<ac_declarator>(kc_p1));
    case sel_AcDirectDeclId:
	return AcDirectDeclId(phylum_cast<ID>(kc_p1));
    case sel_AcDeclarator:
	return AcDeclarator(phylum_cast<ac_pointer_option>(kc_p1), phylum_cast<ac_ref_option>(kc_p2), phylum_cast<ac_direct_declarator>(kc_p3));
    case sel_AcInitDecl:
	return AcInitDecl(phylum_cast<ac_declarator>(kc_p1));
    case sel_Consac_init_declarator_list:
	return Consac_init_declarator_list(phylum_cast<ac_init_declarator>(kc_p1), phylum_cast<ac_init_declarator_list>(kc_p2));
    case sel_Nilac_init_declarator_list:
	return Nilac_init_declarator_list();
    case sel_AcNoQualifier:
	return AcNoQualifier();
    case sel_AcUnsigned:
	return AcUnsigned();
    case sel_AcVolatile:
	return AcVolatile();
    case sel_AcConst:
	return AcConst();
    case sel_AcTypeSpec:
	return AcTypeSpec(phylum_cast<ID>(kc_p1));
    case sel_AcVirtual:
	return AcVirtual();
    case sel_AcTypedef:
	return AcTypedef();
    case sel_AcExtern:
	return AcExtern();
    case sel_AcStatic:
	return AcStatic();
    case sel_AcRegister:
	return AcRegister();
    case sel_AcAuto:
	return AcAuto();
    case sel_AcDeclSpecTypeQual:
	return AcDeclSpecTypeQual(phylum_cast<ac_type_qualifier>(kc_p1));
    case sel_AcDeclSpecTypeSpec:
	return AcDeclSpecTypeSpec(phylum_cast<ac_type_specifier>(kc_p1));
    case sel_AcDeclSpecStorageSpec:
	return AcDeclSpecStorageSpec(phylum_cast<ac_storage_class_specifier>(kc_p1));
    case sel_Consac_declaration_specifiers:
	return Consac_declaration_specifiers(phylum_cast<ac_declaration_specifier>(kc_p1), phylum_cast<ac_declaration_specifiers>(kc_p2));
    case sel_Nilac_declaration_specifiers:
	return Nilac_declaration_specifiers();
    case sel_Consac_declaration_list:
	return Consac_declaration_list(phylum_cast<ac_declaration>(kc_p1), phylum_cast<ac_declaration_list>(kc_p2));
    case sel_Nilac_declaration_list:
	return Nilac_declaration_list();
    case sel_AcDeclaration:
	return AcDeclaration(phylum_cast<ac_declaration_specifiers>(kc_p1), phylum_cast<ac_init_declarator_list>(kc_p2));
    case sel_Unparsedeclinfo:
	return Unparsedeclinfo(phylum_cast<patternrepresentation>(kc_p1), phylum_cast<patternrepresentation>(kc_p2), phylum_cast<unparseclause>(kc_p3));
    case sel_Consunparsedeclsinfo:
	return Consunparsedeclsinfo(phylum_cast<unparsedeclinfo>(kc_p1), phylum_cast<unparsedeclsinfo>(kc_p2));
    case sel_Nilunparsedeclsinfo:
	return Nilunparsedeclsinfo();
    case sel_Unparseviewinfo:
	return Unparseviewinfo(phylum_cast<ID>(kc_p1), phylum_cast<unparsedeclsinfo>(kc_p2));
    case sel_Consunparseviewsinfo:
	return Consunparseviewsinfo(phylum_cast<unparseviewinfo>(kc_p1), phylum_cast<unparseviewsinfo>(kc_p2));
    case sel_Nilunparseviewsinfo:
	return Nilunparseviewsinfo();
    case sel_Rewriteviewinfo:
	return Rewriteviewinfo(phylum_cast<ID>(kc_p1), phylum_cast<rewriterulesinfo>(kc_p2));
    case sel_Consrewriteviewsinfo:
	return Consrewriteviewsinfo(phylum_cast<rewriteviewinfo>(kc_p1), phylum_cast<rewriteviewsinfo>(kc_p2));
    case sel_Nilrewriteviewsinfo:
	return Nilrewriteviewsinfo();
    case sel_Withcaseinfo:
	return Withcaseinfo(phylum_cast<patternrepresentation>(kc_p1), phylum_cast<patternrepresentation>(kc_p2), phylum_cast<Ctext>(kc_p3));
    case sel_Conswithcasesinfo:
	return Conswithcasesinfo(phylum_cast<withcaseinfo>(kc_p1), phylum_cast<withcasesinfo>(kc_p2));
    case sel_Nilwithcasesinfo:
	return Nilwithcasesinfo();
    case sel_Rewriteruleinfo:
	return Rewriteruleinfo(phylum_cast<patternrepresentation>(kc_p1), phylum_cast<patternrepresentation>(kc_p2), phylum_cast<rewriteclause>(kc_p3));
    case sel_Consrewriterulesinfo:
	return Consrewriterulesinfo(phylum_cast<rewriteruleinfo>(kc_p1), phylum_cast<rewriterulesinfo>(kc_p2));
    case sel_Nilrewriterulesinfo:
	return Nilrewriterulesinfo();
    case sel_Consargsnumbers:
	return Consargsnumbers(phylum_cast<integer>(kc_p1), phylum_cast<argsnumbers>(kc_p2));
    case sel_Nilargsnumbers:
	return Nilargsnumbers();
    case sel_Conspaths:
	return Conspaths(phylum_cast<path>(kc_p1), phylum_cast<paths>(kc_p2));
    case sel_Nilpaths:
	return Nilpaths();
    case sel_Conspath:
	return Conspath(phylum_cast<integer>(kc_p1), phylum_cast<path>(kc_p2));
    case sel_Nilpath:
	return Nilpath();
    case sel_PRIntLiteral:
	return PRIntLiteral(phylum_cast<path>(kc_p1), phylum_cast<INT>(kc_p2));
    case sel_PRStringLiteral:
	return PRStringLiteral(phylum_cast<path>(kc_p1), phylum_cast<CexpressionDQ>(kc_p2));
    case sel_PRDefault:
	return PRDefault();
    case sel_PRWildcard:
	return PRWildcard(phylum_cast<path>(kc_p1));
    case sel_PRNonLeafBinding:
	return PRNonLeafBinding(phylum_cast<path>(kc_p1), phylum_cast<ID>(kc_p2), phylum_cast<patternrepresentation>(kc_p3));
    case sel_PRUserPredicate:
	return PRUserPredicate(phylum_cast<Cexpression>(kc_p1));
    case sel_PROperPredicate:
	return PROperPredicate(phylum_cast<path>(kc_p1), phylum_cast<ID>(kc_p2));
    case sel_PRVarPredicate:
	return PRVarPredicate(phylum_cast<paths>(kc_p1), phylum_cast<ID>(kc_p2), phylum_cast<patternrepresentation>(kc_p3));
    case sel_PRBinding:
	return PRBinding(phylum_cast<path>(kc_p1), phylum_cast<ID>(kc_p2));
    case sel_Conspatternrepresentation:
	return Conspatternrepresentation(phylum_cast<elem_patternrepresentation>(kc_p1), phylum_cast<patternrepresentation>(kc_p2));
    case sel_Nilpatternrepresentation:
	return Nilpatternrepresentation();
    case sel_Conspatternrepresentations:
	return Conspatternrepresentations(phylum_cast<patternrepresentation>(kc_p1), phylum_cast<patternrepresentations>(kc_p2));
    case sel_Nilpatternrepresentations:
	return Nilpatternrepresentations();
    case sel_Bigger:
	return Bigger();
    case sel_Smaller:
	return Smaller();
    case sel_Equal:
	return Equal();
    case sel_TwoPath:
	return TwoPath(phylum_cast<path>(kc_p1), phylum_cast<path>(kc_p2));
    case sel_TwoPaths:
	return TwoPaths(phylum_cast<paths>(kc_p1), phylum_cast<paths>(kc_p2));
    case sel_TwoElem_patternrepresentation:
	return TwoElem_patternrepresentation(phylum_cast<elem_patternrepresentation>(kc_p1), phylum_cast<elem_patternrepresentation>(kc_p2));
    case sel_TwoPatternrepresentation:
	return TwoPatternrepresentation(phylum_cast<patternrepresentation>(kc_p1), phylum_cast<patternrepresentation>(kc_p2));
    case sel_TwoUnparsedeclinfo:
	return TwoUnparsedeclinfo(phylum_cast<unparsedeclinfo>(kc_p1), phylum_cast<unparsedeclinfo>(kc_p2));
    case sel_TwoWithcaseinfo:
	return TwoWithcaseinfo(phylum_cast<withcaseinfo>(kc_p1), phylum_cast<withcaseinfo>(kc_p2));
    case sel_TwoRewriteruleinfo:
	return TwoRewriteruleinfo(phylum_cast<rewriteruleinfo>(kc_p1), phylum_cast<rewriteruleinfo>(kc_p2));
    case sel_TwoCcode_option:
	return TwoCcode_option(phylum_cast<Ccode_option>(kc_p1), phylum_cast<Ccode_option>(kc_p2));
    case sel_TwoProductionblock:
	return TwoProductionblock(phylum_cast<productionblock>(kc_p1), phylum_cast<productionblock>(kc_p2));
    case sel_TwoStorageoption:
	return TwoStorageoption(phylum_cast<storageoption>(kc_p1), phylum_cast<storageoption>(kc_p2));
    case sel_DVDisallowed:
	return DVDisallowed();
    case sel_DVAllowed:
	return DVAllowed();
    case sel_Consvariables:
	return Consvariables(phylum_cast<ID>(kc_p1), phylum_cast<variables>(kc_p2));
    case sel_Nilvariables:
	return Nilvariables();
    case sel_Consphyla:
	return Consphyla(phylum_cast<ID>(kc_p1), phylum_cast<phyla>(kc_p2));
    case sel_Nilphyla:
	return Nilphyla();
    case sel_Consoperators:
	return Consoperators(phylum_cast<ID>(kc_p1), phylum_cast<operators>(kc_p2));
    case sel_Niloperators:
	return Niloperators();
    case sel_ITLanguageName:
	return ITLanguageName(phylum_cast<integer>(kc_p1));
    case sel_ITPatternVariable:
	return ITPatternVariable(phylum_cast<ID>(kc_p1), phylum_cast<integer>(kc_p2));
    case sel_ITUserFunction:
	return ITUserFunction(phylum_cast<fnclass>(kc_p1));
    case sel_ITUserRView:
	return ITUserRView();
    case sel_ITPredefinedRView:
	return ITPredefinedRView();
    case sel_ITUViewVar:
	return ITUViewVar();
    case sel_ITUserUView:
	return ITUserUView();
    case sel_ITPredefinedUView:
	return ITPredefinedUView();
    case sel_ITStorageClass:
	return ITStorageClass();
    case sel_ITPredefinedStorageClass:
	return ITPredefinedStorageClass();
    case sel_ITUserOperator:
	return ITUserOperator(phylum_cast<alternative>(kc_p1), phylum_cast<ID>(kc_p2));
    case sel_ITPredefinedOperator:
	return ITPredefinedOperator(phylum_cast<alternative>(kc_p1), phylum_cast<ID>(kc_p2));
    case sel_ITUserPhylum:
	return ITUserPhylum(phylum_cast<phylumdeclaration>(kc_p1));
    case sel_ITPredefinedPhylum:
	return ITPredefinedPhylum(phylum_cast<phylumdeclaration>(kc_p1));
    case sel_ITUnknown:
	return ITUnknown();
    case sel_ScopeTypeFileLine:
	return ScopeTypeFileLine(phylum_cast<integer>(kc_p1), phylum_cast<IDtype>(kc_p2), phylum_cast<casestring>(kc_p3), phylum_cast<integer>(kc_p4));
    case sel_Consscopetypefilelinestack:
	return Consscopetypefilelinestack(phylum_cast<scopetypefileline>(kc_p1), phylum_cast<scopetypefilelinestack>(kc_p2));
    case sel_Nilscopetypefilelinestack:
	return Nilscopetypefilelinestack();
    case sel_PosNoFileLine:
	return PosNoFileLine();
    case sel_NoFileLine:
	return NoFileLine();
    case sel_FileLine:
	return FileLine();
    case sel_Conslanguagenames:
	return Conslanguagenames(phylum_cast<ID>(kc_p1), phylum_cast<languagenames>(kc_p2));
    case sel_Nillanguagenames:
	return Nillanguagenames();
    case sel_LanguageList:
	return LanguageList(phylum_cast<languagenames>(kc_p1));
    case sel_NoLanguagename:
	return NoLanguagename();
    case sel_YesViewname:
	return YesViewname(phylum_cast<ID>(kc_p1));
    case sel_NoViewname:
	return NoViewname();
    case sel_Consunpattributes:
	return Consunpattributes(phylum_cast<ID>(kc_p1), phylum_cast<unpattributes>(kc_p2));
    case sel_Nilunpattributes:
	return Nilunpattributes();
    case sel_UnpCastedVariable:
	return UnpCastedVariable(phylum_cast<ID>(kc_p1), phylum_cast<ID>(kc_p2));
    case sel_UnpDollarvarAttr:
	return UnpDollarvarAttr(phylum_cast<INT>(kc_p1), phylum_cast<unpattributes>(kc_p2));
    case sel_UnpSubAttr:
	return UnpSubAttr(phylum_cast<ID>(kc_p1), phylum_cast<unpattributes>(kc_p2));
    case sel_UnpDollarvarTerm:
	return UnpDollarvarTerm(phylum_cast<INT>(kc_p1));
    case sel_UnpSubTerm:
	return UnpSubTerm(phylum_cast<ID>(kc_p1));
    case sel_UViewVarDecl:
	return UViewVarDecl(phylum_cast<ID>(kc_p1), phylum_cast<ID>(kc_p2), phylum_cast<Cexpression>(kc_p3));
    case sel_UnpBody:
	return UnpBody(phylum_cast<languageoption>(kc_p1), phylum_cast<unparseitems>(kc_p2));
    case sel_UnpCtext:
	return UnpCtext(phylum_cast<languageoption>(kc_p1), phylum_cast<Ctext>(kc_p2));
    case sel_UnpSubexpr:
	return UnpSubexpr(phylum_cast<languageoption>(kc_p1), phylum_cast<unpsubterm>(kc_p2), phylum_cast<viewnameoption>(kc_p3));
    case sel_UnpStr:
	return UnpStr(phylum_cast<languageoption>(kc_p1), phylum_cast<CexpressionDQ>(kc_p2), phylum_cast<viewnameoption>(kc_p3));
    case sel_Consunparseitems:
	return Consunparseitems(phylum_cast<unparseitem>(kc_p1), phylum_cast<unparseitems>(kc_p2));
    case sel_Nilunparseitems:
	return Nilunparseitems();
    case sel_Consviewnames:
	return Consviewnames(phylum_cast<ID>(kc_p1), phylum_cast<viewnames>(kc_p2));
    case sel_Nilviewnames:
	return Nilviewnames();
    case sel_UnparseClause:
	return UnparseClause(phylum_cast<viewnames>(kc_p1), phylum_cast<unparseitems>(kc_p2));
    case sel_Consunparseclauses:
	return Consunparseclauses(phylum_cast<unparseclause>(kc_p1), phylum_cast<unparseclauses>(kc_p2));
    case sel_Nilunparseclauses:
	return Nilunparseclauses();
    case sel_UnparseDeclaration:
	return UnparseDeclaration(phylum_cast<outmostpatterns>(kc_p1), phylum_cast<unparseclauses>(kc_p2));
    case sel_Consunparsedeclarations:
	return Consunparsedeclarations(phylum_cast<unparsedeclaration>(kc_p1), phylum_cast<unparsedeclarations>(kc_p2));
    case sel_Nilunparsedeclarations:
	return Nilunparsedeclarations();
    case sel_Withcase:
	return Withcase(phylum_cast<patternchains>(kc_p1), phylum_cast<Ctext>(kc_p2));
    case sel_Conswithcases:
	return Conswithcases(phylum_cast<withcase>(kc_p1), phylum_cast<withcases>(kc_p2));
    case sel_Nilwithcases:
	return Nilwithcases();
    case sel_WECexpression:
	return WECexpression(phylum_cast<Cexpression>(kc_p1));
    case sel_WEVariable:
	return WEVariable(phylum_cast<ID>(kc_p1));
    case sel_Conswithexpressions:
	return Conswithexpressions(phylum_cast<withexpression>(kc_p1), phylum_cast<withexpressions>(kc_p2));
    case sel_Nilwithexpressions:
	return Nilwithexpressions();
    case sel_NotInForeachContext:
	return NotInForeachContext();
    case sel_InForeachContext:
	return InForeachContext(phylum_cast<patternchain>(kc_p1));
    case sel_ForeachAfter:
	return ForeachAfter(phylum_cast<patternchain>(kc_p1), phylum_cast<idCexpressions>(kc_p2), phylum_cast<withexpressions>(kc_p3), phylum_cast<Ctext>(kc_p4));
    case sel_NoForeachAfter:
	return NoForeachAfter();
    case sel_CTextWithexpression:
	return CTextWithexpression(phylum_cast<withexpressions>(kc_p1), phylum_cast<withcases>(kc_p2), phylum_cast<contextinfo>(kc_p3));
    case sel_CTextForeachexpression:
	return CTextForeachexpression(phylum_cast<patternchain>(kc_p1), phylum_cast<idCexpressions>(kc_p2), phylum_cast<withexpressions>(kc_p3), phylum_cast<Ctext>(kc_p4), phylum_cast<foreach_after>(kc_p5));
    case sel_CTextCbody:
	return CTextCbody(phylum_cast<Ctext>(kc_p1));
    case sel_CTextCexpressionSQ:
	return CTextCexpressionSQ(phylum_cast<CexpressionSQ>(kc_p1));
    case sel_CTextCexpressionDQ:
	return CTextCexpressionDQ(phylum_cast<CexpressionDQ>(kc_p1));
    case sel_CTextNl:
	return CTextNl(phylum_cast<integer>(kc_p1));
    case sel_CTextDollarVar:
	return CTextDollarVar(phylum_cast<INT>(kc_p1));
    case sel_CTextLine:
	return CTextLine(phylum_cast<casestring>(kc_p1));
    case sel_ConsCtext:
	return ConsCtext(phylum_cast<Ctext_elem>(kc_p1), phylum_cast<Ctext>(kc_p2));
    case sel_NilCtext:
	return NilCtext();
    case sel_DestructorFn:
	return DestructorFn();
    case sel_ConstructorFn:
	return ConstructorFn();
    case sel_MemberFn:
	return MemberFn();
    case sel_StaticFn:
	return StaticFn(phylum_cast<casestring>(kc_p1));
    case sel_GlobalFn:
	return GlobalFn();
    case sel_AcMemberDeclaration:
	return AcMemberDeclaration(phylum_cast<ac_declaration_specifiers>(kc_p1), phylum_cast<ac_declarator>(kc_p2), phylum_cast<ac_constant_expression_option>(kc_p3), phylum_cast<fnclass>(kc_p4));
    case sel_FnAcDeclaration:
	return FnAcDeclaration(phylum_cast<ac_declaration_specifiers>(kc_p1), phylum_cast<ac_declarator>(kc_p2), phylum_cast<ac_declaration_list>(kc_p3), phylum_cast<ac_opt_base_init_list>(kc_p4), phylum_cast<Ctext>(kc_p5), phylum_cast<ID>(kc_p6), phylum_cast<fnclass>(kc_p7));
    case sel_Consfndeclarations:
	return Consfndeclarations(phylum_cast<fndeclaration>(kc_p1), phylum_cast<fndeclarations>(kc_p2));
    case sel_Nilfndeclarations:
	return Nilfndeclarations();
    case sel_FnFile:
	return FnFile(phylum_cast<casestring>(kc_p1));
    case sel_Consfnfiles:
	return Consfnfiles(phylum_cast<fnfile>(kc_p1), phylum_cast<fnfiles>(kc_p2));
    case sel_Nilfnfiles:
	return Nilfnfiles();
    case sel_Consterms:
	return Consterms(phylum_cast<term>(kc_p1), phylum_cast<terms>(kc_p2));
    case sel_Nilterms:
	return Nilterms();
    case sel_TIntLiteral:
	return TIntLiteral(phylum_cast<INT>(kc_p1));
    case sel_TStringLiteral:
	return TStringLiteral(phylum_cast<CexpressionDQ>(kc_p1));
    case sel_TCTerm:
	return TCTerm(phylum_cast<CexpressionSQ>(kc_p1));
    case sel_TMethod:
	return TMethod(phylum_cast<term>(kc_p1), phylum_cast<ID>(kc_p2), phylum_cast<terms>(kc_p3));
    case sel_TOperator:
	return TOperator(phylum_cast<ID>(kc_p1), phylum_cast<terms>(kc_p2));
    case sel_TVariable:
	return TVariable(phylum_cast<ID>(kc_p1));
    case sel_Conspatterns:
	return Conspatterns(phylum_cast<pattern>(kc_p1), phylum_cast<patterns>(kc_p2));
    case sel_Nilpatterns:
	return Nilpatterns();
    case sel_PIntLiteral:
	return PIntLiteral(phylum_cast<INT>(kc_p1));
    case sel_PStringLiteral:
	return PStringLiteral(phylum_cast<CexpressionDQ>(kc_p1));
    case sel_PWildcard:
	return PWildcard();
    case sel_PNonLeafVariable:
	return PNonLeafVariable(phylum_cast<ID>(kc_p1), phylum_cast<pattern>(kc_p2));
    case sel_POperator:
	return POperator(phylum_cast<ID>(kc_p1), phylum_cast<patterns>(kc_p2));
    case sel_PVariable:
	return PVariable(phylum_cast<ID>(kc_p1));
    case sel_OPDefault:
	return OPDefault(phylum_cast<Cexpression>(kc_p1));
    case sel_OPWildcard:
	return OPWildcard(phylum_cast<Cexpression>(kc_p1));
    case sel_OPNonLeafVariable:
	return OPNonLeafVariable(phylum_cast<ID>(kc_p1), phylum_cast<outmostpattern>(kc_p2));
    case sel_OPOperator:
	return OPOperator(phylum_cast<ID>(kc_p1), phylum_cast<patterns>(kc_p2), phylum_cast<Cexpression>(kc_p3));
    case sel_OPOperatorWildcard:
	return OPOperatorWildcard(phylum_cast<ID>(kc_p1), phylum_cast<Cexpression>(kc_p2));
    case sel_PatternchainitemDollarid:
	return PatternchainitemDollarid(phylum_cast<ID>(kc_p1));
    case sel_PatternchainitemGroup:
	return PatternchainitemGroup(phylum_cast<patternchains>(kc_p1));
    case sel_PatternchainitemOutmost:
	return PatternchainitemOutmost(phylum_cast<outmostpattern>(kc_p1));
    case sel_Consoutmostpatterns:
	return Consoutmostpatterns(phylum_cast<outmostpattern>(kc_p1), phylum_cast<outmostpatterns>(kc_p2));
    case sel_Niloutmostpatterns:
	return Niloutmostpatterns();
    case sel_Conspatternchain:
	return Conspatternchain(phylum_cast<patternchainitem>(kc_p1), phylum_cast<patternchain>(kc_p2));
    case sel_Nilpatternchain:
	return Nilpatternchain();
    case sel_Conspatternchains:
	return Conspatternchains(phylum_cast<patternchain>(kc_p1), phylum_cast<patternchains>(kc_p2));
    case sel_Nilpatternchains:
	return Nilpatternchains();
    case sel_RewriteClause:
	return RewriteClause(phylum_cast<viewnames>(kc_p1), phylum_cast<term>(kc_p2));
    case sel_Consrewriteclauses:
	return Consrewriteclauses(phylum_cast<rewriteclause>(kc_p1), phylum_cast<rewriteclauses>(kc_p2));
    case sel_Nilrewriteclauses:
	return Nilrewriteclauses();
    case sel_RwDeclaration:
	return RwDeclaration(phylum_cast<outmostpatterns>(kc_p1), phylum_cast<rewriteclauses>(kc_p2));
    case sel_Consrwdeclarations:
	return Consrwdeclarations(phylum_cast<rwdeclaration>(kc_p1), phylum_cast<rwdeclarations>(kc_p2));
    case sel_Nilrwdeclarations:
	return Nilrwdeclarations();
    case sel_IncludeDeclaration:
	return IncludeDeclaration(phylum_cast<casestring>(kc_p1));
    case sel_Consincludedeclarations:
	return Consincludedeclarations(phylum_cast<includedeclaration>(kc_p1), phylum_cast<includedeclarations>(kc_p2));
    case sel_Nilincludedeclarations:
	return Nilincludedeclarations();
    case sel_IncludeFile:
	return IncludeFile(phylum_cast<casestring>(kc_p1));
    case sel_Consincludefiles:
	return Consincludefiles(phylum_cast<includefile>(kc_p1), phylum_cast<includefiles>(kc_p2));
    case sel_Nilincludefiles:
	return Nilincludefiles();
    case sel_ConsCtexts:
	return ConsCtexts(phylum_cast<Ctext>(kc_p1), phylum_cast<Ctexts>(kc_p2));
    case sel_NilCtexts:
	return NilCtexts();
    case sel_IdCexpression:
	return IdCexpression(phylum_cast<ID>(kc_p1), phylum_cast<Cexpression>(kc_p2));
    case sel_ConsidCexpressions:
	return ConsidCexpressions(phylum_cast<idCexpression>(kc_p1), phylum_cast<idCexpressions>(kc_p2));
    case sel_NilidCexpressions:
	return NilidCexpressions();
    case sel_CExpressionSQNl:
	return CExpressionSQNl(phylum_cast<integer>(kc_p1));
    case sel_CExpressionSQPart:
	return CExpressionSQPart(phylum_cast<casestring>(kc_p1));
    case sel_ConsCexpressionSQ:
	return ConsCexpressionSQ(phylum_cast<CexpressionSQ_elem>(kc_p1), phylum_cast<CexpressionSQ>(kc_p2));
    case sel_NilCexpressionSQ:
	return NilCexpressionSQ();
    case sel_CExpressionDQNl:
	return CExpressionDQNl(phylum_cast<integer>(kc_p1));
    case sel_CExpressionDQPart:
	return CExpressionDQPart(phylum_cast<casestring>(kc_p1));
    case sel_ConsCexpressionDQ:
	return ConsCexpressionDQ(phylum_cast<CexpressionDQ_elem>(kc_p1), phylum_cast<CexpressionDQ>(kc_p2));
    case sel_NilCexpressionDQ:
	return NilCexpressionDQ();
    case sel_CExpressionArray:
	return CExpressionArray(phylum_cast<Cexpression>(kc_p1));
    case sel_CExpressionPack:
	return CExpressionPack(phylum_cast<Cexpression>(kc_p1));
    case sel_CExpressionSQ:
	return CExpressionSQ(phylum_cast<CexpressionSQ>(kc_p1));
    case sel_CExpressionDQ:
	return CExpressionDQ(phylum_cast<CexpressionDQ>(kc_p1));
    case sel_CExpressionNl:
	return CExpressionNl(phylum_cast<integer>(kc_p1));
    case sel_CExpressionDollarvar:
	return CExpressionDollarvar(phylum_cast<INT>(kc_p1));
    case sel_CExpressionPart:
	return CExpressionPart(phylum_cast<casestring>(kc_p1));
    case sel_ConsCexpression:
	return ConsCexpression(phylum_cast<Cexpression_elem>(kc_p1), phylum_cast<Cexpression>(kc_p2));
    case sel_NilCexpression:
	return NilCexpression();
    case sel_Yesattribute_initialisation:
	return Yesattribute_initialisation(phylum_cast<Cexpression>(kc_p1));
    case sel_Noattribute_initialisation:
	return Noattribute_initialisation();
    case sel_Attribute:
	return Attribute(phylum_cast<ID>(kc_p1), phylum_cast<ID>(kc_p2), phylum_cast<attribute_initialisation_option>(kc_p3));
    case sel_Consattributes:
	return Consattributes(phylum_cast<attribute>(kc_p1), phylum_cast<attributes>(kc_p2));
    case sel_Nilattributes:
	return Nilattributes();
    case sel_CcodeOption:
	return CcodeOption(phylum_cast<attributes>(kc_p1), phylum_cast<Ctexts>(kc_p2));
    case sel_Argument:
	return Argument(phylum_cast<ID>(kc_p1), phylum_cast<integer>(kc_p2));
    case sel_Consarguments:
	return Consarguments(phylum_cast<ID>(kc_p1), phylum_cast<arguments>(kc_p2));
    case sel_Nilarguments:
	return Nilarguments();
    case sel_Alternative:
	return Alternative(phylum_cast<ID>(kc_p1), phylum_cast<arguments>(kc_p2));
    case sel_Consalternatives:
	return Consalternatives(phylum_cast<alternative>(kc_p1), phylum_cast<alternatives>(kc_p2));
    case sel_Nilalternatives:
	return Nilalternatives();
    case sel_PredefinedAlternatives:
	return PredefinedAlternatives(phylum_cast<alternatives>(kc_p1));
    case sel_NonlistAlternatives:
	return NonlistAlternatives(phylum_cast<alternatives>(kc_p1));
    case sel_ListAlternatives:
	return ListAlternatives(phylum_cast<alternatives>(kc_p1), phylum_cast<ID>(kc_p2));
    case sel_Emptyproductionblock:
	return Emptyproductionblock();
    case sel_Consstorageclasses:
	return Consstorageclasses(phylum_cast<ID>(kc_p1), phylum_cast<storageclasses>(kc_p2));
    case sel_Nilstorageclasses:
	return Nilstorageclasses();
    case sel_PositiveStorageOption:
	return PositiveStorageOption(phylum_cast<ID>(kc_p1));
    case sel_NegativeStorageOption:
	return NegativeStorageOption(phylum_cast<ID>(kc_p1));
    case sel_NoStorageOption:
	return NoStorageOption();
    case sel_PhylumDeclaration:
	return PhylumDeclaration(phylum_cast<ID>(kc_p1), phylum_cast<storageoption>(kc_p2), phylum_cast<productionblock>(kc_p3), phylum_cast<Ccode_option>(kc_p4));
    case sel_Consphylumnames:
	return Consphylumnames(phylum_cast<ID>(kc_p1), phylum_cast<phylumnames>(kc_p2));
    case sel_Nilphylumnames:
	return Nilphylumnames();
    case sel_Consphylumdeclarations:
	return Consphylumdeclarations(phylum_cast<phylumdeclaration>(kc_p1), phylum_cast<phylumdeclarations>(kc_p2));
    case sel_Nilphylumdeclarations:
	return Nilphylumdeclarations();
    case sel_PhylumDeclarations:
	return PhylumDeclarations(phylum_cast<phylumdeclarations>(kc_p1));
    case sel_String:
	return String(phylum_cast<casestring>(kc_p1));
    case sel_Int:
	return Int(phylum_cast<integer>(kc_p1));
    case sel_Id:
	return Id(phylum_cast<uniqID>(kc_p1));
    case sel_Str:
	return Str(phylum_cast<casestring>(kc_p1));
    default:
	assertionFailed("Cannot create this kind of phylum - unkown operator id");
    }
    NORETURN
}

abstract_phylum&
attributeOf(abstract_phylum kc_p, int no)
{
    assertionFailed("Cannot select attribute for this kind of phylum - has no attributes");
    NORETURN
}

abstract_phylum
kc_tag_abstract_phylum::subphylum(int,bool) const
{
    return 0;
}

void
kc_tag_abstract_phylum::set_subphylum(int,abstract_phylum,bool)
{
}

void
kc_tag_abstract_phylum::free(bool kc_rec)
{
    kc_enum_operators kc_prodsel = prod_sel();
    KC_COLLECT_STATS0(KC_FREE_CALLED_STATS(kc_prodsel, kc_rec));
    if (!kc_PhylumInfo[phylum()].uniq_stored) {
	if (kc_rec) {
	    abstract_phylum son;
	    for (int kc_i=0; (son = subphylum(kc_i)); kc_i++)
	    {
		if (son!=0) son->free(kc_rec);
		son=0;
	    }
	}
	KC_COLLECT_STATS0(KC_FREED_STATS(kc_prodsel, kc_rec));
	delete this;
    }
}

bool kc_tag_abstract_phylum::eq(c_abstract_phylum kc_p2) const
{
    if (this == kc_p2)
	return true;
    if (prod_sel() != kc_p2->prod_sel())
	return false;

    int kc_st = kc_PhylumInfo[phylum()].uniq_stored;
    if (kc_st && kc_storageclass_still_uniq[kc_st])
	return false;

    c_abstract_phylum son1;
    for (int kc_i=0; (son1 = subphylum(kc_i)); kc_i++) {
	if (!son1->eq(kc_p2->subphylum(kc_i)))
	    return false;
    }

    return true;
}

static string kc_indentation = "";
static const char *kc_printformat_not_nullary_open = "%s%s(\n";
static const char *kc_printformat_list_open = "%s%s\n";

static const char *kc_printformat_not_nullary_close = "%s)\n";
static const char *kc_printformat_nullary = "%s%s()\n";

void kc_tag_abstract_phylum::fprint(FILE*kc_f)
{
    int kc_i;

    if (!kc_f) kc_f = stdout;
    if (this->is_list() && !dynamic_cast<abstract_list>(this)->is_nil()) {
	fprintf(kc_f, kc_printformat_list_open, kc_indentation.c_str(), op_name());
	kc_indentation+="| ";
	subphylum(0)->fprint(kc_f);
	kc_indentation=kc_indentation.substr(0, kc_indentation.length()-2);
	dynamic_cast<abstract_list>(subphylum(1))->fprint_list(kc_f);
	kc_indentation=kc_indentation.substr(0, kc_indentation.length()-2);
    } else // not list
	switch(phylum()) {
	case kc_phylum_voidptr:
	    fprintf(kc_f, "%s%p\n", kc_indentation.c_str(), static_cast<voidptr>(this)->pointer);
	    break;
	case kc_phylum_casestring:
	case kc_phylum_nocasestring:
	    fprintf(kc_f, "%s%s\n", kc_indentation.c_str(), static_cast<casestring>(this)->name);
	    break;
	case kc_phylum_integer:
	    fprintf(kc_f, "%s%i\n", kc_indentation.c_str(), static_cast<integer>(this)->value);
	    break;
	case kc_phylum_real:
	    fprintf(kc_f, "%s%f\n", kc_indentation.c_str(), static_cast<real>(this)->value);
	    break;
	default:
	    if (!subphylum(0)) {
		fprintf(kc_f, kc_printformat_nullary, kc_indentation.c_str(), op_name());
	    } else {
		fprintf(kc_f, kc_printformat_not_nullary_open, kc_indentation.c_str(), op_name());
		kc_indentation+="  ";
		abstract_phylum son;
		for (kc_i=0; (son = subphylum(kc_i)); kc_i++) {
		    son->fprint(kc_f);
		}
		kc_indentation=kc_indentation.substr(0, kc_indentation.length()-2);
		fprintf(kc_f, kc_printformat_not_nullary_close, kc_indentation.c_str());
	    }
    }
}

void kc_tag_abstract_phylum::print()
{
    fprint(stdout);
}

void kc_tag_abstract_list::fprint_list(FILE*kc_f)
{
    if (!kc_f)
	kc_f = stdout;
    if (this->is_nil()) {
	kc_indentation+="`-";
	fprintf(kc_f, kc_printformat_nullary, kc_indentation.c_str(), op_name());
    } else {
	kc_indentation+="|-";
	fprintf(kc_f, kc_printformat_list_open, kc_indentation.c_str(), op_name());
	kc_indentation=kc_indentation.substr(0, kc_indentation.length()-2);
	kc_indentation+="| ";
	subphylum(0)->fprint(kc_f);
	kc_indentation=kc_indentation.substr(0, kc_indentation.length()-2);
	dynamic_cast<abstract_list>(subphylum(1))->fprint_list(kc_f);
    }
}

const char *kc_error_concat = "concat_";
const char *kc_error_reverse = "reverse_";
const char *kc_error_length = "length_";
const char *kc_error_last = "last_";
const char *kc_error_last_with_nil_argument = "Internal Error: list::last was called with argument Nil%s\n";
const char *kc_error_map = "map_";
const char *kc_error_filter = "filter_";
const char *kc_error_freelist = "freelist_";

int kc_tag_abstract_list::length() const
{
    int kc_length = 0;
    c_abstract_phylum kc_p = this;
    while((kc_p = kc_p->subphylum(1)))
	kc_length++;
    return kc_length;
}
void kc_tag_abstract_list::freelist()
{
    abstract_phylum kc_p = this, kc_tmp_p;
    do{
	kc_tmp_p = kc_p->subphylum(1);
	kc_p->free(false);
	kc_p = kc_tmp_p;
    }while(kc_p);
}
abstract_phylum kc_tag_abstract_list::do_concat(c_abstract_phylum kc_p2, kc_enum_operators mk) const
{
    abstract_phylum next = subphylum(1);
    if(!next)
	return const_cast<abstract_phylum>(kc_p2);
    return kc_create(mk, subphylum(0), static_cast<abstract_list>(next)->do_concat(kc_p2, mk));
}

abstract_phylum kc_tag_abstract_list::do_reverse(c_abstract_phylum tail, kc_enum_operators mk) const
{
    for (kc_tag_abstract_list const* iterator_ = this; iterator_->subphylum(1) != 0;
	iterator_ = static_cast<kc_tag_abstract_list const*>(iterator_->subphylum(1)) )
    tail = kc_create(mk, iterator_->subphylum(0), const_cast<abstract_phylum>(tail));
    return const_cast<abstract_phylum>(tail);
}

abstract_phylum kc_tag_abstract_list::last() const
{
    c_abstract_phylum kc_p = this, kc_next = subphylum(1), kc_nextnext;
    if(!kc_next){
	fflush(stdout);
	fprintf(stderr, kc_error_last_with_nil_argument, phylum_name());
	exit(1);
    }
    while((kc_nextnext = kc_next->subphylum(1))) {
	kc_p = kc_next;
	kc_next = kc_nextnext;
    }
    return const_cast<abstract_phylum>(kc_p->subphylum(0));/* XXX remove cast */
}

abstract_phylum kc_tag_abstract_list::do_map(abstract_phylum (*kc_fp)(abstract_phylum), kc_enum_operators mk)
{
    abstract_phylum el = subphylum(0);
    if (!el)
	return this;
    abstract_list next = static_cast<abstract_list>(subphylum(1));
    return kc_create(mk, kc_fp(el), next->do_map(kc_fp, mk));
}

abstract_phylum kc_tag_abstract_list::do_filter(bool (*kc_fp)(abstract_phylum), kc_enum_operators mk)
{
    abstract_phylum el = subphylum(0);
    if (!el)
	return this;
    abstract_list next = static_cast<abstract_list>(subphylum(1));
    if ((*kc_fp)(el)) {
	return kc_create(mk, el, next->do_filter(kc_fp, mk));
    } else {
	return next->do_filter(kc_fp, mk);
    }
}

abstract_phylum kc_tag_abstract_list::do_merge(abstract_list second,abstract_phylum(*kc_fp)(abstract_phylum,abstract_phylum), kc_enum_operators mk)
{
    abstract_phylum el = subphylum(0);
    if (!el)
	return this;
    abstract_phylum el2 = second->subphylum(0);
    if (!el2)
	return el2;
    abstract_list next = static_cast<abstract_list>(subphylum(1));
    abstract_list next2 = static_cast<abstract_list>(second->subphylum(1));
    return kc_create(mk, kc_fp(el,el2), next->do_merge(next2, kc_fp, mk));
}

abstract_phylum kc_tag_abstract_list::do_reduce(abstract_phylum neutral, abstract_phylum(*kc_fp)(abstract_phylum,abstract_phylum)) {
    abstract_phylum el = subphylum(0);
    if (!el)
	return neutral;
    abstract_list next = static_cast<abstract_list>(subphylum(1));
    return kc_fp(el,next->do_reduce(neutral,kc_fp));
}


extern const char* kc_storageclassnames[];

#ifdef KC_STATISTICS
void kc_do_print_operator_statistics(FILE * kc_f)
{
    unsigned int kc_i;
    assertNonNull( kc_f,"kc_f" );
    fprintf(kc_f, "%-*s| %-*s| %-*s| %-*s| %-*s| %-*s| %-*s| %-*s| %-*s| %-*s\n", 38 , "Operator", 3, "Sz", 8, "#oper", 8, "#new", 8, "#exist", 8, "#frnrec", 8, "#frrec", 8, "#freed", 8, "#rem", 9, "total (bytes)");
    fprintf(kc_f, "%-*s|%*s |%*d |%*d |%*d |%*d |%*d |%*d |%*d |%*d\n", 38, "case sensitive strings", 3, "-", 8, kc_OperatorStatistics[sel__Str].created, 8, kc_OperatorStatistics[sel__Str].existing_not_found, 8, kc_OperatorStatistics[sel__Str].created-kc_OperatorStatistics[sel__Str].existing_not_found, 8, 0, 8, 0, 8, 0, 8, 0, 9, kc_casestring_strlen);
    fprintf(kc_f, "%-*s|%*s |%*d |%*d |%*d |%*d |%*d |%*d |%*d |%*d\n", 38, "case insensitive strings", 3, "-", 8, kc_OperatorStatistics[sel_NoCaseStr].created, 8, kc_OperatorStatistics[sel_NoCaseStr].existing_not_found, 8, kc_OperatorStatistics[sel_NoCaseStr].created-kc_OperatorStatistics[sel_NoCaseStr].existing_not_found, 8, 0, 8, 0, 8, 0, 8, 0, 9, kc_nocasestring_strlen);
    for (kc_i = kc_one_before_first_operator+1; kc_i < kc_last_operator; kc_i++) {
	fprintf(kc_f, "%-*s|%*d |%*d |%*d |%*d |%*d |%*d |%*d |%*d |%*d\n", 38, kc_OperatorInfo[kc_i].name, 3, kc_OperatorInfo[kc_i].size, 8, kc_OperatorStatistics[kc_i].created, 8, kc_OperatorStatistics[kc_i].existing_not_found, 8, kc_OperatorStatistics[kc_i].created-kc_OperatorStatistics[kc_i].existing_not_found, 8, kc_OperatorStatistics[kc_i].free_called[false], 8, kc_OperatorStatistics[kc_i].free_called[true], 8, kc_OperatorStatistics[kc_i].freed[false]+kc_OperatorStatistics[kc_i].freed[true], 8, kc_OperatorStatistics[kc_i].existing_not_found-(kc_OperatorStatistics[kc_i].freed[false]+kc_OperatorStatistics[kc_i].freed[true]), 9, kc_OperatorInfo[kc_i].size*(kc_OperatorStatistics[kc_i].existing_not_found-(kc_OperatorStatistics[kc_i].freed[false]+kc_OperatorStatistics[kc_i].freed[true])));
    }
}
#endif /* KC_STATISTICS */

const char*
kc_phylumname_or_error(kc_enum_phyla kc_phy)
{
    if ((kc_phy <= kc_one_before_first_phylum) || (kc_phy >= kc_last_phylum)) {
	char *kc_strof_error;
	sprintf((kc_strof_error=new char[69]), "Internal Error: unknown phylum number: %d", kc_phy);
	return kc_strof_error;
    } else {
	return kc_PhylumInfo[kc_phy].name;
    }   }


const char*
kc_operatorname_or_error(kc_enum_operators kc_operator)
{
    if ((kc_operator <= kc_one_before_first_operator) || (kc_operator >= kc_last_operator)) {
	char *kc_strof_error;
	sprintf((kc_strof_error=new char[71]), "Internal Error: unknown operator number: %d", kc_operator);
	return kc_strof_error;
    } else {
	return kc_OperatorInfo[kc_operator].name;
    }   }

phylumdeclarations
concat(c_phylumdeclarations kc_p1, c_phylumdeclarations kc_p2)
{ return dynamic_cast<phylumdeclarations>(kc_p1->do_concat(kc_p2, sel_Consphylumdeclarations)); }

phylumdeclarations
kc_tag_phylumdeclarations::reverse() const
{ return dynamic_cast<phylumdeclarations>(do_reverse(Nilphylumdeclarations(), sel_Consphylumdeclarations)); }

phylumdeclaration
kc_tag_phylumdeclarations::last() const
{ return dynamic_cast<phylumdeclaration>(kc_tag_abstract_list::last()); }

bool
kc_tag_phylumdeclarations::is_nil() const
{
    return phylumdeclaration_1==0 && phylumdeclarations_1==0;
}

phylumdeclarations
kc_tag_phylumdeclarations::map(phylumdeclaration (*kc_fp)(phylumdeclaration))
{ return dynamic_cast<phylumdeclarations>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consphylumdeclarations)); }
phylumdeclarations
kc_tag_phylumdeclarations::filter(bool (*kc_fp)(phylumdeclaration))
{ return dynamic_cast<phylumdeclarations>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consphylumdeclarations)); }

phylumdeclarations
kc_tag_phylumdeclarations::append(phylumdeclaration last)
{
    if(is_nil()) { phylumdeclaration_1=last;phylumdeclarations_1=Nilphylumdeclarations(); return this; }
    return phylumdeclarations_1->append(last);
}
phylumdeclarations
kc_tag_phylumdeclarations::merge( phylumdeclarations second, phylumdeclaration (*kc_fp)(phylumdeclaration, phylumdeclaration))
{
    return dynamic_cast<phylumdeclarations>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consphylumdeclarations));
}
phylumdeclaration
kc_tag_phylumdeclarations::reduce( phylumdeclaration neutral, phylumdeclaration (*kc_fp)(phylumdeclaration, phylumdeclaration))
{
    return dynamic_cast<phylumdeclaration>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

phylumnames
concat(c_phylumnames kc_p1, c_phylumnames kc_p2)
{ return dynamic_cast<phylumnames>(kc_p1->do_concat(kc_p2, sel_Consphylumnames)); }

phylumnames
kc_tag_phylumnames::reverse() const
{ return dynamic_cast<phylumnames>(do_reverse(Nilphylumnames(), sel_Consphylumnames)); }

ID
kc_tag_phylumnames::last() const
{ return dynamic_cast<ID>(kc_tag_abstract_list::last()); }

bool
kc_tag_phylumnames::is_nil() const
{
    return ID_1==0 && phylumnames_1==0;
}

phylumnames
kc_tag_phylumnames::map(ID (*kc_fp)(ID))
{ return dynamic_cast<phylumnames>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consphylumnames)); }
phylumnames
kc_tag_phylumnames::filter(bool (*kc_fp)(ID))
{ return dynamic_cast<phylumnames>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consphylumnames)); }

phylumnames
kc_tag_phylumnames::append(ID last)
{
    if(is_nil()) { ID_1=last;phylumnames_1=Nilphylumnames(); return this; }
    return phylumnames_1->append(last);
}
phylumnames
kc_tag_phylumnames::merge( phylumnames second, ID (*kc_fp)(ID, ID))
{
    return dynamic_cast<phylumnames>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consphylumnames));
}
ID
kc_tag_phylumnames::reduce( ID neutral, ID (*kc_fp)(ID, ID))
{
    return dynamic_cast<ID>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

storageclasses
concat(c_storageclasses kc_p1, c_storageclasses kc_p2)
{ return dynamic_cast<storageclasses>(kc_p1->do_concat(kc_p2, sel_Consstorageclasses)); }

storageclasses
kc_tag_storageclasses::reverse() const
{ return dynamic_cast<storageclasses>(do_reverse(Nilstorageclasses(), sel_Consstorageclasses)); }

ID
kc_tag_storageclasses::last() const
{ return dynamic_cast<ID>(kc_tag_abstract_list::last()); }

bool
kc_tag_storageclasses::is_nil() const
{
    return ID_1==0 && storageclasses_1==0;
}

storageclasses
kc_tag_storageclasses::map(ID (*kc_fp)(ID))
{ return dynamic_cast<storageclasses>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consstorageclasses)); }
storageclasses
kc_tag_storageclasses::filter(bool (*kc_fp)(ID))
{ return dynamic_cast<storageclasses>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consstorageclasses)); }

storageclasses
kc_tag_storageclasses::append(ID last)
{
    if(is_nil()) { ID_1=last;storageclasses_1=Nilstorageclasses(); return this; }
    return storageclasses_1->append(last);
}
storageclasses
kc_tag_storageclasses::merge( storageclasses second, ID (*kc_fp)(ID, ID))
{
    return dynamic_cast<storageclasses>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consstorageclasses));
}
ID
kc_tag_storageclasses::reduce( ID neutral, ID (*kc_fp)(ID, ID))
{
    return dynamic_cast<ID>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

alternatives
concat(c_alternatives kc_p1, c_alternatives kc_p2)
{ return dynamic_cast<alternatives>(kc_p1->do_concat(kc_p2, sel_Consalternatives)); }

alternatives
kc_tag_alternatives::reverse() const
{ return dynamic_cast<alternatives>(do_reverse(Nilalternatives(), sel_Consalternatives)); }

alternative
kc_tag_alternatives::last() const
{ return dynamic_cast<alternative>(kc_tag_abstract_list::last()); }

bool
kc_tag_alternatives::is_nil() const
{
    return alternative_1==0 && alternatives_1==0;
}

alternatives
kc_tag_alternatives::map(alternative (*kc_fp)(alternative))
{ return dynamic_cast<alternatives>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consalternatives)); }
alternatives
kc_tag_alternatives::filter(bool (*kc_fp)(alternative))
{ return dynamic_cast<alternatives>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consalternatives)); }

alternatives
kc_tag_alternatives::append(alternative last)
{
    if(is_nil()) { alternative_1=last;alternatives_1=Nilalternatives(); return this; }
    return alternatives_1->append(last);
}
alternatives
kc_tag_alternatives::merge( alternatives second, alternative (*kc_fp)(alternative, alternative))
{
    return dynamic_cast<alternatives>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consalternatives));
}
alternative
kc_tag_alternatives::reduce( alternative neutral, alternative (*kc_fp)(alternative, alternative))
{
    return dynamic_cast<alternative>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

arguments
concat(c_arguments kc_p1, c_arguments kc_p2)
{ return dynamic_cast<arguments>(kc_p1->do_concat(kc_p2, sel_Consarguments)); }

arguments
kc_tag_arguments::reverse() const
{ return dynamic_cast<arguments>(do_reverse(Nilarguments(), sel_Consarguments)); }

ID
kc_tag_arguments::last() const
{ return dynamic_cast<ID>(kc_tag_abstract_list::last()); }

bool
kc_tag_arguments::is_nil() const
{
    return ID_1==0 && arguments_1==0;
}

arguments
kc_tag_arguments::map(ID (*kc_fp)(ID))
{ return dynamic_cast<arguments>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consarguments)); }
arguments
kc_tag_arguments::filter(bool (*kc_fp)(ID))
{ return dynamic_cast<arguments>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consarguments)); }

arguments
kc_tag_arguments::append(ID last)
{
    if(is_nil()) { ID_1=last;arguments_1=Nilarguments(); return this; }
    return arguments_1->append(last);
}
arguments
kc_tag_arguments::merge( arguments second, ID (*kc_fp)(ID, ID))
{
    return dynamic_cast<arguments>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consarguments));
}
ID
kc_tag_arguments::reduce( ID neutral, ID (*kc_fp)(ID, ID))
{
    return dynamic_cast<ID>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

attributes
concat(c_attributes kc_p1, c_attributes kc_p2)
{ return dynamic_cast<attributes>(kc_p1->do_concat(kc_p2, sel_Consattributes)); }

attributes
kc_tag_attributes::reverse() const
{ return dynamic_cast<attributes>(do_reverse(Nilattributes(), sel_Consattributes)); }

attribute
kc_tag_attributes::last() const
{ return dynamic_cast<attribute>(kc_tag_abstract_list::last()); }

bool
kc_tag_attributes::is_nil() const
{
    return attribute_1==0 && attributes_1==0;
}

attributes
kc_tag_attributes::map(attribute (*kc_fp)(attribute))
{ return dynamic_cast<attributes>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consattributes)); }
attributes
kc_tag_attributes::filter(bool (*kc_fp)(attribute))
{ return dynamic_cast<attributes>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consattributes)); }

attributes
kc_tag_attributes::append(attribute last)
{
    if(is_nil()) { attribute_1=last;attributes_1=Nilattributes(); return this; }
    return attributes_1->append(last);
}
attributes
kc_tag_attributes::merge( attributes second, attribute (*kc_fp)(attribute, attribute))
{
    return dynamic_cast<attributes>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consattributes));
}
attribute
kc_tag_attributes::reduce( attribute neutral, attribute (*kc_fp)(attribute, attribute))
{
    return dynamic_cast<attribute>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

Cexpression
concat(c_Cexpression kc_p1, c_Cexpression kc_p2)
{ return dynamic_cast<Cexpression>(kc_p1->do_concat(kc_p2, sel_ConsCexpression)); }

Cexpression
kc_tag_Cexpression::reverse() const
{ return dynamic_cast<Cexpression>(do_reverse(NilCexpression(), sel_ConsCexpression)); }

Cexpression_elem
kc_tag_Cexpression::last() const
{ return dynamic_cast<Cexpression_elem>(kc_tag_abstract_list::last()); }

bool
kc_tag_Cexpression::is_nil() const
{
    return Cexpression_elem_1==0 && Cexpression_1==0;
}

Cexpression
kc_tag_Cexpression::map(Cexpression_elem (*kc_fp)(Cexpression_elem))
{ return dynamic_cast<Cexpression>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConsCexpression)); }
Cexpression
kc_tag_Cexpression::filter(bool (*kc_fp)(Cexpression_elem))
{ return dynamic_cast<Cexpression>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConsCexpression)); }

Cexpression
kc_tag_Cexpression::append(Cexpression_elem last)
{
    if(is_nil()) { Cexpression_elem_1=last;Cexpression_1=NilCexpression(); return this; }
    return Cexpression_1->append(last);
}
Cexpression
kc_tag_Cexpression::merge( Cexpression second, Cexpression_elem (*kc_fp)(Cexpression_elem, Cexpression_elem))
{
    return dynamic_cast<Cexpression>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConsCexpression));
}
Cexpression_elem
kc_tag_Cexpression::reduce( Cexpression_elem neutral, Cexpression_elem (*kc_fp)(Cexpression_elem, Cexpression_elem))
{
    return dynamic_cast<Cexpression_elem>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

CexpressionDQ
concat(c_CexpressionDQ kc_p1, c_CexpressionDQ kc_p2)
{ return dynamic_cast<CexpressionDQ>(kc_p1->do_concat(kc_p2, sel_ConsCexpressionDQ)); }

CexpressionDQ
kc_tag_CexpressionDQ::reverse() const
{ return dynamic_cast<CexpressionDQ>(do_reverse(NilCexpressionDQ(), sel_ConsCexpressionDQ)); }

CexpressionDQ_elem
kc_tag_CexpressionDQ::last() const
{ return dynamic_cast<CexpressionDQ_elem>(kc_tag_abstract_list::last()); }

bool
kc_tag_CexpressionDQ::is_nil() const
{
    return CexpressionDQ_elem_1==0 && CexpressionDQ_1==0;
}

CexpressionDQ
kc_tag_CexpressionDQ::map(CexpressionDQ_elem (*kc_fp)(CexpressionDQ_elem))
{ return dynamic_cast<CexpressionDQ>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConsCexpressionDQ)); }
CexpressionDQ
kc_tag_CexpressionDQ::filter(bool (*kc_fp)(CexpressionDQ_elem))
{ return dynamic_cast<CexpressionDQ>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConsCexpressionDQ)); }

CexpressionDQ
kc_tag_CexpressionDQ::append(CexpressionDQ_elem last)
{
    if(is_nil()) { CexpressionDQ_elem_1=last;CexpressionDQ_1=NilCexpressionDQ(); return this; }
    return CexpressionDQ_1->append(last);
}
CexpressionDQ
kc_tag_CexpressionDQ::merge( CexpressionDQ second, CexpressionDQ_elem (*kc_fp)(CexpressionDQ_elem, CexpressionDQ_elem))
{
    return dynamic_cast<CexpressionDQ>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConsCexpressionDQ));
}
CexpressionDQ_elem
kc_tag_CexpressionDQ::reduce( CexpressionDQ_elem neutral, CexpressionDQ_elem (*kc_fp)(CexpressionDQ_elem, CexpressionDQ_elem))
{
    return dynamic_cast<CexpressionDQ_elem>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

CexpressionSQ
concat(c_CexpressionSQ kc_p1, c_CexpressionSQ kc_p2)
{ return dynamic_cast<CexpressionSQ>(kc_p1->do_concat(kc_p2, sel_ConsCexpressionSQ)); }

CexpressionSQ
kc_tag_CexpressionSQ::reverse() const
{ return dynamic_cast<CexpressionSQ>(do_reverse(NilCexpressionSQ(), sel_ConsCexpressionSQ)); }

CexpressionSQ_elem
kc_tag_CexpressionSQ::last() const
{ return dynamic_cast<CexpressionSQ_elem>(kc_tag_abstract_list::last()); }

bool
kc_tag_CexpressionSQ::is_nil() const
{
    return CexpressionSQ_elem_1==0 && CexpressionSQ_1==0;
}

CexpressionSQ
kc_tag_CexpressionSQ::map(CexpressionSQ_elem (*kc_fp)(CexpressionSQ_elem))
{ return dynamic_cast<CexpressionSQ>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConsCexpressionSQ)); }
CexpressionSQ
kc_tag_CexpressionSQ::filter(bool (*kc_fp)(CexpressionSQ_elem))
{ return dynamic_cast<CexpressionSQ>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConsCexpressionSQ)); }

CexpressionSQ
kc_tag_CexpressionSQ::append(CexpressionSQ_elem last)
{
    if(is_nil()) { CexpressionSQ_elem_1=last;CexpressionSQ_1=NilCexpressionSQ(); return this; }
    return CexpressionSQ_1->append(last);
}
CexpressionSQ
kc_tag_CexpressionSQ::merge( CexpressionSQ second, CexpressionSQ_elem (*kc_fp)(CexpressionSQ_elem, CexpressionSQ_elem))
{
    return dynamic_cast<CexpressionSQ>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConsCexpressionSQ));
}
CexpressionSQ_elem
kc_tag_CexpressionSQ::reduce( CexpressionSQ_elem neutral, CexpressionSQ_elem (*kc_fp)(CexpressionSQ_elem, CexpressionSQ_elem))
{
    return dynamic_cast<CexpressionSQ_elem>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

idCexpressions
concat(c_idCexpressions kc_p1, c_idCexpressions kc_p2)
{ return dynamic_cast<idCexpressions>(kc_p1->do_concat(kc_p2, sel_ConsidCexpressions)); }

idCexpressions
kc_tag_idCexpressions::reverse() const
{ return dynamic_cast<idCexpressions>(do_reverse(NilidCexpressions(), sel_ConsidCexpressions)); }

idCexpression
kc_tag_idCexpressions::last() const
{ return dynamic_cast<idCexpression>(kc_tag_abstract_list::last()); }

bool
kc_tag_idCexpressions::is_nil() const
{
    return idCexpression_1==0 && idCexpressions_1==0;
}

idCexpressions
kc_tag_idCexpressions::map(idCexpression (*kc_fp)(idCexpression))
{ return dynamic_cast<idCexpressions>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConsidCexpressions)); }
idCexpressions
kc_tag_idCexpressions::filter(bool (*kc_fp)(idCexpression))
{ return dynamic_cast<idCexpressions>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConsidCexpressions)); }

idCexpressions
kc_tag_idCexpressions::append(idCexpression last)
{
    if(is_nil()) { idCexpression_1=last;idCexpressions_1=NilidCexpressions(); return this; }
    return idCexpressions_1->append(last);
}
idCexpressions
kc_tag_idCexpressions::merge( idCexpressions second, idCexpression (*kc_fp)(idCexpression, idCexpression))
{
    return dynamic_cast<idCexpressions>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConsidCexpressions));
}
idCexpression
kc_tag_idCexpressions::reduce( idCexpression neutral, idCexpression (*kc_fp)(idCexpression, idCexpression))
{
    return dynamic_cast<idCexpression>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

Ctexts
concat(c_Ctexts kc_p1, c_Ctexts kc_p2)
{ return dynamic_cast<Ctexts>(kc_p1->do_concat(kc_p2, sel_ConsCtexts)); }

Ctexts
kc_tag_Ctexts::reverse() const
{ return dynamic_cast<Ctexts>(do_reverse(NilCtexts(), sel_ConsCtexts)); }

Ctext
kc_tag_Ctexts::last() const
{ return dynamic_cast<Ctext>(kc_tag_abstract_list::last()); }

bool
kc_tag_Ctexts::is_nil() const
{
    return Ctext_1==0 && Ctexts_1==0;
}

Ctexts
kc_tag_Ctexts::map(Ctext (*kc_fp)(Ctext))
{ return dynamic_cast<Ctexts>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConsCtexts)); }
Ctexts
kc_tag_Ctexts::filter(bool (*kc_fp)(Ctext))
{ return dynamic_cast<Ctexts>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConsCtexts)); }

Ctexts
kc_tag_Ctexts::append(Ctext last)
{
    if(is_nil()) { Ctext_1=last;Ctexts_1=NilCtexts(); return this; }
    return Ctexts_1->append(last);
}
Ctexts
kc_tag_Ctexts::merge( Ctexts second, Ctext (*kc_fp)(Ctext, Ctext))
{
    return dynamic_cast<Ctexts>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConsCtexts));
}
Ctext
kc_tag_Ctexts::reduce( Ctext neutral, Ctext (*kc_fp)(Ctext, Ctext))
{
    return dynamic_cast<Ctext>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

includefiles
concat(c_includefiles kc_p1, c_includefiles kc_p2)
{ return dynamic_cast<includefiles>(kc_p1->do_concat(kc_p2, sel_Consincludefiles)); }

includefiles
kc_tag_includefiles::reverse() const
{ return dynamic_cast<includefiles>(do_reverse(Nilincludefiles(), sel_Consincludefiles)); }

includefile
kc_tag_includefiles::last() const
{ return dynamic_cast<includefile>(kc_tag_abstract_list::last()); }

bool
kc_tag_includefiles::is_nil() const
{
    return includefile_1==0 && includefiles_1==0;
}

includefiles
kc_tag_includefiles::map(includefile (*kc_fp)(includefile))
{ return dynamic_cast<includefiles>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consincludefiles)); }
includefiles
kc_tag_includefiles::filter(bool (*kc_fp)(includefile))
{ return dynamic_cast<includefiles>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consincludefiles)); }

includefiles
kc_tag_includefiles::append(includefile last)
{
    if(is_nil()) { includefile_1=last;includefiles_1=Nilincludefiles(); return this; }
    return includefiles_1->append(last);
}
includefiles
kc_tag_includefiles::merge( includefiles second, includefile (*kc_fp)(includefile, includefile))
{
    return dynamic_cast<includefiles>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consincludefiles));
}
includefile
kc_tag_includefiles::reduce( includefile neutral, includefile (*kc_fp)(includefile, includefile))
{
    return dynamic_cast<includefile>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

includedeclarations
concat(c_includedeclarations kc_p1, c_includedeclarations kc_p2)
{ return dynamic_cast<includedeclarations>(kc_p1->do_concat(kc_p2, sel_Consincludedeclarations)); }

includedeclarations
kc_tag_includedeclarations::reverse() const
{ return dynamic_cast<includedeclarations>(do_reverse(Nilincludedeclarations(), sel_Consincludedeclarations)); }

includedeclaration
kc_tag_includedeclarations::last() const
{ return dynamic_cast<includedeclaration>(kc_tag_abstract_list::last()); }

bool
kc_tag_includedeclarations::is_nil() const
{
    return includedeclaration_1==0 && includedeclarations_1==0;
}

includedeclarations
kc_tag_includedeclarations::map(includedeclaration (*kc_fp)(includedeclaration))
{ return dynamic_cast<includedeclarations>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consincludedeclarations)); }
includedeclarations
kc_tag_includedeclarations::filter(bool (*kc_fp)(includedeclaration))
{ return dynamic_cast<includedeclarations>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consincludedeclarations)); }

includedeclarations
kc_tag_includedeclarations::append(includedeclaration last)
{
    if(is_nil()) { includedeclaration_1=last;includedeclarations_1=Nilincludedeclarations(); return this; }
    return includedeclarations_1->append(last);
}
includedeclarations
kc_tag_includedeclarations::merge( includedeclarations second, includedeclaration (*kc_fp)(includedeclaration, includedeclaration))
{
    return dynamic_cast<includedeclarations>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consincludedeclarations));
}
includedeclaration
kc_tag_includedeclarations::reduce( includedeclaration neutral, includedeclaration (*kc_fp)(includedeclaration, includedeclaration))
{
    return dynamic_cast<includedeclaration>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

rwdeclarations
concat(c_rwdeclarations kc_p1, c_rwdeclarations kc_p2)
{ return dynamic_cast<rwdeclarations>(kc_p1->do_concat(kc_p2, sel_Consrwdeclarations)); }

rwdeclarations
kc_tag_rwdeclarations::reverse() const
{ return dynamic_cast<rwdeclarations>(do_reverse(Nilrwdeclarations(), sel_Consrwdeclarations)); }

rwdeclaration
kc_tag_rwdeclarations::last() const
{ return dynamic_cast<rwdeclaration>(kc_tag_abstract_list::last()); }

bool
kc_tag_rwdeclarations::is_nil() const
{
    return rwdeclaration_1==0 && rwdeclarations_1==0;
}

rwdeclarations
kc_tag_rwdeclarations::map(rwdeclaration (*kc_fp)(rwdeclaration))
{ return dynamic_cast<rwdeclarations>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consrwdeclarations)); }
rwdeclarations
kc_tag_rwdeclarations::filter(bool (*kc_fp)(rwdeclaration))
{ return dynamic_cast<rwdeclarations>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consrwdeclarations)); }

rwdeclarations
kc_tag_rwdeclarations::append(rwdeclaration last)
{
    if(is_nil()) { rwdeclaration_1=last;rwdeclarations_1=Nilrwdeclarations(); return this; }
    return rwdeclarations_1->append(last);
}
rwdeclarations
kc_tag_rwdeclarations::merge( rwdeclarations second, rwdeclaration (*kc_fp)(rwdeclaration, rwdeclaration))
{
    return dynamic_cast<rwdeclarations>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consrwdeclarations));
}
rwdeclaration
kc_tag_rwdeclarations::reduce( rwdeclaration neutral, rwdeclaration (*kc_fp)(rwdeclaration, rwdeclaration))
{
    return dynamic_cast<rwdeclaration>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

rewriteclauses
concat(c_rewriteclauses kc_p1, c_rewriteclauses kc_p2)
{ return dynamic_cast<rewriteclauses>(kc_p1->do_concat(kc_p2, sel_Consrewriteclauses)); }

rewriteclauses
kc_tag_rewriteclauses::reverse() const
{ return dynamic_cast<rewriteclauses>(do_reverse(Nilrewriteclauses(), sel_Consrewriteclauses)); }

rewriteclause
kc_tag_rewriteclauses::last() const
{ return dynamic_cast<rewriteclause>(kc_tag_abstract_list::last()); }

bool
kc_tag_rewriteclauses::is_nil() const
{
    return rewriteclause_1==0 && rewriteclauses_1==0;
}

rewriteclauses
kc_tag_rewriteclauses::map(rewriteclause (*kc_fp)(rewriteclause))
{ return dynamic_cast<rewriteclauses>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consrewriteclauses)); }
rewriteclauses
kc_tag_rewriteclauses::filter(bool (*kc_fp)(rewriteclause))
{ return dynamic_cast<rewriteclauses>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consrewriteclauses)); }

rewriteclauses
kc_tag_rewriteclauses::append(rewriteclause last)
{
    if(is_nil()) { rewriteclause_1=last;rewriteclauses_1=Nilrewriteclauses(); return this; }
    return rewriteclauses_1->append(last);
}
rewriteclauses
kc_tag_rewriteclauses::merge( rewriteclauses second, rewriteclause (*kc_fp)(rewriteclause, rewriteclause))
{
    return dynamic_cast<rewriteclauses>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consrewriteclauses));
}
rewriteclause
kc_tag_rewriteclauses::reduce( rewriteclause neutral, rewriteclause (*kc_fp)(rewriteclause, rewriteclause))
{
    return dynamic_cast<rewriteclause>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

patternchains
concat(c_patternchains kc_p1, c_patternchains kc_p2)
{ return dynamic_cast<patternchains>(kc_p1->do_concat(kc_p2, sel_Conspatternchains)); }

patternchains
kc_tag_patternchains::reverse() const
{ return dynamic_cast<patternchains>(do_reverse(Nilpatternchains(), sel_Conspatternchains)); }

patternchain
kc_tag_patternchains::last() const
{ return dynamic_cast<patternchain>(kc_tag_abstract_list::last()); }

bool
kc_tag_patternchains::is_nil() const
{
    return patternchain_1==0 && patternchains_1==0;
}

patternchains
kc_tag_patternchains::map(patternchain (*kc_fp)(patternchain))
{ return dynamic_cast<patternchains>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Conspatternchains)); }
patternchains
kc_tag_patternchains::filter(bool (*kc_fp)(patternchain))
{ return dynamic_cast<patternchains>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Conspatternchains)); }

patternchains
kc_tag_patternchains::append(patternchain last)
{
    if(is_nil()) { patternchain_1=last;patternchains_1=Nilpatternchains(); return this; }
    return patternchains_1->append(last);
}
patternchains
kc_tag_patternchains::merge( patternchains second, patternchain (*kc_fp)(patternchain, patternchain))
{
    return dynamic_cast<patternchains>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Conspatternchains));
}
patternchain
kc_tag_patternchains::reduce( patternchain neutral, patternchain (*kc_fp)(patternchain, patternchain))
{
    return dynamic_cast<patternchain>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

patternchain
concat(c_patternchain kc_p1, c_patternchain kc_p2)
{ return dynamic_cast<patternchain>(kc_p1->do_concat(kc_p2, sel_Conspatternchain)); }

patternchain
kc_tag_patternchain::reverse() const
{ return dynamic_cast<patternchain>(do_reverse(Nilpatternchain(), sel_Conspatternchain)); }

patternchainitem
kc_tag_patternchain::last() const
{ return dynamic_cast<patternchainitem>(kc_tag_abstract_list::last()); }

bool
kc_tag_patternchain::is_nil() const
{
    return patternchainitem_1==0 && patternchain_1==0;
}

patternchain
kc_tag_patternchain::map(patternchainitem (*kc_fp)(patternchainitem))
{ return dynamic_cast<patternchain>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Conspatternchain)); }
patternchain
kc_tag_patternchain::filter(bool (*kc_fp)(patternchainitem))
{ return dynamic_cast<patternchain>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Conspatternchain)); }

patternchain
kc_tag_patternchain::append(patternchainitem last)
{
    if(is_nil()) { patternchainitem_1=last;patternchain_1=Nilpatternchain(); return this; }
    return patternchain_1->append(last);
}
patternchain
kc_tag_patternchain::merge( patternchain second, patternchainitem (*kc_fp)(patternchainitem, patternchainitem))
{
    return dynamic_cast<patternchain>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Conspatternchain));
}
patternchainitem
kc_tag_patternchain::reduce( patternchainitem neutral, patternchainitem (*kc_fp)(patternchainitem, patternchainitem))
{
    return dynamic_cast<patternchainitem>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

outmostpatterns
concat(c_outmostpatterns kc_p1, c_outmostpatterns kc_p2)
{ return dynamic_cast<outmostpatterns>(kc_p1->do_concat(kc_p2, sel_Consoutmostpatterns)); }

outmostpatterns
kc_tag_outmostpatterns::reverse() const
{ return dynamic_cast<outmostpatterns>(do_reverse(Niloutmostpatterns(), sel_Consoutmostpatterns)); }

outmostpattern
kc_tag_outmostpatterns::last() const
{ return dynamic_cast<outmostpattern>(kc_tag_abstract_list::last()); }

bool
kc_tag_outmostpatterns::is_nil() const
{
    return outmostpattern_1==0 && outmostpatterns_1==0;
}

outmostpatterns
kc_tag_outmostpatterns::map(outmostpattern (*kc_fp)(outmostpattern))
{ return dynamic_cast<outmostpatterns>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consoutmostpatterns)); }
outmostpatterns
kc_tag_outmostpatterns::filter(bool (*kc_fp)(outmostpattern))
{ return dynamic_cast<outmostpatterns>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consoutmostpatterns)); }

outmostpatterns
kc_tag_outmostpatterns::append(outmostpattern last)
{
    if(is_nil()) { outmostpattern_1=last;outmostpatterns_1=Niloutmostpatterns(); return this; }
    return outmostpatterns_1->append(last);
}
outmostpatterns
kc_tag_outmostpatterns::merge( outmostpatterns second, outmostpattern (*kc_fp)(outmostpattern, outmostpattern))
{
    return dynamic_cast<outmostpatterns>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consoutmostpatterns));
}
outmostpattern
kc_tag_outmostpatterns::reduce( outmostpattern neutral, outmostpattern (*kc_fp)(outmostpattern, outmostpattern))
{
    return dynamic_cast<outmostpattern>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

patterns
concat(c_patterns kc_p1, c_patterns kc_p2)
{ return dynamic_cast<patterns>(kc_p1->do_concat(kc_p2, sel_Conspatterns)); }

patterns
kc_tag_patterns::reverse() const
{ return dynamic_cast<patterns>(do_reverse(Nilpatterns(), sel_Conspatterns)); }

pattern
kc_tag_patterns::last() const
{ return dynamic_cast<pattern>(kc_tag_abstract_list::last()); }

bool
kc_tag_patterns::is_nil() const
{
    return pattern_1==0 && patterns_1==0;
}

patterns
kc_tag_patterns::map(pattern (*kc_fp)(pattern))
{ return dynamic_cast<patterns>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Conspatterns)); }
patterns
kc_tag_patterns::filter(bool (*kc_fp)(pattern))
{ return dynamic_cast<patterns>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Conspatterns)); }

patterns
kc_tag_patterns::append(pattern last)
{
    if(is_nil()) { pattern_1=last;patterns_1=Nilpatterns(); return this; }
    return patterns_1->append(last);
}
patterns
kc_tag_patterns::merge( patterns second, pattern (*kc_fp)(pattern, pattern))
{
    return dynamic_cast<patterns>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Conspatterns));
}
pattern
kc_tag_patterns::reduce( pattern neutral, pattern (*kc_fp)(pattern, pattern))
{
    return dynamic_cast<pattern>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

terms
concat(c_terms kc_p1, c_terms kc_p2)
{ return dynamic_cast<terms>(kc_p1->do_concat(kc_p2, sel_Consterms)); }

terms
kc_tag_terms::reverse() const
{ return dynamic_cast<terms>(do_reverse(Nilterms(), sel_Consterms)); }

term
kc_tag_terms::last() const
{ return dynamic_cast<term>(kc_tag_abstract_list::last()); }

bool
kc_tag_terms::is_nil() const
{
    return term_1==0 && terms_1==0;
}

terms
kc_tag_terms::map(term (*kc_fp)(term))
{ return dynamic_cast<terms>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consterms)); }
terms
kc_tag_terms::filter(bool (*kc_fp)(term))
{ return dynamic_cast<terms>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consterms)); }

terms
kc_tag_terms::append(term last)
{
    if(is_nil()) { term_1=last;terms_1=Nilterms(); return this; }
    return terms_1->append(last);
}
terms
kc_tag_terms::merge( terms second, term (*kc_fp)(term, term))
{
    return dynamic_cast<terms>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consterms));
}
term
kc_tag_terms::reduce( term neutral, term (*kc_fp)(term, term))
{
    return dynamic_cast<term>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

fnfiles
concat(c_fnfiles kc_p1, c_fnfiles kc_p2)
{ return dynamic_cast<fnfiles>(kc_p1->do_concat(kc_p2, sel_Consfnfiles)); }

fnfiles
kc_tag_fnfiles::reverse() const
{ return dynamic_cast<fnfiles>(do_reverse(Nilfnfiles(), sel_Consfnfiles)); }

fnfile
kc_tag_fnfiles::last() const
{ return dynamic_cast<fnfile>(kc_tag_abstract_list::last()); }

bool
kc_tag_fnfiles::is_nil() const
{
    return fnfile_1==0 && fnfiles_1==0;
}

fnfiles
kc_tag_fnfiles::map(fnfile (*kc_fp)(fnfile))
{ return dynamic_cast<fnfiles>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consfnfiles)); }
fnfiles
kc_tag_fnfiles::filter(bool (*kc_fp)(fnfile))
{ return dynamic_cast<fnfiles>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consfnfiles)); }

fnfiles
kc_tag_fnfiles::append(fnfile last)
{
    if(is_nil()) { fnfile_1=last;fnfiles_1=Nilfnfiles(); return this; }
    return fnfiles_1->append(last);
}
fnfiles
kc_tag_fnfiles::merge( fnfiles second, fnfile (*kc_fp)(fnfile, fnfile))
{
    return dynamic_cast<fnfiles>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consfnfiles));
}
fnfile
kc_tag_fnfiles::reduce( fnfile neutral, fnfile (*kc_fp)(fnfile, fnfile))
{
    return dynamic_cast<fnfile>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

fndeclarations
concat(c_fndeclarations kc_p1, c_fndeclarations kc_p2)
{ return dynamic_cast<fndeclarations>(kc_p1->do_concat(kc_p2, sel_Consfndeclarations)); }

fndeclarations
kc_tag_fndeclarations::reverse() const
{ return dynamic_cast<fndeclarations>(do_reverse(Nilfndeclarations(), sel_Consfndeclarations)); }

fndeclaration
kc_tag_fndeclarations::last() const
{ return dynamic_cast<fndeclaration>(kc_tag_abstract_list::last()); }

bool
kc_tag_fndeclarations::is_nil() const
{
    return fndeclaration_1==0 && fndeclarations_1==0;
}

fndeclarations
kc_tag_fndeclarations::map(fndeclaration (*kc_fp)(fndeclaration))
{ return dynamic_cast<fndeclarations>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consfndeclarations)); }
fndeclarations
kc_tag_fndeclarations::filter(bool (*kc_fp)(fndeclaration))
{ return dynamic_cast<fndeclarations>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consfndeclarations)); }

fndeclarations
kc_tag_fndeclarations::append(fndeclaration last)
{
    if(is_nil()) { fndeclaration_1=last;fndeclarations_1=Nilfndeclarations(); return this; }
    return fndeclarations_1->append(last);
}
fndeclarations
kc_tag_fndeclarations::merge( fndeclarations second, fndeclaration (*kc_fp)(fndeclaration, fndeclaration))
{
    return dynamic_cast<fndeclarations>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consfndeclarations));
}
fndeclaration
kc_tag_fndeclarations::reduce( fndeclaration neutral, fndeclaration (*kc_fp)(fndeclaration, fndeclaration))
{
    return dynamic_cast<fndeclaration>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

Ctext
concat(c_Ctext kc_p1, c_Ctext kc_p2)
{ return dynamic_cast<Ctext>(kc_p1->do_concat(kc_p2, sel_ConsCtext)); }

Ctext
kc_tag_Ctext::reverse() const
{ return dynamic_cast<Ctext>(do_reverse(NilCtext(), sel_ConsCtext)); }

Ctext_elem
kc_tag_Ctext::last() const
{ return dynamic_cast<Ctext_elem>(kc_tag_abstract_list::last()); }

bool
kc_tag_Ctext::is_nil() const
{
    return Ctext_elem_1==0 && Ctext_1==0;
}

Ctext
kc_tag_Ctext::map(Ctext_elem (*kc_fp)(Ctext_elem))
{ return dynamic_cast<Ctext>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConsCtext)); }
Ctext
kc_tag_Ctext::filter(bool (*kc_fp)(Ctext_elem))
{ return dynamic_cast<Ctext>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConsCtext)); }

Ctext
kc_tag_Ctext::append(Ctext_elem last)
{
    if(is_nil()) { Ctext_elem_1=last;Ctext_1=NilCtext(); return this; }
    return Ctext_1->append(last);
}
Ctext
kc_tag_Ctext::merge( Ctext second, Ctext_elem (*kc_fp)(Ctext_elem, Ctext_elem))
{
    return dynamic_cast<Ctext>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConsCtext));
}
Ctext_elem
kc_tag_Ctext::reduce( Ctext_elem neutral, Ctext_elem (*kc_fp)(Ctext_elem, Ctext_elem))
{
    return dynamic_cast<Ctext_elem>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

withexpressions
concat(c_withexpressions kc_p1, c_withexpressions kc_p2)
{ return dynamic_cast<withexpressions>(kc_p1->do_concat(kc_p2, sel_Conswithexpressions)); }

withexpressions
kc_tag_withexpressions::reverse() const
{ return dynamic_cast<withexpressions>(do_reverse(Nilwithexpressions(), sel_Conswithexpressions)); }

withexpression
kc_tag_withexpressions::last() const
{ return dynamic_cast<withexpression>(kc_tag_abstract_list::last()); }

bool
kc_tag_withexpressions::is_nil() const
{
    return withexpression_1==0 && withexpressions_1==0;
}

withexpressions
kc_tag_withexpressions::map(withexpression (*kc_fp)(withexpression))
{ return dynamic_cast<withexpressions>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Conswithexpressions)); }
withexpressions
kc_tag_withexpressions::filter(bool (*kc_fp)(withexpression))
{ return dynamic_cast<withexpressions>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Conswithexpressions)); }

withexpressions
kc_tag_withexpressions::append(withexpression last)
{
    if(is_nil()) { withexpression_1=last;withexpressions_1=Nilwithexpressions(); return this; }
    return withexpressions_1->append(last);
}
withexpressions
kc_tag_withexpressions::merge( withexpressions second, withexpression (*kc_fp)(withexpression, withexpression))
{
    return dynamic_cast<withexpressions>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Conswithexpressions));
}
withexpression
kc_tag_withexpressions::reduce( withexpression neutral, withexpression (*kc_fp)(withexpression, withexpression))
{
    return dynamic_cast<withexpression>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

withcases
concat(c_withcases kc_p1, c_withcases kc_p2)
{ return dynamic_cast<withcases>(kc_p1->do_concat(kc_p2, sel_Conswithcases)); }

withcases
kc_tag_withcases::reverse() const
{ return dynamic_cast<withcases>(do_reverse(Nilwithcases(), sel_Conswithcases)); }

withcase
kc_tag_withcases::last() const
{ return dynamic_cast<withcase>(kc_tag_abstract_list::last()); }

bool
kc_tag_withcases::is_nil() const
{
    return withcase_1==0 && withcases_1==0;
}

withcases
kc_tag_withcases::map(withcase (*kc_fp)(withcase))
{ return dynamic_cast<withcases>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Conswithcases)); }
withcases
kc_tag_withcases::filter(bool (*kc_fp)(withcase))
{ return dynamic_cast<withcases>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Conswithcases)); }

withcases
kc_tag_withcases::append(withcase last)
{
    if(is_nil()) { withcase_1=last;withcases_1=Nilwithcases(); return this; }
    return withcases_1->append(last);
}
withcases
kc_tag_withcases::merge( withcases second, withcase (*kc_fp)(withcase, withcase))
{
    return dynamic_cast<withcases>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Conswithcases));
}
withcase
kc_tag_withcases::reduce( withcase neutral, withcase (*kc_fp)(withcase, withcase))
{
    return dynamic_cast<withcase>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

unparsedeclarations
concat(c_unparsedeclarations kc_p1, c_unparsedeclarations kc_p2)
{ return dynamic_cast<unparsedeclarations>(kc_p1->do_concat(kc_p2, sel_Consunparsedeclarations)); }

unparsedeclarations
kc_tag_unparsedeclarations::reverse() const
{ return dynamic_cast<unparsedeclarations>(do_reverse(Nilunparsedeclarations(), sel_Consunparsedeclarations)); }

unparsedeclaration
kc_tag_unparsedeclarations::last() const
{ return dynamic_cast<unparsedeclaration>(kc_tag_abstract_list::last()); }

bool
kc_tag_unparsedeclarations::is_nil() const
{
    return unparsedeclaration_1==0 && unparsedeclarations_1==0;
}

unparsedeclarations
kc_tag_unparsedeclarations::map(unparsedeclaration (*kc_fp)(unparsedeclaration))
{ return dynamic_cast<unparsedeclarations>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consunparsedeclarations)); }
unparsedeclarations
kc_tag_unparsedeclarations::filter(bool (*kc_fp)(unparsedeclaration))
{ return dynamic_cast<unparsedeclarations>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consunparsedeclarations)); }

unparsedeclarations
kc_tag_unparsedeclarations::append(unparsedeclaration last)
{
    if(is_nil()) { unparsedeclaration_1=last;unparsedeclarations_1=Nilunparsedeclarations(); return this; }
    return unparsedeclarations_1->append(last);
}
unparsedeclarations
kc_tag_unparsedeclarations::merge( unparsedeclarations second, unparsedeclaration (*kc_fp)(unparsedeclaration, unparsedeclaration))
{
    return dynamic_cast<unparsedeclarations>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consunparsedeclarations));
}
unparsedeclaration
kc_tag_unparsedeclarations::reduce( unparsedeclaration neutral, unparsedeclaration (*kc_fp)(unparsedeclaration, unparsedeclaration))
{
    return dynamic_cast<unparsedeclaration>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

unparseclauses
concat(c_unparseclauses kc_p1, c_unparseclauses kc_p2)
{ return dynamic_cast<unparseclauses>(kc_p1->do_concat(kc_p2, sel_Consunparseclauses)); }

unparseclauses
kc_tag_unparseclauses::reverse() const
{ return dynamic_cast<unparseclauses>(do_reverse(Nilunparseclauses(), sel_Consunparseclauses)); }

unparseclause
kc_tag_unparseclauses::last() const
{ return dynamic_cast<unparseclause>(kc_tag_abstract_list::last()); }

bool
kc_tag_unparseclauses::is_nil() const
{
    return unparseclause_1==0 && unparseclauses_1==0;
}

unparseclauses
kc_tag_unparseclauses::map(unparseclause (*kc_fp)(unparseclause))
{ return dynamic_cast<unparseclauses>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consunparseclauses)); }
unparseclauses
kc_tag_unparseclauses::filter(bool (*kc_fp)(unparseclause))
{ return dynamic_cast<unparseclauses>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consunparseclauses)); }

unparseclauses
kc_tag_unparseclauses::append(unparseclause last)
{
    if(is_nil()) { unparseclause_1=last;unparseclauses_1=Nilunparseclauses(); return this; }
    return unparseclauses_1->append(last);
}
unparseclauses
kc_tag_unparseclauses::merge( unparseclauses second, unparseclause (*kc_fp)(unparseclause, unparseclause))
{
    return dynamic_cast<unparseclauses>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consunparseclauses));
}
unparseclause
kc_tag_unparseclauses::reduce( unparseclause neutral, unparseclause (*kc_fp)(unparseclause, unparseclause))
{
    return dynamic_cast<unparseclause>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

viewnames
concat(c_viewnames kc_p1, c_viewnames kc_p2)
{ return dynamic_cast<viewnames>(kc_p1->do_concat(kc_p2, sel_Consviewnames)); }

viewnames
kc_tag_viewnames::reverse() const
{ return dynamic_cast<viewnames>(do_reverse(Nilviewnames(), sel_Consviewnames)); }

ID
kc_tag_viewnames::last() const
{ return dynamic_cast<ID>(kc_tag_abstract_list::last()); }

bool
kc_tag_viewnames::is_nil() const
{
    return ID_1==0 && viewnames_1==0;
}

viewnames
kc_tag_viewnames::map(ID (*kc_fp)(ID))
{ return dynamic_cast<viewnames>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consviewnames)); }
viewnames
kc_tag_viewnames::filter(bool (*kc_fp)(ID))
{ return dynamic_cast<viewnames>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consviewnames)); }

viewnames
kc_tag_viewnames::append(ID last)
{
    if(is_nil()) { ID_1=last;viewnames_1=Nilviewnames(); return this; }
    return viewnames_1->append(last);
}
viewnames
kc_tag_viewnames::merge( viewnames second, ID (*kc_fp)(ID, ID))
{
    return dynamic_cast<viewnames>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consviewnames));
}
ID
kc_tag_viewnames::reduce( ID neutral, ID (*kc_fp)(ID, ID))
{
    return dynamic_cast<ID>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

unparseitems
concat(c_unparseitems kc_p1, c_unparseitems kc_p2)
{ return dynamic_cast<unparseitems>(kc_p1->do_concat(kc_p2, sel_Consunparseitems)); }

unparseitems
kc_tag_unparseitems::reverse() const
{ return dynamic_cast<unparseitems>(do_reverse(Nilunparseitems(), sel_Consunparseitems)); }

unparseitem
kc_tag_unparseitems::last() const
{ return dynamic_cast<unparseitem>(kc_tag_abstract_list::last()); }

bool
kc_tag_unparseitems::is_nil() const
{
    return unparseitem_1==0 && unparseitems_1==0;
}

unparseitems
kc_tag_unparseitems::map(unparseitem (*kc_fp)(unparseitem))
{ return dynamic_cast<unparseitems>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consunparseitems)); }
unparseitems
kc_tag_unparseitems::filter(bool (*kc_fp)(unparseitem))
{ return dynamic_cast<unparseitems>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consunparseitems)); }

unparseitems
kc_tag_unparseitems::append(unparseitem last)
{
    if(is_nil()) { unparseitem_1=last;unparseitems_1=Nilunparseitems(); return this; }
    return unparseitems_1->append(last);
}
unparseitems
kc_tag_unparseitems::merge( unparseitems second, unparseitem (*kc_fp)(unparseitem, unparseitem))
{
    return dynamic_cast<unparseitems>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consunparseitems));
}
unparseitem
kc_tag_unparseitems::reduce( unparseitem neutral, unparseitem (*kc_fp)(unparseitem, unparseitem))
{
    return dynamic_cast<unparseitem>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

unpattributes
concat(c_unpattributes kc_p1, c_unpattributes kc_p2)
{ return dynamic_cast<unpattributes>(kc_p1->do_concat(kc_p2, sel_Consunpattributes)); }

unpattributes
kc_tag_unpattributes::reverse() const
{ return dynamic_cast<unpattributes>(do_reverse(Nilunpattributes(), sel_Consunpattributes)); }

ID
kc_tag_unpattributes::last() const
{ return dynamic_cast<ID>(kc_tag_abstract_list::last()); }

bool
kc_tag_unpattributes::is_nil() const
{
    return ID_1==0 && unpattributes_1==0;
}

unpattributes
kc_tag_unpattributes::map(ID (*kc_fp)(ID))
{ return dynamic_cast<unpattributes>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consunpattributes)); }
unpattributes
kc_tag_unpattributes::filter(bool (*kc_fp)(ID))
{ return dynamic_cast<unpattributes>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consunpattributes)); }

unpattributes
kc_tag_unpattributes::append(ID last)
{
    if(is_nil()) { ID_1=last;unpattributes_1=Nilunpattributes(); return this; }
    return unpattributes_1->append(last);
}
unpattributes
kc_tag_unpattributes::merge( unpattributes second, ID (*kc_fp)(ID, ID))
{
    return dynamic_cast<unpattributes>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consunpattributes));
}
ID
kc_tag_unpattributes::reduce( ID neutral, ID (*kc_fp)(ID, ID))
{
    return dynamic_cast<ID>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

languagenames
concat(c_languagenames kc_p1, c_languagenames kc_p2)
{ return dynamic_cast<languagenames>(kc_p1->do_concat(kc_p2, sel_Conslanguagenames)); }

languagenames
kc_tag_languagenames::reverse() const
{ return dynamic_cast<languagenames>(do_reverse(Nillanguagenames(), sel_Conslanguagenames)); }

ID
kc_tag_languagenames::last() const
{ return dynamic_cast<ID>(kc_tag_abstract_list::last()); }

bool
kc_tag_languagenames::is_nil() const
{
    return ID_1==0 && languagenames_1==0;
}

languagenames
kc_tag_languagenames::map(ID (*kc_fp)(ID))
{ return dynamic_cast<languagenames>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Conslanguagenames)); }
languagenames
kc_tag_languagenames::filter(bool (*kc_fp)(ID))
{ return dynamic_cast<languagenames>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Conslanguagenames)); }

languagenames
kc_tag_languagenames::append(ID last)
{
    if(is_nil()) { ID_1=last;languagenames_1=Nillanguagenames(); return this; }
    return languagenames_1->append(last);
}
languagenames
kc_tag_languagenames::merge( languagenames second, ID (*kc_fp)(ID, ID))
{
    return dynamic_cast<languagenames>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Conslanguagenames));
}
ID
kc_tag_languagenames::reduce( ID neutral, ID (*kc_fp)(ID, ID))
{
    return dynamic_cast<ID>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

scopetypefilelinestack
concat(c_scopetypefilelinestack kc_p1, c_scopetypefilelinestack kc_p2)
{ return dynamic_cast<scopetypefilelinestack>(kc_p1->do_concat(kc_p2, sel_Consscopetypefilelinestack)); }

scopetypefilelinestack
kc_tag_scopetypefilelinestack::reverse() const
{ return dynamic_cast<scopetypefilelinestack>(do_reverse(Nilscopetypefilelinestack(), sel_Consscopetypefilelinestack)); }

scopetypefileline
kc_tag_scopetypefilelinestack::last() const
{ return dynamic_cast<scopetypefileline>(kc_tag_abstract_list::last()); }

bool
kc_tag_scopetypefilelinestack::is_nil() const
{
    return scopetypefileline_1==0 && scopetypefilelinestack_1==0;
}

scopetypefilelinestack
kc_tag_scopetypefilelinestack::map(scopetypefileline (*kc_fp)(scopetypefileline))
{ return dynamic_cast<scopetypefilelinestack>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consscopetypefilelinestack)); }
scopetypefilelinestack
kc_tag_scopetypefilelinestack::filter(bool (*kc_fp)(scopetypefileline))
{ return dynamic_cast<scopetypefilelinestack>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consscopetypefilelinestack)); }

scopetypefilelinestack
kc_tag_scopetypefilelinestack::append(scopetypefileline last)
{
    if(is_nil()) { scopetypefileline_1=last;scopetypefilelinestack_1=Nilscopetypefilelinestack(); return this; }
    return scopetypefilelinestack_1->append(last);
}
scopetypefilelinestack
kc_tag_scopetypefilelinestack::merge( scopetypefilelinestack second, scopetypefileline (*kc_fp)(scopetypefileline, scopetypefileline))
{
    return dynamic_cast<scopetypefilelinestack>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consscopetypefilelinestack));
}
scopetypefileline
kc_tag_scopetypefilelinestack::reduce( scopetypefileline neutral, scopetypefileline (*kc_fp)(scopetypefileline, scopetypefileline))
{
    return dynamic_cast<scopetypefileline>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

operators
concat(c_operators kc_p1, c_operators kc_p2)
{ return dynamic_cast<operators>(kc_p1->do_concat(kc_p2, sel_Consoperators)); }

operators
kc_tag_operators::reverse() const
{ return dynamic_cast<operators>(do_reverse(Niloperators(), sel_Consoperators)); }

ID
kc_tag_operators::last() const
{ return dynamic_cast<ID>(kc_tag_abstract_list::last()); }

bool
kc_tag_operators::is_nil() const
{
    return ID_1==0 && operators_1==0;
}

operators
kc_tag_operators::map(ID (*kc_fp)(ID))
{ return dynamic_cast<operators>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consoperators)); }
operators
kc_tag_operators::filter(bool (*kc_fp)(ID))
{ return dynamic_cast<operators>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consoperators)); }

operators
kc_tag_operators::append(ID last)
{
    if(is_nil()) { ID_1=last;operators_1=Niloperators(); return this; }
    return operators_1->append(last);
}
operators
kc_tag_operators::merge( operators second, ID (*kc_fp)(ID, ID))
{
    return dynamic_cast<operators>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consoperators));
}
ID
kc_tag_operators::reduce( ID neutral, ID (*kc_fp)(ID, ID))
{
    return dynamic_cast<ID>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

phyla
concat(c_phyla kc_p1, c_phyla kc_p2)
{ return dynamic_cast<phyla>(kc_p1->do_concat(kc_p2, sel_Consphyla)); }

phyla
kc_tag_phyla::reverse() const
{ return dynamic_cast<phyla>(do_reverse(Nilphyla(), sel_Consphyla)); }

ID
kc_tag_phyla::last() const
{ return dynamic_cast<ID>(kc_tag_abstract_list::last()); }

bool
kc_tag_phyla::is_nil() const
{
    return ID_1==0 && phyla_1==0;
}

phyla
kc_tag_phyla::map(ID (*kc_fp)(ID))
{ return dynamic_cast<phyla>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consphyla)); }
phyla
kc_tag_phyla::filter(bool (*kc_fp)(ID))
{ return dynamic_cast<phyla>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consphyla)); }

phyla
kc_tag_phyla::append(ID last)
{
    if(is_nil()) { ID_1=last;phyla_1=Nilphyla(); return this; }
    return phyla_1->append(last);
}
phyla
kc_tag_phyla::merge( phyla second, ID (*kc_fp)(ID, ID))
{
    return dynamic_cast<phyla>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consphyla));
}
ID
kc_tag_phyla::reduce( ID neutral, ID (*kc_fp)(ID, ID))
{
    return dynamic_cast<ID>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

variables
concat(c_variables kc_p1, c_variables kc_p2)
{ return dynamic_cast<variables>(kc_p1->do_concat(kc_p2, sel_Consvariables)); }

variables
kc_tag_variables::reverse() const
{ return dynamic_cast<variables>(do_reverse(Nilvariables(), sel_Consvariables)); }

ID
kc_tag_variables::last() const
{ return dynamic_cast<ID>(kc_tag_abstract_list::last()); }

bool
kc_tag_variables::is_nil() const
{
    return ID_1==0 && variables_1==0;
}

variables
kc_tag_variables::map(ID (*kc_fp)(ID))
{ return dynamic_cast<variables>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consvariables)); }
variables
kc_tag_variables::filter(bool (*kc_fp)(ID))
{ return dynamic_cast<variables>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consvariables)); }

variables
kc_tag_variables::append(ID last)
{
    if(is_nil()) { ID_1=last;variables_1=Nilvariables(); return this; }
    return variables_1->append(last);
}
variables
kc_tag_variables::merge( variables second, ID (*kc_fp)(ID, ID))
{
    return dynamic_cast<variables>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consvariables));
}
ID
kc_tag_variables::reduce( ID neutral, ID (*kc_fp)(ID, ID))
{
    return dynamic_cast<ID>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

patternrepresentations
concat(c_patternrepresentations kc_p1, c_patternrepresentations kc_p2)
{ return dynamic_cast<patternrepresentations>(kc_p1->do_concat(kc_p2, sel_Conspatternrepresentations)); }

patternrepresentations
kc_tag_patternrepresentations::reverse() const
{ return dynamic_cast<patternrepresentations>(do_reverse(Nilpatternrepresentations(), sel_Conspatternrepresentations)); }

patternrepresentation
kc_tag_patternrepresentations::last() const
{ return dynamic_cast<patternrepresentation>(kc_tag_abstract_list::last()); }

bool
kc_tag_patternrepresentations::is_nil() const
{
    return patternrepresentation_1==0 && patternrepresentations_1==0;
}

patternrepresentations
kc_tag_patternrepresentations::map(patternrepresentation (*kc_fp)(patternrepresentation))
{ return dynamic_cast<patternrepresentations>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Conspatternrepresentations)); }
patternrepresentations
kc_tag_patternrepresentations::filter(bool (*kc_fp)(patternrepresentation))
{ return dynamic_cast<patternrepresentations>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Conspatternrepresentations)); }

patternrepresentations
kc_tag_patternrepresentations::append(patternrepresentation last)
{
    if(is_nil()) { patternrepresentation_1=last;patternrepresentations_1=Nilpatternrepresentations(); return this; }
    return patternrepresentations_1->append(last);
}
patternrepresentations
kc_tag_patternrepresentations::merge( patternrepresentations second, patternrepresentation (*kc_fp)(patternrepresentation, patternrepresentation))
{
    return dynamic_cast<patternrepresentations>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Conspatternrepresentations));
}
patternrepresentation
kc_tag_patternrepresentations::reduce( patternrepresentation neutral, patternrepresentation (*kc_fp)(patternrepresentation, patternrepresentation))
{
    return dynamic_cast<patternrepresentation>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

patternrepresentation
concat(c_patternrepresentation kc_p1, c_patternrepresentation kc_p2)
{ return dynamic_cast<patternrepresentation>(kc_p1->do_concat(kc_p2, sel_Conspatternrepresentation)); }

patternrepresentation
kc_tag_patternrepresentation::reverse() const
{ return dynamic_cast<patternrepresentation>(do_reverse(Nilpatternrepresentation(), sel_Conspatternrepresentation)); }

elem_patternrepresentation
kc_tag_patternrepresentation::last() const
{ return dynamic_cast<elem_patternrepresentation>(kc_tag_abstract_list::last()); }

bool
kc_tag_patternrepresentation::is_nil() const
{
    return elem_patternrepresentation_1==0 && patternrepresentation_1==0;
}

patternrepresentation
kc_tag_patternrepresentation::map(elem_patternrepresentation (*kc_fp)(elem_patternrepresentation))
{ return dynamic_cast<patternrepresentation>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Conspatternrepresentation)); }
patternrepresentation
kc_tag_patternrepresentation::filter(bool (*kc_fp)(elem_patternrepresentation))
{ return dynamic_cast<patternrepresentation>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Conspatternrepresentation)); }

patternrepresentation
kc_tag_patternrepresentation::append(elem_patternrepresentation last)
{
    if(is_nil()) { elem_patternrepresentation_1=last;patternrepresentation_1=Nilpatternrepresentation(); return this; }
    return patternrepresentation_1->append(last);
}
patternrepresentation
kc_tag_patternrepresentation::merge( patternrepresentation second, elem_patternrepresentation (*kc_fp)(elem_patternrepresentation, elem_patternrepresentation))
{
    return dynamic_cast<patternrepresentation>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Conspatternrepresentation));
}
elem_patternrepresentation
kc_tag_patternrepresentation::reduce( elem_patternrepresentation neutral, elem_patternrepresentation (*kc_fp)(elem_patternrepresentation, elem_patternrepresentation))
{
    return dynamic_cast<elem_patternrepresentation>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

path
concat(c_path kc_p1, c_path kc_p2)
{ return dynamic_cast<path>(kc_p1->do_concat(kc_p2, sel_Conspath)); }

path
kc_tag_path::reverse() const
{ return dynamic_cast<path>(do_reverse(Nilpath(), sel_Conspath)); }

integer
kc_tag_path::last() const
{ return dynamic_cast<integer>(kc_tag_abstract_list::last()); }

bool
kc_tag_path::is_nil() const
{
    return integer_1==0 && path_1==0;
}

path
kc_tag_path::map(integer (*kc_fp)(integer))
{ return dynamic_cast<path>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Conspath)); }
path
kc_tag_path::filter(bool (*kc_fp)(integer))
{ return dynamic_cast<path>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Conspath)); }

path
kc_tag_path::append(integer last)
{
    if(is_nil()) { integer_1=last;path_1=Nilpath(); return this; }
    return path_1->append(last);
}
path
kc_tag_path::merge( path second, integer (*kc_fp)(integer, integer))
{
    return dynamic_cast<path>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Conspath));
}
integer
kc_tag_path::reduce( integer neutral, integer (*kc_fp)(integer, integer))
{
    return dynamic_cast<integer>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

paths
concat(c_paths kc_p1, c_paths kc_p2)
{ return dynamic_cast<paths>(kc_p1->do_concat(kc_p2, sel_Conspaths)); }

paths
kc_tag_paths::reverse() const
{ return dynamic_cast<paths>(do_reverse(Nilpaths(), sel_Conspaths)); }

path
kc_tag_paths::last() const
{ return dynamic_cast<path>(kc_tag_abstract_list::last()); }

bool
kc_tag_paths::is_nil() const
{
    return path_1==0 && paths_1==0;
}

paths
kc_tag_paths::map(path (*kc_fp)(path))
{ return dynamic_cast<paths>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Conspaths)); }
paths
kc_tag_paths::filter(bool (*kc_fp)(path))
{ return dynamic_cast<paths>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Conspaths)); }

paths
kc_tag_paths::append(path last)
{
    if(is_nil()) { path_1=last;paths_1=Nilpaths(); return this; }
    return paths_1->append(last);
}
paths
kc_tag_paths::merge( paths second, path (*kc_fp)(path, path))
{
    return dynamic_cast<paths>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Conspaths));
}
path
kc_tag_paths::reduce( path neutral, path (*kc_fp)(path, path))
{
    return dynamic_cast<path>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

argsnumbers
concat(c_argsnumbers kc_p1, c_argsnumbers kc_p2)
{ return dynamic_cast<argsnumbers>(kc_p1->do_concat(kc_p2, sel_Consargsnumbers)); }

argsnumbers
kc_tag_argsnumbers::reverse() const
{ return dynamic_cast<argsnumbers>(do_reverse(Nilargsnumbers(), sel_Consargsnumbers)); }

integer
kc_tag_argsnumbers::last() const
{ return dynamic_cast<integer>(kc_tag_abstract_list::last()); }

bool
kc_tag_argsnumbers::is_nil() const
{
    return integer_1==0 && argsnumbers_1==0;
}

argsnumbers
kc_tag_argsnumbers::map(integer (*kc_fp)(integer))
{ return dynamic_cast<argsnumbers>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consargsnumbers)); }
argsnumbers
kc_tag_argsnumbers::filter(bool (*kc_fp)(integer))
{ return dynamic_cast<argsnumbers>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consargsnumbers)); }

argsnumbers
kc_tag_argsnumbers::append(integer last)
{
    if(is_nil()) { integer_1=last;argsnumbers_1=Nilargsnumbers(); return this; }
    return argsnumbers_1->append(last);
}
argsnumbers
kc_tag_argsnumbers::merge( argsnumbers second, integer (*kc_fp)(integer, integer))
{
    return dynamic_cast<argsnumbers>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consargsnumbers));
}
integer
kc_tag_argsnumbers::reduce( integer neutral, integer (*kc_fp)(integer, integer))
{
    return dynamic_cast<integer>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

rewriterulesinfo
concat(c_rewriterulesinfo kc_p1, c_rewriterulesinfo kc_p2)
{ return dynamic_cast<rewriterulesinfo>(kc_p1->do_concat(kc_p2, sel_Consrewriterulesinfo)); }

rewriterulesinfo
kc_tag_rewriterulesinfo::reverse() const
{ return dynamic_cast<rewriterulesinfo>(do_reverse(Nilrewriterulesinfo(), sel_Consrewriterulesinfo)); }

rewriteruleinfo
kc_tag_rewriterulesinfo::last() const
{ return dynamic_cast<rewriteruleinfo>(kc_tag_abstract_list::last()); }

bool
kc_tag_rewriterulesinfo::is_nil() const
{
    return rewriteruleinfo_1==0 && rewriterulesinfo_1==0;
}

rewriterulesinfo
kc_tag_rewriterulesinfo::map(rewriteruleinfo (*kc_fp)(rewriteruleinfo))
{ return dynamic_cast<rewriterulesinfo>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consrewriterulesinfo)); }
rewriterulesinfo
kc_tag_rewriterulesinfo::filter(bool (*kc_fp)(rewriteruleinfo))
{ return dynamic_cast<rewriterulesinfo>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consrewriterulesinfo)); }

rewriterulesinfo
kc_tag_rewriterulesinfo::append(rewriteruleinfo last)
{
    if(is_nil()) { rewriteruleinfo_1=last;rewriterulesinfo_1=Nilrewriterulesinfo(); return this; }
    return rewriterulesinfo_1->append(last);
}
rewriterulesinfo
kc_tag_rewriterulesinfo::merge( rewriterulesinfo second, rewriteruleinfo (*kc_fp)(rewriteruleinfo, rewriteruleinfo))
{
    return dynamic_cast<rewriterulesinfo>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consrewriterulesinfo));
}
rewriteruleinfo
kc_tag_rewriterulesinfo::reduce( rewriteruleinfo neutral, rewriteruleinfo (*kc_fp)(rewriteruleinfo, rewriteruleinfo))
{
    return dynamic_cast<rewriteruleinfo>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

withcasesinfo
concat(c_withcasesinfo kc_p1, c_withcasesinfo kc_p2)
{ return dynamic_cast<withcasesinfo>(kc_p1->do_concat(kc_p2, sel_Conswithcasesinfo)); }

withcasesinfo
kc_tag_withcasesinfo::reverse() const
{ return dynamic_cast<withcasesinfo>(do_reverse(Nilwithcasesinfo(), sel_Conswithcasesinfo)); }

withcaseinfo
kc_tag_withcasesinfo::last() const
{ return dynamic_cast<withcaseinfo>(kc_tag_abstract_list::last()); }

bool
kc_tag_withcasesinfo::is_nil() const
{
    return withcaseinfo_1==0 && withcasesinfo_1==0;
}

withcasesinfo
kc_tag_withcasesinfo::map(withcaseinfo (*kc_fp)(withcaseinfo))
{ return dynamic_cast<withcasesinfo>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Conswithcasesinfo)); }
withcasesinfo
kc_tag_withcasesinfo::filter(bool (*kc_fp)(withcaseinfo))
{ return dynamic_cast<withcasesinfo>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Conswithcasesinfo)); }

withcasesinfo
kc_tag_withcasesinfo::append(withcaseinfo last)
{
    if(is_nil()) { withcaseinfo_1=last;withcasesinfo_1=Nilwithcasesinfo(); return this; }
    return withcasesinfo_1->append(last);
}
withcasesinfo
kc_tag_withcasesinfo::merge( withcasesinfo second, withcaseinfo (*kc_fp)(withcaseinfo, withcaseinfo))
{
    return dynamic_cast<withcasesinfo>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Conswithcasesinfo));
}
withcaseinfo
kc_tag_withcasesinfo::reduce( withcaseinfo neutral, withcaseinfo (*kc_fp)(withcaseinfo, withcaseinfo))
{
    return dynamic_cast<withcaseinfo>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

rewriteviewsinfo
concat(c_rewriteviewsinfo kc_p1, c_rewriteviewsinfo kc_p2)
{ return dynamic_cast<rewriteviewsinfo>(kc_p1->do_concat(kc_p2, sel_Consrewriteviewsinfo)); }

rewriteviewsinfo
kc_tag_rewriteviewsinfo::reverse() const
{ return dynamic_cast<rewriteviewsinfo>(do_reverse(Nilrewriteviewsinfo(), sel_Consrewriteviewsinfo)); }

rewriteviewinfo
kc_tag_rewriteviewsinfo::last() const
{ return dynamic_cast<rewriteviewinfo>(kc_tag_abstract_list::last()); }

bool
kc_tag_rewriteviewsinfo::is_nil() const
{
    return rewriteviewinfo_1==0 && rewriteviewsinfo_1==0;
}

rewriteviewsinfo
kc_tag_rewriteviewsinfo::map(rewriteviewinfo (*kc_fp)(rewriteviewinfo))
{ return dynamic_cast<rewriteviewsinfo>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consrewriteviewsinfo)); }
rewriteviewsinfo
kc_tag_rewriteviewsinfo::filter(bool (*kc_fp)(rewriteviewinfo))
{ return dynamic_cast<rewriteviewsinfo>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consrewriteviewsinfo)); }

rewriteviewsinfo
kc_tag_rewriteviewsinfo::append(rewriteviewinfo last)
{
    if(is_nil()) { rewriteviewinfo_1=last;rewriteviewsinfo_1=Nilrewriteviewsinfo(); return this; }
    return rewriteviewsinfo_1->append(last);
}
rewriteviewsinfo
kc_tag_rewriteviewsinfo::merge( rewriteviewsinfo second, rewriteviewinfo (*kc_fp)(rewriteviewinfo, rewriteviewinfo))
{
    return dynamic_cast<rewriteviewsinfo>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consrewriteviewsinfo));
}
rewriteviewinfo
kc_tag_rewriteviewsinfo::reduce( rewriteviewinfo neutral, rewriteviewinfo (*kc_fp)(rewriteviewinfo, rewriteviewinfo))
{
    return dynamic_cast<rewriteviewinfo>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

unparseviewsinfo
concat(c_unparseviewsinfo kc_p1, c_unparseviewsinfo kc_p2)
{ return dynamic_cast<unparseviewsinfo>(kc_p1->do_concat(kc_p2, sel_Consunparseviewsinfo)); }

unparseviewsinfo
kc_tag_unparseviewsinfo::reverse() const
{ return dynamic_cast<unparseviewsinfo>(do_reverse(Nilunparseviewsinfo(), sel_Consunparseviewsinfo)); }

unparseviewinfo
kc_tag_unparseviewsinfo::last() const
{ return dynamic_cast<unparseviewinfo>(kc_tag_abstract_list::last()); }

bool
kc_tag_unparseviewsinfo::is_nil() const
{
    return unparseviewinfo_1==0 && unparseviewsinfo_1==0;
}

unparseviewsinfo
kc_tag_unparseviewsinfo::map(unparseviewinfo (*kc_fp)(unparseviewinfo))
{ return dynamic_cast<unparseviewsinfo>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consunparseviewsinfo)); }
unparseviewsinfo
kc_tag_unparseviewsinfo::filter(bool (*kc_fp)(unparseviewinfo))
{ return dynamic_cast<unparseviewsinfo>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consunparseviewsinfo)); }

unparseviewsinfo
kc_tag_unparseviewsinfo::append(unparseviewinfo last)
{
    if(is_nil()) { unparseviewinfo_1=last;unparseviewsinfo_1=Nilunparseviewsinfo(); return this; }
    return unparseviewsinfo_1->append(last);
}
unparseviewsinfo
kc_tag_unparseviewsinfo::merge( unparseviewsinfo second, unparseviewinfo (*kc_fp)(unparseviewinfo, unparseviewinfo))
{
    return dynamic_cast<unparseviewsinfo>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consunparseviewsinfo));
}
unparseviewinfo
kc_tag_unparseviewsinfo::reduce( unparseviewinfo neutral, unparseviewinfo (*kc_fp)(unparseviewinfo, unparseviewinfo))
{
    return dynamic_cast<unparseviewinfo>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

unparsedeclsinfo
concat(c_unparsedeclsinfo kc_p1, c_unparsedeclsinfo kc_p2)
{ return dynamic_cast<unparsedeclsinfo>(kc_p1->do_concat(kc_p2, sel_Consunparsedeclsinfo)); }

unparsedeclsinfo
kc_tag_unparsedeclsinfo::reverse() const
{ return dynamic_cast<unparsedeclsinfo>(do_reverse(Nilunparsedeclsinfo(), sel_Consunparsedeclsinfo)); }

unparsedeclinfo
kc_tag_unparsedeclsinfo::last() const
{ return dynamic_cast<unparsedeclinfo>(kc_tag_abstract_list::last()); }

bool
kc_tag_unparsedeclsinfo::is_nil() const
{
    return unparsedeclinfo_1==0 && unparsedeclsinfo_1==0;
}

unparsedeclsinfo
kc_tag_unparsedeclsinfo::map(unparsedeclinfo (*kc_fp)(unparsedeclinfo))
{ return dynamic_cast<unparsedeclsinfo>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consunparsedeclsinfo)); }
unparsedeclsinfo
kc_tag_unparsedeclsinfo::filter(bool (*kc_fp)(unparsedeclinfo))
{ return dynamic_cast<unparsedeclsinfo>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consunparsedeclsinfo)); }

unparsedeclsinfo
kc_tag_unparsedeclsinfo::append(unparsedeclinfo last)
{
    if(is_nil()) { unparsedeclinfo_1=last;unparsedeclsinfo_1=Nilunparsedeclsinfo(); return this; }
    return unparsedeclsinfo_1->append(last);
}
unparsedeclsinfo
kc_tag_unparsedeclsinfo::merge( unparsedeclsinfo second, unparsedeclinfo (*kc_fp)(unparsedeclinfo, unparsedeclinfo))
{
    return dynamic_cast<unparsedeclsinfo>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consunparsedeclsinfo));
}
unparsedeclinfo
kc_tag_unparsedeclsinfo::reduce( unparsedeclinfo neutral, unparsedeclinfo (*kc_fp)(unparsedeclinfo, unparsedeclinfo))
{
    return dynamic_cast<unparsedeclinfo>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

ac_declaration_list
concat(c_ac_declaration_list kc_p1, c_ac_declaration_list kc_p2)
{ return dynamic_cast<ac_declaration_list>(kc_p1->do_concat(kc_p2, sel_Consac_declaration_list)); }

ac_declaration_list
kc_tag_ac_declaration_list::reverse() const
{ return dynamic_cast<ac_declaration_list>(do_reverse(Nilac_declaration_list(), sel_Consac_declaration_list)); }

ac_declaration
kc_tag_ac_declaration_list::last() const
{ return dynamic_cast<ac_declaration>(kc_tag_abstract_list::last()); }

bool
kc_tag_ac_declaration_list::is_nil() const
{
    return ac_declaration_1==0 && ac_declaration_list_1==0;
}

ac_declaration_list
kc_tag_ac_declaration_list::map(ac_declaration (*kc_fp)(ac_declaration))
{ return dynamic_cast<ac_declaration_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consac_declaration_list)); }
ac_declaration_list
kc_tag_ac_declaration_list::filter(bool (*kc_fp)(ac_declaration))
{ return dynamic_cast<ac_declaration_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consac_declaration_list)); }

ac_declaration_list
kc_tag_ac_declaration_list::append(ac_declaration last)
{
    if(is_nil()) { ac_declaration_1=last;ac_declaration_list_1=Nilac_declaration_list(); return this; }
    return ac_declaration_list_1->append(last);
}
ac_declaration_list
kc_tag_ac_declaration_list::merge( ac_declaration_list second, ac_declaration (*kc_fp)(ac_declaration, ac_declaration))
{
    return dynamic_cast<ac_declaration_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consac_declaration_list));
}
ac_declaration
kc_tag_ac_declaration_list::reduce( ac_declaration neutral, ac_declaration (*kc_fp)(ac_declaration, ac_declaration))
{
    return dynamic_cast<ac_declaration>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

ac_declaration_specifiers
concat(c_ac_declaration_specifiers kc_p1, c_ac_declaration_specifiers kc_p2)
{ return dynamic_cast<ac_declaration_specifiers>(kc_p1->do_concat(kc_p2, sel_Consac_declaration_specifiers)); }

ac_declaration_specifiers
kc_tag_ac_declaration_specifiers::reverse() const
{ return dynamic_cast<ac_declaration_specifiers>(do_reverse(Nilac_declaration_specifiers(), sel_Consac_declaration_specifiers)); }

ac_declaration_specifier
kc_tag_ac_declaration_specifiers::last() const
{ return dynamic_cast<ac_declaration_specifier>(kc_tag_abstract_list::last()); }

bool
kc_tag_ac_declaration_specifiers::is_nil() const
{
    return ac_declaration_specifier_1==0 && ac_declaration_specifiers_1==0;
}

ac_declaration_specifiers
kc_tag_ac_declaration_specifiers::map(ac_declaration_specifier (*kc_fp)(ac_declaration_specifier))
{ return dynamic_cast<ac_declaration_specifiers>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consac_declaration_specifiers)); }
ac_declaration_specifiers
kc_tag_ac_declaration_specifiers::filter(bool (*kc_fp)(ac_declaration_specifier))
{ return dynamic_cast<ac_declaration_specifiers>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consac_declaration_specifiers)); }

ac_declaration_specifiers
kc_tag_ac_declaration_specifiers::append(ac_declaration_specifier last)
{
    if(is_nil()) { ac_declaration_specifier_1=last;ac_declaration_specifiers_1=Nilac_declaration_specifiers(); return this; }
    return ac_declaration_specifiers_1->append(last);
}
ac_declaration_specifiers
kc_tag_ac_declaration_specifiers::merge( ac_declaration_specifiers second, ac_declaration_specifier (*kc_fp)(ac_declaration_specifier, ac_declaration_specifier))
{
    return dynamic_cast<ac_declaration_specifiers>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consac_declaration_specifiers));
}
ac_declaration_specifier
kc_tag_ac_declaration_specifiers::reduce( ac_declaration_specifier neutral, ac_declaration_specifier (*kc_fp)(ac_declaration_specifier, ac_declaration_specifier))
{
    return dynamic_cast<ac_declaration_specifier>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

ac_init_declarator_list
concat(c_ac_init_declarator_list kc_p1, c_ac_init_declarator_list kc_p2)
{ return dynamic_cast<ac_init_declarator_list>(kc_p1->do_concat(kc_p2, sel_Consac_init_declarator_list)); }

ac_init_declarator_list
kc_tag_ac_init_declarator_list::reverse() const
{ return dynamic_cast<ac_init_declarator_list>(do_reverse(Nilac_init_declarator_list(), sel_Consac_init_declarator_list)); }

ac_init_declarator
kc_tag_ac_init_declarator_list::last() const
{ return dynamic_cast<ac_init_declarator>(kc_tag_abstract_list::last()); }

bool
kc_tag_ac_init_declarator_list::is_nil() const
{
    return ac_init_declarator_1==0 && ac_init_declarator_list_1==0;
}

ac_init_declarator_list
kc_tag_ac_init_declarator_list::map(ac_init_declarator (*kc_fp)(ac_init_declarator))
{ return dynamic_cast<ac_init_declarator_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consac_init_declarator_list)); }
ac_init_declarator_list
kc_tag_ac_init_declarator_list::filter(bool (*kc_fp)(ac_init_declarator))
{ return dynamic_cast<ac_init_declarator_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consac_init_declarator_list)); }

ac_init_declarator_list
kc_tag_ac_init_declarator_list::append(ac_init_declarator last)
{
    if(is_nil()) { ac_init_declarator_1=last;ac_init_declarator_list_1=Nilac_init_declarator_list(); return this; }
    return ac_init_declarator_list_1->append(last);
}
ac_init_declarator_list
kc_tag_ac_init_declarator_list::merge( ac_init_declarator_list second, ac_init_declarator (*kc_fp)(ac_init_declarator, ac_init_declarator))
{
    return dynamic_cast<ac_init_declarator_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consac_init_declarator_list));
}
ac_init_declarator
kc_tag_ac_init_declarator_list::reduce( ac_init_declarator neutral, ac_init_declarator (*kc_fp)(ac_init_declarator, ac_init_declarator))
{
    return dynamic_cast<ac_init_declarator>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

ac_class_qualifier_help_list
concat(c_ac_class_qualifier_help_list kc_p1, c_ac_class_qualifier_help_list kc_p2)
{ return dynamic_cast<ac_class_qualifier_help_list>(kc_p1->do_concat(kc_p2, sel_Consac_class_qualifier_help_list)); }

ac_class_qualifier_help_list
kc_tag_ac_class_qualifier_help_list::reverse() const
{ return dynamic_cast<ac_class_qualifier_help_list>(do_reverse(Nilac_class_qualifier_help_list(), sel_Consac_class_qualifier_help_list)); }

ac_direct_declarator
kc_tag_ac_class_qualifier_help_list::last() const
{ return dynamic_cast<ac_direct_declarator>(kc_tag_abstract_list::last()); }

bool
kc_tag_ac_class_qualifier_help_list::is_nil() const
{
    return ac_direct_declarator_1==0 && ac_class_qualifier_help_list_1==0;
}

ac_class_qualifier_help_list
kc_tag_ac_class_qualifier_help_list::map(ac_direct_declarator (*kc_fp)(ac_direct_declarator))
{ return dynamic_cast<ac_class_qualifier_help_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consac_class_qualifier_help_list)); }
ac_class_qualifier_help_list
kc_tag_ac_class_qualifier_help_list::filter(bool (*kc_fp)(ac_direct_declarator))
{ return dynamic_cast<ac_class_qualifier_help_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consac_class_qualifier_help_list)); }

ac_class_qualifier_help_list
kc_tag_ac_class_qualifier_help_list::append(ac_direct_declarator last)
{
    if(is_nil()) { ac_direct_declarator_1=last;ac_class_qualifier_help_list_1=Nilac_class_qualifier_help_list(); return this; }
    return ac_class_qualifier_help_list_1->append(last);
}
ac_class_qualifier_help_list
kc_tag_ac_class_qualifier_help_list::merge( ac_class_qualifier_help_list second, ac_direct_declarator (*kc_fp)(ac_direct_declarator, ac_direct_declarator))
{
    return dynamic_cast<ac_class_qualifier_help_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consac_class_qualifier_help_list));
}
ac_direct_declarator
kc_tag_ac_class_qualifier_help_list::reduce( ac_direct_declarator neutral, ac_direct_declarator (*kc_fp)(ac_direct_declarator, ac_direct_declarator))
{
    return dynamic_cast<ac_direct_declarator>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

ac_class_qualifier_list
concat(c_ac_class_qualifier_list kc_p1, c_ac_class_qualifier_list kc_p2)
{ return dynamic_cast<ac_class_qualifier_list>(kc_p1->do_concat(kc_p2, sel_Consac_class_qualifier_list)); }

ac_class_qualifier_list
kc_tag_ac_class_qualifier_list::reverse() const
{ return dynamic_cast<ac_class_qualifier_list>(do_reverse(Nilac_class_qualifier_list(), sel_Consac_class_qualifier_list)); }

ID
kc_tag_ac_class_qualifier_list::last() const
{ return dynamic_cast<ID>(kc_tag_abstract_list::last()); }

bool
kc_tag_ac_class_qualifier_list::is_nil() const
{
    return ID_1==0 && ac_class_qualifier_list_1==0;
}

ac_class_qualifier_list
kc_tag_ac_class_qualifier_list::map(ID (*kc_fp)(ID))
{ return dynamic_cast<ac_class_qualifier_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consac_class_qualifier_list)); }
ac_class_qualifier_list
kc_tag_ac_class_qualifier_list::filter(bool (*kc_fp)(ID))
{ return dynamic_cast<ac_class_qualifier_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consac_class_qualifier_list)); }

ac_class_qualifier_list
kc_tag_ac_class_qualifier_list::append(ID last)
{
    if(is_nil()) { ID_1=last;ac_class_qualifier_list_1=Nilac_class_qualifier_list(); return this; }
    return ac_class_qualifier_list_1->append(last);
}
ac_class_qualifier_list
kc_tag_ac_class_qualifier_list::merge( ac_class_qualifier_list second, ID (*kc_fp)(ID, ID))
{
    return dynamic_cast<ac_class_qualifier_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consac_class_qualifier_list));
}
ID
kc_tag_ac_class_qualifier_list::reduce( ID neutral, ID (*kc_fp)(ID, ID))
{
    return dynamic_cast<ID>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

ac_type_qualifier_list
concat(c_ac_type_qualifier_list kc_p1, c_ac_type_qualifier_list kc_p2)
{ return dynamic_cast<ac_type_qualifier_list>(kc_p1->do_concat(kc_p2, sel_Consac_type_qualifier_list)); }

ac_type_qualifier_list
kc_tag_ac_type_qualifier_list::reverse() const
{ return dynamic_cast<ac_type_qualifier_list>(do_reverse(Nilac_type_qualifier_list(), sel_Consac_type_qualifier_list)); }

ac_type_qualifier
kc_tag_ac_type_qualifier_list::last() const
{ return dynamic_cast<ac_type_qualifier>(kc_tag_abstract_list::last()); }

bool
kc_tag_ac_type_qualifier_list::is_nil() const
{
    return ac_type_qualifier_1==0 && ac_type_qualifier_list_1==0;
}

ac_type_qualifier_list
kc_tag_ac_type_qualifier_list::map(ac_type_qualifier (*kc_fp)(ac_type_qualifier))
{ return dynamic_cast<ac_type_qualifier_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consac_type_qualifier_list)); }
ac_type_qualifier_list
kc_tag_ac_type_qualifier_list::filter(bool (*kc_fp)(ac_type_qualifier))
{ return dynamic_cast<ac_type_qualifier_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consac_type_qualifier_list)); }

ac_type_qualifier_list
kc_tag_ac_type_qualifier_list::append(ac_type_qualifier last)
{
    if(is_nil()) { ac_type_qualifier_1=last;ac_type_qualifier_list_1=Nilac_type_qualifier_list(); return this; }
    return ac_type_qualifier_list_1->append(last);
}
ac_type_qualifier_list
kc_tag_ac_type_qualifier_list::merge( ac_type_qualifier_list second, ac_type_qualifier (*kc_fp)(ac_type_qualifier, ac_type_qualifier))
{
    return dynamic_cast<ac_type_qualifier_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consac_type_qualifier_list));
}
ac_type_qualifier
kc_tag_ac_type_qualifier_list::reduce( ac_type_qualifier neutral, ac_type_qualifier (*kc_fp)(ac_type_qualifier, ac_type_qualifier))
{
    return dynamic_cast<ac_type_qualifier>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

ac_parameter_list
concat(c_ac_parameter_list kc_p1, c_ac_parameter_list kc_p2)
{ return dynamic_cast<ac_parameter_list>(kc_p1->do_concat(kc_p2, sel_Consac_parameter_list)); }

ac_parameter_list
kc_tag_ac_parameter_list::reverse() const
{ return dynamic_cast<ac_parameter_list>(do_reverse(Nilac_parameter_list(), sel_Consac_parameter_list)); }

ac_parameter_declaration
kc_tag_ac_parameter_list::last() const
{ return dynamic_cast<ac_parameter_declaration>(kc_tag_abstract_list::last()); }

bool
kc_tag_ac_parameter_list::is_nil() const
{
    return ac_parameter_declaration_1==0 && ac_parameter_list_1==0;
}

ac_parameter_list
kc_tag_ac_parameter_list::map(ac_parameter_declaration (*kc_fp)(ac_parameter_declaration))
{ return dynamic_cast<ac_parameter_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consac_parameter_list)); }
ac_parameter_list
kc_tag_ac_parameter_list::filter(bool (*kc_fp)(ac_parameter_declaration))
{ return dynamic_cast<ac_parameter_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consac_parameter_list)); }

ac_parameter_list
kc_tag_ac_parameter_list::append(ac_parameter_declaration last)
{
    if(is_nil()) { ac_parameter_declaration_1=last;ac_parameter_list_1=Nilac_parameter_list(); return this; }
    return ac_parameter_list_1->append(last);
}
ac_parameter_list
kc_tag_ac_parameter_list::merge( ac_parameter_list second, ac_parameter_declaration (*kc_fp)(ac_parameter_declaration, ac_parameter_declaration))
{
    return dynamic_cast<ac_parameter_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consac_parameter_list));
}
ac_parameter_declaration
kc_tag_ac_parameter_list::reduce( ac_parameter_declaration neutral, ac_parameter_declaration (*kc_fp)(ac_parameter_declaration, ac_parameter_declaration))
{
    return dynamic_cast<ac_parameter_declaration>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

ac_identifier_list
concat(c_ac_identifier_list kc_p1, c_ac_identifier_list kc_p2)
{ return dynamic_cast<ac_identifier_list>(kc_p1->do_concat(kc_p2, sel_Consac_identifier_list)); }

ac_identifier_list
kc_tag_ac_identifier_list::reverse() const
{ return dynamic_cast<ac_identifier_list>(do_reverse(Nilac_identifier_list(), sel_Consac_identifier_list)); }

ID
kc_tag_ac_identifier_list::last() const
{ return dynamic_cast<ID>(kc_tag_abstract_list::last()); }

bool
kc_tag_ac_identifier_list::is_nil() const
{
    return ID_1==0 && ac_identifier_list_1==0;
}

ac_identifier_list
kc_tag_ac_identifier_list::map(ID (*kc_fp)(ID))
{ return dynamic_cast<ac_identifier_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consac_identifier_list)); }
ac_identifier_list
kc_tag_ac_identifier_list::filter(bool (*kc_fp)(ID))
{ return dynamic_cast<ac_identifier_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consac_identifier_list)); }

ac_identifier_list
kc_tag_ac_identifier_list::append(ID last)
{
    if(is_nil()) { ID_1=last;ac_identifier_list_1=Nilac_identifier_list(); return this; }
    return ac_identifier_list_1->append(last);
}
ac_identifier_list
kc_tag_ac_identifier_list::merge( ac_identifier_list second, ID (*kc_fp)(ID, ID))
{
    return dynamic_cast<ac_identifier_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consac_identifier_list));
}
ID
kc_tag_ac_identifier_list::reduce( ID neutral, ID (*kc_fp)(ID, ID))
{
    return dynamic_cast<ID>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

ac_constant_expression_list
concat(c_ac_constant_expression_list kc_p1, c_ac_constant_expression_list kc_p2)
{ return dynamic_cast<ac_constant_expression_list>(kc_p1->do_concat(kc_p2, sel_Consac_constant_expression_list)); }

ac_constant_expression_list
kc_tag_ac_constant_expression_list::reverse() const
{ return dynamic_cast<ac_constant_expression_list>(do_reverse(Nilac_constant_expression_list(), sel_Consac_constant_expression_list)); }

ac_constant_expression
kc_tag_ac_constant_expression_list::last() const
{ return dynamic_cast<ac_constant_expression>(kc_tag_abstract_list::last()); }

bool
kc_tag_ac_constant_expression_list::is_nil() const
{
    return ac_constant_expression_1==0 && ac_constant_expression_list_1==0;
}

ac_constant_expression_list
kc_tag_ac_constant_expression_list::map(ac_constant_expression (*kc_fp)(ac_constant_expression))
{ return dynamic_cast<ac_constant_expression_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consac_constant_expression_list)); }
ac_constant_expression_list
kc_tag_ac_constant_expression_list::filter(bool (*kc_fp)(ac_constant_expression))
{ return dynamic_cast<ac_constant_expression_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consac_constant_expression_list)); }

ac_constant_expression_list
kc_tag_ac_constant_expression_list::append(ac_constant_expression last)
{
    if(is_nil()) { ac_constant_expression_1=last;ac_constant_expression_list_1=Nilac_constant_expression_list(); return this; }
    return ac_constant_expression_list_1->append(last);
}
ac_constant_expression_list
kc_tag_ac_constant_expression_list::merge( ac_constant_expression_list second, ac_constant_expression (*kc_fp)(ac_constant_expression, ac_constant_expression))
{
    return dynamic_cast<ac_constant_expression_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consac_constant_expression_list));
}
ac_constant_expression
kc_tag_ac_constant_expression_list::reduce( ac_constant_expression neutral, ac_constant_expression (*kc_fp)(ac_constant_expression, ac_constant_expression))
{
    return dynamic_cast<ac_constant_expression>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

ac_base_init_list
concat(c_ac_base_init_list kc_p1, c_ac_base_init_list kc_p2)
{ return dynamic_cast<ac_base_init_list>(kc_p1->do_concat(kc_p2, sel_Consac_base_init_list)); }

ac_base_init_list
kc_tag_ac_base_init_list::reverse() const
{ return dynamic_cast<ac_base_init_list>(do_reverse(Nilac_base_init_list(), sel_Consac_base_init_list)); }

ac_base_init
kc_tag_ac_base_init_list::last() const
{ return dynamic_cast<ac_base_init>(kc_tag_abstract_list::last()); }

bool
kc_tag_ac_base_init_list::is_nil() const
{
    return ac_base_init_1==0 && ac_base_init_list_1==0;
}

ac_base_init_list
kc_tag_ac_base_init_list::map(ac_base_init (*kc_fp)(ac_base_init))
{ return dynamic_cast<ac_base_init_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consac_base_init_list)); }
ac_base_init_list
kc_tag_ac_base_init_list::filter(bool (*kc_fp)(ac_base_init))
{ return dynamic_cast<ac_base_init_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consac_base_init_list)); }

ac_base_init_list
kc_tag_ac_base_init_list::append(ac_base_init last)
{
    if(is_nil()) { ac_base_init_1=last;ac_base_init_list_1=Nilac_base_init_list(); return this; }
    return ac_base_init_list_1->append(last);
}
ac_base_init_list
kc_tag_ac_base_init_list::merge( ac_base_init_list second, ac_base_init (*kc_fp)(ac_base_init, ac_base_init))
{
    return dynamic_cast<ac_base_init_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consac_base_init_list));
}
ac_base_init
kc_tag_ac_base_init_list::reduce( ac_base_init neutral, ac_base_init (*kc_fp)(ac_base_init, ac_base_init))
{
    return dynamic_cast<ac_base_init>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

baseclass_declarations
concat(c_baseclass_declarations kc_p1, c_baseclass_declarations kc_p2)
{ return dynamic_cast<baseclass_declarations>(kc_p1->do_concat(kc_p2, sel_Consbaseclass_declarations)); }

baseclass_declarations
kc_tag_baseclass_declarations::reverse() const
{ return dynamic_cast<baseclass_declarations>(do_reverse(Nilbaseclass_declarations(), sel_Consbaseclass_declarations)); }

baseclass_decl
kc_tag_baseclass_declarations::last() const
{ return dynamic_cast<baseclass_decl>(kc_tag_abstract_list::last()); }

bool
kc_tag_baseclass_declarations::is_nil() const
{
    return baseclass_decl_1==0 && baseclass_declarations_1==0;
}

baseclass_declarations
kc_tag_baseclass_declarations::map(baseclass_decl (*kc_fp)(baseclass_decl))
{ return dynamic_cast<baseclass_declarations>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consbaseclass_declarations)); }
baseclass_declarations
kc_tag_baseclass_declarations::filter(bool (*kc_fp)(baseclass_decl))
{ return dynamic_cast<baseclass_declarations>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consbaseclass_declarations)); }

baseclass_declarations
kc_tag_baseclass_declarations::append(baseclass_decl last)
{
    if(is_nil()) { baseclass_decl_1=last;baseclass_declarations_1=Nilbaseclass_declarations(); return this; }
    return baseclass_declarations_1->append(last);
}
baseclass_declarations
kc_tag_baseclass_declarations::merge( baseclass_declarations second, baseclass_decl (*kc_fp)(baseclass_decl, baseclass_decl))
{
    return dynamic_cast<baseclass_declarations>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consbaseclass_declarations));
}
baseclass_decl
kc_tag_baseclass_declarations::reduce( baseclass_decl neutral, baseclass_decl (*kc_fp)(baseclass_decl, baseclass_decl))
{
    return dynamic_cast<baseclass_decl>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

baseclass_list
concat(c_baseclass_list kc_p1, c_baseclass_list kc_p2)
{ return dynamic_cast<baseclass_list>(kc_p1->do_concat(kc_p2, sel_Consbaseclass_list)); }

baseclass_list
kc_tag_baseclass_list::reverse() const
{ return dynamic_cast<baseclass_list>(do_reverse(Nilbaseclass_list(), sel_Consbaseclass_list)); }

ID
kc_tag_baseclass_list::last() const
{ return dynamic_cast<ID>(kc_tag_abstract_list::last()); }

bool
kc_tag_baseclass_list::is_nil() const
{
    return ID_1==0 && baseclass_list_1==0;
}

baseclass_list
kc_tag_baseclass_list::map(ID (*kc_fp)(ID))
{ return dynamic_cast<baseclass_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consbaseclass_list)); }
baseclass_list
kc_tag_baseclass_list::filter(bool (*kc_fp)(ID))
{ return dynamic_cast<baseclass_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consbaseclass_list)); }

baseclass_list
kc_tag_baseclass_list::append(ID last)
{
    if(is_nil()) { ID_1=last;baseclass_list_1=Nilbaseclass_list(); return this; }
    return baseclass_list_1->append(last);
}
baseclass_list
kc_tag_baseclass_list::merge( baseclass_list second, ID (*kc_fp)(ID, ID))
{
    return dynamic_cast<baseclass_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consbaseclass_list));
}
ID
kc_tag_baseclass_list::reduce( ID neutral, ID (*kc_fp)(ID, ID))
{
    return dynamic_cast<ID>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

addedphylumdeclarations
concat(c_addedphylumdeclarations kc_p1, c_addedphylumdeclarations kc_p2)
{ return dynamic_cast<addedphylumdeclarations>(kc_p1->do_concat(kc_p2, sel_Consaddedphylumdeclarations)); }

addedphylumdeclarations
kc_tag_addedphylumdeclarations::reverse() const
{ return dynamic_cast<addedphylumdeclarations>(do_reverse(Niladdedphylumdeclarations(), sel_Consaddedphylumdeclarations)); }

addedphylumdeclaration
kc_tag_addedphylumdeclarations::last() const
{ return dynamic_cast<addedphylumdeclaration>(kc_tag_abstract_list::last()); }

bool
kc_tag_addedphylumdeclarations::is_nil() const
{
    return addedphylumdeclaration_1==0 && addedphylumdeclarations_1==0;
}

addedphylumdeclarations
kc_tag_addedphylumdeclarations::map(addedphylumdeclaration (*kc_fp)(addedphylumdeclaration))
{ return dynamic_cast<addedphylumdeclarations>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consaddedphylumdeclarations)); }
addedphylumdeclarations
kc_tag_addedphylumdeclarations::filter(bool (*kc_fp)(addedphylumdeclaration))
{ return dynamic_cast<addedphylumdeclarations>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consaddedphylumdeclarations)); }

addedphylumdeclarations
kc_tag_addedphylumdeclarations::append(addedphylumdeclaration last)
{
    if(is_nil()) { addedphylumdeclaration_1=last;addedphylumdeclarations_1=Niladdedphylumdeclarations(); return this; }
    return addedphylumdeclarations_1->append(last);
}
addedphylumdeclarations
kc_tag_addedphylumdeclarations::merge( addedphylumdeclarations second, addedphylumdeclaration (*kc_fp)(addedphylumdeclaration, addedphylumdeclaration))
{
    return dynamic_cast<addedphylumdeclarations>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consaddedphylumdeclarations));
}
addedphylumdeclaration
kc_tag_addedphylumdeclarations::reduce( addedphylumdeclaration neutral, addedphylumdeclaration (*kc_fp)(addedphylumdeclaration, addedphylumdeclaration))
{
    return dynamic_cast<addedphylumdeclaration>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

countedphylumdeclarations
concat(c_countedphylumdeclarations kc_p1, c_countedphylumdeclarations kc_p2)
{ return dynamic_cast<countedphylumdeclarations>(kc_p1->do_concat(kc_p2, sel_Conscountedphylumdeclarations)); }

countedphylumdeclarations
kc_tag_countedphylumdeclarations::reverse() const
{ return dynamic_cast<countedphylumdeclarations>(do_reverse(Nilcountedphylumdeclarations(), sel_Conscountedphylumdeclarations)); }

countedphylumdeclaration
kc_tag_countedphylumdeclarations::last() const
{ return dynamic_cast<countedphylumdeclaration>(kc_tag_abstract_list::last()); }

bool
kc_tag_countedphylumdeclarations::is_nil() const
{
    return countedphylumdeclaration_1==0 && countedphylumdeclarations_1==0;
}

countedphylumdeclarations
kc_tag_countedphylumdeclarations::map(countedphylumdeclaration (*kc_fp)(countedphylumdeclaration))
{ return dynamic_cast<countedphylumdeclarations>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Conscountedphylumdeclarations)); }
countedphylumdeclarations
kc_tag_countedphylumdeclarations::filter(bool (*kc_fp)(countedphylumdeclaration))
{ return dynamic_cast<countedphylumdeclarations>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Conscountedphylumdeclarations)); }

countedphylumdeclarations
kc_tag_countedphylumdeclarations::append(countedphylumdeclaration last)
{
    if(is_nil()) { countedphylumdeclaration_1=last;countedphylumdeclarations_1=Nilcountedphylumdeclarations(); return this; }
    return countedphylumdeclarations_1->append(last);
}
countedphylumdeclarations
kc_tag_countedphylumdeclarations::merge( countedphylumdeclarations second, countedphylumdeclaration (*kc_fp)(countedphylumdeclaration, countedphylumdeclaration))
{
    return dynamic_cast<countedphylumdeclarations>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Conscountedphylumdeclarations));
}
countedphylumdeclaration
kc_tag_countedphylumdeclarations::reduce( countedphylumdeclaration neutral, countedphylumdeclaration (*kc_fp)(countedphylumdeclaration, countedphylumdeclaration))
{
    return dynamic_cast<countedphylumdeclaration>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

bindingidmarks
concat(c_bindingidmarks kc_p1, c_bindingidmarks kc_p2)
{ return dynamic_cast<bindingidmarks>(kc_p1->do_concat(kc_p2, sel_Consbindingidmarks)); }

bindingidmarks
kc_tag_bindingidmarks::reverse() const
{ return dynamic_cast<bindingidmarks>(do_reverse(Nilbindingidmarks(), sel_Consbindingidmarks)); }

bindingidmark
kc_tag_bindingidmarks::last() const
{ return dynamic_cast<bindingidmark>(kc_tag_abstract_list::last()); }

bool
kc_tag_bindingidmarks::is_nil() const
{
    return bindingidmark_1==0 && bindingidmarks_1==0;
}

bindingidmarks
kc_tag_bindingidmarks::map(bindingidmark (*kc_fp)(bindingidmark))
{ return dynamic_cast<bindingidmarks>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consbindingidmarks)); }
bindingidmarks
kc_tag_bindingidmarks::filter(bool (*kc_fp)(bindingidmark))
{ return dynamic_cast<bindingidmarks>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consbindingidmarks)); }

bindingidmarks
kc_tag_bindingidmarks::append(bindingidmark last)
{
    if(is_nil()) { bindingidmark_1=last;bindingidmarks_1=Nilbindingidmarks(); return this; }
    return bindingidmarks_1->append(last);
}
bindingidmarks
kc_tag_bindingidmarks::merge( bindingidmarks second, bindingidmark (*kc_fp)(bindingidmark, bindingidmark))
{
    return dynamic_cast<bindingidmarks>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consbindingidmarks));
}
bindingidmark
kc_tag_bindingidmarks::reduce( bindingidmark neutral, bindingidmark (*kc_fp)(bindingidmark, bindingidmark))
{
    return dynamic_cast<bindingidmark>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

abstract_phylum
kc_tag_abstract_phylum::copy(bool kc_copy_attributes) const
{
    kc_enum_phyla kc_phy = phylum(); // XXX - implement special cases in subclasses - MvL
    KC_OPERATOR_INFO *kc_op_info = &kc_OperatorInfo[prod_sel()];
    kc_storageclass_t kc_st = kc_PhylumInfo[kc_op_info->phylum].uniq_stored;
    kc_hashtable_t kc_a_ht = kc_hashtables[kc_st];
    if (kc_st && kc_storageclass_still_uniq[kc_st])
	return const_cast<abstract_phylum>(this);
    abstract_phylum kc_answer=0;
    if (kc_phy == kc_phylum_casestring) {
	kc_answer=mkcasestring((dynamic_cast<c_casestring>(this))->name);
    } else if (kc_phy == kc_phylum_nocasestring) {
	kc_answer=mknocasestring((dynamic_cast<c_nocasestring>(this))->name);
    } else if (kc_phy == kc_phylum_voidptr) {
	kc_answer=mkvoidptr((dynamic_cast<c_voidptr>(this))->pointer);
    } else if (kc_phy == kc_phylum_integer) {
	kc_answer=mkinteger((dynamic_cast<c_integer>(this))->value);
    } else if (kc_phy == kc_phylum_real) {
	kc_answer=mkreal((dynamic_cast<c_real>(this))->value);
    } else {
	abstract_phylum kc_subtmp[7], child;
	for (int kc_i = 0; (child = subphylum(kc_i)); kc_i++) {
	    kc_subtmp[kc_i] = child->copy(kc_copy_attributes);
	}
	switch(kc_op_info->no_sons) {
	    case 0: kc_answer = kc_create(prod_sel()); break;
	    case 1: kc_answer = kc_create(prod_sel(),  kc_subtmp[0]); break;
	    case 2: kc_answer = kc_create(prod_sel(),  kc_subtmp[0],  kc_subtmp[1]); break;
	    case 3: kc_answer = kc_create(prod_sel(),  kc_subtmp[0],  kc_subtmp[1],  kc_subtmp[2]); break;
	    case 4: kc_answer = kc_create(prod_sel(),  kc_subtmp[0],  kc_subtmp[1],  kc_subtmp[2],  kc_subtmp[3]); break;
	    case 5: kc_answer = kc_create(prod_sel(),  kc_subtmp[0],  kc_subtmp[1],  kc_subtmp[2],  kc_subtmp[3],  kc_subtmp[4]); break;
	    case 6: kc_answer = kc_create(prod_sel(),  kc_subtmp[0],  kc_subtmp[1],  kc_subtmp[2],  kc_subtmp[3],  kc_subtmp[4],  kc_subtmp[5]); break;
	    case 7: kc_answer = kc_create(prod_sel(),  kc_subtmp[0],  kc_subtmp[1],  kc_subtmp[2],  kc_subtmp[3],  kc_subtmp[4],  kc_subtmp[5],  kc_subtmp[6]); break;
	    default: assertionFailed("unexpected number of sub-phyla");
	}
    }
    if (kc_copy_attributes)
	copy_attributes(kc_phy, this, kc_answer);
    return kc_answer;
}


} // namespace kc
