/***************************************************************************
 *   Copyright (C) 2005 by KesieV   *
 *   kesiev@hotmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kitty_articleedit.h"
#include <kdialogbase.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qtextedit.h>
#include <klocale.h>
#include <qpixmap.h>
#include <kmessagebox.h>
#include <kstandarddirs.h>
#include <qdir.h>
#include <qpushbutton.h>
#include <krun.h>
#include <kurllabel.h>
#include <kfiledialog.h>
#include <kiconloader.h>
#include <qvbox.h>
#include <qhbox.h>
#include <kio/job.h>

kitty_articleedit::kitty_articleedit( QWidget *parent, const QString& caption,const t_feed& feed,const int &art)
   : KDialogBase( IconList, caption,
                  Ok|Cancel, Ok)
{
   QDir *mydir=new QDir();
   myarticle=art;
   myfeed=feed;

   setMinimumWidth(600);

   QVBox *page;
   QLabel *sepa;

   page= addVBoxPage(i18n("Article"),i18n("Article details"),DesktopIcon("contents"));

   QLabel *label = new QLabel( i18n("<b>Article title</b>"), page);

   title = new QLineEdit( myfeed.items[myarticle].title, page );

   label = new QLabel( i18n("<b>Author</b>"), page);

   author = new QLineEdit( myfeed.items[myarticle].author, page );


   label = new QLabel( i18n("<b>Description</b>"), page);

   description = new QTextEdit( myfeed.items[myarticle].description,"", page);
   description->setSizePolicy(QSizePolicy::Minimum,QSizePolicy::Expanding);

   /***/

   page = addVBoxPage(i18n("Web links"),i18n("Related web links"),DesktopIcon("konqueror"));

   label = new QLabel( i18n("<b>Web page</b>"), page);
   homepage = new QLineEdit( myfeed.items[myarticle].link, page );

   label = new QLabel( i18n("<b>Thumbnail</b>"), page);
   thumbnail = new QLineEdit( myfeed.items[myarticle].thumbnail, page );
   
   label = new QLabel( i18n("<b>Media</b>"), page);
   file = new QLineEdit( myfeed.items[myarticle].file, page );
   
   sepa=new QLabel(page);
   sepa->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);

   /***/

   page = addVBoxPage(i18n("Embedded media"),i18n("Embedded media"),DesktopIcon("video"));

   label = new QLabel( i18n("<b>Thumbnail</b>"), page);

   thumblabel = new QLabel( "", page);
   thumblabel->setMinimumHeight(150);
   thumblabel->setMinimumWidth(200);
   thumblabel->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
   thumblabel->setSizePolicy(QSizePolicy::Minimum,QSizePolicy::Fixed);
   thumblabel->setBackgroundColor(Qt::darkGray);
   QString imgfile=locateLocal("appdata", myfeed.key+"-data/"+myfeed.items[myarticle].key+".png");
   if (mydir->exists(imgfile)) {
	thumburl=imgfile;
   } else {
	thumburl="";
   }
   oldthumburl=thumburl;
   setThumbnail();
   
   QPushButton *buttonThumbChange=new QPushButton(i18n("Change..."),page);
   connect(buttonThumbChange,SIGNAL(clicked()),this,SLOT(slot_setthumb()));
   QPushButton *buttonThumbDelete=new QPushButton(i18n("Delete"),page);
   connect(buttonThumbDelete,SIGNAL(clicked()),this,SLOT(slot_delthumb()));

   label = new QLabel( i18n("<b>Media</b>"), page);

   videolabel = new KURLLabel(page);
   videolabel->setMinimumHeight(150);
   videolabel->setMinimumWidth(200);
   videolabel->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
   videolabel->setSizePolicy(QSizePolicy::Minimum,QSizePolicy::Fixed);
   videolabel->setBackgroundColor(Qt::darkGray);
   if (myfeed.items[myarticle].dlstatus=="downloaded") {
	videourl=locateLocal("appdata", myfeed.key+"-data/"+myfeed.items[myarticle].key);
   } else {
	videourl="";
   }
   oldvideourl=videourl;
   setVideo();
   connect(videolabel,SIGNAL(leftClickedURL()),this,SLOT(slot_playvideo()));

   QPushButton *buttonVideoChange=new QPushButton(i18n("Change..."),page);
   connect(buttonVideoChange,SIGNAL(clicked()),this,SLOT(slot_setvideo()));
   QPushButton *buttonVideoDelete=new QPushButton(i18n("Delete"),page);
   connect(buttonVideoDelete,SIGNAL(clicked()),this,SLOT(slot_delvideo()));

 
   changed=false;
}

void kitty_articleedit::slotresult (KIO::Job *) {
	commit_step++;
	commit_changes();
}

void kitty_articleedit::commit_changes() {
	switch (commit_step) {
		case 0: { // it there is a video to copy, copies
			commit_step=0;
			if (videourl!=oldvideourl) {
				QString oldfile=locateLocal("appdata", myfeed.key+"-data/"+myfeed.items[myarticle].key);
				if (videourl.isEmpty()) {
					myfeed.items[myarticle].dlstatus="";
					KIO::del(oldfile,false,true);
				} else {
					myfeed.items[myarticle].dlstatus="downloaded";
					KIO::FileCopyJob *copyJob=new KIO::FileCopyJob(videourl,oldfile,-1,false,true,false,true);
					connect(copyJob,SIGNAL(result (KIO::Job *)),this,SLOT(slotresult (KIO::Job *)));
					break;
				}
			}
		}
		case 1: { // it there is a thumb to copy, copies
			commit_step=1;
			if (thumburl!=oldthumburl) {
				QString oldfile=locateLocal("appdata", myfeed.key+"-data/"+myfeed.items[myarticle].key+".png");
				if (thumburl.isEmpty()) {
					KIO::del(oldfile,false,true);
				} else {				
					KIO::FileCopyJob *copyJob=new KIO::FileCopyJob(thumburl,oldfile,-1,false,true,false,true);
					connect(copyJob,SIGNAL(result (KIO::Job *)),this,SLOT(slotresult (KIO::Job *)));
					break;
				}
			}
		}
		case 2: {
			commit_step=2;
			myfeed.items[myarticle].title=title->text();
			myfeed.items[myarticle].author=author->text();
			myfeed.items[myarticle].description=description->text();
			myfeed.items[myarticle].link=homepage->text();
			myfeed.items[myarticle].thumbnail=thumbnail->text();
			myfeed.items[myarticle].file=file->text();
			changed=true;
			accept();
			break;
		}
	}
}

void kitty_articleedit::slotOk() {
	QString warns;
	bool ok=true;
	if (videourl!=oldvideourl) {
		if (videourl.isEmpty()) {
			warns+=i18n("Embedded media removed. It will be removed from the collection.\n");
		} else {
			warns+=i18n("Embedded media has changed. It will be copied into the local collection.\n");
		}
	}
	if (thumburl!=oldthumburl) {
		if (thumburl.isEmpty()) {
			warns+=i18n("Embedded thumbnail removed. It will be removed from the collection.\n");
		} else {
			warns+=i18n("Embedded thumbnail has changed. It will be copied into the local collection.\n");
		}
	}
	if (!warns.isEmpty()) {
		ok=(KMessageBox::warningContinueCancel(this,warns.left(warns.length()-1))==KMessageBox::Continue);
	}
	if (ok) {
		commit_step=0;
		commit_changes();
	} 
}

void kitty_articleedit::slot_playvideo() {
	if (videourl.isEmpty()) {
		KMessageBox::information(this,i18n("Any media embedded in this article."));
	} else {
		new KRun(videourl);
	}
}

void kitty_articleedit::slot_setvideo() {
  QString fopen=KFileDialog::getOpenFileName(QString::null,QString::null,this,i18n("Open media"));
  if (fopen!="")
  {
    videourl=fopen;
    setVideo();
  }
}

void kitty_articleedit::slot_delvideo() {
  if (KMessageBox::warningYesNo(this,i18n("Do you want to delete the embedded media?\n(is like purging article from the GUI)"))==KMessageBox::Yes)
  {
    videourl="";
    setVideo();
  }
}

void kitty_articleedit::slot_setthumb() {
  QString fopen=KFileDialog::getOpenFileName(QString::null,QString::null,this,i18n("Open thumbnail"));
  if (fopen!="")
  {
    thumburl=fopen;
    setThumbnail();
  }
}

void kitty_articleedit::slot_delthumb() {
  if (KMessageBox::warningYesNo(this,i18n("Do you want to delete the embedded thumbnail?\n(it will be automatically downloaded from his web link)"))==KMessageBox::Yes)
  {
    thumburl="";
    setThumbnail();
  }
}

void kitty_articleedit::setThumbnail() {
	if (thumburl.isEmpty()) {
		QPixmap sideimg=QPixmap();		
		thumblabel->setPixmap(sideimg);
		thumblabel->setText(i18n("<b>Not avaible</b>"));
	} else {
		thumblabel->setPixmap(readScaledPixmap(thumburl));
	}
}

void kitty_articleedit::setVideo() {
	if (videourl.isEmpty()) {
		videolabel->setText(i18n("<b>Not avaible</b>"));
	} else {
		videolabel->setText(i18n("<u>Click to play</u>"));
	}
}


kitty_articleedit::~kitty_articleedit()
{
}


#include "kitty_articleedit.moc"
