/* @(#) modcommands.c 1.3 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: COMMANDS
\***************************************************************/

#define _KOALAMUD_COMMANDINFO_C "@(#) nitehawk@winghove.1ststep.net|lib/koalamod/modcommands.c|20001105050816|13706 @(#)"

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
#include "log.h"
#include "network.h"
#include "buffer.h"
#include "commands.h"
#include "uplinkprotocol.h"
#include "memory.h"
#include "llist.h"
#include "module.h"
#include "kparser.h"

koalaerror do_loadmod(pdescriptor desc, argument *arglist[])
{
	char **ap, *argv[10], *line;
	int len = 120;
	koalaerror readerr;
	int argc = 0;

	/* Read the rest of the line from the buffer */
	{
		/* Allocate memory */
		line = kmalloc(len, ALLOC_TEMP);
		if (!line)
		{
			logmsg(LOGCRIT, "Unable to allocate memory for line buffer");
			return KENOMEM;
		}

		/* Read data from the buffer */
		readerr = buffer_readline(desc, line, len);
		if (readerr == KENOTENOUGH)
		{
			kmfree(line, ALLOC_TEMP);
			return KENOTENOUGH;
		}
		if (readerr == KENOMEM)
		{
			buffer_flushline(desc);
		}
		
		/* Separate the input into words */
		for (ap = argv; (*ap = strsep(&line, " \t")) != NULL;)
		{
			if (**ap != '\0')
			{
				if (++ap >= &argv[10])
				{
					break;
				}
				++argc;
			}
		}
	}

	/* Make sure we have an argument */
	if (argc < 2)
	{
		buffer_queue(desc, UNKNOWNCOMMANDRESPONSE,
				strlen(UNKNOWNCOMMANDRESPONSE));
		return KESUCCESS;
	}

	/* Unload the module */
	loadmodule(argv[0], argv[1], MODTYPE_GENERIC, desc);

	/* Free line buffer */
	kmfree(line, ALLOC_TEMP);

	return KESUCCESS;
}

koalaerror do_unloadmod(pdescriptor desc, argument *arglist[])
{
	char **ap, *argv[10], *line;
	int len = 120;
	koalaerror readerr;
	int argc = 0;

	/* Read the rest of the line from the buffer */
	{
		/* Allocate memory */
		line = kmalloc(len, ALLOC_TEMP);
		if (!line)
		{
			logmsg(LOGCRIT, "Unable to allocate memory for line buffer");
			return KENOMEM;
		}

		/* Read data from the buffer */
		readerr = buffer_readline(desc, line, len);
		if (readerr == KENOTENOUGH)
		{
			kmfree(line, ALLOC_TEMP);
			return KENOTENOUGH;
		}
		if (readerr == KENOMEM)
		{
			buffer_flushline(desc);
		}
		
		/* Separate the input into words */
		for (ap = argv; (*ap = strsep(&line, " \t")) != NULL;)
		{
			if (**ap != '\0')
			{
				if (++ap >= &argv[10])
				{
					break;
				}
				++argc;
			}
		}
	}

	/* Make sure we have an argument */
	if (argc == 0)
	{
		buffer_queue(desc, UNKNOWNCOMMANDRESPONSE,
				strlen(UNKNOWNCOMMANDRESPONSE));
		return KESUCCESS;
	}

	/* Unload the module */
	unloadmodule(argv[0], desc);

	/* Free Line Buffer */
	kmfree(line, ALLOC_TEMP);

	return KESUCCESS;
}

/* modlist - Display a list of loaded modules */
koalaerror do_modlist(pdescriptor desc, argument *arglist[])
{
	listnodeptr modlist;
	char buf[256];
	dynmod_t *pmod;

	/* Get a pointer to the loaded module list */
	if ((modlist = getmodlisthead()) == NULL)
	{
		snprintf(buf, 256, "No modules loaded.\r\n");
		buffer_queue(desc, buf, strlen(buf));
		return KESUCCESS;
	}

	/* Display header */
	snprintf(buf, 256,
"Module Name\tFull Name\t\tVersion\r\n"
"-----------\t---------\t\t-------\r\n");
	buffer_queue(desc, buf, strlen(buf));

	/* Cycle through modules and display information */
	while (modlist)
	{
		pmod = (dynmod_t *)modlist->data.generic;
		if (pmod == NULL)
			break;
		snprintf(buf, 256, "%s\t%s\t\t%s\r\n", pmod->modname,
				pmod->module.name, pmod->module.version);
		buffer_queue(desc, buf, strlen(buf));

		modlist = listnextnode(modlist);
	}

	return KESUCCESS;
}
