/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _FILE_LIST_H_
#define _FILE_LIST_H_

#include <qvbox.h>
#include <qpushbutton.h>

#include <kpopupmenu.h>
#include <klistbox.h>

#include "globals.h"
#include "logLevel.h"

#define ADD_FILE_MENU_ID 0
#define REMOVE_MENU_ID 1
#define MOVE_UP_MENU_ID 2
#define MOVE_DOWN_MENU_ID 3
#define REMOVE_ALL_MENU_ID 4

//TODO Maybe draw this class with Qt Designer
class FileList : public QWidget {

	Q_OBJECT
	
	public:
		FileList(QWidget *parent, QString description);
		~FileList();

		virtual void insertItem(QString& item);
		virtual void removeItem(int id);
		void insertItem(QPixmap& pixmap, QString& item);
		
		int count();
	
		QString getText(int i);
		
	signals:
		void fileListChanged(int itemLeft);

	protected slots:
		virtual bool updateButtons();
		
		void removeSelectedItem();
		void moveUpItem();
		void moveDownItem();
		void removeAllItem();
		virtual void addItem();
		
		void displayPopupMenu(QListBoxItem* item, const QPoint& point);

	protected:
		bool isValidFile(KURL url);
		
		QVBox* buttons;
		
		KPopupMenu* fileListMenu;
		
		KListBox* fileList;
	
	private:
	
		QPushButton* add;
		QPushButton* remove;
		QPushButton* up;
		QPushButton* down;
		QPushButton* removeAll;
	

};

#endif //_FILE_LIST_H_
