#ifndef _KVI_IRCURL_H_
#define _KVI_IRCURL_H_

//
//   File : kvi_ircurl.h
//   Creation date : Sun Mar 04 2001 14:22:55 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"
#include "kvi_string.h"


// Create /server -u <server> commands (first free context)
#define KVI_IRCURL_CONTEXT_FIRSTFREE 0
// Create /server -n <server> commands (new irc context)
#define KVI_IRCURL_CONTEXT_NEW 1
// Create /server <server> commands (this irc context)
#define KVI_IRCURL_CONTEXT_THIS 2


extern KVIRC_API bool parseIrcUrl(const char * url,KviStr &cmdBuffer,int contextSpec = KVI_IRCURL_CONTEXT_FIRSTFREE);

#endif // _KVI_IRCURL_H_
