#ifndef _KVI_TOOLBAR_KDE_H_INCLUDED_
#define _KVI_TOOLBAR_KDE_H_INCLUDED_

// =============================================================================
//
//      --- kvi_toolbar_kde.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Robin Verduijn <robin@debian.org>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qintdict.h>

#include <ktoolbar.h>

class KviMainWindow;

class KviToolBar : public KToolBar
{
	Q_OBJECT
public:
	KviToolBar(
		const QString &, KviMainWindow *, QWidget *, Qt::Dock dock = Qt::DockTop, bool nl = false, const char *name = 0
	);
	~KviToolBar();

	int insertButton(
		const QString &icon, int id, const char *signal, const QObject *receiver, const char *slot,
		bool enabled = true, const QString &text = QString::null, const QString &tooltip = QString::null
	);

	void setPreferOwnIcons(bool);

	void setButtonIcon(int, const QString &);
	void setButtonText(int, const QString &, bool tipToo = false);

	void toggleBigIcons(bool);
	void toggleIconText(bool);
private:
	QIntDict<QString> m_buttonIcons;
	bool m_bPreferOwnIcons;
};

#endif // _KVI_TOOLBAR_KDE_H_INCLUDED_
