// =============================================================================
//
//      --- kvi_imageselector.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviImageSelector"

#include <qcheckbox.h>

#include "kvi_imagebutton.h"
#include "kvi_imageselector.h"
#include "kvi_string.h"

/**
 * KviImageSelector
 */
KviImageSelector::KviImageSelector(
	QWidget *parent, const char *label, KviStr *valuePtr, QPixmap *cachedPixmap, bool bEnabled)
	: QWidget(parent)
{
	m_valuePtr   = valuePtr;
	m_pCheckBox  = new QCheckBox(_CHAR_2_QSTRING(label), this);
	m_pCheckBox->setChecked(!valuePtr->isEmpty());
	m_pImgButton = new KviImageButton(this, valuePtr->ptr(), cachedPixmap);
	connect(m_pCheckBox, SIGNAL(toggled(bool)), m_pImgButton, SLOT(setEnabled(bool)));
	m_pImgButton->setEnabled(!valuePtr->isEmpty());
	setMinimumSize(sizeHint());
	setEnabled(bEnabled);
}

KviImageSelector::~KviImageSelector()
{
	// Nothing here
}

void KviImageSelector::commitChanges()
{
	if( m_pCheckBox->isChecked() ) {
		const char *ptr = m_pImgButton->getSelectedImagePath();
		*m_valuePtr = ptr ? ptr : "";
	} else *m_valuePtr = ""; // No image
}

const QPixmap *KviImageSelector::getImage()
{
	if( m_pCheckBox->isChecked() )
		return m_pImgButton->pixmap();
	return 0;
}

QSize KviImageSelector::sizeHint()
{
	QSize sz = m_pCheckBox->sizeHint();
	sz.setHeight(sz.height() + 100);
	return sz;
}

void KviImageSelector::resizeEvent(QResizeEvent *)
{
	int hght = m_pCheckBox->sizeHint().height();
	m_pCheckBox->setGeometry(0, 0, width(), hght);
	m_pImgButton->setGeometry(0, hght + 1, width(), height() - (hght + 1));
}

#include "m_kvi_imageselector.moc"
