/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/select.h>
#include <pthread.h>
#include <signal.h>

#include "kwirelessmonitor.h"
#include "wm_arch.h"

#if 0
/* XXX repeat */
/* XXX assume 802.11b for now */
const int availableBitrateList[] = { 1000000,
                                     2000000,
                                     5500000,
                                     11000000 };

const int numAvailableBitrates = sizeof(availableBitrateList) / sizeof(int);
#endif

QValueList<int> availableBitrateList;
int numAvailableBitrates;

void chop(char *str)
{
    int len = strlen(str);
    if (len < 1) {
        return;
    }
    str[len - 1] = 0;
}

int main()
{
    if (getuid() != 0) {
        exit(-1);
    }

    char buf[256];
    FILE *fifo = fopen(HELPER_FIFO, "r+");
    if (fifo == NULL) {
        exit(-1);
    }
    fprintf(fifo, "ready\n");
    fflush(fifo);

    while (1) {
        int sock;

        if (fgets(buf, 128, fifo) == NULL) {
            continue;
        }
        if (strncmp("OD", buf, 2) == 0) {
            kill(getpid(), 9);
            exit(0);
        }
        chop(buf);
        char interface[16];
        strncpy(interface, buf, 15);
        interface[15] = 0;
        sock = wm_openIFSocket(interface);

        if (fgets(buf, 128, fifo) == NULL) {
            continue;
        }
        chop(buf);
        char item[8];
        strncpy(item, buf, 7);
        item[7] = 0;

        if (fgets(buf, 128, fifo) == NULL) {
            continue;
        }
        chop(buf);
        int number = strtol(buf, NULL, 10);
        char essid[64];
        strncpy(essid, buf, 63);
        essid[63] = 0;

        if (strncmp("PM", item, 2) == 0) {
            wm_setPowerMgmt(sock, interface, number);
        } else if (strncmp("BR", item, 2) == 0) {
            availableBitrateList.clear();
            wm_getBitrateList(sock, interface, availableBitrateList);
            numAvailableBitrates = availableBitrateList.size();
            
            if (number == 0) {
                wm_setBitrate(sock, interface, -1);
            } else {
                number -= 1;
                if ((number < 0) || (number > (numAvailableBitrates - 1))) {
                    number = numAvailableBitrates - 1;
                }
                wm_setBitrate(sock, interface, availableBitrateList[number]);
            }
        } else if (strncmp("NW", item, 2) == 0) {
            // system 'kwirelessmonitor-net interface essid'
            unlink(NET_OUT);
            QString cmd = "kwirelessmonitor-net ";
            cmd += interface;
            cmd += " ";
            cmd += essid;
            cmd += " > ";
            cmd += NET_OUT;
            system(cmd.ascii());
        }
        wm_closeIFSocket(sock);
    }
}
