/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_GAPPLET_H
#define XEPLUGIN_GAPPLET_H

#include <qobject.h>
#include <qstring.h>
#include <qimage.h>

//#include "xeconfiguration.h"
//#include "xgdocker.h"
//#include "xgicon.h"

class XSConfigurations;
class XGDocker	;
class XGIcon		;


/**
@author Stefano
*/
class XEPlugin_GApplet : public QObject
{
Q_OBJECT
public:
    XEPlugin_GApplet(QObject *parent = 0, const char *name = 0);

    ~XEPlugin_GApplet();
protected:
	XSConfigurations *ActiveConfiguration;
	XGDocker	*xGDocker;
	XGIcon		*xGIcon;
	QString		IconsPath;
	QImage		xImgSource;
	QString		PluginName;
	class KPopupMenu	*PluginPopup;

public slots:
    virtual void xSetup();
    virtual void xRefresh();
    virtual void xStart();
    virtual void xStop();
    virtual void xAttach(QObject *);
    virtual void xRefreshIcon(QObject *);
    void xGetParameter(const QString,QString&);
    void xGetParameterList(QStringList*);
    void xSetupParameter(const QString, const QString);
protected:
    virtual void xPaint();
protected:
    QPixmap findBase(const QString, const QString);
};

#endif
