/* Copyright (C) 2000, Luca Padovani <luca.padovani@cs.unibo.it>.
 *
 * This file is part of lablgtkmathview, the Ocaml binding
 * for the GtkMathView widget.
 * 
 * lablgtkmathview is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * lablgtkmathview is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with lablgtkmathview; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * For details, send a mail to the author.
 */

#include <assert.h>
#include <string.h>
#include <assert.h>
#include <gtk/gtk.h>
#include <caml/mlvalues.h>
#include <caml/alloc.h>
#include <caml/memory.h>
#include <caml/callback.h>
#include <caml/fail.h>

#include <gtkmathview.h>
#include <ml_gtk.h>

#include <wrappers.h>
#include <ml_glib.h>
#include <ml_gdk.h>
#include <ml_gtk.h>
#include <gtk_tags.h>

#include <mlgdomevalue.h>

#define GtkMathView_val(val) check_cast(GTK_MATH_VIEW,val)

#define FontManagerId_val(val) Int_val(val)
#define Val_FontManagerId(val) Val_int(val)

// As ML_1, but the result is optional
#define OML_1(cname, conv1, conv) \
value ml_##cname (value arg1) { return Val_option_ptr((cname (conv1 (arg1))),conv); }
// As ML_2, but the second argument is optional
#define ML_2O(cname, conv1, conv2, conv) \
value ml_##cname (value arg1, value arg2) \
{ return conv (cname (conv1(arg1), ptr_val_option(arg2,conv2))); }

FontManagerId
font_manager_id_of_value(value v)
{
  if (v == hash_variant("font_manager_gtk")) return FONT_MANAGER_GTK;
  else if (v == hash_variant("font_manager_t1")) return FONT_MANAGER_T1;
  else assert(0);
}

value
value_of_font_manager_id(FontManagerId id)
{
  switch (id) {
  case FONT_MANAGER_GTK:
    return hash_variant("font_manager_gtk");
  case FONT_MANAGER_T1:
    return hash_variant("font_manager_t1");
  default:
    assert(0);
    break;
  }
}

ML_2 (gtk_math_view_new,GtkAdjustment_val, GtkAdjustment_val, Val_GtkWidget_sink)
ML_2 (gtk_math_view_load, GtkMathView_val, String_val, Val_bool)
ML_2 (gtk_math_view_load_tree, GtkMathView_val, Document_val, Val_bool)
ML_1 (gtk_math_view_unload, GtkMathView_val, Unit)
OML_1 (gtk_math_view_get_selection, GtkMathView_val, Val_Element)
ML_2O (gtk_math_view_set_selection, GtkMathView_val, Element_val, Unit)
ML_1 (gtk_math_view_get_width, GtkMathView_val, Val_int)
ML_1 (gtk_math_view_get_height, GtkMathView_val, Val_int)
ML_3 (gtk_math_view_set_top, GtkMathView_val, Int_val, Int_val, Unit)
ML_3 (gtk_math_view_set_adjustments, GtkMathView_val, GtkAdjustment_val, GtkAdjustment_val, Unit)
ML_1 (gtk_math_view_get_hadjustment, GtkMathView_val, Val_GtkWidget)
ML_1 (gtk_math_view_get_vadjustment, GtkMathView_val, Val_GtkWidget)
ML_1 (gtk_math_view_get_buffer, GtkMathView_val, Val_GdkPixmap)
ML_1 (gtk_math_view_get_frame, GtkMathView_val, Val_GtkWidget)
ML_2 (gtk_math_view_set_font_size, GtkMathView_val, Int_val, Unit)
ML_1 (gtk_math_view_get_font_size, GtkMathView_val, Val_int)
ML_2 (gtk_math_view_set_anti_aliasing, GtkMathView_val, Bool_val, Unit)
ML_1 (gtk_math_view_get_anti_aliasing, GtkMathView_val, Val_bool)
ML_2 (gtk_math_view_set_kerning, GtkMathView_val, Bool_val, Unit)
ML_1 (gtk_math_view_get_kerning, GtkMathView_val, Val_bool)
ML_2 (gtk_math_view_set_transparency, GtkMathView_val, Bool_val, Unit)
ML_1 (gtk_math_view_get_transparency, GtkMathView_val, Val_bool)
ML_2 (gtk_math_view_set_log_verbosity, GtkMathView_val, Int_val, Unit)
ML_1 (gtk_math_view_get_log_verbosity, GtkMathView_val, Val_int)
ML_2 (gtk_math_view_set_font_manager_type, GtkMathView_val, font_manager_id_of_value, Unit)
ML_1 (gtk_math_view_get_font_manager_type, GtkMathView_val, value_of_font_manager_id)
OML_1 (gtk_math_view_get_element, GtkMathView_val, Val_Element)
OML_1 (gtk_math_view_get_action, GtkMathView_val, Val_Element)
ML_1 (gtk_math_view_action_get_selected, GtkMathView_val, Val_int)
ML_2 (gtk_math_view_action_set_selected, GtkMathView_val, Int_val, Unit)
ML_1 (gtk_math_view_action_toggle, GtkMathView_val, Unit)

value
ml_gtk_math_view_export_to_postscript_native(value arg1,
		value w, value h, value x0, value y0, value disable_colors, value arg2)
{
   CAMLparam5(arg1,w,h,x0,y0);
   CAMLxparam2(disable_colors, arg2);

   char *filename;
   FILE *fd;
   int res;
   filename = String_val (arg2);
   if ((fd = fopen(filename, "w"))) {
      gtk_math_view_export_to_postscript(GtkMathView_val (arg1),
		      Int_val(w), Int_val(h), Int_val(x0), Int_val(y0), Bool_val(disable_colors), fd);
      fclose (fd);
      res = 1;
   } else {
      fprintf(stderr, "Error opening file %s for writing\n", filename);
      res = 0;
   }
   CAMLreturn (Val_bool(res));
}

value ml_gtk_math_view_export_to_postscript_bytecode (value* arg, int argn)
{
   return ml_gtk_math_view_export_to_postscript_native(arg[0], arg[1], arg[2], arg[3], arg[4], arg[5], arg[6]);
}

value ml_gtk_math_view_get_top (value arg1)
{
   CAMLparam1(arg1);
   CAMLlocal1 (result);
   int x, y;
   gtk_math_view_get_top(GtkMathView_val (arg1), &x, &y);
   result = alloc(2, 0);
   Store_field(result, 0, Val_int(x));
   Store_field(result, 0, Val_int(y));
   CAMLreturn (result);
}

value ml_gtk_math_view_gdome_element_of_boxed_option (value arg1)
{
   CAMLparam1(arg1);

   GdomeElement* nr;
   CAMLlocal1 (res);

   if (arg1==Val_int(0)) {
      assert(0);
   } else {
      nr = (GdomeElement*) Field(Field(arg1,0), 1);
   }
   res = Val_Element(nr);
   if (res==Val_int(0)) {
      assert(0);
   }

   CAMLreturn(res);
}

value ml_gtk_math_view_gdome_element_option_of_boxed_option (value arg1)
{
   CAMLparam1(arg1);

   GdomeElement* nr;
   CAMLlocal1 (valnr);
   CAMLlocal1 (res);

   if (arg1==Val_int(0)) {
      res=Val_unit;
   } else {
      res = Val_option_ptr((GdomeElement*) Field(Field(arg1,0),1),Val_Element);
   }

   CAMLreturn(res);
}
