//LabPlot : DataDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <iostream>

#ifdef HAVE_SOLARIS
#include <ieeefp.h>
#endif

#include <qlabel.h>
#include <qhbox.h>
#include <qcolordialog.h>
#include <qtextstream.h>
#include <qstatusbar.h>
#include <qfiledialog.h>
#include <qtable.h>
#include <qprogressdialog.h>
#include <qinputdialog.h>
#include <klocale.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <kfilterdev.h>
#include <kfilterbase.h>
#include <kimageio.h>
#include "DataDialog.h"
#include "Plot2DSurface.h"
#include "PlotQWT3D.h"
#include "LTableItem.h"
#include "FilterMAGICK.h"
#include "formatlist.h"
#include "inputitems.h"
#include "import.h"
#include "inputfilter.h"
#include "defs.h"

using namespace std;

#define INC_VALUE 1000	// value for incrementing ptr

/* Dialog for reading 2D and 3D data*/
DataDialog::DataDialog(MainWin *mw, const char *name, ListDialog *l,int item, PType newtype)
	: Dialog(mw, name), l(l), item(item)
{
	kdDebug()<<"DataDialog()"<<endl;
	
	GraphList *graphlist=0;
	KConfig *config = mw->Config();
	config->setGroup( "Import" );

	QString dat = config->readEntry("Filename","1.dat");

	kdDebug()<<"DataDialog "<<endl;
	kdDebug()<<"new type = "<<newtype<<endl;
	
	// set type
	Plot *plot=0;
	 if(p!=0)
		plot = p->getPlot(p->API());
	if (plot != 0)
		type = plot->Type();
	else
		type = newtype;

	kdDebug()<<"type = "<<type<<endl;

	QString caption;
	switch (type) {
	case P3D: caption = i18n("3D Data Dialog"); break;
	case PSURFACE: caption = i18n("2D Surface Data Dialog"); break;
	case P2D: caption = i18n("2D Data Dialog"); break;
	case PPIE: caption = i18n("Pie Data Dialog"); break;
	case PPOLAR:caption = i18n("Polar Data Dialog"); break;
	case PTERNARY: caption = i18n("Ternary Data Dialog"); break;
	case PQWT3D: caption = i18n("QWT Data Dialog"); break;
	default: break;
	}
	caption += i18n(" : ")+QString(name);
	setCaption(caption);

	Style *style=0;
	Symbol *symbol=0;

	if (item == -1) {	// new graph
		graph = 0;
	}
	else {			// change graph
		graphlist = p->getPlot(p->API())->getGraphList();
		graph = graphlist->getGraph(item);
		style = graph->getStyle();
		symbol = graph->getSymbol();
	}

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	if (graph != 0) dat = graph->Name();
	importWidget(tab1,dat,(InputFilter)config->readNumEntry("Filter",(int)FUSER));
	
	config->setGroup( "Data" );
	QString entry = QString("PlotType %1 ").arg(type);
	QHBox *hb = new QHBox(tab1);
	if (graph !=0) {
		reread = new QCheckBox(i18n("Reread Datafile"),hb);
		reread->setChecked(config->readBoolEntry(entry+"Reread",false));
	}
	else
		reread=0;

	KPushButton *checkpb = new KPushButton(i18n("Check data"),hb);
	checkpb->setMaximumWidth(150);
	QObject::connect(checkpb,SIGNAL(clicked()),SLOT(checkData()));
	KPushButton *setLabelpb = new KPushButton(i18n("Update Label"),hb);
	QObject::connect(setLabelpb,SIGNAL(clicked()),SLOT(updateLabel()));

	hb = new QHBox(tab1);
	QLabel *tmp = new QLabel(i18n("Read as : "),hb);
 	tmp->setMaximumWidth(100);
	cbi = new KComboBox(hb);
	int i=0;
	switch(type) {
	case P2D:		while(inputitems2d[i] != 0) cbi->insertItem(i18n(inputitems2d[i++])); break;
	case PSURFACE:	while(inputitemssurface[i] != 0) cbi->insertItem(i18n(inputitemssurface[i++])); break;   
	case P3D:		while(inputitems3d[i] != 0) cbi->insertItem(i18n(inputitems3d[i++])); break;
	case PPOLAR:		while(inputitemspolar[i] != 0) cbi->insertItem(i18n(inputitemspolar[i++])); break;
	case PPIE:		while(inputitemspie[i] != 0) cbi->insertItem(i18n(inputitemspie[i++])); break;
	case PTERNARY:	while(inputitemsternary[i] != 0) cbi->insertItem(i18n(inputitemsternary[i++])); break;
	case PQWT3D:	while(inputitemsqwt[i] != 0) cbi->insertItem(i18n(inputitemsqwt[i++])); break;
	default: 	break;
	}
	if(graph != 0)
		cbi->setCurrentItem(graph->ReadAs());
	else
		cbi->setCurrentItem(config->readNumEntry(entry+"ReadAs",0));

	QObject::connect(cbi,SIGNAL(activated(int)),SLOT(updateRead()));

	hb = new QHBox(tab1);
	new QLabel(i18n("Read from column (index = 0) :"),hb);
	new QLabel(i18n("[cdf/netcdf : variable name]"),hb);
	// "audio : 1 = time, 2 = channel 1, 3 = channel 2]"
	hb = new QHBox(tab1);
	readx = new QLabel(hb);
	readxle = new KLineEdit("1",hb);
	ready = new QLabel(hb);
	readyle = new KLineEdit("2",hb);
	readz = new QLabel(hb);
	readzle = new KLineEdit("3",hb);
	readt = new QLabel(hb);
	readtle = new KLineEdit("4",hb);
	
	hb = new QHBox(tab1);
	i=0;
	interpretxcb = new KComboBox(hb);
	while(formatList[i] != 0) interpretxcb->insertItem(i18n(formatList[i++]));
	interpretxcb->setCurrentItem(config->readNumEntry("XFormat",0));
	i=0;
	interpretycb = new KComboBox(hb);
	while(formatList[i] != 0) interpretycb->insertItem(i18n(formatList[i++]));
	interpretycb->setCurrentItem(config->readNumEntry("YFormat",0));
	i=0;
	interpretzcb = new KComboBox(hb);
	while(formatList[i] != 0) interpretzcb->insertItem(i18n(formatList[i++]));
	interpretzcb->setCurrentItem(config->readNumEntry("ZFormat",0));
	i=0;
	interprettcb = new KComboBox(hb);
	while(formatList[i] != 0) interprettcb->insertItem(i18n(formatList[i++]));
	interprettcb->setCurrentItem(config->readNumEntry("TFormat",0));

	updateRead();

	QVBox *tab2 = new QVBox(tw);
	Label* label = new Label(dat);
	if (graph != 0)
		label = graph->getLabel();
	else 
		label->readSettings(config,entry);
	rtw = new RichTextWidget((QWidget *)tab2,label,0);
	
	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(tab2,i18n("Label"));

	// 3d style -> NoCurve
	if(type == P3D) {
		// TODO : style, symbol not defined
		//style->setType(1);
		//symbol->setType(SCROSS);
	}
	
	QVBox *styletab, *annotatetab;
	if(type == PQWT3D) {
		// TODO
	}
	if(type == PSURFACE) {
		styletab=surfaceStyle(tw,item==-1?true:false);
		tw->addTab(styletab,i18n("Style"));
	}
	else {
		styletab=simpleStyle(tw, style, symbol);
		annotatetab = annotateValuesTab(tw,graph);
		tw->addTab(styletab,i18n("Style"));
		tw->addTab(annotatetab,i18n("Annotate Values"));
	}

	// result selection
	hb = new QHBox(vbox);
	new QLabel(i18n("add result to "),hb);
	sheetcb = new KComboBox(hb);
	QStringList wlist;
	QWidgetList list = mw->getWorkspace()->windowList();
	for(unsigned int i=0;i<list.count();i++)
		wlist << list.at(i)->caption();
	wlist<<i18n("new Worksheet")<<i18n("new Spreadsheet");
	sheetcb->insertStringList(wlist);
	sheetcb->setCurrentItem(mw->activeSheetIndex());	
	
	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	QObject::connect(save,SIGNAL(clicked()),SLOT(saveSettings()));
	QObject::connect(cancel,SIGNAL(clicked()),SLOT(accept()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void DataDialog::saveSettings() {
	KConfig *config = mw->Config();

	QString entry = QString("PlotType %1 ").arg(type);
	
	saveImportSettings();
	config->setGroup( "Data" );
	config->writeEntry(entry+"Reread",reread->isChecked());
	config->writeEntry(entry+"ReadAs",cbi->currentItem());
	config->writeEntry(entry+"XColumn",readxle->text().toInt());
	config->writeEntry(entry+"YColumn",readyle->text().toInt());
	config->writeEntry(entry+"ZColumn",readzle->text().toInt());
	config->writeEntry(entry+"TColumn",readtle->text().toInt());
	config->writeEntry(entry+"XFormat",interpretxcb->currentItem());
	config->writeEntry(entry+"YFormat",interpretycb->currentItem());
	config->writeEntry(entry+"ZFormat",interpretzcb->currentItem());
	config->writeEntry(entry+"TFormat",interprettcb->currentItem());

	rtw->getLabel()->saveSettings(config,entry);

	if(type != PQWT3D && type != PSURFACE) {
		config->writeEntry(entry+"Annotate Type",typecb->currentItem());
		config->writeEntry(entry+"Annotate Position",positioncb->currentItem());
		config->writeEntry(entry+"Annotate Distance",distance->value());
	}
}

//! update readline and label when changing "read as"
void DataDialog::updateRead() {
	kdDebug()<<"DataDialog::updateRead()"<<endl;
	// TODO : QWT plot 3D
	int item=cbi->currentItem();
		
	if (type == P2D && item == I2DXY || type == PPIE || type == PPOLAR) {
		kdDebug()<<"	2d"<<endl;
		readx->show();readxle->show();interpretxcb->show();
		ready->show();readyle->show();interpretycb->show();
		readz->hide();readzle->hide();interpretzcb->hide();
		readt->hide();readtle->hide();interprettcb->hide();
		if (type == P2D) {
			readx->setText(i18n(" x : "));
			ready->setText(i18n(" y : "));
		}
		else if (type == PPIE) {
			readx->setText(i18n(" index : "));
			ready->setText(i18n(" value : "));
		}
		else if (type == PPOLAR) {
			readx->setText(i18n(" phi : "));
			ready->setText(i18n(" r : "));
		}
	}
	else if ( (type == P2D && item == I2DXYDY) || (type == P3D && item == I3DXYZ) || 
		(type == PSURFACE && item == ISXYZ) || type == PTERNARY || (type == PQWT3D && item == IQWTXYZ)) {
		kdDebug()<<"	3d"<<endl;
		readx->show();readxle->show();interpretxcb->show();
		ready->show();readyle->show();interpretycb->show();
		readz->show();readzle->show();interpretzcb->show();
		readt->hide();readtle->hide();interprettcb->hide();
		if (type == P2D) {
			readx->setText(i18n(" x : "));
			ready->setText(i18n(" y : "));
			readz->setText(i18n(" dy : "));
		}
		else if (type == P3D || type == PQWT3D) {
			readx->setText(i18n(" x : "));
			ready->setText(i18n(" y : "));
			readz->setText(i18n(" z : "));
		}
		else if (type == PTERNARY) {
			readx->setText(i18n(" a : "));
			ready->setText(i18n(" b : "));
			readz->setText(i18n(" c : "));
		}
	}
	else if (type == P2D && item == I2DLINE) {
		kdDebug()<<"	line"<<endl;
		readx->show();readxle->show();
		readxle->setText("index");
		readxle->setReadOnly(true);
		interpretxcb->hide();
		ready->show();readyle->show();interpretycb->show();
		readyle->setText("1");
		readyle->setReadOnly(true);
		readz->hide();readzle->hide();interpretzcb->hide();
		readt->hide();readtle->hide();interprettcb->hide();
	}
	else if (type == P2D && (item == I2DXYDXDY || item == I2DXYDYDY)) {
		kdDebug()<<"	4d"<<endl;
		readx->show();readxle->show();interpretxcb->show();
		ready->show();readyle->show();interpretycb->show();
		readz->show();readzle->show();interpretzcb->show();
		readt->show();readtle->show();interprettcb->show();
		if (item == I2DXYDXDY) {
			readx->setText(i18n(" x : "));
			ready->setText(i18n(" y : "));
			readz->setText(i18n(" dx : "));
			readt->setText(i18n(" dy : "));
		}
		else if (item == I2DXYDYDY) {
			readx->setText(i18n(" x : "));
			ready->setText(i18n(" y : "));
			readz->setText(i18n(" dy1 : "));
			readt->setText(i18n(" dy2 : "));
		}
	}
	else if (type == P2D && (item == I2DXYPX | item == I2DXYPY)) {
		kdDebug()<<"	%"<<endl;
		readx->show();readxle->show();interpretxcb->show();
		ready->show();readyle->show();interpretycb->show();
		readz->show();readzle->show();
		readx->setText(i18n(" x : "));
		ready->setText(i18n(" y : "));
		if (item == I2DXYPX)
			readz->setText(i18n(" % of x : "));
		else
			readz->setText(i18n(" % of y : "));
	}
	else {				// matrix
		kdDebug()<<"	matrix"<<endl;
		readx->hide();readxle->hide();interpretxcb->hide();
		ready->hide();readyle->hide();interpretycb->hide();
		readz->hide();readzle->hide();interpretzcb->hide();
		readt->hide();readtle->hide();interprettcb->hide();
	}
	kdDebug()<<"	updateRead() OK"<<endl;
}

void DataDialog::checkData() {
	kdDebug()<<"DataDialog:checkData()"<<endl;
	QStringList lines;
      	unsigned int count=0;
	bool imagefile=false;

	QStringList fns = QStringList::split(";",filele->text());
	 for ( QStringList::Iterator it = fns.begin(); it != fns.end(); ++it ) {
		QString filename = *it;
		QFileInfo info(filename);
	
		KDialog *dialog = new KDialog(this);
		if (!filename.isEmpty()) {
			FilterNETCDF ncf = FilterNETCDF(filename);
			FilterAUDIOFILE auf = FilterAUDIOFILE(filename);
			FilterCDF cdf = FilterCDF(filename);
			FilterMAGICK mf = FilterMAGICK(filename);
					
			QString format;
			// not with binary data
	#ifdef HAVE_MAGICK
			if ((filtercb->currentItem() != FBINARY) && 
				(((format = QString(QImageIO::imageFormat(filename))) != 0 ) || mf.fileOK())) {
	#else
			if ((filtercb->currentItem() != FBINARY) && (format = QString(QImageIO::imageFormat(filename))) != 0) {
	#endif
				// TODO : support gzipped, bzipped images
				kdDebug()<< "IMAGE FOUND !"<<endl;
				imagefile=true;
				QPixmap pm;
	#ifdef HAVE_MAGICK
				if(mf.fileOK())
					pm = mf.Pixmap();
				else
	#endif
					pm.load(filename);
	
				QImage image = pm.convertToImage();
				int width = image.width();
				int height = image.height();
				QIconSet::setIconSize(QIconSet::Small,QSize(width,height));
				QPushButton *pb = new QPushButton(pm,"",dialog);
				dialog->resize(width,height);
				pb->resize(width,height);
				dialog->show();
			}
			else if (ncf.fileOK()) {		// netcdf file
				// get variables from lineedits
				QString xname = readxle->text(), yname = readyle->text(),zname,tname;
	#if QT_VERSION > 0x030007
				if(readz->isShown())
	#else
				if(readz->isVisible())
	#endif
					zname = readzle->text();
	#if QT_VERSION > 0x030007
				if(readt->isShown())
	#else
				if(readt->isVisible())
	#endif
					tname = readtle->text();
	
				int len = ncf.VarLen(xname);
				if(len==0)
					len = ncf.VarLen(yname);
				QProgressDialog progress( i18n("Reading data ..."), i18n("Cancel"), len, this, "progress", true );
				for (int i=0;i<len;i++) {
					if(i%1000 == 0) progress.setProgress(i);
					qApp->processEvents();
					
					QString line;
					if ( readxle->text() == "0" )
						line += QString::number(i);
					else
						line += QString::number(ncf.Data(xname,i));
					if ( readyle->text() == "0" )
						line += ' '+QString::number(i);
					else
						line += ' '+QString::number(ncf.Data(yname,i));
					count=2;
	#if QT_VERSION > 0x030007
					if(readz->isShown()) {
	#else
					if(readz->isVisible()) {
	#endif
						if ( readzle->text() == "0" )
							line += ' '+QString::number(i);
						else
						line += ' '+QString::number(ncf.Data(zname,i));
						count=3;
					}
	#if QT_VERSION > 0x030007
					if(readt->isShown()) {
	#else
					if(readt->isVisible()) {
	#endif
						if ( readtle->text() == "0" )
							line += ' '+QString::number(i);
						else
							line += ' '+QString::number(ncf.Data(tname,i));
						count=4;
					}
	
					lines += line;
				}
			}
	#ifdef HAVE_CDF
			else if (cdf.fileOK()) {		// cdf file
				// get variables from lineedits
				QString xname = readxle->text(), yname = readyle->text(),zname,tname;
				if(readz->isShown())
					zname = readzle->text();
				if(readt->isShown())
					tname = readtle->text();
				
				int len = cdf.VarLen(xname);
				if (len == 0)
					len = cdf.VarLen(yname);
				kdDebug()<<" reading "<<xname<<" vs "<<yname<<endl;
				kdDebug()<<" Length = "<<len<<endl;
				QProgressDialog progress( i18n("Reading data ..."), i18n("Cancel"), len, this, "progress", true );
				for (int i=0;i<len;i++) {
					if(i%1000 == 0) progress.setProgress(i);
					qApp->processEvents();
					
					QString line;
					if ( readxle->text() == "0" )
						line += QString::number(i);
					else
						line += QString::number(cdf.Data(xname,i));
					if ( readyle->text() == "0" )
						line += ' '+QString::number(i);
					else
						line += ' '+QString::number(cdf.Data(yname,i));
					count=2;
					if(readz->isShown()) {
						if ( readzle->text() == "0" )
							line += ' '+QString::number(i);
						else
							line += ' '+QString::number(cdf.Data(zname,i));
						count=3;
					}
					if(readt->isShown()) {
						if ( readtle->text() == "0" )
							line += ' '+QString::number(i);
						else
							line += ' '+QString::number(cdf.Data(tname,i));
						count=4;
					}
	
					lines += line;
				}
			}
	#endif
			else if (auf.fileOK()) {		// audiofile file
				double *data = auf.Data();
				QProgressDialog progress( i18n("Reading data ..."), i18n("Cancel"), auf.frameCount(), this, 
					"progress", true );
				
				for (int i=0;i<auf.frameCount();i++) {
					if(i%1000 == 0) progress.setProgress(i);
					qApp->processEvents();
					
					double x=i/auf.sampleRate(), y=0, z=0;
					switch(auf.channelCount()) {
					case 1:
						y=data[i]; break;
					case 2:
						y=data[2*i];
						z = data[2*i+1];
					}
					
					if ( readxle->text() == "0" )
						x=i;
					if ( readyle->text() == "0" )
						y=i;
					if ( readzle->text() == "0" )
						z=i;
					
					QString line;
					
					line += QString::number(x)+' '+QString::number(y);
					count=2;
					
					if(auf.channelCount()==2) {
						line += ' '+QString::number(z);
						count=3;
					}
					lines += line;
				}
				kdDebug()<<"AU OK"<<endl;
			}
			else {		// normal or compressed ascii data
				QIODevice *file = KFilterDev::deviceForFile(filename,QString::null,true);
				if(file==0) file = new QFile(filename);
				
				if ( file->open( IO_ReadOnly )) {
					QDataStream dstream(file);
					QTextStream tstream(file);

					QProgressDialog progress( i18n("Reading data ..."), i18n("Cancel"), file->size(), this, 
						"progress", true );
					
					if(filtercb->currentItem() == FBINARY) {
						while( !dstream.eof() ) {
							if(file->at()%1000 == 0) progress.setProgress(file->at() );
							qApp->processEvents();
							
							QStringList oneline;
							int nvars = varle->text().toInt();
							
							for (int i=0;i<nvars;i++) {
								oneline += QString::number(getBinaryValue(&dstream,binarytypecb->currentItem()));
							}
							lines += oneline.join(" ");
						}
					}
					else {
						QString line;
						while ( !tstream.eof() ) {
							if(file->at()%1000 == 0) progress.setProgress(file->at() );
							qApp->processEvents();
							
							line = tstream.readLine();
							if(simplifycb->isChecked())
								line = line.simplifyWhiteSpace();
	
							// ignore comment lines
							if(line.startsWith(commcb->currentText()) == true)
								continue;
	
							QString sep = sccb->currentText();
							QStringList oneline = splitLine(line,sep,emptycb->isChecked());
							
							if (count<oneline.count())
								count=oneline.count();
							lines += line;
							if ( progress.wasCancelled())
								return;
						}
					}
				file->close();
				}
				else {
					KMessageBox::error(this, i18n("Sorry. Could not open file for reading!"));
					return;
				}
			}	
		}
	
		// no image -> fill table with values
		if(!imagefile) {
			int j=0;
			QTable *table;
			/*if(type == P2D && cbi->currentItem()==4)
			 	table =  new QTable(count,2, dialog);
			else*/
			 	table = new QTable(lines.count(),count, dialog);

			// generic label
			table->horizontalHeader()->setLabel( 0, QString( "X" ) );
			table->horizontalHeader()->setLabel( 1, QString( "Y" ) );
			table->horizontalHeader()->setLabel( 2, QString( "Z" ) );
	
			for ( QStringList::Iterator it = lines.begin(); it != lines.end(); ++it ) {
				QString sep = sccb->currentText();
				QStringList oneline = splitLine(*it,sep,emptycb->isChecked());
				
				int k=0;
				for ( QStringList::Iterator it2 = oneline.begin(); it2 != oneline.end(); ++it2 ) {
					LTableItem *item = new LTableItem( table, QTableItem::OnTyping,*it2);
					
					if (type == P2D && cbi->currentItem() == 4) {
						// OLD : table->setText(j,k,*it2);
						table->setItem(j, k, item);
						k++;
					}
					else
						// OLD : table->setText(j,k++,*it2);
						table->setItem(j, k++, item);
				}
				j++;
			}
			table->setLeftMargin(50);
			dialog->show();
		}
	}
}

void DataDialog::applyStyle() {
	kdDebug()<<"DataDialog:applyStyle()"<<endl;
	if(p == 0) return;
	
	if(type == PSURFACE) {
		Plot2DSurface *plot = (Plot2DSurface *)p->getPlot(p->API());

		if (plot) {
			plot->enableDensity(dcb->isChecked());
			plot->enableContour(ccb->isChecked());
			plot->setNumber(numberle->text().toInt());
			// plot->setPalette(pcb->currentItem());
			plot->setContourColor(contourcolor->color());
			plot->setColoredContour(coloredcb->isChecked());
			plot->setMesh(meshcb->isChecked());
			plot->setRelative(relativecb->isChecked());
			plot->setBrush(dbrushcb->currentItem());
			plot->setThreshold(thresholdle->text().toDouble());
		}
	}
	else {
		Style *style = new Style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),width->value(),
			pencb->currentItem(),brushcb->currentItem());
		style->setBoxWidth(boxwidth->value());
		style->setAutoBoxWidth(autobox->isChecked());
		style->setPointsSorting(sortpointscb->isChecked());
		Symbol *symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->value(),
			(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
		AnnotateValues av(typecb->currentItem(),positioncb->currentItem(),distance->value());

		if (graph != 0) {
			graph->setStyle(style);
			graph->setSymbol(symbol);
			graph->setAnnotateValues(av);
			graph->setReadAs(cbi->currentItem());
		}
	}

	Label *label = rtw->label();
	if (graph)
		graph->setLabel(label);

	if(p) p->updatePixmap();
	kdDebug()<<"DataDialog:applyStyle() OK"<<endl;
}

// equal to FunctionDialog::findPlot()
void DataDialog::findPlot() {
	kdDebug()<<"DataDialog::findPlot()"<<endl;
	int item = sheetcb->currentItem(), count = sheetcb->count();
	kdDebug()<<"	sheetcb->currentItem() = "<<item<<" of "<<count<<endl;

	if(item>=count-2)		// new sheet selected
		return;
	
	QWidgetList list = mw->getWorkspace()->windowList();
	p = (Worksheet *) list.at(item);
	if(p==0 || p->getWidgetType() != WWORKSHEET) {
		p = mw->activeWorksheet();
		return;
	}

	Plot *plot=0;
	if(p)
		plot = p->getPlot(p->API());

	if(plot && plot->Type() == PQWT3D || type == PQWT3D) {	// new worksheet if plot is qwt3d or type = qwt3d
		p = mw->newWorksheet();
		p->newPlot(type);
		plot = p->getPlot(p->API());
		sheetcb->setCurrentItem(count-2);		// set item to new worksheet
	}
	else if(item < count-2 && plot && plot->Type() != type)		// new plot if choosen of other type.
		p->newPlot(type);					// not if already new sheet selected
}

int DataDialog::apply_clicked() {
	kdDebug()<<"DataDialog:apply_clicked()"<<endl;

	findPlot();
	
	if (reread == 0 || reread->isChecked()) {
		if (int status = addData())
			return status;
	}
	
	applyStyle();

	return 0;
}

// called from addData if image x-y is selected
int DataDialog::addDataIMAGEXY(QImage image, QString filename) {
	int iwidth = image.width();
	int iheight = image.height();
	Point *ptr = new Point[iwidth*iheight];
	
	double ymin=0, ymax=1;
	for (int i=0;i<iwidth;i++) {
		for (int j=0;j<iheight;j++) {
			double x = j+i*iheight;
			double y = (double) qGray(image.pixel(i,j));

			if (i == 0 && j == 0) {
				ymin=ymax=y;
			}
			else {
				y<ymin?ymin=y:0;
				y>ymax?ymax=y:0;
			}
			ptr[j+i*iheight].setPoint(x,y);
			ptr[j+i*iheight].setMasked(false);
		}
	}
	LRange range[2];
	range[0] = LRange(0,iwidth*iheight);
	range[1] = LRange(ymin,ymax);

	Style *style = new Style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
		width->value(),pencb->currentItem(),brushcb->currentItem());
	style->setBoxWidth(boxwidth->value());
	style->setAutoBoxWidth(autobox->isChecked());
	style->setPointsSorting(sortpointscb->isChecked());
	Symbol *symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->value(),
		(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
	Graph2D *g = new Graph2D(filename.latin1(),rtw->getLabel()->Title(),range,SDATA,type,style,symbol,ptr,iwidth*iheight);
	g->setLabel(rtw->getLabel());

	AnnotateValues av(typecb->currentItem(),positioncb->currentItem(),distance->value());
	g->setAnnotateValues(av);	
	g->setReadAs(cbi->currentItem());

	mw->addGraph2D(g,sheetcb->currentItem());

	return 0;
}

// called from addData if image x-y-z is selected
int DataDialog::addDataIMAGEXYZ(QImage image, QString filename) {
	kdDebug()<<"addDataIMAGEXYZ()"<<endl;
	int iwidth = image.width();
	int iheight = image.height();
	int number = INC_VALUE;
	Point3D *ptr = (Point3D *) malloc(number*sizeof(Point3D));
	double xmin=0, xmax=1, ymin=0, ymax=1, zmin=0, zmax=1;
	for (int i=0;i<iwidth;i++) {
		for (int j=0;j<iheight;j++) {
			double x = i, y = j, z = (double) qGray(image.pixel(i,j));

			if (i == 0 && j == 0) {
				zmin=zmax=z;
			}
			else {
				z<zmin?zmin=z:0;
				z>zmax?zmax=z:0;
			}
			
			if(j+i*iheight>=number) {
				number += INC_VALUE;
				ptr = (Point3D *) realloc(ptr,number*sizeof(Point3D));
			}
			ptr[j+i*iheight].setPoint(x,y,z);
			ptr[j+i*iheight].setMasked(false);
		}
	}

	LRange range[3];
	range[0] = LRange(xmin,xmax);
	range[1] = LRange(ymin,ymax);
	range[2] = LRange(zmin,zmax);

	Style *style = new Style(cb2->currentItem(),color->color(),filled->isChecked(),
		fcolor->color(),width->value(),pencb->currentItem(),brushcb->currentItem());
	style->setBoxWidth(boxwidth->value());
	style->setAutoBoxWidth(autobox->isChecked());
	style->setPointsSorting(sortpointscb->isChecked());
	Symbol *symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->value(),
		(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());

	Graph3D *g = new Graph3D(filename.latin1(),rtw->getLabel()->Title(),range,SDATA,type,style,symbol,ptr,iwidth*iheight,1);
	g->setLabel(rtw->getLabel());
	AnnotateValues av(typecb->currentItem(),positioncb->currentItem(),distance->value());
	g->setAnnotateValues(av);
	g->setReadAs(cbi->currentItem());
	mw->addGraph3D(g,sheetcb->currentItem());

	return 0;
}

// called from addData if image matrix is selected
int DataDialog::addDataIMAGEMATRIX(QImage image, QString filename) {
	kdDebug()<<"addDataIMAGEMATRIX()"<<endl;
	int iwidth = image.width();
	int iheight = image.height();
//	kdDebug()<<"IMAGE WIDTH/HEIGHT : "<<iwidth<<' '<<iheight<<endl;
	double *ptr = new double[iwidth*iheight];
	double zmin=0,zmax=1;
	for (int i=0;i<iheight;i++) {
		for (int j=0;j<iwidth;j++) {
			double z = (double) qGray(image.pixel(j,i));

			if (i == 0 && j == 0) {
				zmin=zmax=z;
			}
			else {
				z<zmin?zmin=z:0;
				z>zmax?zmax=z:0;
			}
			ptr[j+i*iwidth] = z;
		}
	}

	LRange range[3];
	range[0] = LRange(0,iwidth);
	range[1] = LRange(0,iheight);
	range[2] = LRange(zmin,zmax);

	GraphM *g;

	if (type == PSURFACE) {
		Style *style = new Style(0);
		Symbol *symbol = new Symbol(SNONE);
		g = new GraphM(filename.latin1(),rtw->getLabel()->Title(),range,SDATA,type,style,symbol,ptr,iwidth,iheight);
	}
	else {
		Style *style =new Style(cb2->currentItem(),color->color(), filled->isChecked(), fcolor->color(), 
			width->value(), pencb->currentItem(),brushcb->currentItem());
		style->setBoxWidth(boxwidth->value());
		style->setAutoBoxWidth(autobox->isChecked());
		style->setPointsSorting(sortpointscb->isChecked());
		Symbol *symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),
			ssize->value(),(FType)symbolfillcb->currentItem(),sfcolor->color(),
			sbrushcb->currentItem());
		g = new GraphM(filename.latin1(),rtw->getLabel()->Title(),range,SDATA,type,style,symbol,ptr,iwidth,iheight);
	}
	g->setReadAs(cbi->currentItem());
	g->setLabel(rtw->getLabel());
	mw->addGraphM(g,sheetcb->currentItem(),type);

	return 0;
}

// called from addData if image image is selected
int DataDialog::addDataIMAGEIMAGE(QImage image, QPixmap pm, QString filename) {
	kdDebug()<<"addDataIMAGEIMAGE()"<<endl;
	int width = image.width();
	int height = image.height();
	// create GRAPHIMAGE
	Style *style = new Style(0);
	Symbol *symbol = new Symbol(SNONE);

	LRange range[3];
	range[0] = LRange(0,width);
	range[1] = LRange(0,height);
	range[2] = LRange(0,1);		// TODO
	GraphIMAGE *g = new GraphIMAGE(filename.latin1(),rtw->getLabel()->Title(),range,SDATA,type,style,symbol,pm,width,height);
	g->setLabel(rtw->getLabel());
	g->setReadAs(cbi->currentItem());
	mw->addGraphIMAGE(g,sheetcb->currentItem());
	// TODO : is that correct ?
	//Plot *plot = p->getPlot(p->API());
	//plot->getLegend()->enable(false);	// disable legend
	// occupy space of legend for drawing area (bad hack :-\)
	//int xmax = (int)(p->width()*(plot->getSize().X()*plot->getP2().X()+plot->getPosition().X()));
	//plot->setXMax(xmax+(int)(120*plot->getSize().X()),p->width());

	return 0;
}

// called from addData if x-y is selected
int DataDialog::addDataXY(QIODevice *file,QTextStream *t, QDataStream *d, QString filename,int startRow, int endRow) {
	kdDebug()<<"DataDialog::addDataXY()"<<endl;
	FilterNETCDF ncf = FilterNETCDF(filename);
	FilterAUDIOFILE auf = FilterAUDIOFILE(filename);
	FilterCDF cdf = FilterCDF(filename);	
	
	int number = INC_VALUE;
	Point *ptr = (Point *) malloc(number*sizeof(Point));
	double x=0, y=0, xmin=0, xmax=1, ymin=0, ymax=1;
	int i=0;

	if (ncf.fileOK()) {		// netcdf file
		QString xname = readxle->text(), yname = readyle->text();
		
		QProgressDialog progress( i18n("Reading data ..."), i18n("Cancel"), ncf.VarLen(xname)-startRow, this,
			"progress", true );
		
		int len = ncf.VarLen(xname);
		if (len==0)
			len = ncf.VarLen(yname);

		for (i=startRow;i<len;i++) {
			if(i%1000 == 0) progress.setProgress(i);
			qApp->processEvents();
			
			double x=ncf.Data(xname,i), y=ncf.Data(yname,i);
			
			// index
			if ( readxle->text() == "0" )
				x=i+1-startRow;
			if ( readyle->text() == "0" )
				y=i+1-startRow;	
			
	// 						kdDebug()<<"x/y = "<<x<<' '<<y<<endl;

			if(!finite(x)) x=0;
			if(!finite(y)) y=0;
			
			// calculate range
			if (i == startRow) {
				xmin=xmax=x;ymin=ymax=y;
			}
			else {
				x<xmin?xmin=x:0;
				x>xmax?xmax=x:0;
				y<ymin?ymin=y:0;
				y>ymax?ymax=y:0;
			}
			
			if(i-startRow>=number) {
				number += INC_VALUE;
				ptr = (Point *) realloc(ptr,number*sizeof(Point));
			}
			ptr[i-startRow].setPoint(x,y);
			ptr[i-startRow].setMasked(false);
			
			if (i>endRow)
				break;
		}
	}
#ifdef HAVE_CDF
	else if (cdf.fileOK()) {		// cdf file
		QString xname = readxle->text(), yname = readyle->text();
		
		int len = cdf.VarLen(xname);
		if (len == 0)
			len = cdf.VarLen(yname);
		QProgressDialog progress( i18n("Reading data ..."), i18n("Cancel"), len-startRow, this,
			"progress", true );
		for (i=startRow;i<len;i++) {
			if(i%1000 == 0) progress.setProgress(i);
			qApp->processEvents();
			
			double x=cdf.Data(xname,i), y=cdf.Data(yname,i);
			
			// index
			if ( readxle->text() == "0" )
				x=i+1-startRow;
			if ( readyle->text() == "0" )
				y=i+1-startRow;	
				
		// 						kdDebug()<<"x/y = "<<x<<' '<<y<<endl;
			
			if(!finite(x)) x=0;
			if(!finite(y)) y=0;
			
			// calculate range
			if (i == startRow) {
				xmin=xmax=x;ymin=ymax=y;
			}
			else {
				x<xmin?xmin=x:0;
				x>xmax?xmax=x:0;
				y<ymin?ymin=y:0;
				y>ymax?ymax=y:0;
			}
			
			if(i-startRow>=number) {
				number += INC_VALUE;
				ptr = (Point *) realloc(ptr,number*sizeof(Point));
			}
			
			ptr[i-startRow].setPoint(x,y);
			ptr[i-startRow].setMasked(false);
			
			if (i>endRow)
				break;
		}
	}
#endif
	else if (auf.fileOK()) {		// audiofile file
		double *data = auf.Data();
		QProgressDialog progress(i18n("Reading data ..."), i18n("Cancel"), auf.frameCount()-startRow, this, "progress", true );
		for (i=startRow;i<auf.frameCount();i++) {
			if(i%1000 == 0) progress.setProgress(i);
			qApp->processEvents();
			
			double x=getValue(auf,1,i,data,startRow),y=getValue(auf,2,i,data,startRow);

			if(!finite(x)) x=0;
			if(!finite(y)) y=0;

			// calculate range
			if (i == startRow) {
				xmin=xmax=x;ymin=ymax=y;
			}
			else {
				x<xmin?xmin=x:0;
				x>xmax?xmax=x:0;
				y<ymin?ymin=y:0;
				y>ymax?ymax=y:0;
			}
			
			if(i-startRow>=number) {
				number += INC_VALUE;
				ptr = (Point *) realloc(ptr,number*sizeof(Point));
			}
			
			ptr[i-startRow].setPoint(x,y);
			ptr[i-startRow].setMasked(false);
			
			if (i>endRow)
				break;
		}
	}
	else {			// everything else
		QProgressDialog progress( i18n("Reading data ..."), i18n("Cancel"), file->size(), this, "progress", true );

		// read line data
		if(type == P2D && cbi->currentItem() == I2DLINE) {
			kdDebug()<<"LINE data"<<endl;
			QString line = t->readLine();
			while(i<startRow) {
				line = t->readLine();
				i++;
			}
			
			// simplifiy whitespaces
			if(simplifycb->isChecked())
				line = line.simplifyWhiteSpace();
			// ignore comment lines	
			if(line.startsWith(commcb->currentText()) == true)
				return 2;
			
			QString sep = sccb->currentText();
			QStringList oneline = splitLine(line,sep,emptycb->isChecked());

			// handle empty lines correct
			if(oneline.count()==0)
				return 2;

			for ( QStringList::Iterator it = oneline.begin(); it != oneline.end(); ++it ) {
				x = i-startRow+1;
				y = mw->formatLabel(*it,interpretycb->currentItem());
				
				if(!finite(y)) y=0;
			
				if (i == startRow) {
					xmin=xmax=x;
					ymin=ymax=y;
				}
				else {
					x<xmin?xmin=x:0;
					x>xmax?xmax=x:0;
					y<ymin?ymin=y:0;
					y>ymax?ymax=y:0;
				}
		//								kdDebug()<<"X/Y = "<<x<<' '<<y<<endl;
				
				if(i-startRow>=number) {
					number += INC_VALUE;
					ptr = (Point *) realloc(ptr,number*sizeof(Point));
				}
				
				ptr[(i++)-startRow].setPoint(x,y);
				ptr[(i-1)-startRow].setMasked(false);

				if (i>endRow)
					break;
				if ( progress.wasCancelled() )
				return 1;
			}
		}
		else {	// normal data (no line data)
			kdDebug()<<"no LINE data"<<endl;
			
			if(filtercb->currentItem() == FBINARY) {
				int nvars = varle->text().toInt();
				// skip values
				while(i<startRow) {
					for (int j=0;j<nvars;j++)
						getBinaryValue(d,binarytypecb->currentItem());
					i++;
				}
				
				while(!d->eof()) {
					if(i%1000 == 0) progress.setProgress(file->at() );
					qApp->processEvents();
					
					// read data
					double vx=0,vy;
					if(nvars==1)
						vx = i-startRow;
					else if (nvars==2)
						vx = getBinaryValue(d,binarytypecb->currentItem());

					vy = getBinaryValue(d,binarytypecb->currentItem());
					
					if(!finite(vx)) vx=0;
					if(!finite(vy)) vy=0;
				
					if (i == startRow) {
						xmin=xmax=vx;
						ymin=ymax=vy;
					}
					else {
						vx<xmin?xmin=vx:0;
						vx>xmax?xmax=vx:0;
						vy<ymin?ymin=vy:0;
						vy>ymax?ymax=vy:0;
					}
					
					if(i-startRow>=number) {
						number += INC_VALUE;
						ptr = (Point *) realloc(ptr,number*sizeof(Point));
					}
					
					ptr[(i++)-startRow].setPoint(vx,vy);
					ptr[(i-1)-startRow].setMasked(false);
				}
			}
			else {
				while (!t->eof()) {
					if(i%1000 == 0) progress.setProgress(file->at() );
					qApp->processEvents();
					QString line = t->readLine();

					while(i<startRow) {
						line = t->readLine();
						i++;
					}

					if(simplifycb->isChecked())
						line = line.simplifyWhiteSpace();
					// ignore comment lines	
					if(line.startsWith(commcb->currentText()) == true)
						continue;

					QString sep = sccb->currentText();
					QStringList oneline = splitLine(line,sep,emptycb->isChecked());

					// handle empty lines correct
					if(oneline.count()==0)
						continue;

					int j=1;
					for ( QStringList::Iterator it = oneline.begin(); it != oneline.end(); ++it ) {
						if (j == readxle->text().toInt())		// x
							x = mw->formatLabel(*it,interpretxcb->currentItem());
						if (j == readyle->text().toInt())		// y
							y = mw->formatLabel(*it,interpretycb->currentItem());
						j++;
					}
					if ( readxle->text().toInt() == 0 )
						x=i+1-startRow;
					if ( readyle->text().toInt() == 0 )
						y=i+1-startRow;

					if(!finite(x)) x=0;
					if(!finite(y)) y=0;

					if (i == startRow) {
						xmin=xmax=x;
						ymin=ymax=y;
					}
					else {
						x<xmin?xmin=x:0;
						x>xmax?xmax=x:0;
						y<ymin?ymin=y:0;
						y>ymax?ymax=y:0;
					}
					
					//kdDebug()<<"X/Y = "<<x<<' '<<y<<endl;
					
					if(i-startRow>=number) {
						number += INC_VALUE;
						ptr = (Point *) realloc(ptr,number*sizeof(Point));
					}
					ptr[(i++)-startRow].setPoint(x,y);
					ptr[(i-1)-startRow].setMasked(false);

					if (i>endRow)
						break;
					if ( progress.wasCancelled() )
					return 1;
				}
			}
		}
	}
	
	LRange range[2];
	range[0] = LRange(xmin,xmax);
	range[1] = LRange(ymin,ymax);

	Style *style = new Style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),width->value(),
		pencb->currentItem(),brushcb->currentItem());
	style->setBoxWidth(boxwidth->value());
	style->setAutoBoxWidth(autobox->isChecked());
	style->setPointsSorting(sortpointscb->isChecked());
	Symbol *symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->value(),
		(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
	Graph2D *g = new Graph2D(filename.latin1(),rtw->getLabel()->Title(),range,SDATA,type,style,symbol,ptr,i-startRow);
	g->setLabel(rtw->getLabel());
	
	AnnotateValues av(typecb->currentItem(),positioncb->currentItem(),distance->value());
	g->setAnnotateValues(av);
	g->setReadAs(cbi->currentItem());
	mw->addGraph2D(g,sheetcb->currentItem(),(PType) type);

	return 0;
}

// called from addData if x-y-z is selected
int DataDialog::addDataXYZ(QIODevice *file,QTextStream *t, QDataStream *d, QString filename,int startRow, int endRow) {
	kdDebug()<<"DataDialog::addDataXYZ()"<<endl;
	FilterNETCDF ncf = FilterNETCDF(filename);
	FilterAUDIOFILE auf = FilterAUDIOFILE(filename);
	FilterCDF cdf = FilterCDF(filename);	

	int number = INC_VALUE;
	Point3D *ptr = (Point3D *) malloc(number*sizeof(Point3D));
	double x=0, y=0, z=0, xmin=0, xmax=1, ymin=0, ymax=1, zmin=0, zmax=1;
	int i=0;

	if (ncf.fileOK()) {		// netcdf file
		QString xname = readxle->text(), yname = readyle->text(), zname = readzle->text();

		QProgressDialog progress( i18n("Reading data ..."), i18n("Cancel"),ncf.VarLen(xname)-startRow ,this, 
			"progress", true );

		int len = ncf.VarLen(xname);
		if (len==0)
			len = ncf.VarLen(yname);

		for (i=startRow;i<len;i++) {
			if (i%1000==0)progress.setProgress(i);
			qApp->processEvents();
			
			double x=ncf.Data(xname,i), y=ncf.Data(yname,i), z;
			if(type == P2D && (cbi->currentItem() == I2DXYPX))
				z=fabs(zname.toDouble()/100.0*x);
				else if (type == P2D && (cbi->currentItem() == I2DXYPY))
				z=fabs(zname.toDouble()/100.0*y);
			else
				z=ncf.Data(zname,i);
			
// 			kdDebug()<<"x/y/z = "<<x<<' '<<y<<' '<<z<<endl;
			// index
			if ( readxle->text() == "0" )
				x=i+1-startRow;
			if ( readyle->text() == "0" )
				y=i+1-startRow;	
			if ( readzle->text() == "0" )
				z=i+1-startRow;
			
			if(!finite(x)) x=0;
			if(!finite(y)) y=0;
			if(!finite(z)) z=0;
					
			// calculate range
			if (i == startRow) {
				xmin=xmax=x;ymin=ymax=y;zmin=zmax=z;
			}
			else {
				x<xmin?xmin=x:0;
				x>xmax?xmax=x:0;
				y<ymin?ymin=y:0;
				y>ymax?ymax=y:0;
				z<zmin?zmin=z:0;
				z>zmax?zmax=z:0;
			}

			if(i-startRow>=number) {
				number += INC_VALUE;
				ptr = (Point3D *) realloc(ptr,number*sizeof(Point3D));
			}
			ptr[i-startRow].setPoint(x,y,z);
			ptr[i-startRow].setMasked(false);
		
			if (i>endRow)
				break;
		}
	}
#ifdef HAVE_CDF
	else if (cdf.fileOK()) {		// cdf file
		QString xname = readxle->text(), yname = readyle->text(), zname = readzle->text();
		
		int len = cdf.VarLen(xname);
		if (len == 0)
			len = cdf.VarLen(yname);
		if (len == 0)
			len = cdf.VarLen(zname);
		QProgressDialog progress( i18n("Reading data ..."), i18n("Cancel"), len-startRow, this,"progress", true );
		for (i=startRow;i<len;i++) {
			if(i%1000 == 0) progress.setProgress(i);
			qApp->processEvents();
			
			double x=cdf.Data(xname,i), y=cdf.Data(yname,i), z;
			if(type == P2D && (cbi->currentItem() == I2DXYPX))
				z=fabs(zname.toDouble()/100.0*x);
			else if (type == P2D && (cbi->currentItem() == I2DXYPY))
				z=fabs(zname.toDouble()/100.0*y);
			else
				z=cdf.Data(zname,i);
			
			if(!finite(x)) x=0;
			if(!finite(y)) y=0;
			if(!finite(z)) z=0;
			
			// index
			if ( readxle->text() == "0" )
				x=i+1-startRow;
			if ( readyle->text() == "0" )
				y=i+1-startRow;	
			if ( readzle->text() == "0" )
				z=i+1-startRow;	
			
	// 						kdDebug()<<"x/y = "<<x<<' '<<y<<' '<<z<<endl;
			
			// calculate range
			if (i == startRow) {
				xmin=xmax=x;ymin=ymax=y;zmin=zmax=z;
			}
			else {
				x<xmin?xmin=x:0;
				x>xmax?xmax=x:0;
				y<ymin?ymin=y:0;
				y>ymax?ymax=y:0;
				z<zmin?zmin=z:0;
				z>zmax?zmax=z:0;
			}
			
			if(i-startRow>=number) {
				number += INC_VALUE;
				ptr = (Point3D *) realloc(ptr,number*sizeof(Point3D));
			}
			ptr[i-startRow].setPoint(x,y,z);
			ptr[i-startRow].setMasked(false);
			
			if (i>endRow)
				break;
		}
	}
#endif
	else if (auf.fileOK()) {		// audiofile file
		double *data = auf.Data();
		QProgressDialog progress( i18n("Reading data ..."), i18n("Cancel"),auf.frameCount()-startRow ,this, 
			"progress", true );
		for (i=startRow;i<auf.frameCount();i++) {
			if (i%1000==0)progress.setProgress(i);
			qApp->processEvents();

			double x=getValue(auf,1,i,data,startRow),y=getValue(auf,2,i,data,startRow),z;
			// %
			if(type == P2D && (cbi->currentItem() == I2DXYPX))
				z=fabs(readzle->text().toDouble()/100.0*x);
			else if (type == P2D && (cbi->currentItem() == I2DXYPY))
				z=fabs(readzle->text().toDouble()/100.0*y);
			else
				z=getValue(auf,3,i,data,startRow);

			if(!finite(x)) x=0;
			if(!finite(y)) y=0;
			if(!finite(z)) z=0;

			// calculate range
			if (i == startRow) {
				xmin=xmax=x;ymin=ymax=y,zmin=zmax=z;
			}
			else {
				x<xmin?xmin=x:0;
				x>xmax?xmax=x:0;
				y<ymin?ymin=y:0;
				y>ymax?ymax=y:0;
				z<zmin?zmin=z:0;
				z>zmax?zmax=z:0;
			}
			
			if(i-startRow>=number) {
				number += INC_VALUE;
				ptr = (Point3D *) realloc(ptr,number*sizeof(Point3D));
			}
			ptr[i-startRow].setPoint(x,y,z);
			ptr[i-startRow].setMasked(false);
			
			if (i>endRow)
				break;
		}
	}
	else {			// everything else
		QProgressDialog progress( i18n("Reading data ..."), i18n("Cancel"), file->size(),this, "progress", true );
			
		if(filtercb->currentItem() == FBINARY) {
			kdDebug()<<"	BINARY DATA"<<endl;
			int nvars = varle->text().toInt();
			// skip values
			while(i<startRow) {
				for (int j=0;j<nvars;j++)
					getBinaryValue(d,binarytypecb->currentItem());
				i++;
			}
					
			while(!d->eof()) {
				if(i%1000 == 0) progress.setProgress(file->at() );
				qApp->processEvents();
				
				// read data
				double vx,vy,vz;
				vx = getBinaryValue(d,binarytypecb->currentItem());
				vy = getBinaryValue(d,binarytypecb->currentItem());
				// %
				if(type == P2D && (cbi->currentItem() == I2DXYPX))
					vz=fabs(readzle->text().toDouble()/100.0*vx);
				else if (type == P2D && (cbi->currentItem() == I2DXYPY))
					vz=fabs(readzle->text().toDouble()/100.0*vy);
				else
					vz = getBinaryValue(d,binarytypecb->currentItem());
					
				if(!finite(vx)) vx=0;
				if(!finite(vy)) vy=0;
				if(!finite(vz)) vz=0;
			
				if (i == startRow) {
					xmin=xmax=vx;
					ymin=ymax=vy;
					zmin=zmax=vz;
				}
				else {
					vx<xmin?xmin=vx:0;
					vx>xmax?xmax=vx:0;
					vy<ymin?ymin=vy:0;
					vy>ymax?ymax=vy:0;
					vz<zmin?zmin=vz:0;
					vz>zmax?zmax=vz:0;
				}
			
				if(i-startRow>=number) {
					number += INC_VALUE;
					ptr = (Point3D *) realloc(ptr,number*sizeof(Point3D));
				}
				ptr[(i++)-startRow].setPoint(vx,vy,vz);
				ptr[(i-1)-startRow].setMasked(false);
			}
		}
		else {
			kdDebug()<<"	NORMAL DATA"<<endl;
			while (!t->eof()) {
				if (i%1000==0)progress.setProgress(file->at() );
				qApp->processEvents();
				QString line = t->readLine();

				while(i<startRow) {
					line = t->readLine();
					i++;
				}

				if(simplifycb->isChecked())
					line = line.simplifyWhiteSpace();
				// ignore comment lines
				if(line.startsWith(commcb->currentText()) == true)
					continue;
				
				QString sep = sccb->currentText();
				QStringList oneline = splitLine(line,sep,emptycb->isChecked());

				// handle empty lines correct
				if(oneline.count()==0)
					continue;

				int j=1;
				for ( QStringList::Iterator it = oneline.begin();
					it != oneline.end(); ++it ) {
					if (j == readxle->text().toInt())		// x
						x = mw->formatLabel(*it,interpretxcb->currentItem());
					if (j == readyle->text().toInt())		// y
						y = mw->formatLabel(*it,interpretycb->currentItem());
					// %
					if(type == P2D && (cbi->currentItem() == I2DXYPX))
						z=fabs(readzle->text().toDouble()/100.0*x);
					else if (type == P2D && (cbi->currentItem() == I2DXYPY))
						z=fabs(readzle->text().toDouble()/100.0*y);
					else
						if (j == readzle->text().toInt())		// z
							z = mw->formatLabel(*it,interpretzcb->currentItem());
					j++;
				}
	
				if(!finite(x)) x=0;
				if(!finite(y)) y=0;
				if(!finite(z)) z=0;
			
				if ( readxle->text().toInt() == 0 )
					x=i+1-startRow;
				if ( readyle->text().toInt() == 0 )
					y=i+1-startRow;
				if ( readzle->text().toInt() == 0 )
					z=i+1-startRow;

				if (i == startRow) {
					if (type == PTERNARY) {
						xmin=0;
						xmax=x+y+z;
					}
					else
						xmin=xmax=x;	
					ymin=ymax=y;
					zmin=zmax=z;
				}
				else {
					if (type != PTERNARY) {
						x<xmin?xmin=x:0;
						x>xmax?xmax=x:0;
					}
					y<ymin?ymin=y:0;
					y>ymax?ymax=y:0;
					z<zmin?zmin=z:0;
					z>zmax?zmax=z:0;
				}

				kdDebug()<<"X/Y/Z = "<<x<<' '<<y<<' '<<z<<endl;

				if(i-startRow>=number) {
					number += INC_VALUE;
					ptr = (Point3D *) realloc(ptr,number*sizeof(Point3D));
				}
				ptr[(i++)-startRow].setPoint(x,y,z);
				ptr[(i-1)-startRow].setMasked(false);

				if (i>endRow)
					break;
				if ( progress.wasCancelled() )
					return 1;
			}
		}
	}

	LRange range[3];
	range[0] = LRange(xmin,xmax);
	range[1] = LRange(ymin,ymax);
	range[2] = LRange(zmin,zmax);

	Style *style=0;
	Symbol *symbol=0;
	int rows=i-startRow, cols=1;
	if(type == P2D) {
		style = new Style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
			width->value(),pencb->currentItem(),brushcb->currentItem());
		style->setBoxWidth(boxwidth->value());
		style->setAutoBoxWidth(autobox->isChecked());
		style->setPointsSorting(sortpointscb->isChecked());
		symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->value(),
			(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());	
	}
	else if (type == PSURFACE || type == PQWT3D || type == P3D) {
		kdDebug()<<"	surface/qwt /3d plot"<<endl;
		// calculate dimension
		
		int i=0;
		for(int i=0;i<rows;i++) {
			if(ptr[i].X()>ptr[i+1].X() || ptr[i].Y()>ptr[i+1].Y() ) {
				cols=i+1;
				break;
			}
		}
		rows /= cols;

		// if unclear : ask for dimensions
		if(rows <= 1 || cols <= 1) {
			bool ok;
			int res = QInputDialog::getInteger(i18n("Surface plot from X-Y-Z"),
				i18n("Please specify dimension in X direction : "),rows,2,rows/2,1,&ok);
			if(ok)
				rows=res;
			else
				return -1;
			cols = (i-startRow)/rows;
		}
	}
	kdDebug()<<"	rows/cols = "<<rows<<'/'<<cols<<endl;

	Graph3D *g = new Graph3D(filename.latin1(),rtw->getLabel()->Title(),range,SDATA,type,style,symbol,ptr,rows,cols);
	g->setLabel(rtw->getLabel());
	if(type != PSURFACE) {
		AnnotateValues av(typecb->currentItem(),positioncb->currentItem(),distance->value());
		g->setAnnotateValues(av);
	}
	g->setReadAs(cbi->currentItem());
	mw->addGraph3D(g,sheetcb->currentItem(),type);

	return 0;
}

// called from addData if x-y-z-t is selected
int DataDialog::addDataXYZT(QIODevice *file,QTextStream *t, QDataStream *d, QString filename,int startRow, int endRow) {
	kdDebug()<<"DataDialog::addDataXYZT()"<<endl;
	FilterNETCDF ncf = FilterNETCDF(filename);
	FilterAUDIOFILE auf = FilterAUDIOFILE(filename);
	FilterCDF cdf = FilterCDF(filename);
	
	int number = INC_VALUE;
	
	Point4D *ptr = (Point4D *) malloc(number*sizeof(Point4D));
	double x=0, y=0, z=0, tt=0, xmin=0, xmax=1, ymin=0, ymax=1, zmin=0, zmax=1, tmin=0, tmax=1;
	int i=0;

	if (ncf.fileOK()) {		// netcdf file
		QString xname = readxle->text(), yname = readyle->text(), zname = readzle->text(),
			tname = readtle->text();
		QProgressDialog progress( i18n("Reading data ..."), i18n("Cancel"),ncf.VarLen(xname)-startRow ,this, 
			"progress", true );

		int len = ncf.VarLen(xname);
		if(len==0)
			len = ncf.VarLen(yname);

		for (i=startRow;i<len;i++) {
			if (i%1000==0)progress.setProgress(i);
			qApp->processEvents();

			double x=ncf.Data(xname,i), y=ncf.Data(yname,i), z=ncf.Data(zname,i),
				tt=ncf.Data(tname,i);
			
	// 						kdDebug()<<"x/y/z/t = "<<x<<' '<<y<<' '<<z<<' '<<tt<<endl;
			// index
			if ( readxle->text() == "0" )
				x=i+1-startRow;
			if ( readyle->text() == "0" )
				y=i+1-startRow;	
			if ( readzle->text() == "0" )
				z=i+1-startRow;	
			if ( readtle->text() == "0" )
				tt=i+1-startRow;	

			if(!finite(x)) x=0;
			if(!finite(y)) y=0;
			if(!finite(z)) z=0;
			if(!finite(tt)) tt=0;

			// calculate range
			if (i == startRow) {
				xmin=xmax=x;ymin=ymax=y;zmin=zmax=z,tmin=tmax=tt;
			}
			else {
				x<xmin?xmin=x:0;
				x>xmax?xmax=x:0;
				y<ymin?ymin=y:0;
				y>ymax?ymax=y:0;
				z<zmin?zmin=z:0;
				z>zmax?zmax=z:0;
				tt<tmin?tmin=tt:0;
				tt>tmax?tmax=tt:0;
			}

			if(i-startRow>=number) {
				number += INC_VALUE;
				ptr = (Point4D *) realloc(ptr,number*sizeof(Point4D));
			}
			ptr[i-startRow].setPoint(x,y,z,tt);
			ptr[i-startRow].setMasked(false);

			if (i>endRow)
				break;
		}
	}
#ifdef HAVE_CDF
	else if (cdf.fileOK()) {		// cdf file
		QString xname = readxle->text(), yname = readyle->text(), zname = readzle->text(),
			tname = readtle->text();
		
		int len = cdf.VarLen(xname);
		if (len == 0)
			len = cdf.VarLen(yname);
		if (len == 0)
			len = cdf.VarLen(zname);
		if (len == 0)
			len = cdf.VarLen(tname);
		QProgressDialog progress( i18n("Reading data ..."), i18n("Cancel"), len-startRow, this,
			"progress", true );
		for (i=startRow;i<len;i++) {
			if(i%1000 == 0) progress.setProgress(i);
			qApp->processEvents();

			double x=cdf.Data(xname,i), y=cdf.Data(yname,i),z=cdf.Data(zname,i),
				t= cdf.Data(tname,i);

			if(!finite(x)) x=0;
			if(!finite(y)) y=0;
			if(!finite(z)) z=0;
			if(!finite(t)) t=0;
			
			// index
			if ( readxle->text() == "0" )
				x=i+1-startRow;
			if ( readyle->text() == "0" )
				y=i+1-startRow;	
			if ( readzle->text() == "0" )
				z=i+1-startRow;	
			if ( readtle->text() == "0" )
				t=i+1-startRow;	

	// 						kdDebug()<<"x/y = "<<x<<' '<<y<<' '<<z<<' '<<t<<endl;

			// calculate range
			if (i == startRow) {
				xmin=xmax=x;ymin=ymax=y;zmin=zmax=z;tmin=tmax=t;
			}
			else {
				x<xmin?xmin=x:0;
				x>xmax?xmax=x:0;
				y<ymin?ymin=y:0;
				y>ymax?ymax=y:0;
				z<zmin?zmin=z:0;
				z>zmax?zmax=z:0;
				t<tmin?tmin=t:0;
				t>tmax?tmax=t:0;
			}
			
			if(i-startRow>=number) {
				number += INC_VALUE;
				ptr = (Point4D *) realloc(ptr,number*sizeof(Point4D));
			}
			ptr[i-startRow].setPoint(x,y,z,t);
			ptr[i-startRow].setMasked(false);
			
			if (i>endRow)
				break;
		}
	}
#endif
	else if (auf.fileOK()) {		// audiofile file
		double *data = auf.Data();
		QProgressDialog progress( i18n("Reading data ..."), i18n("Cancel"),auf.frameCount()-startRow ,this, 
			"progress", true );
		for (i=startRow;i<auf.frameCount();i++) {
			if (i%1000==0)progress.setProgress(i);
			qApp->processEvents();

			double x=getValue(auf,1,i,data,startRow), y=getValue(auf,2,i,data,startRow), 
				z=getValue(auf,3,i,data,startRow),t=getValue(auf,4,i,data,startRow);

			if(!finite(x)) x=0;
			if(!finite(y)) y=0;
			if(!finite(z)) z=0;
			if(!finite(t)) t=0;

			// calculate range
			if (i == startRow) {
				xmin=xmax=x;ymin=ymax=y,zmin=zmax=z,tmax=tmin=t;
			}
			else {
				x<xmin?xmin=x:0;
				x>xmax?xmax=x:0;
				y<ymin?ymin=y:0;
				y>ymax?ymax=y:0;
				z<zmin?zmin=z:0;
				z>zmax?zmax=z:0;
				t<tmin?tmin=t:0;
				t>tmax?tmax=t:0;
			}

			if(i-startRow>=number) {
				number += INC_VALUE;
				ptr = (Point4D *) realloc(ptr,number*sizeof(Point4D));
			}
			ptr[i-startRow].setPoint(x,y,z,t);
			ptr[i-startRow].setMasked(false);

			if (i>endRow)
				break;
		}
	}
	else {			// everything else
		QProgressDialog progress( i18n("Reading data ..."), i18n("Cancel"), file->size(),this, "progress", true );
		
		if(filtercb->currentItem() == FBINARY) {
			kdDebug()<<"reading BINARY DATA"<<endl;		
			int nvars = varle->text().toInt();
			// skip values
			while(i<startRow) {
				for(int j=0;j<nvars;j++)
					getBinaryValue(d,binarytypecb->currentItem());
				i++;
			}
			
			while(!d->eof()) {
				if(i%1000 == 0) progress.setProgress(file->at() );
				qApp->processEvents();

				// read data
				double vx=0,vy,vz,vt;
				if(nvars == 3)
					vx = i+1-startRow;	
				else if(nvars==4)
					vx = getBinaryValue(d,binarytypecb->currentItem());
				
				vy = getBinaryValue(d,binarytypecb->currentItem());
				vz = getBinaryValue(d,binarytypecb->currentItem());
				vt = getBinaryValue(d,binarytypecb->currentItem());
					
				if(!finite(vx)) vx=0;
				if(!finite(vy)) vy=0;
				if(!finite(vz)) vz=0;
				if(!finite(vt)) vt=0;
			
				if (i == startRow) {
					xmin=xmax=vx;
					ymin=ymax=vy;
					zmin=zmax=vz;
					tmin=tmax=vt;
				}
				else {
					vx<xmin?xmin=vx:0;
					vx>xmax?xmax=vx:0;
					vy<ymin?ymin=vy:0;
					vy>ymax?ymax=vy:0;
					vz<zmin?zmin=vz:0;
					vz>zmax?zmax=vz:0;
					tt<tmin?tmin=tt:0;
					tt>tmax?tmax=tt:0;
				}
				
				if(i-startRow>=number) {
					number += INC_VALUE;
					ptr = (Point4D *) realloc(ptr,number*sizeof(Point4D));
				}
				ptr[(i++)-startRow].setPoint(vx,vy,vz,tt);
				ptr[(i-1)-startRow].setMasked(false);
			}
		}
		else {
			while (!t->eof()) {
				if (i%1000==0)progress.setProgress(file->at() );
				qApp->processEvents();
				QString line = t->readLine();

				while(i<startRow) {
					line = t->readLine();
					i++;
				}

				if(simplifycb->isChecked())
					line = line.simplifyWhiteSpace();
				// ignore comment lines
				if(line.startsWith(commcb->currentText()) == true)
					continue;
				
				QString sep = sccb->currentText();
				QStringList oneline = splitLine(line,sep,emptycb->isChecked());

				// handle empty lines correct
				if(oneline.count()==0)
					continue;

				int j=1;
				for ( QStringList::Iterator it = oneline.begin();
					it != oneline.end(); ++it ) {
					if (j == readxle->text().toInt())		// x
						x = mw->formatLabel(*it,interpretxcb->currentItem());
					if (j == readyle->text().toInt())		// y
						y = mw->formatLabel(*it,interpretycb->currentItem());
					if (j == readzle->text().toInt())		// z
						z = mw->formatLabel(*it,interpretzcb->currentItem());
					if (j == readtle->text().toInt())		// t
						tt = mw->formatLabel(*it,interprettcb->currentItem());
					j++;
				}

				if(!finite(x)) x=0;
				if(!finite(y)) y=0;
				if(!finite(z)) z=0;
				if(!finite(tt)) tt=0;
			
				if ( readxle->text().toInt() == 0 )
					x=i+1-startRow;
				if ( readyle->text().toInt() == 0 )
					y=i+1-startRow;
				if ( readzle->text().toInt() == 0 )
					z=i+1-startRow;
				if ( readtle->text().toInt() == 0 )
					tt=i+1-startRow;

				if (i == startRow) {
					xmin=xmax=x;
					ymin=ymax=y;
					zmin=zmax=z;
					tmin=tmax=tt;
				}
				else {
					x<xmin?xmin=x:0;
					x>xmax?xmax=x:0;
					y<ymin?ymin=y:0;
					y>ymax?ymax=y:0;
					z<zmin?zmin=z:0;
					z>zmax?zmax=z:0;
					tt<tmin?tmin=tt:0;
					tt>tmax?tmax=tt:0;
				}

				//kdDebug()<<"X/Y/Z = "<<x<<' '<<y<<' '<<z<<endl;
			
				if(i-startRow>=number) {
					number += INC_VALUE;
					ptr = (Point4D *) realloc(ptr,number*sizeof(Point4D));
				}
				ptr[(i++)-startRow].setPoint(x,y,z,tt);
				ptr[(i-1)-startRow].setMasked(false);

				if (i>endRow)
					break;
				if ( progress.wasCancelled() )
					return 1;
			}
		}
	}

	LRange range[4];
	range[0] = LRange(xmin,xmax);
	range[1] = LRange(ymin,ymax);
	range[2] = LRange(zmin,zmax);
	range[3] = LRange(tmin,tmax);

	Style *style = new Style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
		width->value(),pencb->currentItem(),brushcb->currentItem());
	style->setBoxWidth(boxwidth->value());
	style->setAutoBoxWidth(autobox->isChecked());
	style->setPointsSorting(sortpointscb->isChecked());
	Symbol *symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->value(),
		(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());

	Graph4D *g = new Graph4D(filename.latin1(),rtw->getLabel()->Title(),range, SDATA,
		type,style,symbol,ptr,i-startRow,cbi->currentItem()-2);
	g->setLabel(rtw->getLabel());
	g->setReadAs(cbi->currentItem());
	mw->addGraph4D(g,sheetcb->currentItem());

	return 0;
}

// called from addData if matrix is selected
int DataDialog::addDataMATRIX(QIODevice *file,QTextStream *t, QDataStream *d, QString filename, int startRow, int endRow) {
	kdDebug()<<"DataDialog::addDataMATRIX()"<<endl;
	FilterNETCDF ncf = FilterNETCDF(filename);
	FilterAUDIOFILE auf = FilterAUDIOFILE(filename);
	FilterCDF cdf = FilterCDF(filename);
	
	int number = INC_VALUE;
	double *ptr = (double *) malloc(number*sizeof(double));
	QString line;
	int i=0, numberx=0;
	double zmin=0,zmax=1;

	// TODO : read netcdf/cdf/audio data as matrix
	if (ncf.fileOK()) {		// netcdf file
/*		QString xname = readxle->text(), yname = readyle->text(), zname = readzle->text();
		QProgressDialog progress( i18n("Reading data ..."), i18n("Cancel"),ncf.getVarLen(xname)-startRow ,this, 
			"progress", true );

		for (i=startRow;i<ncf.getVarLen(xname);i++) {
			if (i%1000==0)progress.setProgress(i);
			qApp->processEvents();
			int x=ncf.getData(xname,i), y=ncf.getData(yname,i), z=ncf.getData(zname,i);
			
				kdDebug()<<"x/y/z = "<<x<<' '<<y<<' '<<z<<endl;
				// index
				if ( readxle->text() == "0" )
					x=i+1-startRow;
				if ( readyle->text() == "0" )
					y=i+1-startRow;	
				if ( readzle->text() == "0" )
					z=i+1-startRow;	
			
				if(!finite(x)) x=0;
				if(!finite(y)) y=0;
				if(!finite(z)) z=0;
			
				// calculate range
				if (i == startRow) {
					xmin=xmax=x;ymin=ymax=y;zmin=zmax=z;
				}
				else {
					x<xmin?xmin=x:0;
					x>xmax?xmax=x:0;
					y<ymin?ymin=y:0;
					y>ymax?ymax=y:0;
					z<zmin?zmin=z:0;
					z>zmax?zmax=z:0;
				}
			
				if(i-startRow>=number) {
					number += INC_VALUE;
					ptr = (double *) realloc(ptr,number*sizeof(double));
				}
				ptr[i-startRow].setPoint(x,y,z);
		
				if (i>endRow)
					break;
			}
		}*/
	}
	else {			// everything else
		QProgressDialog progress( i18n("Reading data ..."), i18n("Cancel"), file->size(),this, "progress", true );
		if(filtercb->currentItem() == FBINARY) {
			// skip values
			while(i<startRow) {
				getBinaryValue(d,binarytypecb->currentItem());
				i++;
			}
			
			while(!d->eof() && i<endRow) {
				if(i%1000 == 0) progress.setProgress(file->at() );
				qApp->processEvents();
				
				// read data for one line
				numberx=varle->text().toInt();
				for (int j=0;j<numberx;j++) {
					double z = getBinaryValue(d,binarytypecb->currentItem());
					
					if(!finite(z)) z=0;
					
					if (i == startRow) {
						zmin=zmax=z;
					}
					else {
						z<zmin?zmin=z:0;
						z>zmax?zmax=z:0;
					}
				
					if(j+numberx*i-startRow>=number) {
						number += INC_VALUE;
						ptr = (double *) realloc(ptr,number*sizeof(double));
					}
					ptr[j+numberx*i-startRow]=z;
				}
				i++;
			}
		}
		else {
			while (!t->eof()) {
				//kdDebug()<<"Reading line "<<i<<endl;
				if(i%1000 == 0)progress.setProgress(file->at() );
				qApp->processEvents();
				line = t->readLine();
				if(simplifycb->isChecked())
					line = line.simplifyWhiteSpace();
				// ignore comment lines
				if(line.startsWith(commcb->currentText()) == true)
					continue;
				
				QString sep = sccb->currentText();
				QStringList oneline = splitLine(line,sep,emptycb->isChecked());
				
				numberx=oneline.count();

				// handle empty lines correct
				if(oneline.count()==0)
					continue;

			/*kdDebug()<<"line "<<i<<endl;
			for (int j=0;j<numberx;j++) {
				kdDebug()<<" ("<<line.section(' ',j,j)<<")"<<endl;
			}
			kdDebug()<<endl;
			*/
				int j=0;
				for ( QStringList::Iterator it = oneline.begin(); it != oneline.end(); ++it ) {
					double z =  (*it).toDouble();

					if (!finite(z)) z=0;

					if (j==0 && i==0) {
						zmin=zmax=z;
					}
					else {
						z<zmin?zmin=z:0;
						z>zmax?zmax=z:0;
					}

					if(j+numberx*i>=number) {
						number += INC_VALUE;
						ptr = (double *) realloc(ptr,number*sizeof(double));
					}
					ptr[j+numberx*i]=z;
					//kdDebug()<<"ptr["<<j+numberx*i<<"] = "<<z<<endl;
					j++;
				}

				i++;
				if ( progress.wasCancelled() )
					return 1;
			}
		}
	}
	
	LRange range[3];
	range[0] = LRange(0,numberx);
	range[1] = LRange(0,i);
	range[2] = LRange(zmin,zmax);

	GraphM *g;

	if (type == PSURFACE) {
		Style *style = new Style(0);
		Symbol *symbol = new Symbol(SNONE);
		g = new GraphM(filename.latin1(),rtw->getLabel()->Title(),range, SDATA, type,style,symbol,ptr,numberx,i);
	}
	else {
		Style *style = new Style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
			width->value(),pencb->currentItem(),brushcb->currentItem());
		style->setBoxWidth(boxwidth->value());
		style->setAutoBoxWidth(autobox->isChecked());
		style->setPointsSorting(sortpointscb->isChecked());
		Symbol *symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),
			ssize->value(),(FType)symbolfillcb->currentItem(),sfcolor->color(),
			sbrushcb->currentItem());
		g = new GraphM(filename.latin1(),rtw->getLabel()->Title(),range, SDATA, type,style,symbol,ptr,numberx,i);
	}
	g->setLabel(rtw->getLabel());
	g->setReadAs(cbi->currentItem());
	mw->addGraphM(g,sheetcb->currentItem(),type);

	return 0;
}

//! read data file
int DataDialog::addData() {
	kdDebug()<<"DataDialog:addData()"<<endl;
	if(graph != 0)
		p->getPlot(p->API())->getGraphList()->delGraph(item);

	QString label = rtw->getLabel()->Title();
	int mode = cbi->currentItem();
	
	QStringList fns = QStringList::split(";",filele->text());
	 for ( QStringList::Iterator it = fns.begin(); it != fns.end(); ++it ) {
		QString filename = *it;

		if (!filename.isEmpty()) {
			QIODevice *file = KFilterDev::deviceForFile(filename,QString::null,true);
			if(file==0) file = new QFile(filename);
	
			FilterMAGICK mf = FilterMAGICK(filename);
			// reading image
			QString format;
			// not with binary data
#ifdef HAVE_MAGICK
			if ((filtercb->currentItem() != FBINARY) && 
				(((format = QString(QImageIO::imageFormat(filename))) != 0 ) || mf.fileOK())) {
#else
			if ((filtercb->currentItem() != FBINARY) && (format = QString(QImageIO::imageFormat(filename))) != 0) {
#endif
				QPixmap pm;
#ifdef HAVE_MAGICK
// makes problems
				if(mf.fileOK())
					pm = mf.Pixmap();
				else
#endif
					pm.load(filename);

				QImage image = pm.convertToImage();
				kdDebug() <<" Format : "<<format<<endl;
				kdDebug() <<" Depth : "<<image.depth()<<endl;
	
				int res;
				if (type == P2D || type == PPIE || type == PPOLAR ) {
					res = addDataIMAGEXY(image,filename);
				}
				else if ( (type == P2D && mode == I2DXYDY) || (type == P3D && mode == I3DXYZ) 
					|| type == PTERNARY || (type == PQWT3D && mode == IQWTXYZ)) {
					res = addDataIMAGEXYZ(image,filename);
				}
				else if ((type == PSURFACE && mode == ISMATRIX) || (type == P3D && mode == I3DMATRIX)) {
					res = addDataIMAGEMATRIX(image,filename);
				}
				else if (type == PSURFACE && mode == ISIMAGE) {
					res = addDataIMAGEIMAGE(image,pm,filename);
				}
				else if (type == P2D && (mode == I2DXYDXDY || mode == I2DXYDYDY)) { // x-y-dx-dy or x-y-dy1-dy2
					// TODO : from image ???
				}
			}
			else if ( file->open( IO_ReadOnly )) {		// normal data (not image)
				QTextStream t(file);
				QDataStream d(file);
				
				int startRow = startle->text().toInt()-1;
				int endRow;
				if(endle->text() == i18n("END"))
					endRow = INF;
				else
					endRow = endle->text().toInt()-1;
	
				kdDebug()<<"STARTROW = "<<startRow<<endl;

				QFileInfo info(filename);		// for ending of file
				FilterNETCDF ncf = FilterNETCDF(filename);
				FilterAUDIOFILE auf = FilterAUDIOFILE(filename);
				FilterCDF cdf = FilterCDF(filename);
	
				int res=0;
				if ( (type == P2D && (mode == I2DXY || mode == I2DLINE ) ) || type == PPIE  || type == PPOLAR) {
					res = addDataXY(file,&t,&d,filename,startRow,endRow);
				}
				else if (  (type == P2D && (mode == I2DXYDY || mode == I2DXYPX || mode == I2DXYPY )) || 
					(type == PSURFACE && mode == ISXYZ) || (type == P3D && mode == I3DXYZ) || 
					type == PTERNARY || (type == PQWT3D && mode == IQWTXYZ)) {
					res = addDataXYZ(file,&t,&d,filename,startRow,endRow);
				}
				else if (type == PSURFACE || (type == P3D && mode == I3DMATRIX) || 
					(type == PQWT3D && mode == IQWTMATRIX )) {
					res = addDataMATRIX(file,&t,&d,filename,startRow,endRow);
				}
				else if (type == P2D) { // x-y-dx-dy or x-y-dy1-dy2
					res = addDataXYZT(file,&t,&d,filename,startRow,endRow);
				}

				if(res==1) return 1;
				if (res==2) continue;
	
				if (l) l->updateList();
				file->close();
			}
			else {
				KMessageBox::error(this, i18n("Sorry. Could not open specified data file for reading!"));
				return 2;
			}
		}
	}

	return 0;
}

// get audio value from line edits
double DataDialog::getValue(FilterAUDIOFILE auf, int var, int i, double *data, int startRow) {
	int index=0;
	switch (var) {
	case 1:	index = readxle->text().toInt();break;
	case 2:	index = readyle->text().toInt();break;
	case 3:	index = readzle->text().toInt();break;
	case 4:	index = readtle->text().toInt();break;
	}
	
	double value=0;
	switch(index) {
	case 0:	// index
		value=i+1-startRow;break;
	case 1:	// time
		value=i/auf.sampleRate();break;
	case 2:	// channel 1
		switch(auf.channelCount()) {
		case 1:
			value=data[i]; break;
		case 2:
			value=data[2*i];break;
		}
		break;
	case 3:	// channel 2
		if(auf.channelCount()==2)
			value=data[2*i+1];
		break;
	}
	
	return value;
}
