//LabPlot : OverlayPlotDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfontdialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include "OverlayPlotDialog.h"

OverlayPlotDialog::OverlayPlotDialog(MainWin *mw, const char *name)
	: PlotDialog(mw, name)
{
	setCaption(i18n("Overlay Plots"));
	KConfig *config = mw->Config();
	config->setGroup( "Overlay" );

	//TODO : i and j
	QHBox* hb = new QHBox(vbox);
	new QLabel(i18n("Overlay Plot "),hb);
	ani = new KIntNumInput(config->readNumEntry("Set1",2),hb);
	ani->setRange(1,p->NrPlots(),1,false);
	new QLabel(i18n(" onto Plot "),hb);
	bni = new KIntNumInput(config->readNumEntry("Set2",1),hb);
	bni->setRange(1,p->NrPlots(),1,false);

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void OverlayPlotDialog::saveSettings() {
	KConfig *config = mw->Config();
	config->setGroup( "Overlay" );

	config->writeEntry("Set1", ani->value());
	config->writeEntry("Set2", bni->value());
}

void OverlayPlotDialog::apply_clicked() {
	int a = ani->value()-1;
	int b = bni->value()-1;
	Plot *plota = p->getPlot(a);
	Plot *plotb = p->getPlot(b);

	int nr = p->NrPlots();
	if(a<0 || b<0)
		KMessageBox::error(this, i18n("Sorry. Thats not possible!"));
	else if (a > nr || b > nr)
		KMessageBox::error(this, i18n("Sorry. This Plot doesnt exist!"));
	else {
		plota->setTransparent(true);
		plota->setPosition(plotb->Position());
		plota->setSize(plotb->Size());
		plota->setP1(plotb->P1());
		plota->setP2(plotb->P2());
	}
	
	p->updatePixmap();
}
