// LabPlot : PlotPie.cc

#include <iostream>
#include <klocale.h>
#include <kdebug.h>
#include "PlotPie.h"

#include "colors.h"

using namespace std;

//! general pie Plot class
PlotPie::PlotPie(Worksheet *p)
	: Plot(p)
{
	title = new Label(i18n("Pie Plot"),p->getMainWin()->defaultFont(),QColor(Qt::black));
	title->setPosition(0.4,0.04);

	// set default axis settings for all axes
	readAxisSettings(&axis,PPIE);

	// axis
	axis.setScaling(100);
	axis.setTickLabelSuffix(" %");
	axis.setTickLabelFont(QFont( QString("Adobe Times"), 14));
	
	p2.setPoint(.85,.85);
}

QStringList PlotPie::Info() {
	QStringList s;
	s<<"Pie";
	s<<QString::number(position.X())+QString(" , ")+QString::number(position.Y());
	s<<QString::number(size.X())+QString(" X ")+QString::number(size.Y());
	if (transparent)
		s<<QString("yes");
	else
		s<<QString("no");
	s<<bgcolor.name();
	s<<gbgcolor.name();

	return s;
}

void PlotPie::draw(QPainter *p, int w, int h) {
	//int w = worksheet->width(), h = worksheet->height();

	// TODO : check this
	if(aspect_enabled) {	// set aspect ratio to 1
		int wsize = (int) fmin(w,h);
		w=h=wsize;
	}
		
	kdDebug()<<"PlotPie::draw() w/h : "<<w<<' '<<h<<endl;
	int xmin = (int)(w*(size.X()*p1.X()+position.X()));
	int xmax = (int)(w*(size.X()*p2.X()+position.X()));
	int ymin = (int)(h*(size.Y()*p1.Y()+position.Y()));
	int ymax = (int)(h*(size.Y()*p2.Y()+position.Y()));

	// 3d perspective
//	xmax -= (xmax-xmin)/3;
//	ymin += (ymax-ymin)/3;

	kdDebug()<<"XMIN/MXAX/YMIN/YMAX = "<<xmin<<','<<xmax<<','<<ymin<<','<<ymax<<endl;
	kdDebug()<<"p1 = "<<p1.X()<<'/'<<p1.Y()<<" p2 = "<<p2.X()<<'/'<<p2.Y()<<endl;

	if (!transparent) {
		// background color
		p->setBrush(bgcolor);
		p->setPen(Qt::NoPen);
		p->drawRect((int)(w*position.X()),(int)(h*position.Y()),(int)(w*size.X()),(int)(h*size.Y()));

		// graph background color
		p->setBrush(gbgcolor);
		p->setPen(Qt::NoPen);
	}

	kdDebug()<<"PlotPie : title->draw() pos:"<<position.X()<<' '<<position.Y()<<endl;
	kdDebug()<<" 			size:"<<size.X()<<' '<<size.Y()<<endl;
	title->draw(worksheet,p,position,size,w,h,0);

	drawCurves(p, w, h);

	if(legend.Enabled())
		legend.draw(p,type,graphlist,position,size,w,h);

	p->setPen(Qt::NoPen);
}


void PlotPie::drawCurves(QPainter *p, int w, int h) {
	kdDebug()<<"PlotPie::drawCurves()"<<endl;
	int xmin = (int)(w*(size.X()*p1.X()+position.X()));
	int xmax = (int)(w*(size.X()*p2.X()+position.X()));
	int ymin = (int)(h*(size.Y()*p1.Y()+position.Y()));
	int ymax = (int)(h*(size.Y()*p2.Y()+position.Y()));

	// space for legend
//	xmax -=(int)(120*size.X());

	kdDebug()<<"xmin/xmax ymin/ymax : "<<xmin<<'/'<<xmax<<' '<<ymin<<'/'<<ymax<<endl;
	kdDebug()<<"width/height : "<<w<<'/'<<h<<endl;
		
	// TODO : only one graph allowed
	if(graphlist->getGraph(0)->isShown() == false)
		return;

	int N=0;
	Style *style;
	Symbol *symbol;
	GRAPHType st = graphlist->getStruct(0);
	Point *d=0;
	PointL *dl=0;
	if (st == GRAPH2D) {
		Graph2D *g = graphlist->getGraph2D(0);

		d = g->Data();
		N = g->Number();
		style =  g->getStyle();
		symbol = g->getSymbol();
		
		kdDebug()<<"GRAPH2D / 2D number = "<<N<<endl;
	}
	else if (st == GRAPHL) {
		GraphL *g = graphlist->getGraphL(0);

		dl = g->Data();
		N = g->Number();
		style =  g->getStyle();
		symbol = g->getSymbol();
		
		kdDebug()<<"GRAPHL / number = "<<N<<endl;
	}

	// TODO : use style
	p->setPen(Qt::black);

	double sum=0;
	if(st == GRAPH2D) 
		for (int i=0;i<N;i++)
			sum += d[i].Y();
	else if(st == GRAPHL)
		for (int i=0;i<N;i++)
			sum += dl[i].V();
	
	int prec = axis.TickLabelPrecision();
	double scaling = axis.Scaling();
	QString prefix = axis.TickLabelPrefix();
	QString suffix = axis.TickLabelSuffix();
	int pos = axis.TickLabelPosition();
	QFont f = axis.TickLabelFont();
	f.setPointSize((int)(0.7*f.pointSize()));
	f.setPointSize((int)(f.pointSize()*size.X()));	// resize tic label

//	p->drawRect(xmin,ymin,xmax-xmin,ymax-ymin);
//	p->drawEllipse(xmin-20-pos/2.0,ymin-20-pos/2.0,(xmax-xmin)+40+pos,(ymax-ymin)+40+pos);

	double c=0;
	for (int i=0;i<N;i++) {
		if((st == GRAPH2D && d[i].Masked()) || (st == GRAPHL && dl[i].Masked()))
			continue;

		double part=0;
		if(st == GRAPH2D) 
			part = d[i].Y();
		else if(st == GRAPHL)
			part = dl[i].V();
		if(sum>1.0)
			part /= sum;

		// angle
		double alpha = 5.0*c/80.0 + part*180.0;
		kdDebug()<<" alpha = "<<alpha<<endl;
		// TODO : rotation

		p->setFont(f);
		QFontMetrics fm = p->fontMetrics();

		p->setPen(axis.TickLabelColor());
		// TODO : Format

		if (st == GRAPHL) {
			QString s = prefix+dl[i].L()+suffix;
			p->drawText((int)(cos(alpha*M_PI/180.0)*(xmax-xmin+40+pos)/2.0 + (xmax+xmin)/2.0 - fm.width(s)/2.0),
				(int)(- sin(alpha*M_PI/180.0)*(ymax-ymin+40+pos)/2.0 + (ymax+ymin)/2.0 + fm.height()/2.0), s);
		}
		else if (st == GRAPH2D) {
			QString s = prefix+QString::number(part*scaling,'f',prec)+suffix;
			p->drawText((int)(cos(alpha*M_PI/180.0)*(xmax-xmin+40+pos)/2.0 + (xmax+xmin)/2.0 - fm.width(s)/2.0),
				(int)(- sin(alpha*M_PI/180.0)*(ymax-ymin+40+pos)/2.0 + (ymax+ymin)/2.0 + fm.height()/2.0), s);
		}

		p->setPen(Qt::black);
		p->setBrush(colortable[i%15+1]);
		part *= 16*360;
		p->drawPie(xmin, ymin, xmax-xmin, ymax-ymin, (int)c, (int)part);

		c += part;
	}
	kdDebug()<<"PlotPie::drawCurves() OK"<<endl;
	
	//TODO : make legend from all points ?
}

void PlotPie::saveAxes(QTextStream *t) {
	saveAxis(t,&axis);
}

void PlotPie::openAxes(QTextStream *t, int version) {
	if(version>23)
		openAxis(t,version, &axis);
}

void PlotPie::saveXML(QDomDocument doc,QDomElement plottag) {
	QDomElement tag = axis.saveXML(doc,0);
   	plottag.appendChild( tag );
}

void PlotPie::openXML(QDomElement e) {
	if(e.tagName() == "Axis")
		axis.openXML(e.firstChild());
}
